/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.splunkcompute;

import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.splunkcompute.SplunkComparator;
import com.splunk.df.search.compute.splunkcompute.SplunkKVRecord;
import com.splunk.df.search.compute.splunkcompute.SplunkRecord;

public class SearchResultComparator
implements SplunkComparator {
    private final SearchResult.FieldMeta[] sortFields;
    private final int[] sortOrders;

    SearchResultComparator(SearchResult.FieldMeta[] sortFields, boolean[] isAscs) {
        this.sortFields = sortFields;
        int len = isAscs.length;
        this.sortOrders = new int[len];
        for (int i = 0; i < len; ++i) {
            boolean sortDirection = isAscs[i];
            this.sortOrders[i] = sortDirection ? 1 : -1;
        }
    }

    @Override
    public int compare(SplunkRecord lhsSr, SplunkRecord rhsSr) {
        SplunkKVRecord lhsKvsr = (SplunkKVRecord)lhsSr;
        SplunkKVRecord rhsKvsr = (SplunkKVRecord)rhsSr;
        SearchResult lhs = lhsKvsr.getKey();
        SearchResult rhs = rhsKvsr.getKey();
        int len = this.sortFields.length;
        for (int i = 0; i < len; ++i) {
            int ret;
            SearchResult.FieldMeta fieldName = this.sortFields[i];
            int ordering = this.sortOrders[i];
            Object lhsVal = lhs.getFieldValue(fieldName);
            Object rhsVal = rhs.getFieldValue(fieldName);
            if (lhsVal == null && rhsVal == null) continue;
            if (lhsVal != null && rhsVal == null) {
                return 1 * ordering;
            }
            if (lhsVal == null && rhsVal != null) {
                return -1 * ordering;
            }
            if (lhsVal == null || rhsVal == null || (ret = SearchResultFactory.getInstance().compareTo(lhsVal, rhsVal)) == 0) continue;
            return ret * ordering;
        }
        Long lhsSeed = lhs.seed();
        Long rhsSeed = rhs.seed();
        if (lhsSeed != null && rhsSeed != null) {
            return lhsSeed.compareTo(rhsSeed);
        }
        return 0;
    }
}

