/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.splunkcompute;

import com.splunk.commons.ast.nodes.IOrdering;
import com.splunk.commons.ast.nodes.commands.DedupCommand;
import com.splunk.commons.ast.nodes.commands.JoinCommand;
import com.splunk.commons.ast.nodes.commands.SortCommand;
import com.splunk.commons.ast.nodes.commands.UnionCommand;
import com.splunk.commons.ast.nodes.expressions.FieldType;
import com.splunk.df.search.compute.Actor;
import com.splunk.df.search.compute.ComputeEngine;
import com.splunk.df.search.compute.ComputeEngineContext;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.Exploder;
import com.splunk.df.search.compute.Filter;
import com.splunk.df.search.compute.MapPartitioner;
import com.splunk.df.search.compute.Mapper;
import com.splunk.df.search.compute.Reducer;
import com.splunk.df.search.compute.Reporter;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultComparator;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.SplunkConfExtractor;
import com.splunk.df.search.compute.objects._Long;
import com.splunk.df.search.compute.sdk.Pair;
import com.splunk.df.search.compute.splunkcompute.HashPartitioner;
import com.splunk.df.search.compute.splunkcompute.MapPartitionFunction;
import com.splunk.df.search.compute.splunkcompute.PartitionedDataset;
import com.splunk.df.search.compute.splunkcompute.PartitionedDatasetFactory;
import com.splunk.df.search.compute.splunkcompute.SplunkComparator;
import com.splunk.df.search.compute.splunkcompute.SplunkComputeConstants;
import com.splunk.df.search.compute.splunkcompute.SplunkKVRecord;
import com.splunk.df.search.compute.splunkcompute.SplunkRecord;
import com.splunk.df.search.compute.splunkcompute.SplunkReducer;
import com.splunk.df.search.compute.transformers.FieldExtractor;
import com.splunk.df.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;
import scala.Tuple2;

public class SplunkComputeDataset
implements DistributedDataset,
SplunkComputeConstants {
    static final Logger logger = Logger.getLogger(SplunkComputeDataset.class);
    private final PartitionedDataset pd;
    private final ComputeEngine engine;
    private final HashSet<SearchResult.FieldMeta> reducedByFields;
    private FieldExtractor.ExtractionHint fieldExtractionHint;
    private final DistributedDataset sriDd;
    private ComputeEngineContext ctx;
    private final String lowLatencyScratch;
    private final int numCores;
    private static final int DEFAULT_SPLUNK_COMPUTE_CORE_BOOST = 1;
    private static final String DFS_SPLUNK_COMPUTE_CORE_BOOST = "DFS_SPLUNK_COMPUTE_CORE_BOOST";

    SplunkComputeDataset(ComputeEngine engine, ComputeEngineContext ctx) {
        this.engine = engine;
        this.ctx = ctx;
        this.numCores = (Integer)ctx.get("numCores");
        this.lowLatencyScratch = System.getProperty("low.latency.computation.scratch.directory");
        if (this.lowLatencyScratch == null) {
            throw new RuntimeException("splunk low latency compute's scratch directory not set!");
        }
        logger.info((Object)String.format("splunk low latency compute dataset created with scratch dir: %s, and num cores: %d", this.lowLatencyScratch, this.numCores));
        this.pd = PartitionedDatasetFactory.getInstance().getNewPartitionedDataset(this.lowLatencyScratch, this.numCores * SplunkComputeDataset.getCoreBoost(), "SplunkComputeDataset");
        this.reducedByFields = new HashSet();
        this.fieldExtractionHint = FieldExtractor.ExtractionHint.UNKNOWN;
        this.sriDd = null;
    }

    private static int getCoreBoost() {
        int boost = 1;
        String boostStr = System.getenv(DFS_SPLUNK_COMPUTE_CORE_BOOST);
        if (boostStr != null && !boostStr.trim().isEmpty()) {
            try {
                boost = Integer.valueOf(boostStr);
                logger.info((Object)String.format("splunk compute core boost set to %d using envvar", boost));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse %s to int splunk compute core boost", boostStr));
            }
        }
        logger.info((Object)String.format("splunk compute core boost set at: %d", boost));
        return boost;
    }

    SplunkComputeDataset(ComputeEngine engine, ComputeEngineContext ctx, PartitionedDataset pd, HashSet<SearchResult.FieldMeta> reducedByFields, FieldExtractor.ExtractionHint fieldExtractionHint, DistributedDataset sriDd, String lowLatencyScratch, int numCores) {
        this.engine = engine;
        this.ctx = ctx;
        this.pd = pd;
        this.reducedByFields = reducedByFields;
        this.fieldExtractionHint = fieldExtractionHint;
        this.sriDd = sriDd;
        this.lowLatencyScratch = lowLatencyScratch;
        this.numCores = numCores;
    }

    @Override
    public Iterator<SearchResult> retrieve() {
        final Iterator<SplunkRecord> recs = this.pd.iterator(Long.MAX_VALUE);
        return new Iterator<SearchResult>(){

            @Override
            public boolean hasNext() {
                return recs.hasNext();
            }

            @Override
            public SearchResult next() {
                return ((SplunkRecord)recs.next()).getVal();
            }
        };
    }

    @Override
    public List<SearchResult> retrieve(int numSrs) {
        ArrayList<SearchResult> ret = new ArrayList<SearchResult>();
        Iterator<SplunkRecord> results = this.pd.iterator(numSrs);
        while (results.hasNext()) {
            ret.add(results.next().getVal());
        }
        return ret;
    }

    @Override
    public DistributedDataset transform(final Mapper mapper) {
        PartitionedDataset transformed = this.pd.mapPartitions(new MapPartitionFunction(){

            @Override
            public Iterator<SplunkRecord> call(int partitionId, final Iterator<SplunkRecord> srs) {
                return new Iterator<SplunkRecord>(){

                    @Override
                    public boolean hasNext() {
                        return srs.hasNext();
                    }

                    @Override
                    public SplunkRecord next() {
                        SplunkRecord sr = (SplunkRecord)srs.next();
                        SearchResult ret = mapper.map(sr.getVal());
                        return new SplunkRecord(ret);
                    }
                };
            }

            @Override
            public String desc() {
                return Utils.toString(new Throwable("generic mapper lambda for transformers"));
            }
        }, "genericMapped");
        return new SplunkComputeDataset(this.engine, this.ctx, transformed, this.reducedByFields, mapper.fieldExtractionHint(), this.sriDd, this.lowLatencyScratch, this.numCores);
    }

    private Iterator<SearchResult> convert1(final Iterator<SplunkRecord> recs) {
        return new Iterator<SearchResult>(){

            @Override
            public boolean hasNext() {
                return recs.hasNext();
            }

            @Override
            public SearchResult next() {
                return ((SplunkRecord)recs.next()).getVal();
            }
        };
    }

    private Iterator<SplunkRecord> convert2(final Iterator<SearchResult> srs) {
        return new Iterator<SplunkRecord>(){

            @Override
            public boolean hasNext() {
                return srs.hasNext();
            }

            @Override
            public SplunkRecord next() {
                return new SplunkRecord((SearchResult)srs.next());
            }
        };
    }

    @Override
    public DistributedDataset transform(final MapPartitioner mapPartitioner) {
        String desc = mapPartitioner.desc();
        if (desc == null) {
            desc = "noname";
        }
        PartitionedDataset transformed = this.pd.mapPartitions(new MapPartitionFunction(){

            @Override
            public Iterator<SplunkRecord> call(int partitionId, Iterator<SplunkRecord> srs) {
                return SplunkComputeDataset.this.convert2(mapPartitioner.mapPartitions(partitionId, SplunkComputeDataset.this.convert1(srs)));
            }

            @Override
            public String desc() {
                return Utils.toString(new Throwable("generic map partitioner lambda for transformers"));
            }
        }, String.format("%s_%s", desc, "genericMapPartitioned"));
        return new SplunkComputeDataset(this.engine, this.ctx, transformed, this.reducedByFields, mapPartitioner.fieldExtractionHint(), this.sriDd, this.lowLatencyScratch, this.numCores);
    }

    @Override
    public DistributedDataset transform(final MapPartitioner mapPartitioner, final int parid) {
        PartitionedDataset transformed = this.pd.mapPartitions(new MapPartitionFunction(){

            @Override
            public Iterator<SplunkRecord> call(int partitionId, Iterator<SplunkRecord> srs) {
                if (parid != partitionId) {
                    return new ArrayList().iterator();
                }
                return SplunkComputeDataset.this.convert2(mapPartitioner.mapPartitions(partitionId, SplunkComputeDataset.this.convert1(srs)));
            }

            @Override
            public String desc() {
                return Utils.toString(new Throwable("generic map partitioner with par id for transformers"));
            }
        }, "genericMapPartitionedById");
        return new SplunkComputeDataset(this.engine, this.ctx, transformed, this.reducedByFields, mapPartitioner.fieldExtractionHint(), this.sriDd, this.lowLatencyScratch, this.numCores);
    }

    @Override
    public DistributedDataset transform(final Exploder exploder) {
        PartitionedDataset transformed = this.pd.mapPartitions(new MapPartitionFunction(){

            @Override
            public Iterator<SplunkRecord> call(int partitionId, final Iterator<SplunkRecord> srs) {
                return new Iterator<SplunkRecord>(){
                    Iterator<SplunkRecord> lastExplosion;

                    @Override
                    public boolean hasNext() {
                        if (this.lastExplosion != null && this.lastExplosion.hasNext()) {
                            return true;
                        }
                        if (!srs.hasNext()) {
                            return false;
                        }
                        while (srs.hasNext()) {
                            SearchResult nextSr = ((SplunkRecord)srs.next()).getVal();
                            this.lastExplosion = SplunkComputeDataset.this.convert2(exploder.explode(nextSr));
                            if (!this.lastExplosion.hasNext()) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public SplunkRecord next() {
                        return this.lastExplosion.next();
                    }
                };
            }

            @Override
            public String desc() {
                return Utils.toString(new Throwable("generic exploder lambda for transformers"));
            }
        }, "genericExploded");
        return new SplunkComputeDataset(this.engine, this.ctx, transformed, this.reducedByFields, exploder.fieldExtractionHint(), this.sriDd, this.lowLatencyScratch, this.numCores);
    }

    private PartitionedDataset getDataset() {
        return this.pd;
    }

    @Override
    public DistributedDataset transform(final Reducer reducer) {
        PartitionedDataset metadataKvpd;
        SplunkComputeDataset scd = this;
        if (reducer.limitResultset()) {
            HashMap<SearchResult.FieldMeta, Object> context = SplunkConfExtractor.extract(this.ctx);
            int limit = Integer.parseInt(context.get(LIST_MAX_SIZE).toString());
            scd = (SplunkComputeDataset)scd.limit(limit);
            logger.info((Object)String.format("Input dataset has been limited: %d", limit));
        }
        PartitionedDataset pd = scd.getDataset();
        String sid = (String)this.ctx.get("sid");
        final HashMap<SearchResult.FieldMeta, _Long> executionContext = new HashMap<SearchResult.FieldMeta, _Long>();
        HashSet<SearchResult.FieldMeta> reducedByFields = reducer.reduceByFields();
        logger.info((Object)String.format("sdd stats: reduce by fields: %s", reducedByFields.toString()));
        PartitionedDataset kvpd = pd.mapPartitions(new MapPartitionFunction(){

            @Override
            public Iterator<SplunkRecord> call(int partitionId, Iterator<SplunkRecord> srs) {
                HashMap<SearchResult, SearchResult> srKvsTbl = new HashMap<SearchResult, SearchResult>(100);
                while (srs.hasNext()) {
                    SearchResult sr = srs.next().getVal();
                    SearchResult.SRContext parCtx = sr.getContext();
                    List<Pair<SearchResult, SearchResult>> pairs = reducer.splits(sr);
                    int size = pairs.size();
                    for (int i = 0; i < size; ++i) {
                        SearchResult key;
                        Pair<SearchResult, SearchResult> pair = pairs.get(i);
                        if (parCtx != null) {
                            parCtx.addSrsInPartition();
                        }
                        if ((key = pair.first()) == null) continue;
                        SearchResult val = pair.second();
                        SearchResult calcVal = (SearchResult)srKvsTbl.get(key);
                        if (calcVal == null) {
                            srKvsTbl.put(key, val);
                            continue;
                        }
                        srKvsTbl.put(key, reducer.reduce(calcVal, val));
                    }
                }
                ArrayList<SplunkKVRecord> retArr = new ArrayList<SplunkKVRecord>(srKvsTbl.size());
                for (Map.Entry kv : srKvsTbl.entrySet()) {
                    retArr.add(new SplunkKVRecord((SearchResult)kv.getKey(), (SearchResult)kv.getValue()));
                }
                return retArr.iterator();
            }

            @Override
            public String desc() {
                return Utils.toString(new Throwable("concurrent volume reduction lambda"));
            }
        }, "volumeReduced");
        int numPars = kvpd.numPartitions();
        logger.info((Object)String.format("num pars in volume reduced dataset: %d", numPars));
        if (reducer.postJoin()) {
            double boost = Utils.getPartitionBoostPostJoin();
            boost = Math.max(1.0, boost);
            numPars = (int)((double)numPars * boost);
            numPars = Math.max(numPars, 1);
            logger.info((Object)String.format("reduce partition boosted to: %d since this is post join processing", numPars));
        }
        kvpd = kvpd.partitionBy(new HashPartitioner(numPars));
        PartitionedDataset reducedKvpd = kvpd.reduceByKey(new SplunkReducer(){

            @Override
            public SearchResult reduce(SearchResult lhs, SearchResult rhs) {
                return reducer.reduce(lhs, rhs);
            }
        }, "reduced", true);
        if (reducer.downReduce()) {
            reducedKvpd = reducedKvpd.mapPartitions(new MapPartitionFunction(){

                @Override
                public Iterator<SplunkRecord> call(int partitionId, final Iterator<SplunkRecord> kvSrs) {
                    return new Iterator<SplunkRecord>(){

                        @Override
                        public boolean hasNext() {
                            return kvSrs.hasNext();
                        }

                        @Override
                        public SplunkRecord next() {
                            SplunkKVRecord kvSr = (SplunkKVRecord)kvSrs.next();
                            SearchResult keySr = kvSr.getKey();
                            SearchResult valSr = kvSr.getVal();
                            return new SplunkKVRecord(reducer.downProcess(keySr, valSr));
                        }
                    };
                }

                @Override
                public String desc() {
                    return Utils.toString(new Throwable("down reduction lambda"));
                }
            }, "preparedForDownReduce");
            reducedKvpd = reducedKvpd.reduceByKey(new SplunkReducer(){

                @Override
                public SearchResult reduce(SearchResult lhs, SearchResult rhs) {
                    return reducer.reduce(lhs, rhs);
                }
            }, "downReduced", false);
            logger.info((Object)String.format("updated dag to trigger down reduce computation for non group by cases", new Object[0]));
        }
        if (reducer.metadataRequired() && !(metadataKvpd = reducedKvpd.mapPartitions(new MapPartitionFunction(){

            @Override
            public Iterator<SplunkRecord> call(int partitionId, final Iterator<SplunkRecord> kvSrs) {
                return new Iterator<SplunkRecord>(){
                    Iterator<Tuple2<SearchResult.FieldMeta, SearchResult>> lastMetadata;

                    @Override
                    public boolean hasNext() {
                        if (this.lastMetadata != null && this.lastMetadata.hasNext()) {
                            return true;
                        }
                        while (kvSrs.hasNext()) {
                            SplunkKVRecord kvSr = (SplunkKVRecord)kvSrs.next();
                            this.lastMetadata = reducer.gatherMetadataOnReducedData(kvSr.getKey(), kvSr.getVal());
                            if (!this.lastMetadata.hasNext()) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public SplunkRecord next() {
                        Tuple2<SearchResult.FieldMeta, SearchResult> metaRec = this.lastMetadata.next();
                        SearchResult key = SearchResultFactory.getInstance().createSearchResult((SearchResult.FieldMeta)metaRec._1(), "dummy_value_for_metadata_rec");
                        SearchResult val = (SearchResult)metaRec._2();
                        return new SplunkKVRecord(key, val);
                    }
                };
            }

            @Override
            public String desc() {
                return Utils.toString(new Throwable("reduction metadata calculation lambda"));
            }
        }, "prepForMetadataCalculation")).isEmpty()) {
            PartitionedDataset finalizedMetadataKvpd = metadataKvpd.reduceByKey(new SplunkReducer(){

                @Override
                public SearchResult reduce(SearchResult lhs, SearchResult rhs) {
                    return reducer.finalizeMetadata(lhs, rhs);
                }
            }, "metadataReduced", false);
            Iterator<SplunkRecord> metadataList = finalizedMetadataKvpd.iterator(Long.MAX_VALUE);
            while (metadataList.hasNext()) {
                SplunkKVRecord mdTuple = (SplunkKVRecord)metadataList.next();
                SearchResult.FieldMeta key = mdTuple.getKey().getFieldNames()[0];
                Object value = mdTuple.getVal().getFieldValue(key);
                logger.info((Object)("Metadata Key=" + key + ", Value=" + value));
                if (value instanceof Long) {
                    executionContext.put(key, new _Long((long)((Long)value)));
                    continue;
                }
                logger.warn((Object)"Entry has not been added into the execution context");
            }
        }
        logger.debug((Object)("ExecutionContext:::" + executionContext));
        logger.info((Object)String.format("sdd reduce: applied reduce operation: sid: %s", sid));
        pd = reducedKvpd.mapPartitions(new MapPartitionFunction(){

            @Override
            public Iterator<SplunkRecord> call(int partitionId, final Iterator<SplunkRecord> kvSrs) {
                return new Iterator<SplunkRecord>(){

                    @Override
                    public boolean hasNext() {
                        return kvSrs.hasNext();
                    }

                    @Override
                    public SplunkRecord next() {
                        SplunkKVRecord kvSr = (SplunkKVRecord)kvSrs.next();
                        return new SplunkRecord(reducer.merge(kvSr.getKey(), kvSr.getVal(), executionContext));
                    }
                };
            }

            @Override
            public String desc() {
                return Utils.toString(new Throwable("kv record to value record merge lambda"));
            }
        }, "mergedPostReduce");
        return new SplunkComputeDataset(this.engine, this.ctx, pd, reducedByFields, FieldExtractor.ExtractionHint.NOT_PRECOMPUTED, this.sriDd, this.lowLatencyScratch, this.numCores);
    }

    @Override
    public DistributedDataset transform(final Filter filter) {
        PartitionedDataset transformed = this.pd.mapPartitions(new MapPartitionFunction(){

            @Override
            public Iterator<SplunkRecord> call(int partitionId, final Iterator<SplunkRecord> srs) {
                return new Iterator<SplunkRecord>(){
                    SplunkRecord sr;

                    @Override
                    public boolean hasNext() {
                        if (this.sr != null) {
                            return true;
                        }
                        while (srs.hasNext()) {
                            SplunkRecord rec = (SplunkRecord)srs.next();
                            SearchResult sr = rec.getVal();
                            if (!filter.accept(sr)) continue;
                            this.sr = rec;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public SplunkRecord next() {
                        return this.sr;
                    }
                };
            }

            @Override
            public String desc() {
                return Utils.toString(new Throwable("filter lambda"));
            }
        }, "filtered");
        return new SplunkComputeDataset(this.engine, this.ctx, transformed, this.reducedByFields, filter.fieldExtractionHint(), this.sriDd, this.lowLatencyScratch, this.numCores);
    }

    private DistributedDataset _sort(IOrdering[] sortFields, SortCommand sortCmd, int headImposedLimit, String lowLatencyScratchDir, int numCores) {
        PartitionedDataset sorted;
        IOrdering[] fields = sortFields;
        final SearchResult.FieldMeta[] fieldsMeta = new SearchResult.FieldMeta[fields.length];
        int len = fieldsMeta.length;
        for (int i = 0; i < len; ++i) {
            fieldsMeta[i] = SearchResult.FieldMeta.newFieldMeta(fields[i].getField().getFieldName());
        }
        long count = 0L;
        if (sortCmd != null) {
            fields = sortCmd.getBy();
            count = sortCmd.getCount();
        }
        if (headImposedLimit > 0) {
            long tempCount = count;
            count = count == 0L ? (long)headImposedLimit : Math.min(count, (long)headImposedLimit);
            logger.info((Object)String.format("sdd sort: count updated from: %d to head imposed limit: %d", tempCount, count));
        }
        logger.info((Object)String.format("Sort by fields: %s", Utils.printByFields(sortFields)));
        final int maxSeed = (int)Utils.getMaxSortSeed();
        logger.info((Object)String.format("will use max sort seed: %d", maxSeed));
        final IOrdering[] tempFields = fields;
        PartitionedDataset preparedForSort = this.pd.mapPartitions(new MapPartitionFunction(){

            @Override
            public Iterator<SplunkRecord> call(int partitionId, final Iterator<SplunkRecord> srs) {
                return new Iterator<SplunkRecord>(){

                    @Override
                    public boolean hasNext() {
                        return srs.hasNext();
                    }

                    @Override
                    public SplunkRecord next() {
                        SplunkRecord rec = (SplunkRecord)srs.next();
                        SearchResult sr = rec.getVal();
                        int len = tempFields.length;
                        SearchResult.FieldMeta[] fieldNames = new SearchResult.FieldMeta[len];
                        Object[] fieldValues = new Object[len];
                        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> key = new SearchResult.SRHashMap<SearchResult.FieldMeta, Object>(len * 2);
                        for (int i = 0; i < len; ++i) {
                            IOrdering field = tempFields[i];
                            SearchResult.FieldMeta fieldName = fieldsMeta[i];
                            Object val = sr.getFieldValue(fieldName);
                            if (val == null) {
                                val = new SearchResultFactory.NullField(false);
                            }
                            FieldType fieldType = field.getFieldType();
                            val = SearchResultFactory.getInstance().convertValue(val, fieldType);
                            key.put(fieldName, val);
                            fieldNames[i] = fieldName;
                            fieldValues[i] = val;
                        }
                        SearchResult keySr = SearchResultFactory.getInstance().createSearchResult(key, fieldNames, fieldValues);
                        if (maxSeed > 0) {
                            keySr.setSeed(new Random().nextInt(maxSeed));
                        }
                        return new SplunkKVRecord(keySr, sr);
                    }
                };
            }

            @Override
            public String desc() {
                return Utils.toString(new Throwable("preparation for sort lambda"));
            }
        }, "prepForSortProcessing");
        final SearchResultComparator comp = new SearchResultComparator(fields);
        PartitionedDataset ret = sorted = preparedForSort.sortByKey(new SplunkComparator(){

            @Override
            public int compare(SplunkRecord lhs, SplunkRecord rhs) {
                SplunkKVRecord lhsKv = (SplunkKVRecord)lhs;
                SplunkKVRecord rhsKv = (SplunkKVRecord)rhs;
                return comp.compare(lhsKv.getKey(), rhsKv.getKey());
            }
        }, "actualSorted");
        if (count > 0L) {
            count = Math.min(Utils.getMaxLimitRecords(), count);
            logger.info((Object)String.format("sort has been invoked with record limits: %d", count));
            long start = System.currentTimeMillis();
            final Iterator<SplunkRecord> results = sorted.retrieve(count).iterator();
            logger.info((Object)String.format("executed sorted dag to get the end results, time taken: %d millis", System.currentTimeMillis() - start));
            ret = PartitionedDatasetFactory.getInstance().getNewPartitionedDataset(lowLatencyScratchDir, numCores, "sortedAndRetrieved");
            ret = ret.repartition(1);
            ret = ret.mapPartitions(new MapPartitionFunction(){

                @Override
                public Iterator<SplunkRecord> call(int partitionId, Iterator<SplunkRecord> srs) {
                    return results;
                }

                @Override
                public String desc() {
                    return Utils.toString(new Throwable("sort results limiting lambda"));
                }
            }, "limitProcessingPostSort", true);
            logger.info((Object)String.format("curtailed sort to: %d records and distributed back to workers", count));
        }
        return new SplunkComputeDataset(this.engine, this.ctx, ret, this.reducedByFields, this.fieldExtractionHint, this.sriDd, this.lowLatencyScratch, numCores);
    }

    @Override
    public DistributedDataset sort(SortCommand sortCmd, int headImposedLimit) {
        return this._sort(sortCmd.getBy(), sortCmd, headImposedLimit, this.lowLatencyScratch, this.numCores);
    }

    @Override
    public DistributedDataset sort(IOrdering[] fields) {
        return this._sort(fields, null, -1, this.lowLatencyScratch, this.numCores);
    }

    @Override
    public long count() {
        return this.pd.count();
    }

    @Override
    public DistributedDataset cacheMem() {
        return this;
    }

    @Override
    public DistributedDataset repartition(int pars) {
        return new SplunkComputeDataset(this.engine, this.ctx, this.pd.repartition(pars), this.reducedByFields, this.fieldExtractionHint, this.sriDd, this.lowLatencyScratch, this.numCores);
    }

    @Override
    public DistributedDataset reverse() {
        throw new RuntimeException("splunk compute dataset: unsupported transformation - reverse");
    }

    @Override
    public DistributedDataset last(long n) {
        throw new RuntimeException("splunk compute dataset: unsupported transformation - last");
    }

    @Override
    public DistributedDataset limit(long n) {
        long max = Utils.getMaxLimitRecords();
        if (n <= 0L || n > max) {
            long tempN = n;
            n = max;
            logger.warn((Object)String.format("sdd limit: set limit records to: %d since input limit: %d is not valid", n, tempN));
        }
        final List<SplunkRecord> srsList = this.pd.retrieve(n);
        logger.info((Object)String.format("sdd limit: fetched %d records from dataset based on limit n (or count of records whichever is lower), number of records in list: %d", n, srsList.size()));
        PartitionedDataset ret = this.pd;
        ret = ret.repartition(1);
        ret = ret.mapPartitions(new MapPartitionFunction(){

            @Override
            public Iterator<SplunkRecord> call(int partitionId, Iterator<SplunkRecord> srs) {
                return srsList.iterator();
            }

            @Override
            public String desc() {
                return Utils.toString(new Throwable("limit lambda"));
            }
        }, "limitProcessed", this.pd.isOrdered());
        return new SplunkComputeDataset(this.engine, this.ctx, ret, this.reducedByFields, this.fieldExtractionHint, this.sriDd, this.lowLatencyScratch, this.numCores);
    }

    @Override
    public DistributedDataset join(DistributedDataset rhs, JoinCommand jcmd, boolean lhsRepartition, boolean rhsRepartition) {
        throw new RuntimeException("splunk compute dataset: join not supported");
    }

    @Override
    public int partitions() {
        return this.pd.numPartitions();
    }

    @Override
    public FieldExtractor.ExtractionHint fieldExtractionHint() {
        return this.fieldExtractionHint;
    }

    @Override
    public DistributedDataset transform(final Reporter reporter) {
        PartitionedDataset ret = this.pd.mapPartitions(new MapPartitionFunction(){

            @Override
            public Iterator<SplunkRecord> call(int partitionId, Iterator<SplunkRecord> srs) {
                while (srs.hasNext()) {
                    reporter.report(partitionId, srs.next().getVal());
                }
                return new ArrayList().iterator();
            }

            @Override
            public String desc() {
                return Utils.toString(new Throwable("reporting lambda"));
            }
        }, "reported");
        return new SplunkComputeDataset(this.engine, this.ctx, ret, this.reducedByFields, this.fieldExtractionHint, this.sriDd, this.lowLatencyScratch, this.numCores);
    }

    @Override
    public DistributedDataset resetSearchResults(List<SearchResult> srs, int numPars) {
        PartitionedDataset ret = ((SplunkComputeDataset)this.engine.emptyDataset()).getDataset();
        final HashMap<Integer, ArrayList<SplunkRecord>> splits = new HashMap<Integer, ArrayList<SplunkRecord>>();
        Iterator<SearchResult> srsIter = srs.iterator();
        int parId = 0;
        while (srsIter.hasNext()) {
            SearchResult sr = srsIter.next();
            ArrayList<SplunkRecord> bucket = (ArrayList<SplunkRecord>)splits.get(parId);
            if (bucket == null) {
                bucket = new ArrayList<SplunkRecord>();
                splits.put(parId, bucket);
            }
            bucket.add(new SplunkRecord(sr));
            if (!srsIter.hasNext() || ++parId < numPars) continue;
            parId = 0;
        }
        ret = ret.repartition(numPars);
        ret = ret.mapPartitions(new MapPartitionFunction(){

            @Override
            public Iterator<SplunkRecord> call(int partitionId, Iterator<SplunkRecord> srs) {
                ArrayList bucket = (ArrayList)splits.get(partitionId);
                if (bucket == null) {
                    return new ArrayList().iterator();
                }
                return bucket.iterator();
            }

            @Override
            public String desc() {
                return Utils.toString(new Throwable("list to partitioned distribution lambda"));
            }
        }, "listToPartitionDistributed");
        return new SplunkComputeDataset(this.engine, this.ctx, ret, new HashSet<SearchResult.FieldMeta>(), this.fieldExtractionHint, this.sriDd, this.lowLatencyScratch, this.numCores);
    }

    @Override
    public HashSet<SearchResult.FieldMeta> getReducedByFields() {
        return this.reducedByFields;
    }

    @Override
    public DistributedDataset union(List<DistributedDataset> ds, UnionCommand ucmd, boolean streaming) {
        throw new RuntimeException("splunk compute dataset: union not supported");
    }

    @Override
    public DistributedDataset customUnion(UnionCommand ucmd) {
        throw new RuntimeException("splunk compute dataset: union not supported");
    }

    @Override
    public DistributedDataset empty(FieldExtractor.ExtractionHint fieldExtractionHint) {
        PartitionedDataset ret = (PartitionedDataset)((Object)this.engine.emptyDataset());
        return new SplunkComputeDataset(this.engine, this.ctx, ret, new HashSet<SearchResult.FieldMeta>(), fieldExtractionHint, this.sriDd, this.lowLatencyScratch, this.numCores);
    }

    @Override
    public void foreach(final Actor actor) {
        PartitionedDataset action = this.pd.mapPartitions(new MapPartitionFunction(){

            @Override
            public Iterator<SplunkRecord> call(int partitionId, Iterator<SplunkRecord> srs) {
                while (srs.hasNext()) {
                    actor.act(srs.next().getVal());
                }
                return new ArrayList().iterator();
            }

            @Override
            public String desc() {
                return Utils.toString(new Throwable("partition action lambda"));
            }
        }, "acted");
        action.execute();
    }

    @Override
    public DistributedDataset setSriDD(DistributedDataset sridd) {
        return new SplunkComputeDataset(this.engine, this.ctx, this.pd, this.reducedByFields, this.fieldExtractionHint, sridd, this.lowLatencyScratch, this.numCores);
    }

    @Override
    public DistributedDataset getsriDD() {
        return this.sriDd;
    }

    @Override
    public void setContext(ComputeEngineContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public DistributedDataset dedup(DedupCommand dedupCommand, boolean boostPartitions) {
        throw new RuntimeException("splunk compute dataset: dedup not supported");
    }

    @Override
    public boolean ordered() {
        return this.pd.isOrdered();
    }

    @Override
    public DistributedDataset cacheDisk() {
        PartitionedDataset ret = this.pd.cache();
        return new SplunkComputeDataset(this.engine, this.ctx, ret, this.reducedByFields, this.fieldExtractionHint, this.sriDd, this.lowLatencyScratch, this.numCores);
    }

    @Override
    public DistributedDataset setExtractionHint(FieldExtractor.ExtractionHint extractionHint) {
        return new SplunkComputeDataset(this.engine, this.ctx, this.pd, this.reducedByFields, extractionHint, this.sriDd, this.lowLatencyScratch, this.numCores);
    }

    @Override
    public DistributedDataset coalesce(int numPars) {
        PartitionedDataset ret = this.pd.repartition(numPars);
        return new SplunkComputeDataset(this.engine, this.ctx, ret, this.reducedByFields, this.fieldExtractionHint, this.sriDd, this.lowLatencyScratch, this.numCores);
    }

    @Override
    public ComputeEngine engine() {
        return this.engine;
    }

    @Override
    public DistributedDataset setName(String name) {
        return new SplunkComputeDataset(this.engine, this.ctx, this.pd, this.reducedByFields, this.fieldExtractionHint, this.sriDd, this.lowLatencyScratch, this.numCores);
    }
}

