/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.splunkcompute;

import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.ExecutionHints;
import org.apache.log4j.Logger;

public class SplunkComputeExecutionHints
implements ExecutionHints,
ComputeEngineConstants {
    static final Logger logger = Logger.getLogger(SplunkComputeExecutionHints.class);
    private final double dfcDriverMemMbs;
    private final double dfcDriverCores;
    private static double DEFAULT_PAR_SIZE_2G_16_CORES_6_FIELD = 100000.0;
    private final String DFS_SPLUNK_COMPUTE_PARSIZE_2G_16_CORES_6_FIELD = "DFS_SPLUNK_COMPUTE_PARSIZE_2G_16_CORES_6_FIELD";
    private static double MAX_PAR_SIZE = 100000.0;
    private static double MIN_PAR_SIZE = 50000.0;
    private static double DEFAULT_DFC_MEM_MBS = 2048.0;
    private static double DEFAULT_DFC_DRIVER_CORES = 16.0;
    private static double DEFAULT_DFC_CORES = 16.0;
    private static String DFS_SPLUNK_COMPUTE_MAX_PARTITION_SIZE = "DFS_SPLUNK_COMPUTE_MAX_PARTITION_SIZE";
    private static String DFS_SPLUNK_COMPUTE_MIN_PARTITION_SIZE = "DFS_SPLUNK_COMPUTE_MIN_PARTITION_SIZE";

    SplunkComputeExecutionHints(int dfcDriverMemMbs, int dfcDriverCores) {
        this.dfcDriverMemMbs = dfcDriverMemMbs;
        this.dfcDriverCores = dfcDriverCores;
        logger.info((Object)String.format("splunk compute will use: %d mb memory and %d cores", dfcDriverMemMbs, dfcDriverCores));
    }

    private double getDefaultParSizeFor2g16Cores6Field() {
        double parSize = DEFAULT_PAR_SIZE_2G_16_CORES_6_FIELD;
        String parSizeStr = System.getenv("DFS_SPLUNK_COMPUTE_PARSIZE_2G_16_CORES_6_FIELD");
        if (parSizeStr != null && !parSizeStr.trim().isEmpty()) {
            try {
                parSize = Integer.valueOf(parSizeStr).intValue();
                logger.info((Object)String.format("default partition size for splunk compute with %d mbs %d cores dfc processing %d fields: %d overriden by envvar", (int)DEFAULT_DFC_MEM_MBS, (int)DEFAULT_DFC_CORES, 2, (int)parSize));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse %s to int default partition size for %d mbs %d cores dfc processing %d fields", parSizeStr, (int)DEFAULT_DFC_MEM_MBS, (int)DEFAULT_DFC_CORES, 2));
            }
        }
        logger.info((Object)String.format("default partition size for splunk compute with %d mbs %d cores dfc processing %d fields: %d", (int)DEFAULT_DFC_MEM_MBS, (int)DEFAULT_DFC_CORES, 2, (int)parSize));
        return parSize;
    }

    private double getMaxPartitionSize() {
        double max = MAX_PAR_SIZE;
        String maxStr = System.getenv(DFS_SPLUNK_COMPUTE_MAX_PARTITION_SIZE);
        if (maxStr != null && !maxStr.trim().isEmpty()) {
            try {
                max = Integer.valueOf(maxStr).intValue();
                logger.info((Object)String.format("max partition size for splunk compute capped at: %d using envvar", (int)max));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse %s to int max splunk compute partition size", maxStr));
            }
        }
        logger.info((Object)String.format("max partition size for splunk compute capped at: %d", (int)max));
        return max;
    }

    private double getMinPartitionSize() {
        double min = MIN_PAR_SIZE;
        String minStr = System.getenv(DFS_SPLUNK_COMPUTE_MIN_PARTITION_SIZE);
        if (minStr != null && !minStr.trim().isEmpty()) {
            try {
                min = Integer.valueOf(minStr).intValue();
                logger.info((Object)String.format("min partition size for splunk compute capped at: %d using envvar", (int)min));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse %s to int min splunk compute partition size", minStr));
            }
        }
        logger.info((Object)String.format("min partition size for splunk compute capped at: %d", (int)min));
        return min;
    }

    private int getPartitionSize(double numFields) {
        double defaultParSize2g16cores6field = this.getDefaultParSizeFor2g16Cores6Field();
        double parSize = defaultParSize2g16cores6field * (this.dfcDriverMemMbs / DEFAULT_DFC_MEM_MBS) * (DEFAULT_DFC_DRIVER_CORES / this.dfcDriverCores) * (2.0 / numFields);
        logger.info((Object)String.format("calculated partition size before applying caps: %d", (int)parSize));
        parSize = Math.min(this.getMaxPartitionSize(), parSize);
        parSize = Math.max(this.getMinPartitionSize(), parSize);
        logger.info((Object)String.format("calculated partition size post applying caps: %d", (int)parSize));
        return (int)parSize;
    }

    @Override
    public int reducePartitionCount(long recsCount, int numFields) {
        double records = recsCount;
        double parSize = this.getPartitionSize(numFields);
        double numPars = Math.ceil(records / parSize);
        int numParsInt = (int)numPars;
        logger.info((Object)String.format("reduce partition count: %d, num fields: %d, par size: %d, num recs: %d", numParsInt, numFields, (int)parSize, recsCount));
        return numParsInt;
    }

    @Override
    public int sortPartitionCount(long recsCount, int numFields) {
        return this.reducePartitionCount(recsCount, numFields);
    }

    @Override
    public int lightJoinPartitionCount(long recsCount, int numFields) {
        return this.reducePartitionCount(recsCount, numFields);
    }

    @Override
    public int joinPartitionCount(long recsCount, int numFields) {
        return this.reducePartitionCount(recsCount, numFields);
    }

    @Override
    public int defaultPartitionCount(long recsCount, int numFields) {
        return this.reducePartitionCount(recsCount, numFields);
    }

    @Override
    public int maxPartitionSize(int numFields) {
        return this.getPartitionSize(numFields);
    }

    @Override
    public long maxRecords() {
        long max = 1410065408L;
        String maxStr = System.getenv("DFS_MAX_RECORDS_COUNT");
        boolean setViaEnvvar = false;
        if (maxStr != null && !maxStr.trim().isEmpty()) {
            try {
                max = Long.valueOf(maxStr);
                setViaEnvvar = true;
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse max records count to long: %s", maxStr));
            }
        }
        logger.info((Object)String.format("max computable records count set to: %d via envvar: %b", max, setViaEnvvar));
        return max;
    }
}

