/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.commands.UnknownCommand;
import com.splunk.df.search.compute.ComputeEngineContext;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.Transformer;
import com.splunk.df.search.compute.TransformerRegistry;
import com.splunk.df.search.compute.container.SoftContainerService;
import com.splunk.df.search.compute.sdk.ExternalConstants;
import com.splunk.df.search.compute.sdk.ExternalDistributedDataset;
import com.splunk.df.search.compute.sdk.ExternalOperatorParams;
import com.splunk.df.search.compute.sdk.ExternalTransformer;
import com.splunk.df.search.compute.transformers.ExternalCommandMetadataRegistry;
import com.splunk.df.search.compute.transformers.external.ExternalDistributedDatasetImpl;
import com.splunk.df.search.compute.transformers.external.ExternalOperatorParamsImpl;
import org.apache.log4j.Logger;

public class ExternalTransformerImpl
implements Transformer,
ExternalConstants {
    static final Logger logger = Logger.getLogger(ExternalTransformerImpl.class);

    @Override
    public DistributedDataset transform(DistributedDataset dd, CommandNode qcmd, boolean streaming, ComputeEngineContext ctx) {
        ExternalCommandMetadataRegistry ecmr = (ExternalCommandMetadataRegistry)ctx.get("externalCommandMetdataRegistry");
        ExternalCommandMetadataRegistry.ExternalCommandMetadata metadata = ecmr.getMetdata(qcmd.getCommandName());
        logger.debug((Object)String.format("Found external metadata for command: %s, %s", qcmd.getCommandName(), metadata.toString()));
        DistributedDataset ret = dd;
        CommandNode srcCmd = qcmd.getSource();
        Transformer t = ((TransformerRegistry)ctx.get("dfs.dataset.transformer.registry")).getTransformer(srcCmd);
        logger.debug((Object)String.format("Delegating to source transformer - %s", srcCmd.getCommandName()));
        ret = t.transform(ret, srcCmd, streaming, ctx);
        ret = ExternalTransformerImpl._transform(ctx, ret, metadata, (UnknownCommand)qcmd);
        logger.debug((Object)String.format("Applied transformation using: %s external transformer", metadata.getCommandName()));
        return ret;
    }

    private static DistributedDataset _transform(ComputeEngineContext ctx, DistributedDataset inputdd, ExternalCommandMetadataRegistry.ExternalCommandMetadata metadata, UnknownCommand cmd) {
        SoftContainerService scs = (SoftContainerService)ctx.get("softContainerService");
        ExternalTransformer et = scs.getTransformer(metadata, false);
        logger.debug((Object)String.format("Loaded class: %s, id: %s", et.getClass().getName(), et.getName()));
        ExternalDistributedDatasetImpl edd = new ExternalDistributedDatasetImpl(metadata, inputdd);
        ExternalOperatorParamsImpl params = new ExternalOperatorParamsImpl();
        ExternalOperatorParams ep = et.params(params, cmd.getArguments());
        ExternalDistributedDataset ret = et.transform(edd, ep);
        edd = (ExternalDistributedDatasetImpl)ret;
        return edd.getDistributedDataset();
    }

    @Override
    public String name() {
        return "ExternalTransformer";
    }
}

