/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers;

import com.clearspring.analytics.stream.cardinality.HyperLogLog;
import com.splunk.commons.Row;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.expressions.AggregateFunction;
import com.splunk.commons.ast.nodes.expressions.AggregateNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.visitors.ExpressionEvaluator;
import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.sdk.Pair;
import com.splunk.df.search.compute.transformers.FieldExtractor;
import com.splunk.df.search.compute.transformers.aggregatevalues.EdcErrorInfo;
import com.splunk.df.util.DFSException;
import com.splunk.df.util.MultiValueFieldParser;
import com.tdunning.math.stats.TDigest;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class FieldExtractorFactory
implements ComputeEngineConstants {
    static final Logger logger = Logger.getLogger(FieldExtractorFactory.class);
    private static FieldExtractorFactory singleton = new FieldExtractorFactory();
    private HashMap<AggregateFunction, FieldExtractor> extractorTable = new HashMap();

    private FieldExtractorFactory() {
        this.extractorTable.put(AggregateFunction.AVG, new CountAndSumExtractor());
        this.extractorTable.put(AggregateFunction.C, new CountFieldExtractor());
        this.extractorTable.put(AggregateFunction.COUNT, new CountFieldExtractor());
        this.extractorTable.put(AggregateFunction.DC, new ValuesSetExtractor());
        this.extractorTable.put(AggregateFunction.DISTINCT_COUNT, new ValuesSetExtractor());
        this.extractorTable.put(AggregateFunction.EARLIEST, new EarliestValueExtractor());
        this.extractorTable.put(AggregateFunction.EARLIEST_TIME, new EarliestValueExtractor());
        this.extractorTable.put(AggregateFunction.EXACTPERC_X, new ValuesAndCountsExtractor());
        this.extractorTable.put(AggregateFunction.PERC_X, new PercValueExtractor());
        this.extractorTable.put(AggregateFunction.UPPERPERC_X, new PercValueExtractor());
        this.extractorTable.put(AggregateFunction.ESTDC, new ValuesAndCountsExtractor());
        this.extractorTable.put(AggregateFunction.FIRST, new OrderedValuesExtractor(ThresholdType.FIRST));
        this.extractorTable.put(AggregateFunction.LATEST, new LatestValueExtractor());
        this.extractorTable.put(AggregateFunction.LATEST_TIME, new LatestValueExtractor());
        this.extractorTable.put(AggregateFunction.LAST, new OrderedValuesExtractor(ThresholdType.LAST));
        this.extractorTable.put(AggregateFunction.LIST, new ValuesListExtractor());
        this.extractorTable.put(AggregateFunction.MAX, new MaxValueExtractor());
        this.extractorTable.put(AggregateFunction.MEAN, new CountAndSumExtractor());
        this.extractorTable.put(AggregateFunction.MEDIAN, new QuantileValueExtractor());
        this.extractorTable.put(AggregateFunction.MIN, new MinValueExtractor());
        this.extractorTable.put(AggregateFunction.MODE, new ValuesAndCountsExtractor());
        this.extractorTable.put(AggregateFunction.RANGE, new RangeExtractor());
        this.extractorTable.put(AggregateFunction.SPARKLINE, new SparklineValuesExtractor());
        this.extractorTable.put(AggregateFunction.STDEV, new CountSumAndSumSquareExtractor());
        this.extractorTable.put(AggregateFunction.STDEVP, new CountSumAndSumSquareExtractor());
        this.extractorTable.put(AggregateFunction.SUM, new CountAndSumExtractor());
        this.extractorTable.put(AggregateFunction.SUMSQ, new CountAndSumSquareExtractor());
        this.extractorTable.put(AggregateFunction.VALUES, new ValuesSetExtractor());
        this.extractorTable.put(AggregateFunction.VAR, new CountSumAndSumSquareExtractor());
        this.extractorTable.put(AggregateFunction.VARP, new CountSumAndSumSquareExtractor());
        this.extractorTable.put(AggregateFunction.ESTDC_ERROR, new ValuesAndCountsExtractor());
    }

    public static FieldExtractorFactory getInstance() {
        return singleton;
    }

    public FieldExtractor getFieldExtractor(AggregateFunction func) {
        FieldExtractor fieldExtractor = this.extractorTable.get(func);
        if (fieldExtractor == null) {
            logger.debug((Object)("Extraction not supported for aggregation function: " + func));
            throw new RuntimeException("Extraction not supported for aggregation function: " + func);
        }
        return fieldExtractor;
    }

    public static SearchResult.FieldMeta getPrecomputedResultsFieldName(AggregateNode aggregateNode, SearchResult.FieldMeta field) {
        if (aggregateNode.getEvalFunc() == null) {
            return field;
        }
        field = field == null ? SearchResult.FieldMeta.newFieldMeta(aggregateNode.getEvalFunc().toString()) : field.reset(aggregateNode.getEvalFunc().toString());
        return field;
    }

    public static Object extractValueFromSearchResult(AggregateNode aggregateNode, SearchResult.FieldMeta field, SearchResult sr) {
        Object result = null;
        if (aggregateNode.getEvalFunc() == null) {
            if (field.fieldName() != null && !field.fieldName().trim().equals("")) {
                result = sr.getFieldValue(field);
            }
        } else {
            ExpressionEvaluator expressionEvaluator = new ExpressionEvaluator();
            result = expressionEvaluator.evaluate((Node)aggregateNode.getEvalFunc(), new Row(SearchResultFactory.convert(sr.getDataMap())));
        }
        return result;
    }

    private static Map<Object, Long> getValuesAndCountsForField(SearchResult sr, SearchResult.FieldMeta field) {
        Map<Object, Long> valCounts = new HashMap<Object, Long>();
        Object value = sr.getFieldValue(field.getPrestatsMVFieldName());
        if (null != value && !value.toString().isEmpty()) {
            valCounts = FieldExtractorFactory.parseValuesAndCounts(value.toString());
        }
        return valCounts;
    }

    private static byte[] getHyperLogLogForValue(SearchResult sr, SearchResult.FieldMeta field) {
        Object value = sr.getFieldValue(field.getPrestatsMVFieldName());
        String strVal = null;
        try {
            if (value != null) {
                strVal = value.toString().trim();
            }
            if (strVal != null && !strVal.isEmpty()) {
                return FieldExtractorFactory.computeHyperLogLog(value.toString()).getBytes();
            }
            return new HyperLogLog(16).getBytes();
        }
        catch (Throwable t) {
            logger.debug((Object)String.format("error computing hyper log values: %s", t.getMessage()), t);
            throw new RuntimeException(String.format("could not parse value: %s", strVal), t);
        }
    }

    private static HyperLogLog computeHyperLogLog(String valuesAndCountsString) {
        HyperLogLog hyperLogLog = new HyperLogLog(16);
        if (valuesAndCountsString == null || valuesAndCountsString.isEmpty()) {
            return hyperLogLog;
        }
        Map<Object, Long> valCounts = FieldExtractorFactory.parseValuesAndCounts(valuesAndCountsString);
        for (Map.Entry<Object, Long> entry : valCounts.entrySet()) {
            Object key = entry.getKey();
            Long count = entry.getValue();
            for (long i = 0L; i < count; ++i) {
                hyperLogLog.offer(key);
            }
        }
        return hyperLogLog;
    }

    private static Pair<Double, Object> getTimeAndValueForField(SearchResult sr, SearchResult.FieldMeta field, TimeType type) {
        String[] parts;
        SearchResult.FieldMeta fieldName = null;
        if (type.equals((Object)TimeType.EARLIEST)) {
            fieldName = field.getPrestatsEarliestTimeName();
        } else if (type.equals((Object)TimeType.LATEST)) {
            fieldName = field.getPrestatsLatestTimeName();
        } else {
            throw new RuntimeException("invalid time type");
        }
        Object value = sr.getFieldValue(fieldName);
        Double time = 0.0;
        if (null != value && !value.toString().isEmpty() && (parts = value.toString().split(";")).length == 2) {
            try {
                time = Double.parseDouble(parts[0]);
                String valAtTime = parts[1];
                return new Pair<Double, Object>(time, valAtTime);
            }
            catch (Exception e) {
                logger.error((Object)String.format("Error parsing value %s as a time:value format tuple", value));
            }
        }
        return null;
    }

    private static Map<Long, String> getSparklineValueForField(SearchResult sr, SearchResult.FieldMeta field) {
        Object value = sr.getFieldValue(field.getPrestatsSparklineName());
        HashMap<Long, String> valuesMap = new HashMap<Long, String>();
        if (value != null) {
            String[] parts = value.toString().split(";");
            String timeInterval = parts[0];
            for (int i = 1; i < parts.length; ++i) {
                String[] tsAndStats = parts[i].split(":");
                Long timestamp = Long.parseLong(tsAndStats[0]);
                valuesMap.put(timestamp, tsAndStats[1]);
            }
        }
        return valuesMap;
    }

    private static SearchResult.FieldMeta getActualField(SearchResult.FieldMeta field, ThresholdType type) {
        if (type.equals((Object)ThresholdType.MIN)) {
            return field.getPrestatsThresholdMin();
        }
        if (type.equals((Object)ThresholdType.MAX)) {
            return field.getPrestatsThresholdMax();
        }
        if (type.equals((Object)ThresholdType.MIN_STR)) {
            return field.getPrestatsThresholdMinStr();
        }
        if (type.equals((Object)ThresholdType.MAX_STR)) {
            return field.getPrestatsThresholdMaxStr();
        }
        if (type.equals((Object)ThresholdType.FIRST)) {
            return field.getPrestatsThresholdFirst();
        }
        if (type.equals((Object)ThresholdType.LAST)) {
            return field.getPrestatsThresholdLast();
        }
        throw new RuntimeException("unsupported threshold type");
    }

    private static Object getThresholdValueForField(SearchResult sr, SearchResult.FieldMeta field, ThresholdType type, boolean logMessage) {
        Object value = sr.getFieldValue(FieldExtractorFactory.getActualField(field, type));
        if (logMessage && null == value) {
            logger.debug((Object)String.format("Null value found for %s", FieldExtractorFactory.getActualField(field, type).fieldName()));
        }
        return value;
    }

    private static List<String> getValuesForField(SearchResult sr, SearchResult.FieldMeta field) {
        Object value = sr.getFieldValue(field.getPrestatsListName());
        List<String> valsList = null;
        if (null == value || value.toString().isEmpty()) {
            logger.debug((Object)String.format("Null or Empty value found for %s%s", "psrsvd_li_", field.fieldName()));
            valsList = new ArrayList<String>();
        } else {
            valsList = Arrays.asList(value.toString().split(";"));
        }
        return valsList;
    }

    private static Pair<Double, Double> getMinMaxPairForField(SearchResult searchResult, SearchResult.FieldMeta field) {
        Double minValue = Double.MAX_VALUE;
        Double maxValue = Double.MIN_VALUE;
        Object minFieldValue = FieldExtractorFactory.getThresholdValueForField(searchResult, field, ThresholdType.MIN, false);
        Object maxFieldValue = FieldExtractorFactory.getThresholdValueForField(searchResult, field, ThresholdType.MAX, false);
        try {
            minValue = Double.parseDouble(minFieldValue.toString());
        }
        catch (Exception e) {
            logger.debug((Object)String.format("Exception caught parsing prestats min field value %s to Double ", maxFieldValue));
            return null;
        }
        try {
            maxValue = Double.parseDouble(maxFieldValue.toString());
        }
        catch (Exception e) {
            logger.debug((Object)String.format("Exception caught parsing prestats max field value %s to Double ", maxFieldValue));
            return null;
        }
        return new Pair<Double, Double>(minValue, maxValue);
    }

    private static Pair<Long, Pair<Double, Double>> getCountSumAndSumSquareForField(SearchResult sr, SearchResult.FieldMeta field) {
        Long fieldCount = FieldExtractorFactory.getCountForField(sr, field);
        Double fieldSum = FieldExtractorFactory.getSumForField(sr, field, SumType.SUM);
        Double fieldSumSquares = FieldExtractorFactory.getSumForField(sr, field, SumType.SUM_SQUARED);
        if (fieldCount == null || fieldSum == null || fieldSumSquares == null) {
            return null;
        }
        return new Pair<Long, Pair<Double, Double>>(fieldCount, new Pair<Double, Double>(fieldSum, fieldSumSquares));
    }

    private static Pair<Long, Double> getCountAndSumPairForField(SearchResult sr, SearchResult.FieldMeta field, SumType type) {
        Long fieldCount = FieldExtractorFactory.getCountForField(sr, field);
        Double fieldSum = FieldExtractorFactory.getSumForField(sr, field, type);
        if (fieldCount == null || fieldSum == null) {
            return new Pair<Long, Double>(0L, 0.0);
        }
        return new Pair<Long, Double>(fieldCount, fieldSum);
    }

    private static Double getSumForField(SearchResult sr, SearchResult.FieldMeta field, SumType type) {
        Double fieldSum;
        block7: {
            SearchResult.FieldMeta srSumField = null;
            if (type.equals((Object)SumType.SUM)) {
                srSumField = field.getPrestatsSumName();
            } else if (type.equals((Object)SumType.SUM_SQUARED)) {
                srSumField = field.getPrestatsSumSquaredName();
            } else {
                throw new RuntimeException(String.format("invalid sum type", new Object[0]));
            }
            fieldSum = null;
            Object fieldSumObj = sr.getFieldValue(srSumField);
            if (fieldSumObj != null) {
                try {
                    fieldSum = Double.parseDouble(fieldSumObj.toString());
                }
                catch (Throwable t) {
                    if (!logger.isDebugEnabled()) break block7;
                    logger.debug((Object)String.format("sum field: %s has a value: %s which could not be parsed to double", srSumField.toString(), fieldSumObj));
                }
            }
        }
        return fieldSum;
    }

    private static Long getCountForField(SearchResult sr, SearchResult.FieldMeta field) {
        SearchResult.FieldMeta srCountField = field.getPrestatsCountName();
        Long fieldCount = null;
        Object fieldCountObj = sr.getFieldValue(srCountField);
        if (fieldCountObj != null) {
            try {
                fieldCount = Long.parseLong(fieldCountObj.toString());
            }
            catch (Throwable t) {
                logger.debug((Object)String.format("count field: %s has a value: %s which could not be parsed to long", srCountField, fieldCountObj));
            }
        }
        return fieldCount;
    }

    private static Long parseLongWithErrorHandling(Object countValue) {
        Long count;
        block5: {
            count = 0L;
            if (countValue != null) {
                try {
                    String countValStr = countValue.toString();
                    if (countValStr.length() == 0) {
                        return count;
                    }
                    if ((countValStr = countValStr.trim()).isEmpty()) {
                        return count;
                    }
                    count = Long.parseLong(countValStr);
                }
                catch (Throwable t) {
                    if (!logger.isDebugEnabled()) break block5;
                    logger.warn((Object)String.format("Error parsing count field value %s into long", countValue));
                }
            }
        }
        return count;
    }

    private static boolean isMultiValuedField(SearchResult sr, FieldNode fieldNode, SearchResult.FieldMeta fieldMeta, Object result) {
        if (fieldNode == null) {
            return false;
        }
        SearchResult.FieldMeta mvName = fieldMeta.getMvName();
        return sr.containsField(mvName);
    }

    private static String[] getArrayFromMVString(String mvString) {
        if (mvString.startsWith("[") && mvString.endsWith("]")) {
            mvString = mvString.substring(1, mvString.length() - 1);
        }
        String[] parts = mvString.split(",");
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = parts[i].trim();
        }
        return parts;
    }

    private static Map<Object, Long> parseValuesAndCounts(String payload) {
        HashMap<Object, Long> valCounts = new HashMap<Object, Long>();
        int len = payload.length();
        StringBuilder valueSb = new StringBuilder();
        StringBuilder countSb = new StringBuilder();
        boolean valueMode = true;
        for (int i = 0; i < len; ++i) {
            char c = payload.charAt(i);
            if (c == ';') {
                if (!valueMode) {
                    String value = valueSb.toString();
                    long count = Long.valueOf(countSb.toString());
                    valCounts.put(value, count);
                    valueSb.setLength(0);
                    countSb.setLength(0);
                    valueMode = true;
                    continue;
                }
                if (i >= len - 1) continue;
                char nextC = payload.charAt(i + 1);
                if (nextC == ';') {
                    valueSb.append(c);
                    ++i;
                    continue;
                }
                valueMode = false;
                continue;
            }
            if (valueMode) {
                valueSb.append(c);
                continue;
            }
            countSb.append(c);
        }
        if (valueSb.length() > 0) {
            String value = valueSb.toString();
            long count = 0L;
            if (countSb.length() > 0) {
                count = Long.valueOf(countSb.toString());
            }
            valCounts.put(value, count);
        }
        return valCounts;
    }

    public static void main(String[] args) {
        String values = "Mozilla/5.0 (Macintosh;; U;; PPC Mac OS X Mach-O;; en-US;; sl:1.7.7) Gecko/00010100 Firefox/1.0.3;27;Mozilla/5.0 (Macintosh;; U;; PPC Mac OS X;; en) AppleWebKit/412 (KHTML, like Gecko) Safari/412;166;check_http/1.10 (nagios-plugins 1.4);477;";
        Map<Object, Object> valCounts = new HashMap();
        valCounts = FieldExtractorFactory.parseValuesAndCounts(values);
        System.out.println(valCounts.toString());
    }

    private static enum SumType {
        SUM,
        SUM_SQUARED;

    }

    private static enum ThresholdType {
        MIN,
        MAX,
        MIN_STR,
        MAX_STR,
        FIRST,
        LAST;

    }

    private static enum TimeType {
        EARLIEST,
        LATEST;

    }

    private static class SparklineValuesExtractor
    implements FieldExtractor {
        private SparklineValuesExtractor() {
        }

        @Override
        public Object extract(SearchResult sr, AggregateNode aggregateNode, SearchResult.FieldMeta field, FieldExtractor.ExtractionHint fieldExtractionHint) {
            if (fieldExtractionHint.equals((Object)FieldExtractor.ExtractionHint.PRECOMPUTED_PRE_STAGED)) {
                SearchResult.FieldMeta newField = FieldExtractorFactory.getPrecomputedResultsFieldName(aggregateNode, field);
                return FieldExtractorFactory.getSparklineValueForField(sr, newField);
            }
            if (fieldExtractionHint.equals((Object)FieldExtractor.ExtractionHint.PRECOMPUTED_NO_PRE_STAGING)) {
                throw new UnsupportedOperationException("Stats function '" + aggregateNode.getFunction() + "' not supported for PRECOMPUTED_NO_PRE_STAGING data");
            }
            throw new UnsupportedOperationException("Stats function '" + aggregateNode.getFunction() + "' not supported for RAW data");
        }
    }

    private static class RangeExtractor
    implements FieldExtractor {
        private RangeExtractor() {
        }

        @Override
        public Object extract(SearchResult sr, AggregateNode aggregateNode, SearchResult.FieldMeta field, FieldExtractor.ExtractionHint fieldExtractionHint) {
            if (fieldExtractionHint.equals((Object)FieldExtractor.ExtractionHint.PRECOMPUTED_PRE_STAGED)) {
                SearchResult.FieldMeta newField = FieldExtractorFactory.getPrecomputedResultsFieldName(aggregateNode, field);
                return FieldExtractorFactory.getMinMaxPairForField(sr, newField);
            }
            if (fieldExtractionHint.equals((Object)FieldExtractor.ExtractionHint.PRECOMPUTED_NO_PRE_STAGING)) {
                throw new UnsupportedOperationException("Stats function '" + aggregateNode.getFunction() + "' not supported for PRECOMPUTED_NO_PRE_STAGING data");
            }
            Object result = FieldExtractorFactory.extractValueFromSearchResult(aggregateNode, field, sr);
            FieldNode fieldNode = aggregateNode.getField();
            if (result != null) {
                if (FieldExtractorFactory.isMultiValuedField(sr, fieldNode, field, result)) {
                    String[] parts = FieldExtractorFactory.getArrayFromMVString(result.toString());
                    Double maxVal = Double.MIN_VALUE;
                    Double minVal = Double.MAX_VALUE;
                    for (String part : parts) {
                        try {
                            Double doubleVal = Double.parseDouble(part);
                            maxVal = doubleVal > maxVal ? doubleVal : maxVal;
                            minVal = doubleVal < minVal ? doubleVal : minVal;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return new Pair<Double, Double>(minVal, maxVal);
                }
                try {
                    Double dval = new BigDecimal(result.toString()).doubleValue();
                    return new Pair<Double, Double>(dval, dval);
                }
                catch (Exception e) {
                    logger.debug((Object)String.format("Exception caught parsing value %s into a double", result), (Throwable)e);
                }
            }
            return new Pair<Object, Object>(null, null);
        }
    }

    private static class MaxValueExtractor
    implements FieldExtractor {
        private MaxValueExtractor() {
        }

        @Override
        public Object extract(SearchResult sr, AggregateNode aggregateNode, SearchResult.FieldMeta field, FieldExtractor.ExtractionHint fieldExtractionHint) {
            if (fieldExtractionHint.equals((Object)FieldExtractor.ExtractionHint.PRECOMPUTED_PRE_STAGED)) {
                SearchResult.FieldMeta newField = FieldExtractorFactory.getPrecomputedResultsFieldName(aggregateNode, field);
                Object obj = FieldExtractorFactory.getThresholdValueForField(sr, newField, ThresholdType.MAX, false);
                if (obj == null) {
                    obj = FieldExtractorFactory.getThresholdValueForField(sr, newField, ThresholdType.MAX_STR, true);
                }
                return obj;
            }
            if (fieldExtractionHint.equals((Object)FieldExtractor.ExtractionHint.PRECOMPUTED_NO_PRE_STAGING)) {
                Object result = sr.getFieldValue(SearchResult.FieldMeta.newFieldMeta(aggregateNode.getAsName()));
                return result;
            }
            Object result = FieldExtractorFactory.extractValueFromSearchResult(aggregateNode, field, sr);
            FieldNode fieldNode = aggregateNode.getField();
            if (result != null) {
                if (FieldExtractorFactory.isMultiValuedField(sr, fieldNode, field, result)) {
                    String[] parts = FieldExtractorFactory.getArrayFromMVString(result.toString());
                    Double maxVal = Double.MIN_VALUE;
                    for (String part : parts) {
                        try {
                            Double doubleVal = Double.parseDouble(part);
                            maxVal = doubleVal > maxVal ? doubleVal : maxVal;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return maxVal;
                }
                if (result instanceof Number) {
                    return new BigDecimal(result.toString()).doubleValue();
                }
                return result;
            }
            return null;
        }
    }

    private static class MinValueExtractor
    implements FieldExtractor {
        private MinValueExtractor() {
        }

        @Override
        public Object extract(SearchResult sr, AggregateNode aggregateNode, SearchResult.FieldMeta field, FieldExtractor.ExtractionHint fieldExtractionHint) {
            if (fieldExtractionHint.equals((Object)FieldExtractor.ExtractionHint.PRECOMPUTED_PRE_STAGED)) {
                SearchResult.FieldMeta newField = FieldExtractorFactory.getPrecomputedResultsFieldName(aggregateNode, field);
                Object obj = FieldExtractorFactory.getThresholdValueForField(sr, newField, ThresholdType.MIN, false);
                if (obj == null) {
                    obj = FieldExtractorFactory.getThresholdValueForField(sr, newField, ThresholdType.MIN_STR, true);
                }
                return obj;
            }
            if (fieldExtractionHint.equals((Object)FieldExtractor.ExtractionHint.PRECOMPUTED_NO_PRE_STAGING)) {
                Object result = sr.getFieldValue(SearchResult.FieldMeta.newFieldMeta(aggregateNode.getAsName()));
                return result;
            }
            Object result = FieldExtractorFactory.extractValueFromSearchResult(aggregateNode, field, sr);
            FieldNode fieldNode = aggregateNode.getField();
            if (result != null) {
                if (FieldExtractorFactory.isMultiValuedField(sr, fieldNode, field, result)) {
                    String[] parts = FieldExtractorFactory.getArrayFromMVString(result.toString());
                    Double minVal = Double.MAX_VALUE;
                    for (String part : parts) {
                        try {
                            Double doubleVal = Double.parseDouble(part);
                            minVal = doubleVal < minVal ? doubleVal : minVal;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return minVal;
                }
                if (result instanceof Number) {
                    return new BigDecimal(result.toString()).doubleValue();
                }
                return result;
            }
            return null;
        }
    }

    private static class LatestValueExtractor
    implements FieldExtractor {
        private LatestValueExtractor() {
        }

        @Override
        public Object extract(SearchResult sr, AggregateNode aggregateNode, SearchResult.FieldMeta field, FieldExtractor.ExtractionHint fieldExtractionHint) {
            block7: {
                if (fieldExtractionHint.equals((Object)FieldExtractor.ExtractionHint.PRECOMPUTED_PRE_STAGED)) {
                    Pair result = FieldExtractorFactory.getTimeAndValueForField(sr, field, TimeType.LATEST);
                    if (null == result) {
                        return new Pair<Double, String>((Double)Double.MIN_VALUE, "");
                    }
                    return result;
                }
                if (fieldExtractionHint.equals((Object)FieldExtractor.ExtractionHint.PRECOMPUTED_NO_PRE_STAGING)) {
                    throw new UnsupportedOperationException("Stats function '" + aggregateNode.getFunction() + "' not supported for PRECOMPUTED_NO_PRE_STAGING data");
                }
                if (field.fieldName() == null || field.fieldName().trim().equals("")) {
                    return new Pair<Double, String>((Double)Double.MIN_VALUE, "");
                }
                Object val = sr.getFieldValue(field);
                Object _time = sr.getFieldValue(SearchResult._TIME_FIELD_META);
                if (val != null && _time != null && !val.toString().isEmpty() && !_time.toString().isEmpty()) {
                    try {
                        Double timestamp = Double.parseDouble(_time.toString());
                        return new Pair<Double, Object>(timestamp, val);
                    }
                    catch (Exception e) {
                        if (!logger.isDebugEnabled()) break block7;
                        logger.error((Object)String.format("Error converting field value %s to long for field %s", val, "_time"));
                    }
                }
            }
            return new Pair<Double, String>((Double)Double.MIN_VALUE, "");
        }
    }

    private static class OrderedValuesExtractor
    implements FieldExtractor {
        ThresholdType thresholdType;

        OrderedValuesExtractor(ThresholdType thresholdType) {
            this.thresholdType = thresholdType;
        }

        @Override
        public Object extract(SearchResult sr, AggregateNode aggregateNode, SearchResult.FieldMeta field, FieldExtractor.ExtractionHint fieldExtractionHint) {
            if (fieldExtractionHint.equals((Object)FieldExtractor.ExtractionHint.PRECOMPUTED_PRE_STAGED)) {
                return FieldExtractorFactory.getThresholdValueForField(sr, field, this.thresholdType, true);
            }
            if (fieldExtractionHint.equals((Object)FieldExtractor.ExtractionHint.PRECOMPUTED_NO_PRE_STAGING)) {
                return sr.getFieldValue(SearchResult.FieldMeta.newFieldMeta(aggregateNode.getAsName()));
            }
            if (field.fieldName() == null || field.fieldName().trim().equals("")) {
                return null;
            }
            Object value = sr.getFieldValue(field);
            FieldNode fieldNode = aggregateNode.getField();
            if (FieldExtractorFactory.isMultiValuedField(sr, fieldNode, field, value)) {
                Object mvValue = sr.getFieldValue(SearchResult.FieldMeta.newFieldMeta(String.format("%s%s", "__mv_", fieldNode.getFieldName())));
                String[] parts = mvValue == null || mvValue.toString().length() == 0 ? FieldExtractorFactory.getArrayFromMVString(value.toString()) : MultiValueFieldParser.parse(mvValue.toString());
                if (this.thresholdType.equals((Object)ThresholdType.FIRST)) {
                    return parts[0];
                }
                return parts[parts.length - 1];
            }
            return value;
        }
    }

    private static class EarliestValueExtractor
    implements FieldExtractor {
        private EarliestValueExtractor() {
        }

        @Override
        public Object extract(SearchResult sr, AggregateNode aggregateNode, SearchResult.FieldMeta field, FieldExtractor.ExtractionHint fieldExtractionHint) {
            if (fieldExtractionHint.equals((Object)FieldExtractor.ExtractionHint.PRECOMPUTED_PRE_STAGED)) {
                Pair result = FieldExtractorFactory.getTimeAndValueForField(sr, field, TimeType.EARLIEST);
                if (null == result) {
                    return new Pair<Double, String>((Double)Double.MAX_VALUE, "");
                }
                return result;
            }
            if (fieldExtractionHint.equals((Object)FieldExtractor.ExtractionHint.PRECOMPUTED_NO_PRE_STAGING)) {
                throw new UnsupportedOperationException("Stats function '" + aggregateNode.getFunction() + "' not supported for PRECOMPUTED_NO_PRE_STAGING data");
            }
            if (field.fieldName() == null || field.fieldName().trim().equals("")) {
                return new Pair<Double, String>((Double)Double.MAX_VALUE, "");
            }
            Object val = sr.getFieldValue(field);
            Object _time = sr.getFieldValue(SearchResult._TIME_FIELD_META);
            if (val != null && _time != null && !val.toString().isEmpty() && !_time.toString().isEmpty()) {
                try {
                    Double timestamp = Double.parseDouble(_time.toString());
                    return new Pair<Double, Object>(timestamp, val);
                }
                catch (Exception e) {
                    logger.debug((Object)String.format("Error converting field value %s to long for field %s", val, "_time"));
                }
            }
            return new Pair<Double, String>((Double)Double.MAX_VALUE, "");
        }
    }

    private static class QuantileValueExtractor
    implements FieldExtractor {
        private QuantileValueExtractor() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object extract(SearchResult sr, AggregateNode aggregateNode, SearchResult.FieldMeta field, FieldExtractor.ExtractionHint fieldExtractionHint) {
            TDigest digest = TDigest.createMergingDigest((double)100.0);
            if (fieldExtractionHint.equals((Object)FieldExtractor.ExtractionHint.PRECOMPUTED_PRE_STAGED)) {
                String[] parts;
                Object value = sr.getFieldValue(field.getPrestatsPercName());
                if (null == value) return null;
                String str = value.toString();
                for (String part : parts = str.split(";")) {
                    if ((part = part.trim()).isEmpty()) continue;
                    try {
                        String val;
                        String obj;
                        String[] splits = part.split(":");
                        if (splits.length < 2 || (obj = splits[0].trim()).isEmpty()) continue;
                        long count = Long.parseLong(splits[1]);
                        int remain = (int)(count % Integer.MAX_VALUE);
                        int multiples = (int)(count / Integer.MAX_VALUE);
                        for (int i = 0; i < multiples; ++i) {
                            String val2 = obj;
                            if (val2 == null || val2.isEmpty()) continue;
                            digest.add(Double.parseDouble(val2), Integer.MAX_VALUE);
                        }
                        if (remain <= 0 || (val = obj) == null || val.isEmpty()) continue;
                        digest.add(Double.parseDouble(val), remain);
                    }
                    catch (Exception e) {
                        logger.warn((Object)String.format("error parsing value: %s, as a value:count format tuple", part));
                    }
                }
                return digest;
            } else {
                String str;
                if (fieldExtractionHint.equals((Object)FieldExtractor.ExtractionHint.PRECOMPUTED_NO_PRE_STAGING)) {
                    throw new UnsupportedOperationException("Stats function '" + aggregateNode.getFunction() + "' not supported for PRECOMPUTED_NO_PRE_STAGING data");
                }
                Object result = FieldExtractorFactory.extractValueFromSearchResult(aggregateNode, field, sr);
                FieldNode fieldNode = aggregateNode.getField();
                if (result == null || (str = result.toString()) == null || str.isEmpty()) return digest;
                if (FieldExtractorFactory.isMultiValuedField(sr, fieldNode, field, str)) {
                    String[] parts;
                    for (String part : parts = FieldExtractorFactory.getArrayFromMVString(str)) {
                        try {
                            digest.add(Double.parseDouble(part));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return digest;
                } else {
                    digest.add(Double.parseDouble(str));
                }
            }
            return digest;
        }
    }

    private static class PercValueExtractor
    implements FieldExtractor {
        private PercValueExtractor() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object extract(SearchResult sr, AggregateNode aggregateNode, SearchResult.FieldMeta field, FieldExtractor.ExtractionHint fieldExtractionHint) {
            TDigest digest = TDigest.createMergingDigest((double)100.0);
            if (fieldExtractionHint.equals((Object)FieldExtractor.ExtractionHint.PRECOMPUTED_PRE_STAGED)) {
                String[] parts;
                Object value = sr.getFieldValue(field.getPrestatsPercName());
                if (null == value) return null;
                String str = value.toString();
                for (String part : parts = str.split(";")) {
                    try {
                        String val;
                        String[] splits = part.split(":");
                        String obj = splits[0];
                        long count = Long.parseLong(splits[1]);
                        int remain = (int)(count % Integer.MAX_VALUE);
                        int multiples = (int)(count / Integer.MAX_VALUE);
                        for (int i = 0; i < multiples; ++i) {
                            String val2 = obj;
                            if (val2 == null || val2.isEmpty()) continue;
                            digest.add(Double.parseDouble(val2), Integer.MAX_VALUE);
                        }
                        if (remain <= 0 || (val = obj) == null || val.isEmpty()) continue;
                        digest.add(Double.parseDouble(val), remain);
                    }
                    catch (Exception e) {
                        logger.debug((Object)String.format("Error parsing value %s as a value:count format tuple", part));
                    }
                }
            } else {
                String str;
                if (fieldExtractionHint.equals((Object)FieldExtractor.ExtractionHint.PRECOMPUTED_NO_PRE_STAGING)) {
                    throw new UnsupportedOperationException("Stats function '" + aggregateNode.getFunction() + "' not supported for PRECOMPUTED_NO_PRE_STAGING data");
                }
                Object result = FieldExtractorFactory.extractValueFromSearchResult(aggregateNode, field, sr);
                FieldNode fieldNode = aggregateNode.getField();
                if (result != null && (str = result.toString()) != null && !str.isEmpty()) {
                    if (FieldExtractorFactory.isMultiValuedField(sr, fieldNode, field, str)) {
                        String[] parts;
                        for (String part : parts = FieldExtractorFactory.getArrayFromMVString(str)) {
                            try {
                                digest.add(Double.parseDouble(part));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    } else {
                        digest.add(Double.parseDouble(str));
                    }
                }
            }
            ByteBuffer output = ByteBuffer.allocate(digest.smallByteSize());
            digest.asSmallBytes(output);
            return output;
        }
    }

    private static class ValuesListExtractor
    implements FieldExtractor {
        private ValuesListExtractor() {
        }

        @Override
        public Object extract(SearchResult sr, AggregateNode aggregateNode, SearchResult.FieldMeta field, FieldExtractor.ExtractionHint fieldExtractionHint) {
            ArrayList<String> result = null;
            if (fieldExtractionHint.equals((Object)FieldExtractor.ExtractionHint.PRECOMPUTED_PRE_STAGED)) {
                SearchResult.FieldMeta newField = FieldExtractorFactory.getPrecomputedResultsFieldName(aggregateNode, field);
                result = FieldExtractorFactory.getValuesForField(sr, newField);
            } else {
                if (fieldExtractionHint.equals((Object)FieldExtractor.ExtractionHint.PRECOMPUTED_NO_PRE_STAGING)) {
                    throw new UnsupportedOperationException("Stats function '" + aggregateNode.getFunction() + "' not supported for PRECOMPUTED_NO_PRE_STAGING data");
                }
                ArrayList<String> valuesList = new ArrayList<String>();
                FieldNode fieldNode = aggregateNode.getField();
                Object val = FieldExtractorFactory.extractValueFromSearchResult(aggregateNode, field, sr);
                if (val != null) {
                    if (FieldExtractorFactory.isMultiValuedField(sr, fieldNode, field, val)) {
                        Object mvVal = sr.getFieldValue(SearchResult.FieldMeta.newFieldMeta(String.format("%s%s", "__mv_", fieldNode.getFieldName())));
                        if (mvVal == null || mvVal.toString().length() == 0) {
                            valuesList.addAll(Arrays.asList(FieldExtractorFactory.getArrayFromMVString(val.toString())));
                        } else {
                            valuesList.addAll(Arrays.asList(MultiValueFieldParser.parse(mvVal.toString())));
                        }
                    } else {
                        valuesList.add(val.toString());
                    }
                }
                result = valuesList;
            }
            return result;
        }
    }

    private static class ValuesAndCountsExtractor
    implements FieldExtractor {
        private ValuesAndCountsExtractor() {
        }

        @Override
        public Object extract(SearchResult sr, AggregateNode aggregateNode, SearchResult.FieldMeta field, FieldExtractor.ExtractionHint fieldExtractionHint) {
            Object result = null;
            if (fieldExtractionHint.equals((Object)FieldExtractor.ExtractionHint.PRECOMPUTED_PRE_STAGED)) {
                SearchResult.FieldMeta newField = FieldExtractorFactory.getPrecomputedResultsFieldName(aggregateNode, field);
                if (aggregateNode.getFunction() == AggregateFunction.ESTDC) {
                    result = FieldExtractorFactory.getHyperLogLogForValue(sr, newField);
                    FieldExtractorFactory.getValuesAndCountsForField(sr, newField);
                } else {
                    if (aggregateNode.getFunction() == AggregateFunction.ESTDC_ERROR) {
                        byte[] hllBytes = FieldExtractorFactory.getHyperLogLogForValue(sr, newField);
                        Map values = FieldExtractorFactory.getValuesAndCountsForField(sr, newField);
                        return new EdcErrorInfo(values.keySet(), hllBytes);
                    }
                    result = FieldExtractorFactory.getValuesAndCountsForField(sr, newField);
                }
            } else {
                if (fieldExtractionHint.equals((Object)FieldExtractor.ExtractionHint.PRECOMPUTED_NO_PRE_STAGING)) {
                    throw new UnsupportedOperationException("Stats function '" + aggregateNode.getFunction() + "' not supported for PRECOMPUTED_NO_PRE_STAGING data");
                }
                Object value = FieldExtractorFactory.extractValueFromSearchResult(aggregateNode, field, sr);
                FieldNode fieldNode = aggregateNode.getField();
                if (value != null) {
                    if (aggregateNode.getFunction() == AggregateFunction.ESTDC) {
                        try {
                            if (FieldExtractorFactory.isMultiValuedField(sr, fieldNode, field, value)) {
                                Object mvValue = sr.getFieldValue(SearchResult.FieldMeta.newFieldMeta(String.format("%s%s", "__mv_", fieldNode.getFieldName())));
                                Object[] valParts = mvValue == null || mvValue.toString().length() == 0 ? FieldExtractorFactory.getArrayFromMVString(value.toString()) : MultiValueFieldParser.parse(mvValue.toString());
                                if (valParts == null || valParts.length == 0) {
                                    result = FieldExtractorFactory.computeHyperLogLog("").getBytes();
                                }
                                result = FieldExtractorFactory.computeHyperLogLog(String.format("%s%s", StringUtils.join((Object[])valParts, (String)";1;"), ";1")).getBytes();
                            }
                            result = FieldExtractorFactory.computeHyperLogLog(value + ";1").getBytes();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    } else {
                        if (aggregateNode.getFunction() == AggregateFunction.ESTDC_ERROR) {
                            try {
                                if (FieldExtractorFactory.isMultiValuedField(sr, fieldNode, field, value)) {
                                    Object mvValue = sr.getFieldValue(SearchResult.FieldMeta.newFieldMeta(String.format("%s%s", "__mv_", fieldNode.getFieldName())));
                                    Object[] valParts = mvValue == null || mvValue.toString().length() == 0 ? FieldExtractorFactory.getArrayFromMVString(value.toString()) : MultiValueFieldParser.parse(mvValue.toString());
                                    HyperLogLog loglog = valParts == null || valParts.length == 0 ? FieldExtractorFactory.computeHyperLogLog("") : FieldExtractorFactory.computeHyperLogLog(String.format("%s%s", StringUtils.join((Object[])valParts, (String)";1;"), ";1"));
                                    HashSet<Object> valuesSet = new HashSet<Object>(Arrays.asList(valParts));
                                    return new EdcErrorInfo(valuesSet, loglog.getBytes());
                                }
                                HyperLogLog loglog = FieldExtractorFactory.computeHyperLogLog(value + ";1");
                                HashSet<Object> valuesSet = new HashSet<Object>();
                                valuesSet.add(value);
                                return new EdcErrorInfo(valuesSet, loglog.getBytes());
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                        HashMap<Object, Long> valCounts = new HashMap<Object, Long>();
                        if (FieldExtractorFactory.isMultiValuedField(sr, fieldNode, field, value)) {
                            Object mvValue = sr.getFieldValue(SearchResult.FieldMeta.newFieldMeta(String.format("%s%s", "__mv_", fieldNode.getFieldName())));
                            String[] parts = mvValue == null || mvValue.toString().length() == 0 ? FieldExtractorFactory.getArrayFromMVString(value.toString()) : MultiValueFieldParser.parse(mvValue.toString());
                            for (String part : parts) {
                                if (valCounts.containsKey(part)) {
                                    valCounts.put(part, (Long)valCounts.get(part) + 1L);
                                    continue;
                                }
                                valCounts.put(part, 1L);
                            }
                        } else {
                            valCounts.put(value, 1L);
                        }
                        result = valCounts;
                    }
                }
            }
            if (result == null) {
                if (AggregateFunction.ESTDC != aggregateNode.getFunction()) {
                    return new HashMap();
                }
                try {
                    return new HyperLogLog(16).getBytes();
                }
                catch (IOException e) {
                    throw new DFSException(e);
                }
            }
            return result;
        }
    }

    private static class ValuesSetExtractor
    implements FieldExtractor {
        private ValuesSetExtractor() {
        }

        @Override
        public Object extract(SearchResult sr, AggregateNode aggregateNode, SearchResult.FieldMeta field, FieldExtractor.ExtractionHint fieldExtractionHint) {
            if (fieldExtractionHint.equals((Object)FieldExtractor.ExtractionHint.PRECOMPUTED_PRE_STAGED)) {
                SearchResult.FieldMeta newField = FieldExtractorFactory.getPrecomputedResultsFieldName(aggregateNode, field);
                Map valCounts = FieldExtractorFactory.getValuesAndCountsForField(sr, newField);
                return new HashSet(valCounts.keySet());
            }
            if (fieldExtractionHint.equals((Object)FieldExtractor.ExtractionHint.PRECOMPUTED_NO_PRE_STAGING)) {
                Object result = sr.getFieldValue(SearchResult.FieldMeta.newFieldMeta(aggregateNode.getAsName()));
                if (result != null) {
                    return new HashSet<String>(Arrays.asList(FieldExtractorFactory.getArrayFromMVString(result.toString())));
                }
                return new HashSet();
            }
            HashSet<String> valuesSet = new HashSet<String>();
            Object result = FieldExtractorFactory.extractValueFromSearchResult(aggregateNode, field, sr);
            FieldNode fieldNode = aggregateNode.getField();
            if (result != null) {
                if (FieldExtractorFactory.isMultiValuedField(sr, fieldNode, field, result)) {
                    Object mvResult = sr.getFieldValue(SearchResult.FieldMeta.newFieldMeta(String.format("%s%s", "__mv_", fieldNode.getFieldName())));
                    if (mvResult == null || mvResult.toString().length() == 0) {
                        valuesSet.addAll(Arrays.asList(FieldExtractorFactory.getArrayFromMVString(result.toString())));
                    } else {
                        valuesSet.addAll(Arrays.asList(MultiValueFieldParser.parse(mvResult.toString())));
                    }
                } else {
                    valuesSet.add(result.toString());
                }
            }
            return valuesSet;
        }
    }

    private static class CountSumAndSumSquareExtractor
    implements FieldExtractor {
        private CountSumAndSumSquareExtractor() {
        }

        @Override
        public Object extract(SearchResult sr, AggregateNode aggregateNode, SearchResult.FieldMeta field, FieldExtractor.ExtractionHint fieldExtractionHint) {
            Pair<Long, Pair<Double, Double>> result;
            SearchResult.FieldMeta newField = null;
            if (fieldExtractionHint.equals((Object)FieldExtractor.ExtractionHint.PRECOMPUTED_PRE_STAGED)) {
                newField = FieldExtractorFactory.getPrecomputedResultsFieldName(aggregateNode, field);
                result = FieldExtractorFactory.getCountSumAndSumSquareForField(sr, newField);
                if (result == null) {
                    result = new Pair<Long, Pair<Double, Double>>(0L, new Pair<Double, Double>(0.0, 0.0));
                }
            } else {
                if (fieldExtractionHint.equals((Object)FieldExtractor.ExtractionHint.PRECOMPUTED_NO_PRE_STAGING)) {
                    throw new UnsupportedOperationException("Stats function '" + aggregateNode.getFunction() + "' not supported for PRECOMPUTED_NO_PRE_STAGING data");
                }
                Object value = FieldExtractorFactory.extractValueFromSearchResult(aggregateNode, field, sr);
                FieldNode fieldNode = aggregateNode.getField();
                if (FieldExtractorFactory.isMultiValuedField(sr, fieldNode, field, value)) {
                    String[] parts = FieldExtractorFactory.getArrayFromMVString(value.toString());
                    long count = 0L;
                    double sum = 0.0;
                    double sumsq = 0.0;
                    for (String part : parts) {
                        try {
                            Double doubleVal = Double.parseDouble(part);
                            sum += doubleVal.doubleValue();
                            sumsq += doubleVal * doubleVal;
                            ++count;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    result = new Pair<Long, Pair<Double, Double>>(count, new Pair<Double, Double>(sum, sumsq));
                } else {
                    if (value == null) {
                        return new Pair<Long, Pair<Double, Double>>(0L, new Pair<Double, Double>(0.0, 0.0));
                    }
                    try {
                        Double doubleVal = new BigDecimal(value.toString()).doubleValue();
                        result = new Pair<Long, Pair<Double, Double>>(1L, new Pair<Double, Double>(doubleVal, doubleVal * doubleVal));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (logger.isDebugEnabled()) {
                            logger.error((Object)String.format("Error converting field value %s to long for field %s", value, newField));
                        }
                        result = new Pair<Long, Pair<Double, Double>>(0L, new Pair<Double, Double>(0.0, 0.0));
                    }
                }
            }
            return result;
        }
    }

    private static class CountAndSumSquareExtractor
    implements FieldExtractor {
        private CountAndSumSquareExtractor() {
        }

        @Override
        public Object extract(SearchResult sr, AggregateNode aggregateNode, SearchResult.FieldMeta field, FieldExtractor.ExtractionHint fieldExtractionHint) {
            Pair<Long, Double> result;
            SearchResult.FieldMeta newField = null;
            if (fieldExtractionHint.equals((Object)FieldExtractor.ExtractionHint.PRECOMPUTED_PRE_STAGED)) {
                newField = FieldExtractorFactory.getPrecomputedResultsFieldName(aggregateNode, field);
                return FieldExtractorFactory.getCountAndSumPairForField(sr, newField, SumType.SUM_SQUARED);
            }
            if (fieldExtractionHint.equals((Object)FieldExtractor.ExtractionHint.PRECOMPUTED_NO_PRE_STAGING)) {
                Object value = sr.getFieldValue(SearchResult.FieldMeta.newFieldMeta(aggregateNode.getAsName()));
                if (value != null) {
                    try {
                        Double doubleVal = new BigDecimal(value.toString()).doubleValue();
                        result = new Pair<Long, Double>(1L, doubleVal * doubleVal);
                    }
                    catch (NumberFormatException e) {
                        result = new Pair<Long, Double>(0L, 0.0);
                    }
                } else {
                    result = new Pair<Long, Double>(0L, 0.0);
                }
            } else {
                Object value = FieldExtractorFactory.extractValueFromSearchResult(aggregateNode, field, sr);
                FieldNode fieldNode = aggregateNode.getField();
                if (FieldExtractorFactory.isMultiValuedField(sr, fieldNode, field, value)) {
                    String[] parts = FieldExtractorFactory.getArrayFromMVString(value.toString());
                    long count = 0L;
                    double sum = 0.0;
                    for (String part : parts) {
                        try {
                            Double doubleVal = Double.parseDouble(part);
                            sum += doubleVal * doubleVal;
                            ++count;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    result = new Pair<Long, Double>(count, sum);
                } else {
                    try {
                        Double doubleVal = new BigDecimal(value.toString()).doubleValue();
                        result = new Pair<Long, Double>(1L, doubleVal * doubleVal);
                    }
                    catch (Exception e) {
                        logger.debug((Object)String.format("Error converting field value %s to long for field %s", value, newField));
                        result = new Pair<Long, Double>(0L, 0.0);
                    }
                }
            }
            return result;
        }
    }

    private static class CountAndSumExtractor
    implements FieldExtractor {
        private CountAndSumExtractor() {
        }

        @Override
        public Object extract(SearchResult sr, AggregateNode aggregateNode, SearchResult.FieldMeta field, FieldExtractor.ExtractionHint fieldExtractionHint) {
            Pair<Long, Double> result;
            if (fieldExtractionHint.equals((Object)FieldExtractor.ExtractionHint.PRECOMPUTED_PRE_STAGED)) {
                SearchResult.FieldMeta newField = FieldExtractorFactory.getPrecomputedResultsFieldName(aggregateNode, field);
                result = FieldExtractorFactory.getCountAndSumPairForField(sr, newField, SumType.SUM);
            } else if (fieldExtractionHint.equals((Object)FieldExtractor.ExtractionHint.PRECOMPUTED_NO_PRE_STAGING)) {
                Object value = sr.getFieldValue(SearchResult.FieldMeta.newFieldMeta(aggregateNode.getAsName()));
                if (value != null) {
                    try {
                        result = new Pair<Long, Double>(1L, new BigDecimal(value.toString()).doubleValue());
                    }
                    catch (NumberFormatException e) {
                        result = new Pair<Long, Double>(0L, 0.0);
                    }
                } else {
                    result = new Pair<Long, Double>(0L, 0.0);
                }
            } else {
                Object value = FieldExtractorFactory.extractValueFromSearchResult(aggregateNode, field, sr);
                FieldNode fieldNode = aggregateNode.getField();
                if (FieldExtractorFactory.isMultiValuedField(sr, fieldNode, field, value)) {
                    String[] parts = FieldExtractorFactory.getArrayFromMVString(value.toString());
                    long count = 0L;
                    double sum = 0.0;
                    for (String part : parts) {
                        try {
                            Double doubleVal = Double.parseDouble(part);
                            sum += doubleVal.doubleValue();
                            ++count;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    result = new Pair<Long, Double>(count, sum);
                } else {
                    try {
                        result = value instanceof Long ? new Pair<Long, Double>(1L, Double.valueOf(((Long)value).longValue())) : (value instanceof Integer ? new Pair<Long, Double>(1L, Double.valueOf(((Integer)value).intValue())) : (value instanceof Double ? new Pair<Long, Double>(1L, (Double)value) : new Pair<Long, Double>(1L, new BigDecimal(value.toString()).doubleValue())));
                    }
                    catch (Exception e) {
                        result = new Pair<Long, Double>(0L, 0.0);
                    }
                }
            }
            return result;
        }
    }

    private static class CountFieldExtractor
    implements FieldExtractor {
        private CountFieldExtractor() {
        }

        @Override
        public Object extract(SearchResult sr, AggregateNode aggregateNode, SearchResult.FieldMeta field, FieldExtractor.ExtractionHint fieldExtractionHint) {
            Long count = 0L;
            if (fieldExtractionHint.equals((Object)FieldExtractor.ExtractionHint.PRECOMPUTED_PRE_STAGED)) {
                SearchResult.FieldMeta newField = FieldExtractorFactory.getPrecomputedResultsFieldName(aggregateNode, field);
                newField = newField.fieldName() == null || newField.fieldName().trim().isEmpty() ? newField.reset("psrsvd_gc") : newField.prepend("psrsvd_ct_");
                count = FieldExtractorFactory.parseLongWithErrorHandling(sr.getFieldValue(newField));
            } else if (fieldExtractionHint.equals((Object)FieldExtractor.ExtractionHint.PRECOMPUTED_NO_PRE_STAGING)) {
                SearchResult.FieldMeta newField = FieldExtractorFactory.getPrecomputedResultsFieldName(aggregateNode, field);
                if (newField.fieldName() == null || newField.fieldName().trim().isEmpty()) {
                    newField = newField.reset("count");
                }
                count = FieldExtractorFactory.parseLongWithErrorHandling(sr.getFieldValue(newField));
            } else {
                FieldNode fieldNode = aggregateNode.getField();
                Object result = FieldExtractorFactory.extractValueFromSearchResult(aggregateNode, field, sr);
                if (result != null && !result.toString().isEmpty()) {
                    Object mvResult;
                    count = FieldExtractorFactory.isMultiValuedField(sr, fieldNode, field, result) ? ((mvResult = sr.getFieldValue(SearchResult.FieldMeta.newFieldMeta(String.format("%s%s", "__mv_", fieldNode.getFieldName())))) == null || mvResult.toString().length() == 0 ? Long.valueOf(FieldExtractorFactory.getArrayFromMVString(result.toString()).length) : Long.valueOf(MultiValueFieldParser.parse(mvResult.toString()).length)) : Long.valueOf(1L);
                } else if (aggregateNode.getEvalFunc() == null && (fieldNode.getFieldName() == null || fieldNode.getFieldName().trim().equals(""))) {
                    count = 1L;
                }
            }
            return count;
        }
    }
}

