/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers;

import com.splunk.commons.ast.matchers.TermMatcher;
import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.commands.FieldsCommand;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.df.search.compute.ComputeEngineContext;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.Mapper;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.Transformer;
import com.splunk.df.search.compute.TransformerRegistry;
import com.splunk.df.search.compute.transformers.BaseTransformerFactory;
import com.splunk.df.search.compute.transformers.FieldExtractor;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class FieldsTransformer
implements Transformer {
    static final Logger logger = Logger.getLogger(FieldsTransformer.class);

    @Override
    public DistributedDataset transform(DistributedDataset dd, CommandNode cmd, boolean streaming, ComputeEngineContext ctx) {
        return FieldsTransformer._transform(ctx, dd, cmd, streaming);
    }

    private static DistributedDataset _transform(ComputeEngineContext ctx, DistributedDataset dd, CommandNode cmd, final boolean streaming) {
        boolean executeExternal;
        DistributedDataset outputdd = dd;
        CommandNode srcCmd = cmd.getSource();
        boolean bl = executeExternal = !BaseTransformerFactory.getInstance().canExecuteExternal(cmd, srcCmd);
        if (executeExternal) {
            logger.debug((Object)"Will execute base transformer to input create dataset");
            outputdd = BaseTransformerFactory.getInstance().transform(outputdd, cmd, ctx);
        } else {
            String cmdName = srcCmd.getCommandName();
            Transformer t = ((TransformerRegistry)ctx.get("dfs.dataset.transformer.registry")).getTransformer(srcCmd);
            outputdd = t.transform(outputdd, srcCmd, streaming, ctx);
            logger.debug((Object)("Will apply fields processing on output of transformer " + cmdName));
        }
        FieldsCommand fcmd = (FieldsCommand)cmd;
        FieldNode[] fields = fcmd.getFields();
        final TermMatcher[] fldMatchers = new TermMatcher[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            FieldNode field = fields[i];
            fldMatchers[i] = new TermMatcher(field.getFieldName());
        }
        final int fldLen = fields.length;
        final boolean remove = fcmd.isRemoveFields();
        outputdd = outputdd.transform(new Mapper(){
            private static final long serialVersionUID = 1L;

            @Override
            public SearchResult map(SearchResult sr) {
                int len = fldLen;
                HashSet<SearchResult.FieldMeta> matchedFields = new HashSet<SearchResult.FieldMeta>(len);
                SearchResult.FieldMeta[] srFlds = sr.getFieldNames();
                int srLen = srFlds.length;
                for (int i = 0; i < srLen; ++i) {
                    SearchResult.FieldMeta srFld = srFlds[i];
                    for (int j = 0; j < fldMatchers.length; ++j) {
                        TermMatcher tm = fldMatchers[j];
                        if (!tm.match(srFld.fieldName())) continue;
                        matchedFields.add(srFld);
                    }
                }
                len = matchedFields.size();
                if (remove) {
                    len = srFlds.length - len;
                }
                SearchResult.SRHashMap<SearchResult.FieldMeta, Object> data = new SearchResult.SRHashMap<SearchResult.FieldMeta, Object>(len + 1, 1.0f);
                SearchResult.FieldMeta[] retFlds = new SearchResult.FieldMeta[len];
                Object[] retVals = new Object[len];
                int ri = 0;
                for (int i = 0; i < srFlds.length; ++i) {
                    SearchResult.FieldMeta fieldName = srFlds[i];
                    boolean matchFound = matchedFields.contains(fieldName);
                    if (remove && matchFound || !remove && !matchFound) continue;
                    Object fieldVal = sr.getFieldValue(fieldName);
                    data.put(fieldName, fieldVal);
                    retFlds[ri] = fieldName;
                    retVals[ri] = fieldVal;
                    ++ri;
                }
                return SearchResultFactory.getInstance().createSearchResult(data, retFlds, retVals);
            }

            @Override
            public boolean repartition() {
                return !streaming;
            }

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return FieldExtractor.ExtractionHint.UNKNOWN;
            }

            @Override
            public String desc() {
                return "fieldsTransformerProcessing";
            }
        });
        ctx.addContext("numfields", fields.length);
        return outputdd;
    }

    @Override
    public String name() {
        return "FieldsTransformer";
    }
}

