/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.df.search.compute.ComputeEngineContext;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.Transformer;
import com.splunk.df.search.compute.TransformerRegistry;
import com.splunk.df.search.compute.transformers.BaseTransformerFactory;
import org.apache.log4j.Logger;

public class ReverseTransformer
implements Transformer {
    static final Logger logger = Logger.getLogger(ReverseTransformer.class);
    private ComputeEngineContext ctx;

    @Override
    public String name() {
        return "ReverseTransformer";
    }

    @Override
    public DistributedDataset transform(DistributedDataset dd, CommandNode cmd, boolean streaming, ComputeEngineContext ctx) {
        boolean executeExternal;
        DistributedDataset outputdd = dd;
        CommandNode source = cmd.getSource();
        if (source == null) {
            logger.debug((Object)"source for reverse command not present!");
            throw new RuntimeException("source not found for reverse command");
        }
        boolean bl = executeExternal = !BaseTransformerFactory.getInstance().canExecuteExternal(cmd, source);
        if (executeExternal) {
            outputdd = BaseTransformerFactory.getInstance().transform(outputdd, cmd, ctx);
            outputdd = outputdd.cacheDisk();
            logger.debug((Object)"Will execute base transformer to input create dataset");
        } else {
            String cmdName = source.getCommandName();
            Transformer t = ((TransformerRegistry)ctx.get("dfs.dataset.transformer.registry")).getTransformer(source);
            if (t == null) {
                logger.debug((Object)("transformer not found for command: " + cmdName));
                throw new RuntimeException("transformer not found for command: " + cmdName);
            }
            logger.debug((Object)String.format("Using source transformer - %s", cmdName));
            outputdd = t.transform(outputdd, source, streaming, ctx);
        }
        outputdd = outputdd.reverse();
        return outputdd;
    }
}

