/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers.aggregatevalues;

import com.splunk.df.search.compute.sdk.Pair;
import com.splunk.df.search.compute.transformers.aggregatevalues.AggregateValue;
import com.splunk.df.search.compute.transformers.aggregatevalues.BaseAggregateValue;
import com.splunk.df.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class TimeAndValAggregateValue
extends BaseAggregateValue {
    static final Logger logger = Logger.getLogger(TimeAndValAggregateValue.class);
    private Double time = null;
    private Object val = null;
    private COMPARE_FUNCTION compareFunction;

    private TimeAndValAggregateValue(double time, Object val, COMPARE_FUNCTION compareFunction) {
        this.time = time;
        this.val = val;
        this.compareFunction = compareFunction;
    }

    private TimeAndValAggregateValue(COMPARE_FUNCTION compareFunction) {
        this.compareFunction = compareFunction;
        this.time = compareFunction == COMPARE_FUNCTION.EARLIEST ? Double.MAX_VALUE : Double.MIN_VALUE;
    }

    public static TimeAndValAggregateValue getInstance(COMPARE_FUNCTION compareFunction) {
        return new TimeAndValAggregateValue(compareFunction);
    }

    @Override
    public AggregateValue accumulate(Object item) {
        assert (item instanceof Pair);
        Pair timeValPair = (Pair)item;
        this.compareAndSet(timeValPair);
        return this;
    }

    @Override
    public AggregateValue accumulate(AggregateValue aggregateValue) {
        assert (aggregateValue instanceof TimeAndValAggregateValue);
        Pair timeValPair = (Pair)aggregateValue.getValue();
        this.compareAndSet(timeValPair);
        return this;
    }

    private void compareAndSet(Pair<Double, Object> timeValPair) {
        boolean cmpResult;
        boolean bl = this.compareFunction == COMPARE_FUNCTION.EARLIEST ? this.time > timeValPair.first() : (cmpResult = this.time < timeValPair.first());
        if (cmpResult) {
            this.time = timeValPair.first();
            this.val = timeValPair.second();
        }
    }

    @Override
    public Object getValue() {
        return new Pair<Double, Object>(this.time, this.val);
    }

    public static void write(OutputStream os, TimeAndValAggregateValue aggrVal) throws IOException {
        Double time = aggrVal.time;
        if (time == null) {
            Utils.write(os, false);
        } else {
            Utils.write(os, true);
            Utils.write(os, time);
        }
        Object val = aggrVal.val;
        if (val == null) {
            Utils.write(os, false);
        } else {
            Utils.write(os, true);
            Utils.write(os, val);
        }
        COMPARE_FUNCTION compareFunc = aggrVal.compareFunction;
        if (compareFunc == null) {
            Utils.write(os, false);
        } else {
            Utils.write(os, true);
            Utils.write(os, compareFunc.ordinal());
        }
    }

    private static COMPARE_FUNCTION getCompareFunction(int funcId) {
        if (funcId == COMPARE_FUNCTION.EARLIEST.ordinal()) {
            return COMPARE_FUNCTION.EARLIEST;
        }
        if (funcId == COMPARE_FUNCTION.LATEST.ordinal()) {
            return COMPARE_FUNCTION.LATEST;
        }
        throw new RuntimeException(String.format("%d compare function type not supported", funcId));
    }

    public static TimeAndValAggregateValue read(InputStream is) throws IOException {
        Double time = null;
        if (Utils.readBoolean(is)) {
            time = Utils.readDouble(is);
        }
        Object val = null;
        if (Utils.readBoolean(is)) {
            val = Utils.readObject(is);
        }
        COMPARE_FUNCTION compareFunc = null;
        if (Utils.readBoolean(is)) {
            int funcId = Utils.readInt(is);
            compareFunc = TimeAndValAggregateValue.getCompareFunction(funcId);
        }
        return new TimeAndValAggregateValue(time, val, compareFunc);
    }

    public static enum COMPARE_FUNCTION {
        EARLIEST,
        LATEST;

    }
}

