/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers.external;

import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.Exploder;
import com.splunk.df.search.compute.Mapper;
import com.splunk.df.search.compute.Reducer;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.container.SoftContainerFactory;
import com.splunk.df.search.compute.container.SoftContainerService;
import com.splunk.df.search.compute.objects.SearchObject;
import com.splunk.df.search.compute.sdk.ExternalDistributedDataset;
import com.splunk.df.search.compute.sdk.ExternalDistributedOperator;
import com.splunk.df.search.compute.sdk.ExternalExploder;
import com.splunk.df.search.compute.sdk.ExternalMapper;
import com.splunk.df.search.compute.sdk.ExternalOperatorParams;
import com.splunk.df.search.compute.sdk.ExternalReducer;
import com.splunk.df.search.compute.sdk.ExternalSearchResult;
import com.splunk.df.search.compute.sdk.ExternalTransformer;
import com.splunk.df.search.compute.sdk.Pair;
import com.splunk.df.search.compute.transformers.ExternalCommandMetadataRegistry;
import com.splunk.df.search.compute.transformers.FieldExtractor;
import com.splunk.df.search.compute.transformers.external.ExternalSearchResultImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import scala.Tuple2;

public class ExternalDistributedDatasetImpl
implements ExternalDistributedDataset {
    static final Logger logger = Logger.getLogger(ExternalDistributedDatasetImpl.class);
    private final DistributedDataset edd;
    private final ExternalCommandMetadataRegistry.ExternalCommandMetadata ecm;

    public ExternalDistributedDatasetImpl(ExternalCommandMetadataRegistry.ExternalCommandMetadata ecm, DistributedDataset dd) {
        this.edd = dd;
        this.ecm = ecm;
    }

    @Override
    public ExternalDistributedDataset map(String mapperName, ExternalOperatorParams params) {
        return ExternalDistributedDatasetImpl._map(this.ecm, this.edd, mapperName, params);
    }

    private static ExternalDistributedOperator getOperator(ExternalCommandMetadataRegistry.ExternalCommandMetadata ecm, String operName) {
        SoftContainerService scs = SoftContainerFactory.instance().getService("felixSoftContainerService");
        ExternalTransformer et = scs.getTransformer(ecm, true);
        ExternalDistributedOperator edo = et.getOperator(operName);
        logger.debug((Object)String.format("Loaded external distributed operator: %s, extrans class: %s", operName, ecm.getClassName()));
        return edo;
    }

    private static ExternalDistributedDataset _map(final ExternalCommandMetadataRegistry.ExternalCommandMetadata ecm, DistributedDataset edd, final String mapperName, final ExternalOperatorParams params) {
        DistributedDataset ret = edd.transform(new Mapper(){
            private static final long serialVersionUID = 1L;

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return FieldExtractor.ExtractionHint.NOT_PRECOMPUTED;
            }

            @Override
            public SearchResult map(SearchResult sr) {
                ExternalSearchResultImpl esr = new ExternalSearchResultImpl(sr);
                ExternalMapper mapper = (ExternalMapper)ExternalDistributedDatasetImpl.getOperator(ecm, mapperName);
                ExternalSearchResult ret = mapper.map(esr, params);
                esr = (ExternalSearchResultImpl)ret;
                logger.debug((Object)String.format("Applied map operation: %s, from transformer: %s", mapperName, ecm.getClassName()));
                return esr.getSearchResult();
            }

            @Override
            public boolean repartition() {
                return false;
            }

            @Override
            public String desc() {
                return "externalDatasetMapper";
            }
        });
        return new ExternalDistributedDatasetImpl(ecm, ret);
    }

    public DistributedDataset getDistributedDataset() {
        return this.edd;
    }

    @Override
    public ExternalDistributedDataset reduce(String reducerName, ExternalOperatorParams params) {
        return ExternalDistributedDatasetImpl._reduce(this.edd, this.ecm, reducerName, params);
    }

    private static List<Pair<SearchResult, SearchResult>> toPairList(Pair<SearchResult, SearchResult> pair) {
        ArrayList<Pair<SearchResult, SearchResult>> ret = new ArrayList<Pair<SearchResult, SearchResult>>();
        ret.add(pair);
        return ret;
    }

    private static ExternalDistributedDataset _reduce(DistributedDataset edd, final ExternalCommandMetadataRegistry.ExternalCommandMetadata ecm, final String reducerName, final ExternalOperatorParams params) {
        DistributedDataset ret = edd.transform(new Reducer(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean limitResultset() {
                return false;
            }

            @Override
            public boolean metadataRequired() {
                return false;
            }

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return FieldExtractor.ExtractionHint.NOT_PRECOMPUTED;
            }

            @Override
            public List<Pair<SearchResult, SearchResult>> splits(SearchResult sr) {
                ExternalSearchResultImpl esr = new ExternalSearchResultImpl(sr);
                ExternalReducer reducer = (ExternalReducer)ExternalDistributedDatasetImpl.getOperator(ecm, reducerName);
                Pair<ExternalSearchResult, ExternalSearchResult> split = reducer.split(esr, params);
                ExternalSearchResultImpl key = (ExternalSearchResultImpl)split.first();
                ExternalSearchResultImpl val = (ExternalSearchResultImpl)split.second();
                return ExternalDistributedDatasetImpl.toPairList(new Pair<SearchResult, SearchResult>(key.getSearchResult(), val.getSearchResult()));
            }

            @Override
            public SearchResult reduce(SearchResult lhs, SearchResult rhs) {
                ExternalSearchResultImpl lhsSr = new ExternalSearchResultImpl(lhs);
                ExternalSearchResultImpl rhsSr = new ExternalSearchResultImpl(rhs);
                ExternalReducer reducer = (ExternalReducer)ExternalDistributedDatasetImpl.getOperator(ecm, reducerName);
                ExternalSearchResult esr = reducer.reduce(lhsSr, rhsSr, params);
                ExternalSearchResultImpl esrImpl = (ExternalSearchResultImpl)esr;
                return esrImpl.getSearchResult();
            }

            @Override
            public Iterator<Tuple2<SearchResult.FieldMeta, SearchResult>> gatherMetadataOnReducedData(SearchResult key, SearchResult value) {
                return null;
            }

            @Override
            public SearchResult finalizeMetadata(SearchResult sr1, SearchResult sr2) {
                return null;
            }

            @Override
            public SearchResult merge(SearchResult key, SearchResult value, Map<SearchResult.FieldMeta, SearchObject> context) {
                ExternalSearchResultImpl keySr = new ExternalSearchResultImpl(key);
                ExternalSearchResultImpl valSr = new ExternalSearchResultImpl(value);
                ExternalReducer reducer = (ExternalReducer)ExternalDistributedDatasetImpl.getOperator(ecm, reducerName);
                ExternalSearchResult ret = reducer.merge(keySr, valSr, params);
                ExternalSearchResultImpl retSrImpl = (ExternalSearchResultImpl)ret;
                return retSrImpl.getSearchResult();
            }

            @Override
            public HashSet<SearchResult.FieldMeta> reduceByFields() {
                ExternalReducer reducer = (ExternalReducer)ExternalDistributedDatasetImpl.getOperator(ecm, reducerName);
                return reducer.reduceByFields(params);
            }

            @Override
            public boolean postJoin() {
                return false;
            }

            @Override
            public Pair<SearchResult, SearchResult> downProcess(SearchResult keySr, SearchResult valSr) {
                return new Pair<SearchResult, SearchResult>(keySr, valSr);
            }

            @Override
            public boolean downReduce() {
                return false;
            }

            @Override
            public String desc() {
                return "externalDatasetReduceProcessing";
            }
        });
        return new ExternalDistributedDatasetImpl(ecm, ret);
    }

    @Override
    public ExternalDistributedDataset explode(String exploderName, ExternalOperatorParams params) {
        return ExternalDistributedDatasetImpl._explode(this.edd, this.ecm, exploderName, params);
    }

    private static ExternalDistributedDataset _explode(DistributedDataset edd, final ExternalCommandMetadataRegistry.ExternalCommandMetadata ecm, final String exploderName, final ExternalOperatorParams params) {
        DistributedDataset ret = edd.transform(new Exploder(){
            private static final long serialVersionUID = 1L;

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return FieldExtractor.ExtractionHint.NOT_PRECOMPUTED;
            }

            @Override
            public Iterator<SearchResult> explode(SearchResult sr) {
                ExternalSearchResultImpl esr = new ExternalSearchResultImpl(sr);
                ExternalExploder exploder = (ExternalExploder)ExternalDistributedDatasetImpl.getOperator(ecm, exploderName);
                final Iterable<ExternalSearchResult> iesr = exploder.explode(esr, params);
                return new Iterator<SearchResult>(){
                    final Iterator<ExternalSearchResult> iesr1;
                    {
                        this.iesr1 = iesr.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iesr1.hasNext();
                    }

                    @Override
                    public SearchResult next() {
                        ExternalSearchResult esr = this.iesr1.next();
                        ExternalSearchResultImpl esrImpl = (ExternalSearchResultImpl)esr;
                        return esrImpl.getSearchResult();
                    }

                    @Override
                    public void remove() {
                        throw new RuntimeException("remove not supported");
                    }
                };
            }

            @Override
            public String desc() {
                return "externalDDExploder";
            }
        });
        return new ExternalDistributedDatasetImpl(ecm, ret);
    }
}

