/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers.external;

import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.sdk.ExternalSearchResult;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ExternalSearchResultImpl
implements ExternalSearchResult {
    static final Logger logger = Logger.getLogger(ExternalSearchResultImpl.class);
    private static final long serialVersionUID = 1L;
    private SearchResult esr;
    private final String[] fieldNames;

    ExternalSearchResultImpl(SearchResult sr) {
        this.esr = sr;
        SearchResult.FieldMeta[] flds = sr.getFieldNames();
        int len = flds.length;
        this.fieldNames = new String[len];
        for (int i = 0; i < len; ++i) {
            this.fieldNames[i] = flds[i].fieldName();
        }
    }

    @Override
    public String[] getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public Object getFieldValue(String fieldName) {
        return this.esr.getFieldValue(SearchResult.FieldMeta.newFieldMeta(fieldName));
    }

    public SearchResult getSearchResult() {
        return this.esr;
    }

    @Override
    public ExternalSearchResult addField(String fieldName, Object fieldValue) {
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> data = this.esr.getDataMap();
        SearchResult.FieldMeta[] fieldNames = this.esr.getFieldNames();
        Object[] fieldValues = this.esr.getFieldValues();
        data.put(SearchResult.FieldMeta.newFieldMeta(fieldName), fieldValue);
        if (data.containsKey(fieldName)) {
            return new ExternalSearchResultImpl(SearchResultFactory.getInstance().createSearchResult(data, fieldNames, fieldValues));
        }
        SearchResult.FieldMeta[] retFieldNames = new SearchResult.FieldMeta[fieldNames.length + 1];
        Object[] retFieldValues = new Object[fieldValues.length + 1];
        System.arraycopy(fieldNames, 0, retFieldNames, 0, fieldNames.length);
        System.arraycopy(fieldValues, 0, retFieldValues, 0, fieldValues.length);
        retFieldNames[retFieldNames.length - 1] = SearchResult.FieldMeta.newFieldMeta(fieldName);
        retFieldValues[retFieldValues.length - 1] = fieldValue;
        return new ExternalSearchResultImpl(SearchResultFactory.getInstance().createSearchResult(data, retFieldNames, retFieldValues));
    }

    private static SearchResult.FieldMeta[] getFieldMetas(String[] fieldNames) {
        SearchResult.FieldMeta[] fieldsMeta = new SearchResult.FieldMeta[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            fieldsMeta[i] = SearchResult.FieldMeta.newFieldMeta(fieldNames[i]);
        }
        return fieldsMeta;
    }

    @Override
    public ExternalSearchResult createNew(HashMap<String, Object> data, String[] fields, Object[] values) {
        SearchResult.FieldMeta[] fieldsMeta = ExternalSearchResultImpl.getFieldMetas(fields);
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> newData = SearchResultFactory.convert(data, fieldsMeta);
        return new ExternalSearchResultImpl(SearchResultFactory.getInstance().createSearchResult(newData, fieldsMeta, values));
    }

    @Override
    public ExternalSearchResult createNew(String field, Object val) {
        return new ExternalSearchResultImpl(SearchResultFactory.getInstance().createSearchResult(SearchResult.FieldMeta.newFieldMeta(field), val));
    }

    @Override
    public ExternalSearchResult merge(ExternalSearchResult rhs) {
        ExternalSearchResultImpl lhsi = this;
        ExternalSearchResultImpl rhsi = (ExternalSearchResultImpl)rhs;
        return new ExternalSearchResultImpl(SearchResultFactory.getInstance().merge(lhsi.getSearchResult(), rhsi.getSearchResult()));
    }
}

