/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.processors;

import com.splunk.df.search.SplunkEvent;
import com.splunk.df.search.processors.EventingSearchProcessor;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

@Deprecated
public class EvalProcessor
implements EventingSearchProcessor {
    private static final long serialVersionUID = 1L;
    static final Logger logger = Logger.getLogger(EvalProcessor.class);
    private String targetField = null;
    private String sourceField = null;
    private Number value = 1;
    private Operator oper = Operator.ADD;
    private String name = null;

    private void parseArgs(String args) {
        StringTokenizer st = new StringTokenizer(args, "=+-/* ");
        this.targetField = st.nextToken();
        this.sourceField = st.nextToken();
        String valueStr = st.nextToken();
        try {
            this.value = NumberFormat.getInstance().parse(valueStr);
        }
        catch (ParseException pe) {
            logger.error((Object)("could not parse the value string: " + valueStr + "; reason: " + pe.getMessage()), (Throwable)pe);
        }
        if (args.indexOf("-") > 0) {
            this.oper = Operator.SUBTRACT;
        } else if (args.indexOf("/") > 0) {
            this.oper = Operator.DIVIDE;
        } else if (args.indexOf("*") > 0) {
            this.oper = Operator.MULTIPLY;
        }
        logger.debug((Object)("TargetField: " + this.targetField + ", sourceField: " + this.sourceField + ", value: " + this.value + ", operator: " + (Object)((Object)this.oper)));
    }

    @Override
    public void setArgs(String args) {
        try {
            this.parseArgs(args);
        }
        catch (Throwable t) {
            logger.error((Object)("Could not parse args hence setting args to null: " + args));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<SplunkEvent> process(List<SplunkEvent> events) {
        long start = System.currentTimeMillis();
        Iterator<SplunkEvent> ei = events.iterator();
        NumberFormat format = NumberFormat.getInstance();
        while (ei.hasNext()) {
            SplunkEvent event = ei.next();
            String sourceFieldValue = (String)event.get(this.sourceField);
            if (sourceFieldValue == null) continue;
            Number targetFieldValue = 0;
            try {
                Number srcFldVal = format.parse(sourceFieldValue);
                switch (this.oper) {
                    case ADD: {
                        targetFieldValue = srcFldVal.doubleValue() + this.value.doubleValue();
                        break;
                    }
                    case SUBTRACT: {
                        targetFieldValue = srcFldVal.doubleValue() - this.value.doubleValue();
                        break;
                    }
                    case MULTIPLY: {
                        targetFieldValue = srcFldVal.doubleValue() * this.value.doubleValue();
                        break;
                    }
                    default: {
                        targetFieldValue = srcFldVal.doubleValue() / this.value.doubleValue();
                    }
                }
                if (srcFldVal instanceof Long) {
                    targetFieldValue = targetFieldValue.longValue();
                }
                String targetFieldValStr = String.valueOf(targetFieldValue);
                event.put(this.targetField, targetFieldValStr);
            }
            catch (Throwable throwable) {}
        }
        logger.debug((Object)("Time taken to process " + events.size() + " events: " + (System.currentTimeMillis() - start)));
        return events;
    }

    static enum Operator {
        ADD,
        SUBTRACT,
        DIVIDE,
        MULTIPLY;

    }
}

