/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.security;

import com.splunk.df.search.DFCCallable;
import com.splunk.df.search.DFCRunnable;
import com.splunk.df.search.DFSExecutorService;
import com.splunk.df.search.DFSProtocolConstants;
import com.splunk.df.search.DFSSearchCoordinator;
import com.splunk.df.search.SearchResultInfoUtils;
import com.splunk.df.search.compute.sdk.Pair;
import com.splunk.df.security.DFSSecurityUtils;
import com.splunk.df.security.SSLConfig;
import com.splunk.df.util.DFSException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;
import org.apache.spark.SparkEnv;
import org.bouncycastle.util.encoders.Base64;
import org.json.JSONObject;

public class NIOTls {
    static final Logger logger = Logger.getLogger(NIOTls.class);
    private static final int MAX_PORT = 65535;
    private static final int LAST_RESERVED_PORT = 1023;

    public static Pair<ServerSocketChannel, Integer> bindWithRetries(String host, int startPort, int portCount, int backlog) throws IOException {
        int maxPort = startPort + portCount;
        if (portCount == 0 || maxPort > 65535) {
            maxPort = 65535;
        }
        for (int portNum = startPort; portNum <= maxPort; ++portNum) {
            InetSocketAddress serverSocketAddr = new InetSocketAddress(host, portNum);
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            try {
                serverSocketChannel.bind(serverSocketAddr, backlog);
                logger.info((Object)String.format("Start receiver port on %d", portNum));
                return new Pair<ServerSocketChannel, Integer>(serverSocketChannel, portNum);
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("Could not start receiver port on %d, reason=%s", portNum, t.getMessage()));
                if (portCount != 0 || portNum != 65535) continue;
                portNum = 1023;
                maxPort = startPort;
                continue;
            }
        }
        throw new DFSException(logger, String.format("Could not find available receiver port", new Object[0]));
    }

    private static int reservePortFromDFM(int dfsMasterPort, String dfcId) {
        try {
            Socket socketToReservePort = new Socket("127.0.0.1", dfsMasterPort);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(socketToReservePort.getOutputStream()));
            String payload = String.format("%s,%s\n", DFSProtocolConstants.PROTO_DFS_RESERVE_PORT.toString(), dfcId);
            bw.write(payload);
            bw.flush();
            logger.info((Object)"Send reservePortFromDFM Request");
            BufferedReader br = new BufferedReader(new InputStreamReader(socketToReservePort.getInputStream()));
            String line = br.readLine();
            socketToReservePort.close();
            logger.info((Object)("Received reservePortFromDFM port:" + line));
            int port = Integer.parseInt(line);
            if (port < 0) {
                throw new DFSException(logger, String.format("Could not find available receiver port", new Object[0]));
            }
            return port;
        }
        catch (Throwable t) {
            throw new DFSException(logger, "Exception in finding available receiver port.", t);
        }
    }

    public static Pair<ServerSocketChannel, Integer> bindWithReservation(String host, int dfsMasterPort, String dfcId) throws IOException {
        while (true) {
            int portNum = NIOTls.reservePortFromDFM(dfsMasterPort, dfcId);
            InetSocketAddress serverSocketAddr = new InetSocketAddress(host, portNum);
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            try {
                serverSocketChannel.bind(serverSocketAddr);
                logger.info((Object)String.format("Start binded receiver port on %d", portNum));
                return new Pair<ServerSocketChannel, Integer>(serverSocketChannel, portNum);
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("Could not start receiver port on %d, reason=%s", portNum, t.getMessage()));
                continue;
            }
            break;
        }
    }

    public static Pair<SocketChannel, SSLEngine> connectWithAuthentication(String address, int port, String tlsProtocol) throws Exception {
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(false);
        socketChannel.connect(new InetSocketAddress(address, port));
        while (!socketChannel.finishConnect()) {
            logger.debug((Object)String.format("Try to finish connecting to address %s and port %d", address, port));
            Thread.sleep(100L);
        }
        logger.info((Object)("socketChannel remote and local :: " + socketChannel.getRemoteAddress().toString() + "::" + socketChannel.getLocalAddress()));
        logger.info((Object)String.format("TLS enabled, requesting a secure connection using TLS protocol %s", tlsProtocol));
        SSLContext sslContext = SSLContext.getInstance(tlsProtocol);
        sslContext.init(null, NIOTls.trustAllCertificates(), new SecureRandom());
        SSLEngine sslEngine = sslContext.createSSLEngine(address, port);
        sslEngine.setUseClientMode(true);
        sslEngine.beginHandshake();
        NIOTls.handleHandShake(socketChannel, sslEngine);
        if (!NIOTls.authenticateDFC(socketChannel, sslEngine)) {
            logger.error((Object)"Error authenticating DFC, disconnecting the connection");
            NIOTls.disconnect(socketChannel, sslEngine);
            return null;
        }
        logger.info((Object)"TLS Handshake was successful");
        logger.info((Object)String.format("Sender connection accepted from ip: %s", socketChannel.getRemoteAddress().toString()));
        return new Pair<SocketChannel, SSLEngine>(socketChannel, sslEngine);
    }

    public static Pair<SocketChannel, SSLEngine> connect(String address, int port) throws Exception {
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(false);
        socketChannel.connect(new InetSocketAddress(address, port));
        while (!socketChannel.finishConnect()) {
            logger.debug((Object)String.format("Try to finish connecting to address %s and port %d", address, port));
            Thread.sleep(100L);
        }
        logger.info((Object)("socketChannel remote and local :: " + socketChannel.getRemoteAddress().toString() + "::" + socketChannel.getLocalAddress()));
        SSLConfig sslConfig = SSLConfig.getInstance();
        if (sslConfig.isTlsEnabled()) {
            logger.info((Object)String.format("TLS enabled, requesting a secure connection using TLS protocol %s", sslConfig.getTlsProtocol()));
            logger.info((Object)String.format("isOverrideDefaultCertificate %s --- isUseSparkSecurityConfigs %s  --- isUseNodeSpecificCertificates %s", sslConfig.isOverrideDefaultCertificate(), sslConfig.isUseSparkSecurityConfigs(), sslConfig.isUseNodeSpecificCertificates()));
            SSLContext sslContext = SSLContext.getInstance(sslConfig.getTlsProtocol());
            try {
                sslContext.init(NIOTls.getKeyManagers(sslConfig.getDFWKeystorePath(), sslConfig.getDFWKeystorePassword(), sslConfig.getDFWKeyPassword()), NIOTls.getTrusManagers(sslConfig.getDFWTruststorePath(), sslConfig.getDFWTruststorePassword()), new SecureRandom());
            }
            catch (Exception e) {
                if (!(e instanceof DFSException)) {
                    logger.error((Object)"SSLContext Failed. Please check the provided keystore, truststore, and corresponding password.");
                }
                throw e;
            }
            SSLEngine sslEngine = sslContext.createSSLEngine(address, port);
            sslEngine.setUseClientMode(true);
            sslEngine.beginHandshake();
            NIOTls.handleHandShake(socketChannel, sslEngine);
            logger.info((Object)"TLS Handshake was successful");
            logger.info((Object)String.format("Sender connection accepted from ip: %s", socketChannel.getRemoteAddress().toString()));
            return new Pair<SocketChannel, SSLEngine>(socketChannel, sslEngine);
        }
        return new Pair<SocketChannel, Object>(socketChannel, null);
    }

    public static void disconnect(SocketChannel socketChannel) throws Exception {
        if (socketChannel != null) {
            socketChannel.close();
        }
    }

    public static void disconnect(SocketChannel socketChannel, SSLEngine sslEngine) throws Exception {
        if (sslEngine != null) {
            sslEngine.closeOutbound();
        }
        if (socketChannel != null) {
            socketChannel.close();
        }
    }

    public static void accept(SelectionKey selectionKey, Selector selector, Boolean authenticateDFWDFC) throws Exception {
        NIOTls.accept(selectionKey, selector, authenticateDFWDFC, null, null);
    }

    public static void accept(SelectionKey selectionKey, Selector selector, final Boolean authenticateDFWDFC, DFSExecutorService executorService, final LinkedBlockingQueue acceptQueue) throws Exception {
        final SocketChannel socketChannel = ((ServerSocketChannel)selectionKey.channel()).accept();
        socketChannel.configureBlocking(false);
        SSLConfig sslConfig = SSLConfig.getInstance();
        if (sslConfig.isTlsEnabled()) {
            logger.info((Object)String.format("TLS enabled, accepting a secure connection using TLS protocol %s", sslConfig.getTlsProtocol()));
            logger.info((Object)String.format("isOverrideDefaultCertificate %s --- isUseSparkSecurityConfigs %s -- isUseNodeSpecificCertificates %s -- authenticateDFWDFC %s", sslConfig.isOverrideDefaultCertificate(), sslConfig.isUseSparkSecurityConfigs(), sslConfig.isUseNodeSpecificCertificates(), authenticateDFWDFC));
            SSLContext sslContext = SSLContext.getInstance(sslConfig.getTlsProtocol());
            try {
                if (authenticateDFWDFC.booleanValue()) {
                    sslContext.init(NIOTls.getKeyManagers(sslConfig.getDFCKeystorePath(), sslConfig.getDFCKeystorePassword(), sslConfig.getDFCKeyPassword()), NIOTls.trustAllCertificates(), new SecureRandom());
                } else {
                    sslContext.init(NIOTls.getKeyManagers(sslConfig.getDFCKeystorePath(), sslConfig.getDFCKeystorePassword(), sslConfig.getDFCKeyPassword()), NIOTls.getTrusManagers(sslConfig.getDFCTruststorePath(), sslConfig.getDFCTruststorePassword()), new SecureRandom());
                }
            }
            catch (Exception e) {
                if (!(e instanceof DFSException)) {
                    logger.error((Object)"SSLContext Failed. Please check the provided keystore, truststore, and corresponding password.");
                }
                throw e;
            }
            final SSLEngine sslEngine = sslContext.createSSLEngine();
            sslEngine.setUseClientMode(false);
            if (!authenticateDFWDFC.booleanValue()) {
                sslEngine.setNeedClientAuth(true);
            }
            sslEngine.beginHandshake();
            if (executorService != null) {
                executorService.submit(new DFCCallable(){

                    @Override
                    protected Object runInternal() throws Exception {
                        NIOTls.handleHandShake(socketChannel, sslEngine);
                        if (authenticateDFWDFC.booleanValue() && !NIOTls.authenticateDFSWorker(socketChannel, sslEngine)) {
                            NIOTls.disconnect(socketChannel, sslEngine);
                            throw new DFSException("Error authenticating DFW, disconnecting the connection");
                        }
                        logger.info((Object)"TLS Handshake was successful");
                        logger.info((Object)String.format("Sender connection accepted from ip: %s", socketChannel.getRemoteAddress().toString()));
                        ChannelAttachment attachment = new ChannelAttachment(sslEngine);
                        acceptQueue.put(new Pair<SocketChannel, ChannelAttachment>(socketChannel, attachment));
                        return null;
                    }

                    @Override
                    protected Object runOnFailure(Throwable t) throws Exception {
                        logger.error((Object)String.format("Failed authenticate worker - %s", socketChannel.getRemoteAddress().toString()), t);
                        return null;
                    }
                });
            } else {
                try {
                    NIOTls.handleHandShake(socketChannel, sslEngine);
                    logger.info((Object)"TLS Handshake was successful");
                    logger.info((Object)String.format("Sender connection accepted from ip: %s", socketChannel.getRemoteAddress().toString()));
                    ChannelAttachment attachment = new ChannelAttachment(sslEngine);
                    socketChannel.register(selector, 1, attachment);
                }
                catch (Exception ex) {
                    socketChannel.close();
                    logger.error((Object)String.format("TLS handshake failed from ip: %s with exception %s", socketChannel.getRemoteAddress().toString(), ex.getMessage()));
                    throw ex;
                }
            }
        } else {
            socketChannel.register(selector, 1);
        }
    }

    private static KeyManager[] getKeyManagers(String storePath, String storePassword, String keyPassword) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        try (FileInputStream inputStreamStore = new FileInputStream(storePath);){
            keyStore.load(inputStreamStore, storePassword.toCharArray());
        }
        DFSSecurityUtils.checkCertificateValidity(keyStore);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keyPassword.toCharArray());
        return keyManagerFactory.getKeyManagers();
    }

    private static TrustManager[] getTrusManagers(String storePath, String storePassword) throws Exception {
        KeyStore trustStore = KeyStore.getInstance("JKS");
        try (FileInputStream inputStreamStore = new FileInputStream(storePath);){
            trustStore.load(inputStreamStore, storePassword.toCharArray());
        }
        DFSSecurityUtils.checkCertificateValidity(trustStore);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        return trustManagerFactory.getTrustManagers();
    }

    private static void handleHandShake(SocketChannel socketChannel, SSLEngine sslEngine) throws Exception {
        int bufferSize = sslEngine.getSession().getPacketBufferSize();
        ByteBuffer appData = ByteBuffer.allocate(bufferSize);
        ByteBuffer netData = ByteBuffer.allocate(bufferSize);
        ByteBuffer peerAppData = ByteBuffer.allocate(bufferSize);
        ByteBuffer peerNetData = ByteBuffer.allocate(bufferSize);
        SSLEngineResult.HandshakeStatus handshakeStatus = sslEngine.getHandshakeStatus();
        block11: while (handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED) {
            switch (handshakeStatus) {
                case NEED_WRAP: {
                    try {
                        handshakeStatus = NIOTls.doWrap(socketChannel, sslEngine, appData, netData);
                        continue block11;
                    }
                    catch (Exception ex) {
                        if (!sslEngine.isOutboundDone()) {
                            sslEngine.closeOutbound();
                        }
                        if (!sslEngine.isInboundDone()) {
                            sslEngine.closeInbound();
                        }
                        logger.error((Object)ex.getMessage());
                        throw new IllegalStateException("Handshake failed during NEED_WRAP");
                    }
                }
                case NEED_UNWRAP: {
                    try {
                        handshakeStatus = NIOTls.doUnWrap(socketChannel, sslEngine, peerAppData, peerNetData);
                        continue block11;
                    }
                    catch (Exception ex) {
                        if (!sslEngine.isOutboundDone()) {
                            sslEngine.closeOutbound();
                        }
                        if (!sslEngine.isInboundDone()) {
                            sslEngine.closeInbound();
                        }
                        logger.error((Object)ex.getMessage());
                        throw new IllegalStateException("Handshake failed during NEED_UNWRAP");
                    }
                }
                case NEED_TASK: {
                    Runnable task;
                    ExecutorService executorService = Executors.newSingleThreadExecutor();
                    while ((task = sslEngine.getDelegatedTask()) != null) {
                        executorService.execute(task);
                    }
                    executorService.shutdown();
                    handshakeStatus = sslEngine.getHandshakeStatus();
                    continue block11;
                }
                case FINISHED: {
                    continue block11;
                }
                case NOT_HANDSHAKING: {
                    continue block11;
                }
            }
            throw new IllegalStateException("Handshake failed with invalid status: " + (Object)((Object)handshakeStatus));
        }
    }

    private static SSLEngineResult.HandshakeStatus doWrap(SocketChannel socketChannel, SSLEngine sslEngine, ByteBuffer appData, ByteBuffer netData) throws Exception {
        netData.clear();
        SSLEngineResult sslEngineResult = sslEngine.wrap(appData, netData);
        switch (sslEngineResult.getStatus()) {
            case OK: {
                netData.flip();
                while (netData.hasRemaining()) {
                    socketChannel.write(netData);
                }
                break;
            }
            case BUFFER_OVERFLOW: {
                netData = NIOTls.reallocBuffer(netData, sslEngine.getSession().getPacketBufferSize());
                break;
            }
            case BUFFER_UNDERFLOW: {
                throw new IllegalStateException("Buffer underflow during wrap");
            }
            case CLOSED: {
                netData.flip();
                while (netData.hasRemaining()) {
                    socketChannel.write(netData);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Failed to wrap with status::  " + (Object)((Object)sslEngineResult.getStatus()));
            }
        }
        return sslEngineResult.getHandshakeStatus();
    }

    private static SSLEngineResult.HandshakeStatus doUnWrap(SocketChannel socketChannel, SSLEngine sslEngine, ByteBuffer peerAppData, ByteBuffer peerNetData) throws Exception {
        if (socketChannel.read(peerNetData) < 0) {
            if (sslEngine.isInboundDone() && sslEngine.isOutboundDone()) {
                throw new IllegalStateException("Handshake failed during unwrap");
            }
            try {
                sslEngine.closeInbound();
            }
            catch (SSLException ex) {
                logger.error((Object)("Inbound engine close failed :: " + ex.getMessage()));
            }
            sslEngine.closeOutbound();
            return sslEngine.getHandshakeStatus();
        }
        peerNetData.flip();
        SSLEngineResult sslEngineResult = sslEngine.unwrap(peerNetData, peerAppData);
        peerNetData.compact();
        switch (sslEngineResult.getStatus()) {
            case OK: {
                break;
            }
            case BUFFER_OVERFLOW: {
                peerAppData = NIOTls.reallocBuffer(peerAppData, sslEngine.getSession().getApplicationBufferSize());
                logger.info((Object)"doUnWrap buffer overflow");
                break;
            }
            case BUFFER_UNDERFLOW: {
                peerNetData = NIOTls.handleBufferUnderflow(peerNetData, sslEngine.getSession().getPacketBufferSize());
                break;
            }
            case CLOSED: {
                if (sslEngine.isOutboundDone()) {
                    throw new IllegalStateException("Handshake failed during unwrap");
                }
                sslEngine.closeOutbound();
                return sslEngine.getHandshakeStatus();
            }
            default: {
                throw new IllegalStateException("Failed to unwrap with status::  " + (Object)((Object)sslEngineResult.getStatus()));
            }
        }
        return sslEngineResult.getHandshakeStatus();
    }

    public static void write(SocketChannel socketChannel, SSLEngine sslEngine, ByteBuffer appData) throws Exception {
        if (sslEngine != null) {
            appData.rewind();
            ByteBuffer netData = ByteBuffer.allocate(sslEngine.getSession().getPacketBufferSize());
            block6: while (appData.hasRemaining()) {
                netData.clear();
                SSLEngineResult sslEngineResult = sslEngine.wrap(appData, netData);
                switch (sslEngineResult.getStatus()) {
                    case OK: {
                        netData.flip();
                        while (netData.hasRemaining()) {
                            socketChannel.write(netData);
                        }
                        continue block6;
                    }
                    case BUFFER_OVERFLOW: {
                        netData = NIOTls.reallocBuffer(netData, sslEngine.getSession().getPacketBufferSize());
                        continue block6;
                    }
                    case BUFFER_UNDERFLOW: {
                        throw new SSLException("Buffer underflow occured during write");
                    }
                    case CLOSED: {
                        NIOTls.disconnect(socketChannel, sslEngine);
                        return;
                    }
                }
                throw new IllegalStateException("Write failed with invalid status: " + (Object)((Object)sslEngineResult.getStatus()));
            }
        } else {
            appData.rewind();
            while (appData.remaining() > 0) {
                socketChannel.write(appData);
            }
            appData.rewind();
        }
    }

    private static ByteBuffer reallocBuffer(ByteBuffer byteBuffer, int capacity) {
        byteBuffer = capacity > byteBuffer.capacity() ? ByteBuffer.allocate(capacity) : ByteBuffer.allocate(2 * byteBuffer.capacity());
        return byteBuffer;
    }

    private static ByteBuffer handleBufferUnderflow(ByteBuffer byteBuffer, int capacity) {
        if (capacity <= byteBuffer.limit()) {
            return byteBuffer;
        }
        ByteBuffer newBuffer = ByteBuffer.allocate(capacity);
        newBuffer.put(byteBuffer);
        return newBuffer;
    }

    public static Pair<ByteBuffer, ByteBuffer> read(SocketChannel socketChannel, SSLEngine sslEngine, ByteBuffer appData, ByteBuffer peerNetData, ByteBuffer peerAppData) throws Exception {
        long startTime = System.currentTimeMillis();
        long timeout = 20000L;
        if (sslEngine != null) {
            ByteBuffer nb;
            if (peerAppData != null && peerAppData.hasRemaining()) {
                int copyBytes = Math.min(appData.remaining(), peerAppData.remaining());
                appData.put(peerAppData.array(), peerAppData.position(), copyBytes);
                peerAppData.position(peerAppData.position() + copyBytes);
            }
            if (peerNetData != null && peerNetData.hasRemaining()) {
                while (appData.remaining() > 0) {
                    long elapsedTime;
                    int bytesRead;
                    peerAppData.clear();
                    SSLEngineResult sslEngineResult = null;
                    try {
                        sslEngineResult = sslEngine.unwrap(peerNetData, peerAppData);
                    }
                    catch (SSLException ssex) {
                        ssex.printStackTrace();
                        logger.error((Object)("-----------------Exception occurred:: " + ssex.getMessage()));
                        ByteBuffer b = ByteBuffer.allocate(peerNetData.capacity() * 2);
                        bytesRead = socketChannel.read(b);
                        logger.debug((Object)("Bytesread in exception :: " + bytesRead));
                        while (bytesRead <= 0) {
                            bytesRead = socketChannel.read(b);
                            logger.debug((Object)("Bytesread in exception :: " + bytesRead));
                        }
                        nb = ByteBuffer.allocate(peerNetData.capacity() + b.capacity() + 100);
                        nb.put(peerNetData);
                        b.flip();
                        nb.put(b);
                        peerNetData = nb;
                        peerNetData.flip();
                        continue;
                    }
                    switch (sslEngineResult.getStatus()) {
                        case OK: {
                            peerAppData.flip();
                            int copyBytes = Math.min(appData.remaining(), peerAppData.remaining());
                            appData.put(peerAppData.array(), 0, copyBytes);
                            peerAppData.position(copyBytes);
                            break;
                        }
                        case BUFFER_OVERFLOW: {
                            peerAppData = NIOTls.reallocBuffer(peerAppData, peerAppData.capacity() * 2);
                            logger.info((Object)"Buffer overflow");
                            break;
                        }
                        case BUFFER_UNDERFLOW: {
                            ByteBuffer b1 = ByteBuffer.allocate(peerNetData.capacity());
                            bytesRead = socketChannel.read(b1);
                            nb = ByteBuffer.allocate(peerNetData.remaining() + b1.position() + 10);
                            nb.put(peerNetData);
                            b1.flip();
                            nb.put(b1);
                            peerNetData = nb;
                            peerNetData.flip();
                            if (bytesRead > 0) {
                                startTime = System.currentTimeMillis();
                            }
                            if (bytesRead >= 0) break;
                            logger.debug((Object)"Read:: End of stream closing connection");
                            NIOTls.disconnect(socketChannel, sslEngine);
                            return null;
                        }
                        case CLOSED: {
                            logger.info((Object)"Close connection");
                            NIOTls.disconnect(socketChannel, sslEngine);
                            return null;
                        }
                        default: {
                            throw new IllegalStateException("Read failed with invalid status: " + (Object)((Object)sslEngineResult.getStatus()));
                        }
                    }
                    if ((elapsedTime = System.currentTimeMillis() - startTime) <= timeout) continue;
                    break;
                }
            }
            while (appData.remaining() > 0) {
                long elapsedTime;
                peerAppData = ByteBuffer.allocate(sslEngine.getSession().getApplicationBufferSize());
                peerNetData = ByteBuffer.allocate(sslEngine.getSession().getPacketBufferSize());
                int bytesRead = socketChannel.read(peerNetData);
                peerNetData.flip();
                if (bytesRead > 0) {
                    block21: while (appData.remaining() > 0) {
                        peerAppData.clear();
                        SSLEngineResult sslEngineResult = null;
                        try {
                            sslEngineResult = sslEngine.unwrap(peerNetData, peerAppData);
                        }
                        catch (SSLException sslex) {
                            sslex.printStackTrace();
                            logger.error((Object)("Exception occurred:: " + sslex.getMessage()));
                            ByteBuffer b = ByteBuffer.allocate(peerNetData.capacity() * 2);
                            bytesRead = socketChannel.read(b);
                            logger.debug((Object)("Bytesread in exception :: " + bytesRead));
                            while (bytesRead <= 0) {
                                bytesRead = socketChannel.read(b);
                                logger.debug((Object)("Bytesread in exception :: " + bytesRead));
                            }
                            nb = ByteBuffer.allocate(peerNetData.capacity() + b.capacity() + 100);
                            nb.put(peerNetData);
                            b.flip();
                            nb.put(b);
                            peerNetData = nb;
                            peerNetData.flip();
                            continue;
                        }
                        switch (sslEngineResult.getStatus()) {
                            case OK: {
                                peerAppData.flip();
                                int copyBytes = Math.min(appData.remaining(), peerAppData.remaining());
                                appData.put(peerAppData.array(), 0, copyBytes);
                                peerAppData.position(copyBytes);
                                continue block21;
                            }
                            case BUFFER_OVERFLOW: {
                                peerAppData = NIOTls.reallocBuffer(peerAppData, peerAppData.capacity() * 2);
                                logger.debug((Object)"Buffer overflow:: ");
                                continue block21;
                            }
                            case BUFFER_UNDERFLOW: {
                                ByteBuffer b1 = ByteBuffer.allocate(peerNetData.capacity());
                                bytesRead = socketChannel.read(b1);
                                nb = ByteBuffer.allocate(peerNetData.remaining() + b1.position() + 10);
                                nb.put(peerNetData);
                                b1.flip();
                                nb.put(b1);
                                peerNetData = nb;
                                peerNetData.flip();
                                if (bytesRead > 0) {
                                    startTime = System.currentTimeMillis();
                                }
                                if (bytesRead >= 0) continue block21;
                                logger.debug((Object)"Read:: End of stream closing connection");
                                NIOTls.disconnect(socketChannel, sslEngine);
                                return null;
                            }
                            case CLOSED: {
                                logger.info((Object)"Close connection");
                                NIOTls.disconnect(socketChannel, sslEngine);
                                return null;
                            }
                        }
                        throw new IllegalStateException("Read failed with invalid status: " + (Object)((Object)sslEngineResult.getStatus()));
                    }
                    if (bytesRead > 0) {
                        startTime = System.currentTimeMillis();
                    }
                } else if (bytesRead < 0) {
                    logger.debug((Object)"End of stream");
                    try {
                        sslEngine.closeInbound();
                    }
                    catch (Exception e) {
                        logger.warn((Object)"This engine was forced to close inbound, without having received the proper SSL/TLS close notification message from the peer, due to end of stream.");
                    }
                    NIOTls.disconnect(socketChannel, sslEngine);
                    return null;
                }
                if ((elapsedTime = System.currentTimeMillis() - startTime) <= timeout) continue;
                break;
            }
            appData.rewind();
        } else {
            appData.rewind();
            while (appData.remaining() > 0) {
                int bytesRead = socketChannel.read(appData);
                if (bytesRead >= 0) continue;
                NIOTls.disconnect(socketChannel);
                return null;
            }
            appData.rewind();
        }
        return new Pair<ByteBuffer, ByteBuffer>(peerNetData, peerAppData);
    }

    public static TrustManager[] trustAllCertificates() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getConf(String key) {
        String sparkConfFile = System.getenv("SPARK_HOME") + File.separator + "conf" + File.separator + "spark-defaults.conf";
        Properties prop = new Properties();
        FileInputStream confFile = null;
        String value = null;
        try {
            confFile = new FileInputStream(sparkConfFile);
            prop.load(confFile);
            value = prop.getProperty(key);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (confFile != null) {
                try {
                    ((InputStream)confFile).close();
                }
                catch (IOException e) {
                    logger.error((Object)("Exception while closing the file:: " + e.getMessage()));
                }
            }
        }
        return value;
    }

    public static boolean authenticateDFSWorker(SocketChannel socketChannel, SSLEngine sslEngine) throws Exception {
        String secret = SparkEnv.get().securityManager().getSecretKey();
        if (secret == null && ((secret = NIOTls.getConf("spark.authenticate.secret")) == null || secret.isEmpty())) {
            logger.warn((Object)"Default secret key is being used, change it immediately and enable spark authentication");
            secret = "changeme";
        }
        ByteBuffer intBuff = ByteBuffer.allocate(4);
        ByteBuffer remainingNetBuffer = null;
        ByteBuffer remainingAppBuffer = null;
        logger.info((Object)("Starting to read on the socket:: " + socketChannel.getRemoteAddress().toString() + ":: " + socketChannel.getLocalAddress().toString()));
        Pair<ByteBuffer, ByteBuffer> remainingBuffers = NIOTls.read(socketChannel, sslEngine, intBuff, remainingNetBuffer, remainingAppBuffer);
        if (remainingBuffers == null) {
            logger.error((Object)String.format("authenticateDFSWorker:: end of stream reached before finishing the authentication", new Object[0]));
            return false;
        }
        int payloadSize = intBuff.getInt(0);
        ByteBuffer payloadBuff = ByteBuffer.allocate(payloadSize);
        intBuff.clear();
        remainingNetBuffer = remainingBuffers.first();
        remainingAppBuffer = remainingBuffers.second();
        if (NIOTls.read(socketChannel, sslEngine, payloadBuff, remainingNetBuffer, remainingAppBuffer) == null) {
            logger.error((Object)String.format("authenticateDFSWorker:: end of stream reached before finishing the authentication, remote client address: %s", socketChannel.getRemoteAddress().toString()));
            return false;
        }
        String hashedSecretFromDFW = new String(Base64.decode((byte[])payloadBuff.array()));
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(secret.getBytes());
        String hashedSecret = new String(messageDigest.digest());
        if (!hashedSecret.equals(hashedSecretFromDFW)) {
            logger.error((Object)"authenticateDFSWorker: failed authentication, shared secret is not the same ");
            return false;
        }
        String newSecret = secret + secret;
        messageDigest.update(newSecret.getBytes());
        String newHashedSecret = Base64.toBase64String((byte[])messageDigest.digest());
        ByteBuffer sizeBuffer = ByteBuffer.allocate(4).putInt(newHashedSecret.getBytes().length);
        NIOTls.write(socketChannel, sslEngine, sizeBuffer);
        ByteBuffer finalPayloadBuffer = ByteBuffer.wrap(newHashedSecret.getBytes());
        NIOTls.write(socketChannel, sslEngine, finalPayloadBuffer);
        logger.info((Object)String.format("authenticateDFW:: success - %s", socketChannel.getRemoteAddress().toString()));
        return true;
    }

    public static boolean authenticateDFC(SocketChannel socketChannel, SSLEngine sslEngine) throws Exception {
        String secret = SparkEnv.get().securityManager().getSecretKey();
        if (secret == null && ((secret = NIOTls.getConf("spark.authenticate.secret")) == null || secret.isEmpty())) {
            logger.warn((Object)"Default secret key is being used, change it immediately and enable spark authentication");
            secret = "changeme";
        }
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(secret.getBytes());
        String hashedString = Base64.toBase64String((byte[])messageDigest.digest());
        ByteBuffer sendBuf = ByteBuffer.wrap(hashedString.getBytes());
        ByteBuffer sizeBuffer = ByteBuffer.allocate(4).putInt(hashedString.getBytes().length);
        NIOTls.write(socketChannel, sslEngine, sizeBuffer);
        NIOTls.write(socketChannel, sslEngine, sendBuf);
        logger.debug((Object)"Waiting for response from DFC");
        ByteBuffer intBuff = ByteBuffer.allocate(4);
        ByteBuffer remainingNetBuffer = null;
        ByteBuffer remainingAppBuffer = null;
        Pair<ByteBuffer, ByteBuffer> remainingBuffers = NIOTls.read(socketChannel, sslEngine, intBuff, remainingNetBuffer, remainingAppBuffer);
        if (remainingBuffers == null) {
            logger.error((Object)String.format("authenticateDFC:: end of stream reached before finishing the authentication", new Object[0]));
            return false;
        }
        int payloadSize = intBuff.getInt(0);
        ByteBuffer payloadBuff = ByteBuffer.allocate(payloadSize);
        intBuff.clear();
        remainingNetBuffer = remainingBuffers.first();
        remainingAppBuffer = remainingBuffers.second();
        if (NIOTls.read(socketChannel, sslEngine, payloadBuff, remainingNetBuffer, remainingAppBuffer) == null) {
            logger.error((Object)String.format("authenticateDFC:: end of stream reached before finishing the authentication, remote client address: %s", socketChannel.getRemoteAddress().toString()));
        }
        String hashedSecretReceived = new String(Base64.decode((byte[])payloadBuff.array()));
        String newSecret = secret + secret;
        messageDigest.update(newSecret.getBytes());
        String hashedString1 = new String(messageDigest.digest());
        if (hashedString1.equals(hashedSecretReceived)) {
            logger.info((Object)"authenticateDFC:: success");
            return true;
        }
        return false;
    }

    public static void createSSLConfigInfo(int keyStoreProviderPort, String host, String tlsProtocol, HashMap<String, Integer> params) {
        String sslConfigFromDFC = null;
        Pair<SocketChannel, SSLEngine> pairSoc = null;
        SSLEngine sslEngine = null;
        SocketChannel clientChannel = null;
        logger.debug((Object)("createSSLConfigInfo trying to connect to host:: " + host + " :: " + keyStoreProviderPort));
        int dfwToDfcAuthRetryTimes = params.get("DFW_TO_DFC_AUTH_RETRY_TIMES");
        logger.debug((Object)String.format("DFW to DFC Authentication retry time set to %d", dfwToDfcAuthRetryTimes));
        try {
            for (int i = 0; i < dfwToDfcAuthRetryTimes; ++i) {
                try {
                    pairSoc = NIOTls.connectWithAuthentication(host, keyStoreProviderPort, tlsProtocol);
                    break;
                }
                catch (Exception e) {
                    logger.error((Object)String.format("%s - Connection failed. Will retry %d times. Failed Reason: %s", Thread.currentThread().getName(), dfwToDfcAuthRetryTimes - 1 - i, e.getMessage()), (Throwable)e);
                    Thread.sleep(10L);
                    continue;
                }
            }
            clientChannel = (SocketChannel)pairSoc.first();
            sslEngine = pairSoc.second();
            ByteBuffer intbuff = ByteBuffer.allocate(4);
            byte[] payload = "SSLConfig".getBytes();
            int payloadSize = payload.length;
            intbuff.putInt(payloadSize);
            ByteBuffer payloadBuff = ByteBuffer.wrap(payload);
            NIOTls.write(clientChannel, sslEngine, intbuff);
            NIOTls.write(clientChannel, sslEngine, payloadBuff);
            intbuff.clear();
            logger.debug((Object)String.format("createSSLConfigInfo:: waiting to read after Payload size=%d", payloadSize));
            Pair<ByteBuffer, ByteBuffer> remainingBuffers = NIOTls.read(clientChannel, sslEngine, intbuff, null, null);
            if (remainingBuffers == null) {
                logger.error((Object)"writePayload:: read failed to get the ack");
            }
            payloadSize = intbuff.getInt(0);
            logger.debug((Object)String.format("createSSLConfigInfo:: writePayload:: Received after write payload:: %d", payloadSize));
            intbuff.clear();
            logger.info((Object)String.format("createSSLConfigInfo:: Transferred payload size=%d", payloadSize));
            payloadBuff = ByteBuffer.allocate(payloadSize);
            logger.debug((Object)("createSSLConfigInfo:: Search results received payload size=" + payloadSize));
            if (NIOTls.read(clientChannel, sslEngine, payloadBuff, remainingBuffers.first(), remainingBuffers.second()) == null) {
                logger.error((Object)String.format("End of stream reached, remote client address: %s", clientChannel.getRemoteAddress().toString()));
            }
            sslConfigFromDFC = new String(Base64.decode((byte[])payloadBuff.array()));
            NIOTls.disconnect(clientChannel, sslEngine);
        }
        catch (Exception ioe) {
            logger.error((Object)String.format("Could not connect to SSLConfig Info provider", new Object[0]), (Throwable)ioe);
            throw new DFSException("Could not connect to SSLConfig Info provider");
        }
        if (sslConfigFromDFC != null) {
            SSLConfig.getInstance(sslConfigFromDFC);
        }
    }

    public static int startSSLConfigInfoProviderServer(final String sid, String host, final DFSExecutorService executorService, final DFSSearchCoordinator dfc, final SearchResultInfoUtils searchResultsInfo, int backlogSize) throws IOException {
        final Selector selector = Selector.open();
        logger.info((Object)String.format("SSLConfig info server socket backlog size set to %d", backlogSize));
        Pair<ServerSocketChannel, Integer> socPort = NIOTls.bindWithRetries(host, 29000, 500, backlogSize);
        final ServerSocketChannel serverSocketChannel = socPort.first();
        int port = socPort.second();
        serverSocketChannel.configureBlocking(false);
        int ops = serverSocketChannel.validOps();
        serverSocketChannel.register(selector, ops, null);
        logger.debug((Object)String.format("SSLConfigInfoProviderThread started key store provider on port: %s:%d for search %s", host, port, sid));
        final LinkedBlockingQueue acceptQueue = new LinkedBlockingQueue();
        executorService.submit(new DFCCallable(){

            /*
             * Unable to fully structure code
             */
            @Override
            protected Object runInternal() throws Exception {
                try {
                    try {
                        block4: while (true) {
                            if (acceptQueue.size() != 0) {
                                pair = (Pair)acceptQueue.take();
                                ((SocketChannel)pair.first()).register(selector, 1, pair.second());
                                continue;
                            }
                            ready = selector.select(1000L);
                            if (ready <= 0) continue;
                            clientKeys = selector.selectedKeys();
                            clientKeysIter = clientKeys.iterator();
                            while (true) {
                                if (clientKeysIter.hasNext()) ** break;
                                continue block4;
                                clientKey = clientKeysIter.next();
                                clientKeysIter.remove();
                                if (!clientKey.isValid()) {
                                    NIOTls.logger.error((Object)String.format("Ignoring channel key since it is not valid: %s", new Object[]{clientKey.toString()}));
                                    continue;
                                }
                                if (clientKey.isAcceptable()) {
                                    NIOTls.accept(clientKey, selector, true, executorService, acceptQueue);
                                    continue;
                                }
                                if (!clientKey.isReadable()) continue;
                                clientSocketChannel = (SocketChannel)clientKey.channel();
                                NIOTls.logger.info((Object)String.format("SSLConfigInfoProviderThread ****** sender connection accepted from ip: %s %s", new Object[]{clientSocketChannel.getRemoteAddress().toString(), clientSocketChannel.getLocalAddress().toString()}));
                                attachment = (ChannelAttachment)clientKey.attachment();
                                sslEngine = null;
                                if (attachment != null) {
                                    sslEngine = attachment.sslEngine;
                                }
                                intbuff = ByteBuffer.allocate(4);
                                remainingNetBuffer = null;
                                remainingAppBuffer = null;
                                if (attachment != null) {
                                    remainingNetBuffer = attachment.remainingNetBuffer;
                                    remainingAppBuffer = attachment.remainingAppBuffer;
                                }
                                NIOTls.logger.debug((Object)"SSLConfigInfoProviderThread:: about to read");
                                remainingBuffers = NIOTls.read(clientSocketChannel, sslEngine, intbuff, remainingNetBuffer, remainingAppBuffer);
                                if (remainingBuffers == null) {
                                    NIOTls.logger.info((Object)String.format("End of stream reached for sid: %s", new Object[]{sid}));
                                    continue;
                                }
                                if (sslEngine != null && attachment != null) {
                                    if (remainingBuffers != null) {
                                        attachment.remainingNetBuffer = remainingBuffers.first();
                                        attachment.remainingAppBuffer = remainingBuffers.second();
                                    } else {
                                        attachment.remainingNetBuffer.clear();
                                        attachment.remainingAppBuffer.clear();
                                        attachment.remainingNetBuffer = null;
                                        attachment.remainingAppBuffer = null;
                                    }
                                }
                                payloadSize = intbuff.getInt(0);
                                intbuff.clear();
                                payloadBuff = ByteBuffer.allocate(payloadSize);
                                NIOTls.logger.debug((Object)("SSLConfigInfoProviderThread:: Search results received payload size=" + payloadSize));
                                if (attachment != null) {
                                    remainingNetBuffer = attachment.remainingNetBuffer;
                                    remainingAppBuffer = attachment.remainingAppBuffer;
                                }
                                if ((remainingBuffers = NIOTls.read(clientSocketChannel, sslEngine, payloadBuff, remainingNetBuffer, remainingAppBuffer)) == null) {
                                    NIOTls.logger.error((Object)String.format("End of stream reached, sid: %s, remote client address: %s", new Object[]{sid, clientSocketChannel.getRemoteAddress().toString()}));
                                    throw new DFSException(NIOTls.logger, String.format("Cannot get end of stream here, was expecting the entire payload of size= %d", new Object[]{payloadSize}));
                                }
                                if (sslEngine != null && attachment != null) {
                                    if (remainingBuffers != null) {
                                        attachment.remainingNetBuffer = remainingBuffers.first();
                                        attachment.remainingAppBuffer = remainingBuffers.second();
                                    } else {
                                        attachment.remainingNetBuffer.clear();
                                        attachment.remainingAppBuffer.clear();
                                        attachment.remainingNetBuffer = null;
                                        attachment.remainingAppBuffer = null;
                                    }
                                }
                                toDFWJson = new JSONObject(SSLConfig.getInstance().getToDFW());
                                toDFWJson.put("to_dfw", (Object)"true");
                                dfsSecurityToDFW = toDFWJson.getJSONObject("server").getJSONObject("dfs_security");
                                sslConfig = SSLConfig.getInstance();
                                if (!(sslConfig.isOverrideDefaultCertificate() || sslConfig.isUseSparkSecurityConfigs() || sslConfig.isUseNodeSpecificCertificates())) {
                                    dfsSecurityToDFW.put("default_dfw_keystore_password", (Object)DFSSecurityUtils.generateKeyStorePasswd());
                                }
                                sslConfigToDFW = Base64.toBase64String((byte[])toDFWJson.toString().getBytes());
                                payload = sslConfigToDFW.getBytes();
                                intbuff.putInt(payload.length);
                                NIOTls.write(clientSocketChannel, sslEngine, intbuff);
                                intbuff.clear();
                                payLoadBuffer = ByteBuffer.wrap(payload);
                                NIOTls.write(clientSocketChannel, sslEngine, payLoadBuffer);
                            }
                            break;
                        }
                    }
                    catch (Throwable t) {
                        NIOTls.logger.error((Object)String.format("This error is fatal, this error should not occur under any circumstances other than dfc shutdown: %s", new Object[]{t}));
                        throw t;
                    }
                }
                catch (Throwable var20_22) {
                    serverSocketChannel.close();
                    NIOTls.logger.error((Object)String.format("Closing keyStoreInfoProviderThread server socket %s", new Object[]{sid}));
                    throw var20_22;
                }
            }

            @Override
            protected Object runOnFailure(Throwable t) throws Exception {
                if (!(t instanceof DFSException)) {
                    t = new DFSException(String.format("Error caused while starting SSLConfig info provider server , error cause=%s", t.getMessage()));
                }
                searchResultsInfo.sendAckError(Thread.currentThread(), t);
                dfc.informMasterDfcShutdown();
                return t;
            }
        });
        return port;
    }

    public static void rdinAccept(SelectionKey selectionKey, Selector selector, ExecutorService executorService, final LinkedBlockingQueue acceptQueue) throws Exception {
        final SocketChannel socketChannel = ((ServerSocketChannel)selectionKey.channel()).accept();
        socketChannel.configureBlocking(false);
        final SSLConfig sslConfig = SSLConfig.getInstance();
        if (sslConfig.isTlsEnabled()) {
            logger.info((Object)"Requesting a secure rdin-rdout connection");
            SSLContext sslContext = SSLContext.getInstance(sslConfig.getTlsProtocol());
            try {
                sslContext.init(NIOTls.getKeyManagers(sslConfig.getDFWKeystorePath(), sslConfig.getDFWKeystorePassword(), sslConfig.getDFWKeyPassword()), NIOTls.getTrusManagers(sslConfig.getDFWTruststorePath(), sslConfig.getDFWTruststorePassword()), new SecureRandom());
            }
            catch (Exception e) {
                if (!(e instanceof DFSException)) {
                    logger.error((Object)"SSLContext Failed. Please check the provided keystore, truststore, and corresponding password.");
                }
                throw e;
            }
            final SSLEngine sslEngine = sslContext.createSSLEngine();
            sslEngine.setUseClientMode(false);
            sslEngine.setNeedClientAuth(true);
            sslEngine.beginHandshake();
            executorService.submit(new DFCRunnable(true){

                @Override
                protected void runInternal() throws Exception {
                    try {
                        NIOTls.handleHandShake(socketChannel, sslEngine);
                        if (sslConfig.isVerifySearchPeerToDFWClientCertificate()) {
                            logger.info((Object)"Check certificate common name and alternative name");
                            SSLSession sslSession = sslEngine.getSession();
                            Certificate[] certificates = sslSession.getPeerCertificates();
                            if (certificates[0] instanceof X509Certificate) {
                                if (DFSSecurityUtils.isCertificateInKeyStore(sslConfig.getDFWKeystorePath(), sslConfig.getDFWKeystorePassword(), (X509Certificate)certificates[0])) {
                                    logger.info((Object)"Rdin accept certificate validation was successful");
                                } else if (!DFSSecurityUtils.checkX509CommonAlternativeNames((X509Certificate)certificates[0], SSLConfig.getInstance())) {
                                    logger.error((Object)"Common and Alternative name check failed");
                                    NIOTls.disconnect(socketChannel, sslEngine);
                                    throw new DFSException("Rdout to DFW TLS certificate common name and alternative check failed");
                                }
                            }
                        }
                        logger.info((Object)String.format("Rdin accept Handshake was successful - Sender connection accepted from ip: %s", socketChannel.getRemoteAddress().toString()));
                        ChannelAttachment attachment = new ChannelAttachment(sslEngine);
                        acceptQueue.put(new Pair<SocketChannel, ChannelAttachment>(socketChannel, attachment));
                    }
                    catch (Exception ex) {
                        socketChannel.close();
                        logger.error((Object)("rdinAccept Failed handshake:: " + ex.getMessage()));
                        throw ex;
                    }
                }
            });
        } else {
            socketChannel.register(selector, 1);
        }
    }

    public static Pair<SocketChannel, SSLEngine> connectWithRetry(String address, int port, int retryCount) throws Exception {
        Pair<SocketChannel, SSLEngine> pairSoc = null;
        for (int i = 0; i < retryCount; ++i) {
            try {
                pairSoc = NIOTls.connect(address, port);
                break;
            }
            catch (Exception ex) {
                logger.debug((Object)String.format("Could not connect. Reason: %s", ex.getMessage()));
                Thread.sleep(10L);
                continue;
            }
        }
        return pairSoc;
    }

    public static class ChannelAttachment {
        public SSLEngine sslEngine;
        public ByteBuffer remainingNetBuffer;
        public ByteBuffer remainingAppBuffer;

        public ChannelAttachment(SSLEngine sslEngine) {
            this(sslEngine, null, null);
        }

        public ChannelAttachment(SSLEngine sslEngine, ByteBuffer remainingNetBuffer, ByteBuffer remainingAppBuffer) {
            this.sslEngine = sslEngine;
            this.remainingNetBuffer = remainingNetBuffer;
            this.remainingAppBuffer = remainingAppBuffer;
        }
    }
}

