/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.serdes;

import com.splunk.df.search.CsvSplunkEventIterable;
import com.splunk.df.search.SplunkEvent;
import com.splunk.df.serdes.WireFormatRecord;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class WireFormatParser
implements Iterable<SplunkEvent> {
    static final Logger logger = Logger.getLogger(WireFormatParser.class);
    private BufferedInputStream bos;
    private WireFormatRecord header;

    WireFormatParser(BufferedInputStream bos) throws IOException {
        this.bos = bos;
        this.header = this.nextRec();
        if (this.header == null) {
            logger.error((Object)"Wire format header cannot be empty");
            throw new RuntimeException("Unable to retrieve any header from wire format stream");
        }
    }

    private static void createWireFormatFile() throws IOException {
        String root = System.getenv("DFS_HOME");
        String csvFile = root + "/2008_0.csv";
        String wireFile = root + "/2008_0.wireformat";
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(csvFile)));
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(wireFile, false));
        CsvSplunkEventIterable csvIter = new CsvSplunkEventIterable(br);
        Iterator<SplunkEvent> i = csvIter.iterator();
        boolean first = true;
        int batchCount = 0;
        int totalEvents = 0;
        while (i.hasNext()) {
            WireFormatRecord rec;
            SplunkEvent event = i.next();
            if (first) {
                first = false;
                rec = new WireFormatRecord(event, true);
                rec.writeBytes(bos);
            }
            rec = new WireFormatRecord(event, false);
            rec.writeBytes(bos);
            ++totalEvents;
            if (++batchCount <= 80) continue;
            batchCount = 0;
            System.out.println();
        }
        bos.flush();
        bos.close();
    }

    private static void readWireFormatFile() throws IOException {
        String wireFile = System.getenv("DFS_HOME") + "/2008_0.wireformat";
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(wireFile));
        for (SplunkEvent event : new WireFormatParser(bis)) {
            System.out.println(event.toString());
        }
    }

    public static void main(String[] args) throws Exception {
        WireFormatParser.readWireFormatFile();
    }

    public WireFormatRecord getHeader() {
        return this.header;
    }

    private WireFormatRecord nextRec() throws IOException {
        if (this.bos == null) {
            logger.error((Object)"Wire format input stream is null");
            throw new RuntimeException("Wire format input stream cannot be null");
        }
        ArrayList<String> recStrings = new ArrayList<String>();
        byte[] intb = new byte[4];
        while (true) {
            Arrays.fill(intb, (byte)0);
            int bytesRead = this.bos.read(intb);
            if (bytesRead <= 0) {
                logger.warn((Object)"Could not read any more bytes hence assuming no records left in the stream");
                return null;
            }
            if (bytesRead != 4) {
                logger.error((Object)("Expected 4 bytes from the stream but got: " + bytesRead));
                throw new RuntimeException("Expected 4 bytes from stream but got " + bytesRead + " bytes");
            }
            int strLen = ByteBuffer.wrap(intb, 0, bytesRead).getInt();
            if (strLen < 0) break;
            if (strLen > Integer.MAX_VALUE) {
                logger.error((Object)("Str bytes length corrupt: " + strLen));
                throw new RuntimeException("Str bytes length corrupt: " + strLen);
            }
            byte[] strBytes = new byte[strLen];
            bytesRead = this.bos.read(strBytes);
            if (bytesRead != strLen) {
                logger.error((Object)("Expected a string of byte length " + strLen + " but recieved " + bytesRead));
                throw new RuntimeException("Expected a string of byte length: " + strLen + " but received: " + bytesRead);
            }
            String str = new String(strBytes);
            recStrings.add(str);
        }
        WireFormatRecord rec = new WireFormatRecord(recStrings);
        return rec;
    }

    @Override
    public Iterator<SplunkEvent> iterator() {
        return new Iterator<SplunkEvent>(){
            private SplunkEvent nextEvent;

            @Override
            public boolean hasNext() {
                if (this.nextEvent != null) {
                    return true;
                }
                try {
                    WireFormatRecord rec = WireFormatParser.this.nextRec();
                    if (rec == null) {
                        return false;
                    }
                    if (rec.numFields != ((WireFormatParser)WireFormatParser.this).header.numFields) {
                        logger.error((Object)("Wire format contains records which have more fields than the header; header num fields: " + ((WireFormatParser)WireFormatParser.this).header.numFields + ", rec num fields: " + rec.numFields));
                        throw new RuntimeException("Wire format contains records which have more fields than the header; header num fields: " + ((WireFormatParser)WireFormatParser.this).header.numFields + ", rec num fields: " + rec.numFields);
                    }
                    this.nextEvent = new SplunkEvent(WireFormatParser.this.header.getFields(), rec.getFields());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return true;
            }

            @Override
            public SplunkEvent next() {
                SplunkEvent ret = this.nextEvent;
                this.nextEvent = null;
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

