/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.serdes.fieldCompressed;

import com.splunk.df.serdes.fieldCompressed.ChunkHeader;
import com.splunk.df.serdes.fieldCompressed.FastSplunkEvent;
import com.splunk.df.serdes.fieldCompressed.util.DataUtil;
import com.splunk.df.serdes.fieldCompressed.util.EncodingStringCache;
import com.splunk.df.serdes.fieldCompressed.util.ReadableThresholdStringCache;
import com.splunk.df.serdes.fieldCompressed.util.WritableThresholdStringCache;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FastSplunkEventChunk
implements Iterable<FastSplunkEvent> {
    List<String> header;
    ArrayList<FastSplunkEvent> rows;
    Map<String, Integer> fieldNameToPosition = new HashMap<String, Integer>();

    public FastSplunkEventChunk() {
        this.header = new ArrayList<String>();
        this.rows = new ArrayList();
    }

    public FastSplunkEventChunk(String[] fieldNames) {
        this.header = new ArrayList<String>(fieldNames.length);
        this.rows = new ArrayList();
        for (int i = 0; i < fieldNames.length; ++i) {
            this.header.add(fieldNames[i]);
            this.fieldNameToPosition.put(fieldNames[i], i);
        }
    }

    public FastSplunkEventChunk(List<String> fieldNames) {
        this.header = new ArrayList<String>(fieldNames);
        this.rows = new ArrayList();
        for (int i = 0; i < fieldNames.size(); ++i) {
            this.fieldNameToPosition.put(fieldNames.get(i), i);
        }
    }

    public static FastSplunkEventChunk deserialize(InputStream in) throws IOException {
        ReadableThresholdStringCache retrievedCache = new ReadableThresholdStringCache();
        int size = (int)DataUtil.readBase128(in);
        assert (2 == (byte)in.read());
        ChunkHeader hdr = ChunkHeader.read(in, retrievedCache);
        FastSplunkEventChunk chunk = new FastSplunkEventChunk(hdr.fieldNames);
        int eventCount = 0;
        while (eventCount < size) {
            byte type = (byte)in.read();
            if (type == 1) {
                retrievedCache.readFrom(in);
                continue;
            }
            if (type == 0) {
                FastSplunkEvent.read(chunk, in, retrievedCache);
                ++eventCount;
                continue;
            }
            throw new RuntimeException("Unrecognized type: " + Integer.toHexString(type));
        }
        return chunk;
    }

    public List<String> getFieldNames() {
        return this.header;
    }

    public int size() {
        return this.rows.size();
    }

    public FastSplunkEvent getEvent(int pos) {
        return this.rows.get(pos);
    }

    @Override
    public Iterator<FastSplunkEvent> iterator() {
        return new Iterator<FastSplunkEvent>(){
            int position = 0;

            @Override
            public boolean hasNext() {
                return this.position < FastSplunkEventChunk.this.rows.size();
            }

            @Override
            public FastSplunkEvent next() {
                return FastSplunkEventChunk.this.rows.get(this.position++);
            }

            @Override
            public void remove() {
                if (this.position == 0) {
                    throw new IndexOutOfBoundsException("Iterator has not yet returned an event");
                }
                --this.position;
                FastSplunkEventChunk.this.rows.remove(this.position);
            }
        };
    }

    public FastSplunkEvent createEvent() {
        FastSplunkEvent event = new FastSplunkEvent();
        event.chunk = this;
        this.rows.add(event);
        return event;
    }

    public void serialize(OutputStream out) throws IOException {
        this.serialize(out, new WritableThresholdStringCache(5, 100000, 1000));
    }

    public void serialize(OutputStream masterOut, EncodingStringCache cache) throws IOException {
        DataUtil.writeBase128(masterOut, this.rows.size());
        ChunkHeader writableHeader = new ChunkHeader(this.header);
        writableHeader.write(masterOut, cache);
        ByteArrayOutputStream eventOut = new ByteArrayOutputStream();
        for (int i = 0; i < this.rows.size(); ++i) {
            eventOut.reset();
            FastSplunkEvent event = this.rows.get(i);
            event.write(eventOut, cache);
            cache.write(masterOut);
            masterOut.write(eventOut.toByteArray());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FastSplunkEventChunk chunk = (FastSplunkEventChunk)o;
        if (this.header != null ? !this.header.equals(chunk.header) : chunk.header != null) {
            return false;
        }
        return this.rows != null ? this.rows.equals(chunk.rows) : chunk.rows == null;
    }

    public int hashCode() {
        int result = this.header != null ? this.header.hashCode() : 0;
        result = 31 * result + (this.rows != null ? this.rows.hashCode() : 0);
        return result;
    }
}

