/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class IndexSpecifierMeta {
    static final Logger logger = Logger.getLogger(IndexSpecifierMeta.class);
    private final String search;
    private final BucketMeta.BucketMetaArray bucketMetaArray;
    private final Number totalEventCount;

    public IndexSpecifierMeta() {
        this.search = null;
        this.bucketMetaArray = null;
        this.totalEventCount = null;
    }

    public IndexSpecifierMeta(String search, BucketMeta.BucketMetaArray bucketMetaArray, Number totalEventCount) {
        this.search = search;
        this.bucketMetaArray = bucketMetaArray;
        this.totalEventCount = totalEventCount;
    }

    public String toString() {
        return "{" + this.getSearch() + ", " + this.getBucketMetaArray().toString() + ", " + this.getTotalEventCount() + "}\n";
    }

    public String getSearch() {
        return this.search;
    }

    public BucketMeta.BucketMetaArray getBucketMetaArray() {
        return this.bucketMetaArray;
    }

    public Number getTotalEventCount() {
        return this.totalEventCount;
    }

    public final class BucketMeta {
        private final String indexName;
        private final String serverId;
        private final String[] bucketId;
        private final Number[] bucketCount;
        private final Number eventCount;

        public BucketMeta() {
            this.indexName = null;
            this.serverId = null;
            this.bucketId = null;
            this.bucketCount = null;
            this.eventCount = null;
        }

        public BucketMeta(String indexName, String serverId, String[] bucketId, Number[] bucketCount, Number eventCount) {
            this.indexName = indexName;
            this.serverId = serverId;
            this.bucketId = bucketId;
            this.bucketCount = bucketCount;
            this.eventCount = eventCount;
        }

        public String toString() {
            return "{" + this.getIndexName() + ", " + this.getServerId() + ", " + Arrays.toString(this.getBucketId()) + ", " + Arrays.toString(this.getBucketCount()) + ", " + this.getEventCount() + "}";
        }

        public String getIndexName() {
            return this.indexName;
        }

        public String getServerId() {
            return this.serverId;
        }

        public String[] getBucketId() {
            return this.bucketId;
        }

        public Number[] getBucketCount() {
            return this.bucketCount;
        }

        public Number getEventCount() {
            return this.eventCount;
        }

        public final class BucketMetaArray {
            private final ArrayList<BucketMeta> bucketMetaArray = new ArrayList();

            public BucketMetaArray and(BucketMeta bucketMeta) {
                this.bucketMetaArray.add(bucketMeta);
                return this;
            }

            public BucketMeta[] array() {
                return this.bucketMetaArray.toArray(new BucketMeta[this.bucketMetaArray.size()]);
            }

            public String toString() {
                return Arrays.toString(this.array());
            }
        }
    }
}

