/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.util;

import com.splunk.df.util.Environment;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PropertyUtil {
    static Logger logger = Logger.getLogger(PropertyUtil.class);
    static PropertyUtil instance = null;
    Properties props;
    Environment env;

    public static PropertyUtil getInstance() {
        if (instance == null) {
            instance = new PropertyUtil(new Environment());
        }
        return instance;
    }

    public PropertyUtil(Environment environment) {
        String configFile = "config.properties";
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        this.props = new Properties();
        this.env = environment;
        try {
            InputStream stream = loader.getResourceAsStream(configFile);
            this.props.load(stream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getProperty(String key) {
        String value = this.env.getenv(this.convertToEnvName(key));
        if (value == null) {
            value = this.props.getProperty(key);
        }
        logger.info((Object)String.format("Key=%s Value=%s", key, value));
        return value;
    }

    public String convertToEnvName(String key) {
        return key.replace('.', '_').toUpperCase();
    }
}

