/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.visitors;

import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.Operator;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.ast.nodes.search.SearchAndNode;
import com.splunk.commons.ast.nodes.search.SearchComparisonNode;
import com.splunk.commons.ast.nodes.search.SearchModifier;
import com.splunk.commons.ast.nodes.search.SearchOrNode;
import com.splunk.commons.ast.nodes.search.SearchQuotableNode;
import com.splunk.commons.util.StringUtils;
import com.splunk.commons.visitors.NodeVisitor;
import com.splunk.commons.visitors.SplFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class EstimateFederatedSplFormatter
extends SplFormatter {
    private static final Set<String> set = new HashSet<String>(){
        {
            this.add("index");
            this.add("earliest");
            this.add("latest");
            this.add("_time");
            this.add("splunk_server");
            this.add("splunk_server_group");
        }
    };

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String visit(SearchComparisonNode node) {
        String lhs;
        FieldNode leftNode = node.getLhs();
        if (leftNode != null) {
            FieldNode fieldNode = leftNode;
            if (!node.is_indexed() && !set.contains(fieldNode.getFieldName())) return "";
            String retVal = fieldNode.getFieldName();
            if (StringUtils.isQuoteNeeded((String)retVal) && !retVal.startsWith("'")) {
                retVal = '\'' + retVal + '\'';
            }
            if (fieldNode.getSource() != null) {
                retVal = (String)fieldNode.getSource().getNode().accept((NodeVisitor)this) + '.' + retVal;
            }
            lhs = retVal;
        } else {
            lhs = (String)node.getLhs().accept((NodeVisitor)this);
        }
        lhs = EstimateFederatedSplFormatter.applyModifier(EstimateFederatedSplFormatter.applyQuoting(lhs, node.is_lhs_quoted()), SearchModifier.NONE);
        String rhs = node.getRhs() instanceof StringNode ? ((StringNode)node.getRhs()).getValue() : (String)node.getRhs().accept((NodeVisitor)this);
        rhs = EstimateFederatedSplFormatter.applyModifier(EstimateFederatedSplFormatter.applyQuoting(rhs, node.is_rhs_quoted()), node.getModifier());
        String op = node.getOperator().toSplOperator();
        if (node.getOperator() == Operator.EQUAL_EQUAL) {
            op = Operator.EQUAL.toSplOperator();
        }
        String retValue = String.format("%1$s%2$s%3$s", lhs, op, rhs);
        return EstimateFederatedSplFormatter.applyNegation(retValue, node.is_negated());
    }

    private static String applyQuoting(String spl, boolean quote) {
        boolean isPreQuoted;
        boolean bl = isPreQuoted = !spl.isEmpty() && spl.charAt(0) == '\"' && spl.charAt(spl.length() - 1) == '\"';
        if (quote && !isPreQuoted) {
            return '\"' + spl + '\"';
        }
        return spl;
    }

    private static String applyModifier(String spl, SearchModifier modifier) {
        switch (modifier) {
            case NONE: {
                return spl;
            }
            case CASE: {
                return "CASE(" + spl + ')';
            }
            case TERM: {
                return "TERM(" + spl + ')';
            }
        }
        throw new RuntimeException("Unexpected SearchModifier found.");
    }

    private static String applyNegation(String spl, boolean negate) {
        return negate ? "NOT " + spl : spl;
    }

    public String visit(SearchQuotableNode node) {
        return "";
    }

    public String visit(SearchOrNode node) {
        String[] args = this.asSplArray(node.getArguments(), true);
        ArrayList<String> newargs = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].isEmpty() || args[i].equals("()")) continue;
            newargs.add(args[i]);
        }
        if (newargs.size() == 0) {
            return "index=* OR index=_*";
        }
        if (newargs.size() == 1) {
            return (String)newargs.get(0);
        }
        return StringUtils.join((String)" OR ", (Object[])newargs.toArray());
    }

    public String visit(SearchAndNode node) {
        String[] args = this.asSplArray(node.getArguments(), true);
        ArrayList<String> newargs = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].isEmpty() || args[i].equals("()")) continue;
            newargs.add(args[i]);
        }
        if (newargs.size() == 0) {
            return "";
        }
        if (newargs.size() == 1) {
            return (String)newargs.get(0);
        }
        return StringUtils.join((String)" ", (Object[])newargs.toArray());
    }
}

