/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.visitors;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.commands.AddInfoCommand;
import com.splunk.commons.ast.nodes.commands.DedupCommand;
import com.splunk.commons.ast.nodes.commands.FromCommand;
import com.splunk.commons.ast.nodes.commands.HeadCommand;
import com.splunk.commons.ast.nodes.commands.JobPartitionerCommand;
import com.splunk.commons.ast.nodes.commands.JoinCommand;
import com.splunk.commons.ast.nodes.commands.NoOpCommand;
import com.splunk.commons.ast.nodes.commands.StatsCommand;
import com.splunk.commons.ast.nodes.commands.UnionCommand;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.search.IGroupBy;
import com.splunk.commons.util.VisitorUtil;
import com.splunk.commons.visitors.CommandRebuilder;
import com.splunk.commons.visitors.NodeVisitor;
import com.splunk.df.search.DFSSupportedProcessors;
import com.splunk.df.util.DFSVisitorUtil;
import com.splunk.df.visitors.PrestatsVisitor;
import com.splunk.df.visitors.StatsExpanderVisitor;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class JobPartitionerVisitor
extends CommandRebuilder {
    static final Logger logger = Logger.getLogger(JobPartitionerVisitor.class);
    private static final DFSVisitorUtil.JobStatus DEFAULT_JOB_STATUS = DFSVisitorUtil.JobStatus.UNDEFINED_STATE;
    private DFSVisitorUtil.JobStatus currentJobStatus = DEFAULT_JOB_STATUS;

    public CommandNode visit(CommandNode node) {
        NoOpCommand noop = new NoOpCommand(node);
        CommandNode partitionedQuery = this.executeNode((CommandNode)noop, noop.getSource());
        CommandNode streamingQuery = this.phaseForStreaming(partitionedQuery.getSource());
        return streamingQuery;
    }

    private CommandNode executeNode(CommandNode parent, CommandNode child) {
        if (child.getCommandName().equalsIgnoreCase("jobpartition")) {
            logger.debug((Object)("PhaseGenerationVisitor found the " + child.getSource().getCommandName()));
            return child;
        }
        CommandNode passThroughNode = child;
        CommandNode[] currentNode = child.getSources();
        int numSources = currentNode.length;
        if (numSources != 0) {
            if (numSources >= 2) {
                logger.debug((Object)("Number of sources:" + numSources + " " + child.getCommandName()));
                boolean canStatsPrecomputed = this.isStatsOfCursoredUnion(parent, currentNode);
                CommandNode multiSourcedNode = this.executeStateMachineForNode(child, parent, canStatsPrecomputed);
                CommandNode updatedParent = parent.setSource(DFSVisitorUtil.rebuild(multiSourcedNode));
                return this.upatePrecomputedInfoForStats(updatedParent, canStatsPrecomputed);
            }
            passThroughNode = this.executeNode(child, currentNode[0]);
        } else {
            this.currentJobStatus = DFSVisitorUtil.JobStatus.GENERATING_STATE;
        }
        CommandNode updatedChild = this.executeStateMachineForNode(passThroughNode, parent, false);
        CommandNode updatedParent = parent.setSource(DFSVisitorUtil.rebuild(updatedChild));
        return updatedParent;
    }

    private CommandNode executeStateMachineForNode(CommandNode node, CommandNode parent, boolean canStatsPrecomputed) {
        logger.debug((Object)("Entering executeStateMachineForNode=" + node.toString() + "currentJobStatus ==> " + this.currentJobStatus.toString()));
        switch (this.currentJobStatus) {
            case SPLUNK_SH_STATE: {
                return node;
            }
            case DFS_STATE: {
                if (!DFSSupportedProcessors.getInstance().isProcessorSupported(node.getCommandName())) {
                    JobPartitionerCommand phaseCommand = new JobPartitionerCommand(node.getSource(), this.currentJobStatus.toString());
                    CommandNode finalnode = node.setSource(DFSVisitorUtil.rebuild((CommandNode)phaseCommand));
                    this.currentJobStatus = DFSVisitorUtil.JobStatus.SPLUNK_SH_STATE;
                    return finalnode;
                }
                return node;
            }
            case UNDEFINED_STATE: 
            case GENERATING_STATE: {
                if (!node.isMultiSourced() && (node.getCommandType().equals((Object)CommandType.SP_STREAM) || node.getCommandType().equals((Object)CommandType.INTERNAL))) {
                    return node;
                }
                CommandNode currentNode = this.dispatchToCommand(node, parent, canStatsPrecomputed);
                this.currentJobStatus = DFSVisitorUtil.JobStatus.DFS_STATE;
                return currentNode;
            }
        }
        return node;
    }

    private CommandNode dispatchToCommand(CommandNode node, CommandNode parent, boolean canStatsPrecomputed) {
        boolean toAdd = node.getCommandType().ordinal() > CommandType.SP_EVENTS.ordinal();
        boolean isMultiSourced = false;
        CommandNode currentNode = null;
        switch (node.getCommandName().toLowerCase()) {
            case "stats": {
                currentNode = this.phaseForStats((StatsCommand)node);
                break;
            }
            case "union": {
                currentNode = canStatsPrecomputed ? this.phaseForUnionWithPrestats((UnionCommand)node, (StatsCommand)parent) : this.phaseForUnion((UnionCommand)node);
                isMultiSourced = true;
                break;
            }
            case "join": {
                currentNode = this.phaseForJoin((JoinCommand)node);
                isMultiSourced = true;
                break;
            }
            case "head": {
                currentNode = this.phaseForHead((HeadCommand)node);
                break;
            }
            case "dedup": {
                currentNode = this.phaseForDedup((DedupCommand)node);
                break;
            }
            case "from": {
                currentNode = this.phaseForFrom((FromCommand)node);
                break;
            }
            case "rename": 
            case "where": {
                currentNode = node;
                break;
            }
            case "tail": 
            case "sort": 
            case "reverse": {
                currentNode = this.phaseForDefaultOperator(node);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Command " + node.getCommandName() + " not supported currently.");
            }
        }
        if (toAdd && !isMultiSourced && currentNode != null) {
            return this.injectAddInfoCommand(currentNode, currentNode.getSource());
        }
        return currentNode;
    }

    private CommandNode phaseForStreaming(CommandNode node) {
        if (this.currentJobStatus != DFSVisitorUtil.JobStatus.GENERATING_STATE) {
            return node;
        }
        JobPartitionerCommand jpc = new JobPartitionerCommand(node, DFSVisitorUtil.JobStatus.GENERATING_STATE.toString());
        this.currentJobStatus = DFSVisitorUtil.JobStatus.DFS_STATE;
        return VisitorUtil.rebuild((CommandNode)jpc);
    }

    private CommandNode phaseForFrom(FromCommand node) {
        if (node.getDataset().getKind().equalsIgnoreCase("federated")) {
            JobPartitionerCommand jpc = new JobPartitionerCommand((CommandNode)node, DFSVisitorUtil.JobStatus.FSH_STATE.toString());
            this.currentJobStatus = DFSVisitorUtil.JobStatus.DFS_STATE;
            return VisitorUtil.rebuild((CommandNode)jpc);
        }
        throw new UnsupportedOperationException("DFS does not support datatype" + node.getDataset().getKind());
    }

    private CommandNode phaseForUnion(UnionCommand node) {
        CommandNode[] children = new CommandNode[node.getSources().length];
        for (int i = 0; i < children.length; ++i) {
            children[i] = (CommandNode)node.getSources()[i].accept((NodeVisitor)new JobPartitionerVisitor());
        }
        return node.setSources(children);
    }

    private CommandNode phaseForUnionWithPrestats(UnionCommand node, StatsCommand parent) {
        CommandNode[] children = new CommandNode[node.getSources().length];
        for (int i = 0; i < children.length; ++i) {
            CommandNode prestatsNode = parent.convertToPrestats(node.getSources()[i]);
            children[i] = VisitorUtil.rebuild((CommandNode)prestatsNode);
            CommandNode tmp = (CommandNode)children[i].accept((NodeVisitor)new JobPartitionerVisitor());
            children[i] = this.injectAddInfoCommand(null, tmp);
        }
        this.currentJobStatus = DFSVisitorUtil.JobStatus.DFS_STATE;
        return node.setSources(children);
    }

    private CommandNode injectAddInfoCommand(CommandNode reduceNode, CommandNode jpcNode) {
        boolean parentHasSource;
        boolean isPartitionCommand = jpcNode != null && jpcNode.getCommandName().equalsIgnoreCase("jobpartition");
        boolean bl = parentHasSource = jpcNode != null && jpcNode.getSource() != null;
        if (!isPartitionCommand || !parentHasSource) {
            throw new UnsupportedOperationException("Cannot add info to " + (jpcNode == null ? " null. " : jpcNode.toString()));
        }
        CommandNode itr = jpcNode.getSource();
        AddInfoCommand addInfoCommand = new AddInfoCommand(itr.getSource());
        itr = jpcNode.getSource();
        CommandNode newNode = itr.setSource(VisitorUtil.rebuild((CommandNode)addInfoCommand));
        itr = jpcNode;
        newNode = itr.setSource(VisitorUtil.rebuild((CommandNode)newNode));
        if (reduceNode == null) {
            return VisitorUtil.rebuild((CommandNode)newNode);
        }
        return reduceNode.setSource(VisitorUtil.rebuild((CommandNode)newNode));
    }

    private CommandNode phaseForHead(HeadCommand node) {
        CommandNode preHeadNode = node.convertToPreHead(node.getSource());
        CommandNode updatedWithPreStreaming = node.setSource(VisitorUtil.rebuild((CommandNode)preHeadNode));
        JobPartitionerCommand jpc = new JobPartitionerCommand(updatedWithPreStreaming.getSource(), this.currentJobStatus.toString());
        CommandNode finalnode = updatedWithPreStreaming.setSource(VisitorUtil.rebuild((CommandNode)jpc));
        return finalnode;
    }

    private CommandNode phaseForDefaultOperator(CommandNode node) {
        JobPartitionerCommand jpc = new JobPartitionerCommand(node.getSource(), this.currentJobStatus.toString());
        CommandNode finalNode = node.setSource(VisitorUtil.rebuild((CommandNode)jpc));
        return finalNode;
    }

    private CommandNode phaseForJoin(JoinCommand node) {
        CommandNode updatedLHS = (CommandNode)node.getSources()[0].accept((NodeVisitor)new JobPartitionerVisitor());
        CommandNode updatedRHS = (CommandNode)node.getSources()[1].accept((NodeVisitor)new JobPartitionerVisitor());
        CommandNode updatedJoin = node.setSources(new CommandNode[]{updatedLHS, updatedRHS});
        return updatedJoin;
    }

    private CommandNode phaseForStats(StatsCommand node) {
        StatsCommand expandedStatsNode = (StatsCommand)node.accept((NodeVisitor)new StatsExpanderVisitor());
        CommandNode prestatsNode = expandedStatsNode.convertToPrestats(expandedStatsNode.getSource());
        CommandNode alteredPrestatsNode = (CommandNode)prestatsNode.accept((NodeVisitor)new PrestatsVisitor());
        CommandNode updatedWithPreStreaming = expandedStatsNode.setSource(VisitorUtil.rebuild((CommandNode)alteredPrestatsNode));
        IGroupBy[] groupByFields = null;
        List groupByList = ((StatsCommand)updatedWithPreStreaming).getByFields();
        if (groupByList != null) {
            groupByFields = groupByList.toArray(new IGroupBy[0]);
        }
        FieldNode[] byFields = null;
        if (groupByFields != null) {
            byFields = (FieldNode[])Arrays.copyOf(groupByFields, groupByFields.length, FieldNode[].class);
        }
        JobPartitionerCommand phaseCommand = new JobPartitionerCommand(updatedWithPreStreaming.getSource(), this.currentJobStatus.toString(), byFields);
        CommandNode finalnode = updatedWithPreStreaming.setSource(VisitorUtil.rebuild((CommandNode)phaseCommand));
        return finalnode;
    }

    private CommandNode phaseForDedup(DedupCommand node) {
        CommandNode preDedupNode = node.convertToPreDedup(node.getSource());
        CommandNode updatedWithPreStreaming = node.setSource(VisitorUtil.rebuild((CommandNode)preDedupNode));
        FieldNode[] byFields = ((DedupCommand)updatedWithPreStreaming).getFields();
        JobPartitionerCommand jpc = new JobPartitionerCommand(updatedWithPreStreaming.getSource(), this.currentJobStatus.toString(), byFields);
        CommandNode finalnode = updatedWithPreStreaming.setSource(VisitorUtil.rebuild((CommandNode)jpc));
        return finalnode;
    }

    private CommandNode upatePrecomputedInfoForStats(CommandNode command, boolean canStatsPrecomputed) {
        if (!canStatsPrecomputed) {
            return command;
        }
        StatsCommand node = (StatsCommand)command;
        return new StatsCommand(node.getSource(), node.getAggregates(), node.getByFields(), node.getPartitions(), node.getAllnum(), node.getDelim(), node.isPrestatsMode(), node.getFieldPropertiesArray(), true);
    }

    private boolean isStatsOfCursoredUnion(CommandNode parent, CommandNode[] children) {
        if (!(parent instanceof StatsCommand)) {
            return false;
        }
        for (CommandNode child : children) {
            if (this.isLinearStreams(child)) continue;
            return false;
        }
        return true;
    }

    private boolean isLinearStreams(CommandNode node) {
        while (CommandType.SP_STREAM.equals((Object)node.getCommandType())) {
            int numChildren = node.getSources().length;
            if (numChildren == 0) {
                return true;
            }
            if (numChildren > 1) {
                return false;
            }
            node = node.getSource();
        }
        return false;
    }
}

