/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.visitors;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.commands.StatsCommand;
import com.splunk.commons.ast.nodes.expressions.AggregateFunction;
import com.splunk.commons.ast.nodes.expressions.AggregateNode;
import com.splunk.commons.visitors.CommandRebuilder;
import java.util.Arrays;
import java.util.LinkedList;

public class PrestatsVisitor
extends CommandRebuilder {
    public CommandNode visit(CommandNode node) {
        return node;
    }

    public CommandNode visit(StatsCommand node) {
        if (node.isPrestatsMode()) {
            int length = node.getAggregates().size();
            LinkedList<AggregateNode> aggregatesList = new LinkedList<AggregateNode>();
            AggregateNode replacedESTDCAggNode = null;
            boolean isDistinctCountAggPresent = false;
            for (int i = 0; i < length; ++i) {
                AggregateNode aggNode = (AggregateNode)node.getAggregates().get(i);
                if (aggNode.getFunction() == AggregateFunction.ESTDC || aggNode.getFunction() == AggregateFunction.ESTDC_ERROR) {
                    String asName = aggNode.getAsName();
                    if (asName.isEmpty()) {
                        asName = AggregateFunction.DISTINCT_COUNT.toString() + "(" + aggNode.getField().getFieldName() + ")";
                    }
                    replacedESTDCAggNode = new AggregateNode(AggregateFunction.DISTINCT_COUNT, aggNode.getField(), asName);
                    continue;
                }
                if (aggNode.getFunction() == AggregateFunction.DISTINCT_COUNT || aggNode.getFunction() == AggregateFunction.DC) {
                    isDistinctCountAggPresent = true;
                }
                aggregatesList.add(aggNode);
            }
            if (!isDistinctCountAggPresent & replacedESTDCAggNode != null) {
                aggregatesList.add(replacedESTDCAggNode);
            }
            AggregateNode[] aggregates = new AggregateNode[aggregatesList.size()];
            aggregates = aggregatesList.toArray(aggregates);
            return new StatsCommand(node.getSource(), Arrays.asList(aggregates), node.getByFields(), node.getPartitions(), node.getAllnum(), node.getDelim(), true, node.getFieldPropertiesArray(), node.isPreComputed());
        }
        return node;
    }
}

