/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.visitors;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.DedupCommand;
import com.splunk.commons.visitors.NodeVisitor;
import com.splunk.df.search.DFSSupportedProcessors;

public class RemoteFederatedQueryVisitor
extends NodeVisitor<Object> {
    private int depth = 0;
    private Boolean isDFSSupport = null;
    private Integer earliestDFSPosition = null;
    private Integer earliestNonDFSPosition = null;
    private Boolean allStreamingNonDFS = null;
    private Boolean inBranch = null;

    public RemoteFederatedQueryVisitor(boolean inBranch) {
        this.inBranch = inBranch;
    }

    public RemoteFederatedQueryVisitor() {
    }

    public boolean isQuerySupported() {
        return this.isDFSSupport;
    }

    public Object visit(Node node) {
        return null;
    }

    public Object visit(CommandNode node) {
        CommandNode[] sources;
        if (this.earliestDFSPosition != null || this.earliestNonDFSPosition != null) assert (this.earliestNonDFSPosition != this.earliestDFSPosition);
        if (this.isDFSSupport != null) {
            return null;
        }
        ++this.depth;
        if (DFSSupportedProcessors.getInstance().isProcessorSupported(node.getCommandName())) {
            DedupCommand dedupCommand;
            if (this.earliestNonDFSPosition != null && this.earliestNonDFSPosition < this.depth) {
                this.isDFSSupport = false;
                return null;
            }
            this.earliestDFSPosition = this.depth;
            if (node.getCommandName() == "dedup" && (dedupCommand = (DedupCommand)node).isConsecutive()) {
                this.earliestNonDFSPosition = this.depth;
            }
        } else {
            this.earliestNonDFSPosition = this.depth;
            if (node.getCommandType() != CommandType.SP_STREAM && node.getCommandType() != CommandType.SP_EVENTS) {
                this.isDFSSupport = false;
                this.allStreamingNonDFS = false;
            }
        }
        if ((sources = node.getSources()).length == 1) {
            sources[0].accept((NodeVisitor)this);
        } else if (sources.length > 1) {
            if (this.depth == this.earliestDFSPosition) {
                for (int i = 0; i < sources.length; ++i) {
                    RemoteFederatedQueryVisitor subVisitor = new RemoteFederatedQueryVisitor(true);
                    sources[i].accept((NodeVisitor)subVisitor);
                    if (subVisitor.isQuerySupported()) continue;
                    this.isDFSSupport = false;
                }
            } else {
                this.isDFSSupport = false;
            }
        }
        if (this.isDFSSupport != null) {
            return null;
        }
        this.isDFSSupport = this.earliestDFSPosition != null && this.earliestNonDFSPosition == null ? Boolean.valueOf(true) : (this.earliestNonDFSPosition != null && this.earliestDFSPosition == null ? (sources.length == 0 && this.allStreamingNonDFS == null && this.inBranch.booleanValue() ? Boolean.valueOf(true) : Boolean.valueOf(false)) : Boolean.valueOf(true));
        return null;
    }
}

