/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.visitors;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.commands.AddInfoCommand;
import com.splunk.commons.ast.nodes.commands.FieldProperties;
import com.splunk.commons.ast.nodes.commands.FieldsCommand;
import com.splunk.commons.ast.nodes.commands.RdInCommand;
import com.splunk.commons.ast.nodes.commands.RdOutCommand;
import com.splunk.commons.ast.nodes.commands.RenameCommand;
import com.splunk.commons.ast.nodes.commands.RenameNode;
import com.splunk.commons.ast.nodes.commands.ReverseCommand;
import com.splunk.commons.ast.nodes.commands.StatsCommand;
import com.splunk.commons.ast.nodes.commands.TableCommand;
import com.splunk.commons.ast.nodes.commands.TailCommand;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.visitors.CommandRebuilder;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;

public class RequiredFieldsOrderVisitor
extends CommandRebuilder {
    static final Logger logger = Logger.getLogger(RequiredFieldsOrderVisitor.class);
    private LinkedHashSet<String> requiredFields = new LinkedHashSet();
    private boolean isPreOrder = true;

    public RequiredFieldsOrderVisitor() {
    }

    public RequiredFieldsOrderVisitor(boolean isPreOrder) {
        this.isPreOrder = isPreOrder;
    }

    public LinkedHashSet<String> getRequiredFields() {
        return this.requiredFields;
    }

    public int getNumberOfRequiredFields() {
        return this.requiredFields.size();
    }

    private void reset() {
        this.requiredFields.clear();
    }

    public CommandNode visit(CommandNode node) {
        if (this.isPreOrder) {
            node.setRequiredFields(this.requiredFields);
        }
        super.visit(node);
        if (!this.isPreOrder) {
            node.setRequiredFields(this.requiredFields);
        }
        return node;
    }

    public CommandNode visit(StatsCommand node) {
        if (this.isPreOrder) {
            this.reset();
            node.setRequiredFields(this.requiredFields);
        }
        super.visit((CommandNode)node);
        if (!this.isPreOrder) {
            this.reset();
            node.setRequiredFields(this.requiredFields);
        }
        return node;
    }

    public CommandNode visit(RenameCommand node) {
        if (this.isPreOrder) {
            RenameNode[] renames = node.getRenames();
            LinkedHashSet<String> toRemove = new LinkedHashSet<String>();
            LinkedHashSet<String> toAdd = new LinkedHashSet<String>();
            int len = renames.length;
            for (int i = 0; i < len; ++i) {
                if (!this.requiredFields.contains(renames[i].getFieldName())) continue;
                String fromName = renames[i].getField().getFieldName();
                String toName = renames[i].getNewFieldName();
                toRemove.add(fromName);
                toAdd.add(toName);
            }
            this.requiredFields.removeAll(toRemove);
            this.requiredFields.addAll(toAdd);
        }
        super.visit((CommandNode)node);
        return node;
    }

    public CommandNode visit(FieldsCommand node) {
        if (this.isPreOrder) {
            LinkedHashSet<String> fields = new LinkedHashSet<String>();
            FieldNode[] fieldNode = node.getFields();
            for (int i = 0; i < fieldNode.length; ++i) {
                fields.add(fieldNode[i].getFieldName());
            }
            if (node.isRemoveFields()) {
                this.requiredFields.removeAll(fields);
            } else {
                this.reset();
                this.requiredFields.addAll(fields);
            }
        }
        super.visit((CommandNode)node);
        return node;
    }

    public CommandNode visit(RdInCommand node) {
        super.visit((CommandNode)node);
        return node;
    }

    public CommandNode visit(RdOutCommand node) {
        super.visit((CommandNode)node);
        return node;
    }

    public CommandNode visit(TailCommand node) {
        for (FieldProperties fp : node.getFieldPropertiesArray()) {
            if (!fp.getReferenced()) continue;
            this.requiredFields.add(fp.getName());
        }
        super.visit((CommandNode)node);
        return node;
    }

    public CommandNode visit(ReverseCommand node) {
        for (FieldProperties fp : node.getFieldPropertiesArray()) {
            if (!fp.getReferenced()) continue;
            this.requiredFields.add(fp.getName());
        }
        super.visit((CommandNode)node);
        return node;
    }

    public CommandNode visit(AddInfoCommand node) {
        super.visit((CommandNode)node);
        return node;
    }

    public CommandNode visit(TableCommand node) {
        if (this.isPreOrder) {
            LinkedHashSet<String> fields = new LinkedHashSet<String>();
            FieldNode[] fieldNode = node.getFields();
            for (int i = 0; i < fieldNode.length; ++i) {
                fields.add(fieldNode[i].getFieldName());
            }
            this.reset();
            this.requiredFields.addAll(fields);
        }
        super.visit((CommandNode)node);
        return node;
    }
}

