/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.datasource.parquet;

import com.splunk.datasource.Field;
import com.splunk.datasource.Writer;
import com.splunk.datasource.parquet.JsonWriteSupport;
import com.splunk.datasource.parquet.converter.Group;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class ParquetWriter
implements Writer {
    private org.apache.parquet.hadoop.ParquetWriter<Group> writer;
    private MessageType schema;
    private boolean errorIfFieldMissing;

    public ParquetWriter(Path file, List<Field> fields, WriterOptions options) throws IOException {
        this(file, fields, options, false);
    }

    public ParquetWriter(Path file, List<Field> fields, WriterOptions options, boolean errorIfFieldMissing) throws IOException {
        ArrayList<PrimitiveType> types = new ArrayList<PrimitiveType>();
        for (Field f : fields) {
            Type.Repetition r = Type.Repetition.OPTIONAL;
            if (f.getRepetition() == Field.Repetition.REQUIRED) {
                r = Type.Repetition.REQUIRED;
            } else if (f.getRepetition() == Field.Repetition.REPEATED) {
                r = Type.Repetition.REPEATED;
            }
            PrimitiveType.PrimitiveTypeName tn = PrimitiveType.PrimitiveTypeName.BINARY;
            if (f.getFieldType().equals(Long.TYPE)) {
                tn = PrimitiveType.PrimitiveTypeName.INT64;
            } else if (f.getFieldType().equals(Integer.TYPE)) {
                tn = PrimitiveType.PrimitiveTypeName.INT32;
            } else if (f.getFieldType().equals(Boolean.TYPE)) {
                tn = PrimitiveType.PrimitiveTypeName.BOOLEAN;
            } else if (f.getFieldType().equals(Double.TYPE)) {
                tn = PrimitiveType.PrimitiveTypeName.DOUBLE;
            } else if (f.getFieldType().equals(Float.TYPE)) {
                tn = PrimitiveType.PrimitiveTypeName.FLOAT;
            }
            types.add(new PrimitiveType(r, tn, f.getFieldName()));
        }
        this.schema = new MessageType("hunk-datamodel", types);
        this.writer = new org.apache.parquet.hadoop.ParquetWriter(file, (WriteSupport)new JsonWriteSupport(this.schema), options.codecName, options.blockSize, options.pageSize, options.dictionaryPageSize, options.enableDictionary, options.enableValidation, options.writeVersion, options.conf);
        this.errorIfFieldMissing = errorIfFieldMissing;
    }

    @Override
    public void write(Map<String, Object> keyValues) throws IOException {
        Group g = new Group((GroupType)this.schema);
        block7: for (Type f : this.schema.getFields()) {
            String k = f.getName();
            Object v = keyValues.get(k);
            if (v == null) {
                if (!this.errorIfFieldMissing) continue;
                throw new RuntimeException("Failed to find the field in keyValues map. field=" + k);
            }
            switch (f.asPrimitiveType().getPrimitiveTypeName()) {
                case DOUBLE: {
                    g.add(k, Double.parseDouble((String)v));
                    continue block7;
                }
                case FLOAT: {
                    g.add(k, Float.parseFloat((String)v));
                    continue block7;
                }
                case INT96: 
                case INT64: {
                    g.add(k, Long.parseLong((String)v));
                    continue block7;
                }
                case INT32: {
                    g.add(k, Integer.parseInt((String)v));
                    continue block7;
                }
                case BOOLEAN: {
                    g.add(k, Boolean.parseBoolean((String)v));
                    continue block7;
                }
            }
            if (f.getRepetition() == Type.Repetition.REPEATED) {
                String[] values;
                for (String s : values = (String[])v) {
                    g.add(k, s);
                }
                continue;
            }
            g.add(k, (String)v);
        }
        this.writer.write((Object)g);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public static class WriterOptions {
        public CompressionCodecName codecName;
        public int blockSize;
        public int pageSize = 0x100000;
        public int dictionaryPageSize = 0x100000;
        public boolean enableDictionary = true;
        public boolean enableValidation = false;
        public ParquetProperties.WriterVersion writeVersion = ParquetProperties.WriterVersion.PARQUET_2_0;
        public Configuration conf;

        public WriterOptions(Configuration conf) {
            this.conf = conf;
        }
    }
}

