/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.datasource.parquet.converter;

import com.splunk.util.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;

public class Group {
    private static Logger gLogger = Logger.getLogger(Group.class);
    private List<Object>[] data;
    private GroupType schema;
    private boolean hunkEvent;

    public void setHunkEvent(boolean hunkEvent) {
        this.hunkEvent = hunkEvent;
    }

    public Group(GroupType schema) {
        this.schema = schema;
        this.data = new List[schema.getFieldCount()];
    }

    public void reset() {
        if (this.data != null) {
            for (List<Object> list : this.data) {
                if (list == null) continue;
                list.clear();
            }
        }
    }

    public static boolean isMap(GroupType gt) {
        if (gt.getFieldCount() != 1) {
            return false;
        }
        Type childType = gt.getType(0);
        if (childType.isPrimitive()) {
            return false;
        }
        if (childType.asGroupType().getFieldCount() != 2) {
            return false;
        }
        if (!childType.isRepetition(Type.Repetition.REPEATED)) {
            return false;
        }
        if (OriginalType.MAP.equals((Object)gt.getOriginalType()) && OriginalType.MAP_KEY_VALUE.equals((Object)childType.getOriginalType())) {
            return true;
        }
        GroupType childGroup = childType.asGroupType();
        return "key".equals(childGroup.getFieldName(0)) && "value".equals(childGroup.getFieldName(1));
    }

    public static boolean isList(GroupType gt) {
        if (gt.getFieldCount() != 1) {
            return false;
        }
        Type childType = gt.getType(0);
        if (childType.isPrimitive()) {
            return false;
        }
        if (!childType.isRepetition(Type.Repetition.REPEATED)) {
            return false;
        }
        GroupType groupChild = childType.asGroupType();
        if (groupChild.getFieldCount() != 1) {
            return false;
        }
        return "bag".equals(groupChild.getName());
    }

    private boolean serializeMap(JsonGenerator json, boolean simplify) throws JsonGenerationException, IOException {
        if (!Group.isMap(this.schema)) {
            return false;
        }
        if (this.data[0] == null) {
            return false;
        }
        json.writeStartObject();
        for (Object v : this.data[0]) {
            Group po = (Group)v;
            Object key = po.data[0].get(0);
            Object value = po.data[1].get(0);
            if (value instanceof Group) {
                json.writeFieldName(String.valueOf(key));
                ((Group)value).serializeInto(json, simplify);
                continue;
            }
            json.writeObjectField(String.valueOf(key), value);
        }
        json.writeEndObject();
        return true;
    }

    private boolean serializeBag(JsonGenerator json, boolean simplify) throws JsonGenerationException, IOException {
        if (!Group.isList(this.schema)) {
            return false;
        }
        json.writeStartArray();
        for (Object d : this.data[0]) {
            Group bag = (Group)d;
            if (bag.data[0] == null) continue;
            Group.serializeObject(json, bag.data[0].get(0), simplify);
        }
        json.writeEndArray();
        return true;
    }

    private static void serializeObject(JsonGenerator json, Object val, boolean simplify) throws JsonGenerationException, IOException {
        if (val instanceof Group) {
            ((Group)val).serializeInto(json, simplify);
        } else {
            json.writeObject(val);
        }
    }

    public void serializeInto(JsonGenerator json) throws JsonGenerationException, IOException {
        this.serializeInto(json, false);
    }

    public void serializeHunkEventOthersField(JsonGenerator json, List<Object> value, Type schema) throws JsonProcessingException, IOException {
        if (value == null || value.isEmpty()) {
            return;
        }
        if (schema.isPrimitive() || !Group.isMap(schema.asGroupType())) {
            throw new IllegalStateException("Invalid hunk event 'others' field value. schema=" + schema);
        }
        Group othersGroup = (Group)value.get(0);
        for (Object v : othersGroup.data[0]) {
            Group mapGroup = (Group)v;
            Object key = mapGroup.data[0].get(0);
            Object val = mapGroup.data[1].get(0);
            try {
                boolean isNumber = true;
                for (char c : val.toString().toCharArray()) {
                    if (Character.isDigit(c)) continue;
                    isNumber = false;
                    break;
                }
                if (isNumber) {
                    val = Long.parseLong(val.toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            json.writeObjectField(String.valueOf(key), val);
        }
    }

    public void serializeInto(JsonGenerator json, boolean simplify) throws JsonGenerationException, IOException {
        if (simplify && this.serializeMap(json, simplify)) {
            return;
        }
        if (simplify && this.serializeBag(json, simplify)) {
            return;
        }
        json.writeStartObject();
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == null) continue;
            Type type = this.schema.getType(i);
            List<Object> value = this.data[i];
            String name = type.getName();
            if (simplify && this.hunkEvent && name.equals("others")) {
                this.serializeHunkEventOthersField(json, value, type);
                continue;
            }
            if (type.isRepetition(Type.Repetition.REPEATED)) {
                json.writeArrayFieldStart(name);
                for (Object v : value) {
                    Group.serializeObject(json, v, simplify);
                }
                json.writeEndArray();
                continue;
            }
            if (value.isEmpty()) continue;
            Object v = value.get(0);
            if (v instanceof Group) {
                json.writeFieldName(name);
                ((Group)v).serializeInto(json, simplify);
                continue;
            }
            json.writeObjectField(name, v);
        }
        json.writeEndObject();
    }

    public Group add(int fieldIndex, Binary value) {
        return this.addElement(fieldIndex, value);
    }

    public Group add(int fieldIndex, boolean value) {
        return this.addElement(fieldIndex, value);
    }

    public Group add(int fieldIndex, long value) {
        return this.addElement(fieldIndex, value);
    }

    public Group add(int fieldIndex, int value) {
        return this.addElement(fieldIndex, value);
    }

    public Group add(int fieldIndex, float value) {
        return this.addElement(fieldIndex, Float.valueOf(value));
    }

    public Group add(int fieldIndex, double value) {
        return this.addElement(fieldIndex, value);
    }

    public Group add(int fieldIndex, String value) {
        return this.addElement(fieldIndex, value);
    }

    public Group add(int fieldIndex, Group value) {
        return this.addElement(fieldIndex, value);
    }

    public Group add(String fieldName, Binary value) {
        return this.add(this.schema.getFieldIndex(fieldName), value);
    }

    public Group add(String fieldName, boolean value) {
        return this.add(this.schema.getFieldIndex(fieldName), value);
    }

    public Group add(String fieldName, long value) {
        return this.add(this.schema.getFieldIndex(fieldName), value);
    }

    public Group add(String fieldName, int value) {
        return this.add(this.schema.getFieldIndex(fieldName), value);
    }

    public Group add(String fieldName, float value) {
        return this.add(this.schema.getFieldIndex(fieldName), value);
    }

    public Group add(String fieldName, double value) {
        return this.add(this.schema.getFieldIndex(fieldName), value);
    }

    public Group add(String fieldName, String value) {
        return this.add(this.schema.getFieldIndex(fieldName), Binary.fromString((String)value));
    }

    public Group add(String fieldName, byte[] value) {
        return this.add(this.schema.getFieldIndex(fieldName), Binary.fromByteArray((byte[])value));
    }

    public Group add(String fieldName, byte[] value, int offset, int length) {
        return this.add(this.schema.getFieldIndex(fieldName), Binary.fromByteArray((byte[])value, (int)offset, (int)length));
    }

    public void writeValue(int fieldIndex, int elementIndex, RecordConsumer consumer) {
        block10: {
            Object value = this.getValue(fieldIndex, elementIndex);
            PrimitiveType.PrimitiveTypeName tname = this.schema.getType(fieldIndex).asPrimitiveType().getPrimitiveTypeName();
            boolean invalidType = false;
            try {
                switch (tname) {
                    case BINARY: {
                        consumer.addBinary((Binary)value);
                        break;
                    }
                    case BOOLEAN: {
                        consumer.addBoolean(((Boolean)value).booleanValue());
                        break;
                    }
                    case DOUBLE: {
                        consumer.addDouble(((Double)value).doubleValue());
                        break;
                    }
                    case FLOAT: {
                        consumer.addFloat(((Float)value).floatValue());
                        break;
                    }
                    case INT32: {
                        consumer.addInteger(((Integer)value).intValue());
                        break;
                    }
                    case INT64: 
                    case INT96: {
                        consumer.addLong(((Long)value).longValue());
                        break;
                    }
                    default: {
                        invalidType = true;
                        throw new UnsupportedOperationException("Cannot write value of type " + tname);
                    }
                }
            }
            catch (RuntimeException e) {
                if (invalidType) break block10;
                gLogger.error((Object)("Failed to consume value. fieldIndex=" + fieldIndex + ", elementIndex=" + elementIndex + ", value=" + value + ", schema=" + this.schema));
                throw e;
            }
        }
    }

    public Group addGroup(String fieldName) {
        if (gLogger.isDebugEnabled()) {
            gLogger.debug((Object)("add group " + fieldName + " to " + this.schema.getName()));
        }
        int fieldIndex = this.schema.getFieldIndex(fieldName);
        Group value = new Group(this.schema.getType(fieldName).asGroupType());
        this.add(fieldIndex, value);
        return value;
    }

    private Group addElement(int fieldIndex, Object value) {
        Preconditions.checkIndexInBound(this.data, fieldIndex);
        if (this.data[fieldIndex] == null) {
            Type type = this.schema.getType(fieldIndex);
            int sizeHint = type.isRepetition(Type.Repetition.REPEATED) ? 4 : 1;
            this.data[fieldIndex] = new ArrayList<Object>(sizeHint);
        }
        if (!this.schema.getType(fieldIndex).isRepetition(Type.Repetition.REPEATED) && !this.data[fieldIndex].isEmpty()) {
            throw new IllegalStateException("Field " + this.schema.getFieldName(fieldIndex) + " is not repeated and should not have multiple values. schema=" + this.schema);
        }
        this.data[fieldIndex].add(value);
        return this;
    }

    public Object getValue(int fieldIndex, int elementIndex) {
        Preconditions.checkIndexInBound(this.data, fieldIndex);
        List<Object> list = this.data[fieldIndex];
        if (list == null) {
            return null;
        }
        try {
            Preconditions.checkIndexInBound(list, elementIndex);
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage() + ", fieldIndex=" + fieldIndex + ", fieldName=" + this.schema.getFieldName(fieldIndex), e.getCause());
        }
        return list.get(elementIndex);
    }

    public int getFieldRepetitionCount(int fieldIndex) {
        Preconditions.checkIndexInBound(this.data, fieldIndex);
        List<Object> list = this.data[fieldIndex];
        return list == null ? 0 : list.size();
    }

    public GroupType getType() {
        return this.schema;
    }

    public Group getGroup(int fieldIndex, int elementIndex) {
        Preconditions.checkIndexInBound(this.schema.getFields(), fieldIndex);
        if (this.schema.getType(fieldIndex).isPrimitive()) {
            throw new RuntimeException("field " + this.schema.getFieldName(fieldIndex) + " is not a group field");
        }
        return (Group)this.getValue(fieldIndex, elementIndex);
    }

    public Group getGroup(String fieldName, int elementIndex) {
        return this.getGroup(this.schema.getFieldIndex(fieldName), elementIndex);
    }

    public void toString(String indent, StringBuilder result) {
        assert (this.data.length == this.schema.getFieldCount());
        for (int i = 0; i < this.schema.getFieldCount(); ++i) {
            if (this.data[i] == null) continue;
            for (Object o : this.data[i]) {
                if (o == null || !(o instanceof Group)) {
                    result.append(indent).append(this.schema.getFieldName(i)).append(":").append(o instanceof Binary ? ((Binary)o).toStringUsingUTF8() : o.toString()).append('\n');
                    continue;
                }
                result.append(indent).append(this.schema.getFieldName(i)).append('\n');
                ((Group)o).toString(indent + "  ", result);
            }
        }
    }
}

