/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.journal;

import java.io.IOException;
import java.io.Writer;

public class SimpleCsvWriter {
    public static char DEFAULT_SEPARATOR_CHAR = (char)9;
    public static char DEFAULT_ESCAPE_CHAR = (char)92;
    private static final char quoteChar = '\"';
    private static final char newLine = '\n';
    private char separatorChar = DEFAULT_SEPARATOR_CHAR;
    private char escapeChar = DEFAULT_ESCAPE_CHAR;
    private Writer writer;

    public SimpleCsvWriter(Writer writer) {
        this.writer = writer;
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void writeRow(Object ... fields) throws IOException {
        this.writeRowNoLineBreak(fields);
        this.endRow();
    }

    public void writeRowNoLineBreak(Object ... fields) throws IOException {
        if (fields.length == 0) {
            return;
        }
        this.writeFirstFieldInRow(fields[0]);
        for (int i = 1; i < fields.length; ++i) {
            this.writeSubequentField(fields[i]);
        }
    }

    public void writeSubequentField(Object field) throws IOException {
        this.writer.write(this.separatorChar);
        this.writeFirstFieldInRow(field);
    }

    public void writeFirstFieldInRow(Object field) throws IOException {
        if (null != field) {
            if (field instanceof Number) {
                this.writer.write(field.toString());
            } else {
                String str = String.valueOf(field);
                char[] chs = ((String)field).toCharArray();
                int begin = 0;
                int end = 0;
                this.writer.write(34);
                while (-1 < (end = this.idxOfNextEscapableChar(str, begin))) {
                    this.writer.write(chs, begin, end - begin);
                    this.writer.write(this.escapeChar);
                    this.writer.write(chs[end]);
                    begin = end + 1;
                }
                this.writer.write(chs, begin, chs.length - begin);
                this.writer.write(34);
            }
        }
    }

    public void endRow() throws IOException {
        this.writer.write(10);
    }

    public char getSeparatorChar() {
        return this.separatorChar;
    }

    public void setSeparatorChar(char separatorChar) {
        this.separatorChar = separatorChar;
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public void setEscapeChar(char escapeChar) {
        this.escapeChar = escapeChar;
    }

    private int idxOfNextEscapableChar(String text, int beginFrom) {
        int idx1 = text.indexOf(34, beginFrom);
        int idx2 = text.indexOf(this.escapeChar, beginFrom);
        if (-1 == idx1) {
            return idx2;
        }
        if (-1 == idx2) {
            return idx1;
        }
        return Math.min(idx1, idx2);
    }
}

