/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.input;

import com.splunk.mr.input.BaseSplitGenerator;
import com.splunk.mr.input.FileStatusExt;
import com.splunk.mr.input.ObjectAcceptor;
import com.splunk.mr.input.VirtualIndex;
import com.splunk.mr.input.VixInputSplit;
import com.splunk.util.WildcardList;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.log4j.Logger;

public class FileSplitGenerator
extends BaseSplitGenerator {
    private static Logger gLogger = Logger.getLogger(FileSplitGenerator.class);
    protected static final double SPLIT_SLOP = 1.1;
    protected boolean forceNotSplit = false;
    protected boolean dmaSplit = false;

    public void forceNotSplit() {
        this.forceNotSplit = true;
    }

    protected boolean sendSplitToAcceptor(ObjectAcceptor<VixInputSplit> acceptor, VixInputSplit split) throws IOException {
        return acceptor.accept(split);
    }

    @Override
    public boolean generateSplits(FileStatusExt fileExt, JobContext job, VirtualIndex vix, ObjectAcceptor<VixInputSplit> acceptor) throws IOException {
        if (fileExt.isDir()) {
            return true;
        }
        super.init(fileExt, job, vix, acceptor);
        Path path = fileExt.getPath();
        long length = fileExt.getLen();
        try {
            FileSystem fs = path.getFileSystem(job.getConfiguration());
            BlockLocation[] blkLocations = fs.getFileBlockLocations((FileStatus)fileExt, 0L, length);
            if (length != 0L && blkLocations.length == 0) {
                throw new IOException(String.format("No block location information could be found for file=%s, size=%d", fileExt.getPath().toUri().toString(), fileExt.getLen()));
            }
            if (length != 0L && !this.forceNotSplit && FileSplitGenerator.isSplitable(this._codecFactory, path)) {
                FileSplit fis;
                long minSplitSize = Math.max(1L, this.getMinSplitSize(vix, fileExt.getInputId()));
                long maxSplitSize = this.getMaxSplitSize(vix, fileExt.getInputId());
                long blockSize = fileExt.getBlockSize();
                long splitSize = FileSplitGenerator.computeSplitSize(maxSplitSize, minSplitSize, blockSize);
                long bytesRemaining = length;
                while ((double)bytesRemaining / (double)splitSize > 1.1) {
                    int blkIndex = FileSplitGenerator.getBlockIndex(blkLocations, length - bytesRemaining);
                    FileSplit fis2 = new FileSplit(path, length - bytesRemaining, splitSize, blkLocations[blkIndex].getHosts());
                    if (!this.sendSplitToAcceptor(acceptor, new VixInputSplit((InputSplit)fis2, fileExt))) {
                        return false;
                    }
                    bytesRemaining -= splitSize;
                }
                if (!(bytesRemaining == 0L && length % splitSize != 0L || this.sendSplitToAcceptor(acceptor, new VixInputSplit((InputSplit)(fis = new FileSplit(path, length - bytesRemaining, bytesRemaining > splitSize ? 2L * splitSize : splitSize, blkLocations[blkLocations.length - 1].getHosts())), fileExt)))) {
                    return false;
                }
            } else if (length != 0L) {
                FileSplit fis = new FileSplit(path, 0L, length, blkLocations[0].getHosts());
                if (!this.sendSplitToAcceptor(acceptor, new VixInputSplit((InputSplit)fis, fileExt))) {
                    return false;
                }
            } else {
                FileSplit fis = null;
                fis = blkLocations != null && blkLocations.length > 0 ? new FileSplit(path, 0L, fileExt.getBlockSize(), blkLocations[0].getHosts()) : new FileSplit(path, 0L, length, new String[0]);
                if (!this.sendSplitToAcceptor(acceptor, new VixInputSplit((InputSplit)fis, fileExt))) {
                    return false;
                }
            }
        }
        catch (IOException ex) {
            gLogger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return true;
    }

    public long getMinSplitSize(VirtualIndex vix, String inputId) {
        return Long.parseLong(this.getConfVar(inputId, "split.minsize", "1"));
    }

    public long getMaxSplitSize(VirtualIndex vix, String inputId) {
        return Long.parseLong(this.getConfVar(inputId, "split.maxsize", String.valueOf(Long.MAX_VALUE)));
    }

    public static boolean isSplitable(CompressionCodecFactory codecFactory, Path file) {
        CompressionCodec codec = codecFactory.getCodec(file);
        if (null == codec) {
            return true;
        }
        Class<?> splitableCompressionCodecClass = null;
        try {
            splitableCompressionCodecClass = Class.forName("org.apache.hadoop.io.compress.SplittableCompressionCodec");
            return splitableCompressionCodecClass.isAssignableFrom(codec.getClass());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static long computeSplitSize(long goalSize, long minSize, long blockSize) {
        return Math.max(minSize, Math.min(goalSize, blockSize));
    }

    public static int getBlockIndex(BlockLocation[] blkLocations, long offset) {
        for (int i = 0; i < blkLocations.length; ++i) {
            if (blkLocations[i].getOffset() > offset || offset >= blkLocations[i].getOffset() + blkLocations[i].getLength()) continue;
            return i;
        }
        BlockLocation last = blkLocations[blkLocations.length - 1];
        long fileLength = last.getOffset() + last.getLength() - 1L;
        throw new IllegalArgumentException("Offset " + offset + " is outside of file (0.." + fileLength + ")");
    }

    @Override
    public String getName() {
        return "file";
    }

    public boolean isDmaSplit() {
        return this.dmaSplit;
    }

    public void setDmaSplit(boolean dmaSplit) {
        this.dmaSplit = dmaSplit;
    }

    protected void modifyRequiredFieldsForDMASplit() {
        String referencedFields;
        Configuration _conf = this._job.getConfiguration();
        if (gLogger.isDebugEnabled()) {
            gLogger.debug((Object)("DMA Split found.. Referenced fields::" + _conf.get("splunk.search.datamodel.referencedfields")));
        }
        if ((referencedFields = _conf.get("splunk.search.datamodel.referencedfields")) != null && !referencedFields.isEmpty()) {
            gLogger.debug((Object)"Changing required fields to reference fields");
            this._requiredFields = new WildcardList(Arrays.asList(referencedFields.split(",")));
        } else {
            this._requiredFields = new WildcardList(Collections.<String>emptyList());
        }
        if (!this._requiredFields.contains("_time")) {
            this._requiredFields.addEntry("_time");
        }
    }
}

