/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.input;

import com.splunk.mr.input.BaseSplunkRecordReader;
import com.splunk.mr.input.VixInputSplit;
import com.splunk.util.TextUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;

public class SplunkJournalRecordReader
extends BaseSplunkRecordReader {
    private static Logger gLogger = Logger.getLogger(SplunkJournalRecordReader.class);
    private final Pattern FILE_PATTERN = Pattern.compile("/journal\\.gz$");
    private FSDataInputStream is;
    private long fileOffset;
    private long fileSize;
    private byte[] data = null;
    private String splitId;
    private int dSize;

    @Override
    public String getName() {
        return "splunkjournal";
    }

    @Override
    public Pattern getFilePattern() {
        return this.FILE_PATTERN;
    }

    @Override
    public void vixInitialize(VixInputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        Path p = split.getPath();
        FileSystem fs = p.getFileSystem(context.getConfiguration());
        this.is = fs.open(split.getPath());
        this.fileOffset = 0L;
        this.fileSize = split.getLength();
        this.dSize = 0;
        this.splitId = split.getSplitId();
        this.data = new byte[Integer.parseInt(this.getConfVar("buffer.size", "65536"))];
        gLogger.debug((Object)("Initializing record reader for split:" + this.splitId + ", buffer.size=" + this.data.length));
    }

    public Text getCurrentKey() throws IOException, InterruptedException {
        return null;
    }

    public Text getCurrentValue() throws IOException, InterruptedException {
        Text val = new Text();
        TextUtil.setTextInternals(val, this.data, this.dSize);
        return val;
    }

    @Override
    public void serializeCurrentValueTo(OutputStream out) throws IOException, InterruptedException {
        if (this.dSize == 0) {
            return;
        }
        out.write(this.data, 0, this.dSize);
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        int bytesRead;
        if (this.fileOffset > this.fileSize) {
            return false;
        }
        if (gLogger.isDebugEnabled()) {
            gLogger.debug((Object)("Getting next value at fileoffset=" + this.fileOffset + ", split=" + this.splitId));
        }
        if ((bytesRead = this.is.read(this.data, 0, this.data.length)) == -1) {
            gLogger.debug((Object)("Reached end of file for split:" + this.splitId));
            return false;
        }
        this.dSize = bytesRead;
        this.fileOffset += (long)this.dSize;
        return true;
    }

    @Override
    public boolean appendNewLine() {
        return false;
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly((InputStream)this.is);
    }

    @Override
    public float getProgress() throws IOException, InterruptedException {
        if (this.fileOffset == 0L) {
            return 0.0f;
        }
        return (float)this.fileOffset / (float)this.fileSize;
    }

    @Override
    public String getOutputDataFormat() {
        return "journal";
    }
}

