/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.input;

import com.splunk.datamodel.DataModelBuckets;
import com.splunk.io.SearchMetricsReporter;
import com.splunk.mr.input.ObjectAcceptor;
import com.splunk.mr.input.VirtualIndex;
import com.splunk.mr.input.VixInputSplit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.Credentials;
import org.apache.log4j.Logger;

public class VixSplitGenerator {
    private static Logger gLogger = Logger.getLogger(VixSplitGenerator.class);
    protected SearchMetricsReporter _metrics = null;

    public VixSplitGenerator(SearchMetricsReporter metrics) {
        this._metrics = metrics;
    }

    public void generateSplits(JobContext job, ObjectAcceptor<VixInputSplit> acceptor) throws IOException {
        this.generateSplits(job, acceptor, null);
    }

    public void generateSplits(JobContext job, ObjectAcceptor<VixInputSplit> acceptor, DataModelBuckets dataModelBuckets) throws IOException {
        Configuration conf = job.getConfiguration();
        List<VirtualIndex> vix = VirtualIndex.parseIndexes(conf);
        ArrayList<Path> paths2glob = new ArrayList<Path>();
        for (VirtualIndex vi : vix) {
            for (String gpath : vi.getGlobPaths()) {
                paths2glob.add(new Path(gpath));
            }
        }
        if (paths2glob.size() == 0) {
            throw new IOException("No input paths specified in job.");
        }
        TokenCache.obtainTokensForNamenodes((Credentials)job.getCredentials(), (Path[])paths2glob.toArray(new Path[0]), (Configuration)job.getConfiguration());
        for (VirtualIndex vi : vix) {
            gLogger.debug((Object)("Generating splits for index=" + vi.getName()));
            vi.setMetricsReporter(this._metrics);
            vi.setDataModelBuckets(dataModelBuckets);
            if (vi.generateSplits(job, acceptor)) continue;
            break;
        }
    }
}

