/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.roll;

import com.splunk.roll.Bucket;
import com.splunk.roll.BucketExporter;
import com.splunk.roll.BucketName;
import com.splunk.roll.util.ConfU;
import com.splunk.roll.util.DateU;
import com.splunk.util.LazySeq;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class BucketLister {
    private static final Logger gLogger = Logger.getLogger(BucketLister.class);
    public static final String FROZEN_PREFIX = "freeze.me.";
    private final LazySeq<File> bucketDirs;
    private final Date rollOlderThanTime;
    private final String index;
    private final String serverGuid;

    public BucketLister(LazySeq<File> dirs, Date rollOlderThanTime, String index, String serverGuid) {
        this.bucketDirs = dirs;
        this.rollOlderThanTime = rollOlderThanTime;
        this.index = index;
        this.serverGuid = serverGuid;
    }

    public Iterator<Bucket.LocalBucket> listBuckets() {
        LinkedList<Bucket.LocalBucket> buckets = new LinkedList<Bucket.LocalBucket>();
        while (this.bucketDirs.hasMoreUnchecked()) {
            for (File dir : this.filterOldBuckets(this.bucketDirs.getHead())) {
                buckets.add(new Bucket.LocalBucket(dir, this.getBucketName(dir), this.index, this.serverGuid));
            }
        }
        Collections.sort(buckets, new Comparator<Bucket.LocalBucket>(){

            @Override
            public int compare(Bucket.LocalBucket o1, Bucket.LocalBucket o2) {
                return o1.getEarliest().compareTo(o2.getEarliest());
            }
        });
        final Iterator it = buckets.iterator();
        return new Iterator<Bucket.LocalBucket>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Bucket.LocalBucket next() {
                Bucket.LocalBucket next = (Bucket.LocalBucket)it.next();
                it.remove();
                return next;
            }

            @Override
            public void remove() {
            }
        };
    }

    private BucketName getBucketName(File bucketDir) {
        String dirName = bucketDir.getName();
        if (BucketLister.hasFrozenPrefix(bucketDir)) {
            return new BucketName(StringUtils.removeStart((String)dirName, (String)FROZEN_PREFIX));
        }
        return new BucketName(dirName);
    }

    public static boolean hasFrozenPrefix(File bucketDir) {
        return bucketDir.getName().startsWith(FROZEN_PREFIX);
    }

    private File[] filterOldBuckets(File bucketDir) {
        if (!bucketDir.exists()) {
            return new File[0];
        }
        return bucketDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File bucketDir) {
                try {
                    boolean shouldRoll;
                    BucketName bucketName = BucketLister.this.getBucketName(bucketDir);
                    boolean isDir = bucketDir.isDirectory();
                    boolean validBucketName = bucketName.isValidBucketName();
                    boolean olderThanRollAge = this.isBucketOlderThanRollAge(bucketName);
                    boolean hasFrozenPrefix = BucketLister.hasFrozenPrefix(bucketDir);
                    boolean oldEnough = olderThanRollAge || hasFrozenPrefix;
                    boolean hasJournal = BucketExporter.getBucketsJournal(bucketDir).exists();
                    boolean bl = shouldRoll = isDir && validBucketName && oldEnough && hasJournal;
                    if (gLogger.isDebugEnabled() && !shouldRoll) {
                        String oldEnoughString = " old_enough=" + oldEnough + " because ( olderThanRollAge=" + olderThanRollAge + " OR hasFrozenPrefix=" + hasFrozenPrefix + " )";
                        gLogger.debug((Object)("Will not match bucket_directory_name=" + bucketName.getName() + ". Because some of the tests were not true. is_dir=" + isDir + " valid_bucket_name=" + validBucketName + " has_journal=" + hasJournal + oldEnoughString));
                    }
                    return shouldRoll;
                }
                catch (Exception e) {
                    gLogger.debug((Object)("Could not accept potential bucket directory: " + bucketDir));
                    return false;
                }
            }

            private boolean isBucketOlderThanRollAge(BucketName bucketName) {
                Date bucketEarliest = DateU.getDate(bucketName.getEarliest(), TimeUnit.SECONDS);
                return bucketEarliest.before(BucketLister.this.rollOlderThanTime);
            }
        });
    }

    public static BucketLister create(Configuration conf, List<File> bucketDirs) {
        String index = ConfU.getRollIndex(conf);
        Date rollOlderThanTime = ConfU.getRollOlderThanTime(conf);
        return new BucketLister(new LazySeq.Once<File>(bucketDirs), rollOlderThanTime, index, ConfU.getSplunkServerUUID(conf));
    }

    public List<File> listFrozenBuckets() {
        ArrayList<File> files = new ArrayList<File>();
        for (File hasBucketDirs : this.bucketDirs) {
            files.addAll(Arrays.asList(hasBucketDirs.listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() && BucketLister.hasFrozenPrefix(f);
                }
            })));
        }
        return files;
    }
}

