/*
 * Decompiled with CFR 0.152.
 */
package java.beans.beancontext;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextServiceAvailableEvent;
import java.beans.beancontext.BeanContextServiceRevokedEvent;
import java.beans.beancontext.BeanContextServicesListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class BeanContextChildSupport
implements BeanContextChild,
BeanContextServicesListener,
Serializable {
    static final long serialVersionUID = 6328947014421475877L;
    public BeanContextChild beanContextChildPeer;
    protected PropertyChangeSupport pcSupport;
    protected VetoableChangeSupport vcSupport;
    protected transient BeanContext beanContext;
    protected transient boolean rejectedSetBCOnce;

    public BeanContextChildSupport() {
        this.beanContextChildPeer = this;
        this.pcSupport = new PropertyChangeSupport(this.beanContextChildPeer);
        this.vcSupport = new VetoableChangeSupport(this.beanContextChildPeer);
    }

    public BeanContextChildSupport(BeanContextChild beanContextChild) {
        this.beanContextChildPeer = beanContextChild != null ? beanContextChild : this;
        this.pcSupport = new PropertyChangeSupport(this.beanContextChildPeer);
        this.vcSupport = new VetoableChangeSupport(this.beanContextChildPeer);
    }

    @Override
    public synchronized void setBeanContext(BeanContext beanContext) throws PropertyVetoException {
        if (beanContext == this.beanContext) {
            return;
        }
        BeanContext beanContext2 = this.beanContext;
        BeanContext beanContext3 = beanContext;
        if (!this.rejectedSetBCOnce) {
            this.rejectedSetBCOnce = !this.validatePendingSetBeanContext(beanContext);
            if (this.rejectedSetBCOnce) {
                throw new PropertyVetoException("setBeanContext() change rejected:", new PropertyChangeEvent(this.beanContextChildPeer, "beanContext", beanContext2, beanContext3));
            }
            try {
                this.fireVetoableChange("beanContext", beanContext2, beanContext3);
            }
            catch (PropertyVetoException propertyVetoException) {
                this.rejectedSetBCOnce = true;
                throw propertyVetoException;
            }
        }
        if (this.beanContext != null) {
            this.releaseBeanContextResources();
        }
        this.beanContext = beanContext3;
        this.rejectedSetBCOnce = false;
        this.firePropertyChange("beanContext", beanContext2, beanContext3);
        if (this.beanContext != null) {
            this.initializeBeanContextResources();
        }
    }

    @Override
    public synchronized BeanContext getBeanContext() {
        return this.beanContext;
    }

    @Override
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public void addVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        this.vcSupport.addVetoableChangeListener(string, vetoableChangeListener);
    }

    @Override
    public void removeVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        this.vcSupport.removeVetoableChangeListener(string, vetoableChangeListener);
    }

    @Override
    public void serviceRevoked(BeanContextServiceRevokedEvent beanContextServiceRevokedEvent) {
    }

    @Override
    public void serviceAvailable(BeanContextServiceAvailableEvent beanContextServiceAvailableEvent) {
    }

    public BeanContextChild getBeanContextChildPeer() {
        return this.beanContextChildPeer;
    }

    public boolean isDelegated() {
        return !this.equals(this.beanContextChildPeer);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.pcSupport.firePropertyChange(string, object, object2);
    }

    public void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        this.vcSupport.fireVetoableChange(string, object, object2);
    }

    public boolean validatePendingSetBeanContext(BeanContext beanContext) {
        return true;
    }

    protected void releaseBeanContextResources() {
    }

    protected void initializeBeanContextResources() {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (!this.equals(this.beanContextChildPeer) && !(this.beanContextChildPeer instanceof Serializable)) {
            throw new IOException("BeanContextChildSupport beanContextChildPeer not Serializable");
        }
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }
}

