/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.kerberos.KeyTab;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.krb5.KerberosSecrets;

class SubjectComber {
    private static final boolean DEBUG = Krb5Util.DEBUG;

    private SubjectComber() {
    }

    static <T> T find(Subject subject, String string, String string2, Class<T> clazz) {
        return clazz.cast(SubjectComber.findAux(subject, string, string2, clazz, true));
    }

    static <T> List<T> findMany(Subject subject, String string, String string2, Class<T> clazz) {
        return (List)SubjectComber.findAux(subject, string, string2, clazz, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Object findAux(Subject subject, String string, String string2, Class<T> clazz, boolean bl) {
        ArrayList<T> arrayList;
        if (subject == null) {
            return null;
        }
        ArrayList<T> arrayList2 = arrayList = bl ? null : new ArrayList<T>();
        if (clazz == KeyTab.class) {
            for (KeyTab keyTab : subject.getPrivateCredentials(KeyTab.class)) {
                if (string != null && keyTab.isBound()) {
                    KerberosPrincipal kerberosPrincipal = keyTab.getPrincipal();
                    if (kerberosPrincipal != null) {
                        if (!string.equals(kerberosPrincipal.getName())) {
                            continue;
                        }
                    } else {
                        boolean bl2 = false;
                        for (KerberosPrincipal kerberosPrincipal2 : subject.getPrincipals(KerberosPrincipal.class)) {
                            if (!kerberosPrincipal2.getName().equals(string)) continue;
                            bl2 = true;
                            break;
                        }
                        if (!bl2) continue;
                    }
                }
                if (DEBUG) {
                    System.out.println("Found " + clazz.getSimpleName() + " " + keyTab);
                }
                if (bl) {
                    return keyTab;
                }
                arrayList.add(clazz.cast(keyTab));
            }
        } else if (clazz == KerberosKey.class) {
            for (KerberosKey kerberosKey : subject.getPrivateCredentials(KerberosKey.class)) {
                String string3 = kerberosKey.getPrincipal().getName();
                if (string != null && !string.equals(string3)) continue;
                if (DEBUG) {
                    System.out.println("Found " + clazz.getSimpleName() + " for " + string3);
                }
                if (bl) {
                    return kerberosKey;
                }
                arrayList.add(clazz.cast(kerberosKey));
            }
        } else if (clazz == KerberosTicket.class) {
            Set<Object> set;
            Set<Object> set2 = set = subject.getPrivateCredentials();
            synchronized (set2) {
                Iterator<Object> iterator = set.iterator();
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    if (!(object instanceof KerberosTicket)) continue;
                    KerberosTicket kerberosTicket = (KerberosTicket)object;
                    if (DEBUG) {
                        System.out.println("Found ticket for " + kerberosTicket.getClient() + " to go to " + kerberosTicket.getServer() + " expiring on " + kerberosTicket.getEndTime());
                    }
                    if (!kerberosTicket.isCurrent()) {
                        if (subject.isReadOnly()) continue;
                        iterator.remove();
                        try {
                            kerberosTicket.destroy();
                            if (!DEBUG) continue;
                            System.out.println("Removed and destroyed the expired Ticket \n" + kerberosTicket);
                        }
                        catch (DestroyFailedException destroyFailedException) {
                            if (!DEBUG) continue;
                            System.out.println("Expired ticket not detroyed successfully. " + destroyFailedException);
                        }
                        continue;
                    }
                    KerberosPrincipal kerberosPrincipal = KerberosSecrets.getJavaxSecurityAuthKerberosAccess().kerberosTicketGetServerAlias(kerberosTicket);
                    if (string != null && !kerberosTicket.getServer().getName().equals(string) && (kerberosPrincipal == null || !string.equals(kerberosPrincipal.getName()))) continue;
                    KerberosPrincipal kerberosPrincipal3 = KerberosSecrets.getJavaxSecurityAuthKerberosAccess().kerberosTicketGetClientAlias(kerberosTicket);
                    if (string2 != null && !string2.equals(kerberosTicket.getClient().getName()) && (kerberosPrincipal3 == null || !string2.equals(kerberosPrincipal3.getName()))) continue;
                    if (bl) {
                        return kerberosTicket;
                    }
                    if (string2 == null) {
                        string2 = kerberosPrincipal3 == null ? kerberosTicket.getClient().getName() : kerberosPrincipal3.getName();
                    }
                    if (string == null) {
                        string = kerberosPrincipal == null ? kerberosTicket.getServer().getName() : kerberosPrincipal.getName();
                    }
                    arrayList.add(clazz.cast(kerberosTicket));
                }
            }
        }
        return arrayList;
    }
}

