/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.DefaultBucketMatcher;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.SMBMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.GenMRProcContext;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.BucketMapJoinContext;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.SMBJoinDesc;

public final class MapJoinFactory {
    public static int getPositionParent(AbstractMapJoinOperator<? extends MapJoinDesc> op, Stack<Node> stack) {
        int pos = 0;
        int size = stack.size();
        assert (size >= 2 && stack.get(size - 1) == op);
        Operator parent = (Operator)stack.get(size - 2);
        List<Operator<OperatorDesc>> parOp = op.getParentOperators();
        pos = parOp.indexOf(parent);
        assert (pos < parOp.size());
        return pos;
    }

    public static NodeProcessor getTableScanMapJoin() {
        return new TableScanMapJoinProcessor();
    }

    private MapJoinFactory() {
    }

    private static class TableScanMapJoinProcessor
    implements NodeProcessor {
        private TableScanMapJoinProcessor() {
        }

        public static void setupBucketMapJoinInfo(MapWork plan, AbstractMapJoinOperator<? extends MapJoinDesc> currMapJoinOp) {
            Map<String, Map<String, List<String>>> aliasBucketFileNameMapping;
            if (currMapJoinOp != null && (aliasBucketFileNameMapping = ((MapJoinDesc)currMapJoinOp.getConf()).getAliasBucketFileNameMapping()) != null) {
                MapredLocalWork smbLocalWork;
                MapredLocalWork localPlan = plan.getMapLocalWork();
                if (localPlan == null) {
                    if (currMapJoinOp instanceof SMBMapJoinOperator) {
                        localPlan = ((SMBJoinDesc)((SMBMapJoinOperator)currMapJoinOp).getConf()).getLocalWork();
                    }
                } else if (currMapJoinOp instanceof SMBMapJoinOperator && (smbLocalWork = ((SMBJoinDesc)((SMBMapJoinOperator)currMapJoinOp).getConf()).getLocalWork()) != null) {
                    localPlan.getAliasToFetchWork().putAll(smbLocalWork.getAliasToFetchWork());
                    localPlan.getAliasToWork().putAll(smbLocalWork.getAliasToWork());
                }
                if (localPlan == null) {
                    return;
                }
                if (currMapJoinOp instanceof SMBMapJoinOperator) {
                    plan.setMapLocalWork(null);
                    ((SMBJoinDesc)((SMBMapJoinOperator)currMapJoinOp).getConf()).setLocalWork(localPlan);
                } else {
                    plan.setMapLocalWork(localPlan);
                }
                BucketMapJoinContext bucketMJCxt = new BucketMapJoinContext();
                localPlan.setBucketMapjoinContext(bucketMJCxt);
                bucketMJCxt.setAliasBucketFileNameMapping(aliasBucketFileNameMapping);
                bucketMJCxt.setBucketFileNameMapping(((MapJoinDesc)currMapJoinOp.getConf()).getBigTableBucketNumMapping());
                localPlan.setInputFileChangeSensitive(true);
                bucketMJCxt.setMapJoinBigTableAlias(((MapJoinDesc)currMapJoinOp.getConf()).getBigTableAlias());
                bucketMJCxt.setBucketMatcherClass(DefaultBucketMatcher.class);
                bucketMJCxt.setBigTablePartSpecToFileMapping(((MapJoinDesc)currMapJoinOp.getConf()).getBigTablePartSpecToFileMapping());
                if (currMapJoinOp instanceof SMBMapJoinOperator || ((MapJoinDesc)currMapJoinOp.getConf()).isBucketMapJoin()) {
                    plan.setUseBucketizedHiveInputFormat(true);
                }
            }
        }

        private static void initMapJoinPlan(AbstractMapJoinOperator<? extends MapJoinDesc> op, Task<? extends Serializable> currTask, GenMRProcContext opProcCtx, boolean local) throws SemanticException {
            opProcCtx.getOpTaskMap().put(op, currTask);
            Operator<? extends OperatorDesc> currTopOp = opProcCtx.getCurrTopOp();
            String currAliasId = opProcCtx.getCurrAliasId();
            GenMapRedUtils.setTaskPlan(currAliasId, currTopOp, currTask, local, opProcCtx);
        }

        private static void joinMapJoinPlan(AbstractMapJoinOperator<? extends MapJoinDesc> op, Task<? extends Serializable> oldTask, GenMRProcContext opProcCtx, boolean local) throws SemanticException {
            Operator<? extends OperatorDesc> currTopOp = opProcCtx.getCurrTopOp();
            GenMapRedUtils.mergeInput(currTopOp, opProcCtx, oldTask, local);
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            boolean local;
            AbstractMapJoinOperator mapJoin = (AbstractMapJoinOperator)nd;
            GenMRProcContext ctx = (GenMRProcContext)procCtx;
            int pos = MapJoinFactory.getPositionParent(mapJoin, stack);
            LinkedHashMap<Operator<? extends OperatorDesc>, GenMRProcContext.GenMapRedCtx> mapCurrCtx = ctx.getMapCurrCtx();
            GenMRProcContext.GenMapRedCtx mapredCtx = (GenMRProcContext.GenMapRedCtx)mapCurrCtx.get(mapJoin.getParentOperators().get(pos));
            Task<? extends Serializable> currTask = mapredCtx.getCurrTask();
            MapredWork currPlan = (MapredWork)currTask.getWork();
            String currAliasId = mapredCtx.getCurrAliasId();
            HashMap<Operator<? extends OperatorDesc>, Task<? extends Serializable>> opTaskMap = ctx.getOpTaskMap();
            Task<? extends Serializable> oldTask = opTaskMap.get(mapJoin);
            ctx.setCurrAliasId(currAliasId);
            ctx.setCurrTask(currTask);
            boolean bl = local = pos != ((MapJoinDesc)mapJoin.getConf()).getPosBigTable();
            if (oldTask == null) {
                assert (currPlan.getReduceWork() == null);
                TableScanMapJoinProcessor.initMapJoinPlan(mapJoin, currTask, ctx, local);
            } else {
                TableScanMapJoinProcessor.joinMapJoinPlan(mapJoin, oldTask, ctx, local);
                currTask = oldTask;
                ctx.setCurrTask(currTask);
            }
            MapredWork plan = (MapredWork)currTask.getWork();
            TableScanMapJoinProcessor.setupBucketMapJoinInfo(plan.getMapWork(), mapJoin);
            mapCurrCtx.put(mapJoin, new GenMRProcContext.GenMapRedCtx(ctx.getCurrTask(), ctx.getCurrAliasId()));
            return !local;
        }
    }
}

