/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr;

import com.splunk.io.SearchOutputStream;
import com.splunk.mr.BundleReplicationCommandHandler;
import com.splunk.mr.CommandHandler;
import com.splunk.mr.SplunkMR;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.log4j.Logger;

public class PrivilegedCommandHandlerAction
implements PrivilegedExceptionAction<Void> {
    public static int EXECUTE = 0;
    public static int REAP_HDFS_BUNDLES = 1;
    public static int CREATE_DISPATCH_DIR = 2;
    private static Logger gLogger = Logger.getLogger(PrivilegedCommandHandlerAction.class);
    private CommandHandler _ch = null;
    private Configuration _conf = null;
    private Map<String, Object> _args = null;
    private SearchOutputStream _out = null;
    private int _action = 0;

    public PrivilegedCommandHandlerAction(CommandHandler h, Configuration conf, Map<String, Object> args, SearchOutputStream out, int action) {
        this._ch = h;
        this._conf = conf;
        this._args = args;
        this._out = out;
        this._action = action;
    }

    public PrivilegedCommandHandlerAction(CommandHandler h, Configuration conf, Map<String, Object> args, SearchOutputStream out) {
        this(h, conf, args, out, 0);
    }

    public PrivilegedCommandHandlerAction(Configuration conf, int action) {
        this(null, conf, null, null, action);
    }

    @Override
    public Void run() throws Exception {
        if (this._action == EXECUTE) {
            this._ch.execute(this._conf, this._args, this._out);
        } else if (this._action == REAP_HDFS_BUNDLES) {
            BundleReplicationCommandHandler.reapHDFSBundles(this._conf);
        } else if (this._action == CREATE_DISPATCH_DIR) {
            Path hdfsDispatch;
            FileSystem fs = FileSystem.get((Configuration)this._conf);
            if (!fs.exists(hdfsDispatch = new Path(SplunkMR.getHDFSSplunkHome(this._conf), "dispatch"))) {
                FileSystem.mkdirs((FileSystem)fs, (Path)hdfsDispatch, (FsPermission)new FsPermission(511));
            }
        } else {
            throw new IllegalArgumentException("invalid action for PrivilegedCommandHandlerAction: action=" + this._action);
        }
        return null;
    }
}

