/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr;

import com.splunk.data_delivery.ForwardingHandler;
import com.splunk.datamodel.DataModelBuckets;
import com.splunk.datamodel.DataModelCreator;
import com.splunk.datamodel.DataModelEvaluator;
import com.splunk.io.ChunkedOutputStream;
import com.splunk.io.SearchOutputStream;
import com.splunk.mr.AsyncMRJob;
import com.splunk.mr.BundleReplicationCommandHandler;
import com.splunk.mr.ClusterInfoLogger;
import com.splunk.mr.CommandHandler;
import com.splunk.mr.DispatchReaper;
import com.splunk.mr.FileBasedHeartBeat;
import com.splunk.mr.JobSubmitter;
import com.splunk.mr.OutputProcessor;
import com.splunk.mr.PrivilegedCommandHandlerAction;
import com.splunk.mr.SearchController;
import com.splunk.mr.SetupCommandHandler;
import com.splunk.mr.SplunkBaseMapper;
import com.splunk.mr.SplunkSearchMapper;
import com.splunk.mr.StreamStats;
import com.splunk.mr.cache.MapCache;
import com.splunk.mr.cache.MapCaches;
import com.splunk.mr.cache.compact.CompactionListener;
import com.splunk.mr.cache.integration.CacheEvent;
import com.splunk.mr.cache.integration.CacheKey;
import com.splunk.mr.cache.reporting.CacheReporting;
import com.splunk.mr.input.ObjectAcceptor;
import com.splunk.mr.input.TimeRange;
import com.splunk.mr.input.VirtualIndex;
import com.splunk.mr.input.VixInputSplit;
import com.splunk.mr.input.VixSplitGenerator;
import com.splunk.mr.packaging.SplunkManifestPackager;
import com.splunk.mr.search.processors.ERPAdminProcessor;
import com.splunk.mr.search.processors.MetadataProcessor;
import com.splunk.mr.search.processors.SummarizeProcessor;
import com.splunk.mr.search.processors.VixUtilProcessor;
import com.splunk.roll.RollHandler;
import com.splunk.sdk.SplunkMiniSDK;
import com.splunk.search.SearchPipeline;
import com.splunk.search.SearchProcessor;
import com.splunk.search.SearchResults;
import com.splunk.util.SecurityUtil;
import com.splunk.util.StrUtil;
import com.splunk.util.WildcardList;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.RollingFileAppender;
import org.codehaus.jackson.map.ObjectMapper;

public class SplunkMR
extends Configured
implements Tool {
    private static final String USE_INSTALLED_SPLUNK_PACKAGE = "current";
    private static final String SPLUNK_HOME = "SPLUNK_HOME";
    private static Logger gLogger = Logger.getLogger(SplunkMR.class);
    private static final String VERSION = "6.2";
    private static final String PATTERN = StrUtil.parseBoolean(System.getenv("SPLUNK_LOG_INCLUDE_TIMESTAMP"), false) ? "%d{yyyy-MM-dd HH:mm:ss.SSS Z} %p %C{1} - %m%n" : "%p %C{1} - %m%n";
    public static String HOSTNAME = "unknown";
    public static String CONF_BUNDLE_PATH;
    public static String CONF_SETUP_ONSEARCH;
    public static String CONF_DN_HOME;
    public static String CONF_HDFS_HOME;
    public static String CONF_SEARCH_ID;
    public static String CONF_SEARCH_REDUCE;
    public static String CONF_SEARCH_MAP;
    public static String CONF_SEARCH_DEBUG;
    public static String CONF_SEARCH_PREPROC;
    public static String CONF_SEARCH_SPLITTER;
    public static String CONF_SEARCH_MAPPER;
    public static String CONF_SETUP_PACKAGE;
    public static String CONF_DISPATCH_DIR;
    public static String CONF_COLLECT_THREADS;
    public static String CONF_MAX_SPLITS;
    public static String CONF_MIN_SPLITS;
    public static String CONF_SPLITS_MULTIPLITER;
    public static String CONF_MR_POLL_MS;
    public static String CONF_MAX_STREAM;
    public static String CONF_MIXED_MODE;
    public static String CONF_SEARCH_MODE;
    public static String CONF_JARS;
    public static String CONF_PROVIDER;
    public static String CONF_CACHE_READ;
    public static String CONF_CACHE_WRITE;
    public static String CONF_CACHE_MERGE;
    public static String CONF_CACHE_COMPACT;
    public static String CONF_CACHE_PATH;
    public static String CONF_CACHE_NORM_ID;
    public static String CONF_DEFAULT_BLOCKSIZE;
    public static String CONF_DATAMODEL_APP;
    public static String CONF_DATAMODEL_SUMMARY_ID;
    public static String CONF_DATAMODEL_APP_AND_DMNAME;
    public static String CONF_DATAMODEL_READ;
    public static String CONF_DATAMODEL_WRITE;
    public static String CONF_DATAMODEL_SUMMARIES_ONLY;
    public static String CONF_DATAMODEL_SUMMARIZE;
    public static String CONF_DATAMODEL_COMPRESSION_CODEC;
    public static String CONF_DATAMODEL_BLOOMFILTER_COLUMNS;
    public static String CONF_DATAMODEL_SEARCH_FILTER;
    public static String CONF_DATAMODEL_SEARCH_AGGREGATE;
    public static String CONF_DATASOURCE_FORMAT;
    public static String CONF_DATASOURCE_SCHEMA;
    public static String CONF_BUNDLE_MAX_INACTIVE_WAIT;
    public static String CONF_BUNDLE_POLL_INTERVAL;
    public static String CONF_BUNDLE_SETUP_TIME_LIMIT;
    public static String CONF_PKG_MAX_INACTIVE_WAIT;
    public static String CONF_PKG_POLL_INTERVAL;
    public static String CONF_PKG_SETUP_TIME_LIMIT;
    public static String CONF_BUNDLE_REAP_LIMIT;
    public static String CONF_BUNDLE_REAP_TIME_LIMIT;
    public static String CONF_BUNDLE_REPLICATION;
    public static String CONF_PKG_REPLICATION;
    public static String CONF_SPLITS_PER_COMPACTION;
    public static String CONF_IMPERSONATION;
    public static String CONF_REQUIRED_FIELDS;
    public static String CONF_SPLUNK_ARGS;
    public static String CONF_SH_DISPATCH_DIR;
    public static String CONF_IDX_PRUNE_SEARCH;
    public static String CONF_IDX_PRUNE_TIME;
    public static String CONF_KERBEROS_PRINCIPAL;
    public static String CONF_KERBEROS_KEYTAB;
    public static String CONF_KERBEROS_KDC;
    public static String CONF_KERBEROS_REALM;
    public static String CONF_KERBEROS_CONFFILE;
    public static String CONF_JAVA_SYSTEM_PROPERTIES_PREFIX;
    public static final String CONF_HEARTBEAT_PATH = "splunk.heartbeat.path";
    public static final String CONF_HEARTBEAT_INTERVAL = "splunk.heartbeat.interval";
    public static final String CONF_HEARTBEAT_THRESHOLD = "splunk.heartbeat.threshold";
    public static final String CONF_HEARTBEAT = "splunk.heartbeat";
    public static final String CONF_SH_SPLUNK_HOME = "splunk.searchhead.home";
    public static final String CONF_SUMMARY_CREATE = "splunk.search.summarize.create";
    public static final String CONF_MR_FRAMEWORK_NAME = "mapreduce.framework.name";
    public static final String CONF_JOB_LOCAL_DIR = "job.local.dir";
    public static final String ENV_HUNK_THIRDPARTY_JARS = "HUNK_THIRDPARTY_JARS";
    public static final String SPLUNK_CUSTOM_JARS = "splunk.custom.jars";
    public static final String CONF_INTEGRATION_TEST_RUN = "splunk.integration.test.enabled";
    public static final String CONF_HIVE_TABLENAME = "tablename";
    public static final String CONF_HIVE_DBNAME = "dbname";
    public static final String CONF_HIVE_COLUMN_NAMES = "columnnames";
    public static final String CONF_HIVE_COLUMN_TYPES = "columntypes";
    public static final String CONF_HIVE_SERDE = "serde";
    public static final String CONF_HIVE_SERDE_PROPERTIES = "serde.properties";
    public static final String CONF_HIVE_FILEFORMAT = "fileformat";
    public static final String CONF_HIVE_FILEFORMAT_INPUTFORMAT = "fileformat.inputformat";
    public static final String CONF_HIVE_ROWFORMAT_FIELDS_TERMINATED = "rowformat.fields.terminated";
    public static final String CONF_HIVE_ROWFORMAT_ESCAPTED = "rowformat.escapted";
    public static final String CONF_HIVE_ROWFORMAT_LINES_TERMINATED = "rowformat.lines.terminated";
    public static final String CONF_HIVE_ROWFORMAT_MAPKEYS_TERMINATED = "rowformat.mapkeys.terminated";
    public static final String CONF_HIVE_ROWFORMAT_COLLECTIONITEMS_TERMINATED = "rowformat.collectionitems.terminated";
    public static final String CONF_HIVE_ORC_PPD = "ppd";
    public static final String CONF_HIVE_AUTO_DETECT_PARTITION = "auto.detect.partitions";
    public static final String CONF_HIVE_ORC_BLOOM_FILTER_COLUMNS = "orc.bloom.filter.columns";
    public static final String CONF_SEQUENCE_IGNORE_KEY = "ignore.key";
    public static final String CONF_SPLITTER_PARQUET_READ_STYLE = "parquet.read.style";
    public static final String CONF_SPLITTER_PARQUET_SIMPLIFY_RESULT = "simplifyresult";
    public static final String CONF_FIELD_FILTER = "splunk.search.column.filter";
    public static final String NORMALIZED_SUMMARY_ID_CONF_KEY = "normalized_summary_id";
    public static final String SUMMARY_ID_CONF_KEY = "summary_id";
    public static final String EXTRACT_FIELDS_ON_PATH = "splunk.extract_fields_on_path";
    public static final long DEFAULT_HEARTBEAT_INTERVAL = 6000L;
    public static final int DEFAULT_HEARTBEAT_THRESHOLD = 10;
    public static final boolean DEFAULT_HEARTBEAT = true;
    public static final boolean DEFAULT_USE_FIELD_FILTER = true;
    public static final boolean DEFAULT_PARQUET_SIMPLIFY_RESULT = true;
    public static final boolean DEFAULT_SEQUENCE_IGNORE_KEY = true;
    public static final String DEFAULT_SEQUENCE_KV_DELIMITER = "\t";
    public static final boolean DEFAULT_HIVE_AUTO_DETECT_PARTITION = true;
    public static final boolean DEFAULT_DATAMODEL_SUMMARIES_ONLY = false;
    public static final String KV_STORE_PATH = "/servicesNS/nobody/search/storage/collections/data/";
    public static final String DMA_KV_STORE_COLL_PREFIX = "/servicesNS/nobody/search/storage/collections/data/hunk_dma_";
    public static final String DMA_STATS_COLLECTION_NAME = "HunkDMAStats";
    public static final String DMA_METADATA_KV_STORE_COLL = "/servicesNS/nobody/search/storage/collections/data/hunk_dma_metadata";
    public static final String DMA_KV_STORE_CONFIG_PREFIX = "/servicesNS/nobody/search/storage/collections/config/hunk_dma_";
    public static final int DEFAULT_MAX_BUNDLE_REAP_LIMIT = 5;
    public static final WildcardList ACCEPT_ALL_WCL;
    public static final Pattern ACCEPT_ALL_PATTERN;
    public static final boolean USE_CACHE_READ = false;
    public static final Charset UTF8;
    public static boolean IS_SEARCH_HEAD;
    public static final long START_TIME;
    static final Pattern HOST_COLON_PORT;
    public static final Pattern JOB_FILE_REGEX;
    private Configuration _conf;
    private FileSystem _fs;

    public static void setupSearchHeadLogger() {
        ConsoleAppender console = new ConsoleAppender();
        console.setTarget("System.err");
        console.setLayout((Layout)new PatternLayout(PATTERN));
        console.activateOptions();
        console.setThreshold((Priority)Level.DEBUG);
        Logger.getRootLogger().removeAllAppenders();
        Logger.getRootLogger().addAppender((Appender)console);
        Logger.getRootLogger().setLevel(Level.INFO);
        if (StrUtil.parseBoolean(System.getenv("SPLUNK_LOG_DEBUG"), false)) {
            SplunkMR.setLoggerInDebug();
        }
    }

    public static void changeSearchHeadLoggerforDataDelivery(String providerName) {
        RollingFileAppender rollingFileAppender = new RollingFileAppender();
        rollingFileAppender.setMaxFileSize("25MB");
        rollingFileAppender.setMaxBackupIndex(100000);
        rollingFileAppender.setFile(FileUtils.getFile((String[])new String[]{System.getenv(SPLUNK_HOME), "var", "log", "splunk", "splunk_data_delivery_" + providerName + ".log"}).getAbsolutePath());
        rollingFileAppender.setAppend(true);
        rollingFileAppender.activateOptions();
        rollingFileAppender.setThreshold((Priority)Level.DEBUG);
        rollingFileAppender.setLayout((Layout)new PatternLayout(PATTERN));
        Logger.getRootLogger().removeAllAppenders();
        Logger.getRootLogger().addAppender((Appender)rollingFileAppender);
    }

    public static void setLoggerInDebug() {
        Logger.getRootLogger().setLevel(Level.DEBUG);
        Logger.getLogger(Configuration.class).setLevel(Level.INFO);
        Logger.getLogger((String)"org.apache.hadoop.fs.FSInputChecker").setLevel(Level.INFO);
        Logger.getLogger((String)"org.apache.hadoop.ipc.Client").setLevel(Level.INFO);
        Logger.getLogger((String)"org.apache.hadoop.ipc.RPC").setLevel(Level.INFO);
        Logger.getLogger((String)"org.apache.hadoop.hdfs.DFSClient").setLevel(Level.INFO);
    }

    public static String getSHSplunkHome(Configuration conf) {
        return conf.get(CONF_SH_SPLUNK_HOME);
    }

    public static String getProductName(String packageName) {
        String result = packageName;
        int dash = result.indexOf(45);
        if (dash > -1) {
            result = result.substring(0, dash);
        }
        return result;
    }

    public static long getBlockSizeFromConf(Configuration conf) {
        return Long.valueOf(conf.get(CONF_DEFAULT_BLOCKSIZE));
    }

    public static boolean checkBlockSize(Configuration conf) {
        return conf.get(CONF_DEFAULT_BLOCKSIZE) != null;
    }

    public static boolean isSupportedProductName(String prodName) {
        return prodName.equals("splunk") || prodName.equals("splunkbeta") || prodName.equals("hunk") || prodName.equals("hunkbeta");
    }

    public static File getDNSplunkHome(Configuration conf) {
        File result = new File(conf.get(CONF_DN_HOME));
        String prodName = SplunkMR.getProductName(conf);
        if (!result.getName().equals(prodName)) {
            result = new File(result, prodName);
        }
        return result;
    }

    public static String getProductName(Configuration conf) {
        String prodName = SplunkMR.getProductName(new File(conf.get(CONF_SETUP_PACKAGE)).getName());
        if (!SplunkMR.isSupportedProductName(prodName)) {
            throw new IllegalArgumentException("Invalid package name=" + prodName + ". Package name must start with \"splunk-\" or \"hunk-\".");
        }
        return prodName;
    }

    public static File getLocalJobDir(Mapper.Context context) {
        Configuration conf = context.getConfiguration();
        if (SplunkMR.isYarn(conf)) {
            return new File(conf.get(CONF_JOB_LOCAL_DIR)).getParentFile();
        }
        return new File(context.getJar()).getParentFile().getParentFile();
    }

    private static void setSetupPackagePath(Configuration conf) {
        boolean isConfiguredToUseInstalledSplunk;
        String packagePath = conf.get(CONF_SETUP_PACKAGE);
        boolean bl = isConfiguredToUseInstalledSplunk = packagePath == null || packagePath.equals(USE_INSTALLED_SPLUNK_PACKAGE);
        if (isConfiguredToUseInstalledSplunk) {
            gLogger.info((Object)"Configured to use installed splunk package. Ensuring package exists");
            String splunkHome = SplunkMR.getSHSplunkHome(conf);
            File packageFile = SplunkManifestPackager.getPackageFile(splunkHome);
            gLogger.info((Object)("Setting configuration to use local Splunk package: " + packageFile.getAbsolutePath()));
            conf.set(CONF_SETUP_PACKAGE, packageFile.getAbsolutePath());
        }
    }

    public static File getLocalDispatchDir(Configuration conf) {
        return new File(conf.get(CONF_SH_DISPATCH_DIR)).getParentFile();
    }

    public static File getSearchDispatchDir(Configuration conf) {
        return new File(SplunkMR.getLocalDispatchDir(conf), conf.get(CONF_SEARCH_ID));
    }

    public static Path getHDFSSplunkHome(Configuration conf) {
        return new Path(conf.get(CONF_HDFS_HOME));
    }

    public static Path getHDFSJarsDir(Configuration conf) {
        return new Path(SplunkMR.getHDFSSplunkHome(conf), "jars");
    }

    public static Path getHDFSDispatchHome(Configuration conf) {
        String dir = conf.get(CONF_DISPATCH_DIR, null);
        if (dir == null) {
            return new Path(new Path(SplunkMR.getHDFSSplunkHome(conf), "dispatch"), conf.get(CONF_SEARCH_ID));
        }
        return new Path(dir);
    }

    public static Path getHDFSCacheDir(Configuration conf, VixInputSplit split) {
        return SplunkMR.getHDFSCacheDir(conf, split.getIndex(), split.getBucketId());
    }

    public static Path getHDFSCacheDir(Configuration conf, CacheKey cacheKey) {
        return SplunkMR.getHDFSCacheDir(conf, cacheKey.getIndex(), cacheKey.getSummaryId(), cacheKey.getBucketId());
    }

    private static Path getHDFSCacheDir(Configuration conf, String index, String bucketId) {
        String summaryId = SplunkMR.getSummaryId(conf);
        return SplunkMR.getHDFSCacheDir(conf, index, summaryId, bucketId);
    }

    public static Path getHDFSCacheDir(Configuration conf, String index, String summaryId, String bucketId) {
        String searchHash = SplunkMR.md5SummaryId(summaryId);
        String cachePath = index + "/" + searchHash + "/" + bucketId;
        return new Path(SplunkMR.getTopLevelCacheDir(conf), cachePath);
    }

    public static long getBundleReapTimelimit(Configuration conf) {
        String reaplimit = conf.get(CONF_BUNDLE_REAP_TIME_LIMIT);
        if (reaplimit == null || Long.parseLong(reaplimit) >= 86400000L) {
            return System.currentTimeMillis() - 86400000L;
        }
        return System.currentTimeMillis() - Long.parseLong(reaplimit);
    }

    public static String md5SummaryId(String summaryId) {
        return MD5Hash.digest((String)summaryId).toString();
    }

    public static int getHDFSBundleMaxLimit(Configuration conf) {
        String maxlimit = conf.get(CONF_BUNDLE_REAP_LIMIT);
        if (maxlimit == null || Integer.parseInt(maxlimit) <= 5) {
            return 5;
        }
        return Integer.parseInt(maxlimit);
    }

    public static Path getHDFSCacheDirAtSummaryIdLevel(Path cachePath) {
        return cachePath.getParent();
    }

    public static boolean useNormSummaryId(Configuration conf) {
        return conf.getBoolean(CONF_CACHE_NORM_ID, true);
    }

    public static String getSummaryIdKey(Configuration conf) {
        return SplunkMR.useNormSummaryId(conf) ? NORMALIZED_SUMMARY_ID_CONF_KEY : SUMMARY_ID_CONF_KEY;
    }

    public static String getSummaryId(Configuration conf) {
        return SplunkMR.getSummaryId(conf, SplunkMR.getSummaryIdKey(conf));
    }

    public static String getSummaryId(Configuration conf, String summaryIdKey) {
        Map<String, Object> searchInfo = VirtualIndex.getSearchInfo(conf);
        String summaryId = (String)searchInfo.get(summaryIdKey);
        if (summaryId == null) {
            throw new RuntimeException(summaryIdKey + " did not exist in search info: " + searchInfo);
        }
        return summaryId;
    }

    public static Path getTopLevelCacheDir(Configuration conf) {
        String configuredPath = conf.get(CONF_CACHE_PATH, null);
        if (configuredPath == null) {
            return new Path(SplunkMR.getHDFSSplunkHome(conf), "cache");
        }
        return new Path(configuredPath, "cache");
    }

    public static FileSystem getCacheFs(FileSystem fs, Configuration conf, Path topLevelCacheDir) throws IOException, InterruptedException {
        URI cacheDirUri = topLevelCacheDir.toUri();
        String scheme = cacheDirUri.getScheme();
        if (IS_SEARCH_HEAD && SplunkMR.useProxy(conf)) {
            gLogger.debug((Object)"Using file system with currentUser's realUser as cache fs");
            return SplunkMR.getProxyUserFileSystem(cacheDirUri, conf);
        }
        if (scheme == null || scheme.equals(fs.getHomeDirectory().toUri().getScheme())) {
            return fs;
        }
        return FileSystem.get((URI)cacheDirUri, (Configuration)conf);
    }

    public static FileSystem getProxyUserFileSystem(final URI cacheDirUri, final Configuration conf) throws IOException, InterruptedException {
        return (FileSystem)UserGroupInformation.getCurrentUser().getRealUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws Exception {
                return FileSystem.get((URI)cacheDirUri, (Configuration)conf);
            }
        });
    }

    private static void setupTopLevelCacheDir(FileSystem cacheFs, Path cacheDir) throws IOException, InterruptedException {
        if (SplunkMR.isCachePopulationSearch(cacheFs.getConf())) {
            if (!cacheFs.exists(cacheDir)) {
                cacheFs.mkdirs(cacheDir, new FsPermission(457));
            } else {
                SplunkMR.verifyPathIsWritableOrThrow(cacheFs, cacheDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyPathIsWritableOrThrow(FileSystem cacheFs, Path cacheDir) throws IOException {
        block4: {
            Path writeTestFile = new Path(cacheDir, "write-test." + UUID.randomUUID().toString() + ".file");
            try {
                boolean created = cacheFs.createNewFile(writeTestFile);
                if (created) {
                    gLogger.info((Object)"Passed cache path write test.");
                    break block4;
                }
                throw new IOException("Did not pass cache path write test.Could not write to the cache path: " + cacheDir + ". Please make sure that Hunk can write to the cache path");
            }
            finally {
                cacheFs.delete(writeTestFile, false);
            }
        }
    }

    public static boolean isYarn(Configuration conf) {
        return "yarn".equals(conf.get(CONF_MR_FRAMEWORK_NAME));
    }

    public static boolean useProxy(Configuration conf) {
        return StrUtil.parseBoolean(conf.get(CONF_IMPERSONATION), false);
    }

    public static JobClient getJobClient(Configuration conf, Job job) throws IOException {
        if ("local".equals(conf.get("mapred.job.tracker")) && !SplunkMR.isYarn(conf)) {
            try {
                Class<?> clazz = job.getClass();
                if (job instanceof AsyncMRJob) {
                    clazz = clazz.getSuperclass();
                }
                Field f = clazz.getDeclaredField("jobClient");
                f.setAccessible(true);
                return (JobClient)f.get(job);
            }
            catch (Exception e) {
                gLogger.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return SplunkMR.getJobClient(conf);
    }

    public static JobClient getJobClient(Configuration conf) throws IOException {
        return new JobClient(new JobConf(conf));
    }

    public static void addSplitFieldsToHeader(VixInputSplit vis, Map<String, Object> header, FileStatus fstat, Configuration conf) {
        if (fstat != null) {
            VirtualIndex.addFileMetaFields(header, "field.", fstat, conf);
        }
        header.put("field.input_split_hash", vis.getSplitId());
        header.put("field.tasktracker", HOSTNAME);
        for (Map.Entry<String, String> me : vis.getFields().entrySet()) {
            String key = me.getKey();
            if (!key.startsWith("props.")) {
                key = "field." + key;
            }
            header.put(key, me.getValue());
        }
    }

    public static TaskAttemptContext getNewTaskAttemptContext(Configuration conf, TaskAttemptID id) {
        TaskAttemptContext result = null;
        try {
            Class<?> k = Class.forName("org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl");
            Constructor<?> c = k.getConstructor(Configuration.class, TaskAttemptID.class);
            result = (TaskAttemptContext)c.newInstance(conf, id);
        }
        catch (Throwable ex) {
            try {
                Class<?> k = Class.forName("org.apache.hadoop.mapreduce.TaskAttemptContext");
                Constructor<?> c = k.getConstructor(Configuration.class, TaskAttemptID.class);
                result = (TaskAttemptContext)c.newInstance(conf, id);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    protected static Enum<?> getEnumViaReflection(String klass, String constant) {
        try {
            Class<?> cl = Class.forName(klass);
            return Enum.valueOf(cl, constant);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static String getJobFilename(String type, int tid) {
        return String.format("splunk-%s-%07d", type, tid);
    }

    public static boolean isCachePopulationSearch(Configuration conf) {
        return StrUtil.parseBoolean(conf.get(CONF_SUMMARY_CREATE), false);
    }

    public static boolean writeToCache(Configuration conf) {
        return StrUtil.parseBoolean(conf.get(CONF_CACHE_WRITE), false) || SplunkMR.isCachePopulationSearch(conf);
    }

    public static boolean readFromCache(Configuration conf) {
        return StrUtil.parseBoolean(conf.get(CONF_CACHE_READ), false) || SplunkMR.writeToCache(conf);
    }

    public static boolean isDataModelSummarizeSearch(Configuration conf) {
        return StrUtil.parseBoolean(conf.get(CONF_DATAMODEL_SUMMARIZE), false);
    }

    public static boolean writeToDataModel(Configuration conf) {
        return StrUtil.parseBoolean(conf.get(CONF_DATAMODEL_WRITE), false);
    }

    public static boolean readFromDataModel(Configuration conf) {
        return StrUtil.parseBoolean(conf.get(CONF_DATAMODEL_READ), false);
    }

    public static String getDataModelSummaryId(Configuration conf) {
        return conf.get(CONF_DATAMODEL_SUMMARY_ID);
    }

    public static void setDataModelSummaryId(Configuration conf, String summaryId) {
        conf.set(CONF_DATAMODEL_SUMMARY_ID, summaryId);
    }

    public static void setAppAndDMName(Configuration conf, String appAndDMName) {
        conf.set(CONF_DATAMODEL_APP_AND_DMNAME, appAndDMName);
    }

    public static String getDataModelName(Configuration conf, String appName, String summaryId) {
        String[] parts = summaryId.split("_", 2);
        if (parts.length != 2 || !parts[1].startsWith("DM_")) {
            throw new RuntimeException("Invalid summaryId " + summaryId);
        }
        String id = parts[1].substring("DM_".length());
        if (!id.startsWith(appName + "_")) {
            throw new RuntimeException("Invalid summaryId=" + summaryId + ", appName=" + appName);
        }
        return id.substring((appName + "_").length());
    }

    public static boolean isIntegrationTestRun(Configuration conf) {
        return StrUtil.parseBoolean(conf.get(CONF_INTEGRATION_TEST_RUN), false);
    }

    public SplunkMR(Configuration conf) throws IOException {
        this._conf = conf;
    }

    public static void appendChunkFields(Configuration conf, Map<String, Object> header) throws UnsupportedEncodingException {
        for (Map.Entry kv : conf.getValByRegex("splunk\\.search\\.field\\..*").entrySet()) {
            header.put(((String)kv.getKey()).substring("splunk.search.".length()).trim(), kv.getValue());
        }
    }

    public static void checkArgPresence(Map<String, Object> args, String key) {
        if (!args.containsKey(key)) {
            throw new IllegalArgumentException("Could not find \"" + key + "\" in the provided config arguments.");
        }
    }

    public static ExecutorService getDaemonThreadPool(final String prefix, int size) {
        return Executors.newFixedThreadPool(size, new ThreadFactory(){
            int i = 0;

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName(prefix + "-" + ++this.i);
                t.setDaemon(true);
                return t;
            }
        });
    }

    public static PartialCacheKey getPartialMapCacheKey(Configuration conf) {
        return new PartialCacheKey(conf);
    }

    public static void writeCacheResult(MapCache cache, VixInputSplit split, Configuration conf, Path resultPath) throws IOException {
        cache.writeResult(SplunkMR.getPartialMapCacheKey(conf).getCacheKey(split), resultPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        FileOutputStream stdout = new FileOutputStream(FileDescriptor.out);
        SearchOutputStream out = new SearchOutputStream(new ChunkedOutputStream(stdout));
        System.setOut(System.err);
        try {
            this.runImpl(args, System.in, out);
        }
        catch (IncompatibleClassChangeError e) {
            if (e.getMessage() == "search_finalized") {
                int n = 0;
                return n;
            }
            gLogger.error((Object)e.getMessage(), (Throwable)e);
            out.setStreamType("report");
            out.addMessage("ERROR", "Hadoop version may not match Hadoop cluster version.  Please check provider settings.");
            out.writeHeader();
            out.flush();
            int n = -1;
            return n;
        }
        catch (Throwable e) {
            out.reportError(gLogger, new Exception(e), SearchOutputStream.StreamType.report);
            int n = -1;
            return n;
        }
        finally {
            try {
                SplunkMR.cleanStatics();
            }
            catch (Exception e) {
                gLogger.warn((Object)"Error when cleaning static fields", (Throwable)e);
            }
        }
        return 0;
    }

    public static void cleanStatics() {
        JobSubmitter.SUBMITTERS.clear();
        SearchController.clear();
    }

    private void validateConfiguration() throws Exception {
        Path hdfsHome = SplunkMR.getHDFSSplunkHome(this._conf);
        if (!hdfsHome.isAbsolute()) {
            throw new IllegalArgumentException("Invalid hdfs home='" + hdfsHome + "', must be an absolute path");
        }
        this.setSHSplunkHome(this._conf);
        SplunkMR.setSetupPackagePath(this._conf);
        SplunkMR.getDNSplunkHome(this._conf);
    }

    private void setSHSplunkHome(Configuration conf) {
        String splunkHome = System.getenv(SPLUNK_HOME);
        if (splunkHome != null) {
            conf.set(CONF_SH_SPLUNK_HOME, splunkHome);
        }
    }

    private LinkedHashSet<URL> expandJarPath(String jars) throws Exception {
        LinkedHashSet<URL> toAdd = new LinkedHashSet<URL>();
        if (jars == null) {
            return toAdd;
        }
        jars = StrUtil.expandEnvVars(jars);
        LinkedList<String> files = new LinkedList<String>(Arrays.asList(jars.split(",")));
        while (!files.isEmpty()) {
            String file = files.removeFirst().trim();
            if (file.isEmpty()) continue;
            File f = new File(file);
            if (!f.exists()) {
                throw new Exception(String.format("Jar path is not found, path=%s", file));
            }
            if (f.isDirectory()) {
                File[] content;
                for (File c : content = f.listFiles()) {
                    if (c.isFile() && !c.getName().endsWith(".jar")) continue;
                    files.add(c.getAbsolutePath());
                }
            }
            if (!f.getName().endsWith(".jar")) continue;
            toAdd.add(f.toURI().toURL());
        }
        return toAdd;
    }

    private void resolveHostnameinKerberosePrincipal() throws Exception {
        String kerberoseprincipal = this._conf.get(CONF_KERBEROS_PRINCIPAL);
        if (kerberoseprincipal == null) {
            return;
        }
        kerberoseprincipal = StrUtil.expandEnvVars(kerberoseprincipal);
        this._conf.set(CONF_KERBEROS_PRINCIPAL, kerberoseprincipal);
    }

    private void addCustomJarsToClassLoader() throws Exception {
        String thirdpartyJars = System.getenv(ENV_HUNK_THIRDPARTY_JARS);
        LinkedHashSet<URL> toAdd = this.expandJarPath(thirdpartyJars);
        String jars = this._conf.get(CONF_JARS, "");
        toAdd.addAll(this.expandJarPath(jars));
        if (!toAdd.isEmpty()) {
            StringBuilder tmpjars = new StringBuilder();
            for (URL u : toAdd) {
                if (tmpjars.length() != 0) {
                    tmpjars.append(",");
                }
                tmpjars.append(u.toString());
            }
            this._conf.set(SPLUNK_CUSTOM_JARS, tmpjars.toString());
            gLogger.info((Object)("Setting custom jars=" + tmpjars));
            URL[] urls = toAdd.toArray(new URL[0]);
            this._conf.setClassLoader((ClassLoader)new URLClassLoader(urls, this._conf.getClassLoader()));
            URLClassLoader cl = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public void runImpl(String[] args, InputStream in, SearchOutputStream out) throws Exception {
        ObjectMapper jsonMapper = new ObjectMapper();
        Map json_conf = (Map)jsonMapper.readValue(in, Map.class);
        SplunkMR.checkArgPresence(json_conf, "action");
        SplunkMR.checkArgPresence(json_conf, "args");
        SplunkMR.checkArgPresence(json_conf, "conf");
        HashMap<String, CommandHandler> handlers = new HashMap<String, CommandHandler>();
        handlers.put("search", new SearchHandler(false));
        handlers.put("searchpipe", new SearchHandler(true));
        handlers.put("setup", new SetupCommandHandler());
        handlers.put("bundle-replication", new BundleReplicationCommandHandler());
        handlers.put("roll", new RollHandler());
        handlers.put("forward", new ForwardingHandler());
        Map args_conf = (Map)json_conf.get("conf");
        SplunkMR.checkArgPresence(args_conf, "provider");
        Map args_provider = (Map)args_conf.get("provider");
        SplunkMR.checkArgPresence(args_provider, CONF_HDFS_HOME);
        SplunkMR.checkArgPresence(args_provider, CONF_DN_HOME);
        args_provider.put("mapred.output.compress", String.valueOf(false));
        args_provider.put("mapreduce.output.fileoutputformat.compress", String.valueOf(false));
        String family = String.valueOf(args_provider.get("family"));
        if (!"hadoop".equals(family)) {
            throw new IllegalArgumentException("Invalid ERP family=\"" + family + "\", expected family is \"hadoop\".");
        }
        for (Map.Entry me : args_provider.entrySet()) {
            if (me.getValue() == null) continue;
            String key = ((String)me.getKey()).trim();
            String val = String.valueOf(me.getValue()).trim();
            if (key.isEmpty() || val.isEmpty()) continue;
            if (key == null || "family".equals(key) || "mode".equals(key)) {
                key = "splunk.provider." + key;
            }
            if (key.startsWith(CONF_JAVA_SYSTEM_PROPERTIES_PREFIX)) {
                try {
                    key = key.substring(CONF_JAVA_SYSTEM_PROPERTIES_PREFIX.length());
                    gLogger.info((Object)("set java system property: " + key));
                    System.setProperty(key, val);
                    continue;
                }
                catch (Exception e) {
                    gLogger.error((Object)("Unable to set java system property for " + key), (Throwable)e);
                    throw new RuntimeException("Unable to set java system property for " + key + ": " + e.getMessage());
                }
            }
            if (CONF_KERBEROS_KDC.equals(key) || CONF_KERBEROS_REALM.equals(key)) {
                gLogger.info((Object)("set java system property: " + key));
                System.setProperty(key, val);
            }
            this._conf.set(key, val);
        }
        out.setMetricPrefix("erp." + this._conf.get(CONF_PROVIDER) + ".");
        this.resolveHostnameinKerberosePrincipal();
        this.addCustomJarsToClassLoader();
        VirtualIndex.setSplunkArgs(this._conf, jsonMapper.writeValueAsString((Object)json_conf));
        SecurityUtil.ensureLogin(this._conf);
        this.validateConfiguration();
        String action = (String)json_conf.get("action");
        CommandHandler h = (CommandHandler)handlers.get(action.toLowerCase());
        HashSet<String> nonImpersonableActions = new HashSet<String>(Arrays.asList("roll", "forward"));
        if (h != null) {
            if (SplunkMR.useProxy(this._conf) && !nonImpersonableActions.contains(action)) {
                String splunkUser;
                Map args_args = (Map)json_conf.get("args");
                SplunkMR.checkArgPresence(args_args, "search");
                Map args_search = (Map)args_args.get("search");
                SplunkMR.checkArgPresence(args_search, "info");
                Map args_search_info = (Map)((List)args_search.get("info")).get(0);
                String proxyUser = splunkUser = String.valueOf(args_search_info.get("_ppc.user"));
                if (args_conf.containsKey("mapping") && args_conf.get("mapping") != "") {
                    Map args_mapping = (Map)jsonMapper.readValue((String)args_conf.get("mapping"), Map.class);
                    if (args_mapping.containsKey("user") && !((String)args_mapping.get("user")).isEmpty()) {
                        proxyUser = (String)args_mapping.get("user");
                    }
                    if (args_mapping.containsKey("queue") && !((String)args_mapping.get("queue")).isEmpty()) {
                        this._conf.set("mapred.job.queue.name", (String)args_mapping.get("queue"));
                        this._conf.set("mapreduce.job.queuename", (String)args_mapping.get("queue"));
                    }
                }
                UserGroupInformation loginUgi = UserGroupInformation.getLoginUser();
                UserGroupInformation proxyUgi = UserGroupInformation.createProxyUser((String)proxyUser, (UserGroupInformation)loginUgi);
                gLogger.debug((Object)("Using pass-through auth, hunk superuser " + loginUgi.getShortUserName() + " will impersonate hunk user " + proxyUser));
                proxyUgi.doAs((PrivilegedExceptionAction)new PrivilegedCommandHandlerAction(h, this._conf, json_conf, out));
            } else {
                h.execute(this._conf, json_conf, out);
            }
        } else {
            throw new IllegalArgumentException("Unsupported action: " + action + ".");
        }
    }

    private static void setupYarnConfsIfPossible() {
        try {
            Class.forName("org.apache.hadoop.yarn.conf.YarnConfiguration");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Exception {
        SplunkMR.setupSearchHeadLogger();
        gLogger.info((Object)String.format("starting, version=%s ...", VERSION));
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thr, Throwable t) {
                gLogger.error((Object)("Received an unexpected error from thread '" + thr.getName() + "'. Exiting."), t);
                LogManager.shutdown();
                System.exit(1);
            }
        });
        SplunkMR.setupYarnConfsIfPossible();
        Configuration conf = new Configuration();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        IS_SEARCH_HEAD = true;
        int retval = ToolRunner.run((Tool)new SplunkMR(conf), (String[])otherArgs);
        gLogger.info((Object)String.format("finishing, version=%s ...", VERSION));
        System.exit(retval);
    }

    static {
        try {
            HOSTNAME = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        CONF_BUNDLE_PATH = "splunk.search.bundle.path";
        CONF_SETUP_ONSEARCH = "splunk.setup.onsearch";
        CONF_DN_HOME = "splunk.home.datanode";
        CONF_HDFS_HOME = "splunk.home.hdfs";
        CONF_SEARCH_ID = "splunk.search.id";
        CONF_SEARCH_REDUCE = "splunk.search.reduce";
        CONF_SEARCH_MAP = "splunk.search.map";
        CONF_SEARCH_DEBUG = "splunk.search.debug";
        CONF_SEARCH_PREPROC = "splunk.search.recordreader";
        CONF_SEARCH_SPLITTER = "splunk.search.splitter";
        CONF_SEARCH_MAPPER = "splunk.search.mapper";
        CONF_SETUP_PACKAGE = "splunk.setup.package";
        CONF_DISPATCH_DIR = "splunk.dispatch.dir.hdfs";
        CONF_COLLECT_THREADS = "splunk.search.mr.threads";
        CONF_MAX_SPLITS = "splunk.search.mr.maxsplits";
        CONF_MIN_SPLITS = "splunk.search.mr.minsplits";
        CONF_SPLITS_MULTIPLITER = "splunk.search.mr.splits.multiplier";
        CONF_MR_POLL_MS = "splunk.search.mr.poll";
        CONF_MAX_STREAM = "splunk.search.mixedmode.maxstream";
        CONF_MIXED_MODE = "splunk.search.mixedmode";
        CONF_SEARCH_MODE = "splunk.search.mode";
        CONF_JARS = "splunk.jars";
        CONF_PROVIDER = "splunk.search.provider";
        CONF_CACHE_READ = "splunk.search.cache.read";
        CONF_CACHE_WRITE = "splunk.search.cache.write";
        CONF_CACHE_MERGE = "splunk.search.cache.merge";
        CONF_CACHE_COMPACT = "splunk.search.cache.compact";
        CONF_CACHE_PATH = "splunk.search.cache.path";
        CONF_CACHE_NORM_ID = "splunk.search.cache.use_norm_summary_id";
        CONF_DEFAULT_BLOCKSIZE = "splunk.setup.default.blocksize";
        CONF_DATAMODEL_APP = "splunk.search.datamodel.app";
        CONF_DATAMODEL_SUMMARY_ID = "splunk.search.datamodel.id";
        CONF_DATAMODEL_APP_AND_DMNAME = "splunk.search.datamodel.appAndDMName";
        CONF_DATAMODEL_READ = "splunk.search.datamodel.read";
        CONF_DATAMODEL_WRITE = "splunk.search.datamodel.write";
        CONF_DATAMODEL_SUMMARIES_ONLY = "splunk.search.datamodel.summariesonly";
        CONF_DATAMODEL_SUMMARIZE = "splunk.search.datamodel.summarize";
        CONF_DATAMODEL_COMPRESSION_CODEC = "splunk.search.datamodel.compression.codec";
        CONF_DATAMODEL_BLOOMFILTER_COLUMNS = "splunk.search.datamodel.orc.bloom.filter.columns";
        CONF_DATAMODEL_SEARCH_FILTER = "splunk.search.datamodel.filter";
        CONF_DATAMODEL_SEARCH_AGGREGATE = "splunk.search.datamodel.aggregate";
        CONF_DATASOURCE_FORMAT = "splunk.search.datasource.format";
        CONF_DATASOURCE_SCHEMA = "splunk.search.datasource.schema";
        CONF_BUNDLE_MAX_INACTIVE_WAIT = "splunk.setup.bundle.max.inactive.wait";
        CONF_BUNDLE_POLL_INTERVAL = "splunk.setup.bundle.poll.interval";
        CONF_BUNDLE_SETUP_TIME_LIMIT = "splunk.setup.bundle.setup.timelimit";
        CONF_PKG_MAX_INACTIVE_WAIT = "splunk.setup.package.max.inactive.wait";
        CONF_PKG_POLL_INTERVAL = "splunk.setup.package.poll.interval";
        CONF_PKG_SETUP_TIME_LIMIT = "splunk.setup.package.setup.timelimit";
        CONF_BUNDLE_REAP_LIMIT = "splunk.setup.bundle.reap.limit";
        CONF_BUNDLE_REAP_TIME_LIMIT = "splunk.setup.bundle.reap.timelimit";
        CONF_BUNDLE_REPLICATION = "splunk.setup.bundle.replication";
        CONF_PKG_REPLICATION = "splunk.setup.package.replication";
        CONF_SPLITS_PER_COMPACTION = "splunk.search.cache.splits.per.compaction";
        CONF_IMPERSONATION = "splunk.impersonation";
        CONF_REQUIRED_FIELDS = "splunk.required.fields";
        CONF_SPLUNK_ARGS = "splunk.args";
        CONF_SH_DISPATCH_DIR = "splunk.search.dispatch.path";
        CONF_IDX_PRUNE_SEARCH = "prune.partitions.search";
        CONF_IDX_PRUNE_TIME = "prune.partitions.time";
        CONF_KERBEROS_PRINCIPAL = "kerberos.principal";
        CONF_KERBEROS_KEYTAB = "kerberos.keytab";
        CONF_KERBEROS_KDC = "java.security.krb5.kdc";
        CONF_KERBEROS_REALM = "java.security.krb5.realm";
        CONF_KERBEROS_CONFFILE = "java.security.krb5.conf";
        CONF_JAVA_SYSTEM_PROPERTIES_PREFIX = "javaprops.";
        ACCEPT_ALL_WCL = new WildcardList(Arrays.asList("*"));
        ACCEPT_ALL_PATTERN = Pattern.compile(".*");
        UTF8 = Charset.forName("UTF-8");
        IS_SEARCH_HEAD = false;
        START_TIME = System.currentTimeMillis();
        HOST_COLON_PORT = Pattern.compile("^([^:]+)(:(\\d+))?$");
        JOB_FILE_REGEX = Pattern.compile("splunk\\-([^\\-]+)\\-(\\d+)");
    }

    public static class PartialCacheKey {
        private final String summaryId;
        private final Configuration conf;

        public PartialCacheKey(Configuration conf) {
            this(conf, SplunkMR.getSummaryId(conf));
        }

        public PartialCacheKey(Configuration conf, String summaryId) {
            this.conf = conf;
            this.summaryId = summaryId;
        }

        public CacheKey getCacheKey(VixInputSplit split) {
            return PartialCacheKey.getCacheKey(this.summaryId, split, this.conf);
        }

        public static CacheKey getCacheKey(String summaryId, VixInputSplit split, Configuration conf) {
            String searchSplitId = split.getSplitId() + summaryId;
            return new CacheKey(split, searchSplitId, summaryId, conf);
        }
    }

    public static class SearchHandler
    implements CommandHandler,
    SearchProcessor.Factory {
        private static Logger gLogger = Logger.getLogger(SearchHandler.class);
        static final Class<SplunkSearchMapper> DEFAULT_MAPPER_CLASS = SplunkSearchMapper.class;
        Configuration _conf = null;
        FileSystem _fs = null;
        MapCaches _mapCaches = null;
        SearchOutputStream _out = null;
        Class<? extends JobSubmitter> _jcClass = JobSubmitter.class;
        JobSubmitter _jc = null;
        OutputProcessor _op = null;
        Class<? extends Mapper> _mapperClass = DEFAULT_MAPPER_CLASS;
        FileBasedHeartBeat _heartBeat = null;
        Path _hdfsDispatchDir = null;
        Map<String, Object> _args = null;
        Map<String, Object> _provider = null;
        List<Map<String, Object>> _indexes = null;
        boolean _pipemode = false;
        VixSplitGenerator _tif = null;
        boolean _setupDone = false;

        public SearchHandler(boolean pipemode) {
            this._pipemode = pipemode;
        }

        public StreamStats streamData(VixInputSplit split, Configuration conf) throws IOException, InterruptedException {
            TaskAttemptID taskAttemptId = new TaskAttemptID();
            return SplunkBaseMapper.stream(this._out, split, conf, taskAttemptId);
        }

        public long streamData() throws IOException {
            final long[] bytes = new long[]{0L};
            ObjectAcceptor<VixInputSplit> acceptor = new ObjectAcceptor<VixInputSplit>(){

                @Override
                public <T extends VixInputSplit> boolean accept(T split) {
                    try {
                        bytes[0] = bytes[0] + SearchHandler.this.streamData(split, (Configuration)SearchHandler.this._conf).bytes;
                    }
                    catch (Exception e) {
                        SearchHandler.this._out.reportError(gLogger, e, SearchOutputStream.StreamType.raw);
                        return false;
                    }
                    return true;
                }
            };
            this._conf.setLong("mapred.min.split.size", Long.MAX_VALUE);
            this._conf.setLong("mapreduce.input.fileinputformat.split.minsize", Long.MAX_VALUE);
            AsyncMRJob dummy = new AsyncMRJob(this._conf, this._conf.get(CONF_SEARCH_ID));
            try {
                if (this._tif == null) {
                    this._tif = new VixSplitGenerator(this._out);
                }
                this._tif.generateSplits((JobContext)dummy, acceptor);
            }
            catch (IOException e) {
                gLogger.error((Object)e.getMessage(), (Throwable)e);
            }
            return bytes[0];
        }

        private void createDirAndSetPerms(FileSystem fs, Path path, FsPermission perms) throws IOException {
            fs.mkdirs(path);
            fs.setPermission(path, perms);
        }

        public void setupTopLevelHdfsDirs(Configuration conf) throws IOException, InterruptedException {
            Path hdfsPackageDir = SetupCommandHandler.getHDFSSplunkPackages(conf);
            Path hdfsBundleDir = BundleReplicationCommandHandler.getHDFSBundleDir(conf);
            Path hdfsDispatch = new Path(SplunkMR.getHDFSSplunkHome(conf), "dispatch");
            try {
                if (SplunkMR.useProxy(conf)) {
                    FileSystem proxyFS = SplunkMR.getProxyUserFileSystem(SplunkMR.getHDFSSplunkHome(conf).toUri(), conf);
                    FsPermission rxall = new FsPermission(493);
                    this.createDirAndSetPerms(proxyFS, hdfsPackageDir, rxall);
                    this.createDirAndSetPerms(proxyFS, hdfsBundleDir, rxall);
                    this.createDirAndSetPerms(proxyFS, hdfsDispatch, new FsPermission(511));
                } else {
                    if (!this._fs.exists(hdfsPackageDir)) {
                        this._fs.mkdirs(hdfsPackageDir);
                    }
                    if (!this._fs.exists(hdfsBundleDir)) {
                        this._fs.mkdirs(hdfsBundleDir);
                    }
                    if (!this._fs.exists(hdfsDispatch)) {
                        this._fs.mkdirs(hdfsDispatch);
                    }
                }
            }
            catch (AccessControlException e) {
                gLogger.error((Object)"Failed to create top level hdfs dirs:", (Throwable)e);
                throw new IOException("Failed to create Hunk directories due to permission denied. Please make sure you have write permission to the directory specified by vix." + CONF_HDFS_HOME + " in your provider", e);
            }
        }

        public synchronized void setupMREnv(Configuration conf) throws IOException, InterruptedException {
            if (this._setupDone) {
                return;
            }
            this._setupDone = true;
            gLogger.info((Object)"state=start, set up the required env in HDFS for MR spawning search");
            long st = System.currentTimeMillis();
            this.setupTopLevelHdfsDirs(conf);
            SetupCommandHandler.handleSetupOnSearch(conf, this._args);
            this._out.addMetric("setup.splunk", System.currentTimeMillis() - st, 1L);
            long bst = System.currentTimeMillis();
            BundleReplicationCommandHandler.handleSetupOnSearch(conf, this._args);
            this._out.addMetric("setup.bundles", System.currentTimeMillis() - bst, 1L);
            if (this._fs.exists(this._hdfsDispatchDir)) {
                gLogger.info((Object)("HDFS dispatch directory=" + this._hdfsDispatchDir.toString() + " already exists, deleting it."));
                this._fs.delete(this._hdfsDispatchDir, true);
            }
            if (StrUtil.parseBoolean(conf.get(SplunkMR.CONF_HEARTBEAT), true)) {
                conf.set(SplunkMR.CONF_HEARTBEAT_PATH, this._hdfsDispatchDir.toString());
                this._heartBeat = new FileBasedHeartBeat(conf, true);
                this._heartBeat.start();
            }
            this.addCustomJarsToRemoteClassPath();
            this._out.addMetric("setup", System.currentTimeMillis() - st, 1L);
            gLogger.info((Object)"state=done, set up the required env in HDFS for MR spawning search");
        }

        @Override
        public void execute(Configuration conf, Map<String, Object> args, SearchOutputStream out) throws Exception {
            try {
                this._conf = conf;
                this._out = out;
                this._args = args;
                this.executeImpl();
            }
            catch (Exception ex) {
                throw ex;
            }
            finally {
                try {
                    if (this._jc != null) {
                        this._jc.shutdown(false);
                    }
                }
                catch (Exception e) {
                    gLogger.warn((Object)"Failed to shutdown jobSubmitter", (Throwable)e);
                }
                if (this._heartBeat != null) {
                    try {
                        this._heartBeat.terminate();
                        this._heartBeat.join();
                    }
                    catch (Exception e) {
                        gLogger.warn((Object)"Failed to stop heartBeat", (Throwable)e);
                    }
                }
            }
        }

        private static String getValue(Map<String, Object> map, String key, String defaultVal) {
            if (map.containsKey(key)) {
                return String.valueOf(map.get(key));
            }
            return defaultVal;
        }

        public static String getRequiredFields(Map<String, Object> args_search, Map<String, Object> args_search_info) {
            String rf = null;
            try {
                StringBuilder sb = new StringBuilder();
                List requiredFields = (List)args_search.get("required_fields");
                for (String f : requiredFields) {
                    sb.append(f.trim()).append(",");
                }
                if (sb.length() > 0) {
                    sb.deleteCharAt(sb.length() - 1);
                }
                rf = sb.toString();
            }
            catch (Exception e) {
                gLogger.warn((Object)"Failed to populate required_fields, return all fields.", (Throwable)e);
                rf = null;
            }
            if (rf != null) {
                String keySet = SearchHandler.getValue(args_search_info, "_keySet", "");
                Object[] tokens = StrUtil.parseCSVLine(keySet, 0, ' ', '\"', '\\');
                gLogger.debug((Object)("parsed _keySet=" + Arrays.toString(tokens)));
                for (Object t : tokens) {
                    if (((String)t).trim().isEmpty() || ((String)t).contains("::")) continue;
                    gLogger.debug((Object)"Search contains a term or a phrase, returning all fields");
                    rf = null;
                    break;
                }
            }
            return rf == null ? "*" : rf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executeImpl() throws Exception {
            Map args_conf = (Map)this._args.get("conf");
            Map args_args = (Map)this._args.get("args");
            SplunkMR.checkArgPresence(args_conf, "provider");
            SplunkMR.checkArgPresence(args_conf, "indexes");
            SplunkMR.checkArgPresence(args_args, "search");
            this._provider = (Map)args_conf.get("provider");
            this._indexes = (List)args_conf.get("indexes");
            Map args_search = (Map)args_args.get("search");
            Map args_search_info = (Map)((List)args_search.get("info")).get(0);
            String searchMode = String.valueOf(args_search.get("mode"));
            this._conf.set(CONF_SEARCH_MAP, args_search_info.get("_remote_search").toString());
            if (args_search_info.containsKey("_reduce_search")) {
                this._conf.set(CONF_SEARCH_REDUCE, String.valueOf(args_search_info.get("_reduce_search")));
            }
            this._conf.set(CONF_SEARCH_ID, String.valueOf(args_search_info.get("_sid")));
            this._conf.set(CONF_SEARCH_DEBUG, String.valueOf(args_search.get("debug")));
            if (this._conf.getBoolean(CONF_SEARCH_DEBUG, false)) {
                SplunkMR.setLoggerInDebug();
            }
            if (this._conf.get(CONF_SEARCH_MAP) == null) {
                throw new Exception("Failed to read splunk.search.map from stdin.");
            }
            if (this._conf.get(CONF_SEARCH_ID) == null) {
                throw new Exception("Failed to read splunk.search.id from stdin.");
            }
            if (StrUtil.parseBoolean(String.valueOf(args_search_info.get("realtime")), false)) {
                throw new Exception("Real time search is not supported by this external result provider.");
            }
            this._conf.set(CONF_SEARCH_MODE, searchMode);
            SplunkBaseMapper.validateRecordReaderClasses(this._conf);
            boolean mixedMode = searchMode.equalsIgnoreCase("mixed");
            boolean mapReduce = mixedMode || searchMode.equalsIgnoreCase("report");
            gLogger.info((Object)("Reduce search: " + this._conf.get(CONF_SEARCH_REDUCE)));
            gLogger.info((Object)("Search mode: " + searchMode));
            String rf = SearchHandler.getRequiredFields(args_search, args_search_info);
            gLogger.info((Object)("setting requiredFields=" + rf));
            this._conf.set(CONF_REQUIRED_FIELDS, rf);
            long fsStart = System.currentTimeMillis();
            try {
                this._fs = FileSystem.get((Configuration)this._conf);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create a virtual index filesystem connection: " + e.getMessage() + ". Advice: Verify that your vix.fs.default.name is correct and available.");
            }
            gLogger.info((Object)("Created filesystem object, elapsed_ms=" + (System.currentTimeMillis() - fsStart)));
            Path topLevelCacheDir = SplunkMR.getTopLevelCacheDir(this._conf);
            FileSystem cacheFs = SplunkMR.getCacheFs(this._fs, this._conf, topLevelCacheDir);
            this._mapCaches = MapCaches.create(cacheFs);
            SplunkMR.setupTopLevelCacheDir(cacheFs, topLevelCacheDir);
            SearchController.init(this._conf);
            this.checkLicense();
            ClusterInfoLogger clusterLogger = new ClusterInfoLogger(this._conf, args_search_info, true);
            this._tif = new VixSplitGenerator(this._out);
            if (this._pipemode) {
                this.executePipeMode(args_search);
            } else {
                if (mapReduce) {
                    ExecutorService cacheWorkerPool = SplunkMR.getDaemonThreadPool("cache-worker-pool", 2);
                    this._mapCaches.setReadKeysPool(cacheWorkerPool);
                    ExecutorService cacheReportingPool = SplunkMR.getDaemonThreadPool("cache-reporting-pool", 2);
                    boolean writeToDM = SplunkMR.writeToDataModel(this._conf);
                    try {
                        this.executeMapReduce(searchMode, this._tif, cacheWorkerPool, cacheReportingPool, writeToDM);
                    }
                    finally {
                        SearchHandler.shutdownPool(cacheWorkerPool);
                        SearchHandler.shutdownPool(cacheReportingPool);
                        if (writeToDM && this._jc != null && this._jc.isLockFileCreatedForDMSearch()) {
                            try {
                                DataModelCreator.deleteTempDir(this._conf);
                            }
                            finally {
                                try {
                                    DataModelCreator.deleteLockFile(this._conf);
                                }
                                catch (Exception e) {
                                    gLogger.error((Object)"Failed to delete lock file", (Throwable)e);
                                }
                            }
                        }
                    }
                }
                long bytes = this.streamData();
                if (bytes == 0L) {
                    gLogger.info((Object)"The search couldn't find any matching data");
                }
            }
        }

        void checkLicense() {
            SearchController sc = SearchController.instance();
            if (sc.allowHunkSearching()) {
                return;
            }
            for (Map<String, Object> index : this._indexes) {
                if (index.containsKey("output.buckets.path")) continue;
                throw new RuntimeException("Permission denied. License does not allow execution of searches on virtual index=" + index.get("name") + ". Only archive indexes allowed in ERP family=hadoop.");
            }
        }

        private static void shutdownPool(ExecutorService pool) {
            pool.shutdown();
            pool.shutdownNow();
        }

        @Override
        public SearchProcessor createProcessor(String name) {
            if ("metadata".equals(name)) {
                return new MetadataProcessor(this._conf, this._tif);
            }
            if ("erpadmin".equals(name)) {
                return new ERPAdminProcessor(this._conf);
            }
            if ("vixutil".equals(name)) {
                return new VixUtilProcessor(this._conf, this._out);
            }
            if ("presummarize".equals(name)) {
                HashSet<String> indexNames = new HashSet<String>();
                for (Map<String, Object> index : this._indexes) {
                    indexNames.add(index.get("name").toString());
                }
                return SummarizeProcessor.create(this._mapCaches, this._tif, indexNames);
            }
            return null;
        }

        private void executePipeMode(Map<String, Object> args_search) throws IOException {
            boolean done;
            this._out.setStreamType("report");
            SearchPipeline.registerFactory(this);
            List sp_arg = (List)args_search.get("search_pipeline");
            SearchPipeline sp = new SearchPipeline(sp_arg);
            gLogger.info((Object)("need to run the given search in pipe mode: " + sp.toString()));
            if (!sp.isImplemented()) {
                gLogger.info((Object)("don't know how to handle search pipeline: " + sp.toString()));
                return;
            }
            String unimplementedPipe = sp.getUnimplmented();
            if (!unimplementedPipe.isEmpty()) {
                gLogger.info((Object)("unimplemented part of the pipe: " + unimplementedPipe));
                this._out.setReportPostProcessSearch(unimplementedPipe);
            }
            SearchResults sr = new SearchResults();
            do {
                done = sp.execute(sr);
                this._out.write(sr);
                this._out.flush();
            } while (!done);
            this._out.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LinkedList<Path> syncCustomJars(FileSystem fs, Path jarsDir, String[] customJars) throws IOException {
            Path tmpJarsDir = null;
            LinkedList<Path> remoteJars = new LinkedList<Path>();
            boolean renamed = false;
            tmpJarsDir = new Path(jarsDir.getParent(), "jars.tmp." + System.currentTimeMillis() + "." + UUID.randomUUID());
            gLogger.debug((Object)("Creating remote tmpJarsDir: " + tmpJarsDir));
            try {
                if (fs.exists(tmpJarsDir) && !fs.delete(tmpJarsDir, true)) {
                    throw new RuntimeException("Failed to delete tmpJarsDir: " + tmpJarsDir);
                }
                if (!fs.mkdirs(tmpJarsDir)) {
                    throw new RuntimeException("Failed to create tmpJarsDir: " + tmpJarsDir);
                }
                gLogger.debug((Object)("Copying local custom jars to remote tmpJarDirs=" + jarsDir));
                for (String jar : customJars) {
                    Path src = new Path(jar);
                    Path finalDest = new Path(jarsDir, src.getName());
                    fs.copyFromLocalFile(src, tmpJarsDir);
                    remoteJars.addLast(finalDest);
                }
                if (fs.exists(jarsDir)) {
                    fs.delete(jarsDir, true);
                }
                if (!fs.rename(tmpJarsDir, jarsDir)) {
                    throw new RuntimeException("Failed to rename tmpJarsDir to jarsDir. tmpJarsDir=" + tmpJarsDir + ", jarsDir=" + jarsDir);
                }
                renamed = true;
                gLogger.info((Object)("Successfully synced remote jars dir: " + jarsDir));
                LinkedList<Path> linkedList = remoteJars;
                return linkedList;
            }
            finally {
                if (!renamed) {
                    try {
                        fs.delete(tmpJarsDir, true);
                    }
                    catch (Exception exception) {}
                }
            }
        }

        private void addCustomJarsToRemoteClassPath() {
            String customJarsStr = this._conf.get(SplunkMR.SPLUNK_CUSTOM_JARS);
            if (customJarsStr == null) {
                return;
            }
            try {
                String[] customJars = customJarsStr.split(",");
                Path jarsDir = SplunkMR.getHDFSJarsDir(this._conf);
                FileSystem fs = SplunkMR.getCacheFs(this._fs, this._conf, jarsDir);
                LinkedList<Object> remoteJars = new LinkedList();
                if (!fs.exists(jarsDir)) {
                    remoteJars = this.syncCustomJars(fs, jarsDir, customJars);
                } else {
                    FileStatus[] stats = fs.listStatus(jarsDir);
                    if (stats == null || stats.length == 0 || stats.length != customJars.length) {
                        remoteJars = this.syncCustomJars(fs, jarsDir, customJars);
                    } else {
                        boolean bl;
                        boolean bl2 = true;
                        for (FileStatus fileStatus : stats) {
                            if (customJarsStr.contains(fileStatus.getPath().getName())) continue;
                            remoteJars = this.syncCustomJars(fs, jarsDir, customJars);
                            bl = false;
                            break;
                        }
                        if (bl) {
                            for (String string : customJars) {
                                Path local = new Path(string);
                                Path remote = new Path(jarsDir, local.getName());
                                remoteJars.addLast(remote);
                            }
                        }
                    }
                }
                gLogger.info((Object)("Setting jars to remote classpath. jarDirs=" + jarsDir));
                for (Path path : remoteJars) {
                    gLogger.info((Object)("Adding " + path.getName()));
                    DistributedCache.addFileToClassPath((Path)path, (Configuration)this._conf);
                }
            }
            catch (Throwable t) {
                gLogger.warn((Object)"Failed to set remote classpath and add jars to distributed cache from hadoop jarsDir. Will let hadoop set it.", t);
                this._conf.set("tmpjars", customJarsStr);
            }
        }

        private void ensureHunkDMACollection(String appAndDMName) throws IOException {
            SplunkMiniSDK sdk = SplunkMiniSDK.createForSearch(this._conf);
            try {
                sdk.get(SplunkMR.DMA_KV_STORE_COLL_PREFIX + appAndDMName, new String[0]);
            }
            catch (SplunkMiniSDK.SplunkResponseException sre) {
                sdk.post("/servicesNS/nobody/search/storage/collections/config", "name", "hunk_dma_" + appAndDMName);
                gLogger.info((Object)("Collection for hunk_dma_" + appAndDMName + "created in kv store"));
            }
        }

        private void ensureHunkDMAStatsCollection() throws IOException {
            SplunkMiniSDK sdk = SplunkMiniSDK.createForSearch(this._conf);
            try {
                sdk.get("/servicesNS/nobody/search/storage/collections/data/HunkDMAStats", new String[0]);
            }
            catch (SplunkMiniSDK.SplunkResponseException sre) {
                sdk.post("/servicesNS/nobody/search/storage/collections/config", "name", SplunkMR.DMA_STATS_COLLECTION_NAME);
                gLogger.info((Object)"Created HunkDMAStats in kv store");
            }
        }

        private void ensureHunkDMAMetadataCollection() throws IOException {
            SplunkMiniSDK sdk = SplunkMiniSDK.createForSearch(this._conf);
            try {
                sdk.get(SplunkMR.DMA_METADATA_KV_STORE_COLL, new String[0]);
            }
            catch (SplunkMiniSDK.SplunkResponseException sre) {
                sdk.post("/servicesNS/nobody/search/storage/collections/config", "name", "hunk_dma_metadata");
                gLogger.info((Object)"Collection hunk_dma_metadata created in kv store");
            }
        }

        private void executeMapReduce(String searchMode, VixSplitGenerator tif, ExecutorService cacheWorkerPool, ExecutorService cacheReportingPool, final boolean writeToDM) throws IOException, ClassNotFoundException, InterruptedException, InstantiationException, Exception {
            CacheReporting cacheReporting;
            this._hdfsDispatchDir = SplunkMR.getHDFSDispatchHome(this._conf);
            if (!writeToDM) {
                if (SplunkMR.useProxy(this._conf)) {
                    UserGroupInformation realUser = UserGroupInformation.getCurrentUser().getRealUser();
                    realUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            FileSystem fs = FileSystem.get((Configuration)SearchHandler.this._conf);
                            DispatchReaper dr = new DispatchReaper(fs, SearchHandler.this._hdfsDispatchDir.getParent(), SplunkMR.getLocalDispatchDir(SearchHandler.this._conf));
                            dr.start();
                            return null;
                        }
                    });
                } else {
                    DispatchReaper dr = new DispatchReaper(this._fs, this._hdfsDispatchDir.getParent(), SplunkMR.getLocalDispatchDir(this._conf));
                    dr.start();
                }
            }
            this._op = new OutputProcessor(this._fs, this._out, this._conf, searchMode, this._mapCaches);
            this._jc = JobSubmitter.get(this._conf, this._op, this._out, this._jcClass);
            this._mapperClass = this.getConfiguredMapperClass();
            this._jc.setMapperClass(this._mapperClass);
            this._jc.setSearchHandler(this);
            this._op.setCacheSplitListener(this._jc);
            if (SplunkMR.writeToCache(this._conf)) {
                this._jc.setCompactionListener(new CompactionListener(cacheWorkerPool, this._out, this._mapCaches));
            }
            boolean readFromDM = SplunkMR.readFromDataModel(this._conf);
            String summaryId = SplunkMR.getSummaryId(this._conf, SplunkMR.SUMMARY_ID_CONF_KEY);
            String appAndDMName = null;
            String appName = null;
            String modelName = null;
            DataModelBuckets dataModelBuckets = null;
            DataModelEvaluator dme = null;
            if (readFromDM || writeToDM) {
                summaryId = SplunkMR.getSummaryId(this._conf, SplunkMR.SUMMARY_ID_CONF_KEY);
                dataModelBuckets = new DataModelBuckets(summaryId, this._conf);
                this._jc.setDataModelBuckets(dataModelBuckets);
                this._jc.setWriteToDM(writeToDM);
                gLogger.debug((Object)("summaryId=" + summaryId + ", readFromDM=" + readFromDM + ", writeToDM=" + writeToDM));
                SplunkMR.setDataModelSummaryId(this._conf, summaryId);
                appAndDMName = summaryId.split("_DM_")[1];
                appName = this._conf.get(CONF_DATAMODEL_APP);
                modelName = SplunkMR.getDataModelName(this._conf, appName, summaryId);
                SplunkMR.setAppAndDMName(this._conf, appAndDMName);
                this.ensureHunkDMACollection(appAndDMName);
                this.ensureHunkDMAStatsCollection();
                this.ensureHunkDMAMetadataCollection();
                dme = new DataModelEvaluator(this._conf, appName, modelName);
            }
            if (readFromDM) {
                dme.setDataModelProperties(this._conf, appAndDMName);
                readFromDM = SplunkMR.readFromDataModel(this._conf);
                cacheReporting = null;
            } else if (writeToDM) {
                List<VirtualIndex> indexes = VirtualIndex.parseIndexes(this._conf);
                String provider = indexes.get(0).getProvider();
                dme.parseModel(provider);
                cacheReporting = null;
            } else {
                if (cacheWorkerPool == cacheReportingPool) {
                    throw new IllegalArgumentException("Cache worker and cache reporting pool cannot be the same");
                }
                cacheReporting = CacheReporting.create(this._mapCaches, cacheReportingPool);
            }
            final boolean readCache = SplunkMR.readFromCache(this._conf);
            final boolean readFromDMFinal = readFromDM;
            ObjectAcceptor<VixInputSplit> acceptor = new ObjectAcceptor<VixInputSplit>(){
                final PartialCacheKey partialCacheKey;
                final TimeRange searchTimeRange;
                final boolean summaryCreationSearch;
                {
                    this.partialCacheKey = SplunkMR.getPartialMapCacheKey(SearchHandler.this._conf);
                    this.searchTimeRange = TimeRange.createSearchTimeRange(SearchHandler.this._conf);
                    this.summaryCreationSearch = SplunkMR.isCachePopulationSearch(SearchHandler.this._conf);
                }

                @Override
                public <T extends VixInputSplit> boolean accept(T split) {
                    if (!readFromDMFinal && !writeToDM && readCache && split.isWithinTimeRange(this.searchTimeRange)) {
                        CacheKey cacheKey = this.partialCacheKey.getCacheKey(split);
                        SearchHandler.this._mapCaches.initForSplit(cacheKey);
                        if (this.summaryCreationSearch) {
                            SearchHandler.this._mapCaches.ensureCacheInfoFile(cacheKey);
                        }
                        boolean found = true;
                        if (SearchHandler.this._mapCaches.hasCompactedResult(cacheKey)) {
                            this.offerCacheHit(split, cacheKey, CacheEvent.newCompacted(cacheKey));
                        } else if (SearchHandler.this._mapCaches.hasStagedResult(cacheKey)) {
                            this.offerCacheHit(split, cacheKey, CacheEvent.newStaged(cacheKey));
                        } else {
                            cacheReporting.offer(split);
                            cacheReporting.addPending(cacheKey);
                            SearchHandler.this._jc.gotSplit(split);
                            found = false;
                        }
                        gLogger.debug((Object)("cache state=" + (found ? "HIT" : "MISS") + " for key=" + cacheKey));
                    } else {
                        SearchHandler.offerSplitToJobSubmitter(SearchHandler.this._jc, split, this.summaryCreationSearch, this.searchTimeRange);
                    }
                    return true;
                }

                private <T extends VixInputSplit> void offerCacheHit(T split, CacheKey cacheKey, CacheEvent cacheEvent) {
                    SearchHandler.this._jc.gotCachedSplit(split, cacheKey);
                    SearchHandler.this._op.accept(cacheEvent);
                }
            };
            this._op.start();
            AsyncMRJob dummy = new AsyncMRJob(this._conf, this._conf.get(CONF_SEARCH_ID));
            this._jc.beginning();
            tif.generateSplits((JobContext)dummy, acceptor, dataModelBuckets);
            this._op.accept(new CacheEvent.NoMoreEvents());
            this._jc.finished();
            this._jc.waitForCompletion();
            this._op.waitForCompletion();
            if (this._op.getError() != null) {
                throw this._op.getError();
            }
            if (SearchController.instance().shouldStop()) {
                throw new RuntimeException(SearchController.instance().getStopReason());
            }
            this._mapCaches.awaitCompactions();
            if (SplunkMR.writeToCache(this._conf)) {
                this._mapCaches.compactAllSync(cacheWorkerPool, this._out);
            }
            if (SplunkMR.isCachePopulationSearch(this._conf)) {
                gLogger.debug((Object)"isCachePopulationSearch");
                cacheReporting.offerPending();
                this._out.setStreamType("report");
                SearchResults srs = new SearchResults();
                cacheReporting.outputResults(srs);
                this._out.write(srs);
                this._out.flush();
            }
        }

        private Class<? extends Mapper> getConfiguredMapperClass() {
            String mapperClassName = this._conf.get(CONF_SEARCH_MAPPER);
            if (mapperClassName != null) {
                try {
                    return Class.forName(mapperClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            return this._mapperClass;
        }

        protected static <T extends VixInputSplit> void offerSplitToJobSubmitter(JobSubmitter jc, T split, boolean summaryCreationSearch, TimeRange searchTimeRange) {
            if (!summaryCreationSearch) {
                jc.gotSplit(split);
            } else if (summaryCreationSearch && split.isWithinTimeRange(searchTimeRange)) {
                jc.gotSplit(split);
            } else if (gLogger.isDebugEnabled()) {
                gLogger.debug((Object)("Did not use split=" + split + " summaryCreationSearch=" + summaryCreationSearch + " splitTimeRange=" + new TimeRange(split.getEarliestTime(), split.getLatestTime()) + " searchTimeRange=" + searchTimeRange));
            }
        }
    }
}

