/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.cache;

import com.splunk.mr.cache.CacheReference;
import com.splunk.mr.cache.CompactionMetadata;
import com.splunk.mr.cache.JobQueue;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;

public class CacheIndexer {
    public static final Class<MD5Hash> KEY_CLASS = MD5Hash.class;
    public static final Class<ResultPointer> VALUE_CLASS = ResultPointer.class;
    private static final String RESULT_POINTERS_FILE_NAME = "result_pointers.seq";
    private static final String RESULTS_FILE_NAME = "results.gz";
    private final FileSystem fileSystem;
    private final Path compactionDir;
    private final Path resultPointersFile;
    private final Path resultsFile;
    private final CacheReference cacheReference;
    private SequenceFile.Writer writer;
    private FSDataOutputStream resultsOut;
    private long bytesWritten;
    private CompactionMetadata meta;

    public CacheIndexer(FileSystem fileSystem, Path resultsDir, CacheReference cacheReference) {
        this.fileSystem = fileSystem;
        this.cacheReference = cacheReference;
        this.compactionDir = resultsDir;
        this.resultsFile = CacheIndexer.getResultFile(this.compactionDir);
        this.resultPointersFile = CacheIndexer.getResultPointersFile(this.compactionDir);
    }

    public static Path getResultPointersFile(Path compactionDir) {
        return new Path(compactionDir, RESULT_POINTERS_FILE_NAME);
    }

    public static Path getResultFile(Path compactionDir) {
        return new Path(compactionDir, RESULTS_FILE_NAME);
    }

    public void setup() throws IOException {
        this.fileSystem.mkdirs(this.compactionDir);
        this.writer = SequenceFile.createWriter((FileSystem)this.fileSystem, (Configuration)this.fileSystem.getConf(), (Path)this.resultPointersFile, KEY_CLASS, VALUE_CLASS);
        this.resultsOut = this.fileSystem.create(this.resultsFile, true);
        this.bytesWritten = 0L;
        this.meta = new CompactionMetadata.Zero();
    }

    public void indexJob(JobQueue.CacheJob job) throws IOException {
        try {
            this.writer.append((Writable)job.hash, (Writable)new ResultPointer(job.length, this.bytesWritten));
            this.bytesWritten += IOUtils.copyLarge((InputStream)job.openResults(), (OutputStream)this.resultsOut);
            this.meta = this.meta.mergeWith(this.getMetadataForCacheJob(job));
        }
        finally {
            IOUtils.closeQuietly((Closeable)job);
        }
    }

    private CompactionMetadata getMetadataForCacheJob(JobQueue.CacheJob job) {
        return new CompactionMetadata(job.getSplitLatestTime(), job.getSplitEarliestTime(), 1L, job.getSplitSize());
    }

    public void doneProcessingJobs() throws IOException {
        CompactionMetadata.writeCompactionMetadata(this.fileSystem, this.compactionDir, this.meta);
        IOUtils.closeQuietly((OutputStream)this.resultsOut);
        IOUtils.closeQuietly((Closeable)this.writer);
        this.updateCacheReferenceFile();
    }

    private void updateCacheReferenceFile() throws IOException {
        this.cacheReference.update(new CacheReference.CacheUpdate(){

            @Override
            public Map.Entry<CacheReference.CacheUpdate.PathType, String> getAddedPath() {
                return this.toEntry(CacheReference.CacheUpdate.PathType.MUTABLE, CacheIndexer.this.compactionDir.toUri().getPath());
            }
        });
    }

    public void teardown() {
        IOUtils.closeQuietly((Closeable)this.writer);
        IOUtils.closeQuietly((OutputStream)this.resultsOut);
    }

    public void failed() throws IOException {
        this.fileSystem.delete(this.compactionDir, true);
    }

    public static MD5Hash getKeyForHash(String hash) {
        return MD5Hash.digest((String)hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<MD5Hash, ResultPointer> getKeys(FileSystem fs, Path compactionDir) throws IOException {
        HashMap<MD5Hash, ResultPointer> map = new HashMap<MD5Hash, ResultPointer>();
        Configuration conf = fs.getConf();
        SequenceFile.Reader reader = null;
        try {
            reader = new SequenceFile.Reader(fs, CacheIndexer.getResultPointersFile(compactionDir), conf);
            CacheIndexer.putAllKeyValuesInMap(map, reader);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)reader);
        return map;
    }

    private static void putAllKeyValuesInMap(Map<MD5Hash, ResultPointer> map, SequenceFile.Reader reader) throws IOException {
        ResultPointer resPtr;
        MD5Hash hash;
        boolean wasNext;
        while (wasNext = reader.next((Writable)(hash = new MD5Hash()), (Writable)(resPtr = new ResultPointer()))) {
            map.put(hash, resPtr);
        }
    }

    public static class MD5HashComparator
    implements Comparator<MD5Hash> {
        @Override
        public int compare(MD5Hash o1, MD5Hash o2) {
            return o1.compareTo(o2);
        }
    }

    public static class ResultPointer
    implements Writable {
        private long length;
        private long offset;

        public ResultPointer() {
        }

        public ResultPointer(long length, long offset) {
            this.length = length;
            this.offset = offset;
        }

        public void write(DataOutput out) throws IOException {
            out.writeLong(this.length);
            out.writeLong(this.offset);
        }

        public void readFields(DataInput in) throws IOException {
            this.length = in.readLong();
            this.offset = in.readLong();
        }

        public long getLength() {
            return this.length;
        }

        public long getOffset() {
            return this.offset;
        }

        public ResultPointer withOffset(long offset) {
            this.offset += offset;
            return this;
        }

        public String toString() {
            return "ResultPointer [length=" + this.length + ", offset=" + this.offset + "]";
        }
    }
}

