/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.input;

import com.splunk.filter.schema.CSVSchemaFilter;
import com.splunk.mr.input.SplunkLineRecordReader;
import com.splunk.mr.input.VixInputSplit;
import com.splunk.util.StrUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;

public class SimpleCSVRecordReader
extends SplunkLineRecordReader {
    private static Logger gLogger = Logger.getLogger(SimpleCSVRecordReader.class);
    private final Pattern FILE_PATTERN = Pattern.compile("\\.([tc]sv)(?:\\.(?:gz|bz2|snappy))?$");
    protected Text _val = new Text();
    protected String[] _header = new String[0];
    protected long _line = 0L;
    protected long _splitStart = 0L;
    protected char _delimChar = (char)44;
    protected char _quoteChar = (char)34;
    protected char _escapeChar = (char)92;
    protected boolean[] readColumns;
    private ByteArrayOutputStream _baos = new ByteArrayOutputStream(1024);
    private JsonFactory _jf = new JsonFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean readCSVHeader(Path file) throws IOException {
        FSDataInputStream fileIn = null;
        try {
            FileSystem fs = file.getFileSystem(this._conf);
            fileIn = fs.open(file);
            CompressionCodec codec = new CompressionCodecFactory(this._conf).getCodec(file);
            if (codec != null) {
                fileIn = codec.createInputStream((InputStream)fileIn);
            }
            BufferedReader bis = new BufferedReader(new InputStreamReader((InputStream)fileIn), 4096);
            String line = bis.readLine();
            this._header = StrUtil.parseCSVLine(line, 16, this._delimChar, this._quoteChar, this._escapeChar);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileIn);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fileIn);
        return this._header.length != 0;
    }

    @Override
    public Pattern getFilePattern() {
        return this.FILE_PATTERN;
    }

    @Override
    public String getName() {
        return "csv";
    }

    @Override
    public void vixInitialize(VixInputSplit filesplit, TaskAttemptContext context) throws IOException, InterruptedException {
        String dialect = "default";
        Matcher m = this.FILE_PATTERN.matcher(filesplit.getPath().toString());
        if (m.find() && "tsv".compareToIgnoreCase(m.group(1)) == 0) {
            dialect = "tsv";
        }
        if ((dialect = this.getConfVar("dialect", dialect)).compareToIgnoreCase("excel") == 0) {
            this._escapeChar = (char)34;
            this._quoteChar = (char)34;
            this._delimChar = (char)44;
        } else if (dialect.compareToIgnoreCase("excel-tab") == 0) {
            this._escapeChar = (char)34;
            this._quoteChar = (char)34;
            this._delimChar = (char)9;
        } else if (dialect.compareToIgnoreCase("tsv") == 0) {
            this._escapeChar = (char)92;
            this._quoteChar = (char)34;
            this._delimChar = (char)9;
        }
        if (!this.readCSVHeader(filesplit.getPath())) {
            throw new IOException(String.format("Could not read CSV header line from, path=%s", filesplit.getPath().toString()) + ".");
        }
        CSVSchemaFilter filter = new CSVSchemaFilter();
        filter.filter(Arrays.asList(this._header), this._requiredFields);
        this.readColumns = filter.readColumns();
        this._splitStart = filesplit.getStart();
        super.vixInitialize(filesplit, context);
    }

    @Override
    public String getOutputDataFormat() {
        return "json";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Text getCurrentValue() throws IOException {
        Text i222;
        Text val;
        if (this._splitStart == 0L && this._line == 1L) {
            try {
                if (!this.nextKeyValue()) {
                    return null;
                }
            }
            catch (IOException e1) {
                gLogger.error((Object)"Error while skipping first line", (Throwable)e1);
            }
        }
        if ((val = super.getCurrentValue()) == null) {
            return null;
        }
        String[] data = StrUtil.parseCSVLine(val.toString(), this._header.length, this._delimChar, this._quoteChar, this._escapeChar);
        JsonGenerator json = null;
        try {
            this._baos.reset();
            json = this._jf.createJsonGenerator((OutputStream)this._baos, JsonEncoding.UTF8);
            json.writeStartObject();
            for (int i222 = 0; i222 < this._header.length && i222 < data.length; ++i222) {
                if (!this.readColumns[i222]) continue;
                json.writeStringField(this._header[i222], data[i222]);
            }
            json.writeEndObject();
            json.flush();
            val.set(this._baos.toByteArray());
            i222 = val;
        }
        catch (IOException e) {
            try {
                gLogger.error((Object)("Error while processing line: " + val.toString()), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(json);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)json);
            return null;
        }
        IOUtils.closeQuietly((Closeable)json);
        return i222;
    }

    @Override
    public boolean nextKeyValue() throws IOException {
        ++this._line;
        return super.nextKeyValue();
    }
}

