/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.input;

import com.splunk.datamodel.DataModelBuckets;
import com.splunk.datasource.WriterFactory;
import com.splunk.datasource.hive.HiveMetaStoreUtils;
import com.splunk.io.SearchMetricsReporter;
import com.splunk.mr.SplunkMR;
import com.splunk.mr.input.FileSplitGenerator;
import com.splunk.mr.input.FileStatusExt;
import com.splunk.mr.input.HiveRecordReader;
import com.splunk.mr.input.HiveSplitGenerator;
import com.splunk.mr.input.ObjectAcceptor;
import com.splunk.mr.input.ParquetSplitGenerator;
import com.splunk.mr.input.SampledAcceptor;
import com.splunk.mr.input.SplitGenerator;
import com.splunk.mr.input.TimeRange;
import com.splunk.mr.input.VixInputSplit;
import com.splunk.mr.input.VixTimeSpecifier;
import com.splunk.nscache.CachedFileSystem;
import com.splunk.roll.Bucket;
import com.splunk.roll.PathResolver;
import com.splunk.roll.util.ConfU;
import com.splunk.search.SearchContext;
import com.splunk.search.SearchEvaluator;
import com.splunk.util.ReflectionUtil;
import com.splunk.util.StrUtil;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.util.Progressable;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

public class VirtualIndex {
    private static Logger gLogger = Logger.getLogger(VirtualIndex.class);
    private Configuration _conf = null;
    private String _name = null;
    private String _provider = null;
    private String _search = null;
    private String _metricPrefix = null;
    private List<VIXPathSpecifier> _paths = new ArrayList<VIXPathSpecifier>();
    private Map<String, String> _globPaths = new HashMap<String, String>();
    private long _searchET = 0L;
    private long _searchLT = 0L;
    private SearchEvaluator _se = null;
    private String _rollPath;
    protected SearchMetricsReporter _metrics = null;
    protected Map<String, Object> _args = null;
    private DataModelBuckets _dataModelBuckets;
    protected float _splitSampleRate = 1.0f;
    private long _total_files = 0L;
    private long _time_filtered_files = 0L;
    private long _search_filtered_files = 0L;
    private long _total_dirs = 0L;
    private long _time_filtered_dirs = 0L;
    private long _search_filtered_dirs = 0L;
    private static Pattern SCHEME_EMPTY_HOST = Pattern.compile("^\\w+:///");
    private static final Pattern RR_PATTERN = Pattern.compile("^input\\.[^.]+\\.recordreader$");
    protected long _reported_tf = 0L;
    protected long _reported_tff = 0L;
    protected long _reported_sff = 0L;
    protected long _reported_td = 0L;
    protected long _reported_tfd = 0L;
    protected long _reported_sfd = 0L;
    protected long _start_time = 0L;
    protected long _blocked_time = 0L;
    protected long _reported_time = 0L;
    protected long _datamodel_lookup_time = 0L;
    protected long _datamodel_lookup_files = 0L;
    static final int MAX_ENTRIES = 100;
    static Map<String, List<VirtualIndex>> CACHE = new LinkedHashMap<String, List<VirtualIndex>>(101, 0.75f, true){

        @Override
        public boolean removeEldestEntry(Map.Entry<String, List<VirtualIndex>> eldest) {
            return this.size() > 100;
        }
    };

    private static String getStrValue(Map<String, Object> args, String key) {
        Object v = args.get(key);
        return v == null ? null : v.toString();
    }

    private VixTimeSpecifier getTimeSpecifier(Map<String, Object> args, String prefix) {
        return new VixTimeSpecifier(VirtualIndex.getStrValue(args, prefix + ".regex"), VirtualIndex.getStrValue(args, prefix + ".format"), VirtualIndex.getStrValue(args, prefix + ".value"), VirtualIndex.getStrValue(args, prefix + ".offset"), VirtualIndex.getStrValue(args, prefix + ".timezone"));
    }

    private VIXBucketSpecifier getBucketSpecifier(Map<String, Object> args, String prefix) {
        return new VIXBucketSpecifier(VirtualIndex.getStrValue(args, prefix + ".regex"));
    }

    public VirtualIndex(Configuration conf, String name, Map<String, Object> args) {
        this._args = new HashMap<String, Object>(args);
        this._name = name;
        this._conf = conf;
        this._metricPrefix = "vix." + name;
        this._provider = args.containsKey("provider") ? args.get("provider").toString() : null;
        this._search = args.containsKey("search") ? args.get("search").toString() : null;
        boolean prunePartitions = true;
        boolean useTimeHeuristic = true;
        if (args.containsKey(SplunkMR.CONF_IDX_PRUNE_SEARCH)) {
            prunePartitions = StrUtil.parseBoolean(String.valueOf(args.get(SplunkMR.CONF_IDX_PRUNE_SEARCH)), true);
        }
        if (args.containsKey(SplunkMR.CONF_IDX_PRUNE_TIME)) {
            useTimeHeuristic = StrUtil.parseBoolean(String.valueOf(args.get(SplunkMR.CONF_IDX_PRUNE_TIME)), true);
        }
        if (args.containsKey("search_expr") && prunePartitions) {
            try {
                this._se = SearchEvaluator.parse((Map)args.get("search_expr"));
            }
            catch (Exception ex) {
                gLogger.warn((Object)"Failed to build SearchEvaluator", (Throwable)ex);
            }
        }
        for (Map.Entry<String, Object> me : args.entrySet()) {
            String key = me.getKey();
            if (key.startsWith("input.") && key.endsWith(".path") && key.length() > 11 && me.getValue() != null && me.getValue().toString().trim().length() > 0) {
                String metaStoreUris;
                String id = key.substring(6, key.length() - 5);
                String prefix = "input." + id;
                VIXPathSpecifier vixps = new VIXPathSpecifier(this, id, String.valueOf(me.getValue()), VirtualIndex.getStrValue(args, prefix + ".accept"), VirtualIndex.getStrValue(args, prefix + ".ignore"), this.getTimeSpecifier(args, prefix + ".et"), this.getTimeSpecifier(args, prefix + ".lt"), this.getBucketSpecifier(args, prefix + ".bucket"), this.getBucketSpecifier(args, prefix + ".dm.bucket"));
                this._paths.add(vixps);
                String splitterClass = this.getSplitterClass(id);
                boolean extractFields = conf.getBoolean("splunk.extract_fields_on_path", true);
                if (!extractFields || splitterClass == null || !splitterClass.endsWith("HiveSplitGenerator") || (metaStoreUris = conf.get(HiveConf.ConfVars.METASTOREURIS.toString())) == null) continue;
                String hiveSplitterName = HiveRecordReader.getNameStatically();
                String dbName = this.getSplitterConf(id, hiveSplitterName, "dbname", "default");
                String tableName = this.getRequiredSplitterConf(id, hiveSplitterName, "tablename");
                boolean autoDetect = StrUtil.parseBoolean(this.getSplitterConf(id, hiveSplitterName, "auto.detect.partitions", null), true);
                if (!autoDetect) continue;
                HiveMetaStoreUtils.HivePartitionInfo pi = null;
                try {
                    pi = HiveMetaStoreUtils.getPartitionInfo(conf, dbName, tableName);
                }
                catch (Throwable e) {
                    gLogger.error((Object)("Failed to get hive partition info. dbName=" + dbName + ", tableName=" + tableName), e);
                }
                if (pi == null) continue;
                vixps.extractHivePartitionKeys(pi);
                continue;
            }
            if (key.equals("split.sample.rate")) {
                try {
                    this._splitSampleRate = Float.parseFloat(String.valueOf(me.getValue()));
                    if (!(this._splitSampleRate <= 0.0f) && !(this._splitSampleRate > 1.0f)) continue;
                    throw new Exception("Sampling rate must be >0 and <=1");
                }
                catch (Exception e) {
                    this._splitSampleRate = 1.0f;
                    String msg = String.format("Failed to parse vix.%s=%s, index=%s, defaulting to sample rate 1. Error: %s", me.getKey(), String.valueOf(me.getValue()), this._name, e.getMessage());
                    gLogger.warn((Object)msg);
                    continue;
                }
            }
            if (!key.equals("output.buckets.path")) continue;
            this._rollPath = String.valueOf(me.getValue());
            break;
        }
        if (this._paths.isEmpty() && this._rollPath == null) {
            throw new IllegalArgumentException("Could not find valid input paths for index=" + name + ".");
        }
        this._searchET = 0L;
        this._searchLT = Long.MAX_VALUE;
        if (useTimeHeuristic) {
            TimeRange range = TimeRange.createSearchTimeRange(conf);
            this._searchLT = range.lt;
            this._searchET = range.et;
        }
    }

    public static String getSourcePath(URI pathUri, String defaultFs) {
        String relativePath = pathUri.getPath();
        String absolutePath = pathUri.toString();
        if (defaultFs == null) {
            return absolutePath;
        }
        if (SCHEME_EMPTY_HOST.matcher(absolutePath).find()) {
            return relativePath;
        }
        if (!absolutePath.startsWith(defaultFs)) {
            return absolutePath;
        }
        return relativePath;
    }

    public static void addFileMetaFields(Map<String, ? super String> flds, String prefix, FileStatus status, Configuration conf) {
        flds.put(prefix + "file_size", String.valueOf(status.getLen()));
        flds.put(prefix + "file_mtime", String.valueOf(status.getModificationTime() / 1000L));
        flds.put(prefix + "file_atime", String.valueOf(status.getAccessTime() / 1000L));
        flds.put(prefix + "file_blocksize", String.valueOf(status.getBlockSize()));
        flds.put(prefix + "file_replication", String.valueOf(status.getReplication()));
        flds.put(prefix + "file_perms", String.valueOf(status.getPermission().toShort()));
        flds.put(prefix + "file_owner", status.getOwner());
        flds.put(prefix + "file_group", status.getGroup());
        URI pathUri = status.getPath().toUri();
        String source = VirtualIndex.getSourcePath(pathUri, conf.get("fs.default.name"));
        if (source != null) {
            flds.put(prefix + "source", source);
        }
    }

    public void setMetricsReporter(SearchMetricsReporter smr) {
        this._metrics = smr;
    }

    public boolean matchesIndexedFields(FileStatusExt file) {
        boolean result = this.matchesIndexedFieldsImpl(file);
        boolean isDir = file.isDir();
        if (gLogger.isDebugEnabled()) {
            gLogger.debug((Object)String.format("%s %s the search criteria. Will %sconsider it, path=%s", isDir ? "Dir" : "File", result ? "meets" : "does not meet", result ? "" : "not ", file.getPath()));
        }
        if (!result) {
            if (isDir) {
                ++this._search_filtered_dirs;
            } else {
                ++this._search_filtered_files;
            }
        }
        return result;
    }

    private boolean matchesIndexedFieldsImpl(FileStatusExt file) {
        if (this._se == null) {
            return true;
        }
        try {
            SearchContext sc = new SearchContext(file.getFields());
            VirtualIndex.addFileMetaFields(sc, "", file, this._conf);
            if (file.isDir()) {
                String src = (String)sc.get("source");
                if (!src.endsWith("/")) {
                    src = src + "/";
                }
                sc.put("source", src);
                gLogger.debug((Object)("Updating source in search context to a dir=" + src));
            }
            return this._se.matches(sc, true);
        }
        catch (Exception exception) {
            return true;
        }
    }

    public boolean meetsTimeHeuristic(FileStatus file, long fileET, long fileLT) {
        String type;
        boolean isDir = file.isDir();
        if (isDir) {
            ++this._total_dirs;
        } else {
            ++this._total_files;
        }
        this.updateMetrics(false);
        boolean allTimeSearchOrAllTimeFile = this._searchET == 0L && this._searchLT == 0L || fileET == 0L && fileLT == Long.MAX_VALUE;
        String string = type = isDir ? "Dir" : "File";
        if (!(allTimeSearchOrAllTimeFile || fileET < this._searchLT && fileLT > this._searchET)) {
            if (gLogger.isDebugEnabled()) {
                gLogger.debug((Object)(type + " does not satisfy time heuristic, path=" + file.getPath() + ", search.et=" + this._searchET + ", search.lt=" + this._searchLT + ", file.et=" + fileET + ", file.lt=" + fileLT + ", file.mtime=" + file.getModificationTime() / 1000L));
            }
            if (isDir) {
                ++this._time_filtered_dirs;
            } else {
                ++this._time_filtered_files;
            }
            return false;
        }
        if (gLogger.isDebugEnabled()) {
            gLogger.debug((Object)(type + " meets time heuristic path=" + file.getPath() + ", search.et=" + this._searchET + ", search.lt=" + this._searchLT + ", file.et=" + fileET + ", file.lt=" + fileLT + ", file.mtime=" + file.getModificationTime() / 1000L));
        }
        return true;
    }

    public List<String> getGlobPaths() {
        if (this._rollPath != null) {
            return Arrays.asList(this._rollPath + "/*");
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (VIXPathSpecifier vixPath : this._paths) {
            paths.add(vixPath.getGlobPath());
            this._globPaths.put(vixPath._inputId, vixPath.getGlobPath());
        }
        return paths;
    }

    public String getGlobPath(String inputId) {
        return this._globPaths.get(inputId);
    }

    public List<VIXPathSpecifier> getVIXPathSpecifiers() {
        return this._paths;
    }

    public String getName() {
        return this._name;
    }

    public String getProvider() {
        return this._provider;
    }

    public String getSearch() {
        return this._search;
    }

    public long getSearchET() {
        return this._searchET;
    }

    public void setSearchET(long searchET) {
        this._searchET = searchET;
    }

    public long getSearchLT() {
        return this._searchLT;
    }

    public void setSearchLT(long searchLT) {
        this._searchLT = searchLT;
    }

    public float getSplitSampleRate() {
        return this._splitSampleRate;
    }

    public SearchEvaluator getSearchEvaluator() {
        return this._se;
    }

    protected void setSearchEvaluator(SearchEvaluator se) {
        this._se = se;
    }

    public String getSplitterClass(String inputId) {
        Object result = this._args.get("input." + inputId + ".splitter");
        if (result == null) {
            result = this._args.get("splitter");
        }
        return result == null ? null : String.valueOf(result);
    }

    public boolean isNSCacheEnabled() {
        if (SplunkMR.useProxy(this._conf)) {
            return false;
        }
        Object result = this._args.get("nscache");
        if (result == null) {
            result = this._conf.get("splunk.search.nscache");
        }
        if (result == null) {
            return false;
        }
        return StrUtil.parseBoolean(String.valueOf(result), false);
    }

    public String getNSCacheConf(String confVar, String defaultVal) {
        Object result = this._args.get("nscache." + confVar);
        if (result == null) {
            result = this._conf.get("splunk.search.nscache." + confVar, defaultVal);
        }
        return String.valueOf(result);
    }

    public String getSplitterConf(String inputId, String spName, String confVar, String defaultVal) {
        Object result = this._args.get("input." + inputId + ".splitter." + spName + "." + confVar);
        if (result == null) {
            result = this._args.get("splitter." + spName + "." + confVar);
        }
        if (result == null) {
            return this._conf.get("splunk.search.splitter." + spName + "." + confVar, defaultVal);
        }
        return String.valueOf(result);
    }

    public String getRequiredSplitterConf(String inputId, String spName, String confVar) throws IllegalArgumentException {
        String value = this.getSplitterConf(inputId, spName, confVar, null);
        if (StringUtils.isEmpty((String)value)) {
            throw new IllegalArgumentException("Property " + confVar + " is required and cannot be empty.");
        }
        return value;
    }

    public String getRecordReaderConf(String inputId, String rrName, String confVar) {
        Object result = this._args.get("input." + inputId + ".recordreader." + rrName + "." + confVar);
        if (result == null) {
            result = this._args.get("recordreader." + rrName + "." + confVar);
        }
        return result == null ? null : String.valueOf(result);
    }

    public String getRecordReaderList(String inputId) {
        Object result = this._args.get("input." + inputId + ".recordreader");
        if (result == null) {
            result = this._args.get("recordreader");
        }
        return result == null ? null : String.valueOf(result);
    }

    public String getRequiredFields(String inputId) {
        Object result = this._args.get("input." + inputId + ".required.fields");
        if (result == null) {
            return "";
        }
        return String.valueOf(result);
    }

    public List<String> getRecordReaderList() {
        Object rr;
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, Object> me : this._args.entrySet()) {
            if (me.getValue() == null || !RR_PATTERN.matcher(me.getKey()).matches()) continue;
            result.add(String.valueOf(me.getValue()));
        }
        if (result.isEmpty() && (rr = this._args.get("recordreader")) != null) {
            result.add(String.valueOf(rr));
        }
        return result;
    }

    public String getPropValue(String inputId, String propName, String defaultVal, boolean required) throws IllegalArgumentException {
        Object result = null;
        if (inputId != null) {
            result = this._args.get("input." + inputId + propName);
        }
        if (result == null) {
            result = this._args.get(propName);
        }
        if (result == null) {
            result = this._conf.get("splunk.search." + propName);
        }
        if (result == null || result.toString().trim().length() == 0) {
            if (required) {
                throw new IllegalArgumentException("Property " + propName + " is required and cannot be empty.");
            }
            if (result == null) {
                return defaultVal;
            }
        }
        return String.valueOf(result);
    }

    public void addToBlockedTime(long elapsed) {
        this._blocked_time += elapsed;
    }

    protected void addMetric(SearchMetricsReporter metrics, String name, long elapsed, long value) {
        if ((value > 0L || elapsed > 0L) && metrics != null) {
            metrics.addMetric(this._metricPrefix + name, elapsed, value);
        }
    }

    protected void updateMetrics(boolean force) {
        if (!force && this._total_files % 50L != 0L && System.currentTimeMillis() - this._reported_time < 5000L) {
            return;
        }
        if (this._reported_time == 0L) {
            this._reported_time = this._start_time;
        }
        long now = System.currentTimeMillis();
        long elapsed = now - (this._reported_time + this._blocked_time);
        this.addMetric(this._metrics, ".splits.generation.time", now - this._reported_time, 1L);
        this.addMetric(this._metrics, ".files.listed", elapsed, this._total_files - this._reported_tf);
        this.addMetric(this._metrics, ".files.filter.time", 0L, this._time_filtered_files - this._reported_tff);
        this.addMetric(this._metrics, ".files.filter.search", 0L, this._search_filtered_files - this._reported_sff);
        this.addMetric(this._metrics, ".dirs.listed", elapsed, this._total_dirs - this._reported_td);
        this.addMetric(this._metrics, ".dirs.filter.time", 0L, this._time_filtered_dirs - this._reported_tfd);
        this.addMetric(this._metrics, ".dirs.filter.search", 0L, this._search_filtered_dirs - this._reported_sfd);
        this.addMetric(this._metrics, ".datamodel.files.listed", this._datamodel_lookup_time, this._datamodel_lookup_files);
        this._reported_tf = this._total_files;
        this._reported_tff = this._time_filtered_files;
        this._reported_td = this._total_dirs;
        this._reported_tfd = this._time_filtered_dirs;
        this._reported_sff = this._search_filtered_files;
        this._reported_sfd = this._search_filtered_dirs;
        this._reported_time = now;
        this._blocked_time = 0L;
    }

    public void setDataModelBuckets(DataModelBuckets dataModelBuckets) {
        this._dataModelBuckets = dataModelBuckets;
    }

    public boolean generateSplits(JobContext job, ObjectAcceptor<VixInputSplit> splitAcceptor) throws IOException {
        return this.generateSplits(job, splitAcceptor, null, this._paths);
    }

    public boolean generateSplits(JobContext job, ObjectAcceptor<VixInputSplit> splitAcceptor, FileStatus stats, List<VIXPathSpecifier> vps) throws IOException {
        this._start_time = System.currentTimeMillis();
        Splitter splitter = new Splitter(this, job, splitAcceptor);
        boolean result = true;
        if (this._rollPath != null) {
            Path rootPath = new Path(this._rollPath);
            ConfU.setRollRemoteHome(this._conf, rootPath);
            PathResolver pathResolver = PathResolver.create(this._conf);
            FileSystem fs = new FileSystemWrapper(rootPath.getFileSystem(this._conf));
            FileStatus rootStat = fs.getFileStatus(rootPath);
            CachedFileSystem cfs = null;
            String inputId = "1";
            if (this.isNSCacheEnabled() && rootStat != null && rootStat.isDir()) {
                long st = System.currentTimeMillis();
                try {
                    cfs = new CachedFileSystem(fs, rootStat, this, inputId, true);
                    fs = cfs;
                }
                catch (Exception e) {
                    gLogger.warn((Object)("Failed to instantiate CachedFileSystem. rootPath=" + rootPath + ", vix=" + this._name + ", inputId=" + inputId), (Throwable)e);
                }
                this.addMetric(this._metrics, ".nscache.loaded", System.currentTimeMillis() - st, 1L);
            }
            com.splunk.roll.util.TimeRange range = new com.splunk.roll.util.TimeRange(this._searchLT, this._searchET, TimeUnit.SECONDS);
            Iterable<Bucket.RemoteBucket> bucketIter = pathResolver.resolveBuckets(fs, null, range);
            gLogger.debug((Object)("Resolved buckets at time range: " + range));
            result = splitter.generateSplits(fs, pathResolver, bucketIter, rootPath, inputId);
            if (cfs != null && cfs.isCacheExpired()) {
                long st = System.currentTimeMillis();
                cfs.saveCache();
                this.addMetric(this._metrics, ".nscache.saved", System.currentTimeMillis() - st, 1L);
            }
            this.updateMetrics(true);
        } else {
            result = splitter.generateSplits(stats, vps);
        }
        gLogger.info((Object)String.format("generateSplits done, vix.name=%s, files.total=%d, files.time.filtered=%d, files.search.filtered=%d, files.mr=%d, elapsed=%dms", this._name, this._total_files, this._time_filtered_files, this._search_filtered_files, this._total_files - this._time_filtered_files - this._search_filtered_files, System.currentTimeMillis() - this._start_time));
        return result;
    }

    public static String normalizeInputClassName(String klass) {
        if (!(klass = klass.trim()).contains(".")) {
            return "com.splunk.mr.input." + klass;
        }
        return klass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<VirtualIndex> parseIndexes(Configuration conf) {
        List<VirtualIndex> vix = null;
        ObjectMapper jsonMapper = new ObjectMapper();
        String hash = MD5Hash.digest((String)VirtualIndex.getSplunkArgs(conf)).toString();
        Map<String, List<VirtualIndex>> map = CACHE;
        synchronized (map) {
            vix = CACHE.get(hash);
            if (vix != null) {
                return new ArrayList<VirtualIndex>(vix);
            }
        }
        List indexes_args = VirtualIndex.getIndexes(conf);
        vix = new ArrayList<VirtualIndex>();
        try {
            for (Object idx : indexes_args) {
                Map idx_map = (Map)idx;
                if (!idx_map.containsKey("name")) {
                    gLogger.warn((Object)("Could not find name for index: " + jsonMapper.writeValueAsString((Object)idx_map)));
                    continue;
                }
                vix.add(new VirtualIndex(conf, idx_map.get("name").toString(), idx_map));
            }
        }
        catch (Exception e) {
            gLogger.error((Object)e.getMessage(), (Throwable)e);
        }
        Map<String, List<VirtualIndex>> map2 = CACHE;
        synchronized (map2) {
            CACHE.put(hash, vix);
        }
        return vix;
    }

    public static VirtualIndex parseIndex(Configuration conf, String name) {
        List<VirtualIndex> vix = VirtualIndex.parseIndexes(conf);
        for (VirtualIndex vi : vix) {
            if (!vi.getName().equals(name)) continue;
            return vi;
        }
        return null;
    }

    public static List getIndexes(Configuration conf) {
        ObjectMapper jsonMapper = new ObjectMapper();
        try {
            Map json_conf = (Map)jsonMapper.readValue(VirtualIndex.getSplunkArgs(conf), Map.class);
            Map args_conf = (Map)json_conf.get("conf");
            return (List)args_conf.get("indexes");
        }
        catch (Exception e) {
            gLogger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Map<String, Object> getSearchInfo(Configuration conf) {
        ObjectMapper jsonMapper = new ObjectMapper();
        try {
            Map json_conf = (Map)jsonMapper.readValue(VirtualIndex.getSplunkArgs(conf), Map.class);
            Map args_args = (Map)json_conf.get("args");
            Map args_search = (Map)args_args.get("search");
            Map search_info = (Map)((List)args_search.get("info")).get(0);
            return search_info;
        }
        catch (Exception e) {
            gLogger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static List<String> getFieldsFromSearchPipeline(Configuration conf) {
        ObjectMapper jsonMapper = new ObjectMapper();
        try {
            Map json_conf = (Map)jsonMapper.readValue(VirtualIndex.getSplunkArgs(conf), Map.class);
            Map args_args = (Map)json_conf.get("args");
            Map args_search = (Map)args_args.get("search");
            List search_pipeline = (List)args_search.get("search_pipeline");
            for (Map processor : search_pipeline) {
                String searchString;
                if (!processor.get("name").equals("fields") || !(searchString = (String)processor.get("search_string")).contains("nodename")) continue;
                String[] arr = searchString.split(",");
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = arr[i].trim();
                }
                return new ArrayList<String>(Arrays.asList(arr));
            }
            return Collections.emptyList();
        }
        catch (Exception e) {
            gLogger.error((Object)e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static Map<String, Object> getForwardInfo(Configuration conf) {
        ObjectMapper jsonMapper = new ObjectMapper();
        try {
            Map json_conf = (Map)jsonMapper.readValue(VirtualIndex.getSplunkArgs(conf), Map.class);
            Map args_args = (Map)json_conf.get("args");
            Map args_forward = (Map)args_args.get("forward");
            return args_forward;
        }
        catch (Exception e) {
            gLogger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getSplunkArgs(Configuration conf) {
        return conf.get(SplunkMR.CONF_SPLUNK_ARGS);
    }

    public static void setSplunkArgs(Configuration conf, String json_args) {
        conf.set(SplunkMR.CONF_SPLUNK_ARGS, json_args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Map<String, List<VirtualIndex>> map = CACHE;
        synchronized (map) {
            CACHE.clear();
        }
    }

    private class Splitter {
        private FileSplitter fileSplitter;
        private Map<String, String> fields;
        private VirtualIndex vix;

        public Splitter(VirtualIndex vix, JobContext job, ObjectAcceptor<VixInputSplit> splitAcceptor) {
            this.vix = vix;
            ObjectAcceptor<VixInputSplit> sa = splitAcceptor;
            if (VirtualIndex.this._splitSampleRate < 1.0f) {
                sa = new SampledAcceptor<VixInputSplit>(splitAcceptor, VirtualIndex.this._splitSampleRate);
                gLogger.info((Object)String.format("Using split.sample.rate=%5f, for index=%s", Float.valueOf(VirtualIndex.this._splitSampleRate), VirtualIndex.this.getName()));
            }
            this.fileSplitter = new FileSplitter(job, vix, sa);
            gLogger.info((Object)String.format("generateSplits started, vix.name=%s ... ", VirtualIndex.this._name));
            this.fields = new HashMap<String, String>();
            this.fields.put("index", VirtualIndex.this._name);
        }

        public boolean generateSplits(FileStatus stats, List<VIXPathSpecifier> vps) throws IOException {
            FileSplitGenerator defaultFSG = new FileSplitGenerator();
            String defaultSplitterClass = defaultFSG.getClass().getName();
            HashMap<String, SplitGenerator> class2splitter = new HashMap<String, SplitGenerator>();
            class2splitter.put(defaultSplitterClass, defaultFSG);
            boolean result = true;
            for (VIXPathSpecifier vixPath : vps) {
                SplitGenerator sg;
                String inputId = vixPath.getInputId();
                String klass = VirtualIndex.this.getSplitterClass(inputId);
                if (klass == null) {
                    klass = VirtualIndex.this._conf.get(SplunkMR.CONF_SEARCH_SPLITTER, defaultSplitterClass);
                }
                if ((sg = (SplitGenerator)class2splitter.get(klass = VirtualIndex.normalizeInputClassName(klass))) == null) {
                    sg = (SplitGenerator)ReflectionUtil.newInstance(klass, new Object[0]);
                    class2splitter.put(klass, sg);
                }
                if (gLogger.isDebugEnabled()) {
                    gLogger.debug((Object)String.format("using SplitGenerator class=%s, to split files in index=%s inputId=%s", sg.getClass().getName(), VirtualIndex.this.getName(), inputId));
                }
                this.fileSplitter.setSplitGenerator(sg);
                if (stats == null) {
                    long st;
                    Path rootPath = new Path(vixPath.getGlobPath());
                    if (vixPath.isRecursive()) {
                        rootPath = rootPath.getParent();
                    }
                    FileSystem fs = new FileSystemWrapper(rootPath.getFileSystem(VirtualIndex.this._conf));
                    FileStatus rootStat = fs.getFileStatus(rootPath);
                    CachedFileSystem cfs = null;
                    if (VirtualIndex.this.isNSCacheEnabled() && rootStat != null && rootStat.isDir()) {
                        st = System.currentTimeMillis();
                        try {
                            cfs = new CachedFileSystem(fs, rootStat, this.vix, vixPath.getInputId(), true);
                            fs = cfs;
                        }
                        catch (Exception e) {
                            gLogger.warn((Object)("Failed to instantiate CachedFileSystem. rootPath=" + rootPath + ", vix=" + VirtualIndex.this._name + ", inputId=" + vixPath.getInputId()), (Throwable)e);
                        }
                        VirtualIndex.this.addMetric(VirtualIndex.this._metrics, ".nscache.loaded", System.currentTimeMillis() - st, 1L);
                    }
                    result = vixPath.listStatus(fs, this.fileSplitter, this.fields, true, true, true);
                    if (cfs != null && cfs.isCacheExpired()) {
                        st = System.currentTimeMillis();
                        cfs.saveCache();
                        VirtualIndex.this.addMetric(VirtualIndex.this._metrics, ".nscache.saved", System.currentTimeMillis() - st, 1L);
                    }
                } else {
                    result = this.fileSplitter.accept(new FileStatusExt(stats, inputId, this.fields));
                    VirtualIndex.this._total_files = 1L;
                }
                if (result) continue;
                if (stats == null) break;
                VirtualIndex.this._search_filtered_files = 1L;
                break;
            }
            if (stats == null) {
                VirtualIndex.this.updateMetrics(true);
            }
            return result;
        }

        public boolean generateSplits(FileSystem fs, PathResolver pathResolver, Iterable<Bucket.RemoteBucket> bucketIter, Path rollPath, String inputId) throws IOException {
            FileSplitGenerator sg = new FileSplitGenerator();
            gLogger.debug((Object)String.format("using SplitGenerator class=%s, to split files in index=%s", sg.getClass().getName(), VirtualIndex.this.getName()));
            this.fileSplitter.setSplitGenerator(sg);
            boolean result = true;
            for (Bucket.RemoteBucket b : bucketIter) {
                Path p = new Path(b.getPath(), "journal.gz");
                FileStatusExt fstat = new FileStatusExt(fs.getFileStatus(p), inputId, this.fields);
                fstat.setEarliestTime(b.getTimeRange().getLow(TimeUnit.SECONDS));
                fstat.setLatestTime(b.getTimeRange().getHigh(TimeUnit.SECONDS));
                result = this.fileSplitter.accept(fstat);
                VirtualIndex.this._total_files++;
                if (result) continue;
                break;
            }
            return result;
        }
    }

    static class FileSplitter
    implements ObjectAcceptor<FileStatusExt> {
        SplitGenerator _sg = null;
        VirtualIndex _vix;
        ObjectAcceptor<VixInputSplit> _splitAcceptor;
        JobContext _job;

        public FileSplitter(JobContext job, VirtualIndex vix, ObjectAcceptor<VixInputSplit> acceptor) {
            this._job = job;
            this._vix = vix;
            this._splitAcceptor = acceptor;
        }

        public void setSplitGenerator(SplitGenerator sg) {
            this._sg = sg;
        }

        @Override
        public <T extends FileStatusExt> boolean accept(T fstat) {
            try {
                return this._sg.generateSplits(fstat, this._job, this._vix, this._splitAcceptor);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class VIXBucketSpecifier {
        private final Pattern _pattern;
        private final String _regex;

        public VIXBucketSpecifier(String regex) {
            this._regex = regex;
            this._pattern = Pattern.compile(".*(" + regex + ").*");
        }

        public String getBucketId(Path path) {
            String bucketId = this.doGetBucketId(path);
            gLogger.debug((Object)("Got bucket id for path: " + bucketId));
            return bucketId;
        }

        private String doGetBucketId(Path path) {
            if (this._regex != null) {
                String id = this.getBucketIdByRegex(path);
                String idWithDashes = id.replaceAll("/", "-");
                if (idWithDashes.startsWith("-")) {
                    return idWithDashes.substring(1, idWithDashes.length());
                }
                return idWithDashes;
            }
            return "_no_id";
        }

        private String getBucketIdByRegex(Path path) {
            Matcher matcher = this._pattern.matcher(path.toUri().getPath());
            if (matcher.matches()) {
                if (matcher.groupCount() == 1) {
                    return matcher.group(1);
                }
                StringBuilder sb = new StringBuilder();
                for (int i = 1; i < matcher.groupCount(); ++i) {
                    sb.append(matcher.group(i + 1) + "-");
                }
                return sb.deleteCharAt(sb.length() - 1).toString();
            }
            gLogger.info((Object)("Split's path" + path + ", did not match regex: " + this._regex + ", defaulting to: " + "_no_id"));
            return "_no_id";
        }
    }

    public static class DedupIterator<T>
    implements Iterator<T> {
        private final Iterator<T> it;
        private final Set<String> seen;
        private final StringId<T> stringId;
        private T next;
        private boolean hasSetNext;

        public DedupIterator(Iterator<T> it, Set<String> seen, StringId<T> stringify) {
            this.it = it;
            this.seen = seen;
            this.stringId = stringify;
        }

        @Override
        public boolean hasNext() {
            this.setupNext();
            return this.next != null;
        }

        private void setupNext() {
            if (!this.hasSetNext) {
                this.setNext();
            }
        }

        private void setNext() {
            this.next = null;
            try {
                while (this.it.hasNext()) {
                    T n = this.it.next();
                    String s = this.stringId.getId(n);
                    if (this.isDupe(s)) continue;
                    this.next = n;
                    break;
                }
            }
            finally {
                this.hasSetNext = true;
            }
        }

        private boolean isDupe(String s) {
            if (this.seen.contains(s)) {
                return true;
            }
            this.seen.add(s);
            return false;
        }

        @Override
        public T next() {
            this.setupNext();
            this.hasSetNext = false;
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public static interface StringId<T> {
            public String getId(T var1);
        }
    }

    public static class VIXPathSpecifier {
        public static final String[] ROOT_PATH_PARTS = new String[]{""};
        private String _path = null;
        private String _globpath = null;
        String[] _parts = null;
        private int _origPathDepth;
        private String[] _fieldNames = null;
        private RegexPathFilter _filter = null;
        private RegexPathFilter _blacklist_filter = null;
        private boolean _recursive = false;
        private boolean _hasIndexedFields = false;
        private VixTimeSpecifier _et = null;
        private VixTimeSpecifier _lt = null;
        private VirtualIndex _parent = null;
        private String _inputId = null;
        private VIXBucketSpecifier _bucket = null;
        private VIXBucketSpecifier _dataModelBucket = null;
        public static final Pattern FIELD_PLACEHOLDER = Pattern.compile("\\$\\{([^}/]+)\\}");
        public static final Pattern FS_SEP = Pattern.compile("/");
        static final char AUTO_KV_DELIM = '=';

        public static String[] convertToPathParts(Path path) {
            return FS_SEP.split(path.toUri().getPath());
        }

        public int getOrigPathDepth() {
            return this._origPathDepth;
        }

        public VIXPathSpecifier(VirtualIndex parent, String inputId, String path, String whitelist, String blacklist, VixTimeSpecifier et, VixTimeSpecifier lt, VIXBucketSpecifier bucket, VIXBucketSpecifier dataModelBucket) {
            this._parent = parent;
            this._inputId = inputId;
            this._path = path;
            this._recursive = path.endsWith("...");
            this._filter = new RegexPathFilter(whitelist, blacklist);
            this._blacklist_filter = new RegexPathFilter(null, blacklist);
            this._globpath = this._recursive ? this._path.substring(0, path.length() - 3) + "*" : this._path;
            int tmp = this._globpath.indexOf("://");
            if (tmp < 0) {
                tmp = 0;
            } else if ((tmp = this._globpath.indexOf("/", tmp + 3)) < 0) {
                tmp = 0;
            }
            this._parts = FS_SEP.split(this._globpath.substring(tmp));
            this._fieldNames = new String[this._parts.length];
            this._origPathDepth = this._parts.length;
            for (int i = 0; i < this._parts.length; ++i) {
                Matcher m = FIELD_PLACEHOLDER.matcher(this._parts[i]);
                this._fieldNames[i] = null;
                if (!m.matches()) continue;
                this._hasIndexedFields = true;
                this._fieldNames[i] = m.group(1);
            }
            this._et = et;
            this._lt = lt;
            this._bucket = bucket;
            this._dataModelBucket = dataModelBucket;
            this._globpath = FIELD_PLACEHOLDER.matcher(this._globpath).replaceAll("*");
            this._parts = FS_SEP.split(this._globpath.substring(tmp));
            int firstStar = this._globpath.indexOf(42);
            if (firstStar > 0) {
                this._globpath = this._globpath.substring(0, firstStar + 1);
            }
            gLogger.debug((Object)("VIXPathSpecifier globpath=" + this._globpath + ", accept=" + whitelist + ", ignore=" + blacklist));
        }

        public void extractHivePartitionKeys(HiveMetaStoreUtils.HivePartitionInfo samplePartition) {
            try {
                gLogger.debug((Object)("parts=" + Arrays.toString(this._parts) + ", fieldNames=" + Arrays.toString(this._fieldNames) + ", sp.location=" + samplePartition.location + ", sp.kvs=" + samplePartition.kvs));
                for (String fieldName : this._fieldNames) {
                    if (!samplePartition.kvs.containsKey(fieldName)) continue;
                    throw new IllegalArgumentException("User defined field name on vix input path conflicts with hive partition key. fieldName=" + fieldName + ", partitionKeys=" + samplePartition.kvs.keySet());
                }
                Path p = new Path(samplePartition.location);
                String[] locParts = VIXPathSpecifier.convertToPathParts(p);
                if (!this._recursive) {
                    throw new IllegalArgumentException("Invalid vix input path: must be a recursive path for partitioned hive table.vix.input." + this._inputId + ".path=" + this._path);
                }
                int firstPKeyIdx = this._parts.length - 1;
                if (firstPKeyIdx + samplePartition.kvs.size() > locParts.length) {
                    throw new IllegalArgumentException("Index out of bound: firstPKeyIdx plus number of partition keys must be less than or equals to the number of segments of partition location.vix.input." + this._inputId + ".path=" + this._path + ", sp.location=" + samplePartition.location + ", sp.kvs=" + samplePartition.kvs + ", firstPKeyIdx=" + firstPKeyIdx);
                }
                for (int i = 0; i < firstPKeyIdx; ++i) {
                    if (this._parts[i].equals(locParts[i])) continue;
                    throw new IllegalArgumentException("Invalid vix input path: must point to the parent directory of the first hive partition key directory.vix.input." + this._inputId + ".path=" + this._path + ", sp.location=" + samplePartition.location + ", sp.kvs=" + samplePartition.kvs + ", firstPKeyIdx=" + firstPKeyIdx);
                }
                if (firstPKeyIdx != this._fieldNames.length - 1) {
                    throw new IllegalStateException("Index out of bound. firstPKeyIdx=" + firstPKeyIdx + ", _fieldNames.length=" + this._fieldNames.length);
                }
                Iterator<Map.Entry<String, String>> iter = samplePartition.kvs.entrySet().iterator();
                Map.Entry<String, String> e = iter.next();
                String[] fieldNames = new String[locParts.length];
                System.arraycopy(this._fieldNames, 0, fieldNames, 0, firstPKeyIdx);
                for (int i = firstPKeyIdx; i < locParts.length; ++i) {
                    if (!locParts[i].matches(e.getKey() + ".*" + e.getValue()) && !locParts[i].equals(e.getValue())) continue;
                    fieldNames[i] = e.getKey();
                    if (!iter.hasNext()) break;
                    e = iter.next();
                }
                if (iter.hasNext()) {
                    throw new IllegalStateException("Cannot find all partition keys/values from location path starting from vix input path. vix.input." + this._inputId + ".path=" + this._path + ", sp.location=" + samplePartition.location + ", sp.kvs=" + samplePartition.kvs + ", firstPKeyIdx=" + firstPKeyIdx);
                }
                this._fieldNames = fieldNames;
                this._hasIndexedFields = true;
                gLogger.debug((Object)("Finish extracting hive partition keys. fieldNames=" + Arrays.toString(this._fieldNames)));
            }
            catch (Throwable t) {
                gLogger.error((Object)"Failed to extract hive partition keys", t);
            }
        }

        public String getGlobPath() {
            return this._globpath;
        }

        public String[] getFieldNames() {
            return this._fieldNames;
        }

        public String getInputId() {
            return this._inputId;
        }

        public RegexPathFilter getFilter() {
            return this._filter;
        }

        public RegexPathFilter getBlacklistFilter() {
            return this._blacklist_filter;
        }

        public boolean isRecursive() {
            return this._recursive;
        }

        public boolean isAcceptablePathForBrowse(FileStatus fstat) {
            int browsePathDepth = fstat.getPath().depth();
            if (!this.isRecursive() && this._origPathDepth == 0 && browsePathDepth == 1) {
                return true;
            }
            if (gLogger.isDebugEnabled()) {
                gLogger.debug((Object)("filter unaacceptable paths, browse_path=" + fstat.getPath() + " browse_path_depth=" + browsePathDepth + " _origPathDepth=" + this._origPathDepth + " _parts=" + Arrays.toString(this._parts)));
            }
            String[] browsePathParts = VIXPathSpecifier.convertToPathParts(fstat.getPath());
            if (fstat.isDir()) {
                if ((this.isRecursive() || browsePathDepth <= this._origPathDepth) && this.isDirGlobAcceptable(browsePathParts)) {
                    return true;
                }
            } else {
                int normalizedOrigPathDepth;
                int n = normalizedOrigPathDepth = this.isRecursive() ? this._origPathDepth - 1 : this._origPathDepth;
                if (browsePathDepth >= normalizedOrigPathDepth ? this.isRecursive() || browsePathDepth < normalizedOrigPathDepth + 1 : browsePathDepth == normalizedOrigPathDepth - 1) {
                    return this.isFileGlobAcceptable(browsePathParts) && this.getFilter().accept(fstat.getPath());
                }
            }
            return false;
        }

        public boolean canBrowse(FileStatus fstat) {
            return !fstat.isDir() || this.isRecursive() || fstat.getPath().depth() < this._origPathDepth;
        }

        protected boolean isFileGlobAcceptable(String[] pathParts) {
            if (pathParts.length < this._parts.length) {
                return false;
            }
            for (int i = 0; i < this._parts.length; ++i) {
                if (this._parts[i].equals("*") || pathParts[i].equals(this._parts[i])) continue;
                return false;
            }
            return true;
        }

        private boolean isDirGlobAcceptable(String[] pathParts) {
            for (int i = 0; i < this._parts.length && i < pathParts.length; ++i) {
                if (this._parts[i].equals("*") || pathParts[i].equals(this._parts[i])) continue;
                return false;
            }
            return true;
        }

        public boolean isPathWithinIndexScope(String[] pathParts, boolean isDir) {
            if (gLogger.isDebugEnabled()) {
                gLogger.debug((Object)("_parts.size=" + this._parts.length + ", _parts=" + Arrays.toString(this._parts) + ", testParts.size=" + pathParts.length + ", testParts=" + Arrays.toString(pathParts)));
            }
            if (!this.shouldTraverseDir(pathParts)) {
                return false;
            }
            if (this._parts.length < pathParts.length) {
                if (this._parts.length == 0) {
                    boolean startsCorrectly = ROOT_PATH_PARTS[0].equals(pathParts[0]);
                    return startsCorrectly && pathParts.length <= 2 && (pathParts.length != 2 || !isDir);
                }
                if (!this.isRecursive() && (isDir || pathParts.length > this._parts.length + 1)) {
                    return false;
                }
            } else if (this._parts.length > pathParts.length && !isDir) {
                return false;
            }
            return true;
        }

        public boolean shouldTraverseDir(String[] pathParts) {
            for (int i = 0; i < this._parts.length && i < pathParts.length; ++i) {
                if (this._parts[i].equals("*") || pathParts[i].equals(this._parts[i])) continue;
                return false;
            }
            return true;
        }

        protected FileStatusExt getFileStatusExt(FileStatus status, Map<String, String> fields) {
            String path = status.getPath().toUri().getPath();
            String[] pathParts = FS_SEP.split(path);
            return this.getFileStatusExt(status, fields, path, pathParts);
        }

        protected FileStatusExt getFileStatusExt(FileStatus status, Map<String, String> fields, String path, String[] pathParts) {
            boolean doAutokv;
            HashMap<String, String> flds = new HashMap<String, String>(fields);
            boolean bl = doAutokv = path.indexOf(61) > -1;
            if (this._hasIndexedFields || doAutokv) {
                for (int i = 0; i < pathParts.length; ++i) {
                    int eqIdx;
                    if (i < this._fieldNames.length && this._fieldNames[i] != null) {
                        flds.put(this._fieldNames[i], pathParts[i]);
                    }
                    if (!doAutokv || (eqIdx = pathParts[i].indexOf(61)) <= 0) continue;
                    flds.put(pathParts[i].substring(0, eqIdx), pathParts[i].substring(eqIdx + 1));
                }
            }
            return new FileStatusExt(status, this._inputId, flds);
        }

        protected boolean addStatus(FileSplitter acceptor, FileStatus srcStat, FileStatus dmStat, String inputId, Map<String, String> fields, FileSystem fs, long fileET, long fileLT, String bucketId) throws IOException {
            FileStatusExt fext;
            String path = srcStat.getPath().toUri().getPath();
            String[] pathParts = FS_SEP.split(path);
            if (!this.isFileGlobAcceptable(pathParts)) {
                if (gLogger.isDebugEnabled()) {
                    gLogger.debug((Object)String.format("File not allowed by input.path glob pattern, path=%s", srcStat.getPath().toUri().getPath()));
                }
                return true;
            }
            if (this._parent != null && !this._parent.meetsTimeHeuristic(srcStat, fileET, fileLT)) {
                return true;
            }
            FileStatusExt srcFext = this.getFileStatusExt(srcStat, fields, path, pathParts);
            FileStatusExt fileStatusExt = fext = dmStat == null ? srcFext : new FileStatusExt(dmStat, inputId, fields);
            if (this._parent != null && !this._parent.matchesIndexedFields(srcFext)) {
                return true;
            }
            if (fileET != 0L) {
                fext.setEarliestTime(fileET);
            }
            if (fileLT != 0L) {
                fext.setLatestTime(fileLT);
            }
            fext.setBucketId(bucketId);
            fext.getFields().put("source", VirtualIndex.getSourcePath(srcStat.getPath().toUri(), FileSystem.getDefaultUri((Configuration)fs.getConf()).toString()));
            long st = System.currentTimeMillis();
            boolean result = acceptor.accept(fext);
            if (this._parent != null) {
                this._parent.addToBlockedTime(System.currentTimeMillis() - st);
            }
            return result;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        public boolean listStatus(FileSystem fs, FileSplitter acceptor, Map<String, String> fields, boolean addStatus, boolean matchesIndexedFields, boolean meetTimeHeuristic) throws IOException {
            FileStatusMTimeComparator comparator = new FileStatusMTimeComparator();
            PriorityQueue<FileStatus> pq = new PriorityQueue<FileStatus>(500, comparator);
            Path p = null;
            boolean firstTime = true;
            HashSet<String> listedPaths = new HashSet<String>();
            SplitGenerator srcSplitter = acceptor._sg;
            Object var13_13 = null;
            boolean readFromDM = SplunkMR.readFromDataModel(fs.getConf());
            boolean writeToDM = SplunkMR.writeToDataModel(fs.getConf());
            boolean summariesOnly = StrUtil.parseBoolean(this._parent._conf.get(SplunkMR.CONF_DATAMODEL_SUMMARIES_ONLY), false);
            WriterFactory.Format format = WriterFactory.Format.valueOf(this._parent._conf.get(SplunkMR.CONF_DATASOURCE_FORMAT, "orc"));
            gLogger.debug((Object)("readFromDM=" + readFromDM + ", writeToDM=" + writeToDM));
            if (readFromDM || writeToDM) {
                gLogger.debug((Object)("summariesOnly=" + summariesOnly + ", format=" + (Object)((Object)format)));
                if (format == WriterFactory.Format.orc) {
                    HiveSplitGenerator hiveSplitGenerator = new HiveSplitGenerator(true);
                } else if (format == WriterFactory.Format.parquet) {
                    ParquetSplitGenerator parquetSplitGenerator = new ParquetSplitGenerator(true);
                }
            }
            if (writeToDM) {
                if (!(srcSplitter instanceof FileSplitGenerator)) {
                    throw new RuntimeException("Expecting a FileSplitGenerator, but found " + srcSplitter.getClass().getName());
                }
                ((FileSplitGenerator)srcSplitter).forceNotSplit();
            }
            long totalDMLookupTime = 0L;
            do {
                RegexPathFilter filter;
                if (firstTime) {
                    p = new Path(this._globpath);
                } else {
                    FileStatus dmStat = null;
                    FileStatus fstat = pq.poll();
                    acceptor.setSplitGenerator(srcSplitter);
                    if (gLogger.isDebugEnabled()) {
                        gLogger.debug((Object)("working on path=" + fstat.getPath() + ", mtime=" + fstat.getModificationTime() + ", isDir=" + fstat.isDir()));
                    }
                    if (!fstat.isDir()) {
                        String bucketId;
                        long fileLT;
                        long fileET;
                        block26: {
                            fileET = this._et.getTime(fstat, 0L);
                            fileLT = this._lt.getTime(fstat, Long.MAX_VALUE);
                            if (this._parent._dataModelBuckets != null) {
                                long st = System.nanoTime();
                                bucketId = this._dataModelBucket.getBucketId(fstat.getPath());
                                String bucketKey = this._parent.getName() + "+" + bucketId;
                                this._parent._dataModelBuckets.initForBucket(fs, this._parent._conf, this._parent._name, bucketId, writeToDM);
                                dmStat = this._parent._dataModelBuckets.retrieveFromCache(bucketKey, fstat.getPath(), fileET, fileLT);
                                totalDMLookupTime += System.nanoTime() - st;
                                if (dmStat != null) {
                                    ++this._parent._datamodel_lookup_files;
                                    if (gLogger.isDebugEnabled()) {
                                        gLogger.debug((Object)("Found a data model file " + dmStat.getPath().toUri().getPath()));
                                    }
                                    if (readFromDM) {
                                        void var13_16;
                                        acceptor.setSplitGenerator((SplitGenerator)var13_16);
                                        break block26;
                                    } else {
                                        if (writeToDM) continue;
                                        throw new IllegalStateException("Either read from or write to data model.");
                                    }
                                }
                                if (readFromDM && summariesOnly) continue;
                                if (writeToDM) {
                                    gLogger.debug((Object)"Raw file has not been accelerated, need DMA file creation");
                                    this._parent._dataModelBuckets.updateOrigDataSizeMap(bucketKey, fstat, fileET, fileLT);
                                }
                            } else {
                                bucketId = this._bucket.getBucketId(fstat.getPath());
                            }
                        }
                        if (!addStatus || this.addStatus(acceptor, fstat, dmStat, this._inputId, fields, fs, fileET, fileLT, bucketId)) continue;
                        if (readFromDM || writeToDM) {
                            this._parent._datamodel_lookup_time += totalDMLookupTime / 1000000L;
                        }
                        return false;
                    }
                    if (!this.shouldTraverseDir(VIXPathSpecifier.convertToPathParts(fstat.getPath()))) {
                        if (!gLogger.isDebugEnabled()) continue;
                        gLogger.debug((Object)String.format("dir=%s, not allowed by input.path, ignoring ...", fstat.getPath()));
                        continue;
                    }
                    if (matchesIndexedFields && !this._parent.matchesIndexedFields(this.getFileStatusExt(fstat, fields))) continue;
                    if (meetTimeHeuristic && !this._parent.meetsTimeHeuristic(fstat, this._et.getTime(fstat, 0L), this._lt.getTime(fstat, Long.MAX_VALUE))) {
                        if (!gLogger.isDebugEnabled()) continue;
                        gLogger.debug((Object)String.format("dir=%s, mtime=%d does not meet the time heuristic, ignoring ...", fstat.getPath(), fstat.getModificationTime() / 1000L));
                        continue;
                    }
                    p = fstat.getPath();
                }
                FileStatus[] matches = null;
                RegexPathFilter regexPathFilter = filter = this._recursive ? this._blacklist_filter : this._filter;
                if (firstTime) {
                    matches = fs.globStatus(p, (PathFilter)filter);
                    firstTime = false;
                } else {
                    matches = fs.listStatus(p, (PathFilter)filter);
                }
                Iterable<FileStatus> dedupedByPath = VIXPathSpecifier.dedupPaths(listedPaths, this.asListNullSafe(matches));
                for (FileStatus globStat : dedupedByPath) {
                    if (globStat.isDir()) {
                        if (!this._recursive && globStat.getPath().depth() >= this._origPathDepth && (globStat.getPath().depth() != 0 || this._origPathDepth != 0)) continue;
                        pq.offer(globStat);
                        continue;
                    }
                    if (this._recursive && !this._filter.accept(globStat.getPath())) continue;
                    pq.offer(globStat);
                }
            } while (!pq.isEmpty());
            if (readFromDM || writeToDM) {
                this._parent._datamodel_lookup_time += totalDMLookupTime / 1000000L;
            }
            return true;
        }

        private List<FileStatus> asListNullSafe(FileStatus[] statuses) {
            return statuses != null ? Arrays.asList(statuses) : new ArrayList<FileStatus>();
        }

        private static Iterable<FileStatus> dedupPaths(final Set<String> paths, final List<FileStatus> list) {
            return new Iterable<FileStatus>(){

                @Override
                public Iterator<FileStatus> iterator() {
                    return new DedupIterator<FileStatus>(list.iterator(), paths, new DedupIterator.StringId<FileStatus>(){

                        @Override
                        public String getId(FileStatus t) {
                            return t.getPath().toUri().getPath();
                        }
                    });
                }
            };
        }

        static class FileStatusMTimeComparator
        implements Comparator<FileStatus> {
            FileStatusMTimeComparator() {
            }

            @Override
            public int compare(FileStatus o1, FileStatus o2) {
                return o1.getModificationTime() > o2.getModificationTime() ? -1 : (o1.getModificationTime() < o2.getModificationTime() ? 1 : 0);
            }
        }
    }

    public static class RegexPathFilter
    implements PathFilter {
        Pattern _whitelist = null;
        Pattern _blacklist = null;

        public RegexPathFilter(String whitelist, String blacklist) {
            if (whitelist != null && whitelist.length() > 0) {
                this._whitelist = Pattern.compile(whitelist);
            }
            if (blacklist != null && blacklist.length() > 0) {
                this._blacklist = Pattern.compile(blacklist);
            }
        }

        public boolean accept(Path path) {
            String pathStr = path.toString();
            if (this._blacklist != null && this._blacklist.matcher(pathStr).find()) {
                return false;
            }
            return this._whitelist == null || this._whitelist.matcher(pathStr).find();
        }
    }

    private static class FileSystemWrapper
    extends FileSystem {
        FileSystem _fs;

        public FileSystemWrapper(FileSystem _fs) {
            this._fs = _fs;
        }

        public FileStatus[] listStatus(Path path) throws IOException {
            try {
                return this._fs.listStatus(path);
            }
            catch (IOException ex) {
                if (!(ex instanceof AccessControlException)) {
                    throw ex;
                }
                gLogger.warn((Object)("Permission denied, ignoring path=" + path));
                return new FileStatus[0];
            }
        }

        public FileStatus getFileStatus(Path arg0) throws IOException {
            return this._fs.getFileStatus(arg0);
        }

        public FSDataOutputStream append(Path arg0, int arg1, Progressable arg2) throws IOException {
            return this._fs.append(arg0, arg1, arg2);
        }

        public FSDataOutputStream create(Path arg0, FsPermission arg1, boolean arg2, int arg3, short arg4, long arg5, Progressable arg6) throws IOException {
            return this._fs.create(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
        }

        public boolean delete(Path arg0, boolean arg1) throws IOException {
            return this._fs.delete(arg0, arg1);
        }

        public boolean delete(Path arg0) throws IOException {
            return this._fs.delete(arg0);
        }

        public URI getUri() {
            return this._fs.getUri();
        }

        public Path getWorkingDirectory() {
            return this._fs.getWorkingDirectory();
        }

        public boolean mkdirs(Path arg0, FsPermission arg1) throws IOException {
            return this._fs.mkdirs(arg0, arg1);
        }

        public FSDataInputStream open(Path arg0, int arg1) throws IOException {
            return this._fs.open(arg0, arg1);
        }

        public boolean rename(Path arg0, Path arg1) throws IOException {
            return this._fs.rename(arg0, arg1);
        }

        public void setWorkingDirectory(Path arg0) {
            this._fs.setWorkingDirectory(arg0);
        }

        public Configuration getConf() {
            return this._fs.getConf();
        }
    }
}

