/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.roll.slices;

import com.splunk.mr.SplunkMR;
import com.splunk.roll.slices.Slice;
import com.splunk.roll.slices.Slices;
import com.splunk.roll.slices.SplunkdSliceMetadataProvider;
import com.splunk.roll.util.ConfU;
import com.splunk.util.FunctionUtils;
import com.splunk.util.GzipOnTheFlyInputStream;
import com.splunk.util.Lazy;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class BucketRawdataProvider {
    private static final Logger gLogger = Logger.getLogger(BucketRawdataProvider.class);
    public static final String COMPRESSED_LENGTH = "compressed_length";
    public static final String SLICE_MANIFEST_FILENAME = "slicesv2.dat";
    private static final Pattern SLICE_FILENAME_PATTERN = Pattern.compile("\\d+");
    private final SliceMetadataProvider sliceMetaProvider;
    private final Configuration conf;

    public BucketRawdataProvider(Configuration conf, SliceMetadataProvider sliceManifestProvider) {
        this.conf = conf;
        this.sliceMetaProvider = sliceManifestProvider;
    }

    public BucketRawdata getRawdata(File rawDataDir) throws IOException {
        Slices slices = BucketRawdataProvider.addCompressedLength(this.sliceMetaProvider.getSliceMetadata(rawDataDir));
        if (!ConfU.isJournalFixingEnabled(this.conf)) {
            gLogger.debug((Object)("Feature for fixing journal.gz is disabled. Will return an input stream to the journal as is. " + BucketRawdataProvider.loggingContext(rawDataDir)));
            return this.unmodifiedJournalStream(rawDataDir, slices);
        }
        return this.doGetInputStream(rawDataDir, slices);
    }

    private BucketRawdata unmodifiedJournalStream(File rawDataDir, Slices slices) throws IOException {
        return BucketRawdataProvider.wrapSlicesAndStream(BucketRawdataProvider.setCompressedLengthOnLastSlice(slices, BucketRawdataProvider.getJournal(rawDataDir)), BucketRawdataProvider.getJournalInputStream(rawDataDir));
    }

    private static BucketRawdata wrapSlicesAndStream(Slices mergedSlices, Lazy<InputStream> journalInputStream) {
        return new BucketRawdata(mergedSlices, journalInputStream);
    }

    private static Slices setCompressedLengthOnLastSlice(Slices slices, File journal) {
        if (!slices.isEmpty()) {
            int lastSliceIndex = slices.size() - 1;
            Slice lastSlice = slices.get(lastSliceIndex);
            long compressedLength = journal.length() - lastSlice.getCompressedOffset();
            slices.set(COMPRESSED_LENGTH, lastSliceIndex, compressedLength);
        }
        return slices;
    }

    static String loggingContext(File rawDataDir) {
        return "bucket_rawdata_path=" + rawDataDir.getAbsolutePath();
    }

    private BucketRawdata doGetInputStream(File rawDataDir, Slices slices) throws IOException, FileNotFoundException {
        List<File> sliceFiles = BucketRawdataProvider.listSlices(rawDataDir);
        if (sliceFiles.isEmpty()) {
            gLogger.debug((Object)("There are no slices to be merged with the journal. " + BucketRawdataProvider.loggingContext(rawDataDir)));
            return this.unmodifiedJournalStream(rawDataDir, slices);
        }
        List<Slice> missingSlices = BucketRawdataProvider.getMissingSlices(rawDataDir, slices, sliceFiles);
        if (missingSlices.isEmpty()) {
            gLogger.debug((Object)("There are no slices missing from the journal. " + BucketRawdataProvider.loggingContext(rawDataDir)));
            return this.unmodifiedJournalStream(rawDataDir, slices);
        }
        gLogger.info((Object)("There are slices missing from the journal. Will concatenate the journal with the missing slices. missing_slices_count: " + missingSlices.size() + " " + BucketRawdataProvider.loggingContext(rawDataDir)));
        return BucketRawdataProvider.concatenateJournalWithMissingSlices(rawDataDir, missingSlices, slices);
    }

    static Slices addCompressedLength(Slices slices) {
        ArrayList<Long> compressedLengths = new ArrayList<Long>();
        int i = 0;
        for (Slice slice : slices) {
            boolean isAtLastSlice;
            int next = i + 1;
            boolean bl = isAtLastSlice = slices.size() == next;
            if (isAtLastSlice) {
                compressedLengths.add(null);
            } else {
                Slice nextSlice = slices.get(next);
                long sliceOffset = slice.getCompressedOffset();
                long nextOffset = nextSlice.getCompressedOffset();
                compressedLengths.add(nextOffset - sliceOffset);
            }
            ++i;
        }
        slices.addNewValueToSlices(COMPRESSED_LENGTH, compressedLengths);
        return slices;
    }

    private static List<Slice> getMissingSlices(File rawDataDir, Slices slices, List<File> sliceFiles) throws FileNotFoundException, IOException {
        List<Slice> slicesMissingFromMetadata = BucketRawdataProvider.getSlicesMissingFromMetadata(rawDataDir, slices);
        slices.crop(slices.size() - slicesMissingFromMetadata.size());
        BucketRawdataProvider.setSizeOnLastSlice(slices, rawDataDir);
        List<Slice> slicesMissingFromFiles = BucketRawdataProvider.getSlicesMissingFromFiles(slices, sliceFiles, slicesMissingFromMetadata);
        ArrayList<Slice> missingSlices = new ArrayList<Slice>();
        missingSlices.addAll(slicesMissingFromMetadata);
        missingSlices.addAll(slicesMissingFromFiles);
        return missingSlices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setSizeOnLastSlice(Slices slices, File rawDataDir) throws IOException {
        if (!slices.isEmpty()) {
            int lastSliceIndex = slices.size() - 1;
            Slice lastSlice = slices.get(lastSliceIndex);
            FileInputStream fis = null;
            try {
                File journal = BucketRawdataProvider.getJournal(rawDataDir);
                fis = FileUtils.openInputStream((File)journal);
                BucketRawdataProvider.validateCompressedRead(rawDataDir, lastSlice, BucketRawdataProvider.skip(fis, lastSlice.getCompressedOffset()));
                long positionAtOffset = fis.getChannel().position();
                BufferedInputStream bufIn = new BufferedInputStream(fis);
                boolean decompressConcatenated = false;
                GzipCompressorInputStream uncompressedIn = new GzipCompressorInputStream((InputStream)bufIn, decompressConcatenated);
                BucketRawdataProvider.validateUncompressedRead(rawDataDir, lastSlice, BucketRawdataProvider.skip((InputStream)uncompressedIn, lastSlice.getUncompressedLength()));
                long restTheJournal = IOUtils.copyLarge((InputStream)bufIn, (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
                long sliceEndPosition = journal.length() - restTheJournal;
                long compressedLength = sliceEndPosition - positionAtOffset;
                slices.set(COMPRESSED_LENGTH, lastSliceIndex, compressedLength);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fis);
        }
    }

    private static void validateCompressedRead(File rawDataDir, Slice lastSlice, long compressedRead) {
        if (compressedRead != lastSlice.getCompressedOffset()) {
            throw new RuntimeException("Was not able to skip the whole slice: " + lastSlice.getUncompressedOffset() + " " + BucketRawdataProvider.loggingContext(rawDataDir));
        }
    }

    private static void validateUncompressedRead(File rawDataDir, Slice lastSlice, long uncompressedRead) {
        if (uncompressedRead != lastSlice.getUncompressedLength()) {
            throw new RuntimeException("Did not get the expected length of bytes back. Should have gotten uncompressed_length=" + lastSlice.getUncompressedLength() + " got: " + uncompressedRead + " " + BucketRawdataProvider.loggingContext(rawDataDir));
        }
    }

    private static List<Slice> getSlicesMissingFromMetadata(final File rawDataDir, Slices slices) throws IOException {
        File journal = BucketRawdataProvider.getJournal(rawDataDir);
        ArrayList<Slice> missingSlices = new ArrayList<Slice>();
        for (Slice slice : BucketRawdataProvider.keepPossiblyMissingSlices(journal.length(), slices)) {
            if (!BucketRawdataProvider.isSliceMissing(journal, slice)) continue;
            missingSlices.add(slice);
        }
        return FunctionUtils.map(missingSlices, new FunctionUtils.Fn<Slice, Slice>(){

            @Override
            public Slice apply(Slice slice) throws Exception {
                if (slice.get(BucketRawdataProvider.COMPRESSED_LENGTH) == Slices.DEFAULT_MISSING_VALUE) {
                    long compressedLength = BucketRawdataProvider.getCompressedLength(BucketRawdataProvider.getSliceFile(rawDataDir, slice));
                    slice.put(BucketRawdataProvider.COMPRESSED_LENGTH, compressedLength);
                }
                return slice;
            }
        });
    }

    private static File getSliceFile(File rawDataDir, Slice slice) throws FileNotFoundException {
        File file = new File(rawDataDir, slice.getUncompressedOffset() + "");
        if (!file.exists()) {
            throw new FileNotFoundException("slice_file=" + file.getName() + " could not find slice file for slice=" + slice + " in dir=" + rawDataDir);
        }
        return file;
    }

    private static List<Slice> getSlicesMissingFromFiles(Slices slices, List<File> sliceFiles, List<Slice> slicesMissingFromMetadata) {
        HashSet<Long> uncompressedOffsets = new HashSet<Long>();
        for (Slice slice : slices) {
            uncompressedOffsets.add(slice.getUncompressedOffset());
        }
        for (Slice slice : slicesMissingFromMetadata) {
            uncompressedOffsets.add(slice.getUncompressedOffset());
        }
        ArrayList<File> sliceFilesNotInMetadata = new ArrayList<File>();
        for (File f : sliceFiles) {
            if (uncompressedOffsets.contains(Long.parseLong(f.getName()))) continue;
            sliceFilesNotInMetadata.add(f);
        }
        final long[] lArray = BucketRawdataProvider.getOffsets(BucketRawdataProvider.findLastSlice(slices, slicesMissingFromMetadata));
        return FunctionUtils.map(sliceFilesNotInMetadata, new FunctionUtils.Fn<File, Slice>(){

            @Override
            public Slice apply(File f) throws Exception {
                Slice slice = BucketRawdataProvider.toSlice(f, lArray[0], lArray[1]);
                lArray[0] = lArray[0] + (Long)slice.get(BucketRawdataProvider.COMPRESSED_LENGTH);
                lArray[1] = lArray[1] + slice.getUncompressedLength();
                return slice;
            }
        });
    }

    private static Slice findLastSlice(Slices slices, List<Slice> missingSlices) {
        if (!missingSlices.isEmpty()) {
            return missingSlices.get(missingSlices.size() - 1);
        }
        if (!slices.isEmpty()) {
            return slices.getLast();
        }
        return null;
    }

    private static long[] getOffsets(Slice lastSlice) {
        if (lastSlice == null) {
            return new long[]{0L, 0L};
        }
        long compressedOffset = lastSlice.getCompressedOffset() + (Long)lastSlice.get(COMPRESSED_LENGTH);
        long uncompressedOffset = lastSlice.getUncompressedOffset() + lastSlice.getUncompressedLength();
        return new long[]{compressedOffset, uncompressedOffset};
    }

    static List<Slice> keepPossiblyMissingSlices(final long journalSize, Iterable<Slice> slices) {
        return FunctionUtils.keep(slices, new FunctionUtils.Predicate<Slice>(){

            @Override
            public boolean test(Slice slice) {
                if (slice.get(BucketRawdataProvider.COMPRESSED_LENGTH) != null) {
                    long length = (Long)slice.get(BucketRawdataProvider.COMPRESSED_LENGTH);
                    long sliceEnd = slice.getCompressedOffset() + length;
                    if (sliceEnd < journalSize) {
                        return false;
                    }
                }
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isSliceMissing(File journal, Slice slice) throws IOException {
        boolean bl;
        FileInputStream fin = null;
        GZIPInputStream gin = null;
        try {
            fin = new FileInputStream(journal);
            fin.skip(slice.getCompressedOffset());
            gin = new GZIPInputStream(fin);
            long expectedSkip = slice.getUncompressedLength();
            long actualSkip = BucketRawdataProvider.skip(gin, expectedSkip);
            bl = actualSkip < expectedSkip;
            IOUtils.closeQuietly((InputStream)gin);
        }
        catch (EOFException e) {
            boolean bl2 = true;
            return bl2;
        }
        finally {
            IOUtils.closeQuietly(gin);
            IOUtils.closeQuietly((InputStream)fin);
        }
        IOUtils.closeQuietly((InputStream)fin);
        return bl;
    }

    private static BucketRawdata concatenateJournalWithMissingSlices(File rawDataDir, List<Slice> missingSlices, Slices slices) throws IOException {
        long[] offsets = BucketRawdataProvider.getFirstMissingSliceOffsets(missingSlices, slices);
        final ArrayList<Lazy<InputStream>> inputStreams = new ArrayList<Lazy<InputStream>>();
        long cropPosition = offsets[0];
        inputStreams.add(BucketRawdataProvider.getCroppedJournalStream(rawDataDir, cropPosition));
        slices.addAll(BucketRawdataProvider.getCorrectedSlices(rawDataDir, missingSlices, inputStreams, offsets));
        return BucketRawdataProvider.wrapSlicesAndStream(slices, new Lazy<InputStream>(){

            @Override
            public InputStream get() throws IOException {
                return new SequenceInputStream((Enumeration<? extends InputStream>)new Enumeration<InputStream>(){
                    private final Iterator<Lazy<InputStream>> streams;
                    {
                        this.streams = inputStreams.iterator();
                    }

                    @Override
                    public boolean hasMoreElements() {
                        return this.streams.hasNext();
                    }

                    @Override
                    public InputStream nextElement() {
                        try {
                            return this.streams.next().get();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
        });
    }

    private static long[] getFirstMissingSliceOffsets(List<Slice> missingSlices, Slices slices) {
        if (!slices.isEmpty()) {
            return BucketRawdataProvider.getOffsets(slices.getLast());
        }
        Slice firstMissingSlice = missingSlices.get(0);
        return new long[]{firstMissingSlice.getCompressedOffset(), firstMissingSlice.getUncompressedOffset()};
    }

    private static List<Slice> getCorrectedSlices(File rawDataDir, List<Slice> missingSlices, List<Lazy<InputStream>> inputStreams, long[] offsets) throws FileNotFoundException, IOException {
        ArrayList<Slice> correctedSlices = new ArrayList<Slice>();
        long compressedOffset = offsets[0];
        long uncompressedOffset = offsets[1];
        for (Slice missingSlice : missingSlices) {
            File sliceFile = BucketRawdataProvider.getSliceFile(rawDataDir, missingSlice);
            inputStreams.add(BucketRawdataProvider.getCompressedStreamToSlice(sliceFile));
            Slice slice = BucketRawdataProvider.toSlice(sliceFile, compressedOffset, uncompressedOffset);
            correctedSlices.add(slice);
            compressedOffset += ((Long)slice.get(COMPRESSED_LENGTH)).longValue();
            uncompressedOffset += slice.getUncompressedLength();
        }
        return correctedSlices;
    }

    private static Lazy<InputStream> getJournalInputStream(final File rawDataDir) throws IOException {
        return new Lazy<InputStream>(){

            @Override
            public InputStream get() throws IOException {
                return new BufferedInputStream(FileUtils.openInputStream((File)BucketRawdataProvider.getJournal(rawDataDir)));
            }
        };
    }

    private static long skip(InputStream in, long bytesToSkip) throws IOException {
        BoundedInputStream boundedIn = new BoundedInputStream(in, bytesToSkip);
        return IOUtils.copyLarge((InputStream)boundedIn, (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
    }

    private static File getJournal(File rawDataDir) {
        return new File(rawDataDir, "journal.gz");
    }

    static List<File> listSlices(File rawDataDir) {
        File[] slices = rawDataDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return SLICE_FILENAME_PATTERN.matcher(name).matches();
            }
        });
        if (slices == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(BucketRawdataProvider.sortFileNamesAccending(slices));
    }

    private static File[] sortFileNamesAccending(File[] slices) {
        Arrays.sort(slices, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return Long.valueOf(this.parseFilename(f1)).compareTo(this.parseFilename(f2));
            }

            private long parseFilename(File f) {
                return Integer.parseInt(f.getName());
            }
        });
        return slices;
    }

    private static Lazy<InputStream> getCroppedJournalStream(final File rawDataDir, final long cutOffPoint) {
        return new Lazy<InputStream>(){

            @Override
            public InputStream get() throws IOException {
                return new BoundedInputStream((InputStream)BucketRawdataProvider.getJournalInputStream(rawDataDir).get(), cutOffPoint);
            }
        };
    }

    private static Lazy<InputStream> getCompressedStreamToSlice(final File sliceFile) {
        return new Lazy<InputStream>(){

            @Override
            public InputStream get() throws IOException {
                return new GzipOnTheFlyInputStream(FileUtils.openInputStream((File)sliceFile));
            }
        };
    }

    private static Slice toSlice(File sliceFile, long compressedOffset, long uncompressedOffset) throws IOException {
        Slice slice = new Slice();
        slice.put("compressed_offset", compressedOffset);
        slice.put(COMPRESSED_LENGTH, BucketRawdataProvider.getCompressedLength(sliceFile));
        slice.put("uncompressed_offset", uncompressedOffset);
        slice.put("uncompressed_length", sliceFile.length());
        return slice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getCompressedLength(File sliceFile) throws IOException {
        long l;
        InputStream in = null;
        try {
            in = BucketRawdataProvider.getCompressedStreamToSlice(sliceFile).get();
            l = IOUtils.toByteArray((InputStream)in).length;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return l;
    }

    public static BucketRawdataProvider create(Configuration conf) {
        return new BucketRawdataProvider(conf, BucketRawdataProvider.getSliceMetadataProvider(conf));
    }

    private static SliceMetadataProvider getSliceMetadataProvider(Configuration conf) {
        String splunkHome = SplunkMR.getSHSplunkHome(conf);
        if (splunkHome != null) {
            return SplunkdSliceMetadataProvider.create(splunkHome);
        }
        gLogger.warn((Object)"SPLUNK_HOME was not set. Will not get slice metadata");
        return new SliceMetadataProvider(){

            @Override
            public Slices getSliceMetadata(File rawDataDir) {
                return Slices.newEmpty();
            }
        };
    }

    public static class CouldNotReadMetadataFromClusteredBucket
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public CouldNotReadMetadataFromClusteredBucket(String message, Exception e) {
            super(message, e);
        }
    }

    public static class BucketRawdata {
        public final Slices sliceMetadata;
        public final Lazy<InputStream> journalStream;

        public BucketRawdata(Slices sliceMetadata, Lazy<InputStream> journalStream) {
            this.sliceMetadata = sliceMetadata;
            this.journalStream = journalStream;
        }
    }

    public static interface SliceMetadataProvider {
        public Slices getSliceMetadata(File var1);
    }
}

