/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.search;

import com.splunk.search.SearchPipeline;
import com.splunk.search.SearchResults;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SearchProcessor {
    protected String _name = null;
    protected String _search_string = null;
    protected List<Arg> _args = new ArrayList<Arg>();
    protected int _pipelineLocation = -1;

    public boolean isFirst() {
        return this._pipelineLocation == 0;
    }

    public boolean isPipeline() {
        return false;
    }

    public boolean isGenerating() {
        return false;
    }

    public boolean isImplemented() {
        return !this.getClass().equals(SearchProcessor.class);
    }

    public String getUnimplmented() {
        return this.toString();
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        if (this._search_string.startsWith(" ")) {
            return this._name + this._search_string;
        }
        return this._name + " " + this._search_string;
    }

    public String getOption(String name) {
        for (Arg arg : this._args) {
            OptionArg opArg;
            if (!arg.isOption() || !(opArg = (OptionArg)arg).getName().equalsIgnoreCase(name)) continue;
            return opArg.getValue();
        }
        return null;
    }

    public String getRequiredOption(String name) {
        String value = this.getOption(name);
        if (value == null) {
            throw new RuntimeException("Missing required option " + name);
        }
        return value;
    }

    public void initFrom(Map<String, Object> data, int pipeLocation) {
        String type = (String)data.get("type");
        if (!"processor".equalsIgnoreCase(type)) {
            throw new IllegalArgumentException("Cannot initialize SearchProcessor from type=" + type);
        }
        this._pipelineLocation = pipeLocation;
        this._name = (String)data.get("name");
        this._search_string = (String)data.get("search_string");
        List args = (List)data.get("args");
        for (Map arg : args) {
            this._args.add(Arg.parseArg(arg));
        }
    }

    public void aboutToExecute() {
    }

    public boolean execute(SearchResults results) {
        return false;
    }

    public void lastExecute(SearchResults results) {
    }

    public static class DefaultFactory
    implements Factory {
        @Override
        public SearchProcessor createProcessor(String name) {
            return new SearchProcessor();
        }
    }

    public static interface Factory {
        public SearchProcessor createProcessor(String var1);
    }

    public static class PipelineArg
    extends Arg {
        SearchPipeline _pipe;

        public PipelineArg(Map<String, Object> data) {
            super(data);
            String type = (String)data.get("type");
            if (!"pipeline".equalsIgnoreCase(type)) {
                throw new IllegalArgumentException("Cannot initialize PipelineArg from type=" + type);
            }
            this._pipe = new SearchPipeline((List)data.get("value"));
        }

        @Override
        public boolean isPipeline() {
            return true;
        }

        public SearchPipeline getPipeline() {
            return this._pipe;
        }
    }

    public static class OptionArg
    extends Arg {
        String _name;

        public OptionArg(Map<String, Object> data) {
            super(data);
            String type = (String)data.get("type");
            if (!"option".equalsIgnoreCase(type)) {
                throw new IllegalArgumentException("Cannot initialize OptionArg from type=" + type);
            }
            this._name = (String)data.get("name");
            this._value = (String)data.get("value");
        }

        @Override
        public boolean isOption() {
            return true;
        }

        public String getName() {
            return this._name;
        }
    }

    public static class Arg {
        String _raw = null;
        String _value = null;

        public Arg(Map<String, Object> data) {
            this._raw = String.valueOf(data.get("raw"));
            String type = (String)data.get("type");
            if ("literal".compareToIgnoreCase(type) == 0) {
                this._value = (String)data.get("value");
            }
        }

        public String getValue() {
            return this._value;
        }

        public boolean isOption() {
            return false;
        }

        public boolean isPipeline() {
            return false;
        }

        public final String getRawString() {
            return this._raw;
        }

        public String toString() {
            return this.getRawString();
        }

        public static Arg parseArg(Map<String, Object> data) {
            String type = (String)data.get("type");
            if ("literal".compareToIgnoreCase(type) == 0) {
                return new Arg(data);
            }
            if ("option".compareToIgnoreCase(type) == 0) {
                return new OptionArg(data);
            }
            if ("pipeline".compareToIgnoreCase(type) == 0) {
                return new PipelineArg(data);
            }
            throw new IllegalArgumentException("unknown arg type=" + type);
        }
    }
}

