/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class SerialNumberManager<T> {
    private AtomicInteger id = new AtomicInteger(1);
    private ConcurrentMap<T, Integer> t2i = new ConcurrentHashMap<T, Integer>();
    private ConcurrentMap<Integer, T> i2t = new ConcurrentHashMap<Integer, T>();

    public SerialNumberManager() {
        this.get(null);
    }

    public int get(T t) {
        if (t == null) {
            return 0;
        }
        Integer sn = (Integer)this.t2i.get(t);
        if (sn == null) {
            sn = this.id.getAndIncrement();
            Integer old = this.t2i.putIfAbsent(t, sn);
            if (old != null) {
                return old;
            }
            this.i2t.put(sn, t);
        }
        return sn;
    }

    public T get(int i) {
        if (i == 0) {
            return null;
        }
        Object t = this.i2t.get(i);
        if (t == null) {
            throw new IllegalStateException("Failed to get element with serial number " + i);
        }
        return (T)t;
    }
}

