define(["vizapi/SplunkVisualizationBase","vizapi/SplunkVisualizationUtils"],(function(__WEBPACK_EXTERNAL_MODULE__4__,__WEBPACK_EXTERNAL_MODULE__5__){return function(modules){var installedModules={};function __webpack_require__(moduleId){if(installedModules[moduleId])return installedModules[moduleId].exports;var module=installedModules[moduleId]={i:moduleId,l:!1,exports:{}};return modules[moduleId].call(module.exports,module,module.exports,__webpack_require__),module.l=!0,module.exports}return __webpack_require__.m=modules,__webpack_require__.c=installedModules,__webpack_require__.d=function(exports,name,getter){__webpack_require__.o(exports,name)||Object.defineProperty(exports,name,{enumerable:!0,get:getter})},__webpack_require__.r=function(exports){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(exports,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(exports,"__esModule",{value:!0})},__webpack_require__.t=function(value,mode){if(1&mode&&(value=__webpack_require__(value)),8&mode)return value;if(4&mode&&"object"==typeof value&&value&&value.__esModule)return value;var ns=Object.create(null);if(__webpack_require__.r(ns),Object.defineProperty(ns,"default",{enumerable:!0,value:value}),2&mode&&"string"!=typeof value)for(var key in value)__webpack_require__.d(ns,key,function(key){return value[key]}.bind(null,key));return ns},__webpack_require__.n=function(module){var getter=module&&module.__esModule?function(){return module.default}:function(){return module};return __webpack_require__.d(getter,"a",getter),getter},__webpack_require__.o=function(object,property){return Object.prototype.hasOwnProperty.call(object,property)},__webpack_require__.p="",__webpack_require__(__webpack_require__.s=0)}({0:function(module,exports,__webpack_require__){var __WEBPACK_AMD_DEFINE_ARRAY__,__WEBPACK_AMD_DEFINE_RESULT__;__WEBPACK_AMD_DEFINE_ARRAY__=[__webpack_require__("shim/jquery"),__webpack_require__("require/underscore"),__webpack_require__(4),__webpack_require__(5),__webpack_require__(6)],void 0===(__WEBPACK_AMD_DEFINE_RESULT__=function($,_,SplunkVisualizationBase,vizUtils,d3){var showTooltip,baseColor,prevBaseColor,DEFAULT_COLOR_PALETTE=["#e6ecf3","#cdd8e7","#b4c5db","#9cb1d0","#839ec4","#6a8ab8","#5177ac","#3863a0","#284774"],colorLuminance=function(hex,lum){(hex=String(hex).replace(/[^0-9a-f]/gi,"")).length<6&&(hex=hex[0]+hex[0]+hex[1]+hex[1]+hex[2]+hex[2]),lum=lum||0;var c,i,rgb="#";for(i=0;i<3;i++)c=parseInt(hex.substr(2*i,2),16),rgb+=("00"+(c=Math.round(Math.min(Math.max(0,c+c*lum),255)).toString(16))).substr(c.length);return rgb},formatDate=function(dTime,interval,totalRange){var dateObj=new Date(dTime),tooltipFormat=d3.time.format("%b %d %Y %H:%M%p"),hourMinFormat=d3.time.format("%H:%M%p"),monthDateHourMinFormat=d3.time.format("%b %d %H:%M%p"),monthDateFormat=d3.time.format("%b %d"),monthFormat=d3.time.format("%b"),minFormat=d3.time.format("%M"),hourFormat=d3.time.format("%H"),dayFormat=d3.time.format("%d"),seconds=d3.time.format("%S")(dateObj),minutes=minFormat(dateObj),hours=hourFormat(dateObj),day=dayFormat(dateObj);if(-1==interval)return tooltipFormat(dateObj);if(interval>0&&interval<=1){if(("00"==minutes||"10"==minutes||"20"==minutes||"30"==minutes||"40"==minutes||"50"==minutes)&&"00"==seconds)return hourMinFormat(dateObj)}else if(5==interval){if("00"==minutes)return hourMinFormat(dateObj)}else if(interval>=10&&interval<=30){if(("00"==hours||"04"==hours||"08"==hours||"12"==hours||"16"==hours||"20"==hours)&&"00"==minutes)return monthDateHourMinFormat(dateObj)}else if(60==interval){if(("00"==hours||"12"==hours)&&"00"==minutes)return monthDateHourMinFormat(dateObj)}else if(1440==interval){if(!(totalRange>21600))return monthDateFormat(dateObj);if("05"==day||"10"==day||"15"==day||"20"==day||"25"==day||"30"==day)return monthDateFormat(dateObj)}else if(interval>=4e4&&interval<=5e4)return monthFormat(dateObj);return""},generateDisplayTimeLabel=function(dateObj){var timezoneCorrectedDateObj=vizUtils.parseTimestamp(dateObj.toISOString()),date=timezoneCorrectedDateObj.toISOString().split(/[\T.]+/)[0],time=timezoneCorrectedDateObj.toString().split(/[\s]+/)[4],dateArray=date.split(/[\-]+/);return dateArray[1]+"/"+dateArray[2]+"/"+dateArray[0]+" "+time};return SplunkVisualizationBase.extend({initialize:function(){SplunkVisualizationBase.prototype.initialize.apply(this,arguments),this.$el=$(this.el),this.margin={top:20,right:75,bottom:100,left:150},this.$el.addClass("splunk-heatmap"),this.viewSetup=!1,this.prevTimestampData=[],this.numBuckets=-1},getInitialDataParams:function(){return{outputMode:SplunkVisualizationBase.ROW_MAJOR_OUTPUT_MODE,count:1e4}},formatData:function(data,config){if(!data||!data.rows||!data.fields||0==data.rows.length)return this;this._getBucketNames(data).length;var width=this.$el.width()-this.margin.left-this.margin.right,height=530-this.margin.top-this.margin.bottom;width<=0&&!1!==this.prevWidthLessThanZero&&(this.prevWidthLessThanZero=!0),width=width<=0?$(window).width()-this.margin.left-this.margin.right:width,this.width=width,this.height=height;var numTimeStamps=data.rows.length,gridWidth=Math.floor(this.width/numTimeStamps),colorScale=this._generateColorScale(data),bucketData=this._generateBucketData(data,gridWidth,20),timestampData=this._generateTimeStampData(data,gridWidth,20),formattedData={gridWidth:gridWidth,gridHeight:20,squareData:this._generateSquareData(data,bucketData,timestampData,colorScale,gridWidth,20),timestampData:timestampData,bucketData:bucketData,legendData:this._generateLegendData(colorScale)};return-1==this.numBuckets&&(this.numBuckets=formattedData.bucketData.length),formattedData},updateView:function(data,config){if(!data||!data.squareData)return this;!1===this.viewSetup&&(this.$el.empty(),this._setupViewCustom(data),this.viewSetup=!0),showTooltip=config[this.getPropertyNamespaceInfo().propertyNamespace+"showTooltip"],baseColor=config[this.getPropertyNamespaceInfo().propertyNamespace+"baseColor"];var showLegend=config[this.getPropertyNamespaceInfo().propertyNamespace+"showLegend"],showXAxisLabel=config[this.getPropertyNamespaceInfo().propertyNamespace+"showXAxis"],showYAxisLabel=config[this.getPropertyNamespaceInfo().propertyNamespace+"showYAxis"],customLegendTitle=config[this.getPropertyNamespaceInfo().propertyNamespace+"legendTitle"],customXAxisLabel=config[this.getPropertyNamespaceInfo().propertyNamespace+"xAxis"],customYAxisLabel=config[this.getPropertyNamespaceInfo().propertyNamespace+"yAxis"],svg=d3.select(this.el).select(".canvas");this._updateSquares(svg,data),this._updateBuckets(svg,data),this._updateTimeStamps(svg,data),this._updateLegend(svg,data),_.isUndefined(baseColor)||baseColor==prevBaseColor||(this.invalidateFormatData(),prevBaseColor=baseColor.slice()),this._updateLegendTitle(svg,data,customLegendTitle,"Instance count"),this._updateCustomLabels(svg,data,customXAxisLabel,customYAxisLabel),this._updateLegendLableVisability(svg,showLegend,showXAxisLabel,showYAxisLabel),!1,!0===this.prevWidthLessThanZero&&(this.prevWidthLessThanZero=!1,this.invalidateFormatData())},_setupViewCustom:function(data){var svg=d3.select(this.el).append("svg").attr("width",this.width+this.margin.left+this.margin.right).attr("height",this.height+this.margin.bottom+this.margin.left).append("g").attr("class","canvas").attr("transform","translate("+this.margin.left+","+this.margin.top+")");svg.append("g").attr("class","card-group"),svg.append("g").attr("class","time-label-group"),svg.append("g").attr("class","bucket-label-group"),svg.append("g").attr("class","legend-group"),svg.append("text").attr("class","mono x-axis-label").text("Time").attr("x",this.width/2-20).attr("y",data.bucketData.length*data.gridHeight+50),svg.append("text").attr("class","mono y-axis-label").text("").attr("transform","translate(-130,110)rotate(-90)");d3.select("body").append("div").attr("class","heatmap tooltip").style("opacity",0)},_getMaxNumInstances:function(data){for(var max=0,buckets=this._getBucketNames(data),i=0;i<data.rows.length;i++)for(var j=0;j<buckets.length;j++)max=parseInt(data.rows[i][j+1],10)>max?parseInt(data.rows[i][j+1],10):max;return max},_getBucketNames:function(data){return _.chain(data.fields).pluck("name").filter((function(field){return-1===field.indexOf("span")})).value().splice(1)},_generateColorScale:function(data){var maxNumInstances=this._getMaxNumInstances(data),colors=function(maxNumInstances){var newColorPalette=[];if(_.isUndefined(baseColor)||"#284774"===baseColor)return maxNumInstances>=DEFAULT_COLOR_PALETTE.length-1?DEFAULT_COLOR_PALETTE:DEFAULT_COLOR_PALETTE.slice(0,maxNumInstances+1);for(var lum=2;lum>=0;lum-=.25)newColorPalette.push(colorLuminance(baseColor,lum));return maxNumInstances>=newColorPalette.length-1?newColorPalette:newColorPalette.slice(0,maxNumInstances+1)}(maxNumInstances);return d3.scale.quantile().domain([0,maxNumInstances]).range(colors)},_generateBucketData:function(data,width,height){var buckets=[],bucketNames=this._getBucketNames(data);return _.each(bucketNames,(function(bucketName){buckets.push({name:bucketName,height:height})})),buckets},_generateTimeStampData:function(data,width,height){var timeStamps=[];return _.each(data.rows,(function(row){timeStamps.push({time:row[0],width:width})})),timeStamps},_generateSquareData:function(data,buckets,timestamps,colorScale,width,height){var indexOfSpan=data.fields.findIndex((function(obj){return"_span"===obj.name})),squares=[];return _.each(data.rows,(function(row,i){for(var j=0;j<buckets.length;j++){var numInstances=row[j+1]?row[j+1]:0,square={x:i,y:j,timestamp:timestamps[i].time,bucket:buckets[j].name,width:width,height:height,numInstances:numInstances,color:colorScale(numInstances),_span:row[indexOfSpan]};squares.push(square)}})),squares},_generateLegendData:function(colorScale){var legendData=[],quantiles=[0].concat(colorScale.quantiles());return _.each(quantiles,(function(q){legendData.push({quantile:q,color:colorScale(q)})})),legendData},_updateSquares:function(svg,data){var currentP=this,tooltip=d3.select(".heatmap.tooltip"),cards=svg.select(".card-group").selectAll(".time").data(data.squareData,(function(d){return"x:"+d.x+" y:"+d.y}));cards.enter().append("rect").attr("x",(function(d){return d.x*d.width})).attr("y",(function(d){return d.y*d.height})).attr("rx",4).attr("ry",4).attr("class","time bordered").attr("width",(function(d){return d.width})).attr("height",(function(d){return d.height})).style("fill",DEFAULT_COLOR_PALETTE[0]).style("opacity",0).on("mouseout",(function(){(_.isUndefined(showTooltip)||"true"===showTooltip)&&(d3.select(this).style("cursor","default"),tooltip.interrupt().transition(),tooltip.style("opacity",0))})).on("mouseover",(function(d){(_.isUndefined(showTooltip)||"true"===showTooltip)&&(d3.select(this).style("cursor","pointer"),tooltip.style("opacity",.8),tooltip.html(formatDate(d.timestamp,-1,-1)+"<br>"+vizUtils.escapeHtml(d.bucket)+"<br>Number of Instances: "+vizUtils.escapeHtml(d.numInstances)).style("left",d3.event.pageX-75+"px").style("top",d3.event.pageY-85+"px"),tooltip.transition().delay(300).duration(500).style("opacity",.85))})).call((function(d){if(d3.select(this.el).select(".timestampLabel").node()){var legendY=data.bucketData.length*data.gridHeight+70,legendElementWidth=2*data.gridHeight;d3.select(this.el).selectAll(".legend .legend-color").transition().duration(2e3).attr("x",(function(d,i){return legendElementWidth*i})).attr("y",legendY).attr("width",legendElementWidth).attr("height",data.gridHeight/2),d3.select(this.el).selectAll(".legend .legend-label").transition().duration(2e3).attr("x",(function(d,i){return legendElementWidth*i})).attr("y",legendY+data.gridHeight+2)}})).on("click",(function(d){var earliest=new Date(d.timestamp),latest=new Date(earliest.getTime()+1e3*d._span),earliestLabel=generateDisplayTimeLabel(earliest),latestLabel=generateDisplayTimeLabel(latest),data={_span:!0};data.drilldown_indexing_rate_metric=d.bucket,data.earliest=vizUtils.parseTimestamp(earliest.toISOString()).toISOString(),data.latest=vizUtils.parseTimestamp(latest.toISOString()).toISOString(),data.numInstances=d.numInstances,data.earliest_label=earliestLabel,data.latest_label=latestLabel,currentP.drilldown({action:SplunkVisualizationBase.FIELD_VALUE_DRILLDOWN,data:data,earliest:vizUtils.parseTimestamp(earliest.toISOString()).toISOString(),latest:vizUtils.parseTimestamp(latest.toISOString()).toISOString()},d3.event)})),cards.transition().duration(2e3).attr("x",(function(d){return d.x*d.width})).attr("y",(function(d){return d.y*d.height})).attr("rx",4).attr("ry",4).attr("width",(function(d){return d.width})).attr("height",(function(d){return d.height})).style("opacity",1).style("fill",(function(d){return d.color})),cards.exit().transition().duration(100).style("opacity",0).remove()},_updateBuckets:function(svg,data){var buckets=svg.select(".bucket-label-group").selectAll(".bucketLabel").data(data.bucketData,(function(d){return d.name}));buckets.enter().append("text").text((function(d){return d.name})).attr("x",0).attr("y",(function(d,i){return i*d.height})).style("text-anchor","end").style("opacity",0).attr("transform",function(d){return"translate(-6,"+d.height/1.5+")"}.bind(this)).attr("class",(function(d,i){return"bucketLabel mono axis"})),buckets.transition().duration(2e3).style("opacity",1).attr("x",0).attr("y",(function(d,i){return i*d.height})),buckets.exit().remove()},_updateTimeStamps:function(svg,data){var dataObj=data.timestampData[0],earliest=new Date(dataObj.time),dataObj2=data.timestampData[1],diff=(new Date(dataObj2.time)-earliest)/1e3/60,dataObjLast=data.timestampData[data.timestampData.length-1],totalRange=(new Date(dataObjLast.time)-earliest)/1e3/60,curFirst=data.timestampData[0].time,curLast=data.timestampData[data.timestampData.length-1].time;if(0!=this.prevTimestampData.length)var prevFirst=this.prevTimestampData[0].time,prevLast=this.prevTimestampData[this.prevTimestampData.length-1].time;0==this.prevTimestampData.length||data.timestampData.length==this.prevTimestampData.length&&curFirst==prevFirst&&curLast==prevLast||svg.selectAll(".timestampLabel").remove(),this.prevTimestampData=data.timestampData.slice();var timeLabelHeight=data.bucketData.length*data.gridHeight+15,timeLabels=svg.select(".time-label-group").selectAll(".timestampLabel").data(data.timestampData);timeLabels.enter().append("text").attr("class","timestampLabel mono axis").text((function(d){return formatDate(d.time,diff,totalRange)})).style("font-size","11px").style("font-weight","250").style("text-anchor","beginning").style("opacity",0).attr("transform",function(d,i){return"translate("+parseInt(i*d.width+d.width/2-5,10)+","+timeLabelHeight+")"}.bind(this)),timeLabels.transition().duration(2e3).attr("transform",function(d,i){return"translate("+parseInt(i*d.width+d.width/2-5,10)+","+timeLabelHeight+")"}.bind(this)).style("opacity",1),timeLabels.exit().transition().duration(1e3).style("opacity",0).remove()},_updateLegend:function(svg,data){data.bucketData.length!=this.numBuckets&&(svg.selectAll(".legend").remove(),this.numBuckets=data.bucketData.length);var legendElementWidth=2*data.gridHeight,legendY=data.bucketData.length*data.gridHeight+70,legend=svg.select(".legend-group").selectAll(".legend").data(data.legendData,(function(d,i){return d.color})),legendEnter=legend.enter().append("g").attr("class","legend").style("opacity",0);legendEnter.append("rect").attr("class","legend-color").attr("x",(function(d,i){return legendElementWidth*i})).attr("y",legendY).attr("width",legendElementWidth).attr("height",data.gridHeight/2).style("fill",(function(d,i){return d.color})),legendEnter.append("text").attr("class","mono legend-label").text((function(d){return"≥ "+Math.ceil(d.quantile)})).attr("x",(function(d,i){return legendElementWidth*i})).attr("y",legendY+data.gridHeight+2),legend.transition().duration(2e3).style("opacity",1),legend.exit().transition().duration(1e3).style("opacity",0).remove()},_updateLegendTitle:function(svg,data,customLegendTitle,legendTitle){!_.isUndefined(customLegendTitle)&&customLegendTitle.length>0&&(legendTitle=customLegendTitle=vizUtils.escapeHtml(customLegendTitle)),svg.selectAll(".legend-title").remove();var legendTitleY=data.bucketData.length*data.gridHeight+65;svg.append("text").attr("class","mono legend-title").text(legendTitle).attr("x",0).attr("y",legendTitleY)},_updateCustomLabels:function(svg,data,customXAxisLabel,customYAxisLabel){_.isUndefined(customXAxisLabel)?svg.select(".x-axis-label").attr("y",data.bucketData.length*data.gridHeight+50):(0==(customXAxisLabel=vizUtils.escapeHtml(customXAxisLabel)).length&&(customXAxisLabel="Time"),svg.select(".x-axis-label").text(customXAxisLabel).attr("x",this.width/2-20-4*customXAxisLabel.length)),_.isUndefined(customYAxisLabel)||(0==(customYAxisLabel=vizUtils.escapeHtml(customYAxisLabel)).length&&(customYAxisLabel=""),svg.select(".y-axis-label").text(customYAxisLabel))},_updateLegendLableVisability:function(svg,showLegend,showXAxisLabel,showYAxisLabel){"false"==showLegend?(svg.select(".legend-group").attr("display","none"),svg.select(".legend-title").attr("display","none")):"true"==showLegend&&(svg.select(".legend-group").attr("display","block"),svg.select(".legend-title").attr("display","block")),"false"==showXAxisLabel?svg.select(".x-axis-label").attr("display","none"):"true"==showXAxisLabel&&svg.select(".x-axis-label").attr("display","block"),"false"==showYAxisLabel?svg.select(".y-axis-label").attr("display","none"):"true"==showYAxisLabel&&svg.select(".y-axis-label").attr("display","block")},reflow:function(){this.width===this.$el.width()-this.margin.left-this.margin.right&&this.height===530-this.margin.top-this.margin.bottom||(!0,this.invalidateUpdateView())}})}.apply(exports,__WEBPACK_AMD_DEFINE_ARRAY__))||(module.exports=__WEBPACK_AMD_DEFINE_RESULT__)},1:function(module,exports){(function(){var global;void 0!==(global=this).Splunk&&global.Splunk||(global.Splunk={}),global.Splunk.namespace=function(name){for(var parts=name.split("."),obj=Splunk,i="Splunk"==parts[0]?1:0;i<parts.length;i+=1)obj[parts[i]]=obj[parts[i]]||{},obj=obj[parts[i]];return obj}}).call(window)},2:function(module,exports){module.exports=function(){var regex=/%%|%(\d+\$)?(\([^)]+\))?([-+#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuidfegEG])/g,a=arguments,i=0,format=a[i++],pad=function(str,len,chr,leftJustify){var padding=str.length>=len?"":Array(1+len-str.length>>>0).join(chr);return leftJustify?str+padding:padding+str},justify=function(value,prefix,leftJustify,minWidth,zeroPad){var diff=minWidth-value.length;return diff>0&&(value=leftJustify||!zeroPad?pad(value,minWidth," ",leftJustify):value.slice(0,prefix.length)+pad("",diff,"0",!0)+value.slice(prefix.length)),value},formatBaseX=function(value,base,prefix,leftJustify,minWidth,precision,zeroPad){var number=value>>>0;return value=(prefix=prefix&&number&&{2:"0b",8:"0",16:"0x"}[base]||"")+pad(number.toString(base),precision||0,"0",!1),justify(value,prefix,leftJustify,minWidth,zeroPad)},formatString=function(value,leftJustify,minWidth,precision,zeroPad){return null!=precision&&(value=value.slice(0,precision)),justify(value,"",leftJustify,minWidth,zeroPad)},doFormat=function(substring,valueIndex,valueName,flags,minWidth,_,precision,type){if("%%"==substring)return"%";for(var leftJustify=!1,positivePrefix="",zeroPad=!1,prefixBaseX=!1,flagsl=flags.length,j=0;flags&&j<flagsl;j++)switch(flags.charAt(j)){case" ":positivePrefix=" ";break;case"+":positivePrefix="+";break;case"-":leftJustify=!0;break;case"0":zeroPad=!0;break;case"#":prefixBaseX=!0}if((minWidth=minWidth?"*"==minWidth?+a[i++]:"*"==minWidth.charAt(0)?+a[minWidth.slice(1,-1)]:+minWidth:0)<0&&(minWidth=-minWidth,leftJustify=!0),!isFinite(minWidth))throw new Error("sprintf: (minimum-)width must be finite");if(precision=precision?"*"==precision?+a[i++]:"*"==precision.charAt(0)?+a[precision.slice(1,-1)]:+precision:"fFeE".indexOf(type)>-1?6:"d"==type?0:void 0,valueName){valueName=valueName.substr(1,valueName.length-2);var value=a[1][valueName]}else value=valueIndex?a[valueIndex.slice(0,-1)]:a[i++];switch(type){case"s":return formatString(String(value),leftJustify,minWidth,precision,zeroPad);case"c":return formatString(String.fromCharCode(+value),leftJustify,minWidth,precision,zeroPad);case"b":return formatBaseX(value,2,prefixBaseX,leftJustify,minWidth,precision,zeroPad);case"o":return formatBaseX(value,8,prefixBaseX,leftJustify,minWidth,precision,zeroPad);case"x":return formatBaseX(value,16,prefixBaseX,leftJustify,minWidth,precision,zeroPad);case"X":return formatBaseX(value,16,prefixBaseX,leftJustify,minWidth,precision,zeroPad).toUpperCase();case"u":return formatBaseX(value,10,prefixBaseX,leftJustify,minWidth,precision,zeroPad);case"i":case"d":return value=(prefix=(number=parseInt(+value))<0?"-":positivePrefix)+pad(String(Math.abs(number)),precision,"0",!1),justify(value,prefix,leftJustify,minWidth,zeroPad);case"e":case"E":case"f":case"F":case"g":case"G":var number,prefix=(number=+value)<0?"-":positivePrefix,method=["toExponential","toFixed","toPrecision"]["efg".indexOf(type.toLowerCase())],textTransform=["toString","toUpperCase"]["eEfFgG".indexOf(type)%2];return value=prefix+Math.abs(number)[method](precision),justify(value,prefix,leftJustify,minWidth,zeroPad)[textTransform]();default:return substring}};return format.replace(regex,doFormat)}},3:function(module,exports,__webpack_require__){var $=__webpack_require__("shim/jquery");(function(){!function(global){if(Splunk.namespace("util"),Splunk.util={logger:{info:function(){},log:function(){},debug:function(){},warn:function(){},error:function(){}},propToQueryString:function(dictionary){var val,o=[];for(var prop in dictionary)Array.isArray(dictionary[prop])?dictionary[prop].forEach((function(s){o.push(encodeURIComponent(prop)+"="+encodeURIComponent(s))})):(val=dictionary[prop],o.push(encodeURIComponent(prop)+"="+encodeURIComponent(val)));return o.join("&")},queryStringToProp:function(args){if(!(args=this.trim(args,"&?#"))||0==args.length)return{};for(var key,value,equalsSegments,parts=args.split("&"),output={},i=0;i<parts.length;i++){equalsSegments=parts[i].split("=");try{key=decodeURIComponent(equalsSegments.shift()),value=decodeURIComponent(equalsSegments.join("=").replace(/\+/g," "))}catch(e){continue}if(output.hasOwnProperty(key))if(Array.isArray(output[key]))output[key].push(value);else{var sampleKeys=[];sampleKeys.push(output[key]),sampleKeys.push(value),output[key]=sampleKeys}else output[key]=value}return output},getHash:function(){var hashPos=window.location.href.indexOf("#");if(-1==hashPos)return"";var qPos=window.location.href.indexOf("?",hashPos);return-1!=qPos?window.location.href.substr(qPos):window.location.href.substr(hashPos)},parseDate:function(str,fmt){if(!str||!str.indexOf||0==str.indexOf("mm"))return null;var y=0,m=-1,d=0,a=str.split(/\W+/),b=fmt.match(/%./g),i=0,hr=0,min=0,sec=0;for(i=0;i<a.length;++i)if(a[i])switch(b[i]){case"%d":d=parseInt(a[i],10);break;case"%m":m=parseInt(a[i],10)-1;break;case"%Y":case"%y":(y=parseInt(a[i],10))<100&&(y+=y>29?1900:2e3);break;case"%H":hr=parseInt(a[i],10);break;case"%M":min=parseInt(a[i],10);break;case"%S":sec=parseInt(a[i],10)}return 0!=y&&-1!=m&&0!=d&&new Date(y,m,d,hr,min,sec)},getTimezoneOffsetDelta:function(serverOffsetThen,d){return Splunk.util.isInt(serverOffsetThen)?1e3*((serverOffsetThen*=-60)-60*d.getTimezoneOffset()):0},getEpochTimeFromISO:function(isoStr){this._isoTimeRegex||(this._isoTimeRegex=/([\+\-])?(\d{4,})(?:(?:\-(\d{2}))(?:(?:\-(\d{2}))(?:(?:[T ](\d{2}))(?:(?:\:(\d{2}))(?:(?:\:(\d{2}(?:\.\d+)?)))?)?(?:(Z)|([\+\-])(\d{2})[:]*(\d{2})?)?)?)?)?/);var m=this._isoTimeRegex.exec(isoStr),seconds,millisecondsStr;m[7]?(seconds=m[7].substring(0,2),millisecondsStr=m[7].substring(2)):millisecondsStr="";var offset=eval(m[9]+(60*m[10]+parseInt(m[11]||0,10))),str=sprintf("%s/%s/%s %s:%s:%s",m[3],m[4],m[2],m[5],m[6],seconds),t=new Date(str);t.setTime(t.getTime()+this.getTimezoneOffsetDelta(offset,t));var startTime=t.getTime()/1e3;return startTime+millisecondsStr},getConfigValue:function(configKey,optionalDefault){if(window.$C&&window.$C.hasOwnProperty(configKey))return window.$C[configKey];if("FORM_KEY"===configKey)return this.getFormKey();if(void 0!==optionalDefault)return optionalDefault;throw new Error("getConfigValue - "+configKey+" not set, no default provided")},getCookie:function(name){var cookieValue=null;if(document.cookie&&""!=document.cookie)for(var cookies=document.cookie.split(";"),i=0;i<cookies.length;i++){var cookie=$.trim(cookies[i]);if(cookie.substring(0,name.length+1)==name+"="){cookieValue=decodeURIComponent(cookie.substring(name.length+1));break}}return cookieValue},deleteCookie:function(name){var expdate=new Date;expdate.setTime(expdate.getTime()+-864e5),expdate.toUTCString(),document.cookie=sprintf("%s=;expires=%s;path=/",name,expdate)},getFormKey:function(){var cookieName="splunkweb_csrf_token_"+Splunk.util.getConfigValue("MRSPARKLE_PORT_NUMBER",""),cookieValue=Splunk.util.getCookie(cookieName);return cookieValue||""},loginCheck:function(){return Splunk.util.getCookie("login")},make_url:function(){for(var seg,len,output="",i=0,l=arguments.length;i<l;i++)(len=(seg=arguments[i].toString()).length)>1&&"/"==seg.charAt(len-1)&&(seg=seg.substring(0,len-1)),"/"!=seg.charAt(0)?output+="/"+seg:output+=seg;if("/"!=output){var segments=output.split("/"),firstseg=segments[1];if("static"==firstseg||"modules"==firstseg){var postfix=output.substring(firstseg.length+2,output.length);output="/"+firstseg+"/@"+window.$C.BUILD_NUMBER,window.$C.BUILD_PUSH_NUMBER&&(output+="."+window.$C.BUILD_PUSH_NUMBER),"app"==segments[2]&&(output+=":"+this.getConfigValue("APP_BUILD",0)),output+="/"+postfix}}var root=Splunk.util.getConfigValue("MRSPARKLE_ROOT_PATH","/"),locale=Splunk.util.getConfigValue("LOCALE","en-US"),combinedPath="/"+locale+output;return""==root||"/"==root?combinedPath:root+combinedPath},make_full_url:function(url,options){return url=this.make_url(url),options&&(url=url+"?"+this.propToQueryString(options)),url},redirect_to:function(uri,options,windowObj,focus){uri=this.make_full_url(uri,options),windowObj||(windowObj=window),windowObj.document.location=uri,focus&&windowObj.focus&&windowObj.focus()},getCurrentApp:function(){return $(document.body).attr("s:app")||"UNKNOWN_APP"},getCurrentView:function(){return $(document.body).attr("s:view")||"UNKNOWN_VIEW"},getCurrentDisplayView:function(){return $(document.body).attr("s:displayview")||this.getCurrentView()},getAutoCancelInterval:function(){var interval=$(document.body).attr("s:autoCancelInterval");return interval||(this.logger.error("no autoCancelInterval found. Returning 0"),interval=0),interval},getCurrentViewConfig:function(){return $.extend({},Splunk.ViewConfig)},getPath:function(path){void 0===path&&(path=document.location.pathname);var locale=this.getConfigValue("LOCALE").toString();if(!this.getConfigValue("LOCALE")||-1==path.indexOf(locale))return path;var start=locale.length+path.indexOf(locale);return path.slice(start)},getCumlativeOffsetTop:function(element){return element?element.offsetTop+this.getCumlativeOffsetTop(element.offsetParent):0},getCumlativeOffsetLeft:function(element){return element?element.offsetLeft+this.getCumlativeOffsetLeft(element.offsetParent):0},getPageYOffset:function(){var pageYOffset=0;return window.pageYOffset?pageYOffset=window.pageYOffset:document.documentElement&&document.documentElement.scrollTop&&(pageYOffset=document.documentElement.scrollTop),pageYOffset},getWindowDimensions:function(){return{width:isNaN(window.innerWidth)?document.documentElement.clientWidth||0:window.innerWidth,height:isNaN(window.innerHeight)?document.documentElement.clientHeight||0:window.innerHeight}},getComputedStyleHelper:function(el,styleProperty){if(el.currentStyle)return el.currentStyle[styleProperty];if(window.getComputedStyle){var cssProperty=styleProperty.replace(/([A-Z])/g,"-$1").toLowerCase();return window.getComputedStyle(el,"").getPropertyValue(cssProperty)}return""},getParameter:function(p,s){return(s=s||window.location.search)&&s.indexOf(p+"=")+1?s.split(p+"=")[1].split("&")[0]:null},getHEX:function(rgb){var parts=rgb.match(/^rgb\((\d+),\s*(\d+),\s*(\d+)\)$/),hex=(parts[1]<<16|parts[2]<<8|parts[3]).toString(16);return"#"+Array(6-hex.length).concat([hex]).toString().replace(/,/g,0)},normalizeColor:function(color){if(normalizedColor=null,"#"===color.charAt(0))4===color.length?normalizedColor=color+color.charAt(1)+color.charAt(2)+color.charAt(3):normalizedColor=color;else try{normalizedColor=this.getHEX(color)}catch(e){}return normalizedColor},validateCronString:function(cronString){return!!/^((0*([0-9]|[1-5][0-9])|\*)(-0*([0-9]|[1-5][0-9]))?(\/\d+)?,)*(0*([0-9]|[1-5][0-9])|\*)(-0*([0-9]|[1-5][0-9]))?(\/\d+)?\s((0*([0-9]|1[0-9]|2[0-3])|\*)(-0*([0-9]|1[0-9]|2[0-3]))?(\/\d+)?,)*(0*([0-9]|1[0-9]|2[0-3])|\*)(-0*([0-9]|1[0-9]|2[0-3]))?(\/\d+)?\s((0*([1-9]|[1-2][0-9]|3[0-1])|\*)(-0*([1-9]|[1-2][0-9]|3[0-1]))?(\/\d+)?,)*(0*([1-9]|[1-2][0-9]|3[0-1])|\*)(-0*([1-9]|[1-2][0-9]|3[0-1]))?(\/\d+)?\s((0*([1-9]|1[0-2])|\*)(-0*([1-9]|1[0-2]))?(\/\d+)?,)*(0*([1-9]|1[0-2])|\*)(-0*([1-9]|1[0-2]))?(\/\d+)?\s((0*[0-7]|\*)(-0*[0-7])?(\/\d+)?,)*(0*[0-7]|\*)(-0*[0-7])?(\/\d+)?$/.test(cronString)},turboInnerHTML:function(target,innerHTML){
/*@cc_on //innerHTML is faster for IE
            target.innerHTML = innerHTML;
            return target;
        @*/
var targetClone=target.cloneNode(!1);return targetClone.innerHTML=innerHTML,target.parentNode.replaceChild(targetClone,target),targetClone},normalizeBoolean:function(test,strictMode){switch("string"==typeof test&&(test=test.toLowerCase()),test){case!0:case 1:case"1":case"yes":case"on":case"true":return!0;case!1:case 0:case"0":case"no":case"off":case"false":return!1;default:if(strictMode)throw TypeError("Unable to cast value into boolean: "+test);return test}},getCommaFormattedNumber:function(nStr){for(var x=(nStr+="").split("."),x1=x[0],x2=x.length>1?"."+x[1]:"",rgx=/(\d+)(\d{3})/;rgx.test(x1);)x1=x1.replace(rgx,"$1,$2");return x1+x2},reLTrim:/^[\s\t\r\n]+/,reLTrimCommand:/^[\s\t\r\n\|]+/,reRNormalize:/[\s\t\r\n]+$/,addLeadingSearchCommand:function(q,isUserEntered){var workingQ=""+q;return"|"==(workingQ=workingQ.replace(this.reLTrim,"").replace(this.reRNormalize," ")).substring(0,1)||!isUserEntered&&"search "==workingQ.substring(0,7)&&workingQ.length>7?q:"search "+workingQ},stripLeadingSearchCommand:function(q){var workingQ=""+q;return"search "==(workingQ=workingQ.replace(this.reLTrimCommand,"")).substring(0,7)?workingQ.substring(7).replace(this.reLTrimCommand,""):q},stringToFieldList:function(strList){if("string"!=typeof strList||!strList)return[];for(var items=[],field_name_buffer=[],inquote=!1,str=$.trim(strList),i=0,j=str.length;i<j;i++)if("\\"!=str.charAt(i))if('"'!=str.charAt(i))" "!=str.charAt(i)&&","!=str.charAt(i)||inquote?field_name_buffer.push(str.charAt(i)):(field_name_buffer.length>0&&items.push(field_name_buffer.join("")),field_name_buffer=[]);else{if(inquote){inquote=!1,items.push(field_name_buffer.join("")),field_name_buffer=[];continue}inquote=!0}else{var nextidx=i+1;if(j>nextidx&&("\\"==str.charAt(nextidx)||'"'==str.charAt(nextidx))){field_name_buffer.push(str.charAt(nextidx)),i++;continue}field_name_buffer.push(str.charAt(i))}return field_name_buffer.length>0&&items.push(field_name_buffer.join("")),items},_sflQuotable:/([\\",\s])/,_sflEscapable:/([\\"])/g,fieldListToString:function(fieldArray){if(!fieldArray)return"";for(var output=[],i=0,L=fieldArray.length;i<L;i++){var v=$.trim(fieldArray[i]);""!=v&&(v.search(this._sflEscapable)>-1&&(v=v.replace(this._sflEscapable,"\\$1")),v.search(this._sflQuotable)>-1&&(v=['"',v,'"'].join("")),output.push(v))}return output.join(",")},searchEscape:function(str,options){return str.match(/[\s\,=|\[\]\"]/)?'"'+str.replace(/(\"|\\)/g,"\\$1")+'"':options&&options.forceQuotes?'"'+str+'"':str},searchUnescape:function(str){return'"'!==str[0]||'"'!==str[str.length-1]?str:str.slice(1,-1).replace(/\\"/g,'"').replace(/\\\\/g,"\\")},objectSimilarity:function(obj1,obj2){if(obj1 instanceof Array&&obj2 instanceof Array){if(obj1.length!==obj2.length)return!1;for(var i=0;i<obj1.length;i++)if(!this.objectSimilarity(obj1[i],obj2[i]))return!1}else if(obj1 instanceof Object&&obj2 instanceof Object){if(obj1!=obj2){for(var j in obj2)if(!obj1.hasOwnProperty(j))return!1;for(var k in obj1)if(obj1.hasOwnProperty(k)){if(!obj2.hasOwnProperty(k))return!1;if(!this.objectSimilarity(obj1[k],obj2[k]))return!1}}}else if("function"==typeof obj1&&"function"==typeof obj2){if(obj1.toString()!==obj2.toString())return!1}else if(obj1!==obj2)return!1;return!0},StopWatch:function(){var self=this,startTime=null,stopTime=null,times=[],isSet=function(prop){return null!=prop},isStarted=function(){return isSet(startTime)},isStopped=function(){return isSet(stopTime)},softReset=function(){startTime=null,stopTime=null};self.start=function(){if(isStarted())throw new Error("cannot call start, start already invoked.");startTime=new Date},self.stop=function(){if(!isStarted())throw new Error("cannot call stop, start not invoked.");if(isStopped())throw new Error("cannot call stop, stop already invoked.");stopTime=new Date,time=stopTime-startTime,times.push(time)},self.pause=function(){if(!isStarted())throw new Error("cannot call pause, start not invoked.");if(isStopped())throw new Error("cannot call pause, stop already invoked.");self.stop(),softReset()},self.reset=function(){softReset(),times=[]},self.time=function(){var total=0;for(i=0;i<times.length;i++)total+=times[i];return isStarted()&&!isStopped()&&(total+=new Date-startTime),total/1e3}},isInt:function(num){return""!==num&&!isNaN(parseInt(num,10))&&parseInt(num,10)==num/1},smartTrim:function(string,maxLength){if(!string)return string;if(maxLength<1)return string;if(string.length<=maxLength)return string;if(1==maxLength)return string.substring(0,1)+"...";var midpoint=Math.ceil(string.length/2),toremove=string.length-maxLength,lstrip=Math.ceil(toremove/2),rstrip=toremove-lstrip;return string.substring(0,midpoint-lstrip)+"..."+string.substring(midpoint+rstrip)},_tokenDiscoverer:/\$([^$]+)\$/g,discoverReplacementTokens:function(fragment){var keysToAdd,keys=[],tokenDiscoverer=Splunk.util._tokenDiscoverer;if("string"==typeof fragment){if(fragment.match(tokenDiscoverer)){keysToAdd=fragment.match(tokenDiscoverer);for(var i=0;i<keysToAdd.length;i++)keysToAdd[i]=keysToAdd[i].substring(1,keysToAdd[i].length-1);return keysToAdd}return[]}if("function"==typeof fragment)return[];for(var key in fragment){keysToAdd=[],keysToAdd=Splunk.util.discoverReplacementTokens(fragment[key]);for(var matchesInTheKeyItself=key.match(tokenDiscoverer)||[],j=0;j<matchesInTheKeyItself.length;j++)keysToAdd.push(matchesInTheKeyItself[j].substring(1,matchesInTheKeyItself[j].length-1));for(var k=0;k<keysToAdd.length;k++)-1==keys.indexOf(keysToAdd[k])&&keys.push(keysToAdd[k])}return keys},replaceTokens:function(fragment,reg,value){if("string"==typeof fragment)return fragment.match(reg)&&(fragment=fragment.replace(reg,value)),fragment;if("function"==typeof fragment)return fragment;var keysToRename={};for(var key in fragment)"object"==typeof fragment[key]?Splunk.util.replaceTokens(fragment[key],reg,value):"string"==typeof fragment[key]&&fragment[key].match(reg)&&(fragment[key]=fragment[key].replace(reg,value)),key.match(reg)&&(keysToRename[key]=key.replace(reg,value));for(var oldKey in keysToRename){fragment[keysToRename[oldKey]]=fragment[oldKey],delete fragment[oldKey]}return fragment},getServerTimezoneOffset:function(){return Splunk.util.getConfigValue("SERVER_TIMEZONE_OFFSET")},moduleLoadStates:{WAITING_FOR_INITIALIZATION:1,WAITING_FOR_HIERARCHY:2,WAITING_FOR_CONTEXT:6,HAS_CONTEXT:7},getRetryInterval:function(elapsed_time,min_interval,max_interval,clamp_time){return elapsed_time>=clamp_time?parseFloat(max_interval):Math.min(max_interval*Math.pow(elapsed_time/parseFloat(clamp_time),3)+min_interval,max_interval)},escapeHtml:function(input){return(""+input).replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#39;")},escapeBackslash:function(input){return(""+input).replace(/\\/g,"\\\\")},escapeQuotes:function(input){return(""+input).replace('"','\\"')},escapeRegex:function(input){return(input+"").replace(/([.?*+^$[\]\\(){}|-])/g,"\\$1")},escapeSelector:function(input){return(""+input).replace(/([;&,\.\+\*\~':"\!\^#$%@\[\]\(\)=>\|])/g,"\\$1")},trimToAlphaNumeric:function(input){return(""+input).replace(/([\s;&,\.\+\*\~':"\!\^#$%@\[\]\(\)=<>`\/\|\\])/g,"")},trim:function(str,delim){return delim?str.replace(new RegExp("^[\\s"+delim+"]+"),"").replace(new RegExp("[\\s"+delim+"]+$"),""):str.replace(/^\s\s*/,"").replace(/\s\s*$/,"")},lowerTrimStr:function(str,defValue){return str?this.trim(str).toLowerCase():defValue||str},focusFirstField:function(popup){var firstInput=$(":input:visible:enabled:first",popup),firstSelect=$("select:visible:enabled:first",popup);firstInput.is(":button")&&firstInput.hasClass("splButton-secondary")&&$(":input:button.splButton-primary:first",popup).length&&(firstInput=$(":input:button.splButton-primary:first",popup));var firstInputOffset=!!firstInput.length&&firstInput.offset().top,firstSelectOffset=!!firstSelect.length&&firstSelect.offset().top,firstElem=firstInput;firstInputOffset&&firstSelectOffset&&firstSelectOffset<firstInputOffset&&(firstElem=firstSelect),firstElem.focus(),firstElem.is(":focus")||setTimeout((function(){firstElem.focus()}),10)},getWikiTransform:function(str){var text=Splunk.util.escapeHtml(str);return text=(text=(text=(text=text.replace(/\[(\!?)(\w+\:\/\/[^\s]+)\s+([^\]]+)\]/g,'<a href="$2" #~#$1#~#>$3</a>')).replace(/\[\[(\!?)([^\|]+)\|([^\]]+)\]\]/g,Splunk.util._generateInternalLink)).replace(/#~#!#~#/g,'target="_blank"')).replace(/\s*#~##~#/g,"")},_generateInternalLink:function(str,blank_token,url,text){return'<a href="'+(url=Splunk.util.make_url(url))+'"#~#'+blank_token+"#~#>"+text+"</a>"},findMatchIndices:function(rex,source){for(var matches=source.match(rex),index=0,results=[],length=matches.length,i=0;i<length;i++){var match=matches[i];-1!=(index=source.indexOf(match,index))&&results.push({match:match,start:index,end:index+match.length-1}),index++}return results},isRainmakr:function(isDmcEnabled,isCloud){return!isDmcEnabled&&isCloud},isStackmakr:function(isDmcEnabled,isCloud){return isDmcEnabled&&isCloud},getIEVersion:function(){var myNav=navigator.userAgent.toLowerCase();return-1!=myNav.indexOf("msie")?parseInt(myNav.split("msie")[1],10):-1!=myNav.indexOf("trident")?parseInt(myNav.split(" rv:")[1],10):-1},restart_server:function(return_to){var start_time,restart_url_base,restart_url_proto,restart_timeout=!1,restart_tries=0,restart_done=!1,restart_notified=!1,img_list=[],restart_fail=function(msg){Splunk.Messenger.System.getInstance().send("error","restart_server",msg),$(document).trigger("restart_failed")},restart_succeeded=function(){var bounce_url;restart_notified||(restart_notified=!0,alert(_("Restart successful - close this dialog to redirect back to login page")),bounce_url=return_to?restart_url_base+this.make_full_url("/account/login",{return_to:return_to}):restart_url_base+this.make_url("/"),window.location.href=bounce_url)}.bind(this),restart_check_status=function(){restart_done||(restart_tries++>=180?restart_fail(_("Timed out waiting for restart")):($.ajax({type:"GET",dataType:"json",cache:!1,url:restart_url_base+this.make_url("/api/config/UI_UNIX_START_TIME"),success:function(data){data.start_time>start_time&&(restart_done=!0,clearTimeout(restart_timeout),restart_succeeded())}}),restart_timeout=setTimeout(restart_check_status,2e3)))}.bind(this),restart_img_loaded=function(){restart_done=!0,clearTimeout(restart_timeout),restart_succeeded()},restart_check_status_img=function(){if(!restart_done){var im=new Image;im.onload=restart_img_loaded,im.src=restart_url_base+this.make_url("/config/img?proto="+restart_url_proto+"&_="+Math.random()),img_list.push(im),restart_timeout=setTimeout(restart_check_status_img,2e3)}}.bind(this);$.post(this.make_url("/api/manager/control"),{operation:"restart_server"},function(data){if("OK"==data.status){start_time=data.start_time,"window"==data.ssl&&(data.ssl="https:"==window.location.protocol),restart_url_proto=data.ssl?"https":"http",restart_url_base=(data.ssl?"https://":"http://")+window.location.hostname+(80==data.port||data.ssl&&443==data.port?"":":"+data.port),Splunk.Logger.mode.Default=Splunk.Logger.mode.None,Splunk.Messenger&&(Splunk.Messenger.System.getInstance().abortRequests=!0),Splunk.Session.getInstance().signalRestart(),restart_tries=0;var current_port=window.location.port||("http:"==window.location.protocol?80:443),current_ssl="https:"==window.location.protocol;if(!current_ssl&&data.ssl||data.ssl&&current_port!=data.port)return void $(document).trigger({type:"restart_ssl",sslBase:restart_url_base});data.ssl!=current_ssl||current_port!=data.port?restart_check_status_img():restart_check_status()}else"PERMS"==data.status?restart_fail(_("Permission Denied - You are not authorized to restart the server")):"AUTH"==data.status?restart_fail(_("Restart failed")):"FAIL"==data.status?restart_fail(_("Restart failed: "+data.reason)):restart_fail(_("Restart failed"))}.bind(this),"json")},trackEvent:function(data){window._splunk_metrics_events&&"object"==typeof data&&window._splunk_metrics_events.push(data)}},!Function.prototype.bind){var $A=function(iterable){if(!iterable)return[];if(iterable.toArray)return iterable.toArray();for(var results=[],i=0,length=iterable.length;i<length;i++)results.push(iterable[i]);return results};Function.prototype.bind=function(){var __method=this,args=$A(arguments),object=args.shift();return function(){return __method.apply(object,args.concat($A(arguments)))}}}String.prototype.repeat||(String.prototype.repeat=function(count){return new Array(count+1).join(this)}),String.prototype.reverse||(String.prototype.reverse=function(){return this.split("").reverse().join("")}),String.prototype.rsplit||(String.prototype.rsplit=function(sep,limit){var sp=this.split(sep);if(limit&&sp.length>limit){for(var r=[],i=0;i<limit;i++)r[i]=sp[sp.length-limit+i];return r}return sp}),Array.prototype.indexOf||(Array.prototype.indexOf=function(search,fromIndex){fromIndex||(fromIndex=0);for(var i=0;i<this.length;i++)if(this[i]===search)return i;return-1}),Array.prototype.extend||(Array.prototype.extend=function(arr){for(var i=0;i<arr.length;i++)this.push(arr[i])});var sprintf=global.sprintf=function(){var regex=/%%|%(\d+\$)?(\([^)]+\))?([-+#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuidfegEG])/g,a=arguments,i=0,format=a[i];i++;var pad=function(str,len,chr,leftJustify){var padding=str.length>=len?"":Array(1+len-str.length>>>0).join(chr);return leftJustify?str+padding:padding+str},justify=function(value,prefix,leftJustify,minWidth,zeroPad){var diff=minWidth-value.length;return diff>0&&(value=leftJustify||!zeroPad?pad(value,minWidth," ",leftJustify):value.slice(0,prefix.length)+pad("",diff,"0",!0)+value.slice(prefix.length)),value},formatBaseX=function(value,base,prefix,leftJustify,minWidth,precision,zeroPad){var number=value>>>0;return value=(prefix=prefix&&number&&{2:"0b",8:"0",16:"0x"}[base]||"")+pad(number.toString(base),precision||0,"0",!1),justify(value,prefix,leftJustify,minWidth,zeroPad)},formatString=function(value,leftJustify,minWidth,precision,zeroPad){return null!=precision&&(value=value.slice(0,precision)),justify(value,"",leftJustify,minWidth,zeroPad)},doFormat=function(substring,valueIndex,valueName,flags,minWidth,_,precision,type){if("%%"==substring)return"%";for(var value,number,prefix,leftJustify=!1,positivePrefix="",zeroPad=!1,prefixBaseX=!1,flagsl=flags.length,j=0;flags&&j<flagsl;j++)switch(flags.charAt(j)){case" ":positivePrefix=" ";break;case"+":positivePrefix="+";break;case"-":leftJustify=!0;break;case"0":zeroPad=!0;break;case"#":prefixBaseX=!0}if(minWidth?"*"==minWidth?(minWidth=+a[i],i++):minWidth="*"==minWidth.charAt(0)?+a[minWidth.slice(1,-1)]:+minWidth:minWidth=0,minWidth<0&&(minWidth=-minWidth,leftJustify=!0),!isFinite(minWidth))throw new Error("sprintf: (minimum-)width must be finite");switch(precision?"*"==precision?(precision=+a[i],i++):precision="*"==precision.charAt(0)?+a[precision.slice(1,-1)]:+precision:precision="fFeE".indexOf(type)>-1?6:"d"==type?0:void 0,valueName?(valueName=valueName.substr(1,valueName.length-2),value=a[1].__getitem__?a[1].__getitem__(valueName):a[1][valueName]):valueIndex?value=a[valueIndex.slice(0,-1)]:(value=a[i],i++),type){case"s":return formatString(String(value),leftJustify,minWidth,precision,zeroPad);case"c":return formatString(String.fromCharCode(+value),leftJustify,minWidth,precision,zeroPad);case"b":return formatBaseX(value,2,prefixBaseX,leftJustify,minWidth,precision,zeroPad);case"o":return formatBaseX(value,8,prefixBaseX,leftJustify,minWidth,precision,zeroPad);case"x":return formatBaseX(value,16,prefixBaseX,leftJustify,minWidth,precision,zeroPad);case"X":return formatBaseX(value,16,prefixBaseX,leftJustify,minWidth,precision,zeroPad).toUpperCase();case"u":return formatBaseX(value,10,prefixBaseX,leftJustify,minWidth,precision,zeroPad);case"i":case"d":return value=(prefix=(number=parseInt(+value,10))<0?"-":positivePrefix)+pad(String(Math.abs(number)),precision,"0",!1),justify(value,prefix,leftJustify,minWidth,zeroPad);case"e":case"E":case"f":case"F":case"g":case"G":prefix=(number=+value)<0?"-":positivePrefix;var method=["toExponential","toFixed","toPrecision"]["efg".indexOf(type.toLowerCase())],textTransform=["toString","toUpperCase"]["eEfFgG".indexOf(type)%2];return value=prefix+Math.abs(number)[method](precision),justify(value,prefix,leftJustify,minWidth,zeroPad)[textTransform]();default:return substring}};return format.replace(regex,doFormat)}}(this)}).call(window)},4:function(module,exports){module.exports=__WEBPACK_EXTERNAL_MODULE__4__},5:function(module,exports){module.exports=__WEBPACK_EXTERNAL_MODULE__5__},6:function(module,exports,__webpack_require__){var __WEBPACK_AMD_DEFINE_FACTORY__,__WEBPACK_AMD_DEFINE_RESULT__;!function(){var d3={version:"3.5.17"},d3_arraySlice=[].slice,d3_array=function(list){return d3_arraySlice.call(list)},d3_document=this.document;function d3_documentElement(node){return node&&(node.ownerDocument||node.document||node).documentElement}function d3_window(node){return node&&(node.ownerDocument&&node.ownerDocument.defaultView||node.document&&node||node.defaultView)}if(d3_document)try{d3_array(d3_document.documentElement.childNodes)[0].nodeType}catch(e){d3_array=function(list){for(var i=list.length,array=new Array(i);i--;)array[i]=list[i];return array}}if(Date.now||(Date.now=function(){return+new Date}),d3_document)try{d3_document.createElement("DIV").style.setProperty("opacity",0,"")}catch(error){var d3_element_prototype=this.Element.prototype,d3_element_setAttribute=d3_element_prototype.setAttribute,d3_element_setAttributeNS=d3_element_prototype.setAttributeNS,d3_style_prototype=this.CSSStyleDeclaration.prototype,d3_style_setProperty=d3_style_prototype.setProperty;d3_element_prototype.setAttribute=function(name,value){d3_element_setAttribute.call(this,name,value+"")},d3_element_prototype.setAttributeNS=function(space,local,value){d3_element_setAttributeNS.call(this,space,local,value+"")},d3_style_prototype.setProperty=function(name,value,priority){d3_style_setProperty.call(this,name,value+"",priority)}}function d3_ascending(a,b){return a<b?-1:a>b?1:a>=b?0:NaN}function d3_number(x){return null===x?NaN:+x}function d3_numeric(x){return!isNaN(x)}function d3_bisector(compare){return{left:function(a,x,lo,hi){for(arguments.length<3&&(lo=0),arguments.length<4&&(hi=a.length);lo<hi;){var mid=lo+hi>>>1;compare(a[mid],x)<0?lo=mid+1:hi=mid}return lo},right:function(a,x,lo,hi){for(arguments.length<3&&(lo=0),arguments.length<4&&(hi=a.length);lo<hi;){var mid=lo+hi>>>1;compare(a[mid],x)>0?hi=mid:lo=mid+1}return lo}}}d3.ascending=d3_ascending,d3.descending=function(a,b){return b<a?-1:b>a?1:b>=a?0:NaN},d3.min=function(array,f){var a,b,i=-1,n=array.length;if(1===arguments.length){for(;++i<n;)if(null!=(b=array[i])&&b>=b){a=b;break}for(;++i<n;)null!=(b=array[i])&&a>b&&(a=b)}else{for(;++i<n;)if(null!=(b=f.call(array,array[i],i))&&b>=b){a=b;break}for(;++i<n;)null!=(b=f.call(array,array[i],i))&&a>b&&(a=b)}return a},d3.max=function(array,f){var a,b,i=-1,n=array.length;if(1===arguments.length){for(;++i<n;)if(null!=(b=array[i])&&b>=b){a=b;break}for(;++i<n;)null!=(b=array[i])&&b>a&&(a=b)}else{for(;++i<n;)if(null!=(b=f.call(array,array[i],i))&&b>=b){a=b;break}for(;++i<n;)null!=(b=f.call(array,array[i],i))&&b>a&&(a=b)}return a},d3.extent=function(array,f){var a,b,c,i=-1,n=array.length;if(1===arguments.length){for(;++i<n;)if(null!=(b=array[i])&&b>=b){a=c=b;break}for(;++i<n;)null!=(b=array[i])&&(a>b&&(a=b),c<b&&(c=b))}else{for(;++i<n;)if(null!=(b=f.call(array,array[i],i))&&b>=b){a=c=b;break}for(;++i<n;)null!=(b=f.call(array,array[i],i))&&(a>b&&(a=b),c<b&&(c=b))}return[a,c]},d3.sum=function(array,f){var a,s=0,n=array.length,i=-1;if(1===arguments.length)for(;++i<n;)d3_numeric(a=+array[i])&&(s+=a);else for(;++i<n;)d3_numeric(a=+f.call(array,array[i],i))&&(s+=a);return s},d3.mean=function(array,f){var a,s=0,n=array.length,i=-1,j=n;if(1===arguments.length)for(;++i<n;)d3_numeric(a=d3_number(array[i]))?s+=a:--j;else for(;++i<n;)d3_numeric(a=d3_number(f.call(array,array[i],i)))?s+=a:--j;if(j)return s/j},d3.quantile=function(values,p){var H=(values.length-1)*p+1,h=Math.floor(H),v=+values[h-1],e=H-h;return e?v+e*(values[h]-v):v},d3.median=function(array,f){var a,numbers=[],n=array.length,i=-1;if(1===arguments.length)for(;++i<n;)d3_numeric(a=d3_number(array[i]))&&numbers.push(a);else for(;++i<n;)d3_numeric(a=d3_number(f.call(array,array[i],i)))&&numbers.push(a);if(numbers.length)return d3.quantile(numbers.sort(d3_ascending),.5)},d3.variance=function(array,f){var a,d,n=array.length,m=0,s=0,i=-1,j=0;if(1===arguments.length)for(;++i<n;)d3_numeric(a=d3_number(array[i]))&&(s+=(d=a-m)*(a-(m+=d/++j)));else for(;++i<n;)d3_numeric(a=d3_number(f.call(array,array[i],i)))&&(s+=(d=a-m)*(a-(m+=d/++j)));if(j>1)return s/(j-1)},d3.deviation=function(){var v=d3.variance.apply(this,arguments);return v?Math.sqrt(v):v};var d3_bisect=d3_bisector(d3_ascending);function d3_transposeLength(d){return d.length}d3.bisectLeft=d3_bisect.left,d3.bisect=d3.bisectRight=d3_bisect.right,d3.bisector=function(f){return d3_bisector(1===f.length?function(d,x){return d3_ascending(f(d),x)}:f)},d3.shuffle=function(array,i0,i1){(m=arguments.length)<3&&(i1=array.length,m<2&&(i0=0));for(var t,i,m=i1-i0;m;)i=Math.random()*m--|0,t=array[m+i0],array[m+i0]=array[i+i0],array[i+i0]=t;return array},d3.permute=function(array,indexes){for(var i=indexes.length,permutes=new Array(i);i--;)permutes[i]=array[indexes[i]];return permutes},d3.pairs=function(array){for(var i=0,n=array.length-1,p1=array[0],pairs=new Array(n<0?0:n);i<n;)pairs[i]=[p1,p1=array[++i]];return pairs},d3.transpose=function(matrix){if(!(n=matrix.length))return[];for(var i=-1,m=d3.min(matrix,d3_transposeLength),transpose=new Array(m);++i<m;)for(var n,j=-1,row=transpose[i]=new Array(n);++j<n;)row[j]=matrix[j][i];return transpose},d3.zip=function(){return d3.transpose(arguments)},d3.keys=function(map){var keys=[];for(var key in map)keys.push(key);return keys},d3.values=function(map){var values=[];for(var key in map)values.push(map[key]);return values},d3.entries=function(map){var entries=[];for(var key in map)entries.push({key:key,value:map[key]});return entries},d3.merge=function(arrays){for(var m,merged,array,n=arrays.length,i=-1,j=0;++i<n;)j+=arrays[i].length;for(merged=new Array(j);--n>=0;)for(m=(array=arrays[n]).length;--m>=0;)merged[--j]=array[m];return merged};var abs=Math.abs;function d3_range_integerScale(x){for(var k=1;x*k%1;)k*=10;return k}function d3_class(ctor,properties){for(var key in properties)Object.defineProperty(ctor.prototype,key,{value:properties[key],enumerable:!1})}function d3_Map(){this._=Object.create(null)}d3.range=function(start,stop,step){if(arguments.length<3&&(step=1,arguments.length<2&&(stop=start,start=0)),(stop-start)/step==1/0)throw new Error("infinite range");var j,range=[],k=d3_range_integerScale(abs(step)),i=-1;if(start*=k,stop*=k,(step*=k)<0)for(;(j=start+step*++i)>stop;)range.push(j/k);else for(;(j=start+step*++i)<stop;)range.push(j/k);return range},d3.map=function(object,f){var map=new d3_Map;if(object instanceof d3_Map)object.forEach((function(key,value){map.set(key,value)}));else if(Array.isArray(object)){var o,i=-1,n=object.length;if(1===arguments.length)for(;++i<n;)map.set(i,object[i]);else for(;++i<n;)map.set(f.call(object,o=object[i],i),o)}else for(var key in object)map.set(key,object[key]);return map};function d3_map_escape(key){return"__proto__"==(key+="")||"\0"===key[0]?"\0"+key:key}function d3_map_unescape(key){return"\0"===(key+="")[0]?key.slice(1):key}function d3_map_has(key){return d3_map_escape(key)in this._}function d3_map_remove(key){return(key=d3_map_escape(key))in this._&&delete this._[key]}function d3_map_keys(){var keys=[];for(var key in this._)keys.push(d3_map_unescape(key));return keys}function d3_map_size(){var size=0;for(var key in this._)++size;return size}function d3_map_empty(){for(var key in this._)return!1;return!0}function d3_Set(){this._=Object.create(null)}function d3_identity(d){return d}function d3_rebind(target,source,method){return function(){var value=method.apply(source,arguments);return value===source?target:value}}function d3_vendorSymbol(object,name){if(name in object)return name;name=name.charAt(0).toUpperCase()+name.slice(1);for(var i=0,n=d3_vendorPrefixes.length;i<n;++i){var prefixName=d3_vendorPrefixes[i]+name;if(prefixName in object)return prefixName}}d3_class(d3_Map,{has:d3_map_has,get:function(key){return this._[d3_map_escape(key)]},set:function(key,value){return this._[d3_map_escape(key)]=value},remove:d3_map_remove,keys:d3_map_keys,values:function(){var values=[];for(var key in this._)values.push(this._[key]);return values},entries:function(){var entries=[];for(var key in this._)entries.push({key:d3_map_unescape(key),value:this._[key]});return entries},size:d3_map_size,empty:d3_map_empty,forEach:function(f){for(var key in this._)f.call(this,d3_map_unescape(key),this._[key])}}),d3.nest=function(){var sortValues,rollup,nest={},keys=[],sortKeys=[];function map(mapType,array,depth){if(depth>=keys.length)return rollup?rollup.call(nest,array):sortValues?array.sort(sortValues):array;for(var keyValue,object,setter,values,i=-1,n=array.length,key=keys[depth++],valuesByKey=new d3_Map;++i<n;)(values=valuesByKey.get(keyValue=key(object=array[i])))?values.push(object):valuesByKey.set(keyValue,[object]);return mapType?(object=mapType(),setter=function(keyValue,values){object.set(keyValue,map(mapType,values,depth))}):(object={},setter=function(keyValue,values){object[keyValue]=map(mapType,values,depth)}),valuesByKey.forEach(setter),object}return nest.map=function(array,mapType){return map(mapType,array,0)},nest.entries=function(array){return function entries(map,depth){if(depth>=keys.length)return map;var array=[],sortKey=sortKeys[depth++];return map.forEach((function(key,keyMap){array.push({key:key,values:entries(keyMap,depth)})})),sortKey?array.sort((function(a,b){return sortKey(a.key,b.key)})):array}(map(d3.map,array,0),0)},nest.key=function(d){return keys.push(d),nest},nest.sortKeys=function(order){return sortKeys[keys.length-1]=order,nest},nest.sortValues=function(order){return sortValues=order,nest},nest.rollup=function(f){return rollup=f,nest},nest},d3.set=function(array){var set=new d3_Set;if(array)for(var i=0,n=array.length;i<n;++i)set.add(array[i]);return set},d3_class(d3_Set,{has:d3_map_has,add:function(key){return this._[d3_map_escape(key+="")]=!0,key},remove:d3_map_remove,values:d3_map_keys,size:d3_map_size,empty:d3_map_empty,forEach:function(f){for(var key in this._)f.call(this,d3_map_unescape(key))}}),d3.behavior={},d3.rebind=function(target,source){for(var method,i=1,n=arguments.length;++i<n;)target[method=arguments[i]]=d3_rebind(target,source,source[method]);return target};var d3_vendorPrefixes=["webkit","ms","moz","Moz","o","O"];function d3_noop(){}function d3_dispatch(){}function d3_dispatch_event(dispatch){var listeners=[],listenerByName=new d3_Map;function event(){for(var l,z=listeners,i=-1,n=z.length;++i<n;)(l=z[i].on)&&l.apply(this,arguments);return dispatch}return event.on=function(name,listener){var i,l=listenerByName.get(name);return arguments.length<2?l&&l.on:(l&&(l.on=null,listeners=listeners.slice(0,i=listeners.indexOf(l)).concat(listeners.slice(i+1)),listenerByName.remove(name)),listener&&listeners.push(listenerByName.set(name,{on:listener})),dispatch)},event}function d3_eventPreventDefault(){d3.event.preventDefault()}function d3_eventSource(){for(var s,e=d3.event;s=e.sourceEvent;)e=s;return e}function d3_eventDispatch(target){for(var dispatch=new d3_dispatch,i=0,n=arguments.length;++i<n;)dispatch[arguments[i]]=d3_dispatch_event(dispatch);return dispatch.of=function(thiz,argumentz){return function(e1){try{var e0=e1.sourceEvent=d3.event;e1.target=target,d3.event=e1,dispatch[e1.type].apply(thiz,argumentz)}finally{d3.event=e0}}},dispatch}d3.dispatch=function(){for(var dispatch=new d3_dispatch,i=-1,n=arguments.length;++i<n;)dispatch[arguments[i]]=d3_dispatch_event(dispatch);return dispatch},d3_dispatch.prototype.on=function(type,listener){var i=type.indexOf("."),name="";if(i>=0&&(name=type.slice(i+1),type=type.slice(0,i)),type)return arguments.length<2?this[type].on(name):this[type].on(name,listener);if(2===arguments.length){if(null==listener)for(type in this)this.hasOwnProperty(type)&&this[type].on(name,null);return this}},d3.event=null,d3.requote=function(s){return s.replace(d3_requote_re,"\\$&")};var d3_requote_re=/[\\\^\$\*\+\?\|\[\]\(\)\.\{\}]/g,d3_subclass={}.__proto__?function(object,prototype){object.__proto__=prototype}:function(object,prototype){for(var property in prototype)object[property]=prototype[property]};function d3_selection(groups){return d3_subclass(groups,d3_selectionPrototype),groups}var d3_select=function(s,n){return n.querySelector(s)},d3_selectAll=function(s,n){return n.querySelectorAll(s)},d3_selectMatches=function(n,s){var d3_selectMatcher=n.matches||n[d3_vendorSymbol(n,"matchesSelector")];return(d3_selectMatches=function(n,s){return d3_selectMatcher.call(n,s)})(n,s)};"function"==typeof Sizzle&&(d3_select=function(s,n){return Sizzle(s,n)[0]||null},d3_selectAll=Sizzle,d3_selectMatches=Sizzle.matchesSelector),d3.selection=function(){return d3.select(d3_document.documentElement)};var d3_selectionPrototype=d3.selection.prototype=[];function d3_selection_selector(selector){return"function"==typeof selector?selector:function(){return d3_select(selector,this)}}function d3_selection_selectorAll(selector){return"function"==typeof selector?selector:function(){return d3_selectAll(selector,this)}}d3_selectionPrototype.select=function(selector){var subgroup,subnode,group,node,subgroups=[];selector=d3_selection_selector(selector);for(var j=-1,m=this.length;++j<m;){subgroups.push(subgroup=[]),subgroup.parentNode=(group=this[j]).parentNode;for(var i=-1,n=group.length;++i<n;)(node=group[i])?(subgroup.push(subnode=selector.call(node,node.__data__,i,j)),subnode&&"__data__"in node&&(subnode.__data__=node.__data__)):subgroup.push(null)}return d3_selection(subgroups)},d3_selectionPrototype.selectAll=function(selector){var subgroup,node,subgroups=[];selector=d3_selection_selectorAll(selector);for(var j=-1,m=this.length;++j<m;)for(var group=this[j],i=-1,n=group.length;++i<n;)(node=group[i])&&(subgroups.push(subgroup=d3_array(selector.call(node,node.__data__,i,j))),subgroup.parentNode=node);return d3_selection(subgroups)};var d3_nsXhtml="http://www.w3.org/1999/xhtml",d3_nsPrefix={svg:"http://www.w3.org/2000/svg",xhtml:d3_nsXhtml,xlink:"http://www.w3.org/1999/xlink",xml:"http://www.w3.org/XML/1998/namespace",xmlns:"http://www.w3.org/2000/xmlns/"};function d3_selection_attr(name,value){return name=d3.ns.qualify(name),null==value?name.local?function(){this.removeAttributeNS(name.space,name.local)}:function(){this.removeAttribute(name)}:"function"==typeof value?name.local?function(){var x=value.apply(this,arguments);null==x?this.removeAttributeNS(name.space,name.local):this.setAttributeNS(name.space,name.local,x)}:function(){var x=value.apply(this,arguments);null==x?this.removeAttribute(name):this.setAttribute(name,x)}:name.local?function(){this.setAttributeNS(name.space,name.local,value)}:function(){this.setAttribute(name,value)}}function d3_collapse(s){return s.trim().replace(/\s+/g," ")}function d3_selection_classedRe(name){return new RegExp("(?:^|\\s+)"+d3.requote(name)+"(?:\\s+|$)","g")}function d3_selection_classes(name){return(name+"").trim().split(/^|\s+/)}function d3_selection_classed(name,value){var n=(name=d3_selection_classes(name).map(d3_selection_classedName)).length;return"function"==typeof value?function(){for(var i=-1,x=value.apply(this,arguments);++i<n;)name[i](this,x)}:function(){for(var i=-1;++i<n;)name[i](this,value)}}function d3_selection_classedName(name){var re=d3_selection_classedRe(name);return function(node,value){if(c=node.classList)return value?c.add(name):c.remove(name);var c=node.getAttribute("class")||"";value?(re.lastIndex=0,re.test(c)||node.setAttribute("class",d3_collapse(c+" "+name))):node.setAttribute("class",d3_collapse(c.replace(re," ")))}}function d3_selection_style(name,value,priority){return null==value?function(){this.style.removeProperty(name)}:"function"==typeof value?function(){var x=value.apply(this,arguments);null==x?this.style.removeProperty(name):this.style.setProperty(name,x,priority)}:function(){this.style.setProperty(name,value,priority)}}function d3_selection_property(name,value){return null==value?function(){delete this[name]}:"function"==typeof value?function(){var x=value.apply(this,arguments);null==x?delete this[name]:this[name]=x}:function(){this[name]=value}}function d3_selection_creator(name){return"function"==typeof name?name:(name=d3.ns.qualify(name)).local?function(){return this.ownerDocument.createElementNS(name.space,name.local)}:function(){var document=this.ownerDocument,namespace=this.namespaceURI;return namespace===d3_nsXhtml&&document.documentElement.namespaceURI===d3_nsXhtml?document.createElement(name):document.createElementNS(namespace,name)}}function d3_selectionRemove(){var parent=this.parentNode;parent&&parent.removeChild(this)}function d3_selection_dataNode(data){return{__data__:data}}function d3_selection_filter(selector){return function(){return d3_selectMatches(this,selector)}}function d3_selection_sortComparator(comparator){return arguments.length||(comparator=d3_ascending),function(a,b){return a&&b?comparator(a.__data__,b.__data__):!a-!b}}function d3_selection_each(groups,callback){for(var j=0,m=groups.length;j<m;j++)for(var node,group=groups[j],i=0,n=group.length;i<n;i++)(node=group[i])&&callback(node,i,j);return groups}function d3_selection_enter(selection){return d3_subclass(selection,d3_selection_enterPrototype),selection}d3.ns={prefix:d3_nsPrefix,qualify:function(name){var i=name.indexOf(":"),prefix=name;return i>=0&&"xmlns"!==(prefix=name.slice(0,i))&&(name=name.slice(i+1)),d3_nsPrefix.hasOwnProperty(prefix)?{space:d3_nsPrefix[prefix],local:name}:name}},d3_selectionPrototype.attr=function(name,value){if(arguments.length<2){if("string"==typeof name){var node=this.node();return(name=d3.ns.qualify(name)).local?node.getAttributeNS(name.space,name.local):node.getAttribute(name)}for(value in name)this.each(d3_selection_attr(value,name[value]));return this}return this.each(d3_selection_attr(name,value))},d3_selectionPrototype.classed=function(name,value){if(arguments.length<2){if("string"==typeof name){var node=this.node(),n=(name=d3_selection_classes(name)).length,i=-1;if(value=node.classList){for(;++i<n;)if(!value.contains(name[i]))return!1}else for(value=node.getAttribute("class");++i<n;)if(!d3_selection_classedRe(name[i]).test(value))return!1;return!0}for(value in name)this.each(d3_selection_classed(value,name[value]));return this}return this.each(d3_selection_classed(name,value))},d3_selectionPrototype.style=function(name,value,priority){var n=arguments.length;if(n<3){if("string"!=typeof name){for(priority in n<2&&(value=""),name)this.each(d3_selection_style(priority,name[priority],value));return this}if(n<2){var node=this.node();return d3_window(node).getComputedStyle(node,null).getPropertyValue(name)}priority=""}return this.each(d3_selection_style(name,value,priority))},d3_selectionPrototype.property=function(name,value){if(arguments.length<2){if("string"==typeof name)return this.node()[name];for(value in name)this.each(d3_selection_property(value,name[value]));return this}return this.each(d3_selection_property(name,value))},d3_selectionPrototype.text=function(value){return arguments.length?this.each("function"==typeof value?function(){var v=value.apply(this,arguments);this.textContent=null==v?"":v}:null==value?function(){this.textContent=""}:function(){this.textContent=value}):this.node().textContent},d3_selectionPrototype.html=function(value){return arguments.length?this.each("function"==typeof value?function(){var v=value.apply(this,arguments);this.innerHTML=null==v?"":v}:null==value?function(){this.innerHTML=""}:function(){this.innerHTML=value}):this.node().innerHTML},d3_selectionPrototype.append=function(name){return name=d3_selection_creator(name),this.select((function(){return this.appendChild(name.apply(this,arguments))}))},d3_selectionPrototype.insert=function(name,before){return name=d3_selection_creator(name),before=d3_selection_selector(before),this.select((function(){return this.insertBefore(name.apply(this,arguments),before.apply(this,arguments)||null)}))},d3_selectionPrototype.remove=function(){return this.each(d3_selectionRemove)},d3_selectionPrototype.data=function(value,key){var group,node,i=-1,n=this.length;if(!arguments.length){for(value=new Array(n=(group=this[0]).length);++i<n;)(node=group[i])&&(value[i]=node.__data__);return value}function bind(group,groupData){var i,node,nodeData,n=group.length,m=groupData.length,n0=Math.min(n,m),updateNodes=new Array(m),enterNodes=new Array(m),exitNodes=new Array(n);if(key){var keyValue,nodeByKeyValue=new d3_Map,keyValues=new Array(n);for(i=-1;++i<n;)(node=group[i])&&(nodeByKeyValue.has(keyValue=key.call(node,node.__data__,i))?exitNodes[i]=node:nodeByKeyValue.set(keyValue,node),keyValues[i]=keyValue);for(i=-1;++i<m;)(node=nodeByKeyValue.get(keyValue=key.call(groupData,nodeData=groupData[i],i)))?!0!==node&&(updateNodes[i]=node,node.__data__=nodeData):enterNodes[i]=d3_selection_dataNode(nodeData),nodeByKeyValue.set(keyValue,!0);for(i=-1;++i<n;)i in keyValues&&!0!==nodeByKeyValue.get(keyValues[i])&&(exitNodes[i]=group[i])}else{for(i=-1;++i<n0;)node=group[i],nodeData=groupData[i],node?(node.__data__=nodeData,updateNodes[i]=node):enterNodes[i]=d3_selection_dataNode(nodeData);for(;i<m;++i)enterNodes[i]=d3_selection_dataNode(groupData[i]);for(;i<n;++i)exitNodes[i]=group[i]}enterNodes.update=updateNodes,enterNodes.parentNode=updateNodes.parentNode=exitNodes.parentNode=group.parentNode,enter.push(enterNodes),update.push(updateNodes),exit.push(exitNodes)}var enter=d3_selection_enter([]),update=d3_selection([]),exit=d3_selection([]);if("function"==typeof value)for(;++i<n;)bind(group=this[i],value.call(group,group.parentNode.__data__,i));else for(;++i<n;)bind(group=this[i],value);return update.enter=function(){return enter},update.exit=function(){return exit},update},d3_selectionPrototype.datum=function(value){return arguments.length?this.property("__data__",value):this.property("__data__")},d3_selectionPrototype.filter=function(filter){var subgroup,group,node,subgroups=[];"function"!=typeof filter&&(filter=d3_selection_filter(filter));for(var j=0,m=this.length;j<m;j++){subgroups.push(subgroup=[]),subgroup.parentNode=(group=this[j]).parentNode;for(var i=0,n=group.length;i<n;i++)(node=group[i])&&filter.call(node,node.__data__,i,j)&&subgroup.push(node)}return d3_selection(subgroups)},d3_selectionPrototype.order=function(){for(var j=-1,m=this.length;++j<m;)for(var node,group=this[j],i=group.length-1,next=group[i];--i>=0;)(node=group[i])&&(next&&next!==node.nextSibling&&next.parentNode.insertBefore(node,next),next=node);return this},d3_selectionPrototype.sort=function(comparator){comparator=d3_selection_sortComparator.apply(this,arguments);for(var j=-1,m=this.length;++j<m;)this[j].sort(comparator);return this.order()},d3_selectionPrototype.each=function(callback){return d3_selection_each(this,(function(node,i,j){callback.call(node,node.__data__,i,j)}))},d3_selectionPrototype.call=function(callback){var args=d3_array(arguments);return callback.apply(args[0]=this,args),this},d3_selectionPrototype.empty=function(){return!this.node()},d3_selectionPrototype.node=function(){for(var j=0,m=this.length;j<m;j++)for(var group=this[j],i=0,n=group.length;i<n;i++){var node=group[i];if(node)return node}return null},d3_selectionPrototype.size=function(){var n=0;return d3_selection_each(this,(function(){++n})),n};var d3_selection_enterPrototype=[];function d3_selection_enterInsertBefore(enter){var i0,j0;return function(d,i,j){var node,group=enter[j].update,n=group.length;for(j!=j0&&(j0=j,i0=0),i>=i0&&(i0=i+1);!(node=group[i0])&&++i0<n;);return node}}function d3_selection_on(type,listener,capture){var name="__on"+type,i=type.indexOf("."),wrap=d3_selection_onListener;i>0&&(type=type.slice(0,i));var filter=d3_selection_onFilters.get(type);function onRemove(){var l=this[name];l&&(this.removeEventListener(type,l,l.$),delete this[name])}return filter&&(type=filter,wrap=d3_selection_onFilter),i?listener?function(){var l=wrap(listener,d3_array(arguments));onRemove.call(this),this.addEventListener(type,this[name]=l,l.$=capture),l._=listener}:onRemove:listener?d3_noop:function(){var match,re=new RegExp("^__on([^.]+)"+d3.requote(type)+"$");for(var name in this)if(match=name.match(re)){var l=this[name];this.removeEventListener(match[1],l,l.$),delete this[name]}}}d3.selection.enter=d3_selection_enter,d3.selection.enter.prototype=d3_selection_enterPrototype,d3_selection_enterPrototype.append=d3_selectionPrototype.append,d3_selection_enterPrototype.empty=d3_selectionPrototype.empty,d3_selection_enterPrototype.node=d3_selectionPrototype.node,d3_selection_enterPrototype.call=d3_selectionPrototype.call,d3_selection_enterPrototype.size=d3_selectionPrototype.size,d3_selection_enterPrototype.select=function(selector){for(var subgroup,subnode,upgroup,group,node,subgroups=[],j=-1,m=this.length;++j<m;){upgroup=(group=this[j]).update,subgroups.push(subgroup=[]),subgroup.parentNode=group.parentNode;for(var i=-1,n=group.length;++i<n;)(node=group[i])?(subgroup.push(upgroup[i]=subnode=selector.call(group.parentNode,node.__data__,i,j)),subnode.__data__=node.__data__):subgroup.push(null)}return d3_selection(subgroups)},d3_selection_enterPrototype.insert=function(name,before){return arguments.length<2&&(before=d3_selection_enterInsertBefore(this)),d3_selectionPrototype.insert.call(this,name,before)},d3.select=function(node){var group;return"string"==typeof node?(group=[d3_select(node,d3_document)]).parentNode=d3_document.documentElement:(group=[node]).parentNode=d3_documentElement(node),d3_selection([group])},d3.selectAll=function(nodes){var group;return"string"==typeof nodes?(group=d3_array(d3_selectAll(nodes,d3_document))).parentNode=d3_document.documentElement:(group=d3_array(nodes)).parentNode=null,d3_selection([group])},d3_selectionPrototype.on=function(type,listener,capture){var n=arguments.length;if(n<3){if("string"!=typeof type){for(capture in n<2&&(listener=!1),type)this.each(d3_selection_on(capture,type[capture],listener));return this}if(n<2)return(n=this.node()["__on"+type])&&n._;capture=!1}return this.each(d3_selection_on(type,listener,capture))};var d3_selection_onFilters=d3.map({mouseenter:"mouseover",mouseleave:"mouseout"});function d3_selection_onListener(listener,argumentz){return function(e){var o=d3.event;d3.event=e,argumentz[0]=this.__data__;try{listener.apply(this,argumentz)}finally{d3.event=o}}}function d3_selection_onFilter(listener,argumentz){var l=d3_selection_onListener(listener,argumentz);return function(e){var related=e.relatedTarget;related&&(related===this||8&related.compareDocumentPosition(this))||l.call(this,e)}}d3_document&&d3_selection_onFilters.forEach((function(k){"on"+k in d3_document&&d3_selection_onFilters.remove(k)}));var d3_event_dragSelect,d3_event_dragId=0;function d3_event_dragSuppress(node){var name=".dragsuppress-"+ ++d3_event_dragId,click="click"+name,w=d3.select(d3_window(node)).on("touchmove"+name,d3_eventPreventDefault).on("dragstart"+name,d3_eventPreventDefault).on("selectstart"+name,d3_eventPreventDefault);if(null==d3_event_dragSelect&&(d3_event_dragSelect=!("onselectstart"in node)&&d3_vendorSymbol(node.style,"userSelect")),d3_event_dragSelect){var style=d3_documentElement(node).style,select=style[d3_event_dragSelect];style[d3_event_dragSelect]="none"}return function(suppressClick){if(w.on(name,null),d3_event_dragSelect&&(style[d3_event_dragSelect]=select),suppressClick){var off=function(){w.on(click,null)};w.on(click,(function(){d3_eventPreventDefault(),off()}),!0),setTimeout(off,0)}}}d3.mouse=function(container){return d3_mousePoint(container,d3_eventSource())};var d3_mouse_bug44083=this.navigator&&/WebKit/.test(this.navigator.userAgent)?-1:0;function d3_mousePoint(container,e){e.changedTouches&&(e=e.changedTouches[0]);var svg=container.ownerSVGElement||container;if(svg.createSVGPoint){var point=svg.createSVGPoint();if(d3_mouse_bug44083<0){var window=d3_window(container);if(window.scrollX||window.scrollY){var ctm=(svg=d3.select("body").append("svg").style({position:"absolute",top:0,left:0,margin:0,padding:0,border:"none"},"important"))[0][0].getScreenCTM();d3_mouse_bug44083=!(ctm.f||ctm.e),svg.remove()}}return d3_mouse_bug44083?(point.x=e.pageX,point.y=e.pageY):(point.x=e.clientX,point.y=e.clientY),[(point=point.matrixTransform(container.getScreenCTM().inverse())).x,point.y]}var rect=container.getBoundingClientRect();return[e.clientX-rect.left-container.clientLeft,e.clientY-rect.top-container.clientTop]}function d3_behavior_dragTouchId(){return d3.event.changedTouches[0].identifier}d3.touch=function(container,touches,identifier){if(arguments.length<3&&(identifier=touches,touches=d3_eventSource().changedTouches),touches)for(var touch,i=0,n=touches.length;i<n;++i)if((touch=touches[i]).identifier===identifier)return d3_mousePoint(container,touch)},d3.behavior.drag=function(){var event=d3_eventDispatch(drag,"drag","dragstart","dragend"),origin=null,mousedown=dragstart(d3_noop,d3.mouse,d3_window,"mousemove","mouseup"),touchstart=dragstart(d3_behavior_dragTouchId,d3.touch,d3_identity,"touchmove","touchend");function drag(){this.on("mousedown.drag",mousedown).on("touchstart.drag",touchstart)}function dragstart(id,position,subject,move,end){return function(){var dragOffset,that=this,target=d3.event.target.correspondingElement||d3.event.target,parent=that.parentNode,dispatch=event.of(that,arguments),dragged=0,dragId=id(),dragName=".drag"+(null==dragId?"":"-"+dragId),dragSubject=d3.select(subject(target)).on(move+dragName,moved).on(end+dragName,ended),dragRestore=d3_event_dragSuppress(target),position0=position(parent,dragId);function moved(){var dx,dy,position1=position(parent,dragId);position1&&(dx=position1[0]-position0[0],dy=position1[1]-position0[1],dragged|=dx|dy,position0=position1,dispatch({type:"drag",x:position1[0]+dragOffset[0],y:position1[1]+dragOffset[1],dx:dx,dy:dy}))}function ended(){position(parent,dragId)&&(dragSubject.on(move+dragName,null).on(end+dragName,null),dragRestore(dragged),dispatch({type:"dragend"}))}dragOffset=origin?[(dragOffset=origin.apply(that,arguments)).x-position0[0],dragOffset.y-position0[1]]:[0,0],dispatch({type:"dragstart"})}}return drag.origin=function(x){return arguments.length?(origin=x,drag):origin},d3.rebind(drag,event,"on")},d3.touches=function(container,touches){return arguments.length<2&&(touches=d3_eventSource().touches),touches?d3_array(touches).map((function(touch){var point=d3_mousePoint(container,touch);return point.identifier=touch.identifier,point})):[]};var ε=1e-6,ε2=1e-12,π=Math.PI,τ=2*π,τε=τ-ε,halfπ=π/2,d3_radians=π/180,d3_degrees=180/π;function d3_sgn(x){return x>0?1:x<0?-1:0}function d3_cross2d(a,b,c){return(b[0]-a[0])*(c[1]-a[1])-(b[1]-a[1])*(c[0]-a[0])}function d3_acos(x){return x>1?0:x<-1?π:Math.acos(x)}function d3_asin(x){return x>1?halfπ:x<-1?-halfπ:Math.asin(x)}function d3_cosh(x){return((x=Math.exp(x))+1/x)/2}function d3_haversin(x){return(x=Math.sin(x/2))*x}var ρ=Math.SQRT2;d3.interpolateZoom=function(p0,p1){var i,S,ux0=p0[0],uy0=p0[1],w0=p0[2],ux1=p1[0],uy1=p1[1],w1=p1[2],dx=ux1-ux0,dy=uy1-uy0,d2=dx*dx+dy*dy;if(d2<ε2)S=Math.log(w1/w0)/ρ,i=function(t){return[ux0+t*dx,uy0+t*dy,w0*Math.exp(ρ*t*S)]};else{var d1=Math.sqrt(d2),b0=(w1*w1-w0*w0+4*d2)/(2*w0*2*d1),b1=(w1*w1-w0*w0-4*d2)/(2*w1*2*d1),r0=Math.log(Math.sqrt(b0*b0+1)-b0),r1=Math.log(Math.sqrt(b1*b1+1)-b1);S=(r1-r0)/ρ,i=function(t){var x,s=t*S,coshr0=d3_cosh(r0),u=w0/(2*d1)*(coshr0*(x=ρ*s+r0,((x=Math.exp(2*x))-1)/(x+1))-function(x){return((x=Math.exp(x))-1/x)/2}(r0));return[ux0+u*dx,uy0+u*dy,w0*coshr0/d3_cosh(ρ*s+r0)]}}return i.duration=1e3*S,i},d3.behavior.zoom=function(){var translate0,center0,center,mousewheelTimer,touchtime,x0,x1,y0,y1,view={x:0,y:0,k:1},size=[960,500],scaleExtent=d3_behavior_zoomInfinity,duration=250,zooming=0,mousedown="mousedown.zoom",mousemove="mousemove.zoom",mouseup="mouseup.zoom",touchstart="touchstart.zoom",event=d3_eventDispatch(zoom,"zoomstart","zoom","zoomend");function zoom(g){g.on(mousedown,mousedowned).on(d3_behavior_zoomWheel+".zoom",mousewheeled).on("dblclick.zoom",dblclicked).on(touchstart,touchstarted)}function location(p){return[(p[0]-view.x)/view.k,(p[1]-view.y)/view.k]}function scaleTo(s){view.k=Math.max(scaleExtent[0],Math.min(scaleExtent[1],s))}function translateTo(p,l){l=function(l){return[l[0]*view.k+view.x,l[1]*view.k+view.y]}(l),view.x+=p[0]-l[0],view.y+=p[1]-l[1]}function zoomTo(that,p,l,k){that.__chart__={x:view.x,y:view.y,k:view.k},scaleTo(Math.pow(2,k)),translateTo(center0=p,l),that=d3.select(that),duration>0&&(that=that.transition().duration(duration)),that.call(zoom.event)}function rescale(){x1&&x1.domain(x0.range().map((function(x){return(x-view.x)/view.k})).map(x0.invert)),y1&&y1.domain(y0.range().map((function(y){return(y-view.y)/view.k})).map(y0.invert))}function zoomstarted(dispatch){zooming++||dispatch({type:"zoomstart"})}function zoomed(dispatch){rescale(),dispatch({type:"zoom",scale:view.k,translate:[view.x,view.y]})}function zoomended(dispatch){--zooming||(dispatch({type:"zoomend"}),center0=null)}function mousedowned(){var that=this,dispatch=event.of(that,arguments),dragged=0,subject=d3.select(d3_window(that)).on(mousemove,moved).on(mouseup,ended),location0=location(d3.mouse(that)),dragRestore=d3_event_dragSuppress(that);function moved(){dragged=1,translateTo(d3.mouse(that),location0),zoomed(dispatch)}function ended(){subject.on(mousemove,null).on(mouseup,null),dragRestore(dragged),zoomended(dispatch)}d3_selection_interrupt.call(that),zoomstarted(dispatch)}function touchstarted(){var scale0,that=this,dispatch=event.of(that,arguments),locations0={},distance0=0,zoomName=".zoom-"+d3.event.changedTouches[0].identifier,touchmove="touchmove"+zoomName,touchend="touchend"+zoomName,targets=[],subject=d3.select(that),dragRestore=d3_event_dragSuppress(that);function relocate(){var touches=d3.touches(that);return scale0=view.k,touches.forEach((function(t){t.identifier in locations0&&(locations0[t.identifier]=location(t))})),touches}function started(){var target=d3.event.target;d3.select(target).on(touchmove,moved).on(touchend,ended),targets.push(target);for(var changed=d3.event.changedTouches,i=0,n=changed.length;i<n;++i)locations0[changed[i].identifier]=null;var touches=relocate(),now=Date.now();if(1===touches.length){if(now-touchtime<500){var p=touches[0];zoomTo(that,p,locations0[p.identifier],Math.floor(Math.log(view.k)/Math.LN2)+1),d3_eventPreventDefault()}touchtime=now}else if(touches.length>1){p=touches[0];var q=touches[1],dx=p[0]-q[0],dy=p[1]-q[1];distance0=dx*dx+dy*dy}}function moved(){var p0,l0,p1,l1,touches=d3.touches(that);d3_selection_interrupt.call(that);for(var i=0,n=touches.length;i<n;++i,l1=null)if(p1=touches[i],l1=locations0[p1.identifier]){if(l0)break;p0=p1,l0=l1}if(l1){var distance1=(distance1=p1[0]-p0[0])*distance1+(distance1=p1[1]-p0[1])*distance1,scale1=distance0&&Math.sqrt(distance1/distance0);p0=[(p0[0]+p1[0])/2,(p0[1]+p1[1])/2],l0=[(l0[0]+l1[0])/2,(l0[1]+l1[1])/2],scaleTo(scale1*scale0)}touchtime=null,translateTo(p0,l0),zoomed(dispatch)}function ended(){if(d3.event.touches.length){for(var changed=d3.event.changedTouches,i=0,n=changed.length;i<n;++i)delete locations0[changed[i].identifier];for(var identifier in locations0)return void relocate()}d3.selectAll(targets).on(zoomName,null),subject.on(mousedown,mousedowned).on(touchstart,touchstarted),dragRestore(),zoomended(dispatch)}started(),zoomstarted(dispatch),subject.on(mousedown,null).on(touchstart,started)}function mousewheeled(){var dispatch=event.of(this,arguments);mousewheelTimer?clearTimeout(mousewheelTimer):(d3_selection_interrupt.call(this),translate0=location(center0=center||d3.mouse(this)),zoomstarted(dispatch)),mousewheelTimer=setTimeout((function(){mousewheelTimer=null,zoomended(dispatch)}),50),d3_eventPreventDefault(),scaleTo(Math.pow(2,.002*d3_behavior_zoomDelta())*view.k),translateTo(center0,translate0),zoomed(dispatch)}function dblclicked(){var p=d3.mouse(this),k=Math.log(view.k)/Math.LN2;zoomTo(this,p,location(p),d3.event.shiftKey?Math.ceil(k)-1:Math.floor(k)+1)}return d3_behavior_zoomWheel||(d3_behavior_zoomWheel="onwheel"in d3_document?(d3_behavior_zoomDelta=function(){return-d3.event.deltaY*(d3.event.deltaMode?120:1)},"wheel"):"onmousewheel"in d3_document?(d3_behavior_zoomDelta=function(){return d3.event.wheelDelta},"mousewheel"):(d3_behavior_zoomDelta=function(){return-d3.event.detail},"MozMousePixelScroll")),zoom.event=function(g){g.each((function(){var dispatch=event.of(this,arguments),view1=view;d3_transitionInheritId?d3.select(this).transition().each("start.zoom",(function(){view=this.__chart__||{x:0,y:0,k:1},zoomstarted(dispatch)})).tween("zoom:zoom",(function(){var dx=size[0],dy=size[1],cx=center0?center0[0]:dx/2,cy=center0?center0[1]:dy/2,i=d3.interpolateZoom([(cx-view.x)/view.k,(cy-view.y)/view.k,dx/view.k],[(cx-view1.x)/view1.k,(cy-view1.y)/view1.k,dx/view1.k]);return function(t){var l=i(t),k=dx/l[2];this.__chart__=view={x:cx-l[0]*k,y:cy-l[1]*k,k:k},zoomed(dispatch)}})).each("interrupt.zoom",(function(){zoomended(dispatch)})).each("end.zoom",(function(){zoomended(dispatch)})):(this.__chart__=view,zoomstarted(dispatch),zoomed(dispatch),zoomended(dispatch))}))},zoom.translate=function(_){return arguments.length?(view={x:+_[0],y:+_[1],k:view.k},rescale(),zoom):[view.x,view.y]},zoom.scale=function(_){return arguments.length?(view={x:view.x,y:view.y,k:null},scaleTo(+_),rescale(),zoom):view.k},zoom.scaleExtent=function(_){return arguments.length?(scaleExtent=null==_?d3_behavior_zoomInfinity:[+_[0],+_[1]],zoom):scaleExtent},zoom.center=function(_){return arguments.length?(center=_&&[+_[0],+_[1]],zoom):center},zoom.size=function(_){return arguments.length?(size=_&&[+_[0],+_[1]],zoom):size},zoom.duration=function(_){return arguments.length?(duration=+_,zoom):duration},zoom.x=function(z){return arguments.length?(x1=z,x0=z.copy(),view={x:0,y:0,k:1},zoom):x1},zoom.y=function(z){return arguments.length?(y1=z,y0=z.copy(),view={x:0,y:0,k:1},zoom):y1},d3.rebind(zoom,event,"on")};var d3_behavior_zoomDelta,d3_behavior_zoomWheel,d3_behavior_zoomInfinity=[0,1/0];function d3_color(){}function d3_hsl(h,s,l){return this instanceof d3_hsl?(this.h=+h,this.s=+s,void(this.l=+l)):arguments.length<2?h instanceof d3_hsl?new d3_hsl(h.h,h.s,h.l):d3_rgb_parse(""+h,d3_rgb_hsl,d3_hsl):new d3_hsl(h,s,l)}d3.color=d3_color,d3_color.prototype.toString=function(){return this.rgb()+""},d3.hsl=d3_hsl;var d3_hslPrototype=d3_hsl.prototype=new d3_color;function d3_hsl_rgb(h,s,l){var m1,m2;function vv(h){return Math.round(255*function(h){return h>360?h-=360:h<0&&(h+=360),h<60?m1+(m2-m1)*h/60:h<180?m2:h<240?m1+(m2-m1)*(240-h)/60:m1}(h))}return h=isNaN(h)?0:(h%=360)<0?h+360:h,s=isNaN(s)||s<0?0:s>1?1:s,m1=2*(l=l<0?0:l>1?1:l)-(m2=l<=.5?l*(1+s):l+s-l*s),new d3_rgb(vv(h+120),vv(h),vv(h-120))}function d3_hcl(h,c,l){return this instanceof d3_hcl?(this.h=+h,this.c=+c,void(this.l=+l)):arguments.length<2?h instanceof d3_hcl?new d3_hcl(h.h,h.c,h.l):d3_lab_hcl(h instanceof d3_lab?h.l:(h=d3_rgb_lab((h=d3.rgb(h)).r,h.g,h.b)).l,h.a,h.b):new d3_hcl(h,c,l)}d3_hslPrototype.brighter=function(k){return k=Math.pow(.7,arguments.length?k:1),new d3_hsl(this.h,this.s,this.l/k)},d3_hslPrototype.darker=function(k){return k=Math.pow(.7,arguments.length?k:1),new d3_hsl(this.h,this.s,k*this.l)},d3_hslPrototype.rgb=function(){return d3_hsl_rgb(this.h,this.s,this.l)},d3.hcl=d3_hcl;var d3_hclPrototype=d3_hcl.prototype=new d3_color;function d3_hcl_lab(h,c,l){return isNaN(h)&&(h=0),isNaN(c)&&(c=0),new d3_lab(l,Math.cos(h*=d3_radians)*c,Math.sin(h)*c)}function d3_lab(l,a,b){return this instanceof d3_lab?(this.l=+l,this.a=+a,void(this.b=+b)):arguments.length<2?l instanceof d3_lab?new d3_lab(l.l,l.a,l.b):l instanceof d3_hcl?d3_hcl_lab(l.h,l.c,l.l):d3_rgb_lab((l=d3_rgb(l)).r,l.g,l.b):new d3_lab(l,a,b)}d3_hclPrototype.brighter=function(k){return new d3_hcl(this.h,this.c,Math.min(100,this.l+d3_lab_K*(arguments.length?k:1)))},d3_hclPrototype.darker=function(k){return new d3_hcl(this.h,this.c,Math.max(0,this.l-d3_lab_K*(arguments.length?k:1)))},d3_hclPrototype.rgb=function(){return d3_hcl_lab(this.h,this.c,this.l).rgb()},d3.lab=d3_lab;var d3_lab_K=18,d3_labPrototype=d3_lab.prototype=new d3_color;function d3_lab_rgb(l,a,b){var y=(l+16)/116,x=y+a/500,z=y-b/200;return new d3_rgb(d3_xyz_rgb(3.2404542*(x=.95047*d3_lab_xyz(x))-1.5371385*(y=1*d3_lab_xyz(y))-.4985314*(z=1.08883*d3_lab_xyz(z))),d3_xyz_rgb(-.969266*x+1.8760108*y+.041556*z),d3_xyz_rgb(.0556434*x-.2040259*y+1.0572252*z))}function d3_lab_hcl(l,a,b){return l>0?new d3_hcl(Math.atan2(b,a)*d3_degrees,Math.sqrt(a*a+b*b),l):new d3_hcl(NaN,NaN,l)}function d3_lab_xyz(x){return x>.206893034?x*x*x:(x-4/29)/7.787037}function d3_xyz_lab(x){return x>.008856?Math.pow(x,1/3):7.787037*x+4/29}function d3_xyz_rgb(r){return Math.round(255*(r<=.00304?12.92*r:1.055*Math.pow(r,1/2.4)-.055))}function d3_rgb(r,g,b){return this instanceof d3_rgb?(this.r=~~r,this.g=~~g,void(this.b=~~b)):arguments.length<2?r instanceof d3_rgb?new d3_rgb(r.r,r.g,r.b):d3_rgb_parse(""+r,d3_rgb,d3_hsl_rgb):new d3_rgb(r,g,b)}function d3_rgbNumber(value){return new d3_rgb(value>>16,value>>8&255,255&value)}function d3_rgbString(value){return d3_rgbNumber(value)+""}d3_labPrototype.brighter=function(k){return new d3_lab(Math.min(100,this.l+d3_lab_K*(arguments.length?k:1)),this.a,this.b)},d3_labPrototype.darker=function(k){return new d3_lab(Math.max(0,this.l-d3_lab_K*(arguments.length?k:1)),this.a,this.b)},d3_labPrototype.rgb=function(){return d3_lab_rgb(this.l,this.a,this.b)},d3.rgb=d3_rgb;var d3_rgbPrototype=d3_rgb.prototype=new d3_color;function d3_rgb_hex(v){return v<16?"0"+Math.max(0,v).toString(16):Math.min(255,v).toString(16)}function d3_rgb_parse(format,rgb,hsl){var m1,m2,color,r=0,g=0,b=0;if(m1=/([a-z]+)\((.*)\)/.exec(format=format.toLowerCase()))switch(m2=m1[2].split(","),m1[1]){case"hsl":return hsl(parseFloat(m2[0]),parseFloat(m2[1])/100,parseFloat(m2[2])/100);case"rgb":return rgb(d3_rgb_parseNumber(m2[0]),d3_rgb_parseNumber(m2[1]),d3_rgb_parseNumber(m2[2]))}return(color=d3_rgb_names.get(format))?rgb(color.r,color.g,color.b):(null==format||"#"!==format.charAt(0)||isNaN(color=parseInt(format.slice(1),16))||(4===format.length?(r=(3840&color)>>4,r|=r>>4,g=240&color,g|=g>>4,b=15&color,b|=b<<4):7===format.length&&(r=(16711680&color)>>16,g=(65280&color)>>8,b=255&color)),rgb(r,g,b))}function d3_rgb_hsl(r,g,b){var h,s,min=Math.min(r/=255,g/=255,b/=255),max=Math.max(r,g,b),d=max-min,l=(max+min)/2;return d?(s=l<.5?d/(max+min):d/(2-max-min),h=r==max?(g-b)/d+(g<b?6:0):g==max?(b-r)/d+2:(r-g)/d+4,h*=60):(h=NaN,s=l>0&&l<1?0:h),new d3_hsl(h,s,l)}function d3_rgb_lab(r,g,b){var x=d3_xyz_lab((.4124564*(r=d3_rgb_xyz(r))+.3575761*(g=d3_rgb_xyz(g))+.1804375*(b=d3_rgb_xyz(b)))/.95047),y=d3_xyz_lab((.2126729*r+.7151522*g+.072175*b)/1);return d3_lab(116*y-16,500*(x-y),200*(y-d3_xyz_lab((.0193339*r+.119192*g+.9503041*b)/1.08883)))}function d3_rgb_xyz(r){return(r/=255)<=.04045?r/12.92:Math.pow((r+.055)/1.055,2.4)}function d3_rgb_parseNumber(c){var f=parseFloat(c);return"%"===c.charAt(c.length-1)?Math.round(2.55*f):f}d3_rgbPrototype.brighter=function(k){k=Math.pow(.7,arguments.length?k:1);var r=this.r,g=this.g,b=this.b,i=30;return r||g||b?(r&&r<i&&(r=i),g&&g<i&&(g=i),b&&b<i&&(b=i),new d3_rgb(Math.min(255,r/k),Math.min(255,g/k),Math.min(255,b/k))):new d3_rgb(i,i,i)},d3_rgbPrototype.darker=function(k){return new d3_rgb((k=Math.pow(.7,arguments.length?k:1))*this.r,k*this.g,k*this.b)},d3_rgbPrototype.hsl=function(){return d3_rgb_hsl(this.r,this.g,this.b)},d3_rgbPrototype.toString=function(){return"#"+d3_rgb_hex(this.r)+d3_rgb_hex(this.g)+d3_rgb_hex(this.b)};var d3_rgb_names=d3.map({aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,rebeccapurple:6697881,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074});function d3_functor(v){return"function"==typeof v?v:function(){return v}}function d3_xhrType(response){return function(url,mimeType,callback){return 2===arguments.length&&"function"==typeof mimeType&&(callback=mimeType,mimeType=null),d3_xhr(url,mimeType,response,callback)}}function d3_xhr(url,mimeType,response,callback){var xhr={},dispatch=d3.dispatch("beforesend","progress","load","error"),headers={},request=new XMLHttpRequest,responseType=null;function respond(){var result,status=request.status;if(!status&&function(request){var type=request.responseType;return type&&"text"!==type?request.response:request.responseText}(request)||status>=200&&status<300||304===status){try{result=response.call(xhr,request)}catch(e){return void dispatch.error.call(xhr,e)}dispatch.load.call(xhr,result)}else dispatch.error.call(xhr,request)}return this.XDomainRequest&&!("withCredentials"in request)&&/^(http(s)?:)?\/\//.test(url)&&(request=new XDomainRequest),"onload"in request?request.onload=request.onerror=respond:request.onreadystatechange=function(){request.readyState>3&&respond()},request.onprogress=function(event){var o=d3.event;d3.event=event;try{dispatch.progress.call(xhr,request)}finally{d3.event=o}},xhr.header=function(name,value){return name=(name+"").toLowerCase(),arguments.length<2?headers[name]:(null==value?delete headers[name]:headers[name]=value+"",xhr)},xhr.mimeType=function(value){return arguments.length?(mimeType=null==value?null:value+"",xhr):mimeType},xhr.responseType=function(value){return arguments.length?(responseType=value,xhr):responseType},xhr.response=function(value){return response=value,xhr},["get","post"].forEach((function(method){xhr[method]=function(){return xhr.send.apply(xhr,[method].concat(d3_array(arguments)))}})),xhr.send=function(method,data,callback){if(2===arguments.length&&"function"==typeof data&&(callback=data,data=null),request.open(method,url,!0),null==mimeType||"accept"in headers||(headers.accept=mimeType+",*/*"),request.setRequestHeader)for(var name in headers)request.setRequestHeader(name,headers[name]);return null!=mimeType&&request.overrideMimeType&&request.overrideMimeType(mimeType),null!=responseType&&(request.responseType=responseType),null!=callback&&xhr.on("error",callback).on("load",(function(request){callback(null,request)})),dispatch.beforesend.call(xhr,request),request.send(null==data?null:data),xhr},xhr.abort=function(){return request.abort(),xhr},d3.rebind(xhr,dispatch,"on"),null==callback?xhr:xhr.get(function(callback){return 1===callback.length?function(error,request){callback(null==error?request:null)}:callback}(callback))}d3_rgb_names.forEach((function(key,value){d3_rgb_names.set(key,d3_rgbNumber(value))})),d3.functor=d3_functor,d3.xhr=d3_xhrType(d3_identity),d3.dsv=function(delimiter,mimeType){var reFormat=new RegExp('["'+delimiter+"\n]"),delimiterCode=delimiter.charCodeAt(0);function dsv(url,row,callback){arguments.length<3&&(callback=row,row=null);var xhr=d3_xhr(url,mimeType,null==row?response:typedResponse(row),callback);return xhr.row=function(_){return arguments.length?xhr.response(null==(row=_)?response:typedResponse(_)):row},xhr}function response(request){return dsv.parse(request.responseText)}function typedResponse(f){return function(request){return dsv.parse(request.responseText,f)}}function formatRow(row){return row.map(formatValue).join(delimiter)}function formatValue(text){return reFormat.test(text)?'"'+text.replace(/\"/g,'""')+'"':text}return dsv.parse=function(text,f){var o;return dsv.parseRows(text,(function(row,i){if(o)return o(row,i-1);var a=new Function("d","return {"+row.map((function(name,i){return JSON.stringify(name)+": d["+i+"]"})).join(",")+"}");o=f?function(row,i){return f(a(row),i)}:a}))},dsv.parseRows=function(text,f){var t,eol,EOL={},EOF={},rows=[],N=text.length,I=0,n=0;function token(){if(I>=N)return EOF;if(eol)return eol=!1,EOL;var j=I;if(34===text.charCodeAt(j)){for(var i=j;i++<N;)if(34===text.charCodeAt(i)){if(34!==text.charCodeAt(i+1))break;++i}return I=i+2,13===(c=text.charCodeAt(i+1))?(eol=!0,10===text.charCodeAt(i+2)&&++I):10===c&&(eol=!0),text.slice(j+1,i).replace(/""/g,'"')}for(;I<N;){var c,k=1;if(10===(c=text.charCodeAt(I++)))eol=!0;else if(13===c)eol=!0,10===text.charCodeAt(I)&&(++I,++k);else if(c!==delimiterCode)continue;return text.slice(j,I-k)}return text.slice(j)}for(;(t=token())!==EOF;){for(var a=[];t!==EOL&&t!==EOF;)a.push(t),t=token();f&&null==(a=f(a,n++))||rows.push(a)}return rows},dsv.format=function(rows){if(Array.isArray(rows[0]))return dsv.formatRows(rows);var fieldSet=new d3_Set,fields=[];return rows.forEach((function(row){for(var field in row)fieldSet.has(field)||fields.push(fieldSet.add(field))})),[fields.map(formatValue).join(delimiter)].concat(rows.map((function(row){return fields.map((function(field){return formatValue(row[field])})).join(delimiter)}))).join("\n")},dsv.formatRows=function(rows){return rows.map(formatRow).join("\n")},dsv},d3.csv=d3.dsv(",","text/csv"),d3.tsv=d3.dsv("\t","text/tab-separated-values");var d3_timer_queueHead,d3_timer_queueTail,d3_timer_interval,d3_timer_timeout,d3_timer_frame=this[d3_vendorSymbol(this,"requestAnimationFrame")]||function(callback){setTimeout(callback,17)};function d3_timer(callback,delay,then){var n=arguments.length;n<2&&(delay=0),n<3&&(then=Date.now());var time=then+delay,timer={c:callback,t:time,n:null};return d3_timer_queueTail?d3_timer_queueTail.n=timer:d3_timer_queueHead=timer,d3_timer_queueTail=timer,d3_timer_interval||(d3_timer_timeout=clearTimeout(d3_timer_timeout),d3_timer_interval=1,d3_timer_frame(d3_timer_step)),timer}function d3_timer_step(){var now=d3_timer_mark(),delay=d3_timer_sweep()-now;delay>24?(isFinite(delay)&&(clearTimeout(d3_timer_timeout),d3_timer_timeout=setTimeout(d3_timer_step,delay)),d3_timer_interval=0):(d3_timer_interval=1,d3_timer_frame(d3_timer_step))}function d3_timer_mark(){for(var now=Date.now(),timer=d3_timer_queueHead;timer;)now>=timer.t&&timer.c(now-timer.t)&&(timer.c=null),timer=timer.n;return now}function d3_timer_sweep(){for(var t0,t1=d3_timer_queueHead,time=1/0;t1;)t1.c?(t1.t<time&&(time=t1.t),t1=(t0=t1).n):t1=t0?t0.n=t1.n:d3_timer_queueHead=t1.n;return d3_timer_queueTail=t0,time}function d3_format_precision(x,p){return p-(x?Math.ceil(Math.log(x)/Math.LN10):1)}d3.timer=function(){d3_timer.apply(this,arguments)},d3.timer.flush=function(){d3_timer_mark(),d3_timer_sweep()},d3.round=function(x,n){return n?Math.round(x*(n=Math.pow(10,n)))/n:Math.round(x)};var d3_formatPrefixes=["y","z","a","f","p","n","µ","m","","k","M","G","T","P","E","Z","Y"].map((function(d,i){var k=Math.pow(10,3*abs(8-i));return{scale:i>8?function(d){return d/k}:function(d){return d*k},symbol:d}}));function d3_locale_numberFormat(locale){var locale_decimal=locale.decimal,locale_thousands=locale.thousands,locale_grouping=locale.grouping,locale_currency=locale.currency,formatGroup=locale_grouping&&locale_thousands?function(value,width){for(var i=value.length,t=[],j=0,g=locale_grouping[0],length=0;i>0&&g>0&&(length+g+1>width&&(g=Math.max(1,width-length)),t.push(value.substring(i-=g,i+g)),!((length+=g+1)>width));)g=locale_grouping[j=(j+1)%locale_grouping.length];return t.reverse().join(locale_thousands)}:d3_identity;return function(specifier){var match=d3_format_re.exec(specifier),fill=match[1]||" ",align=match[2]||">",sign=match[3]||"-",symbol=match[4]||"",zfill=match[5],width=+match[6],comma=match[7],precision=match[8],type=match[9],scale=1,prefix="",suffix="",integer=!1,exponent=!0;switch(precision&&(precision=+precision.substring(1)),(zfill||"0"===fill&&"="===align)&&(zfill=fill="0",align="="),type){case"n":comma=!0,type="g";break;case"%":scale=100,suffix="%",type="f";break;case"p":scale=100,suffix="%",type="r";break;case"b":case"o":case"x":case"X":"#"===symbol&&(prefix="0"+type.toLowerCase());case"c":exponent=!1;case"d":integer=!0,precision=0;break;case"s":scale=-1,type="r"}"$"===symbol&&(prefix=locale_currency[0],suffix=locale_currency[1]),"r"!=type||precision||(type="g"),null!=precision&&("g"==type?precision=Math.max(1,Math.min(21,precision)):"e"!=type&&"f"!=type||(precision=Math.max(0,Math.min(20,precision)))),type=d3_format_types.get(type)||d3_format_typeDefault;var zcomma=zfill&&comma;return function(value){var fullSuffix=suffix;if(integer&&value%1)return"";var negative=value<0||0===value&&1/value<0?(value=-value,"-"):"-"===sign?"":sign;if(scale<0){var unit=d3.formatPrefix(value,precision);value=unit.scale(value),fullSuffix=unit.symbol+suffix}else value*=scale;var before,after,i=(value=type(value,precision)).lastIndexOf(".");if(i<0){var j=exponent?value.lastIndexOf("e"):-1;j<0?(before=value,after=""):(before=value.substring(0,j),after=value.substring(j))}else before=value.substring(0,i),after=locale_decimal+value.substring(i+1);!zfill&&comma&&(before=formatGroup(before,1/0));var length=prefix.length+before.length+after.length+(zcomma?0:negative.length),padding=length<width?new Array(length=width-length+1).join(fill):"";return zcomma&&(before=formatGroup(padding+before,padding.length?width-after.length:1/0)),negative+=prefix,value=before+after,("<"===align?negative+value+padding:">"===align?padding+negative+value:"^"===align?padding.substring(0,length>>=1)+negative+value+padding.substring(length):negative+(zcomma?value:padding+value))+fullSuffix}}}d3.formatPrefix=function(value,precision){var i=0;return(value=+value)&&(value<0&&(value*=-1),precision&&(value=d3.round(value,d3_format_precision(value,precision))),i=1+Math.floor(1e-12+Math.log(value)/Math.LN10),i=Math.max(-24,Math.min(24,3*Math.floor((i-1)/3)))),d3_formatPrefixes[8+i/3]};var d3_format_re=/(?:([^{])?([<>=^]))?([+\- ])?([$#])?(0)?(\d+)?(,)?(\.-?\d+)?([a-z%])?/i,d3_format_types=d3.map({b:function(x){return x.toString(2)},c:function(x){return String.fromCharCode(x)},o:function(x){return x.toString(8)},x:function(x){return x.toString(16)},X:function(x){return x.toString(16).toUpperCase()},g:function(x,p){return x.toPrecision(p)},e:function(x,p){return x.toExponential(p)},f:function(x,p){return x.toFixed(p)},r:function(x,p){return(x=d3.round(x,d3_format_precision(x,p))).toFixed(Math.max(0,Math.min(20,d3_format_precision(x*(1+1e-15),p))))}});function d3_format_typeDefault(x){return x+""}var d3_time=d3.time={},d3_date=Date;function d3_date_utc(){this._=new Date(arguments.length>1?Date.UTC.apply(this,arguments):arguments[0])}d3_date_utc.prototype={getDate:function(){return this._.getUTCDate()},getDay:function(){return this._.getUTCDay()},getFullYear:function(){return this._.getUTCFullYear()},getHours:function(){return this._.getUTCHours()},getMilliseconds:function(){return this._.getUTCMilliseconds()},getMinutes:function(){return this._.getUTCMinutes()},getMonth:function(){return this._.getUTCMonth()},getSeconds:function(){return this._.getUTCSeconds()},getTime:function(){return this._.getTime()},getTimezoneOffset:function(){return 0},valueOf:function(){return this._.valueOf()},setDate:function(){d3_time_prototype.setUTCDate.apply(this._,arguments)},setDay:function(){d3_time_prototype.setUTCDay.apply(this._,arguments)},setFullYear:function(){d3_time_prototype.setUTCFullYear.apply(this._,arguments)},setHours:function(){d3_time_prototype.setUTCHours.apply(this._,arguments)},setMilliseconds:function(){d3_time_prototype.setUTCMilliseconds.apply(this._,arguments)},setMinutes:function(){d3_time_prototype.setUTCMinutes.apply(this._,arguments)},setMonth:function(){d3_time_prototype.setUTCMonth.apply(this._,arguments)},setSeconds:function(){d3_time_prototype.setUTCSeconds.apply(this._,arguments)},setTime:function(){d3_time_prototype.setTime.apply(this._,arguments)}};var d3_time_prototype=Date.prototype;function d3_time_interval(local,step,number){function round(date){var d0=local(date),d1=offset(d0,1);return date-d0<d1-date?d0:d1}function ceil(date){return step(date=local(new d3_date(date-1)),1),date}function offset(date,k){return step(date=new d3_date(+date),k),date}function range(t0,t1,dt){var time=ceil(t0),times=[];if(dt>1)for(;time<t1;)number(time)%dt||times.push(new Date(+time)),step(time,1);else for(;time<t1;)times.push(new Date(+time)),step(time,1);return times}local.floor=local,local.round=round,local.ceil=ceil,local.offset=offset,local.range=range;var utc=local.utc=d3_time_interval_utc(local);return utc.floor=utc,utc.round=d3_time_interval_utc(round),utc.ceil=d3_time_interval_utc(ceil),utc.offset=d3_time_interval_utc(offset),utc.range=function(t0,t1,dt){try{d3_date=d3_date_utc;var utc=new d3_date_utc;return utc._=t0,range(utc,t1,dt)}finally{d3_date=Date}},local}function d3_time_interval_utc(method){return function(date,k){try{d3_date=d3_date_utc;var utc=new d3_date_utc;return utc._=date,method(utc,k)._}finally{d3_date=Date}}}function d3_locale_timeFormat(locale){var locale_dateTime=locale.dateTime,locale_date=locale.date,locale_time=locale.time,locale_periods=locale.periods,locale_days=locale.days,locale_shortDays=locale.shortDays,locale_months=locale.months,locale_shortMonths=locale.shortMonths;function d3_time_format(template){var n=template.length;function format(date){for(var c,p,f,string=[],i=-1,j=0;++i<n;)37===template.charCodeAt(i)&&(string.push(template.slice(j,i)),null!=(p=d3_time_formatPads[c=template.charAt(++i)])&&(c=template.charAt(++i)),(f=d3_time_formats[c])&&(c=f(date,null==p?"e"===c?" ":"0":p)),string.push(c),j=i+1);return string.push(template.slice(j,i)),string.join("")}return format.parse=function(string){var d={y:1900,m:0,d:1,H:0,M:0,S:0,L:0,Z:null};if(d3_time_parse(d,template,string,0)!=string.length)return null;"p"in d&&(d.H=d.H%12+12*d.p);var localZ=null!=d.Z&&d3_date!==d3_date_utc,date=new(localZ?d3_date_utc:d3_date);return"j"in d?date.setFullYear(d.y,0,d.j):"W"in d||"U"in d?("w"in d||(d.w="W"in d?1:0),date.setFullYear(d.y,0,1),date.setFullYear(d.y,0,"W"in d?(d.w+6)%7+7*d.W-(date.getDay()+5)%7:d.w+7*d.U-(date.getDay()+6)%7)):date.setFullYear(d.y,d.m,d.d),date.setHours(d.H+(d.Z/100|0),d.M+d.Z%100,d.S,d.L),localZ?date._:date},format.toString=function(){return template},format}function d3_time_parse(date,template,string,j){for(var c,p,t,i=0,n=template.length,m=string.length;i<n;){if(j>=m)return-1;if(37===(c=template.charCodeAt(i++))){if(t=template.charAt(i++),!(p=d3_time_parsers[t in d3_time_formatPads?template.charAt(i++):t])||(j=p(date,string,j))<0)return-1}else if(c!=string.charCodeAt(j++))return-1}return j}d3_time_format.utc=function(template){var local=d3_time_format(template);function format(date){try{var utc=new(d3_date=d3_date_utc);return utc._=date,local(utc)}finally{d3_date=Date}}return format.parse=function(string){try{d3_date=d3_date_utc;var date=local.parse(string);return date&&date._}finally{d3_date=Date}},format.toString=local.toString,format},d3_time_format.multi=d3_time_format.utc.multi=d3_time_formatMulti;var d3_time_periodLookup=d3.map(),d3_time_dayRe=d3_time_formatRe(locale_days),d3_time_dayLookup=d3_time_formatLookup(locale_days),d3_time_dayAbbrevRe=d3_time_formatRe(locale_shortDays),d3_time_dayAbbrevLookup=d3_time_formatLookup(locale_shortDays),d3_time_monthRe=d3_time_formatRe(locale_months),d3_time_monthLookup=d3_time_formatLookup(locale_months),d3_time_monthAbbrevRe=d3_time_formatRe(locale_shortMonths),d3_time_monthAbbrevLookup=d3_time_formatLookup(locale_shortMonths);locale_periods.forEach((function(p,i){d3_time_periodLookup.set(p.toLowerCase(),i)}));var d3_time_formats={a:function(d){return locale_shortDays[d.getDay()]},A:function(d){return locale_days[d.getDay()]},b:function(d){return locale_shortMonths[d.getMonth()]},B:function(d){return locale_months[d.getMonth()]},c:d3_time_format(locale_dateTime),d:function(d,p){return d3_time_formatPad(d.getDate(),p,2)},e:function(d,p){return d3_time_formatPad(d.getDate(),p,2)},H:function(d,p){return d3_time_formatPad(d.getHours(),p,2)},I:function(d,p){return d3_time_formatPad(d.getHours()%12||12,p,2)},j:function(d,p){return d3_time_formatPad(1+d3_time.dayOfYear(d),p,3)},L:function(d,p){return d3_time_formatPad(d.getMilliseconds(),p,3)},m:function(d,p){return d3_time_formatPad(d.getMonth()+1,p,2)},M:function(d,p){return d3_time_formatPad(d.getMinutes(),p,2)},p:function(d){return locale_periods[+(d.getHours()>=12)]},S:function(d,p){return d3_time_formatPad(d.getSeconds(),p,2)},U:function(d,p){return d3_time_formatPad(d3_time.sundayOfYear(d),p,2)},w:function(d){return d.getDay()},W:function(d,p){return d3_time_formatPad(d3_time.mondayOfYear(d),p,2)},x:d3_time_format(locale_date),X:d3_time_format(locale_time),y:function(d,p){return d3_time_formatPad(d.getFullYear()%100,p,2)},Y:function(d,p){return d3_time_formatPad(d.getFullYear()%1e4,p,4)},Z:d3_time_zone,"%":function(){return"%"}},d3_time_parsers={a:function(date,string,i){d3_time_dayAbbrevRe.lastIndex=0;var n=d3_time_dayAbbrevRe.exec(string.slice(i));return n?(date.w=d3_time_dayAbbrevLookup.get(n[0].toLowerCase()),i+n[0].length):-1},A:function(date,string,i){d3_time_dayRe.lastIndex=0;var n=d3_time_dayRe.exec(string.slice(i));return n?(date.w=d3_time_dayLookup.get(n[0].toLowerCase()),i+n[0].length):-1},b:function(date,string,i){d3_time_monthAbbrevRe.lastIndex=0;var n=d3_time_monthAbbrevRe.exec(string.slice(i));return n?(date.m=d3_time_monthAbbrevLookup.get(n[0].toLowerCase()),i+n[0].length):-1},B:function(date,string,i){d3_time_monthRe.lastIndex=0;var n=d3_time_monthRe.exec(string.slice(i));return n?(date.m=d3_time_monthLookup.get(n[0].toLowerCase()),i+n[0].length):-1},c:function(date,string,i){return d3_time_parse(date,d3_time_formats.c.toString(),string,i)},d:d3_time_parseDay,e:d3_time_parseDay,H:d3_time_parseHour24,I:d3_time_parseHour24,j:d3_time_parseDayOfYear,L:d3_time_parseMilliseconds,m:d3_time_parseMonthNumber,M:d3_time_parseMinutes,p:function(date,string,i){var n=d3_time_periodLookup.get(string.slice(i,i+=2).toLowerCase());return null==n?-1:(date.p=n,i)},S:d3_time_parseSeconds,U:d3_time_parseWeekNumberSunday,w:d3_time_parseWeekdayNumber,W:d3_time_parseWeekNumberMonday,x:function(date,string,i){return d3_time_parse(date,d3_time_formats.x.toString(),string,i)},X:function(date,string,i){return d3_time_parse(date,d3_time_formats.X.toString(),string,i)},y:d3_time_parseYear,Y:d3_time_parseFullYear,Z:d3_time_parseZone,"%":d3_time_parseLiteralPercent};return d3_time_format}d3_time.year=d3_time_interval((function(date){return(date=d3_time.day(date)).setMonth(0,1),date}),(function(date,offset){date.setFullYear(date.getFullYear()+offset)}),(function(date){return date.getFullYear()})),d3_time.years=d3_time.year.range,d3_time.years.utc=d3_time.year.utc.range,d3_time.day=d3_time_interval((function(date){var day=new d3_date(2e3,0);return day.setFullYear(date.getFullYear(),date.getMonth(),date.getDate()),day}),(function(date,offset){date.setDate(date.getDate()+offset)}),(function(date){return date.getDate()-1})),d3_time.days=d3_time.day.range,d3_time.days.utc=d3_time.day.utc.range,d3_time.dayOfYear=function(date){var year=d3_time.year(date);return Math.floor((date-year-6e4*(date.getTimezoneOffset()-year.getTimezoneOffset()))/864e5)},["sunday","monday","tuesday","wednesday","thursday","friday","saturday"].forEach((function(day,i){i=7-i;var interval=d3_time[day]=d3_time_interval((function(date){return(date=d3_time.day(date)).setDate(date.getDate()-(date.getDay()+i)%7),date}),(function(date,offset){date.setDate(date.getDate()+7*Math.floor(offset))}),(function(date){var day=d3_time.year(date).getDay();return Math.floor((d3_time.dayOfYear(date)+(day+i)%7)/7)-(day!==i)}));d3_time[day+"s"]=interval.range,d3_time[day+"s"].utc=interval.utc.range,d3_time[day+"OfYear"]=function(date){var day=d3_time.year(date).getDay();return Math.floor((d3_time.dayOfYear(date)+(day+i)%7)/7)}})),d3_time.week=d3_time.sunday,d3_time.weeks=d3_time.sunday.range,d3_time.weeks.utc=d3_time.sunday.utc.range,d3_time.weekOfYear=d3_time.sundayOfYear;var d3_time_formatPads={"-":"",_:" ",0:"0"},d3_time_numberRe=/^\s*\d+/,d3_time_percentRe=/^%/;function d3_time_formatPad(value,fill,width){var sign=value<0?"-":"",string=(sign?-value:value)+"",length=string.length;return sign+(length<width?new Array(width-length+1).join(fill)+string:string)}function d3_time_formatRe(names){return new RegExp("^(?:"+names.map(d3.requote).join("|")+")","i")}function d3_time_formatLookup(names){for(var map=new d3_Map,i=-1,n=names.length;++i<n;)map.set(names[i].toLowerCase(),i);return map}function d3_time_parseWeekdayNumber(date,string,i){d3_time_numberRe.lastIndex=0;var n=d3_time_numberRe.exec(string.slice(i,i+1));return n?(date.w=+n[0],i+n[0].length):-1}function d3_time_parseWeekNumberSunday(date,string,i){d3_time_numberRe.lastIndex=0;var n=d3_time_numberRe.exec(string.slice(i));return n?(date.U=+n[0],i+n[0].length):-1}function d3_time_parseWeekNumberMonday(date,string,i){d3_time_numberRe.lastIndex=0;var n=d3_time_numberRe.exec(string.slice(i));return n?(date.W=+n[0],i+n[0].length):-1}function d3_time_parseFullYear(date,string,i){d3_time_numberRe.lastIndex=0;var n=d3_time_numberRe.exec(string.slice(i,i+4));return n?(date.y=+n[0],i+n[0].length):-1}function d3_time_parseYear(date,string,i){d3_time_numberRe.lastIndex=0;var d,n=d3_time_numberRe.exec(string.slice(i,i+2));return n?(date.y=(d=+n[0])+(d>68?1900:2e3),i+n[0].length):-1}function d3_time_parseZone(date,string,i){return/^[+-]\d{4}$/.test(string=string.slice(i,i+5))?(date.Z=-string,i+5):-1}function d3_time_parseMonthNumber(date,string,i){d3_time_numberRe.lastIndex=0;var n=d3_time_numberRe.exec(string.slice(i,i+2));return n?(date.m=n[0]-1,i+n[0].length):-1}function d3_time_parseDay(date,string,i){d3_time_numberRe.lastIndex=0;var n=d3_time_numberRe.exec(string.slice(i,i+2));return n?(date.d=+n[0],i+n[0].length):-1}function d3_time_parseDayOfYear(date,string,i){d3_time_numberRe.lastIndex=0;var n=d3_time_numberRe.exec(string.slice(i,i+3));return n?(date.j=+n[0],i+n[0].length):-1}function d3_time_parseHour24(date,string,i){d3_time_numberRe.lastIndex=0;var n=d3_time_numberRe.exec(string.slice(i,i+2));return n?(date.H=+n[0],i+n[0].length):-1}function d3_time_parseMinutes(date,string,i){d3_time_numberRe.lastIndex=0;var n=d3_time_numberRe.exec(string.slice(i,i+2));return n?(date.M=+n[0],i+n[0].length):-1}function d3_time_parseSeconds(date,string,i){d3_time_numberRe.lastIndex=0;var n=d3_time_numberRe.exec(string.slice(i,i+2));return n?(date.S=+n[0],i+n[0].length):-1}function d3_time_parseMilliseconds(date,string,i){d3_time_numberRe.lastIndex=0;var n=d3_time_numberRe.exec(string.slice(i,i+3));return n?(date.L=+n[0],i+n[0].length):-1}function d3_time_zone(d){var z=d.getTimezoneOffset(),zs=z>0?"-":"+",zh=abs(z)/60|0,zm=abs(z)%60;return zs+d3_time_formatPad(zh,"0",2)+d3_time_formatPad(zm,"0",2)}function d3_time_parseLiteralPercent(date,string,i){d3_time_percentRe.lastIndex=0;var n=d3_time_percentRe.exec(string.slice(i,i+1));return n?i+n[0].length:-1}function d3_time_formatMulti(formats){for(var n=formats.length,i=-1;++i<n;)formats[i][0]=this(formats[i][0]);return function(date){for(var i=0,f=formats[i];!f[1](date);)f=formats[++i];return f[0](date)}}d3.locale=function(locale){return{numberFormat:d3_locale_numberFormat(locale),timeFormat:d3_locale_timeFormat(locale)}};var d3_locale_enUS=d3.locale({decimal:".",thousands:",",grouping:[3],currency:["$",""],dateTime:"%a %b %e %X %Y",date:"%m/%d/%Y",time:"%H:%M:%S",periods:["AM","PM"],days:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],shortDays:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],months:["January","February","March","April","May","June","July","August","September","October","November","December"],shortMonths:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"]});function d3_adder(){}d3.format=d3_locale_enUS.numberFormat,d3.geo={},d3_adder.prototype={s:0,t:0,add:function(y){d3_adderSum(y,this.t,d3_adderTemp),d3_adderSum(d3_adderTemp.s,this.s,this),this.s?this.t+=d3_adderTemp.t:this.s=d3_adderTemp.t},reset:function(){this.s=this.t=0},valueOf:function(){return this.s}};var d3_adderTemp=new d3_adder;function d3_adderSum(a,b,o){var x=o.s=a+b,bv=x-a,av=x-bv;o.t=a-av+(b-bv)}function d3_geo_streamGeometry(geometry,listener){geometry&&d3_geo_streamGeometryType.hasOwnProperty(geometry.type)&&d3_geo_streamGeometryType[geometry.type](geometry,listener)}d3.geo.stream=function(object,listener){object&&d3_geo_streamObjectType.hasOwnProperty(object.type)?d3_geo_streamObjectType[object.type](object,listener):d3_geo_streamGeometry(object,listener)};var d3_geo_streamObjectType={Feature:function(feature,listener){d3_geo_streamGeometry(feature.geometry,listener)},FeatureCollection:function(object,listener){for(var features=object.features,i=-1,n=features.length;++i<n;)d3_geo_streamGeometry(features[i].geometry,listener)}},d3_geo_streamGeometryType={Sphere:function(object,listener){listener.sphere()},Point:function(object,listener){object=object.coordinates,listener.point(object[0],object[1],object[2])},MultiPoint:function(object,listener){for(var coordinates=object.coordinates,i=-1,n=coordinates.length;++i<n;)object=coordinates[i],listener.point(object[0],object[1],object[2])},LineString:function(object,listener){d3_geo_streamLine(object.coordinates,listener,0)},MultiLineString:function(object,listener){for(var coordinates=object.coordinates,i=-1,n=coordinates.length;++i<n;)d3_geo_streamLine(coordinates[i],listener,0)},Polygon:function(object,listener){d3_geo_streamPolygon(object.coordinates,listener)},MultiPolygon:function(object,listener){for(var coordinates=object.coordinates,i=-1,n=coordinates.length;++i<n;)d3_geo_streamPolygon(coordinates[i],listener)},GeometryCollection:function(object,listener){for(var geometries=object.geometries,i=-1,n=geometries.length;++i<n;)d3_geo_streamGeometry(geometries[i],listener)}};function d3_geo_streamLine(coordinates,listener,closed){var coordinate,i=-1,n=coordinates.length-closed;for(listener.lineStart();++i<n;)coordinate=coordinates[i],listener.point(coordinate[0],coordinate[1],coordinate[2]);listener.lineEnd()}function d3_geo_streamPolygon(coordinates,listener){var i=-1,n=coordinates.length;for(listener.polygonStart();++i<n;)d3_geo_streamLine(coordinates[i],listener,1);listener.polygonEnd()}d3.geo.area=function(object){return d3_geo_areaSum=0,d3.geo.stream(object,d3_geo_area),d3_geo_areaSum};var d3_geo_areaSum,d3_geo_centroidW0,d3_geo_centroidW1,d3_geo_centroidX0,d3_geo_centroidY0,d3_geo_centroidZ0,d3_geo_centroidX1,d3_geo_centroidY1,d3_geo_centroidZ1,d3_geo_centroidX2,d3_geo_centroidY2,d3_geo_centroidZ2,d3_geo_areaRingSum=new d3_adder,d3_geo_area={sphere:function(){d3_geo_areaSum+=4*π},point:d3_noop,lineStart:d3_noop,lineEnd:d3_noop,polygonStart:function(){d3_geo_areaRingSum.reset(),d3_geo_area.lineStart=d3_geo_areaRingStart},polygonEnd:function(){var area=2*d3_geo_areaRingSum;d3_geo_areaSum+=area<0?4*π+area:area,d3_geo_area.lineStart=d3_geo_area.lineEnd=d3_geo_area.point=d3_noop}};function d3_geo_areaRingStart(){var λ00,φ00,λ0,cosφ0,sinφ0;function nextPoint(λ,φ){φ=φ*d3_radians/2+π/4;var dλ=(λ*=d3_radians)-λ0,sdλ=dλ>=0?1:-1,adλ=sdλ*dλ,cosφ=Math.cos(φ),sinφ=Math.sin(φ),k=sinφ0*sinφ,u=cosφ0*cosφ+k*Math.cos(adλ),v=k*sdλ*Math.sin(adλ);d3_geo_areaRingSum.add(Math.atan2(v,u)),λ0=λ,cosφ0=cosφ,sinφ0=sinφ}d3_geo_area.point=function(λ,φ){d3_geo_area.point=nextPoint,λ0=(λ00=λ)*d3_radians,cosφ0=Math.cos(φ=(φ00=φ)*d3_radians/2+π/4),sinφ0=Math.sin(φ)},d3_geo_area.lineEnd=function(){nextPoint(λ00,φ00)}}function d3_geo_cartesian(spherical){var λ=spherical[0],φ=spherical[1],cosφ=Math.cos(φ);return[cosφ*Math.cos(λ),cosφ*Math.sin(λ),Math.sin(φ)]}function d3_geo_cartesianDot(a,b){return a[0]*b[0]+a[1]*b[1]+a[2]*b[2]}function d3_geo_cartesianCross(a,b){return[a[1]*b[2]-a[2]*b[1],a[2]*b[0]-a[0]*b[2],a[0]*b[1]-a[1]*b[0]]}function d3_geo_cartesianAdd(a,b){a[0]+=b[0],a[1]+=b[1],a[2]+=b[2]}function d3_geo_cartesianScale(vector,k){return[vector[0]*k,vector[1]*k,vector[2]*k]}function d3_geo_cartesianNormalize(d){var l=Math.sqrt(d[0]*d[0]+d[1]*d[1]+d[2]*d[2]);d[0]/=l,d[1]/=l,d[2]/=l}function d3_geo_spherical(cartesian){return[Math.atan2(cartesian[1],cartesian[0]),d3_asin(cartesian[2])]}function d3_geo_sphericalEqual(a,b){return abs(a[0]-b[0])<ε&&abs(a[1]-b[1])<ε}d3.geo.bounds=function(){var λ0,φ0,λ1,φ1,λ_,λ__,φ__,p0,dλSum,ranges,range,bound={point:point,lineStart:lineStart,lineEnd:lineEnd,polygonStart:function(){bound.point=ringPoint,bound.lineStart=ringStart,bound.lineEnd=ringEnd,dλSum=0,d3_geo_area.polygonStart()},polygonEnd:function(){d3_geo_area.polygonEnd(),bound.point=point,bound.lineStart=lineStart,bound.lineEnd=lineEnd,d3_geo_areaRingSum<0?(λ0=-(λ1=180),φ0=-(φ1=90)):dλSum>ε?φ1=90:dλSum<-ε&&(φ0=-90),range[0]=λ0,range[1]=λ1}};function point(λ,φ){ranges.push(range=[λ0=λ,λ1=λ]),φ<φ0&&(φ0=φ),φ>φ1&&(φ1=φ)}function linePoint(λ,φ){var p=d3_geo_cartesian([λ*d3_radians,φ*d3_radians]);if(p0){var normal=d3_geo_cartesianCross(p0,p),inflection=d3_geo_cartesianCross([normal[1],-normal[0],0],normal);d3_geo_cartesianNormalize(inflection),inflection=d3_geo_spherical(inflection);var dλ=λ-λ_,s=dλ>0?1:-1,λi=inflection[0]*d3_degrees*s,antimeridian=abs(dλ)>180;if(antimeridian^(s*λ_<λi&&λi<s*λ))(φi=inflection[1]*d3_degrees)>φ1&&(φ1=φi);else if(antimeridian^(s*λ_<(λi=(λi+360)%360-180)&&λi<s*λ)){var φi;(φi=-inflection[1]*d3_degrees)<φ0&&(φ0=φi)}else φ<φ0&&(φ0=φ),φ>φ1&&(φ1=φ);antimeridian?λ<λ_?angle(λ0,λ)>angle(λ0,λ1)&&(λ1=λ):angle(λ,λ1)>angle(λ0,λ1)&&(λ0=λ):λ1>=λ0?(λ<λ0&&(λ0=λ),λ>λ1&&(λ1=λ)):λ>λ_?angle(λ0,λ)>angle(λ0,λ1)&&(λ1=λ):angle(λ,λ1)>angle(λ0,λ1)&&(λ0=λ)}else point(λ,φ);p0=p,λ_=λ}function lineStart(){bound.point=linePoint}function lineEnd(){range[0]=λ0,range[1]=λ1,bound.point=point,p0=null}function ringPoint(λ,φ){if(p0){var dλ=λ-λ_;dλSum+=abs(dλ)>180?dλ+(dλ>0?360:-360):dλ}else λ__=λ,φ__=φ;d3_geo_area.point(λ,φ),linePoint(λ,φ)}function ringStart(){d3_geo_area.lineStart()}function ringEnd(){ringPoint(λ__,φ__),d3_geo_area.lineEnd(),abs(dλSum)>ε&&(λ0=-(λ1=180)),range[0]=λ0,range[1]=λ1,p0=null}function angle(λ0,λ1){return(λ1-=λ0)<0?λ1+360:λ1}function compareRanges(a,b){return a[0]-b[0]}function withinRange(x,range){return range[0]<=range[1]?range[0]<=x&&x<=range[1]:x<range[0]||range[1]<x}return function(feature){if(φ1=λ1=-(λ0=φ0=1/0),ranges=[],d3.geo.stream(feature,bound),n=ranges.length){ranges.sort(compareRanges);for(var i=1,merged=[a=ranges[0]];i<n;++i)withinRange((b=ranges[i])[0],a)||withinRange(b[1],a)?(angle(a[0],b[1])>angle(a[0],a[1])&&(a[1]=b[1]),angle(b[0],a[1])>angle(a[0],a[1])&&(a[0]=b[0])):merged.push(a=b);for(var dλ,n,b,best=-1/0,a=(i=0,merged[n=merged.length-1]);i<=n;a=b,++i)b=merged[i],(dλ=angle(a[1],b[0]))>best&&(best=dλ,λ0=b[0],λ1=a[1])}return ranges=range=null,λ0===1/0||φ0===1/0?[[NaN,NaN],[NaN,NaN]]:[[λ0,φ0],[λ1,φ1]]}}(),d3.geo.centroid=function(object){d3_geo_centroidW0=d3_geo_centroidW1=d3_geo_centroidX0=d3_geo_centroidY0=d3_geo_centroidZ0=d3_geo_centroidX1=d3_geo_centroidY1=d3_geo_centroidZ1=d3_geo_centroidX2=d3_geo_centroidY2=d3_geo_centroidZ2=0,d3.geo.stream(object,d3_geo_centroid);var x=d3_geo_centroidX2,y=d3_geo_centroidY2,z=d3_geo_centroidZ2,m=x*x+y*y+z*z;return m<ε2&&(x=d3_geo_centroidX1,y=d3_geo_centroidY1,z=d3_geo_centroidZ1,d3_geo_centroidW1<ε&&(x=d3_geo_centroidX0,y=d3_geo_centroidY0,z=d3_geo_centroidZ0),(m=x*x+y*y+z*z)<ε2)?[NaN,NaN]:[Math.atan2(y,x)*d3_degrees,d3_asin(z/Math.sqrt(m))*d3_degrees]};var d3_geo_centroid={sphere:d3_noop,point:d3_geo_centroidPoint,lineStart:d3_geo_centroidLineStart,lineEnd:d3_geo_centroidLineEnd,polygonStart:function(){d3_geo_centroid.lineStart=d3_geo_centroidRingStart},polygonEnd:function(){d3_geo_centroid.lineStart=d3_geo_centroidLineStart}};function d3_geo_centroidPoint(λ,φ){λ*=d3_radians;var cosφ=Math.cos(φ*=d3_radians);d3_geo_centroidPointXYZ(cosφ*Math.cos(λ),cosφ*Math.sin(λ),Math.sin(φ))}function d3_geo_centroidPointXYZ(x,y,z){++d3_geo_centroidW0,d3_geo_centroidX0+=(x-d3_geo_centroidX0)/d3_geo_centroidW0,d3_geo_centroidY0+=(y-d3_geo_centroidY0)/d3_geo_centroidW0,d3_geo_centroidZ0+=(z-d3_geo_centroidZ0)/d3_geo_centroidW0}function d3_geo_centroidLineStart(){var x0,y0,z0;function nextPoint(λ,φ){λ*=d3_radians;var cosφ=Math.cos(φ*=d3_radians),x=cosφ*Math.cos(λ),y=cosφ*Math.sin(λ),z=Math.sin(φ),w=Math.atan2(Math.sqrt((w=y0*z-z0*y)*w+(w=z0*x-x0*z)*w+(w=x0*y-y0*x)*w),x0*x+y0*y+z0*z);d3_geo_centroidW1+=w,d3_geo_centroidX1+=w*(x0+(x0=x)),d3_geo_centroidY1+=w*(y0+(y0=y)),d3_geo_centroidZ1+=w*(z0+(z0=z)),d3_geo_centroidPointXYZ(x0,y0,z0)}d3_geo_centroid.point=function(λ,φ){λ*=d3_radians;var cosφ=Math.cos(φ*=d3_radians);x0=cosφ*Math.cos(λ),y0=cosφ*Math.sin(λ),z0=Math.sin(φ),d3_geo_centroid.point=nextPoint,d3_geo_centroidPointXYZ(x0,y0,z0)}}function d3_geo_centroidLineEnd(){d3_geo_centroid.point=d3_geo_centroidPoint}function d3_geo_centroidRingStart(){var λ00,φ00,x0,y0,z0;function nextPoint(λ,φ){λ*=d3_radians;var cosφ=Math.cos(φ*=d3_radians),x=cosφ*Math.cos(λ),y=cosφ*Math.sin(λ),z=Math.sin(φ),cx=y0*z-z0*y,cy=z0*x-x0*z,cz=x0*y-y0*x,m=Math.sqrt(cx*cx+cy*cy+cz*cz),u=x0*x+y0*y+z0*z,v=m&&-d3_acos(u)/m,w=Math.atan2(m,u);d3_geo_centroidX2+=v*cx,d3_geo_centroidY2+=v*cy,d3_geo_centroidZ2+=v*cz,d3_geo_centroidW1+=w,d3_geo_centroidX1+=w*(x0+(x0=x)),d3_geo_centroidY1+=w*(y0+(y0=y)),d3_geo_centroidZ1+=w*(z0+(z0=z)),d3_geo_centroidPointXYZ(x0,y0,z0)}d3_geo_centroid.point=function(λ,φ){λ00=λ,φ00=φ,d3_geo_centroid.point=nextPoint,λ*=d3_radians;var cosφ=Math.cos(φ*=d3_radians);x0=cosφ*Math.cos(λ),y0=cosφ*Math.sin(λ),z0=Math.sin(φ),d3_geo_centroidPointXYZ(x0,y0,z0)},d3_geo_centroid.lineEnd=function(){nextPoint(λ00,φ00),d3_geo_centroid.lineEnd=d3_geo_centroidLineEnd,d3_geo_centroid.point=d3_geo_centroidPoint}}function d3_geo_compose(a,b){function compose(x,y){return x=a(x,y),b(x[0],x[1])}return a.invert&&b.invert&&(compose.invert=function(x,y){return(x=b.invert(x,y))&&a.invert(x[0],x[1])}),compose}function d3_true(){return!0}function d3_geo_clipPolygon(segments,compare,clipStartInside,interpolate,listener){var subject=[],clip=[];if(segments.forEach((function(segment){if(!((n=segment.length-1)<=0)){var n,p0=segment[0],p1=segment[n];if(d3_geo_sphericalEqual(p0,p1)){listener.lineStart();for(var i=0;i<n;++i)listener.point((p0=segment[i])[0],p0[1]);listener.lineEnd()}else{var a=new d3_geo_clipPolygonIntersection(p0,segment,null,!0),b=new d3_geo_clipPolygonIntersection(p0,null,a,!1);a.o=b,subject.push(a),clip.push(b),a=new d3_geo_clipPolygonIntersection(p1,segment,null,!1),b=new d3_geo_clipPolygonIntersection(p1,null,a,!0),a.o=b,subject.push(a),clip.push(b)}}})),clip.sort(compare),d3_geo_clipPolygonLinkCircular(subject),d3_geo_clipPolygonLinkCircular(clip),subject.length){for(var i=0,entry=clipStartInside,n=clip.length;i<n;++i)clip[i].e=entry=!entry;for(var points,point,start=subject[0];;){for(var current=start,isSubject=!0;current.v;)if((current=current.n)===start)return;points=current.z,listener.lineStart();do{if(current.v=current.o.v=!0,current.e){if(isSubject)for(i=0,n=points.length;i<n;++i)listener.point((point=points[i])[0],point[1]);else interpolate(current.x,current.n.x,1,listener);current=current.n}else{if(isSubject)for(i=(points=current.p.z).length-1;i>=0;--i)listener.point((point=points[i])[0],point[1]);else interpolate(current.x,current.p.x,-1,listener);current=current.p}points=(current=current.o).z,isSubject=!isSubject}while(!current.v);listener.lineEnd()}}}function d3_geo_clipPolygonLinkCircular(array){if(n=array.length){for(var n,b,i=0,a=array[0];++i<n;)a.n=b=array[i],b.p=a,a=b;a.n=b=array[0],b.p=a}}function d3_geo_clipPolygonIntersection(point,points,other,entry){this.x=point,this.z=points,this.o=other,this.e=entry,this.v=!1,this.n=this.p=null}function d3_geo_clip(pointVisible,clipLine,interpolate,clipStart){return function(rotate,listener){var segments,line=clipLine(listener),rotatedClipStart=rotate.invert(clipStart[0],clipStart[1]),clip={point:point,lineStart:lineStart,lineEnd:lineEnd,polygonStart:function(){clip.point=pointRing,clip.lineStart=ringStart,clip.lineEnd=ringEnd,segments=[],polygon=[]},polygonEnd:function(){clip.point=point,clip.lineStart=lineStart,clip.lineEnd=lineEnd,segments=d3.merge(segments);var clipStartInside=function(point,polygon){var meridian=point[0],parallel=point[1],meridianNormal=[Math.sin(meridian),-Math.cos(meridian),0],polarAngle=0,winding=0;d3_geo_areaRingSum.reset();for(var i=0,n=polygon.length;i<n;++i){var ring=polygon[i],m=ring.length;if(m)for(var point0=ring[0],λ0=point0[0],φ0=point0[1]/2+π/4,sinφ0=Math.sin(φ0),cosφ0=Math.cos(φ0),j=1;;){j===m&&(j=0);var λ=(point=ring[j])[0],φ=point[1]/2+π/4,sinφ=Math.sin(φ),cosφ=Math.cos(φ),dλ=λ-λ0,sdλ=dλ>=0?1:-1,adλ=sdλ*dλ,antimeridian=adλ>π,k=sinφ0*sinφ;if(d3_geo_areaRingSum.add(Math.atan2(k*sdλ*Math.sin(adλ),cosφ0*cosφ+k*Math.cos(adλ))),polarAngle+=antimeridian?dλ+sdλ*τ:dλ,antimeridian^λ0>=meridian^λ>=meridian){var arc=d3_geo_cartesianCross(d3_geo_cartesian(point0),d3_geo_cartesian(point));d3_geo_cartesianNormalize(arc);var intersection=d3_geo_cartesianCross(meridianNormal,arc);d3_geo_cartesianNormalize(intersection);var φarc=(antimeridian^dλ>=0?-1:1)*d3_asin(intersection[2]);(parallel>φarc||parallel===φarc&&(arc[0]||arc[1]))&&(winding+=antimeridian^dλ>=0?1:-1)}if(!j++)break;λ0=λ,sinφ0=sinφ,cosφ0=cosφ,point0=point}}return(polarAngle<-ε||polarAngle<ε&&d3_geo_areaRingSum<-ε)^1&winding}(rotatedClipStart,polygon);segments.length?(polygonStarted||(listener.polygonStart(),polygonStarted=!0),d3_geo_clipPolygon(segments,d3_geo_clipSort,clipStartInside,interpolate,listener)):clipStartInside&&(polygonStarted||(listener.polygonStart(),polygonStarted=!0),listener.lineStart(),interpolate(null,null,1,listener),listener.lineEnd()),polygonStarted&&(listener.polygonEnd(),polygonStarted=!1),segments=polygon=null},sphere:function(){listener.polygonStart(),listener.lineStart(),interpolate(null,null,1,listener),listener.lineEnd(),listener.polygonEnd()}};function point(λ,φ){var point=rotate(λ,φ);pointVisible(λ=point[0],φ=point[1])&&listener.point(λ,φ)}function pointLine(λ,φ){var point=rotate(λ,φ);line.point(point[0],point[1])}function lineStart(){clip.point=pointLine,line.lineStart()}function lineEnd(){clip.point=point,line.lineEnd()}var polygon,ring,buffer=d3_geo_clipBufferListener(),ringListener=clipLine(buffer),polygonStarted=!1;function pointRing(λ,φ){ring.push([λ,φ]);var point=rotate(λ,φ);ringListener.point(point[0],point[1])}function ringStart(){ringListener.lineStart(),ring=[]}function ringEnd(){pointRing(ring[0][0],ring[0][1]),ringListener.lineEnd();var segment,clean=ringListener.clean(),ringSegments=buffer.buffer(),n=ringSegments.length;if(ring.pop(),polygon.push(ring),ring=null,n)if(1&clean){var point,i=-1;if((n=(segment=ringSegments[0]).length-1)>0){for(polygonStarted||(listener.polygonStart(),polygonStarted=!0),listener.lineStart();++i<n;)listener.point((point=segment[i])[0],point[1]);listener.lineEnd()}}else n>1&&2&clean&&ringSegments.push(ringSegments.pop().concat(ringSegments.shift())),segments.push(ringSegments.filter(d3_geo_clipSegmentLength1))}return clip}}function d3_geo_clipSegmentLength1(segment){return segment.length>1}function d3_geo_clipBufferListener(){var line,lines=[];return{lineStart:function(){lines.push(line=[])},point:function(λ,φ){line.push([λ,φ])},lineEnd:d3_noop,buffer:function(){var buffer=lines;return lines=[],line=null,buffer},rejoin:function(){lines.length>1&&lines.push(lines.pop().concat(lines.shift()))}}}function d3_geo_clipSort(a,b){return((a=a.x)[0]<0?a[1]-halfπ-ε:halfπ-a[1])-((b=b.x)[0]<0?b[1]-halfπ-ε:halfπ-b[1])}var d3_geo_clipAntimeridian=d3_geo_clip(d3_true,(function(listener){var clean,λ0=NaN,φ0=NaN,sλ0=NaN;return{lineStart:function(){listener.lineStart(),clean=1},point:function(λ1,φ1){var sλ1=λ1>0?π:-π,dλ=abs(λ1-λ0);abs(dλ-π)<ε?(listener.point(λ0,φ0=(φ0+φ1)/2>0?halfπ:-halfπ),listener.point(sλ0,φ0),listener.lineEnd(),listener.lineStart(),listener.point(sλ1,φ0),listener.point(λ1,φ0),clean=0):sλ0!==sλ1&&dλ>=π&&(abs(λ0-sλ0)<ε&&(λ0-=sλ0*ε),abs(λ1-sλ1)<ε&&(λ1-=sλ1*ε),φ0=function(λ0,φ0,λ1,φ1){var cosφ0,cosφ1,sinλ0_λ1=Math.sin(λ0-λ1);return abs(sinλ0_λ1)>ε?Math.atan((Math.sin(φ0)*(cosφ1=Math.cos(φ1))*Math.sin(λ1)-Math.sin(φ1)*(cosφ0=Math.cos(φ0))*Math.sin(λ0))/(cosφ0*cosφ1*sinλ0_λ1)):(φ0+φ1)/2}(λ0,φ0,λ1,φ1),listener.point(sλ0,φ0),listener.lineEnd(),listener.lineStart(),listener.point(sλ1,φ0),clean=0),listener.point(λ0=λ1,φ0=φ1),sλ0=sλ1},lineEnd:function(){listener.lineEnd(),λ0=φ0=NaN},clean:function(){return 2-clean}}}),(function(from,to,direction,listener){var φ;if(null==from)φ=direction*halfπ,listener.point(-π,φ),listener.point(0,φ),listener.point(π,φ),listener.point(π,0),listener.point(π,-φ),listener.point(0,-φ),listener.point(-π,-φ),listener.point(-π,0),listener.point(-π,φ);else if(abs(from[0]-to[0])>ε){var s=from[0]<to[0]?π:-π;φ=direction*s/2,listener.point(-s,φ),listener.point(0,φ),listener.point(s,φ)}else listener.point(to[0],to[1])}),[-π,-π/2]);function d3_geo_clipCircle(radius){var cr=Math.cos(radius),smallRadius=cr>0,notHemisphere=abs(cr)>ε;return d3_geo_clip(visible,(function(listener){var point0,c0,v0,v00,clean;return{lineStart:function(){v00=v0=!1,clean=1},point:function(λ,φ){var point2,point1=[λ,φ],v=visible(λ,φ),c=smallRadius?v?0:code(λ,φ):v?code(λ+(λ<0?π:-π),φ):0;if(!point0&&(v00=v0=v)&&listener.lineStart(),v!==v0&&(point2=intersect(point0,point1),(d3_geo_sphericalEqual(point0,point2)||d3_geo_sphericalEqual(point1,point2))&&(point1[0]+=ε,point1[1]+=ε,v=visible(point1[0],point1[1]))),v!==v0)clean=0,v?(listener.lineStart(),point2=intersect(point1,point0),listener.point(point2[0],point2[1])):(point2=intersect(point0,point1),listener.point(point2[0],point2[1]),listener.lineEnd()),point0=point2;else if(notHemisphere&&point0&&smallRadius^v){var t;c&c0||!(t=intersect(point1,point0,!0))||(clean=0,smallRadius?(listener.lineStart(),listener.point(t[0][0],t[0][1]),listener.point(t[1][0],t[1][1]),listener.lineEnd()):(listener.point(t[1][0],t[1][1]),listener.lineEnd(),listener.lineStart(),listener.point(t[0][0],t[0][1])))}!v||point0&&d3_geo_sphericalEqual(point0,point1)||listener.point(point1[0],point1[1]),point0=point1,v0=v,c0=c},lineEnd:function(){v0&&listener.lineEnd(),point0=null},clean:function(){return clean|(v00&&v0)<<1}}}),d3_geo_circleInterpolate(radius,6*d3_radians),smallRadius?[0,-radius]:[-π,radius-π]);function visible(λ,φ){return Math.cos(λ)*Math.cos(φ)>cr}function intersect(a,b,two){var n1=[1,0,0],n2=d3_geo_cartesianCross(d3_geo_cartesian(a),d3_geo_cartesian(b)),n2n2=d3_geo_cartesianDot(n2,n2),n1n2=n2[0],determinant=n2n2-n1n2*n1n2;if(!determinant)return!two&&a;var c1=cr*n2n2/determinant,c2=-cr*n1n2/determinant,n1xn2=d3_geo_cartesianCross(n1,n2),A=d3_geo_cartesianScale(n1,c1);d3_geo_cartesianAdd(A,d3_geo_cartesianScale(n2,c2));var u=n1xn2,w=d3_geo_cartesianDot(A,u),uu=d3_geo_cartesianDot(u,u),t2=w*w-uu*(d3_geo_cartesianDot(A,A)-1);if(!(t2<0)){var t=Math.sqrt(t2),q=d3_geo_cartesianScale(u,(-w-t)/uu);if(d3_geo_cartesianAdd(q,A),q=d3_geo_spherical(q),!two)return q;var z,λ0=a[0],λ1=b[0],φ0=a[1],φ1=b[1];λ1<λ0&&(z=λ0,λ0=λ1,λ1=z);var δλ=λ1-λ0,polar=abs(δλ-π)<ε;if(!polar&&φ1<φ0&&(z=φ0,φ0=φ1,φ1=z),polar||δλ<ε?polar?φ0+φ1>0^q[1]<(abs(q[0]-λ0)<ε?φ0:φ1):φ0<=q[1]&&q[1]<=φ1:δλ>π^(λ0<=q[0]&&q[0]<=λ1)){var q1=d3_geo_cartesianScale(u,(-w+t)/uu);return d3_geo_cartesianAdd(q1,A),[q,d3_geo_spherical(q1)]}}}function code(λ,φ){var r=smallRadius?radius:π-radius,code=0;return λ<-r?code|=1:λ>r&&(code|=2),φ<-r?code|=4:φ>r&&(code|=8),code}}function d3_geom_clipLine(x0,y0,x1,y1){return function(line){var r,a=line.a,b=line.b,ax=a.x,ay=a.y,t0=0,t1=1,dx=b.x-ax,dy=b.y-ay;if(r=x0-ax,dx||!(r>0)){if(r/=dx,dx<0){if(r<t0)return;r<t1&&(t1=r)}else if(dx>0){if(r>t1)return;r>t0&&(t0=r)}if(r=x1-ax,dx||!(r<0)){if(r/=dx,dx<0){if(r>t1)return;r>t0&&(t0=r)}else if(dx>0){if(r<t0)return;r<t1&&(t1=r)}if(r=y0-ay,dy||!(r>0)){if(r/=dy,dy<0){if(r<t0)return;r<t1&&(t1=r)}else if(dy>0){if(r>t1)return;r>t0&&(t0=r)}if(r=y1-ay,dy||!(r<0)){if(r/=dy,dy<0){if(r>t1)return;r>t0&&(t0=r)}else if(dy>0){if(r<t0)return;r<t1&&(t1=r)}return t0>0&&(line.a={x:ax+t0*dx,y:ay+t0*dy}),t1<1&&(line.b={x:ax+t1*dx,y:ay+t1*dy}),line}}}}}}function d3_geo_clipExtent(x0,y0,x1,y1){return function(listener){var segments,polygon,ring,x__,y__,v__,x_,y_,v_,first,clean,listener_=listener,bufferListener=d3_geo_clipBufferListener(),clipLine=d3_geom_clipLine(x0,y0,x1,y1),clip={point:point,lineStart:function(){clip.point=linePoint,polygon&&polygon.push(ring=[]);first=!0,v_=!1,x_=y_=NaN},lineEnd:function(){segments&&(linePoint(x__,y__),v__&&v_&&bufferListener.rejoin(),segments.push(bufferListener.buffer()));clip.point=point,v_&&listener.lineEnd()},polygonStart:function(){listener=bufferListener,segments=[],polygon=[],clean=!0},polygonEnd:function(){listener=listener_,segments=d3.merge(segments);var clipStartInside=function(p){for(var wn=0,n=polygon.length,y=p[1],i=0;i<n;++i)for(var b,j=1,v=polygon[i],m=v.length,a=v[0];j<m;++j)b=v[j],a[1]<=y?b[1]>y&&d3_cross2d(a,b,p)>0&&++wn:b[1]<=y&&d3_cross2d(a,b,p)<0&&--wn,a=b;return 0!==wn}([x0,y1]),inside=clean&&clipStartInside,visible=segments.length;(inside||visible)&&(listener.polygonStart(),inside&&(listener.lineStart(),interpolate(null,null,1,listener),listener.lineEnd()),visible&&d3_geo_clipPolygon(segments,compare,clipStartInside,interpolate,listener),listener.polygonEnd()),segments=polygon=ring=null}};function interpolate(from,to,direction,listener){var a=0,a1=0;if(null==from||(a=corner(from,direction))!==(a1=corner(to,direction))||comparePoints(from,to)<0^direction>0)do{listener.point(0===a||3===a?x0:x1,a>1?y1:y0)}while((a=(a+direction+4)%4)!==a1);else listener.point(to[0],to[1])}function pointVisible(x,y){return x0<=x&&x<=x1&&y0<=y&&y<=y1}function point(x,y){pointVisible(x,y)&&listener.point(x,y)}function linePoint(x,y){var v=pointVisible(x=Math.max(-1e9,Math.min(1e9,x)),y=Math.max(-1e9,Math.min(1e9,y)));if(polygon&&ring.push([x,y]),first)x__=x,y__=y,v__=v,first=!1,v&&(listener.lineStart(),listener.point(x,y));else if(v&&v_)listener.point(x,y);else{var l={a:{x:x_,y:y_},b:{x:x,y:y}};clipLine(l)?(v_||(listener.lineStart(),listener.point(l.a.x,l.a.y)),listener.point(l.b.x,l.b.y),v||listener.lineEnd(),clean=!1):v&&(listener.lineStart(),listener.point(x,y),clean=!1)}x_=x,y_=y,v_=v}return clip};function corner(p,direction){return abs(p[0]-x0)<ε?direction>0?0:3:abs(p[0]-x1)<ε?direction>0?2:1:abs(p[1]-y0)<ε?direction>0?1:0:direction>0?3:2}function compare(a,b){return comparePoints(a.x,b.x)}function comparePoints(a,b){var ca=corner(a,1),cb=corner(b,1);return ca!==cb?ca-cb:0===ca?b[1]-a[1]:1===ca?a[0]-b[0]:2===ca?a[1]-b[1]:b[0]-a[0]}}function d3_geo_conic(projectAt){var φ0=0,φ1=π/3,m=d3_geo_projectionMutator(projectAt),p=m(φ0,φ1);return p.parallels=function(_){return arguments.length?m(φ0=_[0]*π/180,φ1=_[1]*π/180):[φ0/π*180,φ1/π*180]},p}function d3_geo_conicEqualArea(φ0,φ1){var sinφ0=Math.sin(φ0),n=(sinφ0+Math.sin(φ1))/2,C=1+sinφ0*(2*n-sinφ0),ρ0=Math.sqrt(C)/n;function forward(λ,φ){var ρ=Math.sqrt(C-2*n*Math.sin(φ))/n;return[ρ*Math.sin(λ*=n),ρ0-ρ*Math.cos(λ)]}return forward.invert=function(x,y){var ρ0_y=ρ0-y;return[Math.atan2(x,ρ0_y)/n,d3_asin((C-(x*x+ρ0_y*ρ0_y)*n*n)/(2*n))]},forward}d3.geo.clipExtent=function(){var x0,y0,x1,y1,stream,clip,clipExtent={stream:function(output){return stream&&(stream.valid=!1),(stream=clip(output)).valid=!0,stream},extent:function(_){return arguments.length?(clip=d3_geo_clipExtent(x0=+_[0][0],y0=+_[0][1],x1=+_[1][0],y1=+_[1][1]),stream&&(stream.valid=!1,stream=null),clipExtent):[[x0,y0],[x1,y1]]}};return clipExtent.extent([[0,0],[960,500]])},(d3.geo.conicEqualArea=function(){return d3_geo_conic(d3_geo_conicEqualArea)}).raw=d3_geo_conicEqualArea,d3.geo.albers=function(){return d3.geo.conicEqualArea().rotate([96,0]).center([-.6,38.7]).parallels([29.5,45.5]).scale(1070)},d3.geo.albersUsa=function(){var point,lower48Point,alaskaPoint,hawaiiPoint,lower48=d3.geo.albers(),alaska=d3.geo.conicEqualArea().rotate([154,0]).center([-2,58.5]).parallels([55,65]),hawaii=d3.geo.conicEqualArea().rotate([157,0]).center([-3,19.9]).parallels([8,18]),pointStream={point:function(x,y){point=[x,y]}};function albersUsa(coordinates){var x=coordinates[0],y=coordinates[1];return point=null,lower48Point(x,y),point||(alaskaPoint(x,y),point)||hawaiiPoint(x,y),point}return albersUsa.invert=function(coordinates){var k=lower48.scale(),t=lower48.translate(),x=(coordinates[0]-t[0])/k,y=(coordinates[1]-t[1])/k;return(y>=.12&&y<.234&&x>=-.425&&x<-.214?alaska:y>=.166&&y<.234&&x>=-.214&&x<-.115?hawaii:lower48).invert(coordinates)},albersUsa.stream=function(stream){var lower48Stream=lower48.stream(stream),alaskaStream=alaska.stream(stream),hawaiiStream=hawaii.stream(stream);return{point:function(x,y){lower48Stream.point(x,y),alaskaStream.point(x,y),hawaiiStream.point(x,y)},sphere:function(){lower48Stream.sphere(),alaskaStream.sphere(),hawaiiStream.sphere()},lineStart:function(){lower48Stream.lineStart(),alaskaStream.lineStart(),hawaiiStream.lineStart()},lineEnd:function(){lower48Stream.lineEnd(),alaskaStream.lineEnd(),hawaiiStream.lineEnd()},polygonStart:function(){lower48Stream.polygonStart(),alaskaStream.polygonStart(),hawaiiStream.polygonStart()},polygonEnd:function(){lower48Stream.polygonEnd(),alaskaStream.polygonEnd(),hawaiiStream.polygonEnd()}}},albersUsa.precision=function(_){return arguments.length?(lower48.precision(_),alaska.precision(_),hawaii.precision(_),albersUsa):lower48.precision()},albersUsa.scale=function(_){return arguments.length?(lower48.scale(_),alaska.scale(.35*_),hawaii.scale(_),albersUsa.translate(lower48.translate())):lower48.scale()},albersUsa.translate=function(_){if(!arguments.length)return lower48.translate();var k=lower48.scale(),x=+_[0],y=+_[1];return lower48Point=lower48.translate(_).clipExtent([[x-.455*k,y-.238*k],[x+.455*k,y+.238*k]]).stream(pointStream).point,alaskaPoint=alaska.translate([x-.307*k,y+.201*k]).clipExtent([[x-.425*k+ε,y+.12*k+ε],[x-.214*k-ε,y+.234*k-ε]]).stream(pointStream).point,hawaiiPoint=hawaii.translate([x-.205*k,y+.212*k]).clipExtent([[x-.214*k+ε,y+.166*k+ε],[x-.115*k-ε,y+.234*k-ε]]).stream(pointStream).point,albersUsa},albersUsa.scale(1070)};var d3_geo_pathAreaSum,d3_geo_pathAreaPolygon,d3_geo_pathBoundsX0,d3_geo_pathBoundsY0,d3_geo_pathBoundsX1,d3_geo_pathBoundsY1,d3_geo_pathArea={point:d3_noop,lineStart:d3_noop,lineEnd:d3_noop,polygonStart:function(){d3_geo_pathAreaPolygon=0,d3_geo_pathArea.lineStart=d3_geo_pathAreaRingStart},polygonEnd:function(){d3_geo_pathArea.lineStart=d3_geo_pathArea.lineEnd=d3_geo_pathArea.point=d3_noop,d3_geo_pathAreaSum+=abs(d3_geo_pathAreaPolygon/2)}};function d3_geo_pathAreaRingStart(){var x00,y00,x0,y0;function nextPoint(x,y){d3_geo_pathAreaPolygon+=y0*x-x0*y,x0=x,y0=y}d3_geo_pathArea.point=function(x,y){d3_geo_pathArea.point=nextPoint,x00=x0=x,y00=y0=y},d3_geo_pathArea.lineEnd=function(){nextPoint(x00,y00)}}var d3_geo_pathBounds={point:function(x,y){x<d3_geo_pathBoundsX0&&(d3_geo_pathBoundsX0=x);x>d3_geo_pathBoundsX1&&(d3_geo_pathBoundsX1=x);y<d3_geo_pathBoundsY0&&(d3_geo_pathBoundsY0=y);y>d3_geo_pathBoundsY1&&(d3_geo_pathBoundsY1=y)},lineStart:d3_noop,lineEnd:d3_noop,polygonStart:d3_noop,polygonEnd:d3_noop};function d3_geo_pathBuffer(){var pointCircle=d3_geo_pathBufferCircle(4.5),buffer=[],stream={point:point,lineStart:function(){stream.point=pointLineStart},lineEnd:lineEnd,polygonStart:function(){stream.lineEnd=lineEndPolygon},polygonEnd:function(){stream.lineEnd=lineEnd,stream.point=point},pointRadius:function(_){return pointCircle=d3_geo_pathBufferCircle(_),stream},result:function(){if(buffer.length){var result=buffer.join("");return buffer=[],result}}};function point(x,y){buffer.push("M",x,",",y,pointCircle)}function pointLineStart(x,y){buffer.push("M",x,",",y),stream.point=pointLine}function pointLine(x,y){buffer.push("L",x,",",y)}function lineEnd(){stream.point=point}function lineEndPolygon(){buffer.push("Z")}return stream}function d3_geo_pathBufferCircle(radius){return"m0,"+radius+"a"+radius+","+radius+" 0 1,1 0,"+-2*radius+"a"+radius+","+radius+" 0 1,1 0,"+2*radius+"z"}var d3_geo_lengthSum,d3_geo_pathCentroid={point:d3_geo_pathCentroidPoint,lineStart:d3_geo_pathCentroidLineStart,lineEnd:d3_geo_pathCentroidLineEnd,polygonStart:function(){d3_geo_pathCentroid.lineStart=d3_geo_pathCentroidRingStart},polygonEnd:function(){d3_geo_pathCentroid.point=d3_geo_pathCentroidPoint,d3_geo_pathCentroid.lineStart=d3_geo_pathCentroidLineStart,d3_geo_pathCentroid.lineEnd=d3_geo_pathCentroidLineEnd}};function d3_geo_pathCentroidPoint(x,y){d3_geo_centroidX0+=x,d3_geo_centroidY0+=y,++d3_geo_centroidZ0}function d3_geo_pathCentroidLineStart(){var x0,y0;function nextPoint(x,y){var dx=x-x0,dy=y-y0,z=Math.sqrt(dx*dx+dy*dy);d3_geo_centroidX1+=z*(x0+x)/2,d3_geo_centroidY1+=z*(y0+y)/2,d3_geo_centroidZ1+=z,d3_geo_pathCentroidPoint(x0=x,y0=y)}d3_geo_pathCentroid.point=function(x,y){d3_geo_pathCentroid.point=nextPoint,d3_geo_pathCentroidPoint(x0=x,y0=y)}}function d3_geo_pathCentroidLineEnd(){d3_geo_pathCentroid.point=d3_geo_pathCentroidPoint}function d3_geo_pathCentroidRingStart(){var x00,y00,x0,y0;function nextPoint(x,y){var dx=x-x0,dy=y-y0,z=Math.sqrt(dx*dx+dy*dy);d3_geo_centroidX1+=z*(x0+x)/2,d3_geo_centroidY1+=z*(y0+y)/2,d3_geo_centroidZ1+=z,d3_geo_centroidX2+=(z=y0*x-x0*y)*(x0+x),d3_geo_centroidY2+=z*(y0+y),d3_geo_centroidZ2+=3*z,d3_geo_pathCentroidPoint(x0=x,y0=y)}d3_geo_pathCentroid.point=function(x,y){d3_geo_pathCentroid.point=nextPoint,d3_geo_pathCentroidPoint(x00=x0=x,y00=y0=y)},d3_geo_pathCentroid.lineEnd=function(){nextPoint(x00,y00)}}function d3_geo_pathContext(context){var pointRadius=4.5,stream={point:point,lineStart:function(){stream.point=pointLineStart},lineEnd:lineEnd,polygonStart:function(){stream.lineEnd=lineEndPolygon},polygonEnd:function(){stream.lineEnd=lineEnd,stream.point=point},pointRadius:function(_){return pointRadius=_,stream},result:d3_noop};function point(x,y){context.moveTo(x+pointRadius,y),context.arc(x,y,pointRadius,0,τ)}function pointLineStart(x,y){context.moveTo(x,y),stream.point=pointLine}function pointLine(x,y){context.lineTo(x,y)}function lineEnd(){stream.point=point}function lineEndPolygon(){context.closePath()}return stream}function d3_geo_resample(project){var δ2=.5,cosMinDistance=Math.cos(30*d3_radians),maxDepth=16;function resample(stream){return(maxDepth?resampleRecursive:resampleNone)(stream)}function resampleNone(stream){return d3_geo_transformPoint(stream,(function(x,y){x=project(x,y),stream.point(x[0],x[1])}))}function resampleRecursive(stream){var λ00,x00,y00,a00,b00,c00,λ0,x0,y0,a0,b0,c0,resample={point:point,lineStart:lineStart,lineEnd:lineEnd,polygonStart:function(){stream.polygonStart(),resample.lineStart=ringStart},polygonEnd:function(){stream.polygonEnd(),resample.lineStart=lineStart}};function point(x,y){x=project(x,y),stream.point(x[0],x[1])}function lineStart(){x0=NaN,resample.point=linePoint,stream.lineStart()}function linePoint(λ,φ){var c=d3_geo_cartesian([λ,φ]),p=project(λ,φ);resampleLineTo(x0,y0,λ0,a0,b0,c0,x0=p[0],y0=p[1],λ0=λ,a0=c[0],b0=c[1],c0=c[2],maxDepth,stream),stream.point(x0,y0)}function lineEnd(){resample.point=point,stream.lineEnd()}function ringStart(){lineStart(),resample.point=ringPoint,resample.lineEnd=ringEnd}function ringPoint(λ,φ){linePoint(λ00=λ,φ),x00=x0,y00=y0,a00=a0,b00=b0,c00=c0,resample.point=linePoint}function ringEnd(){resampleLineTo(x0,y0,λ0,a0,b0,c0,x00,y00,λ00,a00,b00,c00,maxDepth,stream),resample.lineEnd=lineEnd,lineEnd()}return resample}function resampleLineTo(x0,y0,λ0,a0,b0,c0,x1,y1,λ1,a1,b1,c1,depth,stream){var dx=x1-x0,dy=y1-y0,d2=dx*dx+dy*dy;if(d2>4*δ2&&depth--){var a=a0+a1,b=b0+b1,c=c0+c1,m=Math.sqrt(a*a+b*b+c*c),φ2=Math.asin(c/=m),λ2=abs(abs(c)-1)<ε||abs(λ0-λ1)<ε?(λ0+λ1)/2:Math.atan2(b,a),p=project(λ2,φ2),x2=p[0],y2=p[1],dx2=x2-x0,dy2=y2-y0,dz=dy*dx2-dx*dy2;(dz*dz/d2>δ2||abs((dx*dx2+dy*dy2)/d2-.5)>.3||a0*a1+b0*b1+c0*c1<cosMinDistance)&&(resampleLineTo(x0,y0,λ0,a0,b0,c0,x2,y2,λ2,a/=m,b/=m,c,depth,stream),stream.point(x2,y2),resampleLineTo(x2,y2,λ2,a,b,c,x1,y1,λ1,a1,b1,c1,depth,stream))}}return resample.precision=function(_){return arguments.length?(maxDepth=(δ2=_*_)>0&&16,resample):Math.sqrt(δ2)},resample}function d3_geo_pathProjectStream(project){var resample=d3_geo_resample((function(x,y){return project([x*d3_degrees,y*d3_degrees])}));return function(stream){return d3_geo_projectionRadians(resample(stream))}}function d3_geo_transform(stream){this.stream=stream}function d3_geo_transformPoint(stream,point){return{point:point,sphere:function(){stream.sphere()},lineStart:function(){stream.lineStart()},lineEnd:function(){stream.lineEnd()},polygonStart:function(){stream.polygonStart()},polygonEnd:function(){stream.polygonEnd()}}}function d3_geo_projection(project){return d3_geo_projectionMutator((function(){return project}))()}function d3_geo_projectionMutator(projectAt){var project,rotate,projectRotate,δx,δy,stream,projectResample=d3_geo_resample((function(x,y){return[(x=project(x,y))[0]*k+δx,δy-x[1]*k]})),k=150,x=480,y=250,λ=0,φ=0,δλ=0,δφ=0,δγ=0,preclip=d3_geo_clipAntimeridian,postclip=d3_identity,clipAngle=null,clipExtent=null;function projection(point){return[(point=projectRotate(point[0]*d3_radians,point[1]*d3_radians))[0]*k+δx,δy-point[1]*k]}function invert(point){return(point=projectRotate.invert((point[0]-δx)/k,(δy-point[1])/k))&&[point[0]*d3_degrees,point[1]*d3_degrees]}function reset(){projectRotate=d3_geo_compose(rotate=d3_geo_rotation(δλ,δφ,δγ),project);var center=project(λ,φ);return δx=x-center[0]*k,δy=y+center[1]*k,invalidate()}function invalidate(){return stream&&(stream.valid=!1,stream=null),projection}return projection.stream=function(output){return stream&&(stream.valid=!1),(stream=d3_geo_projectionRadians(preclip(rotate,projectResample(postclip(output))))).valid=!0,stream},projection.clipAngle=function(_){return arguments.length?(preclip=null==_?(clipAngle=_,d3_geo_clipAntimeridian):d3_geo_clipCircle((clipAngle=+_)*d3_radians),invalidate()):clipAngle},projection.clipExtent=function(_){return arguments.length?(clipExtent=_,postclip=_?d3_geo_clipExtent(_[0][0],_[0][1],_[1][0],_[1][1]):d3_identity,invalidate()):clipExtent},projection.scale=function(_){return arguments.length?(k=+_,reset()):k},projection.translate=function(_){return arguments.length?(x=+_[0],y=+_[1],reset()):[x,y]},projection.center=function(_){return arguments.length?(λ=_[0]%360*d3_radians,φ=_[1]%360*d3_radians,reset()):[λ*d3_degrees,φ*d3_degrees]},projection.rotate=function(_){return arguments.length?(δλ=_[0]%360*d3_radians,δφ=_[1]%360*d3_radians,δγ=_.length>2?_[2]%360*d3_radians:0,reset()):[δλ*d3_degrees,δφ*d3_degrees,δγ*d3_degrees]},d3.rebind(projection,projectResample,"precision"),function(){return project=projectAt.apply(this,arguments),projection.invert=project.invert&&invert,reset()}}function d3_geo_projectionRadians(stream){return d3_geo_transformPoint(stream,(function(x,y){stream.point(x*d3_radians,y*d3_radians)}))}function d3_geo_equirectangular(λ,φ){return[λ,φ]}function d3_geo_identityRotation(λ,φ){return[λ>π?λ-τ:λ<-π?λ+τ:λ,φ]}function d3_geo_rotation(δλ,δφ,δγ){return δλ?δφ||δγ?d3_geo_compose(d3_geo_rotationλ(δλ),d3_geo_rotationφγ(δφ,δγ)):d3_geo_rotationλ(δλ):δφ||δγ?d3_geo_rotationφγ(δφ,δγ):d3_geo_identityRotation}function d3_geo_forwardRotationλ(δλ){return function(λ,φ){return[(λ+=δλ)>π?λ-τ:λ<-π?λ+τ:λ,φ]}}function d3_geo_rotationλ(δλ){var rotation=d3_geo_forwardRotationλ(δλ);return rotation.invert=d3_geo_forwardRotationλ(-δλ),rotation}function d3_geo_rotationφγ(δφ,δγ){var cosδφ=Math.cos(δφ),sinδφ=Math.sin(δφ),cosδγ=Math.cos(δγ),sinδγ=Math.sin(δγ);function rotation(λ,φ){var cosφ=Math.cos(φ),x=Math.cos(λ)*cosφ,y=Math.sin(λ)*cosφ,z=Math.sin(φ),k=z*cosδφ+x*sinδφ;return[Math.atan2(y*cosδγ-k*sinδγ,x*cosδφ-z*sinδφ),d3_asin(k*cosδγ+y*sinδγ)]}return rotation.invert=function(λ,φ){var cosφ=Math.cos(φ),x=Math.cos(λ)*cosφ,y=Math.sin(λ)*cosφ,z=Math.sin(φ),k=z*cosδγ-y*sinδγ;return[Math.atan2(y*cosδγ+z*sinδγ,x*cosδφ+k*sinδφ),d3_asin(k*cosδφ-x*sinδφ)]},rotation}function d3_geo_circleInterpolate(radius,precision){var cr=Math.cos(radius),sr=Math.sin(radius);return function(from,to,direction,listener){var step=direction*precision;null!=from?(from=d3_geo_circleAngle(cr,from),to=d3_geo_circleAngle(cr,to),(direction>0?from<to:from>to)&&(from+=direction*τ)):(from=radius+direction*τ,to=radius-.5*step);for(var point,t=from;direction>0?t>to:t<to;t-=step)listener.point((point=d3_geo_spherical([cr,-sr*Math.cos(t),-sr*Math.sin(t)]))[0],point[1])}}function d3_geo_circleAngle(cr,point){var a=d3_geo_cartesian(point);a[0]-=cr,d3_geo_cartesianNormalize(a);var angle=d3_acos(-a[1]);return((-a[2]<0?-angle:angle)+2*Math.PI-ε)%(2*Math.PI)}function d3_geo_graticuleX(y0,y1,dy){var y=d3.range(y0,y1-ε,dy).concat(y1);return function(x){return y.map((function(y){return[x,y]}))}}function d3_geo_graticuleY(x0,x1,dx){var x=d3.range(x0,x1-ε,dx).concat(x1);return function(y){return x.map((function(x){return[x,y]}))}}function d3_source(d){return d.source}function d3_target(d){return d.target}d3.geo.path=function(){var projection,context,projectStream,contextStream,cacheStream,pointRadius=4.5;function path(object){return object&&("function"==typeof pointRadius&&contextStream.pointRadius(+pointRadius.apply(this,arguments)),cacheStream&&cacheStream.valid||(cacheStream=projectStream(contextStream)),d3.geo.stream(object,cacheStream)),contextStream.result()}function reset(){return cacheStream=null,path}return path.area=function(object){return d3_geo_pathAreaSum=0,d3.geo.stream(object,projectStream(d3_geo_pathArea)),d3_geo_pathAreaSum},path.centroid=function(object){return d3_geo_centroidX0=d3_geo_centroidY0=d3_geo_centroidZ0=d3_geo_centroidX1=d3_geo_centroidY1=d3_geo_centroidZ1=d3_geo_centroidX2=d3_geo_centroidY2=d3_geo_centroidZ2=0,d3.geo.stream(object,projectStream(d3_geo_pathCentroid)),d3_geo_centroidZ2?[d3_geo_centroidX2/d3_geo_centroidZ2,d3_geo_centroidY2/d3_geo_centroidZ2]:d3_geo_centroidZ1?[d3_geo_centroidX1/d3_geo_centroidZ1,d3_geo_centroidY1/d3_geo_centroidZ1]:d3_geo_centroidZ0?[d3_geo_centroidX0/d3_geo_centroidZ0,d3_geo_centroidY0/d3_geo_centroidZ0]:[NaN,NaN]},path.bounds=function(object){return d3_geo_pathBoundsX1=d3_geo_pathBoundsY1=-(d3_geo_pathBoundsX0=d3_geo_pathBoundsY0=1/0),d3.geo.stream(object,projectStream(d3_geo_pathBounds)),[[d3_geo_pathBoundsX0,d3_geo_pathBoundsY0],[d3_geo_pathBoundsX1,d3_geo_pathBoundsY1]]},path.projection=function(_){return arguments.length?(projectStream=(projection=_)?_.stream||d3_geo_pathProjectStream(_):d3_identity,reset()):projection},path.context=function(_){return arguments.length?(contextStream=null==(context=_)?new d3_geo_pathBuffer:new d3_geo_pathContext(_),"function"!=typeof pointRadius&&contextStream.pointRadius(pointRadius),reset()):context},path.pointRadius=function(_){return arguments.length?(pointRadius="function"==typeof _?_:(contextStream.pointRadius(+_),+_),path):pointRadius},path.projection(d3.geo.albersUsa()).context(null)},d3.geo.transform=function(methods){return{stream:function(stream){var transform=new d3_geo_transform(stream);for(var k in methods)transform[k]=methods[k];return transform}}},d3_geo_transform.prototype={point:function(x,y){this.stream.point(x,y)},sphere:function(){this.stream.sphere()},lineStart:function(){this.stream.lineStart()},lineEnd:function(){this.stream.lineEnd()},polygonStart:function(){this.stream.polygonStart()},polygonEnd:function(){this.stream.polygonEnd()}},d3.geo.projection=d3_geo_projection,d3.geo.projectionMutator=d3_geo_projectionMutator,(d3.geo.equirectangular=function(){return d3_geo_projection(d3_geo_equirectangular)}).raw=d3_geo_equirectangular.invert=d3_geo_equirectangular,d3.geo.rotation=function(rotate){function forward(coordinates){return(coordinates=rotate(coordinates[0]*d3_radians,coordinates[1]*d3_radians))[0]*=d3_degrees,coordinates[1]*=d3_degrees,coordinates}return rotate=d3_geo_rotation(rotate[0]%360*d3_radians,rotate[1]*d3_radians,rotate.length>2?rotate[2]*d3_radians:0),forward.invert=function(coordinates){return(coordinates=rotate.invert(coordinates[0]*d3_radians,coordinates[1]*d3_radians))[0]*=d3_degrees,coordinates[1]*=d3_degrees,coordinates},forward},d3_geo_identityRotation.invert=d3_geo_equirectangular,d3.geo.circle=function(){var angle,interpolate,origin=[0,0],precision=6;function circle(){var center="function"==typeof origin?origin.apply(this,arguments):origin,rotate=d3_geo_rotation(-center[0]*d3_radians,-center[1]*d3_radians,0).invert,ring=[];return interpolate(null,null,1,{point:function(x,y){ring.push(x=rotate(x,y)),x[0]*=d3_degrees,x[1]*=d3_degrees}}),{type:"Polygon",coordinates:[ring]}}return circle.origin=function(x){return arguments.length?(origin=x,circle):origin},circle.angle=function(x){return arguments.length?(interpolate=d3_geo_circleInterpolate((angle=+x)*d3_radians,precision*d3_radians),circle):angle},circle.precision=function(_){return arguments.length?(interpolate=d3_geo_circleInterpolate(angle*d3_radians,(precision=+_)*d3_radians),circle):precision},circle.angle(90)},d3.geo.distance=function(a,b){var t,Δλ=(b[0]-a[0])*d3_radians,φ0=a[1]*d3_radians,φ1=b[1]*d3_radians,sinΔλ=Math.sin(Δλ),cosΔλ=Math.cos(Δλ),sinφ0=Math.sin(φ0),cosφ0=Math.cos(φ0),sinφ1=Math.sin(φ1),cosφ1=Math.cos(φ1);return Math.atan2(Math.sqrt((t=cosφ1*sinΔλ)*t+(t=cosφ0*sinφ1-sinφ0*cosφ1*cosΔλ)*t),sinφ0*sinφ1+cosφ0*cosφ1*cosΔλ)},d3.geo.graticule=function(){var x1,x0,X1,X0,y1,y0,Y1,Y0,x,y,X,Y,dx=10,dy=dx,DX=90,DY=360,precision=2.5;function graticule(){return{type:"MultiLineString",coordinates:lines()}}function lines(){return d3.range(Math.ceil(X0/DX)*DX,X1,DX).map(X).concat(d3.range(Math.ceil(Y0/DY)*DY,Y1,DY).map(Y)).concat(d3.range(Math.ceil(x0/dx)*dx,x1,dx).filter((function(x){return abs(x%DX)>ε})).map(x)).concat(d3.range(Math.ceil(y0/dy)*dy,y1,dy).filter((function(y){return abs(y%DY)>ε})).map(y))}return graticule.lines=function(){return lines().map((function(coordinates){return{type:"LineString",coordinates:coordinates}}))},graticule.outline=function(){return{type:"Polygon",coordinates:[X(X0).concat(Y(Y1).slice(1),X(X1).reverse().slice(1),Y(Y0).reverse().slice(1))]}},graticule.extent=function(_){return arguments.length?graticule.majorExtent(_).minorExtent(_):graticule.minorExtent()},graticule.majorExtent=function(_){return arguments.length?(X0=+_[0][0],X1=+_[1][0],Y0=+_[0][1],Y1=+_[1][1],X0>X1&&(_=X0,X0=X1,X1=_),Y0>Y1&&(_=Y0,Y0=Y1,Y1=_),graticule.precision(precision)):[[X0,Y0],[X1,Y1]]},graticule.minorExtent=function(_){return arguments.length?(x0=+_[0][0],x1=+_[1][0],y0=+_[0][1],y1=+_[1][1],x0>x1&&(_=x0,x0=x1,x1=_),y0>y1&&(_=y0,y0=y1,y1=_),graticule.precision(precision)):[[x0,y0],[x1,y1]]},graticule.step=function(_){return arguments.length?graticule.majorStep(_).minorStep(_):graticule.minorStep()},graticule.majorStep=function(_){return arguments.length?(DX=+_[0],DY=+_[1],graticule):[DX,DY]},graticule.minorStep=function(_){return arguments.length?(dx=+_[0],dy=+_[1],graticule):[dx,dy]},graticule.precision=function(_){return arguments.length?(precision=+_,x=d3_geo_graticuleX(y0,y1,90),y=d3_geo_graticuleY(x0,x1,precision),X=d3_geo_graticuleX(Y0,Y1,90),Y=d3_geo_graticuleY(X0,X1,precision),graticule):precision},graticule.majorExtent([[-180,-90+ε],[180,90-ε]]).minorExtent([[-180,-80-ε],[180,80+ε]])},d3.geo.greatArc=function(){var source_,target_,source=d3_source,target=d3_target;function greatArc(){return{type:"LineString",coordinates:[source_||source.apply(this,arguments),target_||target.apply(this,arguments)]}}return greatArc.distance=function(){return d3.geo.distance(source_||source.apply(this,arguments),target_||target.apply(this,arguments))},greatArc.source=function(_){return arguments.length?(source=_,source_="function"==typeof _?null:_,greatArc):source},greatArc.target=function(_){return arguments.length?(target=_,target_="function"==typeof _?null:_,greatArc):target},greatArc.precision=function(){return arguments.length?greatArc:0},greatArc},d3.geo.interpolate=function(source,target){return x0=source[0]*d3_radians,y0=source[1]*d3_radians,x1=target[0]*d3_radians,y1=target[1]*d3_radians,cy0=Math.cos(y0),sy0=Math.sin(y0),cy1=Math.cos(y1),sy1=Math.sin(y1),kx0=cy0*Math.cos(x0),ky0=cy0*Math.sin(x0),kx1=cy1*Math.cos(x1),ky1=cy1*Math.sin(x1),d=2*Math.asin(Math.sqrt(d3_haversin(y1-y0)+cy0*cy1*d3_haversin(x1-x0))),k=1/Math.sin(d),(interpolate=d?function(t){var B=Math.sin(t*=d)*k,A=Math.sin(d-t)*k,x=A*kx0+B*kx1,y=A*ky0+B*ky1,z=A*sy0+B*sy1;return[Math.atan2(y,x)*d3_degrees,Math.atan2(z,Math.sqrt(x*x+y*y))*d3_degrees]}:function(){return[x0*d3_degrees,y0*d3_degrees]}).distance=d,interpolate;var x0,y0,x1,y1,cy0,sy0,cy1,sy1,kx0,ky0,kx1,ky1,d,k,interpolate},d3.geo.length=function(object){return d3_geo_lengthSum=0,d3.geo.stream(object,d3_geo_length),d3_geo_lengthSum};var d3_geo_length={sphere:d3_noop,point:d3_noop,lineStart:function(){var λ0,sinφ0,cosφ0;function nextPoint(λ,φ){var sinφ=Math.sin(φ*=d3_radians),cosφ=Math.cos(φ),t=abs((λ*=d3_radians)-λ0),cosΔλ=Math.cos(t);d3_geo_lengthSum+=Math.atan2(Math.sqrt((t=cosφ*Math.sin(t))*t+(t=cosφ0*sinφ-sinφ0*cosφ*cosΔλ)*t),sinφ0*sinφ+cosφ0*cosφ*cosΔλ),λ0=λ,sinφ0=sinφ,cosφ0=cosφ}d3_geo_length.point=function(λ,φ){λ0=λ*d3_radians,sinφ0=Math.sin(φ*=d3_radians),cosφ0=Math.cos(φ),d3_geo_length.point=nextPoint},d3_geo_length.lineEnd=function(){d3_geo_length.point=d3_geo_length.lineEnd=d3_noop}},lineEnd:d3_noop,polygonStart:d3_noop,polygonEnd:d3_noop};function d3_geo_azimuthal(scale,angle){function azimuthal(λ,φ){var cosλ=Math.cos(λ),cosφ=Math.cos(φ),k=scale(cosλ*cosφ);return[k*cosφ*Math.sin(λ),k*Math.sin(φ)]}return azimuthal.invert=function(x,y){var ρ=Math.sqrt(x*x+y*y),c=angle(ρ),sinc=Math.sin(c),cosc=Math.cos(c);return[Math.atan2(x*sinc,ρ*cosc),Math.asin(ρ&&y*sinc/ρ)]},azimuthal}var d3_geo_azimuthalEqualArea=d3_geo_azimuthal((function(cosλcosφ){return Math.sqrt(2/(1+cosλcosφ))}),(function(ρ){return 2*Math.asin(ρ/2)}));(d3.geo.azimuthalEqualArea=function(){return d3_geo_projection(d3_geo_azimuthalEqualArea)}).raw=d3_geo_azimuthalEqualArea;var d3_geo_azimuthalEquidistant=d3_geo_azimuthal((function(cosλcosφ){var c=Math.acos(cosλcosφ);return c&&c/Math.sin(c)}),d3_identity);function d3_geo_conicConformal(φ0,φ1){var cosφ0=Math.cos(φ0),t=function(φ){return Math.tan(π/4+φ/2)},n=φ0===φ1?Math.sin(φ0):Math.log(cosφ0/Math.cos(φ1))/Math.log(t(φ1)/t(φ0)),F=cosφ0*Math.pow(t(φ0),n)/n;if(!n)return d3_geo_mercator;function forward(λ,φ){F>0?φ<-halfπ+ε&&(φ=-halfπ+ε):φ>halfπ-ε&&(φ=halfπ-ε);var ρ=F/Math.pow(t(φ),n);return[ρ*Math.sin(n*λ),F-ρ*Math.cos(n*λ)]}return forward.invert=function(x,y){var ρ0_y=F-y,ρ=d3_sgn(n)*Math.sqrt(x*x+ρ0_y*ρ0_y);return[Math.atan2(x,ρ0_y)/n,2*Math.atan(Math.pow(F/ρ,1/n))-halfπ]},forward}function d3_geo_conicEquidistant(φ0,φ1){var cosφ0=Math.cos(φ0),n=φ0===φ1?Math.sin(φ0):(cosφ0-Math.cos(φ1))/(φ1-φ0),G=cosφ0/n+φ0;if(abs(n)<ε)return d3_geo_equirectangular;function forward(λ,φ){var ρ=G-φ;return[ρ*Math.sin(n*λ),G-ρ*Math.cos(n*λ)]}return forward.invert=function(x,y){var ρ0_y=G-y;return[Math.atan2(x,ρ0_y)/n,G-d3_sgn(n)*Math.sqrt(x*x+ρ0_y*ρ0_y)]},forward}(d3.geo.azimuthalEquidistant=function(){return d3_geo_projection(d3_geo_azimuthalEquidistant)}).raw=d3_geo_azimuthalEquidistant,(d3.geo.conicConformal=function(){return d3_geo_conic(d3_geo_conicConformal)}).raw=d3_geo_conicConformal,(d3.geo.conicEquidistant=function(){return d3_geo_conic(d3_geo_conicEquidistant)}).raw=d3_geo_conicEquidistant;var d3_geo_gnomonic=d3_geo_azimuthal((function(cosλcosφ){return 1/cosλcosφ}),Math.atan);function d3_geo_mercator(λ,φ){return[λ,Math.log(Math.tan(π/4+φ/2))]}function d3_geo_mercatorProjection(project){var clipAuto,m=d3_geo_projection(project),scale=m.scale,translate=m.translate,clipExtent=m.clipExtent;return m.scale=function(){var v=scale.apply(m,arguments);return v===m?clipAuto?m.clipExtent(null):m:v},m.translate=function(){var v=translate.apply(m,arguments);return v===m?clipAuto?m.clipExtent(null):m:v},m.clipExtent=function(_){var v=clipExtent.apply(m,arguments);if(v===m){if(clipAuto=null==_){var k=π*scale(),t=translate();clipExtent([[t[0]-k,t[1]-k],[t[0]+k,t[1]+k]])}}else clipAuto&&(v=null);return v},m.clipExtent(null)}(d3.geo.gnomonic=function(){return d3_geo_projection(d3_geo_gnomonic)}).raw=d3_geo_gnomonic,d3_geo_mercator.invert=function(x,y){return[x,2*Math.atan(Math.exp(y))-halfπ]},(d3.geo.mercator=function(){return d3_geo_mercatorProjection(d3_geo_mercator)}).raw=d3_geo_mercator;var d3_geo_orthographic=d3_geo_azimuthal((function(){return 1}),Math.asin);(d3.geo.orthographic=function(){return d3_geo_projection(d3_geo_orthographic)}).raw=d3_geo_orthographic;var d3_geo_stereographic=d3_geo_azimuthal((function(cosλcosφ){return 1/(1+cosλcosφ)}),(function(ρ){return 2*Math.atan(ρ)}));function d3_geo_transverseMercator(λ,φ){return[Math.log(Math.tan(π/4+φ/2)),-λ]}function d3_geom_pointX(d){return d[0]}function d3_geom_pointY(d){return d[1]}function d3_geom_hullUpper(points){for(var n=points.length,hull=[0,1],hs=2,i=2;i<n;i++){for(;hs>1&&d3_cross2d(points[hull[hs-2]],points[hull[hs-1]],points[i])<=0;)--hs;hull[hs++]=i}return hull.slice(0,hs)}function d3_geom_hullOrder(a,b){return a[0]-b[0]||a[1]-b[1]}(d3.geo.stereographic=function(){return d3_geo_projection(d3_geo_stereographic)}).raw=d3_geo_stereographic,d3_geo_transverseMercator.invert=function(x,y){return[-y,2*Math.atan(Math.exp(x))-halfπ]},(d3.geo.transverseMercator=function(){var projection=d3_geo_mercatorProjection(d3_geo_transverseMercator),center=projection.center,rotate=projection.rotate;return projection.center=function(_){return _?center([-_[1],_[0]]):[(_=center())[1],-_[0]]},projection.rotate=function(_){return _?rotate([_[0],_[1],_.length>2?_[2]+90:90]):[(_=rotate())[0],_[1],_[2]-90]},rotate([0,0,90])}).raw=d3_geo_transverseMercator,d3.geom={},d3.geom.hull=function(vertices){var x=d3_geom_pointX,y=d3_geom_pointY;if(arguments.length)return hull(vertices);function hull(data){if(data.length<3)return[];var i,fx=d3_functor(x),fy=d3_functor(y),n=data.length,points=[],flippedPoints=[];for(i=0;i<n;i++)points.push([+fx.call(this,data[i],i),+fy.call(this,data[i],i),i]);for(points.sort(d3_geom_hullOrder),i=0;i<n;i++)flippedPoints.push([points[i][0],-points[i][1]]);var upper=d3_geom_hullUpper(points),lower=d3_geom_hullUpper(flippedPoints),skipLeft=lower[0]===upper[0],skipRight=lower[lower.length-1]===upper[upper.length-1],polygon=[];for(i=upper.length-1;i>=0;--i)polygon.push(data[points[upper[i]][2]]);for(i=+skipLeft;i<lower.length-skipRight;++i)polygon.push(data[points[lower[i]][2]]);return polygon}return hull.x=function(_){return arguments.length?(x=_,hull):x},hull.y=function(_){return arguments.length?(y=_,hull):y},hull},d3.geom.polygon=function(coordinates){return d3_subclass(coordinates,d3_geom_polygonPrototype),coordinates};var d3_geom_polygonPrototype=d3.geom.polygon.prototype=[];function d3_geom_polygonInside(p,a,b){return(b[0]-a[0])*(p[1]-a[1])<(b[1]-a[1])*(p[0]-a[0])}function d3_geom_polygonIntersect(c,d,a,b){var x1=c[0],x3=a[0],x21=d[0]-x1,x43=b[0]-x3,y1=c[1],y3=a[1],y21=d[1]-y1,y43=b[1]-y3,ua=(x43*(y1-y3)-y43*(x1-x3))/(y43*x21-x43*y21);return[x1+ua*x21,y1+ua*y21]}function d3_geom_polygonClosed(coordinates){var a=coordinates[0],b=coordinates[coordinates.length-1];return!(a[0]-b[0]||a[1]-b[1])}d3_geom_polygonPrototype.area=function(){for(var a,i=-1,n=this.length,b=this[n-1],area=0;++i<n;)a=b,b=this[i],area+=a[1]*b[0]-a[0]*b[1];return.5*area},d3_geom_polygonPrototype.centroid=function(k){var a,c,i=-1,n=this.length,x=0,y=0,b=this[n-1];for(arguments.length||(k=-1/(6*this.area()));++i<n;)a=b,b=this[i],c=a[0]*b[1]-b[0]*a[1],x+=(a[0]+b[0])*c,y+=(a[1]+b[1])*c;return[x*k,y*k]},d3_geom_polygonPrototype.clip=function(subject){for(var input,j,m,b,c,d,closed=d3_geom_polygonClosed(subject),i=-1,n=this.length-d3_geom_polygonClosed(this),a=this[n-1];++i<n;){for(input=subject.slice(),subject.length=0,b=this[i],c=input[(m=input.length-closed)-1],j=-1;++j<m;)d3_geom_polygonInside(d=input[j],a,b)?(d3_geom_polygonInside(c,a,b)||subject.push(d3_geom_polygonIntersect(c,d,a,b)),subject.push(d)):d3_geom_polygonInside(c,a,b)&&subject.push(d3_geom_polygonIntersect(c,d,a,b)),c=d;closed&&subject.push(subject[0]),a=b}return subject};var d3_geom_voronoiEdges,d3_geom_voronoiCells,d3_geom_voronoiBeaches,d3_geom_voronoiFirstCircle,d3_geom_voronoiCircles,d3_geom_voronoiBeachPool=[],d3_geom_voronoiCirclePool=[];function d3_geom_voronoiBeach(){d3_geom_voronoiRedBlackNode(this),this.edge=this.site=this.circle=null}function d3_geom_voronoiCreateBeach(site){var beach=d3_geom_voronoiBeachPool.pop()||new d3_geom_voronoiBeach;return beach.site=site,beach}function d3_geom_voronoiDetachBeach(beach){d3_geom_voronoiDetachCircle(beach),d3_geom_voronoiBeaches.remove(beach),d3_geom_voronoiBeachPool.push(beach),d3_geom_voronoiRedBlackNode(beach)}function d3_geom_voronoiRemoveBeach(beach){var circle=beach.circle,x=circle.x,y=circle.cy,vertex={x:x,y:y},previous=beach.P,next=beach.N,disappearing=[beach];d3_geom_voronoiDetachBeach(beach);for(var lArc=previous;lArc.circle&&abs(x-lArc.circle.x)<ε&&abs(y-lArc.circle.cy)<ε;)previous=lArc.P,disappearing.unshift(lArc),d3_geom_voronoiDetachBeach(lArc),lArc=previous;disappearing.unshift(lArc),d3_geom_voronoiDetachCircle(lArc);for(var rArc=next;rArc.circle&&abs(x-rArc.circle.x)<ε&&abs(y-rArc.circle.cy)<ε;)next=rArc.N,disappearing.push(rArc),d3_geom_voronoiDetachBeach(rArc),rArc=next;disappearing.push(rArc),d3_geom_voronoiDetachCircle(rArc);var iArc,nArcs=disappearing.length;for(iArc=1;iArc<nArcs;++iArc)rArc=disappearing[iArc],lArc=disappearing[iArc-1],d3_geom_voronoiSetEdgeEnd(rArc.edge,lArc.site,rArc.site,vertex);lArc=disappearing[0],(rArc=disappearing[nArcs-1]).edge=d3_geom_voronoiCreateEdge(lArc.site,rArc.site,null,vertex),d3_geom_voronoiAttachCircle(lArc),d3_geom_voronoiAttachCircle(rArc)}function d3_geom_voronoiAddBeach(site){for(var lArc,rArc,dxl,dxr,x=site.x,directrix=site.y,node=d3_geom_voronoiBeaches._;node;)if((dxl=d3_geom_voronoiLeftBreakPoint(node,directrix)-x)>ε)node=node.L;else{if(!((dxr=x-d3_geom_voronoiRightBreakPoint(node,directrix))>ε)){dxl>-ε?(lArc=node.P,rArc=node):dxr>-ε?(lArc=node,rArc=node.N):lArc=rArc=node;break}if(!node.R){lArc=node;break}node=node.R}var newArc=d3_geom_voronoiCreateBeach(site);if(d3_geom_voronoiBeaches.insert(lArc,newArc),lArc||rArc){if(lArc===rArc)return d3_geom_voronoiDetachCircle(lArc),rArc=d3_geom_voronoiCreateBeach(lArc.site),d3_geom_voronoiBeaches.insert(newArc,rArc),newArc.edge=rArc.edge=d3_geom_voronoiCreateEdge(lArc.site,newArc.site),d3_geom_voronoiAttachCircle(lArc),void d3_geom_voronoiAttachCircle(rArc);if(rArc){d3_geom_voronoiDetachCircle(lArc),d3_geom_voronoiDetachCircle(rArc);var lSite=lArc.site,ax=lSite.x,ay=lSite.y,bx=site.x-ax,by=site.y-ay,rSite=rArc.site,cx=rSite.x-ax,cy=rSite.y-ay,d=2*(bx*cy-by*cx),hb=bx*bx+by*by,hc=cx*cx+cy*cy,vertex={x:(cy*hb-by*hc)/d+ax,y:(bx*hc-cx*hb)/d+ay};d3_geom_voronoiSetEdgeEnd(rArc.edge,lSite,rSite,vertex),newArc.edge=d3_geom_voronoiCreateEdge(lSite,site,null,vertex),rArc.edge=d3_geom_voronoiCreateEdge(site,rSite,null,vertex),d3_geom_voronoiAttachCircle(lArc),d3_geom_voronoiAttachCircle(rArc)}else newArc.edge=d3_geom_voronoiCreateEdge(lArc.site,newArc.site)}}function d3_geom_voronoiLeftBreakPoint(arc,directrix){var site=arc.site,rfocx=site.x,rfocy=site.y,pby2=rfocy-directrix;if(!pby2)return rfocx;var lArc=arc.P;if(!lArc)return-1/0;var lfocx=(site=lArc.site).x,lfocy=site.y,plby2=lfocy-directrix;if(!plby2)return lfocx;var hl=lfocx-rfocx,aby2=1/pby2-1/plby2,b=hl/plby2;return aby2?(-b+Math.sqrt(b*b-2*aby2*(hl*hl/(-2*plby2)-lfocy+plby2/2+rfocy-pby2/2)))/aby2+rfocx:(rfocx+lfocx)/2}function d3_geom_voronoiRightBreakPoint(arc,directrix){var rArc=arc.N;if(rArc)return d3_geom_voronoiLeftBreakPoint(rArc,directrix);var site=arc.site;return site.y===directrix?site.x:1/0}function d3_geom_voronoiCell(site){this.site=site,this.edges=[]}function d3_geom_voronoiHalfEdgeOrder(a,b){return b.angle-a.angle}function d3_geom_voronoiCircle(){d3_geom_voronoiRedBlackNode(this),this.x=this.y=this.arc=this.site=this.cy=null}function d3_geom_voronoiAttachCircle(arc){var lArc=arc.P,rArc=arc.N;if(lArc&&rArc){var lSite=lArc.site,cSite=arc.site,rSite=rArc.site;if(lSite!==rSite){var bx=cSite.x,by=cSite.y,ax=lSite.x-bx,ay=lSite.y-by,cx=rSite.x-bx,d=2*(ax*(cy=rSite.y-by)-ay*cx);if(!(d>=-ε2)){var ha=ax*ax+ay*ay,hc=cx*cx+cy*cy,x=(cy*ha-ay*hc)/d,y=(ax*hc-cx*ha)/d,cy=y+by,circle=d3_geom_voronoiCirclePool.pop()||new d3_geom_voronoiCircle;circle.arc=arc,circle.site=cSite,circle.x=x+bx,circle.y=cy+Math.sqrt(x*x+y*y),circle.cy=cy,arc.circle=circle;for(var before=null,node=d3_geom_voronoiCircles._;node;)if(circle.y<node.y||circle.y===node.y&&circle.x<=node.x){if(!node.L){before=node.P;break}node=node.L}else{if(!node.R){before=node;break}node=node.R}d3_geom_voronoiCircles.insert(before,circle),before||(d3_geom_voronoiFirstCircle=circle)}}}}function d3_geom_voronoiDetachCircle(arc){var circle=arc.circle;circle&&(circle.P||(d3_geom_voronoiFirstCircle=circle.N),d3_geom_voronoiCircles.remove(circle),d3_geom_voronoiCirclePool.push(circle),d3_geom_voronoiRedBlackNode(circle),arc.circle=null)}function d3_geom_voronoiConnectEdge(edge,extent){var vb=edge.b;if(vb)return!0;var fm,fb,va=edge.a,x0=extent[0][0],x1=extent[1][0],y0=extent[0][1],y1=extent[1][1],lSite=edge.l,rSite=edge.r,lx=lSite.x,ly=lSite.y,rx=rSite.x,ry=rSite.y,fx=(lx+rx)/2,fy=(ly+ry)/2;if(ry===ly){if(fx<x0||fx>=x1)return;if(lx>rx){if(va){if(va.y>=y1)return}else va={x:fx,y:y0};vb={x:fx,y:y1}}else{if(va){if(va.y<y0)return}else va={x:fx,y:y1};vb={x:fx,y:y0}}}else if(fb=fy-(fm=(lx-rx)/(ry-ly))*fx,fm<-1||fm>1)if(lx>rx){if(va){if(va.y>=y1)return}else va={x:(y0-fb)/fm,y:y0};vb={x:(y1-fb)/fm,y:y1}}else{if(va){if(va.y<y0)return}else va={x:(y1-fb)/fm,y:y1};vb={x:(y0-fb)/fm,y:y0}}else if(ly<ry){if(va){if(va.x>=x1)return}else va={x:x0,y:fm*x0+fb};vb={x:x1,y:fm*x1+fb}}else{if(va){if(va.x<x0)return}else va={x:x1,y:fm*x1+fb};vb={x:x0,y:fm*x0+fb}}return edge.a=va,edge.b=vb,!0}function d3_geom_voronoiEdge(lSite,rSite){this.l=lSite,this.r=rSite,this.a=this.b=null}function d3_geom_voronoiCreateEdge(lSite,rSite,va,vb){var edge=new d3_geom_voronoiEdge(lSite,rSite);return d3_geom_voronoiEdges.push(edge),va&&d3_geom_voronoiSetEdgeEnd(edge,lSite,rSite,va),vb&&d3_geom_voronoiSetEdgeEnd(edge,rSite,lSite,vb),d3_geom_voronoiCells[lSite.i].edges.push(new d3_geom_voronoiHalfEdge(edge,lSite,rSite)),d3_geom_voronoiCells[rSite.i].edges.push(new d3_geom_voronoiHalfEdge(edge,rSite,lSite)),edge}function d3_geom_voronoiCreateBorderEdge(lSite,va,vb){var edge=new d3_geom_voronoiEdge(lSite,null);return edge.a=va,edge.b=vb,d3_geom_voronoiEdges.push(edge),edge}function d3_geom_voronoiSetEdgeEnd(edge,lSite,rSite,vertex){edge.a||edge.b?edge.l===rSite?edge.b=vertex:edge.a=vertex:(edge.a=vertex,edge.l=lSite,edge.r=rSite)}function d3_geom_voronoiHalfEdge(edge,lSite,rSite){var va=edge.a,vb=edge.b;this.edge=edge,this.site=lSite,this.angle=rSite?Math.atan2(rSite.y-lSite.y,rSite.x-lSite.x):edge.l===lSite?Math.atan2(vb.x-va.x,va.y-vb.y):Math.atan2(va.x-vb.x,vb.y-va.y)}function d3_geom_voronoiRedBlackTree(){this._=null}function d3_geom_voronoiRedBlackNode(node){node.U=node.C=node.L=node.R=node.P=node.N=null}function d3_geom_voronoiRedBlackRotateLeft(tree,node){var p=node,q=node.R,parent=p.U;parent?parent.L===p?parent.L=q:parent.R=q:tree._=q,q.U=parent,p.U=q,p.R=q.L,p.R&&(p.R.U=p),q.L=p}function d3_geom_voronoiRedBlackRotateRight(tree,node){var p=node,q=node.L,parent=p.U;parent?parent.L===p?parent.L=q:parent.R=q:tree._=q,q.U=parent,p.U=q,p.L=q.R,p.L&&(p.L.U=p),q.R=p}function d3_geom_voronoiRedBlackFirst(node){for(;node.L;)node=node.L;return node}function d3_geom_voronoi(sites,bbox){var x0,y0,circle,site=sites.sort(d3_geom_voronoiVertexOrder).pop();for(d3_geom_voronoiEdges=[],d3_geom_voronoiCells=new Array(sites.length),d3_geom_voronoiBeaches=new d3_geom_voronoiRedBlackTree,d3_geom_voronoiCircles=new d3_geom_voronoiRedBlackTree;;)if(circle=d3_geom_voronoiFirstCircle,site&&(!circle||site.y<circle.y||site.y===circle.y&&site.x<circle.x))site.x===x0&&site.y===y0||(d3_geom_voronoiCells[site.i]=new d3_geom_voronoiCell(site),d3_geom_voronoiAddBeach(site),x0=site.x,y0=site.y),site=sites.pop();else{if(!circle)break;d3_geom_voronoiRemoveBeach(circle.arc)}bbox&&(function(extent){for(var e,edges=d3_geom_voronoiEdges,clip=d3_geom_clipLine(extent[0][0],extent[0][1],extent[1][0],extent[1][1]),i=edges.length;i--;)(!d3_geom_voronoiConnectEdge(e=edges[i],extent)||!clip(e)||abs(e.a.x-e.b.x)<ε&&abs(e.a.y-e.b.y)<ε)&&(e.a=e.b=null,edges.splice(i,1))}(bbox),function(extent){for(var x2,y2,x3,y3,cell,iHalfEdge,halfEdges,nHalfEdges,start,end,x0=extent[0][0],x1=extent[1][0],y0=extent[0][1],y1=extent[1][1],cells=d3_geom_voronoiCells,iCell=cells.length;iCell--;)if((cell=cells[iCell])&&cell.prepare())for(nHalfEdges=(halfEdges=cell.edges).length,iHalfEdge=0;iHalfEdge<nHalfEdges;)x3=(end=halfEdges[iHalfEdge].end()).x,y3=end.y,x2=(start=halfEdges[++iHalfEdge%nHalfEdges].start()).x,y2=start.y,(abs(x3-x2)>ε||abs(y3-y2)>ε)&&(halfEdges.splice(iHalfEdge,0,new d3_geom_voronoiHalfEdge(d3_geom_voronoiCreateBorderEdge(cell.site,end,abs(x3-x0)<ε&&y1-y3>ε?{x:x0,y:abs(x2-x0)<ε?y2:y1}:abs(y3-y1)<ε&&x1-x3>ε?{x:abs(y2-y1)<ε?x2:x1,y:y1}:abs(x3-x1)<ε&&y3-y0>ε?{x:x1,y:abs(x2-x1)<ε?y2:y0}:abs(y3-y0)<ε&&x3-x0>ε?{x:abs(y2-y0)<ε?x2:x0,y:y0}:null),cell.site,null)),++nHalfEdges)}(bbox));var diagram={cells:d3_geom_voronoiCells,edges:d3_geom_voronoiEdges};return d3_geom_voronoiBeaches=d3_geom_voronoiCircles=d3_geom_voronoiEdges=d3_geom_voronoiCells=null,diagram}function d3_geom_voronoiVertexOrder(a,b){return b.y-a.y||b.x-a.x}d3_geom_voronoiCell.prototype.prepare=function(){for(var edge,halfEdges=this.edges,iHalfEdge=halfEdges.length;iHalfEdge--;)(edge=halfEdges[iHalfEdge].edge).b&&edge.a||halfEdges.splice(iHalfEdge,1);return halfEdges.sort(d3_geom_voronoiHalfEdgeOrder),halfEdges.length},d3_geom_voronoiHalfEdge.prototype={start:function(){return this.edge.l===this.site?this.edge.a:this.edge.b},end:function(){return this.edge.l===this.site?this.edge.b:this.edge.a}},d3_geom_voronoiRedBlackTree.prototype={insert:function(after,node){var parent,grandpa,uncle;if(after){if(node.P=after,node.N=after.N,after.N&&(after.N.P=node),after.N=node,after.R){for(after=after.R;after.L;)after=after.L;after.L=node}else after.R=node;parent=after}else this._?(after=d3_geom_voronoiRedBlackFirst(this._),node.P=null,node.N=after,after.P=after.L=node,parent=after):(node.P=node.N=null,this._=node,parent=null);for(node.L=node.R=null,node.U=parent,node.C=!0,after=node;parent&&parent.C;)parent===(grandpa=parent.U).L?(uncle=grandpa.R)&&uncle.C?(parent.C=uncle.C=!1,grandpa.C=!0,after=grandpa):(after===parent.R&&(d3_geom_voronoiRedBlackRotateLeft(this,parent),parent=(after=parent).U),parent.C=!1,grandpa.C=!0,d3_geom_voronoiRedBlackRotateRight(this,grandpa)):(uncle=grandpa.L)&&uncle.C?(parent.C=uncle.C=!1,grandpa.C=!0,after=grandpa):(after===parent.L&&(d3_geom_voronoiRedBlackRotateRight(this,parent),parent=(after=parent).U),parent.C=!1,grandpa.C=!0,d3_geom_voronoiRedBlackRotateLeft(this,grandpa)),parent=after.U;this._.C=!1},remove:function(node){node.N&&(node.N.P=node.P),node.P&&(node.P.N=node.N),node.N=node.P=null;var sibling,next,red,parent=node.U,left=node.L,right=node.R;if(next=left?right?d3_geom_voronoiRedBlackFirst(right):left:right,parent?parent.L===node?parent.L=next:parent.R=next:this._=next,left&&right?(red=next.C,next.C=node.C,next.L=left,left.U=next,next!==right?(parent=next.U,next.U=node.U,node=next.R,parent.L=node,next.R=right,right.U=next):(next.U=parent,parent=next,node=next.R)):(red=node.C,node=next),node&&(node.U=parent),!red)if(node&&node.C)node.C=!1;else{do{if(node===this._)break;if(node===parent.L){if((sibling=parent.R).C&&(sibling.C=!1,parent.C=!0,d3_geom_voronoiRedBlackRotateLeft(this,parent),sibling=parent.R),sibling.L&&sibling.L.C||sibling.R&&sibling.R.C){sibling.R&&sibling.R.C||(sibling.L.C=!1,sibling.C=!0,d3_geom_voronoiRedBlackRotateRight(this,sibling),sibling=parent.R),sibling.C=parent.C,parent.C=sibling.R.C=!1,d3_geom_voronoiRedBlackRotateLeft(this,parent),node=this._;break}}else if((sibling=parent.L).C&&(sibling.C=!1,parent.C=!0,d3_geom_voronoiRedBlackRotateRight(this,parent),sibling=parent.L),sibling.L&&sibling.L.C||sibling.R&&sibling.R.C){sibling.L&&sibling.L.C||(sibling.R.C=!1,sibling.C=!0,d3_geom_voronoiRedBlackRotateLeft(this,sibling),sibling=parent.L),sibling.C=parent.C,parent.C=sibling.L.C=!1,d3_geom_voronoiRedBlackRotateRight(this,parent),node=this._;break}sibling.C=!0,node=parent,parent=parent.U}while(!node.C);node&&(node.C=!1)}}},d3.geom.voronoi=function(points){var x=d3_geom_pointX,y=d3_geom_pointY,fx=x,fy=y,clipExtent=d3_geom_voronoiClipExtent;if(points)return voronoi(points);function voronoi(data){var polygons=new Array(data.length),x0=clipExtent[0][0],y0=clipExtent[0][1],x1=clipExtent[1][0],y1=clipExtent[1][1];return d3_geom_voronoi(sites(data),clipExtent).cells.forEach((function(cell,i){var edges=cell.edges,site=cell.site;(polygons[i]=edges.length?edges.map((function(e){var s=e.start();return[s.x,s.y]})):site.x>=x0&&site.x<=x1&&site.y>=y0&&site.y<=y1?[[x0,y1],[x1,y1],[x1,y0],[x0,y0]]:[]).point=data[i]})),polygons}function sites(data){return data.map((function(d,i){return{x:Math.round(fx(d,i)/ε)*ε,y:Math.round(fy(d,i)/ε)*ε,i:i}}))}return voronoi.links=function(data){return d3_geom_voronoi(sites(data)).edges.filter((function(edge){return edge.l&&edge.r})).map((function(edge){return{source:data[edge.l.i],target:data[edge.r.i]}}))},voronoi.triangles=function(data){var triangles=[];return d3_geom_voronoi(sites(data)).cells.forEach((function(cell,i){for(var s0,a,b,c,site=cell.site,edges=cell.edges.sort(d3_geom_voronoiHalfEdgeOrder),j=-1,m=edges.length,e1=edges[m-1].edge,s1=e1.l===site?e1.r:e1.l;++j<m;)e1,s0=s1,s1=(e1=edges[j].edge).l===site?e1.r:e1.l,i<s0.i&&i<s1.i&&(b=s0,c=s1,((a=site).x-c.x)*(b.y-a.y)-(a.x-b.x)*(c.y-a.y)<0)&&triangles.push([data[i],data[s0.i],data[s1.i]])})),triangles},voronoi.x=function(_){return arguments.length?(fx=d3_functor(x=_),voronoi):x},voronoi.y=function(_){return arguments.length?(fy=d3_functor(y=_),voronoi):y},voronoi.clipExtent=function(_){return arguments.length?(clipExtent=null==_?d3_geom_voronoiClipExtent:_,voronoi):clipExtent===d3_geom_voronoiClipExtent?null:clipExtent},voronoi.size=function(_){return arguments.length?voronoi.clipExtent(_&&[[0,0],_]):clipExtent===d3_geom_voronoiClipExtent?null:clipExtent&&clipExtent[1]},voronoi};var d3_geom_voronoiClipExtent=[[-1e6,-1e6],[1e6,1e6]];function d3_geom_quadtreeCompatX(d){return d.x}function d3_geom_quadtreeCompatY(d){return d.y}function d3_geom_quadtreeVisit(f,node,x1,y1,x2,y2){if(!f(node,x1,y1,x2,y2)){var sx=.5*(x1+x2),sy=.5*(y1+y2),children=node.nodes;children[0]&&d3_geom_quadtreeVisit(f,children[0],x1,y1,sx,sy),children[1]&&d3_geom_quadtreeVisit(f,children[1],sx,y1,x2,sy),children[2]&&d3_geom_quadtreeVisit(f,children[2],x1,sy,sx,y2),children[3]&&d3_geom_quadtreeVisit(f,children[3],sx,sy,x2,y2)}}function d3_geom_quadtreeFind(root,x,y,x0,y0,x3,y3){var closestPoint,minDistance2=1/0;return function find(node,x1,y1,x2,y2){if(!(x1>x3||y1>y3||x2<x0||y2<y0)){if(point=node.point){var point,dx=x-node.x,dy=y-node.y,distance2=dx*dx+dy*dy;if(distance2<minDistance2){var distance=Math.sqrt(minDistance2=distance2);x0=x-distance,y0=y-distance,x3=x+distance,y3=y+distance,closestPoint=point}}for(var children=node.nodes,xm=.5*(x1+x2),ym=.5*(y1+y2),i=(y>=ym)<<1|x>=xm,j=i+4;i<j;++i)if(node=children[3&i])switch(3&i){case 0:find(node,x1,y1,xm,ym);break;case 1:find(node,xm,y1,x2,ym);break;case 2:find(node,x1,ym,xm,y2);break;case 3:find(node,xm,ym,x2,y2)}}}(root,x0,y0,x3,y3),closestPoint}function d3_interpolateRgb(a,b){a=d3.rgb(a),b=d3.rgb(b);var ar=a.r,ag=a.g,ab=a.b,br=b.r-ar,bg=b.g-ag,bb=b.b-ab;return function(t){return"#"+d3_rgb_hex(Math.round(ar+br*t))+d3_rgb_hex(Math.round(ag+bg*t))+d3_rgb_hex(Math.round(ab+bb*t))}}function d3_interpolateObject(a,b){var k,i={},c={};for(k in a)k in b?i[k]=d3_interpolate(a[k],b[k]):c[k]=a[k];for(k in b)k in a||(c[k]=b[k]);return function(t){for(k in i)c[k]=i[k](t);return c}}function d3_interpolateNumber(a,b){return a=+a,b=+b,function(t){return a*(1-t)+b*t}}function d3_interpolateString(a,b){var am,bm,bs,bi=d3_interpolate_numberA.lastIndex=d3_interpolate_numberB.lastIndex=0,i=-1,s=[],q=[];for(a+="",b+="";(am=d3_interpolate_numberA.exec(a))&&(bm=d3_interpolate_numberB.exec(b));)(bs=bm.index)>bi&&(bs=b.slice(bi,bs),s[i]?s[i]+=bs:s[++i]=bs),(am=am[0])===(bm=bm[0])?s[i]?s[i]+=bm:s[++i]=bm:(s[++i]=null,q.push({i:i,x:d3_interpolateNumber(am,bm)})),bi=d3_interpolate_numberB.lastIndex;return bi<b.length&&(bs=b.slice(bi),s[i]?s[i]+=bs:s[++i]=bs),s.length<2?q[0]?(b=q[0].x,function(t){return b(t)+""}):function(){return b}:(b=q.length,function(t){for(var o,i=0;i<b;++i)s[(o=q[i]).i]=o.x(t);return s.join("")})}d3.geom.delaunay=function(vertices){return d3.geom.voronoi().triangles(vertices)},d3.geom.quadtree=function(points,x1,y1,x2,y2){var compat,x=d3_geom_pointX,y=d3_geom_pointY;if(compat=arguments.length)return x=d3_geom_quadtreeCompatX,y=d3_geom_quadtreeCompatY,3===compat&&(y2=y1,x2=x1,y1=x1=0),quadtree(points);function quadtree(data){var d,xs,ys,i,n,x1_,y1_,x2_,y2_,fx=d3_functor(x),fy=d3_functor(y);if(null!=x1)x1_=x1,y1_=y1,x2_=x2,y2_=y2;else if(x2_=y2_=-(x1_=y1_=1/0),xs=[],ys=[],n=data.length,compat)for(i=0;i<n;++i)(d=data[i]).x<x1_&&(x1_=d.x),d.y<y1_&&(y1_=d.y),d.x>x2_&&(x2_=d.x),d.y>y2_&&(y2_=d.y),xs.push(d.x),ys.push(d.y);else for(i=0;i<n;++i){var x_=+fx(d=data[i],i),y_=+fy(d,i);x_<x1_&&(x1_=x_),y_<y1_&&(y1_=y_),x_>x2_&&(x2_=x_),y_>y2_&&(y2_=y_),xs.push(x_),ys.push(y_)}var dx=x2_-x1_,dy=y2_-y1_;function insert(n,d,x,y,x1,y1,x2,y2){if(!isNaN(x)&&!isNaN(y))if(n.leaf){var nx=n.x,ny=n.y;if(null!=nx)if(abs(nx-x)+abs(ny-y)<.01)insertChild(n,d,x,y,x1,y1,x2,y2);else{var nPoint=n.point;n.x=n.y=n.point=null,insertChild(n,nPoint,nx,ny,x1,y1,x2,y2),insertChild(n,d,x,y,x1,y1,x2,y2)}else n.x=x,n.y=y,n.point=d}else insertChild(n,d,x,y,x1,y1,x2,y2)}function insertChild(n,d,x,y,x1,y1,x2,y2){var xm=.5*(x1+x2),ym=.5*(y1+y2),right=x>=xm,below=y>=ym,i=below<<1|right;n.leaf=!1,right?x1=xm:x2=xm,below?y1=ym:y2=ym,insert(n=n.nodes[i]||(n.nodes[i]={leaf:!0,nodes:[],point:null,x:null,y:null}),d,x,y,x1,y1,x2,y2)}dx>dy?y2_=y1_+dx:x2_=x1_+dy;var root={leaf:!0,nodes:[],point:null,x:null,y:null,add:function(d){insert(root,d,+fx(d,++i),+fy(d,i),x1_,y1_,x2_,y2_)},visit:function(f){d3_geom_quadtreeVisit(f,root,x1_,y1_,x2_,y2_)},find:function(point){return d3_geom_quadtreeFind(root,point[0],point[1],x1_,y1_,x2_,y2_)}};if(i=-1,null==x1){for(;++i<n;)insert(root,data[i],xs[i],ys[i],x1_,y1_,x2_,y2_);--i}else data.forEach(root.add);return xs=ys=data=d=null,root}return quadtree.x=function(_){return arguments.length?(x=_,quadtree):x},quadtree.y=function(_){return arguments.length?(y=_,quadtree):y},quadtree.extent=function(_){return arguments.length?(null==_?x1=y1=x2=y2=null:(x1=+_[0][0],y1=+_[0][1],x2=+_[1][0],y2=+_[1][1]),quadtree):null==x1?null:[[x1,y1],[x2,y2]]},quadtree.size=function(_){return arguments.length?(null==_?x1=y1=x2=y2=null:(x1=y1=0,x2=+_[0],y2=+_[1]),quadtree):null==x1?null:[x2-x1,y2-y1]},quadtree},d3.interpolateRgb=d3_interpolateRgb,d3.interpolateObject=d3_interpolateObject,d3.interpolateNumber=d3_interpolateNumber,d3.interpolateString=d3_interpolateString;var d3_interpolate_numberA=/[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g,d3_interpolate_numberB=new RegExp(d3_interpolate_numberA.source,"g");function d3_interpolate(a,b){for(var f,i=d3.interpolators.length;--i>=0&&!(f=d3.interpolators[i](a,b)););return f}function d3_interpolateArray(a,b){var i,x=[],c=[],na=a.length,nb=b.length,n0=Math.min(a.length,b.length);for(i=0;i<n0;++i)x.push(d3_interpolate(a[i],b[i]));for(;i<na;++i)c[i]=a[i];for(;i<nb;++i)c[i]=b[i];return function(t){for(i=0;i<n0;++i)c[i]=x[i](t);return c}}d3.interpolate=d3_interpolate,d3.interpolators=[function(a,b){var t=typeof b;return("string"===t?d3_rgb_names.has(b.toLowerCase())||/^(#|rgb\(|hsl\()/i.test(b)?d3_interpolateRgb:d3_interpolateString:b instanceof d3_color?d3_interpolateRgb:Array.isArray(b)?d3_interpolateArray:"object"===t&&isNaN(b)?d3_interpolateObject:d3_interpolateNumber)(a,b)}],d3.interpolateArray=d3_interpolateArray;var d3_ease_default=function(){return d3_identity},d3_ease=d3.map({linear:d3_ease_default,poly:function(e){return function(t){return Math.pow(t,e)}},quad:function(){return d3_ease_quad},cubic:function(){return d3_ease_cubic},sin:function(){return d3_ease_sin},exp:function(){return d3_ease_exp},circle:function(){return d3_ease_circle},elastic:function(a,p){var s;arguments.length<2&&(p=.45);arguments.length?s=p/τ*Math.asin(1/a):(a=1,s=p/4);return function(t){return 1+a*Math.pow(2,-10*t)*Math.sin((t-s)*τ/p)}},back:function(s){s||(s=1.70158);return function(t){return t*t*((s+1)*t-s)}},bounce:function(){return d3_ease_bounce}}),d3_ease_mode=d3.map({in:d3_identity,out:d3_ease_reverse,"in-out":d3_ease_reflect,"out-in":function(f){return d3_ease_reflect(d3_ease_reverse(f))}});function d3_ease_clamp(f){return function(t){return t<=0?0:t>=1?1:f(t)}}function d3_ease_reverse(f){return function(t){return 1-f(1-t)}}function d3_ease_reflect(f){return function(t){return.5*(t<.5?f(2*t):2-f(2-2*t))}}function d3_ease_quad(t){return t*t}function d3_ease_cubic(t){return t*t*t}function d3_ease_cubicInOut(t){if(t<=0)return 0;if(t>=1)return 1;var t2=t*t,t3=t2*t;return 4*(t<.5?t3:3*(t-t2)+t3-.75)}function d3_ease_sin(t){return 1-Math.cos(t*halfπ)}function d3_ease_exp(t){return Math.pow(2,10*(t-1))}function d3_ease_circle(t){return 1-Math.sqrt(1-t*t)}function d3_ease_bounce(t){return t<1/2.75?7.5625*t*t:t<2/2.75?7.5625*(t-=1.5/2.75)*t+.75:t<2.5/2.75?7.5625*(t-=2.25/2.75)*t+.9375:7.5625*(t-=2.625/2.75)*t+.984375}function d3_interpolateRound(a,b){return b-=a,function(t){return Math.round(a+b*t)}}function d3_transform(m){var a,b,k,r0=[m.a,m.b],r1=[m.c,m.d],kx=d3_transformNormalize(r0),kz=d3_transformDot(r0,r1),ky=d3_transformNormalize(((a=r1)[0]+=(k=-kz)*(b=r0)[0],a[1]+=k*b[1],a))||0;r0[0]*r1[1]<r1[0]*r0[1]&&(r0[0]*=-1,r0[1]*=-1,kx*=-1,kz*=-1),this.rotate=(kx?Math.atan2(r0[1],r0[0]):Math.atan2(-r1[0],r1[1]))*d3_degrees,this.translate=[m.e,m.f],this.scale=[kx,ky],this.skew=ky?Math.atan2(kz,ky)*d3_degrees:0}function d3_transformDot(a,b){return a[0]*b[0]+a[1]*b[1]}function d3_transformNormalize(a){var k=Math.sqrt(d3_transformDot(a,a));return k&&(a[0]/=k,a[1]/=k),k}d3.ease=function(name){var i=name.indexOf("-"),t=i>=0?name.slice(0,i):name,m=i>=0?name.slice(i+1):"in";return t=d3_ease.get(t)||d3_ease_default,d3_ease_clamp((m=d3_ease_mode.get(m)||d3_identity)(t.apply(null,d3_arraySlice.call(arguments,1))))},d3.interpolateHcl=function(a,b){a=d3.hcl(a),b=d3.hcl(b);var ah=a.h,ac=a.c,al=a.l,bh=b.h-ah,bc=b.c-ac,bl=b.l-al;isNaN(bc)&&(bc=0,ac=isNaN(ac)?b.c:ac);isNaN(bh)?(bh=0,ah=isNaN(ah)?b.h:ah):bh>180?bh-=360:bh<-180&&(bh+=360);return function(t){return d3_hcl_lab(ah+bh*t,ac+bc*t,al+bl*t)+""}},d3.interpolateHsl=function(a,b){a=d3.hsl(a),b=d3.hsl(b);var ah=a.h,as=a.s,al=a.l,bh=b.h-ah,bs=b.s-as,bl=b.l-al;isNaN(bs)&&(bs=0,as=isNaN(as)?b.s:as);isNaN(bh)?(bh=0,ah=isNaN(ah)?b.h:ah):bh>180?bh-=360:bh<-180&&(bh+=360);return function(t){return d3_hsl_rgb(ah+bh*t,as+bs*t,al+bl*t)+""}},d3.interpolateLab=function(a,b){a=d3.lab(a),b=d3.lab(b);var al=a.l,aa=a.a,ab=a.b,bl=b.l-al,ba=b.a-aa,bb=b.b-ab;return function(t){return d3_lab_rgb(al+bl*t,aa+ba*t,ab+bb*t)+""}},d3.interpolateRound=d3_interpolateRound,d3.transform=function(string){var g=d3_document.createElementNS(d3.ns.prefix.svg,"g");return(d3.transform=function(string){if(null!=string){g.setAttribute("transform",string);var t=g.transform.baseVal.consolidate()}return new d3_transform(t?t.matrix:d3_transformIdentity)})(string)},d3_transform.prototype.toString=function(){return"translate("+this.translate+")rotate("+this.rotate+")skewX("+this.skew+")scale("+this.scale+")"};var d3_transformIdentity={a:1,b:0,c:0,d:1,e:0,f:0};function d3_interpolateTransformPop(s){return s.length?s.pop()+",":""}function d3_interpolateTransform(a,b){var s=[],q=[];return a=d3.transform(a),b=d3.transform(b),function(ta,tb,s,q){if(ta[0]!==tb[0]||ta[1]!==tb[1]){var i=s.push("translate(",null,",",null,")");q.push({i:i-4,x:d3_interpolateNumber(ta[0],tb[0])},{i:i-2,x:d3_interpolateNumber(ta[1],tb[1])})}else(tb[0]||tb[1])&&s.push("translate("+tb+")")}(a.translate,b.translate,s,q),function(ra,rb,s,q){ra!==rb?(ra-rb>180?rb+=360:rb-ra>180&&(ra+=360),q.push({i:s.push(d3_interpolateTransformPop(s)+"rotate(",null,")")-2,x:d3_interpolateNumber(ra,rb)})):rb&&s.push(d3_interpolateTransformPop(s)+"rotate("+rb+")")}(a.rotate,b.rotate,s,q),function(wa,wb,s,q){wa!==wb?q.push({i:s.push(d3_interpolateTransformPop(s)+"skewX(",null,")")-2,x:d3_interpolateNumber(wa,wb)}):wb&&s.push(d3_interpolateTransformPop(s)+"skewX("+wb+")")}(a.skew,b.skew,s,q),function(ka,kb,s,q){if(ka[0]!==kb[0]||ka[1]!==kb[1]){var i=s.push(d3_interpolateTransformPop(s)+"scale(",null,",",null,")");q.push({i:i-4,x:d3_interpolateNumber(ka[0],kb[0])},{i:i-2,x:d3_interpolateNumber(ka[1],kb[1])})}else 1===kb[0]&&1===kb[1]||s.push(d3_interpolateTransformPop(s)+"scale("+kb+")")}(a.scale,b.scale,s,q),a=b=null,function(t){for(var o,i=-1,n=q.length;++i<n;)s[(o=q[i]).i]=o.x(t);return s.join("")}}function d3_uninterpolateNumber(a,b){return b=(b-=a=+a)||1/b,function(x){return(x-a)/b}}function d3_uninterpolateClamp(a,b){return b=(b-=a=+a)||1/b,function(x){return Math.max(0,Math.min(1,(x-a)/b))}}function d3_layout_bundlePath(link){for(var start=link.source,end=link.target,lca=function(a,b){if(a===b)return a;var aNodes=d3_layout_bundleAncestors(a),bNodes=d3_layout_bundleAncestors(b),aNode=aNodes.pop(),bNode=bNodes.pop(),sharedNode=null;for(;aNode===bNode;)sharedNode=aNode,aNode=aNodes.pop(),bNode=bNodes.pop();return sharedNode}(start,end),points=[start];start!==lca;)start=start.parent,points.push(start);for(var k=points.length;end!==lca;)points.splice(k,0,end),end=end.parent;return points}function d3_layout_bundleAncestors(node){for(var ancestors=[],parent=node.parent;null!=parent;)ancestors.push(node),node=parent,parent=parent.parent;return ancestors.push(node),ancestors}function d3_layout_forceDragstart(d){d.fixed|=2}function d3_layout_forceDragend(d){d.fixed&=-7}function d3_layout_forceMouseover(d){d.fixed|=4,d.px=d.x,d.py=d.y}function d3_layout_forceMouseout(d){d.fixed&=-5}d3.interpolateTransform=d3_interpolateTransform,d3.layout={},d3.layout.bundle=function(){return function(links){for(var paths=[],i=-1,n=links.length;++i<n;)paths.push(d3_layout_bundlePath(links[i]));return paths}},d3.layout.chord=function(){var chords,groups,matrix,n,sortGroups,sortSubgroups,sortChords,chord={},padding=0;function relayout(){var k,x,x0,i,j,subgroups={},groupSums=[],groupIndex=d3.range(n),subgroupIndex=[];for(chords=[],groups=[],k=0,i=-1;++i<n;){for(x=0,j=-1;++j<n;)x+=matrix[i][j];groupSums.push(x),subgroupIndex.push(d3.range(n)),k+=x}for(sortGroups&&groupIndex.sort((function(a,b){return sortGroups(groupSums[a],groupSums[b])})),sortSubgroups&&subgroupIndex.forEach((function(d,i){d.sort((function(a,b){return sortSubgroups(matrix[i][a],matrix[i][b])}))})),k=(τ-padding*n)/k,x=0,i=-1;++i<n;){for(x0=x,j=-1;++j<n;){var di=groupIndex[i],dj=subgroupIndex[di][j],v=matrix[di][dj],a0=x,a1=x+=v*k;subgroups[di+"-"+dj]={index:di,subindex:dj,startAngle:a0,endAngle:a1,value:v}}groups[di]={index:di,startAngle:x0,endAngle:x,value:groupSums[di]},x+=padding}for(i=-1;++i<n;)for(j=i-1;++j<n;){var source=subgroups[i+"-"+j],target=subgroups[j+"-"+i];(source.value||target.value)&&chords.push(source.value<target.value?{source:target,target:source}:{source:source,target:target})}sortChords&&resort()}function resort(){chords.sort((function(a,b){return sortChords((a.source.value+a.target.value)/2,(b.source.value+b.target.value)/2)}))}return chord.matrix=function(x){return arguments.length?(n=(matrix=x)&&matrix.length,chords=groups=null,chord):matrix},chord.padding=function(x){return arguments.length?(padding=x,chords=groups=null,chord):padding},chord.sortGroups=function(x){return arguments.length?(sortGroups=x,chords=groups=null,chord):sortGroups},chord.sortSubgroups=function(x){return arguments.length?(sortSubgroups=x,chords=null,chord):sortSubgroups},chord.sortChords=function(x){return arguments.length?(sortChords=x,chords&&resort(),chord):sortChords},chord.chords=function(){return chords||relayout(),chords},chord.groups=function(){return groups||relayout(),groups},chord},d3.layout.force=function(){var timer,drag,alpha,distances,strengths,charges,force={},event=d3.dispatch("start","tick","end"),size=[1,1],friction=.9,linkDistance=d3_layout_forceLinkDistance,linkStrength=d3_layout_forceLinkStrength,charge=-30,chargeDistance2=d3_layout_forceChargeDistance2,gravity=.1,theta2=.64,nodes=[],links=[];function repulse(node){return function(quad,x1,_,x2){if(quad.point!==node){var dx=quad.cx-node.x,dy=quad.cy-node.y,dw=x2-x1,dn=dx*dx+dy*dy;if(dw*dw/theta2<dn){if(dn<chargeDistance2){var k=quad.charge/dn;node.px-=dx*k,node.py-=dy*k}return!0}if(quad.point&&dn&&dn<chargeDistance2){k=quad.pointCharge/dn;node.px-=dx*k,node.py-=dy*k}}return!quad.charge}}function dragmove(d){d.px=d3.event.x,d.py=d3.event.y,force.resume()}return force.tick=function(){if((alpha*=.99)<.005)return timer=null,event.end({type:"end",alpha:alpha=0}),!0;var q,i,o,s,t,l,k,x,y,n=nodes.length,m=links.length;for(i=0;i<m;++i)s=(o=links[i]).source,(l=(x=(t=o.target).x-s.x)*x+(y=t.y-s.y)*y)&&(x*=l=alpha*strengths[i]*((l=Math.sqrt(l))-distances[i])/l,y*=l,t.x-=x*(k=s.weight+t.weight?s.weight/(s.weight+t.weight):.5),t.y-=y*k,s.x+=x*(k=1-k),s.y+=y*k);if((k=alpha*gravity)&&(x=size[0]/2,y=size[1]/2,i=-1,k))for(;++i<n;)(o=nodes[i]).x+=(x-o.x)*k,o.y+=(y-o.y)*k;if(charge)for(!function d3_layout_forceAccumulate(quad,alpha,charges){var cx=0,cy=0;if(quad.charge=0,!quad.leaf)for(var c,nodes=quad.nodes,n=nodes.length,i=-1;++i<n;)null!=(c=nodes[i])&&(d3_layout_forceAccumulate(c,alpha,charges),quad.charge+=c.charge,cx+=c.charge*c.cx,cy+=c.charge*c.cy);if(quad.point){quad.leaf||(quad.point.x+=Math.random()-.5,quad.point.y+=Math.random()-.5);var k=alpha*charges[quad.point.index];quad.charge+=quad.pointCharge=k,cx+=k*quad.point.x,cy+=k*quad.point.y}quad.cx=cx/quad.charge,quad.cy=cy/quad.charge}(q=d3.geom.quadtree(nodes),alpha,charges),i=-1;++i<n;)(o=nodes[i]).fixed||q.visit(repulse(o));for(i=-1;++i<n;)(o=nodes[i]).fixed?(o.x=o.px,o.y=o.py):(o.x-=(o.px-(o.px=o.x))*friction,o.y-=(o.py-(o.py=o.y))*friction);event.tick({type:"tick",alpha:alpha})},force.nodes=function(x){return arguments.length?(nodes=x,force):nodes},force.links=function(x){return arguments.length?(links=x,force):links},force.size=function(x){return arguments.length?(size=x,force):size},force.linkDistance=function(x){return arguments.length?(linkDistance="function"==typeof x?x:+x,force):linkDistance},force.distance=force.linkDistance,force.linkStrength=function(x){return arguments.length?(linkStrength="function"==typeof x?x:+x,force):linkStrength},force.friction=function(x){return arguments.length?(friction=+x,force):friction},force.charge=function(x){return arguments.length?(charge="function"==typeof x?x:+x,force):charge},force.chargeDistance=function(x){return arguments.length?(chargeDistance2=x*x,force):Math.sqrt(chargeDistance2)},force.gravity=function(x){return arguments.length?(gravity=+x,force):gravity},force.theta=function(x){return arguments.length?(theta2=x*x,force):Math.sqrt(theta2)},force.alpha=function(x){return arguments.length?(x=+x,alpha?x>0?alpha=x:(timer.c=null,timer.t=NaN,timer=null,event.end({type:"end",alpha:alpha=0})):x>0&&(event.start({type:"start",alpha:alpha=x}),timer=d3_timer(force.tick)),force):alpha},force.start=function(){var i,neighbors,o,n=nodes.length,m=links.length,w=size[0],h=size[1];for(i=0;i<n;++i)(o=nodes[i]).index=i,o.weight=0;for(i=0;i<m;++i)"number"==typeof(o=links[i]).source&&(o.source=nodes[o.source]),"number"==typeof o.target&&(o.target=nodes[o.target]),++o.source.weight,++o.target.weight;for(i=0;i<n;++i)o=nodes[i],isNaN(o.x)&&(o.x=position("x",w)),isNaN(o.y)&&(o.y=position("y",h)),isNaN(o.px)&&(o.px=o.x),isNaN(o.py)&&(o.py=o.y);if(distances=[],"function"==typeof linkDistance)for(i=0;i<m;++i)distances[i]=+linkDistance.call(this,links[i],i);else for(i=0;i<m;++i)distances[i]=linkDistance;if(strengths=[],"function"==typeof linkStrength)for(i=0;i<m;++i)strengths[i]=+linkStrength.call(this,links[i],i);else for(i=0;i<m;++i)strengths[i]=linkStrength;if(charges=[],"function"==typeof charge)for(i=0;i<n;++i)charges[i]=+charge.call(this,nodes[i],i);else for(i=0;i<n;++i)charges[i]=charge;function position(dimension,size){if(!neighbors){for(neighbors=new Array(n),j=0;j<n;++j)neighbors[j]=[];for(j=0;j<m;++j){var o=links[j];neighbors[o.source.index].push(o.target),neighbors[o.target.index].push(o.source)}}for(var x,candidates=neighbors[i],j=-1,l=candidates.length;++j<l;)if(!isNaN(x=candidates[j][dimension]))return x;return Math.random()*size}return force.resume()},force.resume=function(){return force.alpha(.1)},force.stop=function(){return force.alpha(0)},force.drag=function(){if(drag||(drag=d3.behavior.drag().origin(d3_identity).on("dragstart.force",d3_layout_forceDragstart).on("drag.force",dragmove).on("dragend.force",d3_layout_forceDragend)),!arguments.length)return drag;this.on("mouseover.force",d3_layout_forceMouseover).on("mouseout.force",d3_layout_forceMouseout).call(drag)},d3.rebind(force,event,"on")};var d3_layout_forceLinkDistance=20,d3_layout_forceLinkStrength=1,d3_layout_forceChargeDistance2=1/0;function d3_layout_hierarchyRebind(object,hierarchy){return d3.rebind(object,hierarchy,"sort","children","value"),object.nodes=object,object.links=d3_layout_hierarchyLinks,object}function d3_layout_hierarchyVisitBefore(node,callback){for(var nodes=[node];null!=(node=nodes.pop());)if(callback(node),(children=node.children)&&(n=children.length))for(var n,children;--n>=0;)nodes.push(children[n])}function d3_layout_hierarchyVisitAfter(node,callback){for(var nodes=[node],nodes2=[];null!=(node=nodes.pop());)if(nodes2.push(node),(children=node.children)&&(n=children.length))for(var n,children,i=-1;++i<n;)nodes.push(children[i]);for(;null!=(node=nodes2.pop());)callback(node)}function d3_layout_hierarchyChildren(d){return d.children}function d3_layout_hierarchyValue(d){return d.value}function d3_layout_hierarchySort(a,b){return b.value-a.value}function d3_layout_hierarchyLinks(nodes){return d3.merge(nodes.map((function(parent){return(parent.children||[]).map((function(child){return{source:parent,target:child}}))})))}d3.layout.hierarchy=function(){var sort=d3_layout_hierarchySort,children=d3_layout_hierarchyChildren,value=d3_layout_hierarchyValue;function hierarchy(root){var node,stack=[root],nodes=[];for(root.depth=0;null!=(node=stack.pop());)if(nodes.push(node),(childs=children.call(hierarchy,node,node.depth))&&(n=childs.length)){for(var n,childs,child;--n>=0;)stack.push(child=childs[n]),child.parent=node,child.depth=node.depth+1;value&&(node.value=0),node.children=childs}else value&&(node.value=+value.call(hierarchy,node,node.depth)||0),delete node.children;return d3_layout_hierarchyVisitAfter(root,(function(node){var childs,parent;sort&&(childs=node.children)&&childs.sort(sort),value&&(parent=node.parent)&&(parent.value+=node.value)})),nodes}return hierarchy.sort=function(x){return arguments.length?(sort=x,hierarchy):sort},hierarchy.children=function(x){return arguments.length?(children=x,hierarchy):children},hierarchy.value=function(x){return arguments.length?(value=x,hierarchy):value},hierarchy.revalue=function(root){return value&&(d3_layout_hierarchyVisitBefore(root,(function(node){node.children&&(node.value=0)})),d3_layout_hierarchyVisitAfter(root,(function(node){var parent;node.children||(node.value=+value.call(hierarchy,node,node.depth)||0),(parent=node.parent)&&(parent.value+=node.value)}))),root},hierarchy},d3.layout.partition=function(){var hierarchy=d3.layout.hierarchy(),size=[1,1];function partition(d,i){var nodes=hierarchy.call(this,d,i);return function position(node,x,dx,dy){var children=node.children;if(node.x=x,node.y=node.depth*dy,node.dx=dx,node.dy=dy,children&&(n=children.length)){var n,c,d,i=-1;for(dx=node.value?dx/node.value:0;++i<n;)position(c=children[i],x,d=c.value*dx,dy),x+=d}}(nodes[0],0,size[0],size[1]/function depth(node){var children=node.children,d=0;if(children&&(n=children.length))for(var n,i=-1;++i<n;)d=Math.max(d,depth(children[i]));return 1+d}(nodes[0])),nodes}return partition.size=function(x){return arguments.length?(size=x,partition):size},d3_layout_hierarchyRebind(partition,hierarchy)},d3.layout.pie=function(){var value=Number,sort=d3_layout_pieSortByValue,startAngle=0,endAngle=τ,padAngle=0;function pie(data){var v,n=data.length,values=data.map((function(d,i){return+value.call(pie,d,i)})),a=+("function"==typeof startAngle?startAngle.apply(this,arguments):startAngle),da=("function"==typeof endAngle?endAngle.apply(this,arguments):endAngle)-a,p=Math.min(Math.abs(da)/n,+("function"==typeof padAngle?padAngle.apply(this,arguments):padAngle)),pa=p*(da<0?-1:1),sum=d3.sum(values),k=sum?(da-n*pa)/sum:0,index=d3.range(n),arcs=[];return null!=sort&&index.sort(sort===d3_layout_pieSortByValue?function(i,j){return values[j]-values[i]}:function(i,j){return sort(data[i],data[j])}),index.forEach((function(i){arcs[i]={data:data[i],value:v=values[i],startAngle:a,endAngle:a+=v*k+pa,padAngle:p}})),arcs}return pie.value=function(_){return arguments.length?(value=_,pie):value},pie.sort=function(_){return arguments.length?(sort=_,pie):sort},pie.startAngle=function(_){return arguments.length?(startAngle=_,pie):startAngle},pie.endAngle=function(_){return arguments.length?(endAngle=_,pie):endAngle},pie.padAngle=function(_){return arguments.length?(padAngle=_,pie):padAngle},pie};var d3_layout_pieSortByValue={};function d3_layout_stackX(d){return d.x}function d3_layout_stackY(d){return d.y}function d3_layout_stackOut(d,y0,y){d.y0=y0,d.y=y}d3.layout.stack=function(){var values=d3_identity,order=d3_layout_stackOrderDefault,offset=d3_layout_stackOffsetZero,out=d3_layout_stackOut,x=d3_layout_stackX,y=d3_layout_stackY;function stack(data,index){if(!(n=data.length))return data;var series=data.map((function(d,i){return values.call(stack,d,i)})),points=series.map((function(d){return d.map((function(v,i){return[x.call(stack,v,i),y.call(stack,v,i)]}))})),orders=order.call(stack,points,index);series=d3.permute(series,orders),points=d3.permute(points,orders);var n,i,j,o,offsets=offset.call(stack,points,index),m=series[0].length;for(j=0;j<m;++j)for(out.call(stack,series[0][j],o=offsets[j],points[0][j][1]),i=1;i<n;++i)out.call(stack,series[i][j],o+=points[i-1][j][1],points[i][j][1]);return data}return stack.values=function(x){return arguments.length?(values=x,stack):values},stack.order=function(x){return arguments.length?(order="function"==typeof x?x:d3_layout_stackOrders.get(x)||d3_layout_stackOrderDefault,stack):order},stack.offset=function(x){return arguments.length?(offset="function"==typeof x?x:d3_layout_stackOffsets.get(x)||d3_layout_stackOffsetZero,stack):offset},stack.x=function(z){return arguments.length?(x=z,stack):x},stack.y=function(z){return arguments.length?(y=z,stack):y},stack.out=function(z){return arguments.length?(out=z,stack):out},stack};var d3_layout_stackOrders=d3.map({"inside-out":function(data){var i,j,n=data.length,max=data.map(d3_layout_stackMaxIndex),sums=data.map(d3_layout_stackReduceSum),index=d3.range(n).sort((function(a,b){return max[a]-max[b]})),top=0,bottom=0,tops=[],bottoms=[];for(i=0;i<n;++i)j=index[i],top<bottom?(top+=sums[j],tops.push(j)):(bottom+=sums[j],bottoms.push(j));return bottoms.reverse().concat(tops)},reverse:function(data){return d3.range(data.length).reverse()},default:d3_layout_stackOrderDefault}),d3_layout_stackOffsets=d3.map({silhouette:function(data){var i,j,o,n=data.length,m=data[0].length,sums=[],max=0,y0=[];for(j=0;j<m;++j){for(i=0,o=0;i<n;i++)o+=data[i][j][1];o>max&&(max=o),sums.push(o)}for(j=0;j<m;++j)y0[j]=(max-sums[j])/2;return y0},wiggle:function(data){var i,j,k,s1,s2,s3,dx,o,o0,n=data.length,x=data[0],m=x.length,y0=[];for(y0[0]=o=o0=0,j=1;j<m;++j){for(i=0,s1=0;i<n;++i)s1+=data[i][j][1];for(i=0,s2=0,dx=x[j][0]-x[j-1][0];i<n;++i){for(k=0,s3=(data[i][j][1]-data[i][j-1][1])/(2*dx);k<i;++k)s3+=(data[k][j][1]-data[k][j-1][1])/dx;s2+=s3*data[i][j][1]}y0[j]=o-=s1?s2/s1*dx:0,o<o0&&(o0=o)}for(j=0;j<m;++j)y0[j]-=o0;return y0},expand:function(data){var i,j,o,n=data.length,m=data[0].length,k=1/n,y0=[];for(j=0;j<m;++j){for(i=0,o=0;i<n;i++)o+=data[i][j][1];if(o)for(i=0;i<n;i++)data[i][j][1]/=o;else for(i=0;i<n;i++)data[i][j][1]=k}for(j=0;j<m;++j)y0[j]=0;return y0},zero:d3_layout_stackOffsetZero});function d3_layout_stackOrderDefault(data){return d3.range(data.length)}function d3_layout_stackOffsetZero(data){for(var j=-1,m=data[0].length,y0=[];++j<m;)y0[j]=0;return y0}function d3_layout_stackMaxIndex(array){for(var k,i=1,j=0,v=array[0][1],n=array.length;i<n;++i)(k=array[i][1])>v&&(j=i,v=k);return j}function d3_layout_stackReduceSum(d){return d.reduce(d3_layout_stackSum,0)}function d3_layout_stackSum(p,d){return p+d[1]}function d3_layout_histogramBinSturges(range,values){return d3_layout_histogramBinFixed(range,Math.ceil(Math.log(values.length)/Math.LN2+1))}function d3_layout_histogramBinFixed(range,n){for(var x=-1,b=+range[0],m=(range[1]-b)/n,f=[];++x<=n;)f[x]=m*x+b;return f}function d3_layout_histogramRange(values){return[d3.min(values),d3.max(values)]}function d3_layout_packSort(a,b){return a.value-b.value}function d3_layout_packInsert(a,b){var c=a._pack_next;a._pack_next=b,b._pack_prev=a,b._pack_next=c,c._pack_prev=b}function d3_layout_packSplice(a,b){a._pack_next=b,b._pack_prev=a}function d3_layout_packIntersects(a,b){var dx=b.x-a.x,dy=b.y-a.y,dr=a.r+b.r;return.999*dr*dr>dx*dx+dy*dy}function d3_layout_packSiblings(node){if((nodes=node.children)&&(n=nodes.length)){var nodes,a,b,c,i,j,k,n,xMin=1/0,xMax=-1/0,yMin=1/0,yMax=-1/0;if(nodes.forEach(d3_layout_packLink),(a=nodes[0]).x=-a.r,a.y=0,bound(a),n>1&&((b=nodes[1]).x=b.r,b.y=0,bound(b),n>2))for(d3_layout_packPlace(a,b,c=nodes[2]),bound(c),d3_layout_packInsert(a,c),a._pack_prev=c,d3_layout_packInsert(c,b),b=a._pack_next,i=3;i<n;i++){d3_layout_packPlace(a,b,c=nodes[i]);var isect=0,s1=1,s2=1;for(j=b._pack_next;j!==b;j=j._pack_next,s1++)if(d3_layout_packIntersects(j,c)){isect=1;break}if(1==isect)for(k=a._pack_prev;k!==j._pack_prev&&!d3_layout_packIntersects(k,c);k=k._pack_prev,s2++);isect?(s1<s2||s1==s2&&b.r<a.r?d3_layout_packSplice(a,b=j):d3_layout_packSplice(a=k,b),i--):(d3_layout_packInsert(a,c),b=c,bound(c))}var cx=(xMin+xMax)/2,cy=(yMin+yMax)/2,cr=0;for(i=0;i<n;i++)(c=nodes[i]).x-=cx,c.y-=cy,cr=Math.max(cr,c.r+Math.sqrt(c.x*c.x+c.y*c.y));node.r=cr,nodes.forEach(d3_layout_packUnlink)}function bound(node){xMin=Math.min(node.x-node.r,xMin),xMax=Math.max(node.x+node.r,xMax),yMin=Math.min(node.y-node.r,yMin),yMax=Math.max(node.y+node.r,yMax)}}function d3_layout_packLink(node){node._pack_next=node._pack_prev=node}function d3_layout_packUnlink(node){delete node._pack_next,delete node._pack_prev}function d3_layout_packPlace(a,b,c){var db=a.r+c.r,dx=b.x-a.x,dy=b.y-a.y;if(db&&(dx||dy)){var da=b.r+c.r,dc=dx*dx+dy*dy,x=.5+((db*=db)-(da*=da))/(2*dc),y=Math.sqrt(Math.max(0,2*da*(db+dc)-(db-=dc)*db-da*da))/(2*dc);c.x=a.x+x*dx+y*dy,c.y=a.y+x*dy-y*dx}else c.x=a.x+db,c.y=a.y}function d3_layout_treeSeparation(a,b){return a.parent==b.parent?1:2}function d3_layout_treeLeft(v){var children=v.children;return children.length?children[0]:v.t}function d3_layout_treeRight(v){var n,children=v.children;return(n=children.length)?children[n-1]:v.t}function d3_layout_treeMove(wm,wp,shift){var change=shift/(wp.i-wm.i);wp.c-=change,wp.s+=shift,wm.c+=change,wp.z+=shift,wp.m+=shift}function d3_layout_treeAncestor(vim,v,ancestor){return vim.a.parent===v.parent?vim.a:ancestor}function d3_layout_treemapPadNull(node){return{x:node.x,y:node.y,dx:node.dx,dy:node.dy}}function d3_layout_treemapPad(node,padding){var x=node.x+padding[3],y=node.y+padding[0],dx=node.dx-padding[1]-padding[3],dy=node.dy-padding[0]-padding[2];return dx<0&&(x+=dx/2,dx=0),dy<0&&(y+=dy/2,dy=0),{x:x,y:y,dx:dx,dy:dy}}function d3_scaleExtent(domain){var start=domain[0],stop=domain[domain.length-1];return start<stop?[start,stop]:[stop,start]}function d3_scaleRange(scale){return scale.rangeExtent?scale.rangeExtent():d3_scaleExtent(scale.range())}function d3_scale_bilinear(domain,range,uninterpolate,interpolate){var u=uninterpolate(domain[0],domain[1]),i=interpolate(range[0],range[1]);return function(x){return i(u(x))}}function d3_scale_nice(domain,nice){var dx,i0=0,i1=domain.length-1,x0=domain[i0],x1=domain[i1];return x1<x0&&(dx=i0,i0=i1,i1=dx,dx=x0,x0=x1,x1=dx),domain[i0]=nice.floor(x0),domain[i1]=nice.ceil(x1),domain}function d3_scale_niceStep(step){return step?{floor:function(x){return Math.floor(x/step)*step},ceil:function(x){return Math.ceil(x/step)*step}}:d3_scale_niceIdentity}d3.layout.histogram=function(){var frequency=!0,valuer=Number,ranger=d3_layout_histogramRange,binner=d3_layout_histogramBinSturges;function histogram(data,i){for(var bin,x,bins=[],values=data.map(valuer,this),range=ranger.call(this,values,i),thresholds=binner.call(this,range,values,i),n=(i=-1,values.length),m=thresholds.length-1,k=frequency?1:1/n;++i<m;)(bin=bins[i]=[]).dx=thresholds[i+1]-(bin.x=thresholds[i]),bin.y=0;if(m>0)for(i=-1;++i<n;)(x=values[i])>=range[0]&&x<=range[1]&&((bin=bins[d3.bisect(thresholds,x,1,m)-1]).y+=k,bin.push(data[i]));return bins}return histogram.value=function(x){return arguments.length?(valuer=x,histogram):valuer},histogram.range=function(x){return arguments.length?(ranger=d3_functor(x),histogram):ranger},histogram.bins=function(x){return arguments.length?(binner="number"==typeof x?function(range){return d3_layout_histogramBinFixed(range,x)}:d3_functor(x),histogram):binner},histogram.frequency=function(x){return arguments.length?(frequency=!!x,histogram):frequency},histogram},d3.layout.pack=function(){var radius,hierarchy=d3.layout.hierarchy().sort(d3_layout_packSort),padding=0,size=[1,1];function pack(d,i){var nodes=hierarchy.call(this,d,i),root=nodes[0],w=size[0],h=size[1],r=null==radius?Math.sqrt:"function"==typeof radius?radius:function(){return radius};if(root.x=root.y=0,d3_layout_hierarchyVisitAfter(root,(function(d){d.r=+r(d.value)})),d3_layout_hierarchyVisitAfter(root,d3_layout_packSiblings),padding){var dr=padding*(radius?1:Math.max(2*root.r/w,2*root.r/h))/2;d3_layout_hierarchyVisitAfter(root,(function(d){d.r+=dr})),d3_layout_hierarchyVisitAfter(root,d3_layout_packSiblings),d3_layout_hierarchyVisitAfter(root,(function(d){d.r-=dr}))}return function d3_layout_packTransform(node,x,y,k){var children=node.children;if(node.x=x+=k*node.x,node.y=y+=k*node.y,node.r*=k,children)for(var i=-1,n=children.length;++i<n;)d3_layout_packTransform(children[i],x,y,k)}(root,w/2,h/2,radius?1:1/Math.max(2*root.r/w,2*root.r/h)),nodes}return pack.size=function(_){return arguments.length?(size=_,pack):size},pack.radius=function(_){return arguments.length?(radius=null==_||"function"==typeof _?_:+_,pack):radius},pack.padding=function(_){return arguments.length?(padding=+_,pack):padding},d3_layout_hierarchyRebind(pack,hierarchy)},d3.layout.tree=function(){var hierarchy=d3.layout.hierarchy().sort(null).value(null),separation=d3_layout_treeSeparation,size=[1,1],nodeSize=null;function tree(d,i){var nodes=hierarchy.call(this,d,i),root0=nodes[0],root1=function(root0){var node1,root1={A:null,children:[root0]},queue=[root1];for(;null!=(node1=queue.pop());)for(var child,children=node1.children,i=0,n=children.length;i<n;++i)queue.push((children[i]=child={_:children[i],parent:node1,children:(child=children[i].children)&&child.slice()||[],A:null,a:null,z:0,m:0,c:0,s:0,t:null,i:i}).a=child);return root1.children[0]}(root0);if(d3_layout_hierarchyVisitAfter(root1,firstWalk),root1.parent.m=-root1.z,d3_layout_hierarchyVisitBefore(root1,secondWalk),nodeSize)d3_layout_hierarchyVisitBefore(root0,sizeNode);else{var left=root0,right=root0,bottom=root0;d3_layout_hierarchyVisitBefore(root0,(function(node){node.x<left.x&&(left=node),node.x>right.x&&(right=node),node.depth>bottom.depth&&(bottom=node)}));var tx=separation(left,right)/2-left.x,kx=size[0]/(right.x+separation(right,left)/2+tx),ky=size[1]/(bottom.depth||1);d3_layout_hierarchyVisitBefore(root0,(function(node){node.x=(node.x+tx)*kx,node.y=node.depth*ky}))}return nodes}function firstWalk(v){var children=v.children,siblings=v.parent.children,w=v.i?siblings[v.i-1]:null;if(children.length){!function(v){var w,shift=0,change=0,children=v.children,i=children.length;for(;--i>=0;)(w=children[i]).z+=shift,w.m+=shift,shift+=w.s+(change+=w.c)}(v);var midpoint=(children[0].z+children[children.length-1].z)/2;w?(v.z=w.z+separation(v._,w._),v.m=v.z-midpoint):v.z=midpoint}else w&&(v.z=w.z+separation(v._,w._));v.parent.A=function(v,w,ancestor){if(w){for(var shift,vip=v,vop=v,vim=w,vom=vip.parent.children[0],sip=vip.m,sop=vop.m,sim=vim.m,som=vom.m;vim=d3_layout_treeRight(vim),vip=d3_layout_treeLeft(vip),vim&&vip;)vom=d3_layout_treeLeft(vom),(vop=d3_layout_treeRight(vop)).a=v,(shift=vim.z+sim-vip.z-sip+separation(vim._,vip._))>0&&(d3_layout_treeMove(d3_layout_treeAncestor(vim,v,ancestor),v,shift),sip+=shift,sop+=shift),sim+=vim.m,sip+=vip.m,som+=vom.m,sop+=vop.m;vim&&!d3_layout_treeRight(vop)&&(vop.t=vim,vop.m+=sim-sop),vip&&!d3_layout_treeLeft(vom)&&(vom.t=vip,vom.m+=sip-som,ancestor=v)}return ancestor}(v,w,v.parent.A||siblings[0])}function secondWalk(v){v._.x=v.z+v.parent.m,v.m+=v.parent.m}function sizeNode(node){node.x*=size[0],node.y=node.depth*size[1]}return tree.separation=function(x){return arguments.length?(separation=x,tree):separation},tree.size=function(x){return arguments.length?(nodeSize=null==(size=x)?sizeNode:null,tree):nodeSize?null:size},tree.nodeSize=function(x){return arguments.length?(nodeSize=null==(size=x)?null:sizeNode,tree):nodeSize?size:null},d3_layout_hierarchyRebind(tree,hierarchy)},d3.layout.cluster=function(){var hierarchy=d3.layout.hierarchy().sort(null).value(null),separation=d3_layout_treeSeparation,size=[1,1],nodeSize=!1;function cluster(d,i){var previousNode,nodes=hierarchy.call(this,d,i),root=nodes[0],x=0;d3_layout_hierarchyVisitAfter(root,(function(node){var children=node.children;children&&children.length?(node.x=function(children){return children.reduce((function(x,child){return x+child.x}),0)/children.length}(children),node.y=function(children){return 1+d3.max(children,(function(child){return child.y}))}(children)):(node.x=previousNode?x+=separation(node,previousNode):0,node.y=0,previousNode=node)}));var left=function d3_layout_clusterLeft(node){var children=node.children;return children&&children.length?d3_layout_clusterLeft(children[0]):node}(root),right=function d3_layout_clusterRight(node){var n,children=node.children;return children&&(n=children.length)?d3_layout_clusterRight(children[n-1]):node}(root),x0=left.x-separation(left,right)/2,x1=right.x+separation(right,left)/2;return d3_layout_hierarchyVisitAfter(root,nodeSize?function(node){node.x=(node.x-root.x)*size[0],node.y=(root.y-node.y)*size[1]}:function(node){node.x=(node.x-x0)/(x1-x0)*size[0],node.y=(1-(root.y?node.y/root.y:1))*size[1]}),nodes}return cluster.separation=function(x){return arguments.length?(separation=x,cluster):separation},cluster.size=function(x){return arguments.length?(nodeSize=null==(size=x),cluster):nodeSize?null:size},cluster.nodeSize=function(x){return arguments.length?(nodeSize=null!=(size=x),cluster):nodeSize?size:null},d3_layout_hierarchyRebind(cluster,hierarchy)},d3.layout.treemap=function(){var stickies,hierarchy=d3.layout.hierarchy(),round=Math.round,size=[1,1],padding=null,pad=d3_layout_treemapPadNull,sticky=!1,mode="squarify",ratio=.5*(1+Math.sqrt(5));function scale(children,k){for(var child,area,i=-1,n=children.length;++i<n;)area=(child=children[i]).value*(k<0?0:k),child.area=isNaN(area)||area<=0?0:area}function squarify(node){var children=node.children;if(children&&children.length){var child,score,n,rect=pad(node),row=[],remaining=children.slice(),best=1/0,u="slice"===mode?rect.dx:"dice"===mode?rect.dy:"slice-dice"===mode?1&node.depth?rect.dy:rect.dx:Math.min(rect.dx,rect.dy);for(scale(remaining,rect.dx*rect.dy/node.value),row.area=0;(n=remaining.length)>0;)row.push(child=remaining[n-1]),row.area+=child.area,"squarify"!==mode||(score=worst(row,u))<=best?(remaining.pop(),best=score):(row.area-=row.pop().area,position(row,u,rect,!1),u=Math.min(rect.dx,rect.dy),row.length=row.area=0,best=1/0);row.length&&(position(row,u,rect,!0),row.length=row.area=0),children.forEach(squarify)}}function stickify(node){var children=node.children;if(children&&children.length){var child,rect=pad(node),remaining=children.slice(),row=[];for(scale(remaining,rect.dx*rect.dy/node.value),row.area=0;child=remaining.pop();)row.push(child),row.area+=child.area,null!=child.z&&(position(row,child.z?rect.dx:rect.dy,rect,!remaining.length),row.length=row.area=0);children.forEach(stickify)}}function worst(row,u){for(var r,s=row.area,rmax=0,rmin=1/0,i=-1,n=row.length;++i<n;)(r=row[i].area)&&(r<rmin&&(rmin=r),r>rmax&&(rmax=r));return u*=u,(s*=s)?Math.max(u*rmax*ratio/s,s/(u*rmin*ratio)):1/0}function position(row,u,rect,flush){var o,i=-1,n=row.length,x=rect.x,y=rect.y,v=u?round(row.area/u):0;if(u==rect.dx){for((flush||v>rect.dy)&&(v=rect.dy);++i<n;)(o=row[i]).x=x,o.y=y,o.dy=v,x+=o.dx=Math.min(rect.x+rect.dx-x,v?round(o.area/v):0);o.z=!0,o.dx+=rect.x+rect.dx-x,rect.y+=v,rect.dy-=v}else{for((flush||v>rect.dx)&&(v=rect.dx);++i<n;)(o=row[i]).x=x,o.y=y,o.dx=v,y+=o.dy=Math.min(rect.y+rect.dy-y,v?round(o.area/v):0);o.z=!1,o.dy+=rect.y+rect.dy-y,rect.x+=v,rect.dx-=v}}function treemap(d){var nodes=stickies||hierarchy(d),root=nodes[0];return root.x=root.y=0,root.value?(root.dx=size[0],root.dy=size[1]):root.dx=root.dy=0,stickies&&hierarchy.revalue(root),scale([root],root.dx*root.dy/root.value),(stickies?stickify:squarify)(root),sticky&&(stickies=nodes),nodes}return treemap.size=function(x){return arguments.length?(size=x,treemap):size},treemap.padding=function(x){if(!arguments.length)return padding;function padFunction(node){var p=x.call(treemap,node,node.depth);return null==p?d3_layout_treemapPadNull(node):d3_layout_treemapPad(node,"number"==typeof p?[p,p,p,p]:p)}function padConstant(node){return d3_layout_treemapPad(node,x)}var type;return pad=null==(padding=x)?d3_layout_treemapPadNull:"function"==(type=typeof x)?padFunction:"number"===type?(x=[x,x,x,x],padConstant):padConstant,treemap},treemap.round=function(x){return arguments.length?(round=x?Math.round:Number,treemap):round!=Number},treemap.sticky=function(x){return arguments.length?(sticky=x,stickies=null,treemap):sticky},treemap.ratio=function(x){return arguments.length?(ratio=x,treemap):ratio},treemap.mode=function(x){return arguments.length?(mode=x+"",treemap):mode},d3_layout_hierarchyRebind(treemap,hierarchy)},d3.random={normal:function(µ,σ){var n=arguments.length;return n<2&&(σ=1),n<1&&(µ=0),function(){var x,y,r;do{r=(x=2*Math.random()-1)*x+(y=2*Math.random()-1)*y}while(!r||r>1);return µ+σ*x*Math.sqrt(-2*Math.log(r)/r)}},logNormal:function(){var random=d3.random.normal.apply(d3,arguments);return function(){return Math.exp(random())}},bates:function(m){var random=d3.random.irwinHall(m);return function(){return random()/m}},irwinHall:function(m){return function(){for(var s=0,j=0;j<m;j++)s+=Math.random();return s}}},d3.scale={};var d3_scale_niceIdentity={floor:d3_identity,ceil:d3_identity};function d3_scale_polylinear(domain,range,uninterpolate,interpolate){var u=[],i=[],j=0,k=Math.min(domain.length,range.length)-1;for(domain[k]<domain[0]&&(domain=domain.slice().reverse(),range=range.slice().reverse());++j<=k;)u.push(uninterpolate(domain[j-1],domain[j])),i.push(interpolate(range[j-1],range[j]));return function(x){var j=d3.bisect(domain,x,1,k)-1;return i[j](u[j](x))}}function d3_scale_linearRebind(scale,linear){return d3.rebind(scale,linear,"range","rangeRound","interpolate","clamp")}function d3_scale_linearNice(domain,m){return d3_scale_nice(domain,d3_scale_niceStep(d3_scale_linearTickRange(domain,m)[2])),d3_scale_nice(domain,d3_scale_niceStep(d3_scale_linearTickRange(domain,m)[2])),domain}function d3_scale_linearTickRange(domain,m){null==m&&(m=10);var extent=d3_scaleExtent(domain),span=extent[1]-extent[0],step=Math.pow(10,Math.floor(Math.log(span/m)/Math.LN10)),err=m/span*step;return err<=.15?step*=10:err<=.35?step*=5:err<=.75&&(step*=2),extent[0]=Math.ceil(extent[0]/step)*step,extent[1]=Math.floor(extent[1]/step)*step+.5*step,extent[2]=step,extent}function d3_scale_linearTicks(domain,m){return d3.range.apply(d3,d3_scale_linearTickRange(domain,m))}function d3_scale_linearTickFormat(domain,m,format){var range=d3_scale_linearTickRange(domain,m);if(format){var match=d3_format_re.exec(format);if(match.shift(),"s"===match[8]){var prefix=d3.formatPrefix(Math.max(abs(range[0]),abs(range[1])));return match[7]||(match[7]="."+d3_scale_linearPrecision(prefix.scale(range[2]))),match[8]="f",format=d3.format(match.join("")),function(d){return format(prefix.scale(d))+prefix.symbol}}match[7]||(match[7]="."+function(type,range){var p=d3_scale_linearPrecision(range[2]);return type in d3_scale_linearFormatSignificant?Math.abs(p-d3_scale_linearPrecision(Math.max(abs(range[0]),abs(range[1]))))+ +("e"!==type):p-2*("%"===type)}(match[8],range)),format=match.join("")}else format=",."+d3_scale_linearPrecision(range[2])+"f";return d3.format(format)}d3.scale.linear=function(){return function d3_scale_linear(domain,range,interpolate,clamp){var output,input;function rescale(){var linear=Math.min(domain.length,range.length)>2?d3_scale_polylinear:d3_scale_bilinear,uninterpolate=clamp?d3_uninterpolateClamp:d3_uninterpolateNumber;return output=linear(domain,range,uninterpolate,interpolate),input=linear(range,domain,uninterpolate,d3_interpolate),scale}function scale(x){return output(x)}return scale.invert=function(y){return input(y)},scale.domain=function(x){return arguments.length?(domain=x.map(Number),rescale()):domain},scale.range=function(x){return arguments.length?(range=x,rescale()):range},scale.rangeRound=function(x){return scale.range(x).interpolate(d3_interpolateRound)},scale.clamp=function(x){return arguments.length?(clamp=x,rescale()):clamp},scale.interpolate=function(x){return arguments.length?(interpolate=x,rescale()):interpolate},scale.ticks=function(m){return d3_scale_linearTicks(domain,m)},scale.tickFormat=function(m,format){return d3_scale_linearTickFormat(domain,m,format)},scale.nice=function(m){return d3_scale_linearNice(domain,m),rescale()},scale.copy=function(){return d3_scale_linear(domain,range,interpolate,clamp)},rescale()}([0,1],[0,1],d3_interpolate,!1)};var d3_scale_linearFormatSignificant={s:1,g:1,p:1,r:1,e:1};function d3_scale_linearPrecision(value){return-Math.floor(Math.log(value)/Math.LN10+.01)}d3.scale.log=function(){return function d3_scale_log(linear,base,positive,domain){function log(x){return(positive?Math.log(x<0?0:x):-Math.log(x>0?0:-x))/Math.log(base)}function pow(x){return positive?Math.pow(base,x):-Math.pow(base,-x)}function scale(x){return linear(log(x))}return scale.invert=function(x){return pow(linear.invert(x))},scale.domain=function(x){return arguments.length?(positive=x[0]>=0,linear.domain((domain=x.map(Number)).map(log)),scale):domain},scale.base=function(_){return arguments.length?(base=+_,linear.domain(domain.map(log)),scale):base},scale.nice=function(){var niced=d3_scale_nice(domain.map(log),positive?Math:d3_scale_logNiceNegative);return linear.domain(niced),domain=niced.map(pow),scale},scale.ticks=function(){var extent=d3_scaleExtent(domain),ticks=[],u=extent[0],v=extent[1],i=Math.floor(log(u)),j=Math.ceil(log(v)),n=base%1?2:base;if(isFinite(j-i)){if(positive){for(;i<j;i++)for(var k=1;k<n;k++)ticks.push(pow(i)*k);ticks.push(pow(i))}else for(ticks.push(pow(i));i++<j;)for(k=n-1;k>0;k--)ticks.push(pow(i)*k);for(i=0;ticks[i]<u;i++);for(j=ticks.length;ticks[j-1]>v;j--);ticks=ticks.slice(i,j)}return ticks},scale.tickFormat=function(n,format){if(!arguments.length)return d3_scale_logFormat;arguments.length<2?format=d3_scale_logFormat:"function"!=typeof format&&(format=d3.format(format));var k=Math.max(1,base*n/scale.ticks().length);return function(d){var i=d/pow(Math.round(log(d)));return i*base<base-.5&&(i*=base),i<=k?format(d):""}},scale.copy=function(){return d3_scale_log(linear.copy(),base,positive,domain)},d3_scale_linearRebind(scale,linear)}(d3.scale.linear().domain([0,1]),10,!0,[1,10])};var d3_scale_logFormat=d3.format(".0e"),d3_scale_logNiceNegative={floor:function(x){return-Math.ceil(-x)},ceil:function(x){return-Math.floor(-x)}};function d3_scale_powPow(e){return function(x){return x<0?-Math.pow(-x,e):Math.pow(x,e)}}d3.scale.pow=function(){return function d3_scale_pow(linear,exponent,domain){var powp=d3_scale_powPow(exponent),powb=d3_scale_powPow(1/exponent);function scale(x){return linear(powp(x))}return scale.invert=function(x){return powb(linear.invert(x))},scale.domain=function(x){return arguments.length?(linear.domain((domain=x.map(Number)).map(powp)),scale):domain},scale.ticks=function(m){return d3_scale_linearTicks(domain,m)},scale.tickFormat=function(m,format){return d3_scale_linearTickFormat(domain,m,format)},scale.nice=function(m){return scale.domain(d3_scale_linearNice(domain,m))},scale.exponent=function(x){return arguments.length?(powp=d3_scale_powPow(exponent=x),powb=d3_scale_powPow(1/exponent),linear.domain(domain.map(powp)),scale):exponent},scale.copy=function(){return d3_scale_pow(linear.copy(),exponent,domain)},d3_scale_linearRebind(scale,linear)}(d3.scale.linear(),1,[0,1])},d3.scale.sqrt=function(){return d3.scale.pow().exponent(.5)},d3.scale.ordinal=function(){return function d3_scale_ordinal(domain,ranger){var index,range,rangeBand;function scale(x){return range[((index.get(x)||("range"===ranger.t?index.set(x,domain.push(x)):NaN))-1)%range.length]}function steps(start,step){return d3.range(domain.length).map((function(i){return start+step*i}))}return scale.domain=function(x){if(!arguments.length)return domain;domain=[],index=new d3_Map;for(var xi,i=-1,n=x.length;++i<n;)index.has(xi=x[i])||index.set(xi,domain.push(xi));return scale[ranger.t].apply(scale,ranger.a)},scale.range=function(x){return arguments.length?(range=x,rangeBand=0,ranger={t:"range",a:arguments},scale):range},scale.rangePoints=function(x,padding){arguments.length<2&&(padding=0);var start=x[0],stop=x[1],step=domain.length<2?(start=(start+stop)/2,0):(stop-start)/(domain.length-1+padding);return range=steps(start+step*padding/2,step),rangeBand=0,ranger={t:"rangePoints",a:arguments},scale},scale.rangeRoundPoints=function(x,padding){arguments.length<2&&(padding=0);var start=x[0],stop=x[1],step=domain.length<2?(start=stop=Math.round((start+stop)/2),0):(stop-start)/(domain.length-1+padding)|0;return range=steps(start+Math.round(step*padding/2+(stop-start-(domain.length-1+padding)*step)/2),step),rangeBand=0,ranger={t:"rangeRoundPoints",a:arguments},scale},scale.rangeBands=function(x,padding,outerPadding){arguments.length<2&&(padding=0),arguments.length<3&&(outerPadding=padding);var reverse=x[1]<x[0],start=x[reverse-0],stop=x[1-reverse],step=(stop-start)/(domain.length-padding+2*outerPadding);return range=steps(start+step*outerPadding,step),reverse&&range.reverse(),rangeBand=step*(1-padding),ranger={t:"rangeBands",a:arguments},scale},scale.rangeRoundBands=function(x,padding,outerPadding){arguments.length<2&&(padding=0),arguments.length<3&&(outerPadding=padding);var reverse=x[1]<x[0],start=x[reverse-0],stop=x[1-reverse],step=Math.floor((stop-start)/(domain.length-padding+2*outerPadding));return range=steps(start+Math.round((stop-start-(domain.length-padding)*step)/2),step),reverse&&range.reverse(),rangeBand=Math.round(step*(1-padding)),ranger={t:"rangeRoundBands",a:arguments},scale},scale.rangeBand=function(){return rangeBand},scale.rangeExtent=function(){return d3_scaleExtent(ranger.a[0])},scale.copy=function(){return d3_scale_ordinal(domain,ranger)},scale.domain(domain)}([],{t:"range",a:[[]]})},d3.scale.category10=function(){return d3.scale.ordinal().range(d3_category10)},d3.scale.category20=function(){return d3.scale.ordinal().range(d3_category20)},d3.scale.category20b=function(){return d3.scale.ordinal().range(d3_category20b)},d3.scale.category20c=function(){return d3.scale.ordinal().range(d3_category20c)};var d3_category10=[2062260,16744206,2924588,14034728,9725885,9197131,14907330,8355711,12369186,1556175].map(d3_rgbString),d3_category20=[2062260,11454440,16744206,16759672,2924588,10018698,14034728,16750742,9725885,12955861,9197131,12885140,14907330,16234194,8355711,13092807,12369186,14408589,1556175,10410725].map(d3_rgbString),d3_category20b=[3750777,5395619,7040719,10264286,6519097,9216594,11915115,13556636,9202993,12426809,15186514,15190932,8666169,11356490,14049643,15177372,8077683,10834324,13528509,14589654].map(d3_rgbString),d3_category20c=[3244733,7057110,10406625,13032431,15095053,16616764,16625259,16634018,3253076,7652470,10607003,13101504,7695281,10394312,12369372,14342891,6513507,9868950,12434877,14277081].map(d3_rgbString);function d3_zero(){return 0}d3.scale.quantile=function(){return function d3_scale_quantile(domain,range){var thresholds;function rescale(){var k=0,q=range.length;for(thresholds=[];++k<q;)thresholds[k-1]=d3.quantile(domain,k/q);return scale}function scale(x){if(!isNaN(x=+x))return range[d3.bisect(thresholds,x)]}return scale.domain=function(x){return arguments.length?(domain=x.map(d3_number).filter(d3_numeric).sort(d3_ascending),rescale()):domain},scale.range=function(x){return arguments.length?(range=x,rescale()):range},scale.quantiles=function(){return thresholds},scale.invertExtent=function(y){return(y=range.indexOf(y))<0?[NaN,NaN]:[y>0?thresholds[y-1]:domain[0],y<thresholds.length?thresholds[y]:domain[domain.length-1]]},scale.copy=function(){return d3_scale_quantile(domain,range)},rescale()}([],[])},d3.scale.quantize=function(){return function d3_scale_quantize(x0,x1,range){var kx,i;function scale(x){return range[Math.max(0,Math.min(i,Math.floor(kx*(x-x0))))]}function rescale(){return kx=range.length/(x1-x0),i=range.length-1,scale}return scale.domain=function(x){return arguments.length?(x0=+x[0],x1=+x[x.length-1],rescale()):[x0,x1]},scale.range=function(x){return arguments.length?(range=x,rescale()):range},scale.invertExtent=function(y){return[y=(y=range.indexOf(y))<0?NaN:y/kx+x0,y+1/kx]},scale.copy=function(){return d3_scale_quantize(x0,x1,range)},rescale()}(0,1,[0,1])},d3.scale.threshold=function(){return function d3_scale_threshold(domain,range){function scale(x){if(x<=x)return range[d3.bisect(domain,x)]}return scale.domain=function(_){return arguments.length?(domain=_,scale):domain},scale.range=function(_){return arguments.length?(range=_,scale):range},scale.invertExtent=function(y){return y=range.indexOf(y),[domain[y-1],domain[y]]},scale.copy=function(){return d3_scale_threshold(domain,range)},scale}([.5],[0,1])},d3.scale.identity=function(){return function d3_scale_identity(domain){function identity(x){return+x}return identity.invert=identity,identity.domain=identity.range=function(x){return arguments.length?(domain=x.map(identity),identity):domain},identity.ticks=function(m){return d3_scale_linearTicks(domain,m)},identity.tickFormat=function(m,format){return d3_scale_linearTickFormat(domain,m,format)},identity.copy=function(){return d3_scale_identity(domain)},identity}([0,1])},d3.svg={},d3.svg.arc=function(){var innerRadius=d3_svg_arcInnerRadius,outerRadius=d3_svg_arcOuterRadius,cornerRadius=d3_zero,padRadius=d3_svg_arcAuto,startAngle=d3_svg_arcStartAngle,endAngle=d3_svg_arcEndAngle,padAngle=d3_svg_arcPadAngle;function arc(){var r0=Math.max(0,+innerRadius.apply(this,arguments)),r1=Math.max(0,+outerRadius.apply(this,arguments)),a0=startAngle.apply(this,arguments)-halfπ,a1=endAngle.apply(this,arguments)-halfπ,da=Math.abs(a1-a0),cw=a0>a1?0:1;if(r1<r0&&(rc=r1,r1=r0,r0=rc),da>=τε)return circleSegment(r1,cw)+(r0?circleSegment(r0,1-cw):"")+"Z";var rc,cr,rp,ap,x0,y0,x1,y1,x2,y2,x3,y3,p0=0,p1=0,path=[];if((ap=(+padAngle.apply(this,arguments)||0)/2)&&(rp=padRadius===d3_svg_arcAuto?Math.sqrt(r0*r0+r1*r1):+padRadius.apply(this,arguments),cw||(p1*=-1),r1&&(p1=d3_asin(rp/r1*Math.sin(ap))),r0&&(p0=d3_asin(rp/r0*Math.sin(ap)))),r1){x0=r1*Math.cos(a0+p1),y0=r1*Math.sin(a0+p1),x1=r1*Math.cos(a1-p1),y1=r1*Math.sin(a1-p1);var l1=Math.abs(a1-a0-2*p1)<=π?0:1;if(p1&&d3_svg_arcSweep(x0,y0,x1,y1)===cw^l1){var h1=(a0+a1)/2;x0=r1*Math.cos(h1),y0=r1*Math.sin(h1),x1=y1=null}}else x0=y0=0;if(r0){x2=r0*Math.cos(a1-p0),y2=r0*Math.sin(a1-p0),x3=r0*Math.cos(a0+p0),y3=r0*Math.sin(a0+p0);var l0=Math.abs(a0-a1+2*p0)<=π?0:1;if(p0&&d3_svg_arcSweep(x2,y2,x3,y3)===1-cw^l0){var h0=(a0+a1)/2;x2=r0*Math.cos(h0),y2=r0*Math.sin(h0),x3=y3=null}}else x2=y2=0;if(da>ε&&(rc=Math.min(Math.abs(r1-r0)/2,+cornerRadius.apply(this,arguments)))>.001){cr=r0<r1^cw?0:1;var rc1=rc,rc0=rc;if(da<π){var oc=null==x3?[x2,y2]:null==x1?[x0,y0]:d3_geom_polygonIntersect([x0,y0],[x3,y3],[x1,y1],[x2,y2]),ax=x0-oc[0],ay=y0-oc[1],bx=x1-oc[0],by=y1-oc[1],kc=1/Math.sin(Math.acos((ax*bx+ay*by)/(Math.sqrt(ax*ax+ay*ay)*Math.sqrt(bx*bx+by*by)))/2),lc=Math.sqrt(oc[0]*oc[0]+oc[1]*oc[1]);rc0=Math.min(rc,(r0-lc)/(kc-1)),rc1=Math.min(rc,(r1-lc)/(kc+1))}if(null!=x1){var t30=d3_svg_arcCornerTangents(null==x3?[x2,y2]:[x3,y3],[x0,y0],r1,rc1,cw),t12=d3_svg_arcCornerTangents([x1,y1],[x2,y2],r1,rc1,cw);rc===rc1?path.push("M",t30[0],"A",rc1,",",rc1," 0 0,",cr," ",t30[1],"A",r1,",",r1," 0 ",1-cw^d3_svg_arcSweep(t30[1][0],t30[1][1],t12[1][0],t12[1][1]),",",cw," ",t12[1],"A",rc1,",",rc1," 0 0,",cr," ",t12[0]):path.push("M",t30[0],"A",rc1,",",rc1," 0 1,",cr," ",t12[0])}else path.push("M",x0,",",y0);if(null!=x3){var t03=d3_svg_arcCornerTangents([x0,y0],[x3,y3],r0,-rc0,cw),t21=d3_svg_arcCornerTangents([x2,y2],null==x1?[x0,y0]:[x1,y1],r0,-rc0,cw);rc===rc0?path.push("L",t21[0],"A",rc0,",",rc0," 0 0,",cr," ",t21[1],"A",r0,",",r0," 0 ",cw^d3_svg_arcSweep(t21[1][0],t21[1][1],t03[1][0],t03[1][1]),",",1-cw," ",t03[1],"A",rc0,",",rc0," 0 0,",cr," ",t03[0]):path.push("L",t21[0],"A",rc0,",",rc0," 0 0,",cr," ",t03[0])}else path.push("L",x2,",",y2)}else path.push("M",x0,",",y0),null!=x1&&path.push("A",r1,",",r1," 0 ",l1,",",cw," ",x1,",",y1),path.push("L",x2,",",y2),null!=x3&&path.push("A",r0,",",r0," 0 ",l0,",",1-cw," ",x3,",",y3);return path.push("Z"),path.join("")}function circleSegment(r1,cw){return"M0,"+r1+"A"+r1+","+r1+" 0 1,"+cw+" 0,"+-r1+"A"+r1+","+r1+" 0 1,"+cw+" 0,"+r1}return arc.innerRadius=function(v){return arguments.length?(innerRadius=d3_functor(v),arc):innerRadius},arc.outerRadius=function(v){return arguments.length?(outerRadius=d3_functor(v),arc):outerRadius},arc.cornerRadius=function(v){return arguments.length?(cornerRadius=d3_functor(v),arc):cornerRadius},arc.padRadius=function(v){return arguments.length?(padRadius=v==d3_svg_arcAuto?d3_svg_arcAuto:d3_functor(v),arc):padRadius},arc.startAngle=function(v){return arguments.length?(startAngle=d3_functor(v),arc):startAngle},arc.endAngle=function(v){return arguments.length?(endAngle=d3_functor(v),arc):endAngle},arc.padAngle=function(v){return arguments.length?(padAngle=d3_functor(v),arc):padAngle},arc.centroid=function(){var r=(+innerRadius.apply(this,arguments)+ +outerRadius.apply(this,arguments))/2,a=(+startAngle.apply(this,arguments)+ +endAngle.apply(this,arguments))/2-halfπ;return[Math.cos(a)*r,Math.sin(a)*r]},arc};var d3_svg_arcAuto="auto";function d3_svg_arcInnerRadius(d){return d.innerRadius}function d3_svg_arcOuterRadius(d){return d.outerRadius}function d3_svg_arcStartAngle(d){return d.startAngle}function d3_svg_arcEndAngle(d){return d.endAngle}function d3_svg_arcPadAngle(d){return d&&d.padAngle}function d3_svg_arcSweep(x0,y0,x1,y1){return(x0-x1)*y0-(y0-y1)*x0>0?0:1}function d3_svg_arcCornerTangents(p0,p1,r1,rc,cw){var x01=p0[0]-p1[0],y01=p0[1]-p1[1],lo=(cw?rc:-rc)/Math.sqrt(x01*x01+y01*y01),ox=lo*y01,oy=-lo*x01,x1=p0[0]+ox,y1=p0[1]+oy,x2=p1[0]+ox,y2=p1[1]+oy,x3=(x1+x2)/2,y3=(y1+y2)/2,dx=x2-x1,dy=y2-y1,d2=dx*dx+dy*dy,r=r1-rc,D=x1*y2-x2*y1,d=(dy<0?-1:1)*Math.sqrt(Math.max(0,r*r*d2-D*D)),cx0=(D*dy-dx*d)/d2,cy0=(-D*dx-dy*d)/d2,cx1=(D*dy+dx*d)/d2,cy1=(-D*dx+dy*d)/d2,dx0=cx0-x3,dy0=cy0-y3,dx1=cx1-x3,dy1=cy1-y3;return dx0*dx0+dy0*dy0>dx1*dx1+dy1*dy1&&(cx0=cx1,cy0=cy1),[[cx0-ox,cy0-oy],[cx0*r1/r,cy0*r1/r]]}function d3_svg_line(projection){var x=d3_geom_pointX,y=d3_geom_pointY,defined=d3_true,interpolate=d3_svg_lineLinear,interpolateKey=interpolate.key,tension=.7;function line(data){var d,segments=[],points=[],i=-1,n=data.length,fx=d3_functor(x),fy=d3_functor(y);function segment(){segments.push("M",interpolate(projection(points),tension))}for(;++i<n;)defined.call(this,d=data[i],i)?points.push([+fx.call(this,d,i),+fy.call(this,d,i)]):points.length&&(segment(),points=[]);return points.length&&segment(),segments.length?segments.join(""):null}return line.x=function(_){return arguments.length?(x=_,line):x},line.y=function(_){return arguments.length?(y=_,line):y},line.defined=function(_){return arguments.length?(defined=_,line):defined},line.interpolate=function(_){return arguments.length?(interpolateKey="function"==typeof _?interpolate=_:(interpolate=d3_svg_lineInterpolators.get(_)||d3_svg_lineLinear).key,line):interpolateKey},line.tension=function(_){return arguments.length?(tension=_,line):tension},line}d3.svg.line=function(){return d3_svg_line(d3_identity)};var d3_svg_lineInterpolators=d3.map({linear:d3_svg_lineLinear,"linear-closed":d3_svg_lineLinearClosed,step:function(points){var i=0,n=points.length,p=points[0],path=[p[0],",",p[1]];for(;++i<n;)path.push("H",(p[0]+(p=points[i])[0])/2,"V",p[1]);n>1&&path.push("H",p[0]);return path.join("")},"step-before":d3_svg_lineStepBefore,"step-after":d3_svg_lineStepAfter,basis:d3_svg_lineBasis,"basis-open":function(points){if(points.length<4)return d3_svg_lineLinear(points);var pi,path=[],i=-1,n=points.length,px=[0],py=[0];for(;++i<3;)pi=points[i],px.push(pi[0]),py.push(pi[1]);path.push(d3_svg_lineDot4(d3_svg_lineBasisBezier3,px)+","+d3_svg_lineDot4(d3_svg_lineBasisBezier3,py)),--i;for(;++i<n;)pi=points[i],px.shift(),px.push(pi[0]),py.shift(),py.push(pi[1]),d3_svg_lineBasisBezier(path,px,py);return path.join("")},"basis-closed":function(points){var path,pi,i=-1,n=points.length,m=n+4,px=[],py=[];for(;++i<4;)pi=points[i%n],px.push(pi[0]),py.push(pi[1]);path=[d3_svg_lineDot4(d3_svg_lineBasisBezier3,px),",",d3_svg_lineDot4(d3_svg_lineBasisBezier3,py)],--i;for(;++i<m;)pi=points[i%n],px.shift(),px.push(pi[0]),py.shift(),py.push(pi[1]),d3_svg_lineBasisBezier(path,px,py);return path.join("")},bundle:function(points,tension){var n=points.length-1;if(n)for(var p,t,x0=points[0][0],y0=points[0][1],dx=points[n][0]-x0,dy=points[n][1]-y0,i=-1;++i<=n;)p=points[i],t=i/n,p[0]=tension*p[0]+(1-tension)*(x0+t*dx),p[1]=tension*p[1]+(1-tension)*(y0+t*dy);return d3_svg_lineBasis(points)},cardinal:function(points,tension){return points.length<3?d3_svg_lineLinear(points):points[0]+d3_svg_lineHermite(points,d3_svg_lineCardinalTangents(points,tension))},"cardinal-open":function(points,tension){return points.length<4?d3_svg_lineLinear(points):points[1]+d3_svg_lineHermite(points.slice(1,-1),d3_svg_lineCardinalTangents(points,tension))},"cardinal-closed":function(points,tension){return points.length<3?d3_svg_lineLinearClosed(points):points[0]+d3_svg_lineHermite((points.push(points[0]),points),d3_svg_lineCardinalTangents([points[points.length-2]].concat(points,[points[1]]),tension))},monotone:function(points){return points.length<3?d3_svg_lineLinear(points):points[0]+d3_svg_lineHermite(points,function(points){var d,a,b,s,tangents=[],m=function(points){var i=0,j=points.length-1,m=[],p0=points[0],p1=points[1],d=m[0]=d3_svg_lineSlope(p0,p1);for(;++i<j;)m[i]=(d+(d=d3_svg_lineSlope(p0=p1,p1=points[i+1])))/2;return m[i]=d,m}(points),i=-1,j=points.length-1;for(;++i<j;)d=d3_svg_lineSlope(points[i],points[i+1]),abs(d)<ε?m[i]=m[i+1]=0:(a=m[i]/d,b=m[i+1]/d,(s=a*a+b*b)>9&&(s=3*d/Math.sqrt(s),m[i]=s*a,m[i+1]=s*b));i=-1;for(;++i<=j;)s=(points[Math.min(j,i+1)][0]-points[Math.max(0,i-1)][0])/(6*(1+m[i]*m[i])),tangents.push([s||0,m[i]*s||0]);return tangents}(points))}});function d3_svg_lineLinear(points){return points.length>1?points.join("L"):points+"Z"}function d3_svg_lineLinearClosed(points){return points.join("L")+"Z"}function d3_svg_lineStepBefore(points){for(var i=0,n=points.length,p=points[0],path=[p[0],",",p[1]];++i<n;)path.push("V",(p=points[i])[1],"H",p[0]);return path.join("")}function d3_svg_lineStepAfter(points){for(var i=0,n=points.length,p=points[0],path=[p[0],",",p[1]];++i<n;)path.push("H",(p=points[i])[0],"V",p[1]);return path.join("")}function d3_svg_lineHermite(points,tangents){if(tangents.length<1||points.length!=tangents.length&&points.length!=tangents.length+2)return d3_svg_lineLinear(points);var quad=points.length!=tangents.length,path="",p0=points[0],p=points[1],t0=tangents[0],t=t0,pi=1;if(quad&&(path+="Q"+(p[0]-2*t0[0]/3)+","+(p[1]-2*t0[1]/3)+","+p[0]+","+p[1],p0=points[1],pi=2),tangents.length>1){t=tangents[1],p=points[pi],pi++,path+="C"+(p0[0]+t0[0])+","+(p0[1]+t0[1])+","+(p[0]-t[0])+","+(p[1]-t[1])+","+p[0]+","+p[1];for(var i=2;i<tangents.length;i++,pi++)p=points[pi],t=tangents[i],path+="S"+(p[0]-t[0])+","+(p[1]-t[1])+","+p[0]+","+p[1]}if(quad){var lp=points[pi];path+="Q"+(p[0]+2*t[0]/3)+","+(p[1]+2*t[1]/3)+","+lp[0]+","+lp[1]}return path}function d3_svg_lineCardinalTangents(points,tension){for(var p0,tangents=[],a=(1-tension)/2,p1=points[0],p2=points[1],i=1,n=points.length;++i<n;)p0=p1,p1=p2,p2=points[i],tangents.push([a*(p2[0]-p0[0]),a*(p2[1]-p0[1])]);return tangents}function d3_svg_lineBasis(points){if(points.length<3)return d3_svg_lineLinear(points);var i=1,n=points.length,pi=points[0],x0=pi[0],y0=pi[1],px=[x0,x0,x0,(pi=points[1])[0]],py=[y0,y0,y0,pi[1]],path=[x0,",",y0,"L",d3_svg_lineDot4(d3_svg_lineBasisBezier3,px),",",d3_svg_lineDot4(d3_svg_lineBasisBezier3,py)];for(points.push(points[n-1]);++i<=n;)pi=points[i],px.shift(),px.push(pi[0]),py.shift(),py.push(pi[1]),d3_svg_lineBasisBezier(path,px,py);return points.pop(),path.push("L",pi),path.join("")}function d3_svg_lineDot4(a,b){return a[0]*b[0]+a[1]*b[1]+a[2]*b[2]+a[3]*b[3]}d3_svg_lineInterpolators.forEach((function(key,value){value.key=key,value.closed=/-closed$/.test(key)}));var d3_svg_lineBasisBezier1=[0,2/3,1/3,0],d3_svg_lineBasisBezier2=[0,1/3,2/3,0],d3_svg_lineBasisBezier3=[0,1/6,2/3,1/6];function d3_svg_lineBasisBezier(path,x,y){path.push("C",d3_svg_lineDot4(d3_svg_lineBasisBezier1,x),",",d3_svg_lineDot4(d3_svg_lineBasisBezier1,y),",",d3_svg_lineDot4(d3_svg_lineBasisBezier2,x),",",d3_svg_lineDot4(d3_svg_lineBasisBezier2,y),",",d3_svg_lineDot4(d3_svg_lineBasisBezier3,x),",",d3_svg_lineDot4(d3_svg_lineBasisBezier3,y))}function d3_svg_lineSlope(p0,p1){return(p1[1]-p0[1])/(p1[0]-p0[0])}function d3_svg_lineRadial(points){for(var point,r,a,i=-1,n=points.length;++i<n;)r=(point=points[i])[0],a=point[1]-halfπ,point[0]=r*Math.cos(a),point[1]=r*Math.sin(a);return points}function d3_svg_area(projection){var x0=d3_geom_pointX,x1=d3_geom_pointX,y0=0,y1=d3_geom_pointY,defined=d3_true,interpolate=d3_svg_lineLinear,interpolateKey=interpolate.key,interpolateReverse=interpolate,L="L",tension=.7;function area(data){var d,x,y,segments=[],points0=[],points1=[],i=-1,n=data.length,fx0=d3_functor(x0),fy0=d3_functor(y0),fx1=x0===x1?function(){return x}:d3_functor(x1),fy1=y0===y1?function(){return y}:d3_functor(y1);function segment(){segments.push("M",interpolate(projection(points1),tension),L,interpolateReverse(projection(points0.reverse()),tension),"Z")}for(;++i<n;)defined.call(this,d=data[i],i)?(points0.push([x=+fx0.call(this,d,i),y=+fy0.call(this,d,i)]),points1.push([+fx1.call(this,d,i),+fy1.call(this,d,i)])):points0.length&&(segment(),points0=[],points1=[]);return points0.length&&segment(),segments.length?segments.join(""):null}return area.x=function(_){return arguments.length?(x0=x1=_,area):x1},area.x0=function(_){return arguments.length?(x0=_,area):x0},area.x1=function(_){return arguments.length?(x1=_,area):x1},area.y=function(_){return arguments.length?(y0=y1=_,area):y1},area.y0=function(_){return arguments.length?(y0=_,area):y0},area.y1=function(_){return arguments.length?(y1=_,area):y1},area.defined=function(_){return arguments.length?(defined=_,area):defined},area.interpolate=function(_){return arguments.length?(interpolateKey="function"==typeof _?interpolate=_:(interpolate=d3_svg_lineInterpolators.get(_)||d3_svg_lineLinear).key,interpolateReverse=interpolate.reverse||interpolate,L=interpolate.closed?"M":"L",area):interpolateKey},area.tension=function(_){return arguments.length?(tension=_,area):tension},area}function d3_svg_chordRadius(d){return d.radius}function d3_svg_diagonalProjection(d){return[d.x,d.y]}function d3_svg_diagonalRadialProjection(projection){return function(){var d=projection.apply(this,arguments),r=d[0],a=d[1]-halfπ;return[r*Math.cos(a),r*Math.sin(a)]}}function d3_svg_symbolSize(){return 64}function d3_svg_symbolType(){return"circle"}function d3_svg_symbolCircle(size){var r=Math.sqrt(size/π);return"M0,"+r+"A"+r+","+r+" 0 1,1 0,"+-r+"A"+r+","+r+" 0 1,1 0,"+r+"Z"}d3.svg.line.radial=function(){var line=d3_svg_line(d3_svg_lineRadial);return line.radius=line.x,delete line.x,line.angle=line.y,delete line.y,line},d3_svg_lineStepBefore.reverse=d3_svg_lineStepAfter,d3_svg_lineStepAfter.reverse=d3_svg_lineStepBefore,d3.svg.area=function(){return d3_svg_area(d3_identity)},d3.svg.area.radial=function(){var area=d3_svg_area(d3_svg_lineRadial);return area.radius=area.x,delete area.x,area.innerRadius=area.x0,delete area.x0,area.outerRadius=area.x1,delete area.x1,area.angle=area.y,delete area.y,area.startAngle=area.y0,delete area.y0,area.endAngle=area.y1,delete area.y1,area},d3.svg.chord=function(){var source=d3_source,target=d3_target,radius=d3_svg_chordRadius,startAngle=d3_svg_arcStartAngle,endAngle=d3_svg_arcEndAngle;function chord(d,i){var a,b,s=subgroup(this,source,d,i),t=subgroup(this,target,d,i);return"M"+s.p0+arc(s.r,s.p1,s.a1-s.a0)+(b=t,((a=s).a0==b.a0&&a.a1==b.a1?curve(s.r,s.p1,s.r,s.p0):curve(s.r,s.p1,t.r,t.p0)+arc(t.r,t.p1,t.a1-t.a0)+curve(t.r,t.p1,s.r,s.p0))+"Z")}function subgroup(self,f,d,i){var subgroup=f.call(self,d,i),r=radius.call(self,subgroup,i),a0=startAngle.call(self,subgroup,i)-halfπ,a1=endAngle.call(self,subgroup,i)-halfπ;return{r:r,a0:a0,a1:a1,p0:[r*Math.cos(a0),r*Math.sin(a0)],p1:[r*Math.cos(a1),r*Math.sin(a1)]}}function arc(r,p,a){return"A"+r+","+r+" 0 "+ +(a>π)+",1 "+p}function curve(r0,p0,r1,p1){return"Q 0,0 "+p1}return chord.radius=function(v){return arguments.length?(radius=d3_functor(v),chord):radius},chord.source=function(v){return arguments.length?(source=d3_functor(v),chord):source},chord.target=function(v){return arguments.length?(target=d3_functor(v),chord):target},chord.startAngle=function(v){return arguments.length?(startAngle=d3_functor(v),chord):startAngle},chord.endAngle=function(v){return arguments.length?(endAngle=d3_functor(v),chord):endAngle},chord},d3.svg.diagonal=function(){var source=d3_source,target=d3_target,projection=d3_svg_diagonalProjection;function diagonal(d,i){var p0=source.call(this,d,i),p3=target.call(this,d,i),m=(p0.y+p3.y)/2,p=[p0,{x:p0.x,y:m},{x:p3.x,y:m},p3];return"M"+(p=p.map(projection))[0]+"C"+p[1]+" "+p[2]+" "+p[3]}return diagonal.source=function(x){return arguments.length?(source=d3_functor(x),diagonal):source},diagonal.target=function(x){return arguments.length?(target=d3_functor(x),diagonal):target},diagonal.projection=function(x){return arguments.length?(projection=x,diagonal):projection},diagonal},d3.svg.diagonal.radial=function(){var diagonal=d3.svg.diagonal(),projection=d3_svg_diagonalProjection,projection_=diagonal.projection;return diagonal.projection=function(x){return arguments.length?projection_(d3_svg_diagonalRadialProjection(projection=x)):projection},diagonal},d3.svg.symbol=function(){var type=d3_svg_symbolType,size=d3_svg_symbolSize;function symbol(d,i){return(d3_svg_symbols.get(type.call(this,d,i))||d3_svg_symbolCircle)(size.call(this,d,i))}return symbol.type=function(x){return arguments.length?(type=d3_functor(x),symbol):type},symbol.size=function(x){return arguments.length?(size=d3_functor(x),symbol):size},symbol};var d3_svg_symbols=d3.map({circle:d3_svg_symbolCircle,cross:function(size){var r=Math.sqrt(size/5)/2;return"M"+-3*r+","+-r+"H"+-r+"V"+-3*r+"H"+r+"V"+-r+"H"+3*r+"V"+r+"H"+r+"V"+3*r+"H"+-r+"V"+r+"H"+-3*r+"Z"},diamond:function(size){var ry=Math.sqrt(size/(2*d3_svg_symbolTan30)),rx=ry*d3_svg_symbolTan30;return"M0,"+-ry+"L"+rx+",0 0,"+ry+" "+-rx+",0Z"},square:function(size){var r=Math.sqrt(size)/2;return"M"+-r+","+-r+"L"+r+","+-r+" "+r+","+r+" "+-r+","+r+"Z"},"triangle-down":function(size){var rx=Math.sqrt(size/d3_svg_symbolSqrt3),ry=rx*d3_svg_symbolSqrt3/2;return"M0,"+ry+"L"+rx+","+-ry+" "+-rx+","+-ry+"Z"},"triangle-up":function(size){var rx=Math.sqrt(size/d3_svg_symbolSqrt3),ry=rx*d3_svg_symbolSqrt3/2;return"M0,"+-ry+"L"+rx+","+ry+" "+-rx+","+ry+"Z"}});d3.svg.symbolTypes=d3_svg_symbols.keys();var d3_svg_symbolSqrt3=Math.sqrt(3),d3_svg_symbolTan30=Math.tan(30*d3_radians);d3_selectionPrototype.transition=function(name){for(var subgroup,node,id=d3_transitionInheritId||++d3_transitionId,ns=d3_transitionNamespace(name),subgroups=[],transition=d3_transitionInherit||{time:Date.now(),ease:d3_ease_cubicInOut,delay:0,duration:250},j=-1,m=this.length;++j<m;){subgroups.push(subgroup=[]);for(var group=this[j],i=-1,n=group.length;++i<n;)(node=group[i])&&d3_transitionNode(node,i,ns,id,transition),subgroup.push(node)}return d3_transition(subgroups,ns,id)},d3_selectionPrototype.interrupt=function(name){return this.each(null==name?d3_selection_interrupt:d3_selection_interruptNS(d3_transitionNamespace(name)))};var d3_selection_interrupt=d3_selection_interruptNS(d3_transitionNamespace());function d3_selection_interruptNS(ns){return function(){var lock,activeId,active;(lock=this[ns])&&(active=lock[activeId=lock.active])&&(active.timer.c=null,active.timer.t=NaN,--lock.count?delete lock[activeId]:delete this[ns],lock.active+=.5,active.event&&active.event.interrupt.call(this,this.__data__,active.index))}}function d3_transition(groups,ns,id){return d3_subclass(groups,d3_transitionPrototype),groups.namespace=ns,groups.id=id,groups}var d3_transitionInheritId,d3_transitionInherit,d3_transitionPrototype=[],d3_transitionId=0;function d3_transition_tween(groups,name,value,tween){var id=groups.id,ns=groups.namespace;return d3_selection_each(groups,"function"==typeof value?function(node,i,j){node[ns][id].tween.set(name,tween(value.call(node,node.__data__,i,j)))}:(value=tween(value),function(node){node[ns][id].tween.set(name,value)}))}function d3_transition_text(b){return null==b&&(b=""),function(){this.textContent=b}}function d3_transitionNamespace(name){return null==name?"__transition__":"__transition_"+name+"__"}function d3_transitionNode(node,i,ns,id,inherit){var time,timer,duration,ease,tweens,lock=node[ns]||(node[ns]={active:0,count:0}),transition=lock[id];function start(elapsed){var activeId=lock.active,active=lock[activeId];for(var cancelId in active&&(active.timer.c=null,active.timer.t=NaN,--lock.count,delete lock[activeId],active.event&&active.event.interrupt.call(node,node.__data__,active.index)),lock)if(+cancelId<id){var cancel=lock[cancelId];cancel.timer.c=null,cancel.timer.t=NaN,--lock.count,delete lock[cancelId]}timer.c=tick,d3_timer((function(){return timer.c&&tick(elapsed||1)&&(timer.c=null,timer.t=NaN),1}),0,time),lock.active=id,transition.event&&transition.event.start.call(node,node.__data__,i),tweens=[],transition.tween.forEach((function(key,value){(value=value.call(node,node.__data__,i))&&tweens.push(value)})),ease=transition.ease,duration=transition.duration}function tick(elapsed){for(var t=elapsed/duration,e=ease(t),n=tweens.length;n>0;)tweens[--n].call(node,e);if(t>=1)return transition.event&&transition.event.end.call(node,node.__data__,i),--lock.count?delete lock[id]:delete node[ns],1}transition||(time=inherit.time,timer=d3_timer((function(elapsed){var delay=transition.delay;if(timer.t=delay+time,delay<=elapsed)return start(elapsed-delay);timer.c=start}),0,time),transition=lock[id]={tween:new d3_Map,time:time,timer:timer,delay:inherit.delay,duration:inherit.duration,ease:inherit.ease,index:i},inherit=null,++lock.count)}d3_transitionPrototype.call=d3_selectionPrototype.call,d3_transitionPrototype.empty=d3_selectionPrototype.empty,d3_transitionPrototype.node=d3_selectionPrototype.node,d3_transitionPrototype.size=d3_selectionPrototype.size,d3.transition=function(selection,name){return selection&&selection.transition?d3_transitionInheritId?selection.transition(name):selection:d3.selection().transition(selection)},d3.transition.prototype=d3_transitionPrototype,d3_transitionPrototype.select=function(selector){var subgroup,subnode,node,id=this.id,ns=this.namespace,subgroups=[];selector=d3_selection_selector(selector);for(var j=-1,m=this.length;++j<m;){subgroups.push(subgroup=[]);for(var group=this[j],i=-1,n=group.length;++i<n;)(node=group[i])&&(subnode=selector.call(node,node.__data__,i,j))?("__data__"in node&&(subnode.__data__=node.__data__),d3_transitionNode(subnode,i,ns,id,node[ns][id]),subgroup.push(subnode)):subgroup.push(null)}return d3_transition(subgroups,ns,id)},d3_transitionPrototype.selectAll=function(selector){var subgroup,subnodes,node,subnode,transition,id=this.id,ns=this.namespace,subgroups=[];selector=d3_selection_selectorAll(selector);for(var j=-1,m=this.length;++j<m;)for(var group=this[j],i=-1,n=group.length;++i<n;)if(node=group[i]){transition=node[ns][id],subnodes=selector.call(node,node.__data__,i,j),subgroups.push(subgroup=[]);for(var k=-1,o=subnodes.length;++k<o;)(subnode=subnodes[k])&&d3_transitionNode(subnode,k,ns,id,transition),subgroup.push(subnode)}return d3_transition(subgroups,ns,id)},d3_transitionPrototype.filter=function(filter){var subgroup,node,subgroups=[];"function"!=typeof filter&&(filter=d3_selection_filter(filter));for(var j=0,m=this.length;j<m;j++){subgroups.push(subgroup=[]);for(var group,i=0,n=(group=this[j]).length;i<n;i++)(node=group[i])&&filter.call(node,node.__data__,i,j)&&subgroup.push(node)}return d3_transition(subgroups,this.namespace,this.id)},d3_transitionPrototype.tween=function(name,tween){var id=this.id,ns=this.namespace;return arguments.length<2?this.node()[ns][id].tween.get(name):d3_selection_each(this,null==tween?function(node){node[ns][id].tween.remove(name)}:function(node){node[ns][id].tween.set(name,tween)})},d3_transitionPrototype.attr=function(nameNS,value){if(arguments.length<2){for(value in nameNS)this.attr(value,nameNS[value]);return this}var interpolate="transform"==nameNS?d3_interpolateTransform:d3_interpolate,name=d3.ns.qualify(nameNS);function attrNull(){this.removeAttribute(name)}function attrNullNS(){this.removeAttributeNS(name.space,name.local)}function attrTween(b){return null==b?attrNull:(b+="",function(){var i,a=this.getAttribute(name);return a!==b&&(i=interpolate(a,b),function(t){this.setAttribute(name,i(t))})})}function attrTweenNS(b){return null==b?attrNullNS:(b+="",function(){var i,a=this.getAttributeNS(name.space,name.local);return a!==b&&(i=interpolate(a,b),function(t){this.setAttributeNS(name.space,name.local,i(t))})})}return d3_transition_tween(this,"attr."+nameNS,value,name.local?attrTweenNS:attrTween)},d3_transitionPrototype.attrTween=function(nameNS,tween){var name=d3.ns.qualify(nameNS);return this.tween("attr."+nameNS,name.local?function(d,i){var f=tween.call(this,d,i,this.getAttributeNS(name.space,name.local));return f&&function(t){this.setAttributeNS(name.space,name.local,f(t))}}:function(d,i){var f=tween.call(this,d,i,this.getAttribute(name));return f&&function(t){this.setAttribute(name,f(t))}})},d3_transitionPrototype.style=function(name,value,priority){var n=arguments.length;if(n<3){if("string"!=typeof name){for(priority in n<2&&(value=""),name)this.style(priority,name[priority],value);return this}priority=""}function styleNull(){this.style.removeProperty(name)}function styleString(b){return null==b?styleNull:(b+="",function(){var i,a=d3_window(this).getComputedStyle(this,null).getPropertyValue(name);return a!==b&&(i=d3_interpolate(a,b),function(t){this.style.setProperty(name,i(t),priority)})})}return d3_transition_tween(this,"style."+name,value,styleString)},d3_transitionPrototype.styleTween=function(name,tween,priority){function styleTween(d,i){var f=tween.call(this,d,i,d3_window(this).getComputedStyle(this,null).getPropertyValue(name));return f&&function(t){this.style.setProperty(name,f(t),priority)}}return arguments.length<3&&(priority=""),this.tween("style."+name,styleTween)},d3_transitionPrototype.text=function(value){return d3_transition_tween(this,"text",value,d3_transition_text)},d3_transitionPrototype.remove=function(){var ns=this.namespace;return this.each("end.transition",(function(){var p;this[ns].count<2&&(p=this.parentNode)&&p.removeChild(this)}))},d3_transitionPrototype.ease=function(value){var id=this.id,ns=this.namespace;return arguments.length<1?this.node()[ns][id].ease:("function"!=typeof value&&(value=d3.ease.apply(d3,arguments)),d3_selection_each(this,(function(node){node[ns][id].ease=value})))},d3_transitionPrototype.delay=function(value){var id=this.id,ns=this.namespace;return arguments.length<1?this.node()[ns][id].delay:d3_selection_each(this,"function"==typeof value?function(node,i,j){node[ns][id].delay=+value.call(node,node.__data__,i,j)}:(value=+value,function(node){node[ns][id].delay=value}))},d3_transitionPrototype.duration=function(value){var id=this.id,ns=this.namespace;return arguments.length<1?this.node()[ns][id].duration:d3_selection_each(this,"function"==typeof value?function(node,i,j){node[ns][id].duration=Math.max(1,value.call(node,node.__data__,i,j))}:(value=Math.max(1,value),function(node){node[ns][id].duration=value}))},d3_transitionPrototype.each=function(type,listener){var id=this.id,ns=this.namespace;if(arguments.length<2){var inherit=d3_transitionInherit,inheritId=d3_transitionInheritId;try{d3_transitionInheritId=id,d3_selection_each(this,(function(node,i,j){d3_transitionInherit=node[ns][id],type.call(node,node.__data__,i,j)}))}finally{d3_transitionInherit=inherit,d3_transitionInheritId=inheritId}}else d3_selection_each(this,(function(node){var transition=node[ns][id];(transition.event||(transition.event=d3.dispatch("start","end","interrupt"))).on(type,listener)}));return this},d3_transitionPrototype.transition=function(){for(var subgroup,node,transition,id0=this.id,id1=++d3_transitionId,ns=this.namespace,subgroups=[],j=0,m=this.length;j<m;j++){subgroups.push(subgroup=[]);for(var group,i=0,n=(group=this[j]).length;i<n;i++)(node=group[i])&&d3_transitionNode(node,i,ns,id1,{time:(transition=node[ns][id0]).time,ease:transition.ease,delay:transition.delay+transition.duration,duration:transition.duration}),subgroup.push(node)}return d3_transition(subgroups,ns,id1)},d3.svg.axis=function(){var tickFormat_,scale=d3.scale.linear(),orient=d3_svg_axisDefaultOrient,innerTickSize=6,outerTickSize=6,tickPadding=3,tickArguments_=[10],tickValues=null;function axis(g){g.each((function(){var tickTransform,g=d3.select(this),scale0=this.__chart__||scale,scale1=this.__chart__=scale.copy(),ticks=null==tickValues?scale1.ticks?scale1.ticks.apply(scale1,tickArguments_):scale1.domain():tickValues,tickFormat=null==tickFormat_?scale1.tickFormat?scale1.tickFormat.apply(scale1,tickArguments_):d3_identity:tickFormat_,tick=g.selectAll(".tick").data(ticks,scale1),tickEnter=tick.enter().insert("g",".domain").attr("class","tick").style("opacity",ε),tickExit=d3.transition(tick.exit()).style("opacity",ε).remove(),tickUpdate=d3.transition(tick.order()).style("opacity",1),tickSpacing=Math.max(innerTickSize,0)+tickPadding,range=d3_scaleRange(scale1),path=g.selectAll(".domain").data([0]),pathUpdate=(path.enter().append("path").attr("class","domain"),d3.transition(path));tickEnter.append("line"),tickEnter.append("text");var x1,x2,y1,y2,lineEnter=tickEnter.select("line"),lineUpdate=tickUpdate.select("line"),text=tick.select("text").text(tickFormat),textEnter=tickEnter.select("text"),textUpdate=tickUpdate.select("text"),sign="top"===orient||"left"===orient?-1:1;if("bottom"===orient||"top"===orient?(tickTransform=d3_svg_axisX,x1="x",y1="y",x2="x2",y2="y2",text.attr("dy",sign<0?"0em":".71em").style("text-anchor","middle"),pathUpdate.attr("d","M"+range[0]+","+sign*outerTickSize+"V0H"+range[1]+"V"+sign*outerTickSize)):(tickTransform=d3_svg_axisY,x1="y",y1="x",x2="y2",y2="x2",text.attr("dy",".32em").style("text-anchor",sign<0?"end":"start"),pathUpdate.attr("d","M"+sign*outerTickSize+","+range[0]+"H0V"+range[1]+"H"+sign*outerTickSize)),lineEnter.attr(y2,sign*innerTickSize),textEnter.attr(y1,sign*tickSpacing),lineUpdate.attr(x2,0).attr(y2,sign*innerTickSize),textUpdate.attr(x1,0).attr(y1,sign*tickSpacing),scale1.rangeBand){var x=scale1,dx=x.rangeBand()/2;scale0=scale1=function(d){return x(d)+dx}}else scale0.rangeBand?scale0=scale1:tickExit.call(tickTransform,scale1,scale0);tickEnter.call(tickTransform,scale0,scale1),tickUpdate.call(tickTransform,scale1,scale1)}))}return axis.scale=function(x){return arguments.length?(scale=x,axis):scale},axis.orient=function(x){return arguments.length?(orient=x in d3_svg_axisOrients?x+"":d3_svg_axisDefaultOrient,axis):orient},axis.ticks=function(){return arguments.length?(tickArguments_=d3_array(arguments),axis):tickArguments_},axis.tickValues=function(x){return arguments.length?(tickValues=x,axis):tickValues},axis.tickFormat=function(x){return arguments.length?(tickFormat_=x,axis):tickFormat_},axis.tickSize=function(x){var n=arguments.length;return n?(innerTickSize=+x,outerTickSize=+arguments[n-1],axis):innerTickSize},axis.innerTickSize=function(x){return arguments.length?(innerTickSize=+x,axis):innerTickSize},axis.outerTickSize=function(x){return arguments.length?(outerTickSize=+x,axis):outerTickSize},axis.tickPadding=function(x){return arguments.length?(tickPadding=+x,axis):tickPadding},axis.tickSubdivide=function(){return arguments.length&&axis},axis};var d3_svg_axisDefaultOrient="bottom",d3_svg_axisOrients={top:1,right:1,bottom:1,left:1};function d3_svg_axisX(selection,x0,x1){selection.attr("transform",(function(d){var v0=x0(d);return"translate("+(isFinite(v0)?v0:x1(d))+",0)"}))}function d3_svg_axisY(selection,y0,y1){selection.attr("transform",(function(d){var v0=y0(d);return"translate(0,"+(isFinite(v0)?v0:y1(d))+")"}))}d3.svg.brush=function(){var xExtentDomain,yExtentDomain,event=d3_eventDispatch(brush,"brushstart","brush","brushend"),x=null,y=null,xExtent=[0,0],yExtent=[0,0],xClamp=!0,yClamp=!0,resizes=d3_svg_brushResizes[0];function brush(g){g.each((function(){var g=d3.select(this).style("pointer-events","all").style("-webkit-tap-highlight-color","rgba(0,0,0,0)").on("mousedown.brush",brushstart).on("touchstart.brush",brushstart),background=g.selectAll(".background").data([0]);background.enter().append("rect").attr("class","background").style("visibility","hidden").style("cursor","crosshair"),g.selectAll(".extent").data([0]).enter().append("rect").attr("class","extent").style("cursor","move");var resize=g.selectAll(".resize").data(resizes,d3_identity);resize.exit().remove(),resize.enter().append("g").attr("class",(function(d){return"resize "+d})).style("cursor",(function(d){return d3_svg_brushCursor[d]})).append("rect").attr("x",(function(d){return/[ew]$/.test(d)?-3:null})).attr("y",(function(d){return/^[ns]/.test(d)?-3:null})).attr("width",6).attr("height",6).style("visibility","hidden"),resize.style("display",brush.empty()?"none":null);var range,gUpdate=d3.transition(g),backgroundUpdate=d3.transition(background);x&&(range=d3_scaleRange(x),backgroundUpdate.attr("x",range[0]).attr("width",range[1]-range[0]),redrawX(gUpdate)),y&&(range=d3_scaleRange(y),backgroundUpdate.attr("y",range[0]).attr("height",range[1]-range[0]),redrawY(gUpdate)),redraw(gUpdate)}))}function redraw(g){g.selectAll(".resize").attr("transform",(function(d){return"translate("+xExtent[+/e$/.test(d)]+","+yExtent[+/^s/.test(d)]+")"}))}function redrawX(g){g.select(".extent").attr("x",xExtent[0]),g.selectAll(".extent,.n>rect,.s>rect").attr("width",xExtent[1]-xExtent[0])}function redrawY(g){g.select(".extent").attr("y",yExtent[0]),g.selectAll(".extent,.e>rect,.w>rect").attr("height",yExtent[1]-yExtent[0])}function brushstart(){var center,offset,target=this,eventTarget=d3.select(d3.event.target),event_=event.of(target,arguments),g=d3.select(target),resizing=eventTarget.datum(),resizingX=!/^(n|s)$/.test(resizing)&&x,resizingY=!/^(e|w)$/.test(resizing)&&y,dragging=eventTarget.classed("extent"),dragRestore=d3_event_dragSuppress(target),origin=d3.mouse(target),w=d3.select(d3_window(target)).on("keydown.brush",keydown).on("keyup.brush",keyup);if(d3.event.changedTouches?w.on("touchmove.brush",brushmove).on("touchend.brush",brushend):w.on("mousemove.brush",brushmove).on("mouseup.brush",brushend),g.interrupt().selectAll("*").interrupt(),dragging)origin[0]=xExtent[0]-origin[0],origin[1]=yExtent[0]-origin[1];else if(resizing){var ex=+/w$/.test(resizing),ey=+/^n/.test(resizing);offset=[xExtent[1-ex]-origin[0],yExtent[1-ey]-origin[1]],origin[0]=xExtent[ex],origin[1]=yExtent[ey]}else d3.event.altKey&&(center=origin.slice());function keydown(){32==d3.event.keyCode&&(dragging||(center=null,origin[0]-=xExtent[1],origin[1]-=yExtent[1],dragging=2),d3_eventPreventDefault())}function keyup(){32==d3.event.keyCode&&2==dragging&&(origin[0]+=xExtent[1],origin[1]+=yExtent[1],dragging=0,d3_eventPreventDefault())}function brushmove(){var point=d3.mouse(target),moved=!1;offset&&(point[0]+=offset[0],point[1]+=offset[1]),dragging||(d3.event.altKey?(center||(center=[(xExtent[0]+xExtent[1])/2,(yExtent[0]+yExtent[1])/2]),origin[0]=xExtent[+(point[0]<center[0])],origin[1]=yExtent[+(point[1]<center[1])]):center=null),resizingX&&move1(point,x,0)&&(redrawX(g),moved=!0),resizingY&&move1(point,y,1)&&(redrawY(g),moved=!0),moved&&(redraw(g),event_({type:"brush",mode:dragging?"move":"resize"}))}function move1(point,scale,i){var min,max,range=d3_scaleRange(scale),r0=range[0],r1=range[1],position=origin[i],extent=i?yExtent:xExtent,size=extent[1]-extent[0];if(dragging&&(r0-=position,r1-=size+position),min=(i?yClamp:xClamp)?Math.max(r0,Math.min(r1,point[i])):point[i],dragging?max=(min+=position)+size:(center&&(position=Math.max(r0,Math.min(r1,2*center[i]-min))),position<min?(max=min,min=position):max=position),extent[0]!=min||extent[1]!=max)return i?yExtentDomain=null:xExtentDomain=null,extent[0]=min,extent[1]=max,!0}function brushend(){brushmove(),g.style("pointer-events","all").selectAll(".resize").style("display",brush.empty()?"none":null),d3.select("body").style("cursor",null),w.on("mousemove.brush",null).on("mouseup.brush",null).on("touchmove.brush",null).on("touchend.brush",null).on("keydown.brush",null).on("keyup.brush",null),dragRestore(),event_({type:"brushend"})}g.style("pointer-events","none").selectAll(".resize").style("display",null),d3.select("body").style("cursor",eventTarget.style("cursor")),event_({type:"brushstart"}),brushmove()}return brush.event=function(g){g.each((function(){var event_=event.of(this,arguments),extent1={x:xExtent,y:yExtent,i:xExtentDomain,j:yExtentDomain},extent0=this.__chart__||extent1;this.__chart__=extent1,d3_transitionInheritId?d3.select(this).transition().each("start.brush",(function(){xExtentDomain=extent0.i,yExtentDomain=extent0.j,xExtent=extent0.x,yExtent=extent0.y,event_({type:"brushstart"})})).tween("brush:brush",(function(){var xi=d3_interpolateArray(xExtent,extent1.x),yi=d3_interpolateArray(yExtent,extent1.y);return xExtentDomain=yExtentDomain=null,function(t){xExtent=extent1.x=xi(t),yExtent=extent1.y=yi(t),event_({type:"brush",mode:"resize"})}})).each("end.brush",(function(){xExtentDomain=extent1.i,yExtentDomain=extent1.j,event_({type:"brush",mode:"resize"}),event_({type:"brushend"})})):(event_({type:"brushstart"}),event_({type:"brush",mode:"resize"}),event_({type:"brushend"}))}))},brush.x=function(z){return arguments.length?(resizes=d3_svg_brushResizes[!(x=z)<<1|!y],brush):x},brush.y=function(z){return arguments.length?(resizes=d3_svg_brushResizes[!x<<1|!(y=z)],brush):y},brush.clamp=function(z){return arguments.length?(x&&y?(xClamp=!!z[0],yClamp=!!z[1]):x?xClamp=!!z:y&&(yClamp=!!z),brush):x&&y?[xClamp,yClamp]:x?xClamp:y?yClamp:null},brush.extent=function(z){var x0,x1,y0,y1,t;return arguments.length?(x&&(x0=z[0],x1=z[1],y&&(x0=x0[0],x1=x1[0]),xExtentDomain=[x0,x1],x.invert&&(x0=x(x0),x1=x(x1)),x1<x0&&(t=x0,x0=x1,x1=t),x0==xExtent[0]&&x1==xExtent[1]||(xExtent=[x0,x1])),y&&(y0=z[0],y1=z[1],x&&(y0=y0[1],y1=y1[1]),yExtentDomain=[y0,y1],y.invert&&(y0=y(y0),y1=y(y1)),y1<y0&&(t=y0,y0=y1,y1=t),y0==yExtent[0]&&y1==yExtent[1]||(yExtent=[y0,y1])),brush):(x&&(xExtentDomain?(x0=xExtentDomain[0],x1=xExtentDomain[1]):(x0=xExtent[0],x1=xExtent[1],x.invert&&(x0=x.invert(x0),x1=x.invert(x1)),x1<x0&&(t=x0,x0=x1,x1=t))),y&&(yExtentDomain?(y0=yExtentDomain[0],y1=yExtentDomain[1]):(y0=yExtent[0],y1=yExtent[1],y.invert&&(y0=y.invert(y0),y1=y.invert(y1)),y1<y0&&(t=y0,y0=y1,y1=t))),x&&y?[[x0,y0],[x1,y1]]:x?[x0,x1]:y&&[y0,y1])},brush.clear=function(){return brush.empty()||(xExtent=[0,0],yExtent=[0,0],xExtentDomain=yExtentDomain=null),brush},brush.empty=function(){return!!x&&xExtent[0]==xExtent[1]||!!y&&yExtent[0]==yExtent[1]},d3.rebind(brush,event,"on")};var d3_svg_brushCursor={n:"ns-resize",e:"ew-resize",s:"ns-resize",w:"ew-resize",nw:"nwse-resize",ne:"nesw-resize",se:"nwse-resize",sw:"nesw-resize"},d3_svg_brushResizes=[["n","e","s","w","nw","ne","se","sw"],["e","w"],["n","s"],[]],d3_time_format=d3_time.format=d3_locale_enUS.timeFormat,d3_time_formatUtc=d3_time_format.utc,d3_time_formatIso=d3_time_formatUtc("%Y-%m-%dT%H:%M:%S.%LZ");function d3_time_formatIsoNative(date){return date.toISOString()}function d3_time_scale(linear,methods,format){function scale(x){return linear(x)}function tickMethod(extent,count){var target=(extent[1]-extent[0])/count,i=d3.bisect(d3_time_scaleSteps,target);return i==d3_time_scaleSteps.length?[methods.year,d3_scale_linearTickRange(extent.map((function(d){return d/31536e6})),count)[2]]:i?methods[target/d3_time_scaleSteps[i-1]<d3_time_scaleSteps[i]/target?i-1:i]:[d3_time_scaleMilliseconds,d3_scale_linearTickRange(extent,count)[2]]}return scale.invert=function(x){return d3_time_scaleDate(linear.invert(x))},scale.domain=function(x){return arguments.length?(linear.domain(x),scale):linear.domain().map(d3_time_scaleDate)},scale.nice=function(interval,skip){var domain=scale.domain(),extent=d3_scaleExtent(domain),method=null==interval?tickMethod(extent,10):"number"==typeof interval&&tickMethod(extent,interval);function skipped(date){return!isNaN(date)&&!interval.range(date,d3_time_scaleDate(+date+1),skip).length}return method&&(interval=method[0],skip=method[1]),scale.domain(d3_scale_nice(domain,skip>1?{floor:function(date){for(;skipped(date=interval.floor(date));)date=d3_time_scaleDate(date-1);return date},ceil:function(date){for(;skipped(date=interval.ceil(date));)date=d3_time_scaleDate(+date+1);return date}}:interval))},scale.ticks=function(interval,skip){var extent=d3_scaleExtent(scale.domain()),method=null==interval?tickMethod(extent,10):"number"==typeof interval?tickMethod(extent,interval):!interval.range&&[{range:interval},skip];return method&&(interval=method[0],skip=method[1]),interval.range(extent[0],d3_time_scaleDate(+extent[1]+1),skip<1?1:skip)},scale.tickFormat=function(){return format},scale.copy=function(){return d3_time_scale(linear.copy(),methods,format)},d3_scale_linearRebind(scale,linear)}function d3_time_scaleDate(t){return new Date(t)}d3_time_format.iso=Date.prototype.toISOString&&+new Date("2000-01-01T00:00:00.000Z")?d3_time_formatIsoNative:d3_time_formatIso,d3_time_formatIsoNative.parse=function(string){var date=new Date(string);return isNaN(date)?null:date},d3_time_formatIsoNative.toString=d3_time_formatIso.toString,d3_time.second=d3_time_interval((function(date){return new d3_date(1e3*Math.floor(date/1e3))}),(function(date,offset){date.setTime(date.getTime()+1e3*Math.floor(offset))}),(function(date){return date.getSeconds()})),d3_time.seconds=d3_time.second.range,d3_time.seconds.utc=d3_time.second.utc.range,d3_time.minute=d3_time_interval((function(date){return new d3_date(6e4*Math.floor(date/6e4))}),(function(date,offset){date.setTime(date.getTime()+6e4*Math.floor(offset))}),(function(date){return date.getMinutes()})),d3_time.minutes=d3_time.minute.range,d3_time.minutes.utc=d3_time.minute.utc.range,d3_time.hour=d3_time_interval((function(date){var timezone=date.getTimezoneOffset()/60;return new d3_date(36e5*(Math.floor(date/36e5-timezone)+timezone))}),(function(date,offset){date.setTime(date.getTime()+36e5*Math.floor(offset))}),(function(date){return date.getHours()})),d3_time.hours=d3_time.hour.range,d3_time.hours.utc=d3_time.hour.utc.range,d3_time.month=d3_time_interval((function(date){return(date=d3_time.day(date)).setDate(1),date}),(function(date,offset){date.setMonth(date.getMonth()+offset)}),(function(date){return date.getMonth()})),d3_time.months=d3_time.month.range,d3_time.months.utc=d3_time.month.utc.range;var d3_time_scaleSteps=[1e3,5e3,15e3,3e4,6e4,3e5,9e5,18e5,36e5,108e5,216e5,432e5,864e5,1728e5,6048e5,2592e6,7776e6,31536e6],d3_time_scaleLocalMethods=[[d3_time.second,1],[d3_time.second,5],[d3_time.second,15],[d3_time.second,30],[d3_time.minute,1],[d3_time.minute,5],[d3_time.minute,15],[d3_time.minute,30],[d3_time.hour,1],[d3_time.hour,3],[d3_time.hour,6],[d3_time.hour,12],[d3_time.day,1],[d3_time.day,2],[d3_time.week,1],[d3_time.month,1],[d3_time.month,3],[d3_time.year,1]],d3_time_scaleLocalFormat=d3_time_format.multi([[".%L",function(d){return d.getMilliseconds()}],[":%S",function(d){return d.getSeconds()}],["%I:%M",function(d){return d.getMinutes()}],["%I %p",function(d){return d.getHours()}],["%a %d",function(d){return d.getDay()&&1!=d.getDate()}],["%b %d",function(d){return 1!=d.getDate()}],["%B",function(d){return d.getMonth()}],["%Y",d3_true]]),d3_time_scaleMilliseconds={range:function(start,stop,step){return d3.range(Math.ceil(start/step)*step,+stop,step).map(d3_time_scaleDate)},floor:d3_identity,ceil:d3_identity};d3_time_scaleLocalMethods.year=d3_time.year,d3_time.scale=function(){return d3_time_scale(d3.scale.linear(),d3_time_scaleLocalMethods,d3_time_scaleLocalFormat)};var d3_time_scaleUtcMethods=d3_time_scaleLocalMethods.map((function(m){return[m[0].utc,m[1]]})),d3_time_scaleUtcFormat=d3_time_formatUtc.multi([[".%L",function(d){return d.getUTCMilliseconds()}],[":%S",function(d){return d.getUTCSeconds()}],["%I:%M",function(d){return d.getUTCMinutes()}],["%I %p",function(d){return d.getUTCHours()}],["%a %d",function(d){return d.getUTCDay()&&1!=d.getUTCDate()}],["%b %d",function(d){return 1!=d.getUTCDate()}],["%B",function(d){return d.getUTCMonth()}],["%Y",d3_true]]);function d3_json(request){return JSON.parse(request.responseText)}function d3_html(request){var range=d3_document.createRange();return range.selectNode(d3_document.body),range.createContextualFragment(request.responseText)}d3_time_scaleUtcMethods.year=d3_time.year.utc,d3_time.scale.utc=function(){return d3_time_scale(d3.scale.linear(),d3_time_scaleUtcMethods,d3_time_scaleUtcFormat)},d3.text=d3_xhrType((function(request){return request.responseText})),d3.json=function(url,callback){return d3_xhr(url,"application/json",d3_json,callback)},d3.html=function(url,callback){return d3_xhr(url,"text/html",d3_html,callback)},d3.xml=d3_xhrType((function(request){return request.responseXML})),this.d3=d3,void 0===(__WEBPACK_AMD_DEFINE_RESULT__="function"==typeof(__WEBPACK_AMD_DEFINE_FACTORY__=d3)?__WEBPACK_AMD_DEFINE_FACTORY__.call(exports,__webpack_require__,exports,module):__WEBPACK_AMD_DEFINE_FACTORY__)||(module.exports=__WEBPACK_AMD_DEFINE_RESULT__)}()},"contrib/jquery-2.1.0":function(module,exports,__webpack_require__){var __WEBPACK_AMD_DEFINE_RESULT__,global,factory;
/*!
 * jQuery JavaScript Library v2.1.0
 * http://jquery.com/
 *
 * Includes Sizzle.js
 * http://sizzlejs.com/
 *
 * Copyright 2005, 2014 jQuery Foundation, Inc. and other contributors
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: 2014-01-23T21:10Z
 */global="undefined"!=typeof window?window:this,factory=function(window,noGlobal){var arr=[],slice=arr.slice,concat=arr.concat,push=arr.push,indexOf=arr.indexOf,class2type={},toString=class2type.toString,hasOwn=class2type.hasOwnProperty,trim="".trim,support={},document=window.document,jQuery=function(selector,context){return new jQuery.fn.init(selector,context)},rmsPrefix=/^-ms-/,rdashAlpha=/-([\da-z])/gi,fcamelCase=function(all,letter){return letter.toUpperCase()};function isArraylike(obj){var length=obj.length,type=jQuery.type(obj);return"function"!==type&&!jQuery.isWindow(obj)&&(!(1!==obj.nodeType||!length)||"array"===type||0===length||"number"==typeof length&&length>0&&length-1 in obj)}jQuery.fn=jQuery.prototype={jquery:"2.1.0",constructor:jQuery,selector:"",length:0,toArray:function(){return slice.call(this)},get:function(num){return null!=num?num<0?this[num+this.length]:this[num]:slice.call(this)},pushStack:function(elems){var ret=jQuery.merge(this.constructor(),elems);return ret.prevObject=this,ret.context=this.context,ret},each:function(callback,args){return jQuery.each(this,callback,args)},map:function(callback){return this.pushStack(jQuery.map(this,(function(elem,i){return callback.call(elem,i,elem)})))},slice:function(){return this.pushStack(slice.apply(this,arguments))},first:function(){return this.eq(0)},last:function(){return this.eq(-1)},eq:function(i){var len=this.length,j=+i+(i<0?len:0);return this.pushStack(j>=0&&j<len?[this[j]]:[])},end:function(){return this.prevObject||this.constructor(null)},push:push,sort:arr.sort,splice:arr.splice},jQuery.extend=jQuery.fn.extend=function(){var options,name,src,copy,copyIsArray,clone,target=arguments[0]||{},i=1,length=arguments.length,deep=!1;for("boolean"==typeof target&&(deep=target,target=arguments[i]||{},i++),"object"==typeof target||jQuery.isFunction(target)||(target={}),i===length&&(target=this,i--);i<length;i++)if(null!=(options=arguments[i]))for(name in options)src=target[name],target!==(copy=options[name])&&(deep&&copy&&(jQuery.isPlainObject(copy)||(copyIsArray=jQuery.isArray(copy)))?(copyIsArray?(copyIsArray=!1,clone=src&&jQuery.isArray(src)?src:[]):clone=src&&jQuery.isPlainObject(src)?src:{},target[name]=jQuery.extend(deep,clone,copy)):void 0!==copy&&(target[name]=copy));return target},jQuery.extend({expando:"jQuery"+("2.1.0"+Math.random()).replace(/\D/g,""),isReady:!0,error:function(msg){throw new Error(msg)},noop:function(){},isFunction:function(obj){return"function"===jQuery.type(obj)},isArray:Array.isArray,isWindow:function(obj){return null!=obj&&obj===obj.window},isNumeric:function(obj){return obj-parseFloat(obj)>=0},isPlainObject:function(obj){if("object"!==jQuery.type(obj)||obj.nodeType||jQuery.isWindow(obj))return!1;try{if(obj.constructor&&!hasOwn.call(obj.constructor.prototype,"isPrototypeOf"))return!1}catch(e){return!1}return!0},isEmptyObject:function(obj){var name;for(name in obj)return!1;return!0},type:function(obj){return null==obj?obj+"":"object"==typeof obj||"function"==typeof obj?class2type[toString.call(obj)]||"object":typeof obj},globalEval:function(code){var script,indirect=eval;(code=jQuery.trim(code))&&(1===code.indexOf("use strict")?((script=document.createElement("script")).text=code,document.head.appendChild(script).parentNode.removeChild(script)):indirect(code))},camelCase:function(string){return string.replace(rmsPrefix,"ms-").replace(rdashAlpha,fcamelCase)},nodeName:function(elem,name){return elem.nodeName&&elem.nodeName.toLowerCase()===name.toLowerCase()},each:function(obj,callback,args){var i=0,length=obj.length,isArray=isArraylike(obj);if(args){if(isArray)for(;i<length&&!1!==callback.apply(obj[i],args);i++);else for(i in obj)if(!1===callback.apply(obj[i],args))break}else if(isArray)for(;i<length&&!1!==callback.call(obj[i],i,obj[i]);i++);else for(i in obj)if(!1===callback.call(obj[i],i,obj[i]))break;return obj},trim:function(text){return null==text?"":trim.call(text)},makeArray:function(arr,results){var ret=results||[];return null!=arr&&(isArraylike(Object(arr))?jQuery.merge(ret,"string"==typeof arr?[arr]:arr):push.call(ret,arr)),ret},inArray:function(elem,arr,i){return null==arr?-1:indexOf.call(arr,elem,i)},merge:function(first,second){for(var len=+second.length,j=0,i=first.length;j<len;j++)first[i++]=second[j];return first.length=i,first},grep:function(elems,callback,invert){for(var matches=[],i=0,length=elems.length,callbackExpect=!invert;i<length;i++)!callback(elems[i],i)!==callbackExpect&&matches.push(elems[i]);return matches},map:function(elems,callback,arg){var value,i=0,length=elems.length,ret=[];if(isArraylike(elems))for(;i<length;i++)null!=(value=callback(elems[i],i,arg))&&ret.push(value);else for(i in elems)null!=(value=callback(elems[i],i,arg))&&ret.push(value);return concat.apply([],ret)},guid:1,proxy:function(fn,context){var tmp,args,proxy;if("string"==typeof context&&(tmp=fn[context],context=fn,fn=tmp),jQuery.isFunction(fn))return args=slice.call(arguments,2),(proxy=function(){return fn.apply(context||this,args.concat(slice.call(arguments)))}).guid=fn.guid=fn.guid||jQuery.guid++,proxy},now:Date.now,support:support}),jQuery.each("Boolean Number String Function Array Date RegExp Object Error".split(" "),(function(i,name){class2type["[object "+name+"]"]=name.toLowerCase()}));var Sizzle=
/*!
 * Sizzle CSS Selector Engine v1.10.16
 * http://sizzlejs.com/
 *
 * Copyright 2013 jQuery Foundation, Inc. and other contributors
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: 2014-01-13
 */
function(window){var i,support,Expr,getText,isXML,compile,outermostContext,sortInput,hasDuplicate,setDocument,document,docElem,documentIsHTML,rbuggyQSA,rbuggyMatches,matches,contains,expando="sizzle"+-new Date,preferredDoc=window.document,dirruns=0,done=0,classCache=createCache(),tokenCache=createCache(),compilerCache=createCache(),sortOrder=function(a,b){return a===b&&(hasDuplicate=!0),0},hasOwn={}.hasOwnProperty,arr=[],pop=arr.pop,push_native=arr.push,push=arr.push,slice=arr.slice,indexOf=arr.indexOf||function(elem){for(var i=0,len=this.length;i<len;i++)if(this[i]===elem)return i;return-1},booleans="checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped",whitespace="[\\x20\\t\\r\\n\\f]",characterEncoding="(?:\\\\.|[\\w-]|[^\\x00-\\xa0])+",identifier=characterEncoding.replace("w","w#"),attributes="\\["+whitespace+"*("+characterEncoding+")"+whitespace+"*(?:([*^$|!~]?=)"+whitespace+"*(?:(['\"])((?:\\\\.|[^\\\\])*?)\\3|("+identifier+")|)|)"+whitespace+"*\\]",pseudos=":("+characterEncoding+")(?:\\(((['\"])((?:\\\\.|[^\\\\])*?)\\3|((?:\\\\.|[^\\\\()[\\]]|"+attributes.replace(3,8)+")*)|.*)\\)|)",rtrim=new RegExp("^"+whitespace+"+|((?:^|[^\\\\])(?:\\\\.)*)"+whitespace+"+$","g"),rcomma=new RegExp("^"+whitespace+"*,"+whitespace+"*"),rcombinators=new RegExp("^"+whitespace+"*([>+~]|"+whitespace+")"+whitespace+"*"),rattributeQuotes=new RegExp("="+whitespace+"*([^\\]'\"]*?)"+whitespace+"*\\]","g"),rpseudo=new RegExp(pseudos),ridentifier=new RegExp("^"+identifier+"$"),matchExpr={ID:new RegExp("^#("+characterEncoding+")"),CLASS:new RegExp("^\\.("+characterEncoding+")"),TAG:new RegExp("^("+characterEncoding.replace("w","w*")+")"),ATTR:new RegExp("^"+attributes),PSEUDO:new RegExp("^"+pseudos),CHILD:new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\("+whitespace+"*(even|odd|(([+-]|)(\\d*)n|)"+whitespace+"*(?:([+-]|)"+whitespace+"*(\\d+)|))"+whitespace+"*\\)|)","i"),bool:new RegExp("^(?:"+booleans+")$","i"),needsContext:new RegExp("^"+whitespace+"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\("+whitespace+"*((?:-\\d)?\\d*)"+whitespace+"*\\)|)(?=[^-]|$)","i")},rinputs=/^(?:input|select|textarea|button)$/i,rheader=/^h\d$/i,rnative=/^[^{]+\{\s*\[native \w/,rquickExpr=/^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,rsibling=/[+~]/,rescape=/'|\\/g,runescape=new RegExp("\\\\([\\da-f]{1,6}"+whitespace+"?|("+whitespace+")|.)","ig"),funescape=function(_,escaped,escapedWhitespace){var high="0x"+escaped-65536;return high!=high||escapedWhitespace?escaped:high<0?String.fromCharCode(high+65536):String.fromCharCode(high>>10|55296,1023&high|56320)};try{push.apply(arr=slice.call(preferredDoc.childNodes),preferredDoc.childNodes),arr[preferredDoc.childNodes.length].nodeType}catch(e){push={apply:arr.length?function(target,els){push_native.apply(target,slice.call(els))}:function(target,els){for(var j=target.length,i=0;target[j++]=els[i++];);target.length=j-1}}}function Sizzle(selector,context,results,seed){var match,elem,m,nodeType,i,groups,old,nid,newContext,newSelector;if((context?context.ownerDocument||context:preferredDoc)!==document&&setDocument(context),results=results||[],!selector||"string"!=typeof selector)return results;if(1!==(nodeType=(context=context||document).nodeType)&&9!==nodeType)return[];if(documentIsHTML&&!seed){if(match=rquickExpr.exec(selector))if(m=match[1]){if(9===nodeType){if(!(elem=context.getElementById(m))||!elem.parentNode)return results;if(elem.id===m)return results.push(elem),results}else if(context.ownerDocument&&(elem=context.ownerDocument.getElementById(m))&&contains(context,elem)&&elem.id===m)return results.push(elem),results}else{if(match[2])return push.apply(results,context.getElementsByTagName(selector)),results;if((m=match[3])&&support.getElementsByClassName&&context.getElementsByClassName)return push.apply(results,context.getElementsByClassName(m)),results}if(support.qsa&&(!rbuggyQSA||!rbuggyQSA.test(selector))){if(nid=old=expando,newContext=context,newSelector=9===nodeType&&selector,1===nodeType&&"object"!==context.nodeName.toLowerCase()){for(groups=tokenize(selector),(old=context.getAttribute("id"))?nid=old.replace(rescape,"\\$&"):context.setAttribute("id",nid),nid="[id='"+nid+"'] ",i=groups.length;i--;)groups[i]=nid+toSelector(groups[i]);newContext=rsibling.test(selector)&&testContext(context.parentNode)||context,newSelector=groups.join(",")}if(newSelector)try{return push.apply(results,newContext.querySelectorAll(newSelector)),results}catch(qsaError){}finally{old||context.removeAttribute("id")}}}return function(selector,context,results,seed){var i,tokens,token,type,find,match=tokenize(selector);if(!seed&&1===match.length){if((tokens=match[0]=match[0].slice(0)).length>2&&"ID"===(token=tokens[0]).type&&support.getById&&9===context.nodeType&&documentIsHTML&&Expr.relative[tokens[1].type]){if(!(context=(Expr.find.ID(token.matches[0].replace(runescape,funescape),context)||[])[0]))return results;selector=selector.slice(tokens.shift().value.length)}for(i=matchExpr.needsContext.test(selector)?0:tokens.length;i--&&(token=tokens[i],!Expr.relative[type=token.type]);)if((find=Expr.find[type])&&(seed=find(token.matches[0].replace(runescape,funescape),rsibling.test(tokens[0].type)&&testContext(context.parentNode)||context))){if(tokens.splice(i,1),!(selector=seed.length&&toSelector(tokens)))return push.apply(results,seed),results;break}}return compile(selector,match)(seed,context,!documentIsHTML,results,rsibling.test(selector)&&testContext(context.parentNode)||context),results}(selector.replace(rtrim,"$1"),context,results,seed)}function createCache(){var keys=[];return function cache(key,value){return keys.push(key+" ")>Expr.cacheLength&&delete cache[keys.shift()],cache[key+" "]=value}}function markFunction(fn){return fn[expando]=!0,fn}function assert(fn){var div=document.createElement("div");try{return!!fn(div)}catch(e){return!1}finally{div.parentNode&&div.parentNode.removeChild(div),div=null}}function addHandle(attrs,handler){for(var arr=attrs.split("|"),i=attrs.length;i--;)Expr.attrHandle[arr[i]]=handler}function siblingCheck(a,b){var cur=b&&a,diff=cur&&1===a.nodeType&&1===b.nodeType&&(~b.sourceIndex||1<<31)-(~a.sourceIndex||1<<31);if(diff)return diff;if(cur)for(;cur=cur.nextSibling;)if(cur===b)return-1;return a?1:-1}function createInputPseudo(type){return function(elem){return"input"===elem.nodeName.toLowerCase()&&elem.type===type}}function createButtonPseudo(type){return function(elem){var name=elem.nodeName.toLowerCase();return("input"===name||"button"===name)&&elem.type===type}}function createPositionalPseudo(fn){return markFunction((function(argument){return argument=+argument,markFunction((function(seed,matches){for(var j,matchIndexes=fn([],seed.length,argument),i=matchIndexes.length;i--;)seed[j=matchIndexes[i]]&&(seed[j]=!(matches[j]=seed[j]))}))}))}function testContext(context){return context&&void 0!==context.getElementsByTagName&&context}for(i in support=Sizzle.support={},isXML=Sizzle.isXML=function(elem){var documentElement=elem&&(elem.ownerDocument||elem).documentElement;return!!documentElement&&"HTML"!==documentElement.nodeName},setDocument=Sizzle.setDocument=function(node){var hasCompare,doc=node?node.ownerDocument||node:preferredDoc,parent=doc.defaultView;return doc!==document&&9===doc.nodeType&&doc.documentElement?(document=doc,docElem=doc.documentElement,documentIsHTML=!isXML(doc),parent&&parent!==parent.top&&(parent.addEventListener?parent.addEventListener("unload",(function(){setDocument()}),!1):parent.attachEvent&&parent.attachEvent("onunload",(function(){setDocument()}))),support.attributes=assert((function(div){return div.className="i",!div.getAttribute("className")})),support.getElementsByTagName=assert((function(div){return div.appendChild(doc.createComment("")),!div.getElementsByTagName("*").length})),support.getElementsByClassName=rnative.test(doc.getElementsByClassName)&&assert((function(div){return div.innerHTML="<div class='a'></div><div class='a i'></div>",div.firstChild.className="i",2===div.getElementsByClassName("i").length})),support.getById=assert((function(div){return docElem.appendChild(div).id=expando,!doc.getElementsByName||!doc.getElementsByName(expando).length})),support.getById?(Expr.find.ID=function(id,context){if(void 0!==context.getElementById&&documentIsHTML){var m=context.getElementById(id);return m&&m.parentNode?[m]:[]}},Expr.filter.ID=function(id){var attrId=id.replace(runescape,funescape);return function(elem){return elem.getAttribute("id")===attrId}}):(delete Expr.find.ID,Expr.filter.ID=function(id){var attrId=id.replace(runescape,funescape);return function(elem){var node=void 0!==elem.getAttributeNode&&elem.getAttributeNode("id");return node&&node.value===attrId}}),Expr.find.TAG=support.getElementsByTagName?function(tag,context){if(void 0!==context.getElementsByTagName)return context.getElementsByTagName(tag)}:function(tag,context){var elem,tmp=[],i=0,results=context.getElementsByTagName(tag);if("*"===tag){for(;elem=results[i++];)1===elem.nodeType&&tmp.push(elem);return tmp}return results},Expr.find.CLASS=support.getElementsByClassName&&function(className,context){if(void 0!==context.getElementsByClassName&&documentIsHTML)return context.getElementsByClassName(className)},rbuggyMatches=[],rbuggyQSA=[],(support.qsa=rnative.test(doc.querySelectorAll))&&(assert((function(div){div.innerHTML="<select t=''><option selected=''></option></select>",div.querySelectorAll("[t^='']").length&&rbuggyQSA.push("[*^$]="+whitespace+"*(?:''|\"\")"),div.querySelectorAll("[selected]").length||rbuggyQSA.push("\\["+whitespace+"*(?:value|"+booleans+")"),div.querySelectorAll(":checked").length||rbuggyQSA.push(":checked")})),assert((function(div){var input=doc.createElement("input");input.setAttribute("type","hidden"),div.appendChild(input).setAttribute("name","D"),div.querySelectorAll("[name=d]").length&&rbuggyQSA.push("name"+whitespace+"*[*^$|!~]?="),div.querySelectorAll(":enabled").length||rbuggyQSA.push(":enabled",":disabled"),div.querySelectorAll("*,:x"),rbuggyQSA.push(",.*:")}))),(support.matchesSelector=rnative.test(matches=docElem.webkitMatchesSelector||docElem.mozMatchesSelector||docElem.oMatchesSelector||docElem.msMatchesSelector))&&assert((function(div){support.disconnectedMatch=matches.call(div,"div"),matches.call(div,"[s!='']:x"),rbuggyMatches.push("!=",pseudos)})),rbuggyQSA=rbuggyQSA.length&&new RegExp(rbuggyQSA.join("|")),rbuggyMatches=rbuggyMatches.length&&new RegExp(rbuggyMatches.join("|")),hasCompare=rnative.test(docElem.compareDocumentPosition),contains=hasCompare||rnative.test(docElem.contains)?function(a,b){var adown=9===a.nodeType?a.documentElement:a,bup=b&&b.parentNode;return a===bup||!(!bup||1!==bup.nodeType||!(adown.contains?adown.contains(bup):a.compareDocumentPosition&&16&a.compareDocumentPosition(bup)))}:function(a,b){if(b)for(;b=b.parentNode;)if(b===a)return!0;return!1},sortOrder=hasCompare?function(a,b){if(a===b)return hasDuplicate=!0,0;var compare=!a.compareDocumentPosition-!b.compareDocumentPosition;return compare||(1&(compare=(a.ownerDocument||a)===(b.ownerDocument||b)?a.compareDocumentPosition(b):1)||!support.sortDetached&&b.compareDocumentPosition(a)===compare?a===doc||a.ownerDocument===preferredDoc&&contains(preferredDoc,a)?-1:b===doc||b.ownerDocument===preferredDoc&&contains(preferredDoc,b)?1:sortInput?indexOf.call(sortInput,a)-indexOf.call(sortInput,b):0:4&compare?-1:1)}:function(a,b){if(a===b)return hasDuplicate=!0,0;var cur,i=0,aup=a.parentNode,bup=b.parentNode,ap=[a],bp=[b];if(!aup||!bup)return a===doc?-1:b===doc?1:aup?-1:bup?1:sortInput?indexOf.call(sortInput,a)-indexOf.call(sortInput,b):0;if(aup===bup)return siblingCheck(a,b);for(cur=a;cur=cur.parentNode;)ap.unshift(cur);for(cur=b;cur=cur.parentNode;)bp.unshift(cur);for(;ap[i]===bp[i];)i++;return i?siblingCheck(ap[i],bp[i]):ap[i]===preferredDoc?-1:bp[i]===preferredDoc?1:0},doc):document},Sizzle.matches=function(expr,elements){return Sizzle(expr,null,null,elements)},Sizzle.matchesSelector=function(elem,expr){if((elem.ownerDocument||elem)!==document&&setDocument(elem),expr=expr.replace(rattributeQuotes,"='$1']"),support.matchesSelector&&documentIsHTML&&(!rbuggyMatches||!rbuggyMatches.test(expr))&&(!rbuggyQSA||!rbuggyQSA.test(expr)))try{var ret=matches.call(elem,expr);if(ret||support.disconnectedMatch||elem.document&&11!==elem.document.nodeType)return ret}catch(e){}return Sizzle(expr,document,null,[elem]).length>0},Sizzle.contains=function(context,elem){return(context.ownerDocument||context)!==document&&setDocument(context),contains(context,elem)},Sizzle.attr=function(elem,name){(elem.ownerDocument||elem)!==document&&setDocument(elem);var fn=Expr.attrHandle[name.toLowerCase()],val=fn&&hasOwn.call(Expr.attrHandle,name.toLowerCase())?fn(elem,name,!documentIsHTML):void 0;return void 0!==val?val:support.attributes||!documentIsHTML?elem.getAttribute(name):(val=elem.getAttributeNode(name))&&val.specified?val.value:null},Sizzle.error=function(msg){throw new Error("Syntax error, unrecognized expression: "+msg)},Sizzle.uniqueSort=function(results){var elem,duplicates=[],j=0,i=0;if(hasDuplicate=!support.detectDuplicates,sortInput=!support.sortStable&&results.slice(0),results.sort(sortOrder),hasDuplicate){for(;elem=results[i++];)elem===results[i]&&(j=duplicates.push(i));for(;j--;)results.splice(duplicates[j],1)}return sortInput=null,results},getText=Sizzle.getText=function(elem){var node,ret="",i=0,nodeType=elem.nodeType;if(nodeType){if(1===nodeType||9===nodeType||11===nodeType){if("string"==typeof elem.textContent)return elem.textContent;for(elem=elem.firstChild;elem;elem=elem.nextSibling)ret+=getText(elem)}else if(3===nodeType||4===nodeType)return elem.nodeValue}else for(;node=elem[i++];)ret+=getText(node);return ret},(Expr=Sizzle.selectors={cacheLength:50,createPseudo:markFunction,match:matchExpr,attrHandle:{},find:{},relative:{">":{dir:"parentNode",first:!0}," ":{dir:"parentNode"},"+":{dir:"previousSibling",first:!0},"~":{dir:"previousSibling"}},preFilter:{ATTR:function(match){return match[1]=match[1].replace(runescape,funescape),match[3]=(match[4]||match[5]||"").replace(runescape,funescape),"~="===match[2]&&(match[3]=" "+match[3]+" "),match.slice(0,4)},CHILD:function(match){return match[1]=match[1].toLowerCase(),"nth"===match[1].slice(0,3)?(match[3]||Sizzle.error(match[0]),match[4]=+(match[4]?match[5]+(match[6]||1):2*("even"===match[3]||"odd"===match[3])),match[5]=+(match[7]+match[8]||"odd"===match[3])):match[3]&&Sizzle.error(match[0]),match},PSEUDO:function(match){var excess,unquoted=!match[5]&&match[2];return matchExpr.CHILD.test(match[0])?null:(match[3]&&void 0!==match[4]?match[2]=match[4]:unquoted&&rpseudo.test(unquoted)&&(excess=tokenize(unquoted,!0))&&(excess=unquoted.indexOf(")",unquoted.length-excess)-unquoted.length)&&(match[0]=match[0].slice(0,excess),match[2]=unquoted.slice(0,excess)),match.slice(0,3))}},filter:{TAG:function(nodeNameSelector){var nodeName=nodeNameSelector.replace(runescape,funescape).toLowerCase();return"*"===nodeNameSelector?function(){return!0}:function(elem){return elem.nodeName&&elem.nodeName.toLowerCase()===nodeName}},CLASS:function(className){var pattern=classCache[className+" "];return pattern||(pattern=new RegExp("(^|"+whitespace+")"+className+"("+whitespace+"|$)"))&&classCache(className,(function(elem){return pattern.test("string"==typeof elem.className&&elem.className||void 0!==elem.getAttribute&&elem.getAttribute("class")||"")}))},ATTR:function(name,operator,check){return function(elem){var result=Sizzle.attr(elem,name);return null==result?"!="===operator:!operator||(result+="","="===operator?result===check:"!="===operator?result!==check:"^="===operator?check&&0===result.indexOf(check):"*="===operator?check&&result.indexOf(check)>-1:"$="===operator?check&&result.slice(-check.length)===check:"~="===operator?(" "+result+" ").indexOf(check)>-1:"|="===operator&&(result===check||result.slice(0,check.length+1)===check+"-"))}},CHILD:function(type,what,argument,first,last){var simple="nth"!==type.slice(0,3),forward="last"!==type.slice(-4),ofType="of-type"===what;return 1===first&&0===last?function(elem){return!!elem.parentNode}:function(elem,context,xml){var cache,outerCache,node,diff,nodeIndex,start,dir=simple!==forward?"nextSibling":"previousSibling",parent=elem.parentNode,name=ofType&&elem.nodeName.toLowerCase(),useCache=!xml&&!ofType;if(parent){if(simple){for(;dir;){for(node=elem;node=node[dir];)if(ofType?node.nodeName.toLowerCase()===name:1===node.nodeType)return!1;start=dir="only"===type&&!start&&"nextSibling"}return!0}if(start=[forward?parent.firstChild:parent.lastChild],forward&&useCache){for(nodeIndex=(cache=(outerCache=parent[expando]||(parent[expando]={}))[type]||[])[0]===dirruns&&cache[1],diff=cache[0]===dirruns&&cache[2],node=nodeIndex&&parent.childNodes[nodeIndex];node=++nodeIndex&&node&&node[dir]||(diff=nodeIndex=0)||start.pop();)if(1===node.nodeType&&++diff&&node===elem){outerCache[type]=[dirruns,nodeIndex,diff];break}}else if(useCache&&(cache=(elem[expando]||(elem[expando]={}))[type])&&cache[0]===dirruns)diff=cache[1];else for(;(node=++nodeIndex&&node&&node[dir]||(diff=nodeIndex=0)||start.pop())&&((ofType?node.nodeName.toLowerCase()!==name:1!==node.nodeType)||!++diff||(useCache&&((node[expando]||(node[expando]={}))[type]=[dirruns,diff]),node!==elem)););return(diff-=last)===first||diff%first==0&&diff/first>=0}}},PSEUDO:function(pseudo,argument){var args,fn=Expr.pseudos[pseudo]||Expr.setFilters[pseudo.toLowerCase()]||Sizzle.error("unsupported pseudo: "+pseudo);return fn[expando]?fn(argument):fn.length>1?(args=[pseudo,pseudo,"",argument],Expr.setFilters.hasOwnProperty(pseudo.toLowerCase())?markFunction((function(seed,matches){for(var idx,matched=fn(seed,argument),i=matched.length;i--;)seed[idx=indexOf.call(seed,matched[i])]=!(matches[idx]=matched[i])})):function(elem){return fn(elem,0,args)}):fn}},pseudos:{not:markFunction((function(selector){var input=[],results=[],matcher=compile(selector.replace(rtrim,"$1"));return matcher[expando]?markFunction((function(seed,matches,context,xml){for(var elem,unmatched=matcher(seed,null,xml,[]),i=seed.length;i--;)(elem=unmatched[i])&&(seed[i]=!(matches[i]=elem))})):function(elem,context,xml){return input[0]=elem,matcher(input,null,xml,results),!results.pop()}})),has:markFunction((function(selector){return function(elem){return Sizzle(selector,elem).length>0}})),contains:markFunction((function(text){return function(elem){return(elem.textContent||elem.innerText||getText(elem)).indexOf(text)>-1}})),lang:markFunction((function(lang){return ridentifier.test(lang||"")||Sizzle.error("unsupported lang: "+lang),lang=lang.replace(runescape,funescape).toLowerCase(),function(elem){var elemLang;do{if(elemLang=documentIsHTML?elem.lang:elem.getAttribute("xml:lang")||elem.getAttribute("lang"))return(elemLang=elemLang.toLowerCase())===lang||0===elemLang.indexOf(lang+"-")}while((elem=elem.parentNode)&&1===elem.nodeType);return!1}})),target:function(elem){var hash=window.location&&window.location.hash;return hash&&hash.slice(1)===elem.id},root:function(elem){return elem===docElem},focus:function(elem){return elem===document.activeElement&&(!document.hasFocus||document.hasFocus())&&!!(elem.type||elem.href||~elem.tabIndex)},enabled:function(elem){return!1===elem.disabled},disabled:function(elem){return!0===elem.disabled},checked:function(elem){var nodeName=elem.nodeName.toLowerCase();return"input"===nodeName&&!!elem.checked||"option"===nodeName&&!!elem.selected},selected:function(elem){return elem.parentNode&&elem.parentNode.selectedIndex,!0===elem.selected},empty:function(elem){for(elem=elem.firstChild;elem;elem=elem.nextSibling)if(elem.nodeType<6)return!1;return!0},parent:function(elem){return!Expr.pseudos.empty(elem)},header:function(elem){return rheader.test(elem.nodeName)},input:function(elem){return rinputs.test(elem.nodeName)},button:function(elem){var name=elem.nodeName.toLowerCase();return"input"===name&&"button"===elem.type||"button"===name},text:function(elem){var attr;return"input"===elem.nodeName.toLowerCase()&&"text"===elem.type&&(null==(attr=elem.getAttribute("type"))||"text"===attr.toLowerCase())},first:createPositionalPseudo((function(){return[0]})),last:createPositionalPseudo((function(matchIndexes,length){return[length-1]})),eq:createPositionalPseudo((function(matchIndexes,length,argument){return[argument<0?argument+length:argument]})),even:createPositionalPseudo((function(matchIndexes,length){for(var i=0;i<length;i+=2)matchIndexes.push(i);return matchIndexes})),odd:createPositionalPseudo((function(matchIndexes,length){for(var i=1;i<length;i+=2)matchIndexes.push(i);return matchIndexes})),lt:createPositionalPseudo((function(matchIndexes,length,argument){for(var i=argument<0?argument+length:argument;--i>=0;)matchIndexes.push(i);return matchIndexes})),gt:createPositionalPseudo((function(matchIndexes,length,argument){for(var i=argument<0?argument+length:argument;++i<length;)matchIndexes.push(i);return matchIndexes}))}}).pseudos.nth=Expr.pseudos.eq,{radio:!0,checkbox:!0,file:!0,password:!0,image:!0})Expr.pseudos[i]=createInputPseudo(i);for(i in{submit:!0,reset:!0})Expr.pseudos[i]=createButtonPseudo(i);function setFilters(){}function tokenize(selector,parseOnly){var matched,match,tokens,type,soFar,groups,preFilters,cached=tokenCache[selector+" "];if(cached)return parseOnly?0:cached.slice(0);for(soFar=selector,groups=[],preFilters=Expr.preFilter;soFar;){for(type in matched&&!(match=rcomma.exec(soFar))||(match&&(soFar=soFar.slice(match[0].length)||soFar),groups.push(tokens=[])),matched=!1,(match=rcombinators.exec(soFar))&&(matched=match.shift(),tokens.push({value:matched,type:match[0].replace(rtrim," ")}),soFar=soFar.slice(matched.length)),Expr.filter)!(match=matchExpr[type].exec(soFar))||preFilters[type]&&!(match=preFilters[type](match))||(matched=match.shift(),tokens.push({value:matched,type:type,matches:match}),soFar=soFar.slice(matched.length));if(!matched)break}return parseOnly?soFar.length:soFar?Sizzle.error(selector):tokenCache(selector,groups).slice(0)}function toSelector(tokens){for(var i=0,len=tokens.length,selector="";i<len;i++)selector+=tokens[i].value;return selector}function addCombinator(matcher,combinator,base){var dir=combinator.dir,checkNonElements=base&&"parentNode"===dir,doneName=done++;return combinator.first?function(elem,context,xml){for(;elem=elem[dir];)if(1===elem.nodeType||checkNonElements)return matcher(elem,context,xml)}:function(elem,context,xml){var oldCache,outerCache,newCache=[dirruns,doneName];if(xml){for(;elem=elem[dir];)if((1===elem.nodeType||checkNonElements)&&matcher(elem,context,xml))return!0}else for(;elem=elem[dir];)if(1===elem.nodeType||checkNonElements){if((oldCache=(outerCache=elem[expando]||(elem[expando]={}))[dir])&&oldCache[0]===dirruns&&oldCache[1]===doneName)return newCache[2]=oldCache[2];if(outerCache[dir]=newCache,newCache[2]=matcher(elem,context,xml))return!0}}}function elementMatcher(matchers){return matchers.length>1?function(elem,context,xml){for(var i=matchers.length;i--;)if(!matchers[i](elem,context,xml))return!1;return!0}:matchers[0]}function condense(unmatched,map,filter,context,xml){for(var elem,newUnmatched=[],i=0,len=unmatched.length,mapped=null!=map;i<len;i++)(elem=unmatched[i])&&(filter&&!filter(elem,context,xml)||(newUnmatched.push(elem),mapped&&map.push(i)));return newUnmatched}function setMatcher(preFilter,selector,matcher,postFilter,postFinder,postSelector){return postFilter&&!postFilter[expando]&&(postFilter=setMatcher(postFilter)),postFinder&&!postFinder[expando]&&(postFinder=setMatcher(postFinder,postSelector)),markFunction((function(seed,results,context,xml){var temp,i,elem,preMap=[],postMap=[],preexisting=results.length,elems=seed||function(selector,contexts,results){for(var i=0,len=contexts.length;i<len;i++)Sizzle(selector,contexts[i],results);return results}(selector||"*",context.nodeType?[context]:context,[]),matcherIn=!preFilter||!seed&&selector?elems:condense(elems,preMap,preFilter,context,xml),matcherOut=matcher?postFinder||(seed?preFilter:preexisting||postFilter)?[]:results:matcherIn;if(matcher&&matcher(matcherIn,matcherOut,context,xml),postFilter)for(temp=condense(matcherOut,postMap),postFilter(temp,[],context,xml),i=temp.length;i--;)(elem=temp[i])&&(matcherOut[postMap[i]]=!(matcherIn[postMap[i]]=elem));if(seed){if(postFinder||preFilter){if(postFinder){for(temp=[],i=matcherOut.length;i--;)(elem=matcherOut[i])&&temp.push(matcherIn[i]=elem);postFinder(null,matcherOut=[],temp,xml)}for(i=matcherOut.length;i--;)(elem=matcherOut[i])&&(temp=postFinder?indexOf.call(seed,elem):preMap[i])>-1&&(seed[temp]=!(results[temp]=elem))}}else matcherOut=condense(matcherOut===results?matcherOut.splice(preexisting,matcherOut.length):matcherOut),postFinder?postFinder(null,results,matcherOut,xml):push.apply(results,matcherOut)}))}function matcherFromTokens(tokens){for(var checkContext,matcher,j,len=tokens.length,leadingRelative=Expr.relative[tokens[0].type],implicitRelative=leadingRelative||Expr.relative[" "],i=leadingRelative?1:0,matchContext=addCombinator((function(elem){return elem===checkContext}),implicitRelative,!0),matchAnyContext=addCombinator((function(elem){return indexOf.call(checkContext,elem)>-1}),implicitRelative,!0),matchers=[function(elem,context,xml){return!leadingRelative&&(xml||context!==outermostContext)||((checkContext=context).nodeType?matchContext(elem,context,xml):matchAnyContext(elem,context,xml))}];i<len;i++)if(matcher=Expr.relative[tokens[i].type])matchers=[addCombinator(elementMatcher(matchers),matcher)];else{if((matcher=Expr.filter[tokens[i].type].apply(null,tokens[i].matches))[expando]){for(j=++i;j<len&&!Expr.relative[tokens[j].type];j++);return setMatcher(i>1&&elementMatcher(matchers),i>1&&toSelector(tokens.slice(0,i-1).concat({value:" "===tokens[i-2].type?"*":""})).replace(rtrim,"$1"),matcher,i<j&&matcherFromTokens(tokens.slice(i,j)),j<len&&matcherFromTokens(tokens=tokens.slice(j)),j<len&&toSelector(tokens))}matchers.push(matcher)}return elementMatcher(matchers)}return setFilters.prototype=Expr.filters=Expr.pseudos,Expr.setFilters=new setFilters,compile=Sizzle.compile=function(selector,group){var i,setMatchers=[],elementMatchers=[],cached=compilerCache[selector+" "];if(!cached){for(group||(group=tokenize(selector)),i=group.length;i--;)(cached=matcherFromTokens(group[i]))[expando]?setMatchers.push(cached):elementMatchers.push(cached);cached=compilerCache(selector,function(elementMatchers,setMatchers){var bySet=setMatchers.length>0,byElement=elementMatchers.length>0,superMatcher=function(seed,context,xml,results,outermost){var elem,j,matcher,matchedCount=0,i="0",unmatched=seed&&[],setMatched=[],contextBackup=outermostContext,elems=seed||byElement&&Expr.find.TAG("*",outermost),dirrunsUnique=dirruns+=null==contextBackup?1:Math.random()||.1,len=elems.length;for(outermost&&(outermostContext=context!==document&&context);i!==len&&null!=(elem=elems[i]);i++){if(byElement&&elem){for(j=0;matcher=elementMatchers[j++];)if(matcher(elem,context,xml)){results.push(elem);break}outermost&&(dirruns=dirrunsUnique)}bySet&&((elem=!matcher&&elem)&&matchedCount--,seed&&unmatched.push(elem))}if(matchedCount+=i,bySet&&i!==matchedCount){for(j=0;matcher=setMatchers[j++];)matcher(unmatched,setMatched,context,xml);if(seed){if(matchedCount>0)for(;i--;)unmatched[i]||setMatched[i]||(setMatched[i]=pop.call(results));setMatched=condense(setMatched)}push.apply(results,setMatched),outermost&&!seed&&setMatched.length>0&&matchedCount+setMatchers.length>1&&Sizzle.uniqueSort(results)}return outermost&&(dirruns=dirrunsUnique,outermostContext=contextBackup),unmatched};return bySet?markFunction(superMatcher):superMatcher}(elementMatchers,setMatchers))}return cached},support.sortStable=expando.split("").sort(sortOrder).join("")===expando,support.detectDuplicates=!!hasDuplicate,setDocument(),support.sortDetached=assert((function(div1){return 1&div1.compareDocumentPosition(document.createElement("div"))})),assert((function(div){return div.innerHTML="<a href='#'></a>","#"===div.firstChild.getAttribute("href")}))||addHandle("type|href|height|width",(function(elem,name,isXML){if(!isXML)return elem.getAttribute(name,"type"===name.toLowerCase()?1:2)})),support.attributes&&assert((function(div){return div.innerHTML="<input/>",div.firstChild.setAttribute("value",""),""===div.firstChild.getAttribute("value")}))||addHandle("value",(function(elem,name,isXML){if(!isXML&&"input"===elem.nodeName.toLowerCase())return elem.defaultValue})),assert((function(div){return null==div.getAttribute("disabled")}))||addHandle(booleans,(function(elem,name,isXML){var val;if(!isXML)return!0===elem[name]?name.toLowerCase():(val=elem.getAttributeNode(name))&&val.specified?val.value:null})),Sizzle}(window);jQuery.find=Sizzle,jQuery.expr=Sizzle.selectors,jQuery.expr[":"]=jQuery.expr.pseudos,jQuery.unique=Sizzle.uniqueSort,jQuery.text=Sizzle.getText,jQuery.isXMLDoc=Sizzle.isXML,jQuery.contains=Sizzle.contains;var rneedsContext=jQuery.expr.match.needsContext,rsingleTag=/^<(\w+)\s*\/?>(?:<\/\1>|)$/,risSimple=/^.[^:#\[\.,]*$/;function winnow(elements,qualifier,not){if(jQuery.isFunction(qualifier))return jQuery.grep(elements,(function(elem,i){return!!qualifier.call(elem,i,elem)!==not}));if(qualifier.nodeType)return jQuery.grep(elements,(function(elem){return elem===qualifier!==not}));if("string"==typeof qualifier){if(risSimple.test(qualifier))return jQuery.filter(qualifier,elements,not);qualifier=jQuery.filter(qualifier,elements)}return jQuery.grep(elements,(function(elem){return indexOf.call(qualifier,elem)>=0!==not}))}jQuery.filter=function(expr,elems,not){var elem=elems[0];return not&&(expr=":not("+expr+")"),1===elems.length&&1===elem.nodeType?jQuery.find.matchesSelector(elem,expr)?[elem]:[]:jQuery.find.matches(expr,jQuery.grep(elems,(function(elem){return 1===elem.nodeType})))},jQuery.fn.extend({find:function(selector){var i,len=this.length,ret=[],self=this;if("string"!=typeof selector)return this.pushStack(jQuery(selector).filter((function(){for(i=0;i<len;i++)if(jQuery.contains(self[i],this))return!0})));for(i=0;i<len;i++)jQuery.find(selector,self[i],ret);return(ret=this.pushStack(len>1?jQuery.unique(ret):ret)).selector=this.selector?this.selector+" "+selector:selector,ret},filter:function(selector){return this.pushStack(winnow(this,selector||[],!1))},not:function(selector){return this.pushStack(winnow(this,selector||[],!0))},is:function(selector){return!!winnow(this,"string"==typeof selector&&rneedsContext.test(selector)?jQuery(selector):selector||[],!1).length}});var rootjQuery,rquickExpr=/^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]*))$/;(jQuery.fn.init=function(selector,context){var match,elem;if(!selector)return this;if("string"==typeof selector){if(!(match="<"===selector[0]&&">"===selector[selector.length-1]&&selector.length>=3?[null,selector,null]:rquickExpr.exec(selector))||!match[1]&&context)return!context||context.jquery?(context||rootjQuery).find(selector):this.constructor(context).find(selector);if(match[1]){if(context=context instanceof jQuery?context[0]:context,jQuery.merge(this,jQuery.parseHTML(match[1],context&&context.nodeType?context.ownerDocument||context:document,!0)),rsingleTag.test(match[1])&&jQuery.isPlainObject(context))for(match in context)jQuery.isFunction(this[match])?this[match](context[match]):this.attr(match,context[match]);return this}return(elem=document.getElementById(match[2]))&&elem.parentNode&&(this.length=1,this[0]=elem),this.context=document,this.selector=selector,this}return selector.nodeType?(this.context=this[0]=selector,this.length=1,this):jQuery.isFunction(selector)?void 0!==rootjQuery.ready?rootjQuery.ready(selector):selector(jQuery):(void 0!==selector.selector&&(this.selector=selector.selector,this.context=selector.context),jQuery.makeArray(selector,this))}).prototype=jQuery.fn,rootjQuery=jQuery(document);var rparentsprev=/^(?:parents|prev(?:Until|All))/,guaranteedUnique={children:!0,contents:!0,next:!0,prev:!0};function sibling(cur,dir){for(;(cur=cur[dir])&&1!==cur.nodeType;);return cur}jQuery.extend({dir:function(elem,dir,until){for(var matched=[],truncate=void 0!==until;(elem=elem[dir])&&9!==elem.nodeType;)if(1===elem.nodeType){if(truncate&&jQuery(elem).is(until))break;matched.push(elem)}return matched},sibling:function(n,elem){for(var matched=[];n;n=n.nextSibling)1===n.nodeType&&n!==elem&&matched.push(n);return matched}}),jQuery.fn.extend({has:function(target){var targets=jQuery(target,this),l=targets.length;return this.filter((function(){for(var i=0;i<l;i++)if(jQuery.contains(this,targets[i]))return!0}))},closest:function(selectors,context){for(var cur,i=0,l=this.length,matched=[],pos=rneedsContext.test(selectors)||"string"!=typeof selectors?jQuery(selectors,context||this.context):0;i<l;i++)for(cur=this[i];cur&&cur!==context;cur=cur.parentNode)if(cur.nodeType<11&&(pos?pos.index(cur)>-1:1===cur.nodeType&&jQuery.find.matchesSelector(cur,selectors))){matched.push(cur);break}return this.pushStack(matched.length>1?jQuery.unique(matched):matched)},index:function(elem){return elem?"string"==typeof elem?indexOf.call(jQuery(elem),this[0]):indexOf.call(this,elem.jquery?elem[0]:elem):this[0]&&this[0].parentNode?this.first().prevAll().length:-1},add:function(selector,context){return this.pushStack(jQuery.unique(jQuery.merge(this.get(),jQuery(selector,context))))},addBack:function(selector){return this.add(null==selector?this.prevObject:this.prevObject.filter(selector))}}),jQuery.each({parent:function(elem){var parent=elem.parentNode;return parent&&11!==parent.nodeType?parent:null},parents:function(elem){return jQuery.dir(elem,"parentNode")},parentsUntil:function(elem,i,until){return jQuery.dir(elem,"parentNode",until)},next:function(elem){return sibling(elem,"nextSibling")},prev:function(elem){return sibling(elem,"previousSibling")},nextAll:function(elem){return jQuery.dir(elem,"nextSibling")},prevAll:function(elem){return jQuery.dir(elem,"previousSibling")},nextUntil:function(elem,i,until){return jQuery.dir(elem,"nextSibling",until)},prevUntil:function(elem,i,until){return jQuery.dir(elem,"previousSibling",until)},siblings:function(elem){return jQuery.sibling((elem.parentNode||{}).firstChild,elem)},children:function(elem){return jQuery.sibling(elem.firstChild)},contents:function(elem){return elem.contentDocument||jQuery.merge([],elem.childNodes)}},(function(name,fn){jQuery.fn[name]=function(until,selector){var matched=jQuery.map(this,fn,until);return"Until"!==name.slice(-5)&&(selector=until),selector&&"string"==typeof selector&&(matched=jQuery.filter(selector,matched)),this.length>1&&(guaranteedUnique[name]||jQuery.unique(matched),rparentsprev.test(name)&&matched.reverse()),this.pushStack(matched)}}));var readyList,rnotwhite=/\S+/g,optionsCache={};function completed(){document.removeEventListener("DOMContentLoaded",completed,!1),window.removeEventListener("load",completed,!1),jQuery.ready()}jQuery.Callbacks=function(options){options="string"==typeof options?optionsCache[options]||function(options){var object=optionsCache[options]={};return jQuery.each(options.match(rnotwhite)||[],(function(_,flag){object[flag]=!0})),object}(options):jQuery.extend({},options);var memory,fired,firing,firingStart,firingLength,firingIndex,list=[],stack=!options.once&&[],fire=function(data){for(memory=options.memory&&data,fired=!0,firingIndex=firingStart||0,firingStart=0,firingLength=list.length,firing=!0;list&&firingIndex<firingLength;firingIndex++)if(!1===list[firingIndex].apply(data[0],data[1])&&options.stopOnFalse){memory=!1;break}firing=!1,list&&(stack?stack.length&&fire(stack.shift()):memory?list=[]:self.disable())},self={add:function(){if(list){var start=list.length;!function add(args){jQuery.each(args,(function(_,arg){var type=jQuery.type(arg);"function"===type?options.unique&&self.has(arg)||list.push(arg):arg&&arg.length&&"string"!==type&&add(arg)}))}(arguments),firing?firingLength=list.length:memory&&(firingStart=start,fire(memory))}return this},remove:function(){return list&&jQuery.each(arguments,(function(_,arg){for(var index;(index=jQuery.inArray(arg,list,index))>-1;)list.splice(index,1),firing&&(index<=firingLength&&firingLength--,index<=firingIndex&&firingIndex--)})),this},has:function(fn){return fn?jQuery.inArray(fn,list)>-1:!(!list||!list.length)},empty:function(){return list=[],firingLength=0,this},disable:function(){return list=stack=memory=void 0,this},disabled:function(){return!list},lock:function(){return stack=void 0,memory||self.disable(),this},locked:function(){return!stack},fireWith:function(context,args){return!list||fired&&!stack||(args=[context,(args=args||[]).slice?args.slice():args],firing?stack.push(args):fire(args)),this},fire:function(){return self.fireWith(this,arguments),this},fired:function(){return!!fired}};return self},jQuery.extend({Deferred:function(func){var tuples=[["resolve","done",jQuery.Callbacks("once memory"),"resolved"],["reject","fail",jQuery.Callbacks("once memory"),"rejected"],["notify","progress",jQuery.Callbacks("memory")]],state="pending",promise={state:function(){return state},always:function(){return deferred.done(arguments).fail(arguments),this},then:function(){var fns=arguments;return jQuery.Deferred((function(newDefer){jQuery.each(tuples,(function(i,tuple){var fn=jQuery.isFunction(fns[i])&&fns[i];deferred[tuple[1]]((function(){var returned=fn&&fn.apply(this,arguments);returned&&jQuery.isFunction(returned.promise)?returned.promise().done(newDefer.resolve).fail(newDefer.reject).progress(newDefer.notify):newDefer[tuple[0]+"With"](this===promise?newDefer.promise():this,fn?[returned]:arguments)}))})),fns=null})).promise()},promise:function(obj){return null!=obj?jQuery.extend(obj,promise):promise}},deferred={};return promise.pipe=promise.then,jQuery.each(tuples,(function(i,tuple){var list=tuple[2],stateString=tuple[3];promise[tuple[1]]=list.add,stateString&&list.add((function(){state=stateString}),tuples[1^i][2].disable,tuples[2][2].lock),deferred[tuple[0]]=function(){return deferred[tuple[0]+"With"](this===deferred?promise:this,arguments),this},deferred[tuple[0]+"With"]=list.fireWith})),promise.promise(deferred),func&&func.call(deferred,deferred),deferred},when:function(subordinate){var progressValues,progressContexts,resolveContexts,i=0,resolveValues=slice.call(arguments),length=resolveValues.length,remaining=1!==length||subordinate&&jQuery.isFunction(subordinate.promise)?length:0,deferred=1===remaining?subordinate:jQuery.Deferred(),updateFunc=function(i,contexts,values){return function(value){contexts[i]=this,values[i]=arguments.length>1?slice.call(arguments):value,values===progressValues?deferred.notifyWith(contexts,values):--remaining||deferred.resolveWith(contexts,values)}};if(length>1)for(progressValues=new Array(length),progressContexts=new Array(length),resolveContexts=new Array(length);i<length;i++)resolveValues[i]&&jQuery.isFunction(resolveValues[i].promise)?resolveValues[i].promise().done(updateFunc(i,resolveContexts,resolveValues)).fail(deferred.reject).progress(updateFunc(i,progressContexts,progressValues)):--remaining;return remaining||deferred.resolveWith(resolveContexts,resolveValues),deferred.promise()}}),jQuery.fn.ready=function(fn){return jQuery.ready.promise().done(fn),this},jQuery.extend({isReady:!1,readyWait:1,holdReady:function(hold){hold?jQuery.readyWait++:jQuery.ready(!0)},ready:function(wait){(!0===wait?--jQuery.readyWait:jQuery.isReady)||(jQuery.isReady=!0,!0!==wait&&--jQuery.readyWait>0||(readyList.resolveWith(document,[jQuery]),jQuery.fn.trigger&&jQuery(document).trigger("ready").off("ready")))}}),jQuery.ready.promise=function(obj){return readyList||(readyList=jQuery.Deferred(),"complete"===document.readyState?setTimeout(jQuery.ready):(document.addEventListener("DOMContentLoaded",completed,!1),window.addEventListener("load",completed,!1))),readyList.promise(obj)},jQuery.ready.promise();var access=jQuery.access=function(elems,fn,key,value,chainable,emptyGet,raw){var i=0,len=elems.length,bulk=null==key;if("object"===jQuery.type(key))for(i in chainable=!0,key)jQuery.access(elems,fn,i,key[i],!0,emptyGet,raw);else if(void 0!==value&&(chainable=!0,jQuery.isFunction(value)||(raw=!0),bulk&&(raw?(fn.call(elems,value),fn=null):(bulk=fn,fn=function(elem,key,value){return bulk.call(jQuery(elem),value)})),fn))for(;i<len;i++)fn(elems[i],key,raw?value:value.call(elems[i],i,fn(elems[i],key)));return chainable?elems:bulk?fn.call(elems):len?fn(elems[0],key):emptyGet};function Data(){Object.defineProperty(this.cache={},0,{get:function(){return{}}}),this.expando=jQuery.expando+Math.random()}jQuery.acceptData=function(owner){return 1===owner.nodeType||9===owner.nodeType||!+owner.nodeType},Data.uid=1,Data.accepts=jQuery.acceptData,Data.prototype={key:function(owner){if(!Data.accepts(owner))return 0;var descriptor={},unlock=owner[this.expando];if(!unlock){unlock=Data.uid++;try{descriptor[this.expando]={value:unlock},Object.defineProperties(owner,descriptor)}catch(e){descriptor[this.expando]=unlock,jQuery.extend(owner,descriptor)}}return this.cache[unlock]||(this.cache[unlock]={}),unlock},set:function(owner,data,value){var prop,unlock=this.key(owner),cache=this.cache[unlock];if("string"==typeof data)cache[data]=value;else if(jQuery.isEmptyObject(cache))jQuery.extend(this.cache[unlock],data);else for(prop in data)cache[prop]=data[prop];return cache},get:function(owner,key){var cache=this.cache[this.key(owner)];return void 0===key?cache:cache[key]},access:function(owner,key,value){var stored;return void 0===key||key&&"string"==typeof key&&void 0===value?void 0!==(stored=this.get(owner,key))?stored:this.get(owner,jQuery.camelCase(key)):(this.set(owner,key,value),void 0!==value?value:key)},remove:function(owner,key){var i,name,camel,unlock=this.key(owner),cache=this.cache[unlock];if(void 0===key)this.cache[unlock]={};else{jQuery.isArray(key)?name=key.concat(key.map(jQuery.camelCase)):(camel=jQuery.camelCase(key),name=key in cache?[key,camel]:(name=camel)in cache?[name]:name.match(rnotwhite)||[]),i=name.length;for(;i--;)delete cache[name[i]]}},hasData:function(owner){return!jQuery.isEmptyObject(this.cache[owner[this.expando]]||{})},discard:function(owner){owner[this.expando]&&delete this.cache[owner[this.expando]]}};var data_priv=new Data,data_user=new Data,rbrace=/^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,rmultiDash=/([A-Z])/g;function dataAttr(elem,key,data){var name;if(void 0===data&&1===elem.nodeType)if(name="data-"+key.replace(rmultiDash,"-$1").toLowerCase(),"string"==typeof(data=elem.getAttribute(name))){try{data="true"===data||"false"!==data&&("null"===data?null:+data+""===data?+data:rbrace.test(data)?jQuery.parseJSON(data):data)}catch(e){}data_user.set(elem,key,data)}else data=void 0;return data}jQuery.extend({hasData:function(elem){return data_user.hasData(elem)||data_priv.hasData(elem)},data:function(elem,name,data){return data_user.access(elem,name,data)},removeData:function(elem,name){data_user.remove(elem,name)},_data:function(elem,name,data){return data_priv.access(elem,name,data)},_removeData:function(elem,name){data_priv.remove(elem,name)}}),jQuery.fn.extend({data:function(key,value){var i,name,data,elem=this[0],attrs=elem&&elem.attributes;if(void 0===key){if(this.length&&(data=data_user.get(elem),1===elem.nodeType&&!data_priv.get(elem,"hasDataAttrs"))){for(i=attrs.length;i--;)0===(name=attrs[i].name).indexOf("data-")&&(name=jQuery.camelCase(name.slice(5)),dataAttr(elem,name,data[name]));data_priv.set(elem,"hasDataAttrs",!0)}return data}return"object"==typeof key?this.each((function(){data_user.set(this,key)})):access(this,(function(value){var data,camelKey=jQuery.camelCase(key);if(elem&&void 0===value)return void 0!==(data=data_user.get(elem,key))||void 0!==(data=data_user.get(elem,camelKey))||void 0!==(data=dataAttr(elem,camelKey,void 0))?data:void 0;this.each((function(){var data=data_user.get(this,camelKey);data_user.set(this,camelKey,value),-1!==key.indexOf("-")&&void 0!==data&&data_user.set(this,key,value)}))}),null,value,arguments.length>1,null,!0)},removeData:function(key){return this.each((function(){data_user.remove(this,key)}))}}),jQuery.extend({queue:function(elem,type,data){var queue;if(elem)return type=(type||"fx")+"queue",queue=data_priv.get(elem,type),data&&(!queue||jQuery.isArray(data)?queue=data_priv.access(elem,type,jQuery.makeArray(data)):queue.push(data)),queue||[]},dequeue:function(elem,type){type=type||"fx";var queue=jQuery.queue(elem,type),startLength=queue.length,fn=queue.shift(),hooks=jQuery._queueHooks(elem,type);"inprogress"===fn&&(fn=queue.shift(),startLength--),fn&&("fx"===type&&queue.unshift("inprogress"),delete hooks.stop,fn.call(elem,(function(){jQuery.dequeue(elem,type)}),hooks)),!startLength&&hooks&&hooks.empty.fire()},_queueHooks:function(elem,type){var key=type+"queueHooks";return data_priv.get(elem,key)||data_priv.access(elem,key,{empty:jQuery.Callbacks("once memory").add((function(){data_priv.remove(elem,[type+"queue",key])}))})}}),jQuery.fn.extend({queue:function(type,data){var setter=2;return"string"!=typeof type&&(data=type,type="fx",setter--),arguments.length<setter?jQuery.queue(this[0],type):void 0===data?this:this.each((function(){var queue=jQuery.queue(this,type,data);jQuery._queueHooks(this,type),"fx"===type&&"inprogress"!==queue[0]&&jQuery.dequeue(this,type)}))},dequeue:function(type){return this.each((function(){jQuery.dequeue(this,type)}))},clearQueue:function(type){return this.queue(type||"fx",[])},promise:function(type,obj){var tmp,count=1,defer=jQuery.Deferred(),elements=this,i=this.length,resolve=function(){--count||defer.resolveWith(elements,[elements])};for("string"!=typeof type&&(obj=type,type=void 0),type=type||"fx";i--;)(tmp=data_priv.get(elements[i],type+"queueHooks"))&&tmp.empty&&(count++,tmp.empty.add(resolve));return resolve(),defer.promise(obj)}});var div,pnum=/[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source,cssExpand=["Top","Right","Bottom","Left"],isHidden=function(elem,el){return elem=el||elem,"none"===jQuery.css(elem,"display")||!jQuery.contains(elem.ownerDocument,elem)},rcheckableType=/^(?:checkbox|radio)$/i;(div=document.createDocumentFragment().appendChild(document.createElement("div"))).innerHTML="<input type='radio' checked='checked' name='t'/>",support.checkClone=div.cloneNode(!0).cloneNode(!0).lastChild.checked,div.innerHTML="<textarea>x</textarea>",support.noCloneChecked=!!div.cloneNode(!0).lastChild.defaultValue,support.focusinBubbles="onfocusin"in window;var rkeyEvent=/^key/,rmouseEvent=/^(?:mouse|contextmenu)|click/,rfocusMorph=/^(?:focusinfocus|focusoutblur)$/,rtypenamespace=/^([^.]*)(?:\.(.+)|)$/;function returnTrue(){return!0}function returnFalse(){return!1}function safeActiveElement(){try{return document.activeElement}catch(err){}}jQuery.event={global:{},add:function(elem,types,handler,data,selector){var handleObjIn,eventHandle,tmp,events,t,handleObj,special,handlers,type,namespaces,origType,elemData=data_priv.get(elem);if(elemData)for(handler.handler&&(handler=(handleObjIn=handler).handler,selector=handleObjIn.selector),handler.guid||(handler.guid=jQuery.guid++),(events=elemData.events)||(events=elemData.events={}),(eventHandle=elemData.handle)||(eventHandle=elemData.handle=function(e){return void 0!==jQuery&&jQuery.event.triggered!==e.type?jQuery.event.dispatch.apply(elem,arguments):void 0}),t=(types=(types||"").match(rnotwhite)||[""]).length;t--;)type=origType=(tmp=rtypenamespace.exec(types[t])||[])[1],namespaces=(tmp[2]||"").split(".").sort(),type&&(special=jQuery.event.special[type]||{},type=(selector?special.delegateType:special.bindType)||type,special=jQuery.event.special[type]||{},handleObj=jQuery.extend({type:type,origType:origType,data:data,handler:handler,guid:handler.guid,selector:selector,needsContext:selector&&jQuery.expr.match.needsContext.test(selector),namespace:namespaces.join(".")},handleObjIn),(handlers=events[type])||((handlers=events[type]=[]).delegateCount=0,special.setup&&!1!==special.setup.call(elem,data,namespaces,eventHandle)||elem.addEventListener&&elem.addEventListener(type,eventHandle,!1)),special.add&&(special.add.call(elem,handleObj),handleObj.handler.guid||(handleObj.handler.guid=handler.guid)),selector?handlers.splice(handlers.delegateCount++,0,handleObj):handlers.push(handleObj),jQuery.event.global[type]=!0)},remove:function(elem,types,handler,selector,mappedTypes){var j,origCount,tmp,events,t,handleObj,special,handlers,type,namespaces,origType,elemData=data_priv.hasData(elem)&&data_priv.get(elem);if(elemData&&(events=elemData.events)){for(t=(types=(types||"").match(rnotwhite)||[""]).length;t--;)if(type=origType=(tmp=rtypenamespace.exec(types[t])||[])[1],namespaces=(tmp[2]||"").split(".").sort(),type){for(special=jQuery.event.special[type]||{},handlers=events[type=(selector?special.delegateType:special.bindType)||type]||[],tmp=tmp[2]&&new RegExp("(^|\\.)"+namespaces.join("\\.(?:.*\\.|)")+"(\\.|$)"),origCount=j=handlers.length;j--;)handleObj=handlers[j],!mappedTypes&&origType!==handleObj.origType||handler&&handler.guid!==handleObj.guid||tmp&&!tmp.test(handleObj.namespace)||selector&&selector!==handleObj.selector&&("**"!==selector||!handleObj.selector)||(handlers.splice(j,1),handleObj.selector&&handlers.delegateCount--,special.remove&&special.remove.call(elem,handleObj));origCount&&!handlers.length&&(special.teardown&&!1!==special.teardown.call(elem,namespaces,elemData.handle)||jQuery.removeEvent(elem,type,elemData.handle),delete events[type])}else for(type in events)jQuery.event.remove(elem,type+types[t],handler,selector,!0);jQuery.isEmptyObject(events)&&(delete elemData.handle,data_priv.remove(elem,"events"))}},trigger:function(event,data,elem,onlyHandlers){var i,cur,tmp,bubbleType,ontype,handle,special,eventPath=[elem||document],type=hasOwn.call(event,"type")?event.type:event,namespaces=hasOwn.call(event,"namespace")?event.namespace.split("."):[];if(cur=tmp=elem=elem||document,3!==elem.nodeType&&8!==elem.nodeType&&!rfocusMorph.test(type+jQuery.event.triggered)&&(type.indexOf(".")>=0&&(namespaces=type.split("."),type=namespaces.shift(),namespaces.sort()),ontype=type.indexOf(":")<0&&"on"+type,(event=event[jQuery.expando]?event:new jQuery.Event(type,"object"==typeof event&&event)).isTrigger=onlyHandlers?2:3,event.namespace=namespaces.join("."),event.namespace_re=event.namespace?new RegExp("(^|\\.)"+namespaces.join("\\.(?:.*\\.|)")+"(\\.|$)"):null,event.result=void 0,event.target||(event.target=elem),data=null==data?[event]:jQuery.makeArray(data,[event]),special=jQuery.event.special[type]||{},onlyHandlers||!special.trigger||!1!==special.trigger.apply(elem,data))){if(!onlyHandlers&&!special.noBubble&&!jQuery.isWindow(elem)){for(bubbleType=special.delegateType||type,rfocusMorph.test(bubbleType+type)||(cur=cur.parentNode);cur;cur=cur.parentNode)eventPath.push(cur),tmp=cur;tmp===(elem.ownerDocument||document)&&eventPath.push(tmp.defaultView||tmp.parentWindow||window)}for(i=0;(cur=eventPath[i++])&&!event.isPropagationStopped();)event.type=i>1?bubbleType:special.bindType||type,(handle=(data_priv.get(cur,"events")||{})[event.type]&&data_priv.get(cur,"handle"))&&handle.apply(cur,data),(handle=ontype&&cur[ontype])&&handle.apply&&jQuery.acceptData(cur)&&(event.result=handle.apply(cur,data),!1===event.result&&event.preventDefault());return event.type=type,onlyHandlers||event.isDefaultPrevented()||special._default&&!1!==special._default.apply(eventPath.pop(),data)||!jQuery.acceptData(elem)||ontype&&jQuery.isFunction(elem[type])&&!jQuery.isWindow(elem)&&((tmp=elem[ontype])&&(elem[ontype]=null),jQuery.event.triggered=type,elem[type](),jQuery.event.triggered=void 0,tmp&&(elem[ontype]=tmp)),event.result}},dispatch:function(event){event=jQuery.event.fix(event);var i,j,ret,matched,handleObj,handlerQueue=[],args=slice.call(arguments),handlers=(data_priv.get(this,"events")||{})[event.type]||[],special=jQuery.event.special[event.type]||{};if(args[0]=event,event.delegateTarget=this,!special.preDispatch||!1!==special.preDispatch.call(this,event)){for(handlerQueue=jQuery.event.handlers.call(this,event,handlers),i=0;(matched=handlerQueue[i++])&&!event.isPropagationStopped();)for(event.currentTarget=matched.elem,j=0;(handleObj=matched.handlers[j++])&&!event.isImmediatePropagationStopped();)event.namespace_re&&!event.namespace_re.test(handleObj.namespace)||(event.handleObj=handleObj,event.data=handleObj.data,void 0!==(ret=((jQuery.event.special[handleObj.origType]||{}).handle||handleObj.handler).apply(matched.elem,args))&&!1===(event.result=ret)&&(event.preventDefault(),event.stopPropagation()));return special.postDispatch&&special.postDispatch.call(this,event),event.result}},handlers:function(event,handlers){var i,matches,sel,handleObj,handlerQueue=[],delegateCount=handlers.delegateCount,cur=event.target;if(delegateCount&&cur.nodeType&&(!event.button||"click"!==event.type))for(;cur!==this;cur=cur.parentNode||this)if(!0!==cur.disabled||"click"!==event.type){for(matches=[],i=0;i<delegateCount;i++)void 0===matches[sel=(handleObj=handlers[i]).selector+" "]&&(matches[sel]=handleObj.needsContext?jQuery(sel,this).index(cur)>=0:jQuery.find(sel,this,null,[cur]).length),matches[sel]&&matches.push(handleObj);matches.length&&handlerQueue.push({elem:cur,handlers:matches})}return delegateCount<handlers.length&&handlerQueue.push({elem:this,handlers:handlers.slice(delegateCount)}),handlerQueue},props:"altKey bubbles cancelable ctrlKey currentTarget eventPhase metaKey relatedTarget shiftKey target timeStamp view which".split(" "),fixHooks:{},keyHooks:{props:"char charCode key keyCode".split(" "),filter:function(event,original){return null==event.which&&(event.which=null!=original.charCode?original.charCode:original.keyCode),event}},mouseHooks:{props:"button buttons clientX clientY offsetX offsetY pageX pageY screenX screenY toElement".split(" "),filter:function(event,original){var eventDoc,doc,body,button=original.button;return null==event.pageX&&null!=original.clientX&&(doc=(eventDoc=event.target.ownerDocument||document).documentElement,body=eventDoc.body,event.pageX=original.clientX+(doc&&doc.scrollLeft||body&&body.scrollLeft||0)-(doc&&doc.clientLeft||body&&body.clientLeft||0),event.pageY=original.clientY+(doc&&doc.scrollTop||body&&body.scrollTop||0)-(doc&&doc.clientTop||body&&body.clientTop||0)),event.which||void 0===button||(event.which=1&button?1:2&button?3:4&button?2:0),event}},fix:function(event){if(event[jQuery.expando])return event;var i,prop,copy,type=event.type,originalEvent=event,fixHook=this.fixHooks[type];for(fixHook||(this.fixHooks[type]=fixHook=rmouseEvent.test(type)?this.mouseHooks:rkeyEvent.test(type)?this.keyHooks:{}),copy=fixHook.props?this.props.concat(fixHook.props):this.props,event=new jQuery.Event(originalEvent),i=copy.length;i--;)event[prop=copy[i]]=originalEvent[prop];return event.target||(event.target=document),3===event.target.nodeType&&(event.target=event.target.parentNode),fixHook.filter?fixHook.filter(event,originalEvent):event},special:{load:{noBubble:!0},focus:{trigger:function(){if(this!==safeActiveElement()&&this.focus)return this.focus(),!1},delegateType:"focusin"},blur:{trigger:function(){if(this===safeActiveElement()&&this.blur)return this.blur(),!1},delegateType:"focusout"},click:{trigger:function(){if("checkbox"===this.type&&this.click&&jQuery.nodeName(this,"input"))return this.click(),!1},_default:function(event){return jQuery.nodeName(event.target,"a")}},beforeunload:{postDispatch:function(event){void 0!==event.result&&(event.originalEvent.returnValue=event.result)}}},simulate:function(type,elem,event,bubble){var e=jQuery.extend(new jQuery.Event,event,{type:type,isSimulated:!0,originalEvent:{}});bubble?jQuery.event.trigger(e,null,elem):jQuery.event.dispatch.call(elem,e),e.isDefaultPrevented()&&event.preventDefault()}},jQuery.removeEvent=function(elem,type,handle){elem.removeEventListener&&elem.removeEventListener(type,handle,!1)},jQuery.Event=function(src,props){if(!(this instanceof jQuery.Event))return new jQuery.Event(src,props);src&&src.type?(this.originalEvent=src,this.type=src.type,this.isDefaultPrevented=src.defaultPrevented||void 0===src.defaultPrevented&&src.getPreventDefault&&src.getPreventDefault()?returnTrue:returnFalse):this.type=src,props&&jQuery.extend(this,props),this.timeStamp=src&&src.timeStamp||jQuery.now(),this[jQuery.expando]=!0},jQuery.Event.prototype={isDefaultPrevented:returnFalse,isPropagationStopped:returnFalse,isImmediatePropagationStopped:returnFalse,preventDefault:function(){var e=this.originalEvent;this.isDefaultPrevented=returnTrue,e&&e.preventDefault&&e.preventDefault()},stopPropagation:function(){var e=this.originalEvent;this.isPropagationStopped=returnTrue,e&&e.stopPropagation&&e.stopPropagation()},stopImmediatePropagation:function(){this.isImmediatePropagationStopped=returnTrue,this.stopPropagation()}},jQuery.each({mouseenter:"mouseover",mouseleave:"mouseout"},(function(orig,fix){jQuery.event.special[orig]={delegateType:fix,bindType:fix,handle:function(event){var ret,target=this,related=event.relatedTarget,handleObj=event.handleObj;return related&&(related===target||jQuery.contains(target,related))||(event.type=handleObj.origType,ret=handleObj.handler.apply(this,arguments),event.type=fix),ret}}})),support.focusinBubbles||jQuery.each({focus:"focusin",blur:"focusout"},(function(orig,fix){var handler=function(event){jQuery.event.simulate(fix,event.target,jQuery.event.fix(event),!0)};jQuery.event.special[fix]={setup:function(){var doc=this.ownerDocument||this,attaches=data_priv.access(doc,fix);attaches||doc.addEventListener(orig,handler,!0),data_priv.access(doc,fix,(attaches||0)+1)},teardown:function(){var doc=this.ownerDocument||this,attaches=data_priv.access(doc,fix)-1;attaches?data_priv.access(doc,fix,attaches):(doc.removeEventListener(orig,handler,!0),data_priv.remove(doc,fix))}}})),jQuery.fn.extend({on:function(types,selector,data,fn,one){var origFn,type;if("object"==typeof types){for(type in"string"!=typeof selector&&(data=data||selector,selector=void 0),types)this.on(type,selector,data,types[type],one);return this}if(null==data&&null==fn?(fn=selector,data=selector=void 0):null==fn&&("string"==typeof selector?(fn=data,data=void 0):(fn=data,data=selector,selector=void 0)),!1===fn)fn=returnFalse;else if(!fn)return this;return 1===one&&(origFn=fn,(fn=function(event){return jQuery().off(event),origFn.apply(this,arguments)}).guid=origFn.guid||(origFn.guid=jQuery.guid++)),this.each((function(){jQuery.event.add(this,types,fn,data,selector)}))},one:function(types,selector,data,fn){return this.on(types,selector,data,fn,1)},off:function(types,selector,fn){var handleObj,type;if(types&&types.preventDefault&&types.handleObj)return handleObj=types.handleObj,jQuery(types.delegateTarget).off(handleObj.namespace?handleObj.origType+"."+handleObj.namespace:handleObj.origType,handleObj.selector,handleObj.handler),this;if("object"==typeof types){for(type in types)this.off(type,selector,types[type]);return this}return!1!==selector&&"function"!=typeof selector||(fn=selector,selector=void 0),!1===fn&&(fn=returnFalse),this.each((function(){jQuery.event.remove(this,types,fn,selector)}))},trigger:function(type,data){return this.each((function(){jQuery.event.trigger(type,data,this)}))},triggerHandler:function(type,data){var elem=this[0];if(elem)return jQuery.event.trigger(type,data,elem,!0)}});var rxhtmlTag=/<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/gi,rtagName=/<([\w:]+)/,rhtml=/<|&#?\w+;/,rnoInnerhtml=/<(?:script|style|link)/i,rchecked=/checked\s*(?:[^=]|=\s*.checked.)/i,rscriptType=/^$|\/(?:java|ecma)script/i,rscriptTypeMasked=/^true\/(.*)/,rcleanScript=/^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g,wrapMap={option:[1,"<select multiple='multiple'>","</select>"],thead:[1,"<table>","</table>"],col:[2,"<table><colgroup>","</colgroup></table>"],tr:[2,"<table><tbody>","</tbody></table>"],td:[3,"<table><tbody><tr>","</tr></tbody></table>"],_default:[0,"",""]};function manipulationTarget(elem,content){return jQuery.nodeName(elem,"table")&&jQuery.nodeName(11!==content.nodeType?content:content.firstChild,"tr")?elem.getElementsByTagName("tbody")[0]||elem.appendChild(elem.ownerDocument.createElement("tbody")):elem}function disableScript(elem){return elem.type=(null!==elem.getAttribute("type"))+"/"+elem.type,elem}function restoreScript(elem){var match=rscriptTypeMasked.exec(elem.type);return match?elem.type=match[1]:elem.removeAttribute("type"),elem}function setGlobalEval(elems,refElements){for(var i=0,l=elems.length;i<l;i++)data_priv.set(elems[i],"globalEval",!refElements||data_priv.get(refElements[i],"globalEval"))}function cloneCopyEvent(src,dest){var i,l,type,pdataOld,pdataCur,udataOld,udataCur,events;if(1===dest.nodeType){if(data_priv.hasData(src)&&(pdataOld=data_priv.access(src),pdataCur=data_priv.set(dest,pdataOld),events=pdataOld.events))for(type in delete pdataCur.handle,pdataCur.events={},events)for(i=0,l=events[type].length;i<l;i++)jQuery.event.add(dest,type,events[type][i]);data_user.hasData(src)&&(udataOld=data_user.access(src),udataCur=jQuery.extend({},udataOld),data_user.set(dest,udataCur))}}function getAll(context,tag){var ret=context.getElementsByTagName?context.getElementsByTagName(tag||"*"):context.querySelectorAll?context.querySelectorAll(tag||"*"):[];return void 0===tag||tag&&jQuery.nodeName(context,tag)?jQuery.merge([context],ret):ret}wrapMap.optgroup=wrapMap.option,wrapMap.tbody=wrapMap.tfoot=wrapMap.colgroup=wrapMap.caption=wrapMap.thead,wrapMap.th=wrapMap.td,jQuery.extend({clone:function(elem,dataAndEvents,deepDataAndEvents){var i,l,srcElements,destElements,src,dest,nodeName,clone=elem.cloneNode(!0),inPage=jQuery.contains(elem.ownerDocument,elem);if(!(support.noCloneChecked||1!==elem.nodeType&&11!==elem.nodeType||jQuery.isXMLDoc(elem)))for(destElements=getAll(clone),i=0,l=(srcElements=getAll(elem)).length;i<l;i++)src=srcElements[i],dest=destElements[i],nodeName=void 0,"input"===(nodeName=dest.nodeName.toLowerCase())&&rcheckableType.test(src.type)?dest.checked=src.checked:"input"!==nodeName&&"textarea"!==nodeName||(dest.defaultValue=src.defaultValue);if(dataAndEvents)if(deepDataAndEvents)for(srcElements=srcElements||getAll(elem),destElements=destElements||getAll(clone),i=0,l=srcElements.length;i<l;i++)cloneCopyEvent(srcElements[i],destElements[i]);else cloneCopyEvent(elem,clone);return(destElements=getAll(clone,"script")).length>0&&setGlobalEval(destElements,!inPage&&getAll(elem,"script")),clone},buildFragment:function(elems,context,scripts,selection){for(var elem,tmp,tag,wrap,contains,j,fragment=context.createDocumentFragment(),nodes=[],i=0,l=elems.length;i<l;i++)if((elem=elems[i])||0===elem)if("object"===jQuery.type(elem))jQuery.merge(nodes,elem.nodeType?[elem]:elem);else if(rhtml.test(elem)){for(tmp=tmp||fragment.appendChild(context.createElement("div")),tag=(rtagName.exec(elem)||["",""])[1].toLowerCase(),wrap=wrapMap[tag]||wrapMap._default,tmp.innerHTML=wrap[1]+elem.replace(rxhtmlTag,"<$1></$2>")+wrap[2],j=wrap[0];j--;)tmp=tmp.lastChild;jQuery.merge(nodes,tmp.childNodes),(tmp=fragment.firstChild).textContent=""}else nodes.push(context.createTextNode(elem));for(fragment.textContent="",i=0;elem=nodes[i++];)if((!selection||-1===jQuery.inArray(elem,selection))&&(contains=jQuery.contains(elem.ownerDocument,elem),tmp=getAll(fragment.appendChild(elem),"script"),contains&&setGlobalEval(tmp),scripts))for(j=0;elem=tmp[j++];)rscriptType.test(elem.type||"")&&scripts.push(elem);return fragment},cleanData:function(elems){for(var data,elem,events,type,key,j,special=jQuery.event.special,i=0;void 0!==(elem=elems[i]);i++){if(jQuery.acceptData(elem)&&(key=elem[data_priv.expando])&&(data=data_priv.cache[key])){if((events=Object.keys(data.events||{})).length)for(j=0;void 0!==(type=events[j]);j++)special[type]?jQuery.event.remove(elem,type):jQuery.removeEvent(elem,type,data.handle);data_priv.cache[key]&&delete data_priv.cache[key]}delete data_user.cache[elem[data_user.expando]]}}}),jQuery.fn.extend({text:function(value){return access(this,(function(value){return void 0===value?jQuery.text(this):this.empty().each((function(){1!==this.nodeType&&11!==this.nodeType&&9!==this.nodeType||(this.textContent=value)}))}),null,value,arguments.length)},append:function(){return this.domManip(arguments,(function(elem){1!==this.nodeType&&11!==this.nodeType&&9!==this.nodeType||manipulationTarget(this,elem).appendChild(elem)}))},prepend:function(){return this.domManip(arguments,(function(elem){if(1===this.nodeType||11===this.nodeType||9===this.nodeType){var target=manipulationTarget(this,elem);target.insertBefore(elem,target.firstChild)}}))},before:function(){return this.domManip(arguments,(function(elem){this.parentNode&&this.parentNode.insertBefore(elem,this)}))},after:function(){return this.domManip(arguments,(function(elem){this.parentNode&&this.parentNode.insertBefore(elem,this.nextSibling)}))},remove:function(selector,keepData){for(var elem,elems=selector?jQuery.filter(selector,this):this,i=0;null!=(elem=elems[i]);i++)keepData||1!==elem.nodeType||jQuery.cleanData(getAll(elem)),elem.parentNode&&(keepData&&jQuery.contains(elem.ownerDocument,elem)&&setGlobalEval(getAll(elem,"script")),elem.parentNode.removeChild(elem));return this},empty:function(){for(var elem,i=0;null!=(elem=this[i]);i++)1===elem.nodeType&&(jQuery.cleanData(getAll(elem,!1)),elem.textContent="");return this},clone:function(dataAndEvents,deepDataAndEvents){return dataAndEvents=null!=dataAndEvents&&dataAndEvents,deepDataAndEvents=null==deepDataAndEvents?dataAndEvents:deepDataAndEvents,this.map((function(){return jQuery.clone(this,dataAndEvents,deepDataAndEvents)}))},html:function(value){return access(this,(function(value){var elem=this[0]||{},i=0,l=this.length;if(void 0===value&&1===elem.nodeType)return elem.innerHTML;if("string"==typeof value&&!rnoInnerhtml.test(value)&&!wrapMap[(rtagName.exec(value)||["",""])[1].toLowerCase()]){value=value.replace(rxhtmlTag,"<$1></$2>");try{for(;i<l;i++)1===(elem=this[i]||{}).nodeType&&(jQuery.cleanData(getAll(elem,!1)),elem.innerHTML=value);elem=0}catch(e){}}elem&&this.empty().append(value)}),null,value,arguments.length)},replaceWith:function(){var arg=arguments[0];return this.domManip(arguments,(function(elem){arg=this.parentNode,jQuery.cleanData(getAll(this)),arg&&arg.replaceChild(elem,this)})),arg&&(arg.length||arg.nodeType)?this:this.remove()},detach:function(selector){return this.remove(selector,!0)},domManip:function(args,callback){args=concat.apply([],args);var fragment,first,scripts,hasScripts,node,doc,i=0,l=this.length,set=this,iNoClone=l-1,value=args[0],isFunction=jQuery.isFunction(value);if(isFunction||l>1&&"string"==typeof value&&!support.checkClone&&rchecked.test(value))return this.each((function(index){var self=set.eq(index);isFunction&&(args[0]=value.call(this,index,self.html())),self.domManip(args,callback)}));if(l&&(first=(fragment=jQuery.buildFragment(args,this[0].ownerDocument,!1,this)).firstChild,1===fragment.childNodes.length&&(fragment=first),first)){for(hasScripts=(scripts=jQuery.map(getAll(fragment,"script"),disableScript)).length;i<l;i++)node=fragment,i!==iNoClone&&(node=jQuery.clone(node,!0,!0),hasScripts&&jQuery.merge(scripts,getAll(node,"script"))),callback.call(this[i],node,i);if(hasScripts)for(doc=scripts[scripts.length-1].ownerDocument,jQuery.map(scripts,restoreScript),i=0;i<hasScripts;i++)node=scripts[i],rscriptType.test(node.type||"")&&!data_priv.access(node,"globalEval")&&jQuery.contains(doc,node)&&(node.src?jQuery._evalUrl&&jQuery._evalUrl(node.src):jQuery.globalEval(node.textContent.replace(rcleanScript,"")))}return this}}),jQuery.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},(function(name,original){jQuery.fn[name]=function(selector){for(var elems,ret=[],insert=jQuery(selector),last=insert.length-1,i=0;i<=last;i++)elems=i===last?this:this.clone(!0),jQuery(insert[i])[original](elems),push.apply(ret,elems.get());return this.pushStack(ret)}}));var iframe,elemdisplay={};function actualDisplay(name,doc){var elem=jQuery(doc.createElement(name)).appendTo(doc.body),display=window.getDefaultComputedStyle?window.getDefaultComputedStyle(elem[0]).display:jQuery.css(elem[0],"display");return elem.detach(),display}function defaultDisplay(nodeName){var doc=document,display=elemdisplay[nodeName];return display||("none"!==(display=actualDisplay(nodeName,doc))&&display||((doc=(iframe=(iframe||jQuery("<iframe frameborder='0' width='0' height='0'/>")).appendTo(doc.documentElement))[0].contentDocument).write(),doc.close(),display=actualDisplay(nodeName,doc),iframe.detach()),elemdisplay[nodeName]=display),display}var rmargin=/^margin/,rnumnonpx=new RegExp("^("+pnum+")(?!px)[a-z%]+$","i"),getStyles=function(elem){return elem.ownerDocument.defaultView.getComputedStyle(elem,null)};function curCSS(elem,name,computed){var width,minWidth,maxWidth,ret,style=elem.style;return(computed=computed||getStyles(elem))&&(ret=computed.getPropertyValue(name)||computed[name]),computed&&(""!==ret||jQuery.contains(elem.ownerDocument,elem)||(ret=jQuery.style(elem,name)),rnumnonpx.test(ret)&&rmargin.test(name)&&(width=style.width,minWidth=style.minWidth,maxWidth=style.maxWidth,style.minWidth=style.maxWidth=style.width=ret,ret=computed.width,style.width=width,style.minWidth=minWidth,style.maxWidth=maxWidth)),void 0!==ret?ret+"":ret}function addGetHookIf(conditionFn,hookFn){return{get:function(){if(!conditionFn())return(this.get=hookFn).apply(this,arguments);delete this.get}}}!function(){var pixelPositionVal,boxSizingReliableVal,docElem=document.documentElement,container=document.createElement("div"),div=document.createElement("div");function computePixelPositionAndBoxSizingReliable(){div.style.cssText="-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;padding:1px;border:1px;display:block;width:4px;margin-top:1%;position:absolute;top:1%",docElem.appendChild(container);var divStyle=window.getComputedStyle(div,null);pixelPositionVal="1%"!==divStyle.top,boxSizingReliableVal="4px"===divStyle.width,docElem.removeChild(container)}div.style.backgroundClip="content-box",div.cloneNode(!0).style.backgroundClip="",support.clearCloneStyle="content-box"===div.style.backgroundClip,container.style.cssText="border:0;width:0;height:0;position:absolute;top:0;left:-9999px;margin-top:1px",container.appendChild(div),window.getComputedStyle&&jQuery.extend(support,{pixelPosition:function(){return computePixelPositionAndBoxSizingReliable(),pixelPositionVal},boxSizingReliable:function(){return null==boxSizingReliableVal&&computePixelPositionAndBoxSizingReliable(),boxSizingReliableVal},reliableMarginRight:function(){var ret,marginDiv=div.appendChild(document.createElement("div"));return marginDiv.style.cssText=div.style.cssText="padding:0;margin:0;border:0;display:block;-webkit-box-sizing:content-box;-moz-box-sizing:content-box;box-sizing:content-box",marginDiv.style.marginRight=marginDiv.style.width="0",div.style.width="1px",docElem.appendChild(container),ret=!parseFloat(window.getComputedStyle(marginDiv,null).marginRight),docElem.removeChild(container),div.innerHTML="",ret}})}(),jQuery.swap=function(elem,options,callback,args){var ret,name,old={};for(name in options)old[name]=elem.style[name],elem.style[name]=options[name];for(name in ret=callback.apply(elem,args||[]),options)elem.style[name]=old[name];return ret};var rdisplayswap=/^(none|table(?!-c[ea]).+)/,rnumsplit=new RegExp("^("+pnum+")(.*)$","i"),rrelNum=new RegExp("^([+-])=("+pnum+")","i"),cssShow={position:"absolute",visibility:"hidden",display:"block"},cssNormalTransform={letterSpacing:0,fontWeight:400},cssPrefixes=["Webkit","O","Moz","ms"];function vendorPropName(style,name){if(name in style)return name;for(var capName=name[0].toUpperCase()+name.slice(1),origName=name,i=cssPrefixes.length;i--;)if((name=cssPrefixes[i]+capName)in style)return name;return origName}function setPositiveNumber(elem,value,subtract){var matches=rnumsplit.exec(value);return matches?Math.max(0,matches[1]-(subtract||0))+(matches[2]||"px"):value}function augmentWidthOrHeight(elem,name,extra,isBorderBox,styles){for(var i=extra===(isBorderBox?"border":"content")?4:"width"===name?1:0,val=0;i<4;i+=2)"margin"===extra&&(val+=jQuery.css(elem,extra+cssExpand[i],!0,styles)),isBorderBox?("content"===extra&&(val-=jQuery.css(elem,"padding"+cssExpand[i],!0,styles)),"margin"!==extra&&(val-=jQuery.css(elem,"border"+cssExpand[i]+"Width",!0,styles))):(val+=jQuery.css(elem,"padding"+cssExpand[i],!0,styles),"padding"!==extra&&(val+=jQuery.css(elem,"border"+cssExpand[i]+"Width",!0,styles)));return val}function getWidthOrHeight(elem,name,extra){var valueIsBorderBox=!0,val="width"===name?elem.offsetWidth:elem.offsetHeight,styles=getStyles(elem),isBorderBox="border-box"===jQuery.css(elem,"boxSizing",!1,styles);if(val<=0||null==val){if(((val=curCSS(elem,name,styles))<0||null==val)&&(val=elem.style[name]),rnumnonpx.test(val))return val;valueIsBorderBox=isBorderBox&&(support.boxSizingReliable()||val===elem.style[name]),val=parseFloat(val)||0}return val+augmentWidthOrHeight(elem,name,extra||(isBorderBox?"border":"content"),valueIsBorderBox,styles)+"px"}function showHide(elements,show){for(var display,elem,hidden,values=[],index=0,length=elements.length;index<length;index++)(elem=elements[index]).style&&(values[index]=data_priv.get(elem,"olddisplay"),display=elem.style.display,show?(values[index]||"none"!==display||(elem.style.display=""),""===elem.style.display&&isHidden(elem)&&(values[index]=data_priv.access(elem,"olddisplay",defaultDisplay(elem.nodeName)))):values[index]||(hidden=isHidden(elem),(display&&"none"!==display||!hidden)&&data_priv.set(elem,"olddisplay",hidden?display:jQuery.css(elem,"display"))));for(index=0;index<length;index++)(elem=elements[index]).style&&(show&&"none"!==elem.style.display&&""!==elem.style.display||(elem.style.display=show?values[index]||"":"none"));return elements}function Tween(elem,options,prop,end,easing){return new Tween.prototype.init(elem,options,prop,end,easing)}jQuery.extend({cssHooks:{opacity:{get:function(elem,computed){if(computed){var ret=curCSS(elem,"opacity");return""===ret?"1":ret}}}},cssNumber:{columnCount:!0,fillOpacity:!0,fontWeight:!0,lineHeight:!0,opacity:!0,order:!0,orphans:!0,widows:!0,zIndex:!0,zoom:!0},cssProps:{float:"cssFloat"},style:function(elem,name,value,extra){if(elem&&3!==elem.nodeType&&8!==elem.nodeType&&elem.style){var ret,type,hooks,origName=jQuery.camelCase(name),style=elem.style;if(name=jQuery.cssProps[origName]||(jQuery.cssProps[origName]=vendorPropName(style,origName)),hooks=jQuery.cssHooks[name]||jQuery.cssHooks[origName],void 0===value)return hooks&&"get"in hooks&&void 0!==(ret=hooks.get(elem,!1,extra))?ret:style[name];"string"==(type=typeof value)&&(ret=rrelNum.exec(value))&&(value=(ret[1]+1)*ret[2]+parseFloat(jQuery.css(elem,name)),type="number"),null!=value&&value==value&&("number"!==type||jQuery.cssNumber[origName]||(value+="px"),support.clearCloneStyle||""!==value||0!==name.indexOf("background")||(style[name]="inherit"),hooks&&"set"in hooks&&void 0===(value=hooks.set(elem,value,extra))||(style[name]="",style[name]=value))}},css:function(elem,name,extra,styles){var val,num,hooks,origName=jQuery.camelCase(name);return name=jQuery.cssProps[origName]||(jQuery.cssProps[origName]=vendorPropName(elem.style,origName)),(hooks=jQuery.cssHooks[name]||jQuery.cssHooks[origName])&&"get"in hooks&&(val=hooks.get(elem,!0,extra)),void 0===val&&(val=curCSS(elem,name,styles)),"normal"===val&&name in cssNormalTransform&&(val=cssNormalTransform[name]),""===extra||extra?(num=parseFloat(val),!0===extra||jQuery.isNumeric(num)?num||0:val):val}}),jQuery.each(["height","width"],(function(i,name){jQuery.cssHooks[name]={get:function(elem,computed,extra){if(computed)return 0===elem.offsetWidth&&rdisplayswap.test(jQuery.css(elem,"display"))?jQuery.swap(elem,cssShow,(function(){return getWidthOrHeight(elem,name,extra)})):getWidthOrHeight(elem,name,extra)},set:function(elem,value,extra){var styles=extra&&getStyles(elem);return setPositiveNumber(0,value,extra?augmentWidthOrHeight(elem,name,extra,"border-box"===jQuery.css(elem,"boxSizing",!1,styles),styles):0)}}})),jQuery.cssHooks.marginRight=addGetHookIf(support.reliableMarginRight,(function(elem,computed){if(computed)return jQuery.swap(elem,{display:"inline-block"},curCSS,[elem,"marginRight"])})),jQuery.each({margin:"",padding:"",border:"Width"},(function(prefix,suffix){jQuery.cssHooks[prefix+suffix]={expand:function(value){for(var i=0,expanded={},parts="string"==typeof value?value.split(" "):[value];i<4;i++)expanded[prefix+cssExpand[i]+suffix]=parts[i]||parts[i-2]||parts[0];return expanded}},rmargin.test(prefix)||(jQuery.cssHooks[prefix+suffix].set=setPositiveNumber)})),jQuery.fn.extend({css:function(name,value){return access(this,(function(elem,name,value){var styles,len,map={},i=0;if(jQuery.isArray(name)){for(styles=getStyles(elem),len=name.length;i<len;i++)map[name[i]]=jQuery.css(elem,name[i],!1,styles);return map}return void 0!==value?jQuery.style(elem,name,value):jQuery.css(elem,name)}),name,value,arguments.length>1)},show:function(){return showHide(this,!0)},hide:function(){return showHide(this)},toggle:function(state){return"boolean"==typeof state?state?this.show():this.hide():this.each((function(){isHidden(this)?jQuery(this).show():jQuery(this).hide()}))}}),jQuery.Tween=Tween,Tween.prototype={constructor:Tween,init:function(elem,options,prop,end,easing,unit){this.elem=elem,this.prop=prop,this.easing=easing||"swing",this.options=options,this.start=this.now=this.cur(),this.end=end,this.unit=unit||(jQuery.cssNumber[prop]?"":"px")},cur:function(){var hooks=Tween.propHooks[this.prop];return hooks&&hooks.get?hooks.get(this):Tween.propHooks._default.get(this)},run:function(percent){var eased,hooks=Tween.propHooks[this.prop];return this.options.duration?this.pos=eased=jQuery.easing[this.easing](percent,this.options.duration*percent,0,1,this.options.duration):this.pos=eased=percent,this.now=(this.end-this.start)*eased+this.start,this.options.step&&this.options.step.call(this.elem,this.now,this),hooks&&hooks.set?hooks.set(this):Tween.propHooks._default.set(this),this}},Tween.prototype.init.prototype=Tween.prototype,Tween.propHooks={_default:{get:function(tween){var result;return null==tween.elem[tween.prop]||tween.elem.style&&null!=tween.elem.style[tween.prop]?(result=jQuery.css(tween.elem,tween.prop,""))&&"auto"!==result?result:0:tween.elem[tween.prop]},set:function(tween){jQuery.fx.step[tween.prop]?jQuery.fx.step[tween.prop](tween):tween.elem.style&&(null!=tween.elem.style[jQuery.cssProps[tween.prop]]||jQuery.cssHooks[tween.prop])?jQuery.style(tween.elem,tween.prop,tween.now+tween.unit):tween.elem[tween.prop]=tween.now}}},Tween.propHooks.scrollTop=Tween.propHooks.scrollLeft={set:function(tween){tween.elem.nodeType&&tween.elem.parentNode&&(tween.elem[tween.prop]=tween.now)}},jQuery.easing={linear:function(p){return p},swing:function(p){return.5-Math.cos(p*Math.PI)/2}},jQuery.fx=Tween.prototype.init,jQuery.fx.step={};var fxNow,timerId,input,select,opt,rfxtypes=/^(?:toggle|show|hide)$/,rfxnum=new RegExp("^(?:([+-])=|)("+pnum+")([a-z%]*)$","i"),rrun=/queueHooks$/,animationPrefilters=[function(elem,props,opts){var prop,value,toggle,tween,hooks,oldfire,display,anim=this,orig={},style=elem.style,hidden=elem.nodeType&&isHidden(elem),dataShow=data_priv.get(elem,"fxshow");for(prop in opts.queue||(null==(hooks=jQuery._queueHooks(elem,"fx")).unqueued&&(hooks.unqueued=0,oldfire=hooks.empty.fire,hooks.empty.fire=function(){hooks.unqueued||oldfire()}),hooks.unqueued++,anim.always((function(){anim.always((function(){hooks.unqueued--,jQuery.queue(elem,"fx").length||hooks.empty.fire()}))}))),1===elem.nodeType&&("height"in props||"width"in props)&&(opts.overflow=[style.overflow,style.overflowX,style.overflowY],"none"===(display=jQuery.css(elem,"display"))&&(display=defaultDisplay(elem.nodeName)),"inline"===display&&"none"===jQuery.css(elem,"float")&&(style.display="inline-block")),opts.overflow&&(style.overflow="hidden",anim.always((function(){style.overflow=opts.overflow[0],style.overflowX=opts.overflow[1],style.overflowY=opts.overflow[2]}))),props)if(value=props[prop],rfxtypes.exec(value)){if(delete props[prop],toggle=toggle||"toggle"===value,value===(hidden?"hide":"show")){if("show"!==value||!dataShow||void 0===dataShow[prop])continue;hidden=!0}orig[prop]=dataShow&&dataShow[prop]||jQuery.style(elem,prop)}if(!jQuery.isEmptyObject(orig))for(prop in dataShow?"hidden"in dataShow&&(hidden=dataShow.hidden):dataShow=data_priv.access(elem,"fxshow",{}),toggle&&(dataShow.hidden=!hidden),hidden?jQuery(elem).show():anim.done((function(){jQuery(elem).hide()})),anim.done((function(){var prop;for(prop in data_priv.remove(elem,"fxshow"),orig)jQuery.style(elem,prop,orig[prop])})),orig)tween=createTween(hidden?dataShow[prop]:0,prop,anim),prop in dataShow||(dataShow[prop]=tween.start,hidden&&(tween.end=tween.start,tween.start="width"===prop||"height"===prop?1:0))}],tweeners={"*":[function(prop,value){var tween=this.createTween(prop,value),target=tween.cur(),parts=rfxnum.exec(value),unit=parts&&parts[3]||(jQuery.cssNumber[prop]?"":"px"),start=(jQuery.cssNumber[prop]||"px"!==unit&&+target)&&rfxnum.exec(jQuery.css(tween.elem,prop)),scale=1,maxIterations=20;if(start&&start[3]!==unit){unit=unit||start[3],parts=parts||[],start=+target||1;do{start/=scale=scale||".5",jQuery.style(tween.elem,prop,start+unit)}while(scale!==(scale=tween.cur()/target)&&1!==scale&&--maxIterations)}return parts&&(start=tween.start=+start||+target||0,tween.unit=unit,tween.end=parts[1]?start+(parts[1]+1)*parts[2]:+parts[2]),tween}]};function createFxNow(){return setTimeout((function(){fxNow=void 0})),fxNow=jQuery.now()}function genFx(type,includeWidth){var which,i=0,attrs={height:type};for(includeWidth=includeWidth?1:0;i<4;i+=2-includeWidth)attrs["margin"+(which=cssExpand[i])]=attrs["padding"+which]=type;return includeWidth&&(attrs.opacity=attrs.width=type),attrs}function createTween(value,prop,animation){for(var tween,collection=(tweeners[prop]||[]).concat(tweeners["*"]),index=0,length=collection.length;index<length;index++)if(tween=collection[index].call(animation,prop,value))return tween}function Animation(elem,properties,options){var result,stopped,index=0,length=animationPrefilters.length,deferred=jQuery.Deferred().always((function(){delete tick.elem})),tick=function(){if(stopped)return!1;for(var currentTime=fxNow||createFxNow(),remaining=Math.max(0,animation.startTime+animation.duration-currentTime),percent=1-(remaining/animation.duration||0),index=0,length=animation.tweens.length;index<length;index++)animation.tweens[index].run(percent);return deferred.notifyWith(elem,[animation,percent,remaining]),percent<1&&length?remaining:(deferred.resolveWith(elem,[animation]),!1)},animation=deferred.promise({elem:elem,props:jQuery.extend({},properties),opts:jQuery.extend(!0,{specialEasing:{}},options),originalProperties:properties,originalOptions:options,startTime:fxNow||createFxNow(),duration:options.duration,tweens:[],createTween:function(prop,end){var tween=jQuery.Tween(elem,animation.opts,prop,end,animation.opts.specialEasing[prop]||animation.opts.easing);return animation.tweens.push(tween),tween},stop:function(gotoEnd){var index=0,length=gotoEnd?animation.tweens.length:0;if(stopped)return this;for(stopped=!0;index<length;index++)animation.tweens[index].run(1);return gotoEnd?deferred.resolveWith(elem,[animation,gotoEnd]):deferred.rejectWith(elem,[animation,gotoEnd]),this}}),props=animation.props;for(function(props,specialEasing){var index,name,easing,value,hooks;for(index in props)if(easing=specialEasing[name=jQuery.camelCase(index)],value=props[index],jQuery.isArray(value)&&(easing=value[1],value=props[index]=value[0]),index!==name&&(props[name]=value,delete props[index]),(hooks=jQuery.cssHooks[name])&&"expand"in hooks)for(index in value=hooks.expand(value),delete props[name],value)index in props||(props[index]=value[index],specialEasing[index]=easing);else specialEasing[name]=easing}(props,animation.opts.specialEasing);index<length;index++)if(result=animationPrefilters[index].call(animation,elem,props,animation.opts))return result;return jQuery.map(props,createTween,animation),jQuery.isFunction(animation.opts.start)&&animation.opts.start.call(elem,animation),jQuery.fx.timer(jQuery.extend(tick,{elem:elem,anim:animation,queue:animation.opts.queue})),animation.progress(animation.opts.progress).done(animation.opts.done,animation.opts.complete).fail(animation.opts.fail).always(animation.opts.always)}jQuery.Animation=jQuery.extend(Animation,{tweener:function(props,callback){jQuery.isFunction(props)?(callback=props,props=["*"]):props=props.split(" ");for(var prop,index=0,length=props.length;index<length;index++)prop=props[index],tweeners[prop]=tweeners[prop]||[],tweeners[prop].unshift(callback)},prefilter:function(callback,prepend){prepend?animationPrefilters.unshift(callback):animationPrefilters.push(callback)}}),jQuery.speed=function(speed,easing,fn){var opt=speed&&"object"==typeof speed?jQuery.extend({},speed):{complete:fn||!fn&&easing||jQuery.isFunction(speed)&&speed,duration:speed,easing:fn&&easing||easing&&!jQuery.isFunction(easing)&&easing};return opt.duration=jQuery.fx.off?0:"number"==typeof opt.duration?opt.duration:opt.duration in jQuery.fx.speeds?jQuery.fx.speeds[opt.duration]:jQuery.fx.speeds._default,null!=opt.queue&&!0!==opt.queue||(opt.queue="fx"),opt.old=opt.complete,opt.complete=function(){jQuery.isFunction(opt.old)&&opt.old.call(this),opt.queue&&jQuery.dequeue(this,opt.queue)},opt},jQuery.fn.extend({fadeTo:function(speed,to,easing,callback){return this.filter(isHidden).css("opacity",0).show().end().animate({opacity:to},speed,easing,callback)},animate:function(prop,speed,easing,callback){var empty=jQuery.isEmptyObject(prop),optall=jQuery.speed(speed,easing,callback),doAnimation=function(){var anim=Animation(this,jQuery.extend({},prop),optall);(empty||data_priv.get(this,"finish"))&&anim.stop(!0)};return doAnimation.finish=doAnimation,empty||!1===optall.queue?this.each(doAnimation):this.queue(optall.queue,doAnimation)},stop:function(type,clearQueue,gotoEnd){var stopQueue=function(hooks){var stop=hooks.stop;delete hooks.stop,stop(gotoEnd)};return"string"!=typeof type&&(gotoEnd=clearQueue,clearQueue=type,type=void 0),clearQueue&&!1!==type&&this.queue(type||"fx",[]),this.each((function(){var dequeue=!0,index=null!=type&&type+"queueHooks",timers=jQuery.timers,data=data_priv.get(this);if(index)data[index]&&data[index].stop&&stopQueue(data[index]);else for(index in data)data[index]&&data[index].stop&&rrun.test(index)&&stopQueue(data[index]);for(index=timers.length;index--;)timers[index].elem!==this||null!=type&&timers[index].queue!==type||(timers[index].anim.stop(gotoEnd),dequeue=!1,timers.splice(index,1));!dequeue&&gotoEnd||jQuery.dequeue(this,type)}))},finish:function(type){return!1!==type&&(type=type||"fx"),this.each((function(){var index,data=data_priv.get(this),queue=data[type+"queue"],hooks=data[type+"queueHooks"],timers=jQuery.timers,length=queue?queue.length:0;for(data.finish=!0,jQuery.queue(this,type,[]),hooks&&hooks.stop&&hooks.stop.call(this,!0),index=timers.length;index--;)timers[index].elem===this&&timers[index].queue===type&&(timers[index].anim.stop(!0),timers.splice(index,1));for(index=0;index<length;index++)queue[index]&&queue[index].finish&&queue[index].finish.call(this);delete data.finish}))}}),jQuery.each(["toggle","show","hide"],(function(i,name){var cssFn=jQuery.fn[name];jQuery.fn[name]=function(speed,easing,callback){return null==speed||"boolean"==typeof speed?cssFn.apply(this,arguments):this.animate(genFx(name,!0),speed,easing,callback)}})),jQuery.each({slideDown:genFx("show"),slideUp:genFx("hide"),slideToggle:genFx("toggle"),fadeIn:{opacity:"show"},fadeOut:{opacity:"hide"},fadeToggle:{opacity:"toggle"}},(function(name,props){jQuery.fn[name]=function(speed,easing,callback){return this.animate(props,speed,easing,callback)}})),jQuery.timers=[],jQuery.fx.tick=function(){var timer,i=0,timers=jQuery.timers;for(fxNow=jQuery.now();i<timers.length;i++)(timer=timers[i])()||timers[i]!==timer||timers.splice(i--,1);timers.length||jQuery.fx.stop(),fxNow=void 0},jQuery.fx.timer=function(timer){jQuery.timers.push(timer),timer()?jQuery.fx.start():jQuery.timers.pop()},jQuery.fx.interval=13,jQuery.fx.start=function(){timerId||(timerId=setInterval(jQuery.fx.tick,jQuery.fx.interval))},jQuery.fx.stop=function(){clearInterval(timerId),timerId=null},jQuery.fx.speeds={slow:600,fast:200,_default:400},jQuery.fn.delay=function(time,type){return time=jQuery.fx&&jQuery.fx.speeds[time]||time,type=type||"fx",this.queue(type,(function(next,hooks){var timeout=setTimeout(next,time);hooks.stop=function(){clearTimeout(timeout)}}))},input=document.createElement("input"),select=document.createElement("select"),opt=select.appendChild(document.createElement("option")),input.type="checkbox",support.checkOn=""!==input.value,support.optSelected=opt.selected,select.disabled=!0,support.optDisabled=!opt.disabled,(input=document.createElement("input")).value="t",input.type="radio",support.radioValue="t"===input.value;var boolHook,attrHandle=jQuery.expr.attrHandle;jQuery.fn.extend({attr:function(name,value){return access(this,jQuery.attr,name,value,arguments.length>1)},removeAttr:function(name){return this.each((function(){jQuery.removeAttr(this,name)}))}}),jQuery.extend({attr:function(elem,name,value){var hooks,ret,nType=elem.nodeType;if(elem&&3!==nType&&8!==nType&&2!==nType)return void 0===elem.getAttribute?jQuery.prop(elem,name,value):(1===nType&&jQuery.isXMLDoc(elem)||(name=name.toLowerCase(),hooks=jQuery.attrHooks[name]||(jQuery.expr.match.bool.test(name)?boolHook:void 0)),void 0===value?hooks&&"get"in hooks&&null!==(ret=hooks.get(elem,name))?ret:null==(ret=jQuery.find.attr(elem,name))?void 0:ret:null!==value?hooks&&"set"in hooks&&void 0!==(ret=hooks.set(elem,value,name))?ret:(elem.setAttribute(name,value+""),value):void jQuery.removeAttr(elem,name))},removeAttr:function(elem,value){var name,propName,i=0,attrNames=value&&value.match(rnotwhite);if(attrNames&&1===elem.nodeType)for(;name=attrNames[i++];)propName=jQuery.propFix[name]||name,jQuery.expr.match.bool.test(name)&&(elem[propName]=!1),elem.removeAttribute(name)},attrHooks:{type:{set:function(elem,value){if(!support.radioValue&&"radio"===value&&jQuery.nodeName(elem,"input")){var val=elem.value;return elem.setAttribute("type",value),val&&(elem.value=val),value}}}}}),boolHook={set:function(elem,value,name){return!1===value?jQuery.removeAttr(elem,name):elem.setAttribute(name,name),name}},jQuery.each(jQuery.expr.match.bool.source.match(/\w+/g),(function(i,name){var getter=attrHandle[name]||jQuery.find.attr;attrHandle[name]=function(elem,name,isXML){var ret,handle;return isXML||(handle=attrHandle[name],attrHandle[name]=ret,ret=null!=getter(elem,name,isXML)?name.toLowerCase():null,attrHandle[name]=handle),ret}}));var rfocusable=/^(?:input|select|textarea|button)$/i;jQuery.fn.extend({prop:function(name,value){return access(this,jQuery.prop,name,value,arguments.length>1)},removeProp:function(name){return this.each((function(){delete this[jQuery.propFix[name]||name]}))}}),jQuery.extend({propFix:{for:"htmlFor",class:"className"},prop:function(elem,name,value){var ret,hooks,nType=elem.nodeType;if(elem&&3!==nType&&8!==nType&&2!==nType)return(1!==nType||!jQuery.isXMLDoc(elem))&&(name=jQuery.propFix[name]||name,hooks=jQuery.propHooks[name]),void 0!==value?hooks&&"set"in hooks&&void 0!==(ret=hooks.set(elem,value,name))?ret:elem[name]=value:hooks&&"get"in hooks&&null!==(ret=hooks.get(elem,name))?ret:elem[name]},propHooks:{tabIndex:{get:function(elem){return elem.hasAttribute("tabindex")||rfocusable.test(elem.nodeName)||elem.href?elem.tabIndex:-1}}}}),support.optSelected||(jQuery.propHooks.selected={get:function(elem){var parent=elem.parentNode;return parent&&parent.parentNode&&parent.parentNode.selectedIndex,null}}),jQuery.each(["tabIndex","readOnly","maxLength","cellSpacing","cellPadding","rowSpan","colSpan","useMap","frameBorder","contentEditable"],(function(){jQuery.propFix[this.toLowerCase()]=this}));var rclass=/[\t\r\n\f]/g;jQuery.fn.extend({addClass:function(value){var classes,elem,cur,clazz,j,finalValue,proceed="string"==typeof value&&value,i=0,len=this.length;if(jQuery.isFunction(value))return this.each((function(j){jQuery(this).addClass(value.call(this,j,this.className))}));if(proceed)for(classes=(value||"").match(rnotwhite)||[];i<len;i++)if(cur=1===(elem=this[i]).nodeType&&(elem.className?(" "+elem.className+" ").replace(rclass," "):" ")){for(j=0;clazz=classes[j++];)cur.indexOf(" "+clazz+" ")<0&&(cur+=clazz+" ");finalValue=jQuery.trim(cur),elem.className!==finalValue&&(elem.className=finalValue)}return this},removeClass:function(value){var classes,elem,cur,clazz,j,finalValue,proceed=0===arguments.length||"string"==typeof value&&value,i=0,len=this.length;if(jQuery.isFunction(value))return this.each((function(j){jQuery(this).removeClass(value.call(this,j,this.className))}));if(proceed)for(classes=(value||"").match(rnotwhite)||[];i<len;i++)if(cur=1===(elem=this[i]).nodeType&&(elem.className?(" "+elem.className+" ").replace(rclass," "):"")){for(j=0;clazz=classes[j++];)for(;cur.indexOf(" "+clazz+" ")>=0;)cur=cur.replace(" "+clazz+" "," ");finalValue=value?jQuery.trim(cur):"",elem.className!==finalValue&&(elem.className=finalValue)}return this},toggleClass:function(value,stateVal){var type=typeof value;return"boolean"==typeof stateVal&&"string"===type?stateVal?this.addClass(value):this.removeClass(value):jQuery.isFunction(value)?this.each((function(i){jQuery(this).toggleClass(value.call(this,i,this.className,stateVal),stateVal)})):this.each((function(){if("string"===type)for(var className,i=0,self=jQuery(this),classNames=value.match(rnotwhite)||[];className=classNames[i++];)self.hasClass(className)?self.removeClass(className):self.addClass(className);else"undefined"!==type&&"boolean"!==type||(this.className&&data_priv.set(this,"__className__",this.className),this.className=this.className||!1===value?"":data_priv.get(this,"__className__")||"")}))},hasClass:function(selector){for(var className=" "+selector+" ",i=0,l=this.length;i<l;i++)if(1===this[i].nodeType&&(" "+this[i].className+" ").replace(rclass," ").indexOf(className)>=0)return!0;return!1}});var rreturn=/\r/g;jQuery.fn.extend({val:function(value){var hooks,ret,isFunction,elem=this[0];return arguments.length?(isFunction=jQuery.isFunction(value),this.each((function(i){var val;1===this.nodeType&&(null==(val=isFunction?value.call(this,i,jQuery(this).val()):value)?val="":"number"==typeof val?val+="":jQuery.isArray(val)&&(val=jQuery.map(val,(function(value){return null==value?"":value+""}))),(hooks=jQuery.valHooks[this.type]||jQuery.valHooks[this.nodeName.toLowerCase()])&&"set"in hooks&&void 0!==hooks.set(this,val,"value")||(this.value=val))}))):elem?(hooks=jQuery.valHooks[elem.type]||jQuery.valHooks[elem.nodeName.toLowerCase()])&&"get"in hooks&&void 0!==(ret=hooks.get(elem,"value"))?ret:"string"==typeof(ret=elem.value)?ret.replace(rreturn,""):null==ret?"":ret:void 0}}),jQuery.extend({valHooks:{select:{get:function(elem){for(var value,option,options=elem.options,index=elem.selectedIndex,one="select-one"===elem.type||index<0,values=one?null:[],max=one?index+1:options.length,i=index<0?max:one?index:0;i<max;i++)if(((option=options[i]).selected||i===index)&&(support.optDisabled?!option.disabled:null===option.getAttribute("disabled"))&&(!option.parentNode.disabled||!jQuery.nodeName(option.parentNode,"optgroup"))){if(value=jQuery(option).val(),one)return value;values.push(value)}return values},set:function(elem,value){for(var optionSet,option,options=elem.options,values=jQuery.makeArray(value),i=options.length;i--;)((option=options[i]).selected=jQuery.inArray(jQuery(option).val(),values)>=0)&&(optionSet=!0);return optionSet||(elem.selectedIndex=-1),values}}}}),jQuery.each(["radio","checkbox"],(function(){jQuery.valHooks[this]={set:function(elem,value){if(jQuery.isArray(value))return elem.checked=jQuery.inArray(jQuery(elem).val(),value)>=0}},support.checkOn||(jQuery.valHooks[this].get=function(elem){return null===elem.getAttribute("value")?"on":elem.value})})),jQuery.each("blur focus focusin focusout load resize scroll unload click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup error contextmenu".split(" "),(function(i,name){jQuery.fn[name]=function(data,fn){return arguments.length>0?this.on(name,null,data,fn):this.trigger(name)}})),jQuery.fn.extend({hover:function(fnOver,fnOut){return this.mouseenter(fnOver).mouseleave(fnOut||fnOver)},bind:function(types,data,fn){return this.on(types,null,data,fn)},unbind:function(types,fn){return this.off(types,null,fn)},delegate:function(selector,types,data,fn){return this.on(types,selector,data,fn)},undelegate:function(selector,types,fn){return 1===arguments.length?this.off(selector,"**"):this.off(types,selector||"**",fn)}});var nonce=jQuery.now(),rquery=/\?/;jQuery.parseJSON=function(data){return JSON.parse(data+"")},jQuery.parseXML=function(data){var xml;if(!data||"string"!=typeof data)return null;try{xml=(new DOMParser).parseFromString(data,"text/xml")}catch(e){xml=void 0}return xml&&!xml.getElementsByTagName("parsererror").length||jQuery.error("Invalid XML: "+data),xml};var ajaxLocParts,ajaxLocation,rhash=/#.*$/,rts=/([?&])_=[^&]*/,rheaders=/^(.*?):[ \t]*([^\r\n]*)$/gm,rnoContent=/^(?:GET|HEAD)$/,rprotocol=/^\/\//,rurl=/^([\w.+-]+:)(?:\/\/(?:[^\/?#]*@|)([^\/?#:]*)(?::(\d+)|)|)/,prefilters={},transports={},allTypes="*/".concat("*");try{ajaxLocation=location.href}catch(e){(ajaxLocation=document.createElement("a")).href="",ajaxLocation=ajaxLocation.href}function addToPrefiltersOrTransports(structure){return function(dataTypeExpression,func){"string"!=typeof dataTypeExpression&&(func=dataTypeExpression,dataTypeExpression="*");var dataType,i=0,dataTypes=dataTypeExpression.toLowerCase().match(rnotwhite)||[];if(jQuery.isFunction(func))for(;dataType=dataTypes[i++];)"+"===dataType[0]?(dataType=dataType.slice(1)||"*",(structure[dataType]=structure[dataType]||[]).unshift(func)):(structure[dataType]=structure[dataType]||[]).push(func)}}function inspectPrefiltersOrTransports(structure,options,originalOptions,jqXHR){var inspected={},seekingTransport=structure===transports;function inspect(dataType){var selected;return inspected[dataType]=!0,jQuery.each(structure[dataType]||[],(function(_,prefilterOrFactory){var dataTypeOrTransport=prefilterOrFactory(options,originalOptions,jqXHR);return"string"!=typeof dataTypeOrTransport||seekingTransport||inspected[dataTypeOrTransport]?seekingTransport?!(selected=dataTypeOrTransport):void 0:(options.dataTypes.unshift(dataTypeOrTransport),inspect(dataTypeOrTransport),!1)})),selected}return inspect(options.dataTypes[0])||!inspected["*"]&&inspect("*")}function ajaxExtend(target,src){var key,deep,flatOptions=jQuery.ajaxSettings.flatOptions||{};for(key in src)void 0!==src[key]&&((flatOptions[key]?target:deep||(deep={}))[key]=src[key]);return deep&&jQuery.extend(!0,target,deep),target}ajaxLocParts=rurl.exec(ajaxLocation.toLowerCase())||[],jQuery.extend({active:0,lastModified:{},etag:{},ajaxSettings:{url:ajaxLocation,type:"GET",isLocal:/^(?:about|app|app-storage|.+-extension|file|res|widget):$/.test(ajaxLocParts[1]),global:!0,processData:!0,async:!0,contentType:"application/x-www-form-urlencoded; charset=UTF-8",accepts:{"*":allTypes,text:"text/plain",html:"text/html",xml:"application/xml, text/xml",json:"application/json, text/javascript"},contents:{xml:/xml/,html:/html/,json:/json/},responseFields:{xml:"responseXML",text:"responseText",json:"responseJSON"},converters:{"* text":String,"text html":!0,"text json":jQuery.parseJSON,"text xml":jQuery.parseXML},flatOptions:{url:!0,context:!0}},ajaxSetup:function(target,settings){return settings?ajaxExtend(ajaxExtend(target,jQuery.ajaxSettings),settings):ajaxExtend(jQuery.ajaxSettings,target)},ajaxPrefilter:addToPrefiltersOrTransports(prefilters),ajaxTransport:addToPrefiltersOrTransports(transports),ajax:function(url,options){"object"==typeof url&&(options=url,url=void 0),options=options||{};var transport,cacheURL,responseHeadersString,responseHeaders,timeoutTimer,parts,fireGlobals,i,s=jQuery.ajaxSetup({},options),callbackContext=s.context||s,globalEventContext=s.context&&(callbackContext.nodeType||callbackContext.jquery)?jQuery(callbackContext):jQuery.event,deferred=jQuery.Deferred(),completeDeferred=jQuery.Callbacks("once memory"),statusCode=s.statusCode||{},requestHeaders={},requestHeadersNames={},state=0,strAbort="canceled",jqXHR={readyState:0,getResponseHeader:function(key){var match;if(2===state){if(!responseHeaders)for(responseHeaders={};match=rheaders.exec(responseHeadersString);)responseHeaders[match[1].toLowerCase()]=match[2];match=responseHeaders[key.toLowerCase()]}return null==match?null:match},getAllResponseHeaders:function(){return 2===state?responseHeadersString:null},setRequestHeader:function(name,value){var lname=name.toLowerCase();return state||(name=requestHeadersNames[lname]=requestHeadersNames[lname]||name,requestHeaders[name]=value),this},overrideMimeType:function(type){return state||(s.mimeType=type),this},statusCode:function(map){var code;if(map)if(state<2)for(code in map)statusCode[code]=[statusCode[code],map[code]];else jqXHR.always(map[jqXHR.status]);return this},abort:function(statusText){var finalText=statusText||strAbort;return transport&&transport.abort(finalText),done(0,finalText),this}};if(deferred.promise(jqXHR).complete=completeDeferred.add,jqXHR.success=jqXHR.done,jqXHR.error=jqXHR.fail,s.url=((url||s.url||ajaxLocation)+"").replace(rhash,"").replace(rprotocol,ajaxLocParts[1]+"//"),s.type=options.method||options.type||s.method||s.type,s.dataTypes=jQuery.trim(s.dataType||"*").toLowerCase().match(rnotwhite)||[""],null==s.crossDomain&&(parts=rurl.exec(s.url.toLowerCase()),s.crossDomain=!(!parts||parts[1]===ajaxLocParts[1]&&parts[2]===ajaxLocParts[2]&&(parts[3]||("http:"===parts[1]?"80":"443"))===(ajaxLocParts[3]||("http:"===ajaxLocParts[1]?"80":"443")))),s.data&&s.processData&&"string"!=typeof s.data&&(s.data=jQuery.param(s.data,s.traditional)),inspectPrefiltersOrTransports(prefilters,s,options,jqXHR),2===state)return jqXHR;for(i in(fireGlobals=s.global)&&0==jQuery.active++&&jQuery.event.trigger("ajaxStart"),s.type=s.type.toUpperCase(),s.hasContent=!rnoContent.test(s.type),cacheURL=s.url,s.hasContent||(s.data&&(cacheURL=s.url+=(rquery.test(cacheURL)?"&":"?")+s.data,delete s.data),!1===s.cache&&(s.url=rts.test(cacheURL)?cacheURL.replace(rts,"$1_="+nonce++):cacheURL+(rquery.test(cacheURL)?"&":"?")+"_="+nonce++)),s.ifModified&&(jQuery.lastModified[cacheURL]&&jqXHR.setRequestHeader("If-Modified-Since",jQuery.lastModified[cacheURL]),jQuery.etag[cacheURL]&&jqXHR.setRequestHeader("If-None-Match",jQuery.etag[cacheURL])),(s.data&&s.hasContent&&!1!==s.contentType||options.contentType)&&jqXHR.setRequestHeader("Content-Type",s.contentType),jqXHR.setRequestHeader("Accept",s.dataTypes[0]&&s.accepts[s.dataTypes[0]]?s.accepts[s.dataTypes[0]]+("*"!==s.dataTypes[0]?", "+allTypes+"; q=0.01":""):s.accepts["*"]),s.headers)jqXHR.setRequestHeader(i,s.headers[i]);if(s.beforeSend&&(!1===s.beforeSend.call(callbackContext,jqXHR,s)||2===state))return jqXHR.abort();for(i in strAbort="abort",{success:1,error:1,complete:1})jqXHR[i](s[i]);if(transport=inspectPrefiltersOrTransports(transports,s,options,jqXHR)){jqXHR.readyState=1,fireGlobals&&globalEventContext.trigger("ajaxSend",[jqXHR,s]),s.async&&s.timeout>0&&(timeoutTimer=setTimeout((function(){jqXHR.abort("timeout")}),s.timeout));try{state=1,transport.send(requestHeaders,done)}catch(e){if(!(state<2))throw e;done(-1,e)}}else done(-1,"No Transport");function done(status,nativeStatusText,responses,headers){var isSuccess,success,error,response,modified,statusText=nativeStatusText;2!==state&&(state=2,timeoutTimer&&clearTimeout(timeoutTimer),transport=void 0,responseHeadersString=headers||"",jqXHR.readyState=status>0?4:0,isSuccess=status>=200&&status<300||304===status,responses&&(response=function(s,jqXHR,responses){for(var ct,type,finalDataType,firstDataType,contents=s.contents,dataTypes=s.dataTypes;"*"===dataTypes[0];)dataTypes.shift(),void 0===ct&&(ct=s.mimeType||jqXHR.getResponseHeader("Content-Type"));if(ct)for(type in contents)if(contents[type]&&contents[type].test(ct)){dataTypes.unshift(type);break}if(dataTypes[0]in responses)finalDataType=dataTypes[0];else{for(type in responses){if(!dataTypes[0]||s.converters[type+" "+dataTypes[0]]){finalDataType=type;break}firstDataType||(firstDataType=type)}finalDataType=finalDataType||firstDataType}if(finalDataType)return finalDataType!==dataTypes[0]&&dataTypes.unshift(finalDataType),responses[finalDataType]}(s,jqXHR,responses)),response=function(s,response,jqXHR,isSuccess){var conv2,current,conv,tmp,prev,converters={},dataTypes=s.dataTypes.slice();if(dataTypes[1])for(conv in s.converters)converters[conv.toLowerCase()]=s.converters[conv];for(current=dataTypes.shift();current;)if(s.responseFields[current]&&(jqXHR[s.responseFields[current]]=response),!prev&&isSuccess&&s.dataFilter&&(response=s.dataFilter(response,s.dataType)),prev=current,current=dataTypes.shift())if("*"===current)current=prev;else if("*"!==prev&&prev!==current){if(!(conv=converters[prev+" "+current]||converters["* "+current]))for(conv2 in converters)if((tmp=conv2.split(" "))[1]===current&&(conv=converters[prev+" "+tmp[0]]||converters["* "+tmp[0]])){!0===conv?conv=converters[conv2]:!0!==converters[conv2]&&(current=tmp[0],dataTypes.unshift(tmp[1]));break}if(!0!==conv)if(conv&&s.throws)response=conv(response);else try{response=conv(response)}catch(e){return{state:"parsererror",error:conv?e:"No conversion from "+prev+" to "+current}}}return{state:"success",data:response}}(s,response,jqXHR,isSuccess),isSuccess?(s.ifModified&&((modified=jqXHR.getResponseHeader("Last-Modified"))&&(jQuery.lastModified[cacheURL]=modified),(modified=jqXHR.getResponseHeader("etag"))&&(jQuery.etag[cacheURL]=modified)),204===status||"HEAD"===s.type?statusText="nocontent":304===status?statusText="notmodified":(statusText=response.state,success=response.data,isSuccess=!(error=response.error))):(error=statusText,!status&&statusText||(statusText="error",status<0&&(status=0))),jqXHR.status=status,jqXHR.statusText=(nativeStatusText||statusText)+"",isSuccess?deferred.resolveWith(callbackContext,[success,statusText,jqXHR]):deferred.rejectWith(callbackContext,[jqXHR,statusText,error]),jqXHR.statusCode(statusCode),statusCode=void 0,fireGlobals&&globalEventContext.trigger(isSuccess?"ajaxSuccess":"ajaxError",[jqXHR,s,isSuccess?success:error]),completeDeferred.fireWith(callbackContext,[jqXHR,statusText]),fireGlobals&&(globalEventContext.trigger("ajaxComplete",[jqXHR,s]),--jQuery.active||jQuery.event.trigger("ajaxStop")))}return jqXHR},getJSON:function(url,data,callback){return jQuery.get(url,data,callback,"json")},getScript:function(url,callback){return jQuery.get(url,void 0,callback,"script")}}),jQuery.each(["get","post"],(function(i,method){jQuery[method]=function(url,data,callback,type){return jQuery.isFunction(data)&&(type=type||callback,callback=data,data=void 0),jQuery.ajax({url:url,type:method,dataType:type,data:data,success:callback})}})),jQuery.each(["ajaxStart","ajaxStop","ajaxComplete","ajaxError","ajaxSuccess","ajaxSend"],(function(i,type){jQuery.fn[type]=function(fn){return this.on(type,fn)}})),jQuery._evalUrl=function(url){return jQuery.ajax({url:url,type:"GET",dataType:"script",async:!1,global:!1,throws:!0})},jQuery.fn.extend({wrapAll:function(html){var wrap;return jQuery.isFunction(html)?this.each((function(i){jQuery(this).wrapAll(html.call(this,i))})):(this[0]&&(wrap=jQuery(html,this[0].ownerDocument).eq(0).clone(!0),this[0].parentNode&&wrap.insertBefore(this[0]),wrap.map((function(){for(var elem=this;elem.firstElementChild;)elem=elem.firstElementChild;return elem})).append(this)),this)},wrapInner:function(html){return jQuery.isFunction(html)?this.each((function(i){jQuery(this).wrapInner(html.call(this,i))})):this.each((function(){var self=jQuery(this),contents=self.contents();contents.length?contents.wrapAll(html):self.append(html)}))},wrap:function(html){var isFunction=jQuery.isFunction(html);return this.each((function(i){jQuery(this).wrapAll(isFunction?html.call(this,i):html)}))},unwrap:function(){return this.parent().each((function(){jQuery.nodeName(this,"body")||jQuery(this).replaceWith(this.childNodes)})).end()}}),jQuery.expr.filters.hidden=function(elem){return elem.offsetWidth<=0&&elem.offsetHeight<=0},jQuery.expr.filters.visible=function(elem){return!jQuery.expr.filters.hidden(elem)};var r20=/%20/g,rbracket=/\[\]$/,rCRLF=/\r?\n/g,rsubmitterTypes=/^(?:submit|button|image|reset|file)$/i,rsubmittable=/^(?:input|select|textarea|keygen)/i;function buildParams(prefix,obj,traditional,add){var name;if(jQuery.isArray(obj))jQuery.each(obj,(function(i,v){traditional||rbracket.test(prefix)?add(prefix,v):buildParams(prefix+"["+("object"==typeof v?i:"")+"]",v,traditional,add)}));else if(traditional||"object"!==jQuery.type(obj))add(prefix,obj);else for(name in obj)buildParams(prefix+"["+name+"]",obj[name],traditional,add)}jQuery.param=function(a,traditional){var prefix,s=[],add=function(key,value){value=jQuery.isFunction(value)?value():null==value?"":value,s[s.length]=encodeURIComponent(key)+"="+encodeURIComponent(value)};if(void 0===traditional&&(traditional=jQuery.ajaxSettings&&jQuery.ajaxSettings.traditional),jQuery.isArray(a)||a.jquery&&!jQuery.isPlainObject(a))jQuery.each(a,(function(){add(this.name,this.value)}));else for(prefix in a)buildParams(prefix,a[prefix],traditional,add);return s.join("&").replace(r20,"+")},jQuery.fn.extend({serialize:function(){return jQuery.param(this.serializeArray())},serializeArray:function(){return this.map((function(){var elements=jQuery.prop(this,"elements");return elements?jQuery.makeArray(elements):this})).filter((function(){var type=this.type;return this.name&&!jQuery(this).is(":disabled")&&rsubmittable.test(this.nodeName)&&!rsubmitterTypes.test(type)&&(this.checked||!rcheckableType.test(type))})).map((function(i,elem){var val=jQuery(this).val();return null==val?null:jQuery.isArray(val)?jQuery.map(val,(function(val){return{name:elem.name,value:val.replace(rCRLF,"\r\n")}})):{name:elem.name,value:val.replace(rCRLF,"\r\n")}})).get()}}),jQuery.ajaxSettings.xhr=function(){try{return new XMLHttpRequest}catch(e){}};var xhrId=0,xhrCallbacks={},xhrSuccessStatus={0:200,1223:204},xhrSupported=jQuery.ajaxSettings.xhr();window.ActiveXObject&&jQuery(window).on("unload",(function(){for(var key in xhrCallbacks)xhrCallbacks[key]()})),support.cors=!!xhrSupported&&"withCredentials"in xhrSupported,support.ajax=xhrSupported=!!xhrSupported,jQuery.ajaxTransport((function(options){var callback;if(support.cors||xhrSupported&&!options.crossDomain)return{send:function(headers,complete){var i,xhr=options.xhr(),id=++xhrId;if(xhr.open(options.type,options.url,options.async,options.username,options.password),options.xhrFields)for(i in options.xhrFields)xhr[i]=options.xhrFields[i];for(i in options.mimeType&&xhr.overrideMimeType&&xhr.overrideMimeType(options.mimeType),options.crossDomain||headers["X-Requested-With"]||(headers["X-Requested-With"]="XMLHttpRequest"),headers)xhr.setRequestHeader(i,headers[i]);callback=function(type){return function(){callback&&(delete xhrCallbacks[id],callback=xhr.onload=xhr.onerror=null,"abort"===type?xhr.abort():"error"===type?complete(xhr.status,xhr.statusText):complete(xhrSuccessStatus[xhr.status]||xhr.status,xhr.statusText,"string"==typeof xhr.responseText?{text:xhr.responseText}:void 0,xhr.getAllResponseHeaders()))}},xhr.onload=callback(),xhr.onerror=callback("error"),callback=xhrCallbacks[id]=callback("abort"),xhr.send(options.hasContent&&options.data||null)},abort:function(){callback&&callback()}}})),jQuery.ajaxSetup({accepts:{script:"text/javascript, application/javascript, application/ecmascript, application/x-ecmascript"},contents:{script:/(?:java|ecma)script/},converters:{"text script":function(text){return jQuery.globalEval(text),text}}}),jQuery.ajaxPrefilter("script",(function(s){void 0===s.cache&&(s.cache=!1),s.crossDomain&&(s.type="GET")})),jQuery.ajaxTransport("script",(function(s){var script,callback;if(s.crossDomain)return{send:function(_,complete){script=jQuery("<script>").prop({async:!0,charset:s.scriptCharset,src:s.url}).on("load error",callback=function(evt){script.remove(),callback=null,evt&&complete("error"===evt.type?404:200,evt.type)}),document.head.appendChild(script[0])},abort:function(){callback&&callback()}}}));var oldCallbacks=[],rjsonp=/(=)\?(?=&|$)|\?\?/;jQuery.ajaxSetup({jsonp:"callback",jsonpCallback:function(){var callback=oldCallbacks.pop()||jQuery.expando+"_"+nonce++;return this[callback]=!0,callback}}),jQuery.ajaxPrefilter("json jsonp",(function(s,originalSettings,jqXHR){var callbackName,overwritten,responseContainer,jsonProp=!1!==s.jsonp&&(rjsonp.test(s.url)?"url":"string"==typeof s.data&&!(s.contentType||"").indexOf("application/x-www-form-urlencoded")&&rjsonp.test(s.data)&&"data");if(jsonProp||"jsonp"===s.dataTypes[0])return callbackName=s.jsonpCallback=jQuery.isFunction(s.jsonpCallback)?s.jsonpCallback():s.jsonpCallback,jsonProp?s[jsonProp]=s[jsonProp].replace(rjsonp,"$1"+callbackName):!1!==s.jsonp&&(s.url+=(rquery.test(s.url)?"&":"?")+s.jsonp+"="+callbackName),s.converters["script json"]=function(){return responseContainer||jQuery.error(callbackName+" was not called"),responseContainer[0]},s.dataTypes[0]="json",overwritten=window[callbackName],window[callbackName]=function(){responseContainer=arguments},jqXHR.always((function(){window[callbackName]=overwritten,s[callbackName]&&(s.jsonpCallback=originalSettings.jsonpCallback,oldCallbacks.push(callbackName)),responseContainer&&jQuery.isFunction(overwritten)&&overwritten(responseContainer[0]),responseContainer=overwritten=void 0})),"script"})),jQuery.parseHTML=function(data,context,keepScripts){if(!data||"string"!=typeof data)return null;"boolean"==typeof context&&(keepScripts=context,context=!1),context=context||document;var parsed=rsingleTag.exec(data),scripts=!keepScripts&&[];return parsed?[context.createElement(parsed[1])]:(parsed=jQuery.buildFragment([data],context,scripts),scripts&&scripts.length&&jQuery(scripts).remove(),jQuery.merge([],parsed.childNodes))};var _load=jQuery.fn.load;jQuery.fn.load=function(url,params,callback){if("string"!=typeof url&&_load)return _load.apply(this,arguments);var selector,type,response,self=this,off=url.indexOf(" ");return off>=0&&(selector=url.slice(off),url=url.slice(0,off)),jQuery.isFunction(params)?(callback=params,params=void 0):params&&"object"==typeof params&&(type="POST"),self.length>0&&jQuery.ajax({url:url,type:type,dataType:"html",data:params}).done((function(responseText){response=arguments,self.html(selector?jQuery("<div>").append(jQuery.parseHTML(responseText)).find(selector):responseText)})).complete(callback&&function(jqXHR,status){self.each(callback,response||[jqXHR.responseText,status,jqXHR])}),this},jQuery.expr.filters.animated=function(elem){return jQuery.grep(jQuery.timers,(function(fn){return elem===fn.elem})).length};var docElem=window.document.documentElement;function getWindow(elem){return jQuery.isWindow(elem)?elem:9===elem.nodeType&&elem.defaultView}jQuery.offset={setOffset:function(elem,options,i){var curPosition,curLeft,curCSSTop,curTop,curOffset,curCSSLeft,position=jQuery.css(elem,"position"),curElem=jQuery(elem),props={};"static"===position&&(elem.style.position="relative"),curOffset=curElem.offset(),curCSSTop=jQuery.css(elem,"top"),curCSSLeft=jQuery.css(elem,"left"),("absolute"===position||"fixed"===position)&&(curCSSTop+curCSSLeft).indexOf("auto")>-1?(curTop=(curPosition=curElem.position()).top,curLeft=curPosition.left):(curTop=parseFloat(curCSSTop)||0,curLeft=parseFloat(curCSSLeft)||0),jQuery.isFunction(options)&&(options=options.call(elem,i,curOffset)),null!=options.top&&(props.top=options.top-curOffset.top+curTop),null!=options.left&&(props.left=options.left-curOffset.left+curLeft),"using"in options?options.using.call(elem,props):curElem.css(props)}},jQuery.fn.extend({offset:function(options){if(arguments.length)return void 0===options?this:this.each((function(i){jQuery.offset.setOffset(this,options,i)}));var docElem,win,elem=this[0],box={top:0,left:0},doc=elem&&elem.ownerDocument;return doc?(docElem=doc.documentElement,jQuery.contains(docElem,elem)?(void 0!==elem.getBoundingClientRect&&(box=elem.getBoundingClientRect()),win=getWindow(doc),{top:box.top+win.pageYOffset-docElem.clientTop,left:box.left+win.pageXOffset-docElem.clientLeft}):box):void 0},position:function(){if(this[0]){var offsetParent,offset,elem=this[0],parentOffset={top:0,left:0};return"fixed"===jQuery.css(elem,"position")?offset=elem.getBoundingClientRect():(offsetParent=this.offsetParent(),offset=this.offset(),jQuery.nodeName(offsetParent[0],"html")||(parentOffset=offsetParent.offset()),parentOffset.top+=jQuery.css(offsetParent[0],"borderTopWidth",!0),parentOffset.left+=jQuery.css(offsetParent[0],"borderLeftWidth",!0)),{top:offset.top-parentOffset.top-jQuery.css(elem,"marginTop",!0),left:offset.left-parentOffset.left-jQuery.css(elem,"marginLeft",!0)}}},offsetParent:function(){return this.map((function(){for(var offsetParent=this.offsetParent||docElem;offsetParent&&!jQuery.nodeName(offsetParent,"html")&&"static"===jQuery.css(offsetParent,"position");)offsetParent=offsetParent.offsetParent;return offsetParent||docElem}))}}),jQuery.each({scrollLeft:"pageXOffset",scrollTop:"pageYOffset"},(function(method,prop){var top="pageYOffset"===prop;jQuery.fn[method]=function(val){return access(this,(function(elem,method,val){var win=getWindow(elem);if(void 0===val)return win?win[prop]:elem[method];win?win.scrollTo(top?window.pageXOffset:val,top?val:window.pageYOffset):elem[method]=val}),method,val,arguments.length,null)}})),jQuery.each(["top","left"],(function(i,prop){jQuery.cssHooks[prop]=addGetHookIf(support.pixelPosition,(function(elem,computed){if(computed)return computed=curCSS(elem,prop),rnumnonpx.test(computed)?jQuery(elem).position()[prop]+"px":computed}))})),jQuery.each({Height:"height",Width:"width"},(function(name,type){jQuery.each({padding:"inner"+name,content:type,"":"outer"+name},(function(defaultExtra,funcName){jQuery.fn[funcName]=function(margin,value){var chainable=arguments.length&&(defaultExtra||"boolean"!=typeof margin),extra=defaultExtra||(!0===margin||!0===value?"margin":"border");return access(this,(function(elem,type,value){var doc;return jQuery.isWindow(elem)?elem.document.documentElement["client"+name]:9===elem.nodeType?(doc=elem.documentElement,Math.max(elem.body["scroll"+name],doc["scroll"+name],elem.body["offset"+name],doc["offset"+name],doc["client"+name])):void 0===value?jQuery.css(elem,type,extra):jQuery.style(elem,type,value,extra)}),type,chainable?margin:void 0,chainable,null)}}))})),jQuery.fn.size=function(){return this.length},jQuery.fn.andSelf=jQuery.fn.addBack,void 0===(__WEBPACK_AMD_DEFINE_RESULT__=function(){return jQuery}.apply(exports,[]))||(module.exports=__WEBPACK_AMD_DEFINE_RESULT__);var _jQuery=window.jQuery,_$=window.$;return jQuery.noConflict=function(deep){return window.$===jQuery&&(window.$=_$),deep&&window.jQuery===jQuery&&(window.jQuery=_jQuery),jQuery},void 0===noGlobal&&(window.jQuery=window.$=jQuery),jQuery},"object"==typeof module.exports?module.exports=global.document?factory(global,!0):function(w){if(!w.document)throw new Error("jQuery requires a window with a document");return factory(w)}:factory(global)},"contrib/strftime":function(module,exports){Number.prototype.pad=function(n,p){var s=""+this;for(p=p||"0";s.length<n;)s=p+s;return s},Date.prototype.months=["January","February","March","April","May","June","July","August","September","October","November","December"],Date.prototype.weekdays=["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],Date.prototype.dpm=[31,28,31,30,31,30,31,31,30,31,30,31],Date.prototype.strftime_f={A:function(d){return d.weekdays[d.getDay()]},a:function(d){return d.weekdays[d.getDay()].substring(0,3)},B:function(d){return d.months[d.getMonth()]},b:function(d){return d.months[d.getMonth()].substring(0,3)},C:function(d){return Math.floor(d.getFullYear()/100)},c:function(d){return d.toString()},D:function(d){return d.strftime_f.m(d)+"/"+d.strftime_f.d(d)+"/"+d.strftime_f.y(d)},d:function(d){return d.getDate().pad(2,"0")},e:function(d){return d.getDate()},F:function(d){return d.strftime_f.Y(d)+"-"+d.strftime_f.m(d)+"-"+d.strftime_f.d(d)},H:function(d){return d.getHours().pad(2,"0")},I:function(d){return(d.getHours()%12||12).pad(2)},j:function(d){var t=d.getDate(),m=d.getMonth()-1;if(m>1){var y=d.getYear();(y%100==0&&y%400==0||y%4==0)&&++t}for(;m>-1;)t+=d.dpm[m--];return t.pad(3,"0")},k:function(d){return d.getHours().pad(2," ")},l:function(d){return d.getHours()%12||12},M:function(d){return d.getMinutes().pad(2,"0")},m:function(d){return(d.getMonth()+1).pad(2,"0")},n:function(d){return"\n"},p:function(d){return d.getHours()>11?"PM":"AM"},Q:function(d){return 0==d.getMilliseconds()?"000":d.getMilliseconds().pad(3,"0")},R:function(d){return d.strftime_f.H(d)+":"+d.strftime_f.M(d)},r:function(d){return d.strftime_f.I(d)+":"+d.strftime_f.M(d)+":"+d.strftime_f.S(d)+" "+d.strftime_f.p(d)},S:function(d){return d.getSeconds().pad(2,"0")},s:function(d){return Math.floor(d.getTime()/1e3)},T:function(d){return d.strftime_f.H(d)+":"+d.strftime_f.M(d)+":"+d.strftime_f.S(d)},t:function(d){return"\t"},u:function(d){return d.getDay()||7},v:function(d){return d.strftime_f.e(d)+"-"+d.strftime_f.b(d)+"-"+d.strftime_f.Y(d)},w:function(d){return d.getDay()},X:function(d){return d.toTimeString()},x:function(d){return d.toDateString()},Y:function(d){return d.getFullYear()},y:function(d){return(d.getYear()%100).pad(2)},z:function(d){return""},Z:function(d){return""},"%":function(d){return"%"}},Date.prototype.strftime_f["+"]=Date.prototype.strftime_f.c,Date.prototype.strftime_f.h=Date.prototype.strftime_f.b,Date.prototype.strftime=function(fmt){var rv;if(rv=this[fmt])return rv;for(var r=[],n=0;n<fmt.length;){var c=fmt.charAt(n);"%"==c?(c=fmt.charAt(++n),r.push(this.strftime_f[c]?this.strftime_f[c](this):c)):r.push(c),++n}return this[fmt]=r.join("")}},"contrib/underscore":function(module,exports,__webpack_require__){var __WEBPACK_AMD_DEFINE_RESULT__;(function(){var root=this,previousUnderscore=root._,breaker={},ArrayProto=Array.prototype,ObjProto=Object.prototype,FuncProto=Function.prototype,push=ArrayProto.push,slice=ArrayProto.slice,concat=ArrayProto.concat,toString=ObjProto.toString,hasOwnProperty=ObjProto.hasOwnProperty,nativeForEach=ArrayProto.forEach,nativeMap=ArrayProto.map,nativeReduce=ArrayProto.reduce,nativeReduceRight=ArrayProto.reduceRight,nativeFilter=ArrayProto.filter,nativeEvery=ArrayProto.every,nativeSome=ArrayProto.some,nativeIndexOf=ArrayProto.indexOf,nativeLastIndexOf=ArrayProto.lastIndexOf,nativeIsArray=Array.isArray,nativeKeys=Object.keys,nativeBind=FuncProto.bind,_=function(obj){return obj instanceof _?obj:this instanceof _?void(this._wrapped=obj):new _(obj)};module.exports&&(exports=module.exports=_),exports._=_,_.VERSION="1.6.0";var each=_.each=_.forEach=function(obj,iterator,context){if(null==obj)return obj;if(nativeForEach&&obj.forEach===nativeForEach)obj.forEach(iterator,context);else if(obj.length===+obj.length){for(var i=0,length=obj.length;i<length;i++)if(iterator.call(context,obj[i],i,obj)===breaker)return}else{var keys=_.keys(obj);for(i=0,length=keys.length;i<length;i++)if(iterator.call(context,obj[keys[i]],keys[i],obj)===breaker)return}return obj};_.map=_.collect=function(obj,iterator,context){var results=[];return null==obj?results:nativeMap&&obj.map===nativeMap?obj.map(iterator,context):(each(obj,(function(value,index,list){results.push(iterator.call(context,value,index,list))})),results)};var reduceError="Reduce of empty array with no initial value";_.reduce=_.foldl=_.inject=function(obj,iterator,memo,context){var initial=arguments.length>2;if(null==obj&&(obj=[]),nativeReduce&&obj.reduce===nativeReduce)return context&&(iterator=_.bind(iterator,context)),initial?obj.reduce(iterator,memo):obj.reduce(iterator);if(each(obj,(function(value,index,list){initial?memo=iterator.call(context,memo,value,index,list):(memo=value,initial=!0)})),!initial)throw new TypeError(reduceError);return memo},_.reduceRight=_.foldr=function(obj,iterator,memo,context){var initial=arguments.length>2;if(null==obj&&(obj=[]),nativeReduceRight&&obj.reduceRight===nativeReduceRight)return context&&(iterator=_.bind(iterator,context)),initial?obj.reduceRight(iterator,memo):obj.reduceRight(iterator);var length=obj.length;if(length!==+length){var keys=_.keys(obj);length=keys.length}if(each(obj,(function(value,index,list){index=keys?keys[--length]:--length,initial?memo=iterator.call(context,memo,obj[index],index,list):(memo=obj[index],initial=!0)})),!initial)throw new TypeError(reduceError);return memo},_.find=_.detect=function(obj,predicate,context){var result;return any(obj,(function(value,index,list){if(predicate.call(context,value,index,list))return result=value,!0})),result},_.filter=_.select=function(obj,predicate,context){var results=[];return null==obj?results:nativeFilter&&obj.filter===nativeFilter?obj.filter(predicate,context):(each(obj,(function(value,index,list){predicate.call(context,value,index,list)&&results.push(value)})),results)},_.reject=function(obj,predicate,context){return _.filter(obj,(function(value,index,list){return!predicate.call(context,value,index,list)}),context)},_.every=_.all=function(obj,predicate,context){predicate||(predicate=_.identity);var result=!0;return null==obj?result:nativeEvery&&obj.every===nativeEvery?obj.every(predicate,context):(each(obj,(function(value,index,list){if(!(result=result&&predicate.call(context,value,index,list)))return breaker})),!!result)};var any=_.some=_.any=function(obj,predicate,context){predicate||(predicate=_.identity);var result=!1;return null==obj?result:nativeSome&&obj.some===nativeSome?obj.some(predicate,context):(each(obj,(function(value,index,list){if(result||(result=predicate.call(context,value,index,list)))return breaker})),!!result)};_.contains=_.include=function(obj,target){return null!=obj&&(nativeIndexOf&&obj.indexOf===nativeIndexOf?-1!=obj.indexOf(target):any(obj,(function(value){return value===target})))},_.invoke=function(obj,method){var args=slice.call(arguments,2),isFunc=_.isFunction(method);return _.map(obj,(function(value){return(isFunc?method:value[method]).apply(value,args)}))},_.pluck=function(obj,key){return _.map(obj,_.property(key))},_.where=function(obj,attrs){return _.filter(obj,_.matches(attrs))},_.findWhere=function(obj,attrs){return _.find(obj,_.matches(attrs))},_.max=function(obj,iterator,context){if(!iterator&&_.isArray(obj)&&obj[0]===+obj[0]&&obj.length<65535)return Math.max.apply(Math,obj);var result=-1/0,lastComputed=-1/0;return each(obj,(function(value,index,list){var computed=iterator?iterator.call(context,value,index,list):value;computed>lastComputed&&(result=value,lastComputed=computed)})),result},_.min=function(obj,iterator,context){if(!iterator&&_.isArray(obj)&&obj[0]===+obj[0]&&obj.length<65535)return Math.min.apply(Math,obj);var result=1/0,lastComputed=1/0;return each(obj,(function(value,index,list){var computed=iterator?iterator.call(context,value,index,list):value;computed<lastComputed&&(result=value,lastComputed=computed)})),result},_.shuffle=function(obj){var rand,index=0,shuffled=[];return each(obj,(function(value){rand=_.random(index++),shuffled[index-1]=shuffled[rand],shuffled[rand]=value})),shuffled},_.sample=function(obj,n,guard){return null==n||guard?(obj.length!==+obj.length&&(obj=_.values(obj)),obj[_.random(obj.length-1)]):_.shuffle(obj).slice(0,Math.max(0,n))};var lookupIterator=function(value){return null==value?_.identity:_.isFunction(value)?value:_.property(value)};_.sortBy=function(obj,iterator,context){return iterator=lookupIterator(iterator),_.pluck(_.map(obj,(function(value,index,list){return{value:value,index:index,criteria:iterator.call(context,value,index,list)}})).sort((function(left,right){var a=left.criteria,b=right.criteria;if(a!==b){if(a>b||void 0===a)return 1;if(a<b||void 0===b)return-1}return left.index-right.index})),"value")};var group=function(behavior){return function(obj,iterator,context){var result={};return iterator=lookupIterator(iterator),each(obj,(function(value,index){var key=iterator.call(context,value,index,obj);behavior(result,key,value)})),result}};_.groupBy=group((function(result,key,value){_.has(result,key)?result[key].push(value):result[key]=[value]})),_.indexBy=group((function(result,key,value){result[key]=value})),_.countBy=group((function(result,key){_.has(result,key)?result[key]++:result[key]=1})),_.sortedIndex=function(array,obj,iterator,context){for(var value=(iterator=lookupIterator(iterator)).call(context,obj),low=0,high=array.length;low<high;){var mid=low+high>>>1;iterator.call(context,array[mid])<value?low=mid+1:high=mid}return low},_.toArray=function(obj){return obj?_.isArray(obj)?slice.call(obj):obj.length===+obj.length?_.map(obj,_.identity):_.values(obj):[]},_.size=function(obj){return null==obj?0:obj.length===+obj.length?obj.length:_.keys(obj).length},_.first=_.head=_.take=function(array,n,guard){if(null!=array)return null==n||guard?array[0]:n<0?[]:slice.call(array,0,n)},_.initial=function(array,n,guard){return slice.call(array,0,array.length-(null==n||guard?1:n))},_.last=function(array,n,guard){if(null!=array)return null==n||guard?array[array.length-1]:slice.call(array,Math.max(array.length-n,0))},_.rest=_.tail=_.drop=function(array,n,guard){return slice.call(array,null==n||guard?1:n)},_.compact=function(array){return _.filter(array,_.identity)};var flatten=function(input,shallow,output){return shallow&&_.every(input,_.isArray)?concat.apply(output,input):(each(input,(function(value){_.isArray(value)||_.isArguments(value)?shallow?push.apply(output,value):flatten(value,shallow,output):output.push(value)})),output)};_.flatten=function(array,shallow){return flatten(array,shallow,[])},_.without=function(array){return _.difference(array,slice.call(arguments,1))},_.partition=function(array,predicate,context){predicate=lookupIterator(predicate);var pass=[],fail=[];return each(array,(function(elem){(predicate.call(context,elem)?pass:fail).push(elem)})),[pass,fail]},_.uniq=_.unique=function(array,isSorted,iterator,context){_.isFunction(isSorted)&&(context=iterator,iterator=isSorted,isSorted=!1);var initial=iterator?_.map(array,iterator,context):array,results=[],seen=[];return each(initial,(function(value,index){(isSorted?index&&seen[seen.length-1]===value:_.contains(seen,value))||(seen.push(value),results.push(array[index]))})),results},_.union=function(){return _.uniq(_.flatten(arguments,!0))},_.intersection=function(array){var rest=slice.call(arguments,1);return _.filter(_.uniq(array),(function(item){return _.every(rest,(function(other){return _.contains(other,item)}))}))},_.difference=function(array){var rest=concat.apply(ArrayProto,slice.call(arguments,1));return _.filter(array,(function(value){return!_.contains(rest,value)}))},_.zip=function(){for(var length=_.max(_.pluck(arguments,"length").concat(0)),results=new Array(length),i=0;i<length;i++)results[i]=_.pluck(arguments,""+i);return results},_.object=function(list,values){if(null==list)return{};for(var result={},i=0,length=list.length;i<length;i++)values?result[list[i]]=values[i]:result[list[i][0]]=list[i][1];return result},_.indexOf=function(array,item,isSorted){if(null==array)return-1;var i=0,length=array.length;if(isSorted){if("number"!=typeof isSorted)return array[i=_.sortedIndex(array,item)]===item?i:-1;i=isSorted<0?Math.max(0,length+isSorted):isSorted}if(nativeIndexOf&&array.indexOf===nativeIndexOf)return array.indexOf(item,isSorted);for(;i<length;i++)if(array[i]===item)return i;return-1},_.lastIndexOf=function(array,item,from){if(null==array)return-1;var hasIndex=null!=from;if(nativeLastIndexOf&&array.lastIndexOf===nativeLastIndexOf)return hasIndex?array.lastIndexOf(item,from):array.lastIndexOf(item);for(var i=hasIndex?from:array.length;i--;)if(array[i]===item)return i;return-1},_.range=function(start,stop,step){arguments.length<=1&&(stop=start||0,start=0),step=arguments[2]||1;for(var length=Math.max(Math.ceil((stop-start)/step),0),idx=0,range=new Array(length);idx<length;)range[idx++]=start,start+=step;return range};var ctor=function(){};_.bind=function(func,context){var args,bound;if(nativeBind&&func.bind===nativeBind)return nativeBind.apply(func,slice.call(arguments,1));if(!_.isFunction(func))throw new TypeError;return args=slice.call(arguments,2),bound=function(){if(!(this instanceof bound))return func.apply(context,args.concat(slice.call(arguments)));ctor.prototype=func.prototype;var self=new ctor;ctor.prototype=null;var result=func.apply(self,args.concat(slice.call(arguments)));return Object(result)===result?result:self}},_.partial=function(func){var boundArgs=slice.call(arguments,1);return function(){for(var position=0,args=boundArgs.slice(),i=0,length=args.length;i<length;i++)args[i]===_&&(args[i]=arguments[position++]);for(;position<arguments.length;)args.push(arguments[position++]);return func.apply(this,args)}},_.bindAll=function(obj){var funcs=slice.call(arguments,1);if(0===funcs.length)throw new Error("bindAll must be passed function names");return each(funcs,(function(f){obj[f]=_.bind(obj[f],obj)})),obj},_.memoize=function(func,hasher){var memo={};return hasher||(hasher=_.identity),function(){var key=hasher.apply(this,arguments);return _.has(memo,key)?memo[key]:memo[key]=func.apply(this,arguments)}},_.delay=function(func,wait){var args=slice.call(arguments,2);return setTimeout((function(){return func.apply(null,args)}),wait)},_.defer=function(func){return _.delay.apply(_,[func,1].concat(slice.call(arguments,1)))},_.throttle=function(func,wait,options){var context,args,result,timeout=null,previous=0;options||(options={});var later=function(){previous=!1===options.leading?0:_.now(),timeout=null,result=func.apply(context,args),context=args=null};return function(){var now=_.now();previous||!1!==options.leading||(previous=now);var remaining=wait-(now-previous);return context=this,args=arguments,remaining<=0?(clearTimeout(timeout),timeout=null,previous=now,result=func.apply(context,args),context=args=null):timeout||!1===options.trailing||(timeout=setTimeout(later,remaining)),result}},_.debounce=function(func,wait,immediate){var timeout,args,context,timestamp,result,later=function(){var last=_.now()-timestamp;last<wait?timeout=setTimeout(later,wait-last):(timeout=null,immediate||(result=func.apply(context,args),context=args=null))};return function(){context=this,args=arguments,timestamp=_.now();var callNow=immediate&&!timeout;return timeout||(timeout=setTimeout(later,wait)),callNow&&(result=func.apply(context,args),context=args=null),result}},_.once=function(func){var memo,ran=!1;return function(){return ran||(ran=!0,memo=func.apply(this,arguments),func=null),memo}},_.wrap=function(func,wrapper){return _.partial(wrapper,func)},_.compose=function(){var funcs=arguments;return function(){for(var args=arguments,i=funcs.length-1;i>=0;i--)args=[funcs[i].apply(this,args)];return args[0]}},_.after=function(times,func){return function(){if(--times<1)return func.apply(this,arguments)}},_.keys=function(obj){if(!_.isObject(obj))return[];if(nativeKeys)return nativeKeys(obj);var keys=[];for(var key in obj)_.has(obj,key)&&keys.push(key);return keys},_.values=function(obj){for(var keys=_.keys(obj),length=keys.length,values=new Array(length),i=0;i<length;i++)values[i]=obj[keys[i]];return values},_.pairs=function(obj){for(var keys=_.keys(obj),length=keys.length,pairs=new Array(length),i=0;i<length;i++)pairs[i]=[keys[i],obj[keys[i]]];return pairs},_.invert=function(obj){for(var result={},keys=_.keys(obj),i=0,length=keys.length;i<length;i++)result[obj[keys[i]]]=keys[i];return result},_.functions=_.methods=function(obj){var names=[];for(var key in obj)_.isFunction(obj[key])&&names.push(key);return names.sort()},_.extend=function(obj){return each(slice.call(arguments,1),(function(source){if(source)for(var prop in source)obj[prop]=source[prop]})),obj},_.pick=function(obj){var copy={},keys=concat.apply(ArrayProto,slice.call(arguments,1));return each(keys,(function(key){key in obj&&(copy[key]=obj[key])})),copy},_.omit=function(obj){var copy={},keys=concat.apply(ArrayProto,slice.call(arguments,1));for(var key in obj)_.contains(keys,key)||(copy[key]=obj[key]);return copy},_.defaults=function(obj){return each(slice.call(arguments,1),(function(source){if(source)for(var prop in source)void 0===obj[prop]&&(obj[prop]=source[prop])})),obj},_.clone=function(obj){return _.isObject(obj)?_.isArray(obj)?obj.slice():_.extend({},obj):obj},_.tap=function(obj,interceptor){return interceptor(obj),obj};var eq=function(a,b,aStack,bStack){if(a===b)return 0!==a||1/a==1/b;if(null==a||null==b)return a===b;a instanceof _&&(a=a._wrapped),b instanceof _&&(b=b._wrapped);var className=toString.call(a);if(className!=toString.call(b))return!1;switch(className){case"[object String]":return a==String(b);case"[object Number]":return a!=+a?b!=+b:0==a?1/a==1/b:a==+b;case"[object Date]":case"[object Boolean]":return+a==+b;case"[object RegExp]":return a.source==b.source&&a.global==b.global&&a.multiline==b.multiline&&a.ignoreCase==b.ignoreCase}if("object"!=typeof a||"object"!=typeof b)return!1;for(var length=aStack.length;length--;)if(aStack[length]==a)return bStack[length]==b;var aCtor=a.constructor,bCtor=b.constructor;if(aCtor!==bCtor&&!(_.isFunction(aCtor)&&aCtor instanceof aCtor&&_.isFunction(bCtor)&&bCtor instanceof bCtor)&&"constructor"in a&&"constructor"in b)return!1;aStack.push(a),bStack.push(b);var size=0,result=!0;if("[object Array]"==className){if(result=(size=a.length)==b.length)for(;size--&&(result=eq(a[size],b[size],aStack,bStack)););}else{for(var key in a)if(_.has(a,key)&&(size++,!(result=_.has(b,key)&&eq(a[key],b[key],aStack,bStack))))break;if(result){for(key in b)if(_.has(b,key)&&!size--)break;result=!size}}return aStack.pop(),bStack.pop(),result};_.isEqual=function(a,b){return eq(a,b,[],[])},_.isEmpty=function(obj){if(null==obj)return!0;if(_.isArray(obj)||_.isString(obj))return 0===obj.length;for(var key in obj)if(_.has(obj,key))return!1;return!0},_.isElement=function(obj){return!(!obj||1!==obj.nodeType)},_.isArray=nativeIsArray||function(obj){return"[object Array]"==toString.call(obj)},_.isObject=function(obj){return obj===Object(obj)},each(["Arguments","Function","String","Number","Date","RegExp"],(function(name){_["is"+name]=function(obj){return toString.call(obj)=="[object "+name+"]"}})),_.isArguments(arguments)||(_.isArguments=function(obj){return!(!obj||!_.has(obj,"callee"))}),_.isFunction=function(obj){return"function"==typeof obj},_.isFinite=function(obj){return isFinite(obj)&&!isNaN(parseFloat(obj))},_.isNaN=function(obj){return _.isNumber(obj)&&obj!=+obj},_.isBoolean=function(obj){return!0===obj||!1===obj||"[object Boolean]"==toString.call(obj)},_.isNull=function(obj){return null===obj},_.isUndefined=function(obj){return void 0===obj},_.has=function(obj,key){return hasOwnProperty.call(obj,key)},_.noConflict=function(){return root._=previousUnderscore,this},_.identity=function(value){return value},_.constant=function(value){return function(){return value}},_.property=function(key){return function(obj){return obj[key]}},_.matches=function(attrs){return function(obj){if(obj===attrs)return!0;for(var key in attrs)if(attrs[key]!==obj[key])return!1;return!0}},_.times=function(n,iterator,context){for(var accum=Array(Math.max(0,n)),i=0;i<n;i++)accum[i]=iterator.call(context,i);return accum},_.random=function(min,max){return null==max&&(max=min,min=0),min+Math.floor(Math.random()*(max-min+1))},_.now=Date.now||function(){return(new Date).getTime()};var entityMap={escape:{"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;"}};entityMap.unescape=_.invert(entityMap.escape);var entityRegexes={escape:new RegExp("["+_.keys(entityMap.escape).join("")+"]","g"),unescape:new RegExp("("+_.keys(entityMap.unescape).join("|")+")","g")};_.each(["escape","unescape"],(function(method){_[method]=function(string){return null==string?"":(""+string).replace(entityRegexes[method],(function(match){return entityMap[method][match]}))}})),_.result=function(object,property){if(null!=object){var value=object[property];return _.isFunction(value)?value.call(object):value}},_.mixin=function(obj){each(_.functions(obj),(function(name){var func=_[name]=obj[name];_.prototype[name]=function(){var args=[this._wrapped];return push.apply(args,arguments),result.call(this,func.apply(_,args))}}))};var idCounter=0;_.uniqueId=function(prefix){var id=++idCounter+"";return prefix?prefix+id:id},_.templateSettings={evaluate:/<%([\s\S]+?)%>/g,interpolate:/<%=([\s\S]+?)%>/g,escape:/<%-([\s\S]+?)%>/g};var noMatch=/(.)^/,escapes={"'":"'","\\":"\\","\r":"r","\n":"n","\t":"t","\u2028":"u2028","\u2029":"u2029"},escaper=/\\|'|\r|\n|\t|\u2028|\u2029/g;_.template=function(text,data,settings){var render;settings=_.defaults({},settings,_.templateSettings);var matcher=new RegExp([(settings.escape||noMatch).source,(settings.interpolate||noMatch).source,(settings.evaluate||noMatch).source].join("|")+"|$","g"),index=0,source="__p+='";text.replace(matcher,(function(match,escape,interpolate,evaluate,offset){return source+=text.slice(index,offset).replace(escaper,(function(match){return"\\"+escapes[match]})),escape&&(source+="'+\n((__t=("+escape+"))==null?'':_.escape(__t))+\n'"),interpolate&&(source+="'+\n((__t=("+interpolate+"))==null?'':__t)+\n'"),evaluate&&(source+="';\n"+evaluate+"\n__p+='"),index=offset+match.length,match})),source+="';\n",settings.variable||(source="with(obj||{}){\n"+source+"}\n"),source="var __t,__p='',__j=Array.prototype.join,print=function(){__p+=__j.call(arguments,'');};\n"+source+"return __p;\n";try{render=new Function(settings.variable||"obj","_",source)}catch(e){throw e.source=source,e}if(data)return render(data,_);var template=function(data){return render.call(this,data,_)};return template.source="function("+(settings.variable||"obj")+"){\n"+source+"}",template},_.chain=function(obj){return _(obj).chain()};var result=function(obj){return this._chain?_(obj).chain():obj};_.mixin(_),each(["pop","push","reverse","shift","sort","splice","unshift"],(function(name){var method=ArrayProto[name];_.prototype[name]=function(){var obj=this._wrapped;return method.apply(obj,arguments),"shift"!=name&&"splice"!=name||0!==obj.length||delete obj[0],result.call(this,obj)}})),each(["concat","join","slice"],(function(name){var method=ArrayProto[name];_.prototype[name]=function(){return result.call(this,method.apply(this._wrapped,arguments))}})),_.extend(_.prototype,{chain:function(){return this._chain=!0,this},value:function(){return this._wrapped}}),void 0===(__WEBPACK_AMD_DEFINE_RESULT__=function(){return _}.apply(exports,[]))||(module.exports=__WEBPACK_AMD_DEFINE_RESULT__)}).call(this)},"require/underscore":function(module,exports,__webpack_require__){var __WEBPACK_AMD_DEFINE_ARRAY__,__WEBPACK_AMD_DEFINE_RESULT__;__WEBPACK_AMD_DEFINE_ARRAY__=[__webpack_require__("contrib/underscore"),__webpack_require__("stubs/i18n")],void 0===(__WEBPACK_AMD_DEFINE_RESULT__=function(_,i18n){return _.mixin({t:function(string){return i18n._(string)}}),_.noConflict()}.apply(exports,__WEBPACK_AMD_DEFINE_ARRAY__))||(module.exports=__WEBPACK_AMD_DEFINE_RESULT__)},"shim/jquery":function(module,exports,__webpack_require__){var __WEBPACK_AMD_DEFINE_ARRAY__,__WEBPACK_AMD_DEFINE_RESULT__;__WEBPACK_AMD_DEFINE_ARRAY__=[__webpack_require__("contrib/jquery-2.1.0")],void 0===(__WEBPACK_AMD_DEFINE_RESULT__=function($){return window.$||(window.$=$,window.jQuery=$),$}.apply(exports,__WEBPACK_AMD_DEFINE_ARRAY__))||(module.exports=__WEBPACK_AMD_DEFINE_RESULT__)},"shim/splunk":function(module,exports,__webpack_require__){var __WEBPACK_AMD_DEFINE_ARRAY__,__WEBPACK_AMD_DEFINE_RESULT__;__WEBPACK_AMD_DEFINE_ARRAY__=[__webpack_require__(1)],void 0===(__WEBPACK_AMD_DEFINE_RESULT__=function(){return window.Splunk}.apply(exports,__WEBPACK_AMD_DEFINE_ARRAY__))||(module.exports=__WEBPACK_AMD_DEFINE_RESULT__)},"shim/splunk.util":function(module,exports,__webpack_require__){var __WEBPACK_AMD_DEFINE_ARRAY__,__WEBPACK_AMD_DEFINE_RESULT__;__WEBPACK_AMD_DEFINE_ARRAY__=[__webpack_require__("shim/jquery"),__webpack_require__("shim/splunk"),__webpack_require__("util/sprintf"),__webpack_require__("stubs/splunk.config"),__webpack_require__(3)],void 0===(__WEBPACK_AMD_DEFINE_RESULT__=function($,Splunk,sprintf){return Splunk.util.sprintf=sprintf,Splunk.util}.apply(exports,__WEBPACK_AMD_DEFINE_ARRAY__))||(module.exports=__WEBPACK_AMD_DEFINE_RESULT__)},"stubs/i18n":function(module,exports,__webpack_require__){var __WEBPACK_AMD_DEFINE_ARRAY__,__WEBPACK_AMD_DEFINE_RESULT__;__WEBPACK_AMD_DEFINE_ARRAY__=[__webpack_require__("contrib/strftime"),__webpack_require__("shim/splunk.util")],void 0===(__WEBPACK_AMD_DEFINE_RESULT__=function(){window.locale_name()in{ko_KR:!0,zh_CN:!0,zh_TW:!0}&&(window._i18n_locale.date_formats.short={pattern:"yy/MM/dd",format:"%(yy)s/%(MM)s/%(dd)s"},window._i18n_locale.date_formats.medium={pattern:"yyyy/MM/dd",format:"%(yyyy)s/%(MM)s/%(dd)s"},window._i18n_locale.time_formats.short={pattern:"H:mm",format:"%(H)s:%(mm)s"},window._i18n_locale.time_formats.medium={pattern:"H:mm:ss",format:"%(H)s:%(mm)s:%(ss)s"});var asianLanguageDateReplacements=[[/^ccc MMM d$/,"M/d (ccc)"],[/^YYYY-MM/,"YYYY/MM"],[/MM-dd/,"MM/dd"]],FORMAT_DATE_REPLACEMENTS={ja_JP:asianLanguageDateReplacements,ko_KR:asianLanguageDateReplacements,zh_CN:asianLanguageDateReplacements,zh_TW:asianLanguageDateReplacements},DAY_FIRST_FORMATS=[["MMM d","d MMM"]],oldFormatDate=window.format_date;return window.format_date=function(date,format){format=format||"medium";var i,replacements,locale=window.locale_name();if(format&&"string"==typeof format&&window.locale_uses_day_before_month())for(replacements=DAY_FIRST_FORMATS,i=0;i<replacements.length;i++)format=format.replace(replacements[i][0],replacements[i][1]);if(format&&"string"==typeof format&&locale in FORMAT_DATE_REPLACEMENTS)for(replacements=FORMAT_DATE_REPLACEMENTS[locale],i=0;i<replacements.length;i++){var replacement=replacements[i];format=format.replace(replacement[0],replacement[1])}return oldFormatDate(date,format)},{_:window.gettext,ungettext:window.ungettext,format_decimal:window.format_decimal,format_number:window.format_number,format_percent:window.format_percent,format_scientific:window.format_scientific,format_date:window.format_date,format_datetime:window.format_datetime,format_time:window.format_time,format_datetime_microseconds:window.format_datetime_microseconds,format_time_microseconds:window.format_time_microseconds,locale_uses_day_before_month:window.locale_uses_day_before_month,format_datetime_range:window.format_datetime_range,locale_name:window.locale_name,DateTime:window.DateTime,moment_install:window.moment_install,numeral_install:window.numeral_install,jQuery_ui_datepicker_install:window.jQuery_ui_datepicker_install}}.apply(exports,__WEBPACK_AMD_DEFINE_ARRAY__))||(module.exports=__WEBPACK_AMD_DEFINE_RESULT__)},"stubs/splunk.config":function(module,exports,__webpack_require__){var __WEBPACK_AMD_DEFINE_RESULT__;void 0===(__WEBPACK_AMD_DEFINE_RESULT__=function(){return window.$C}.call(exports,__webpack_require__,exports,module))||(module.exports=__WEBPACK_AMD_DEFINE_RESULT__)},"util/sprintf":function(module,exports,__webpack_require__){var __WEBPACK_AMD_DEFINE_ARRAY__,__WEBPACK_AMD_DEFINE_RESULT__;__WEBPACK_AMD_DEFINE_ARRAY__=[__webpack_require__(2)],void 0===(__WEBPACK_AMD_DEFINE_RESULT__=function(sprintf){return sprintf}.apply(exports,__WEBPACK_AMD_DEFINE_ARRAY__))||(module.exports=__WEBPACK_AMD_DEFINE_RESULT__)}})}));