'use strict';

var fs = require('fs');
var path = require('path');

var camelToDashed = require('../lib/parsers').camelToDashed;

var property_files = fs.readdirSync(path.resolve(__dirname, '../lib/properties'));
var out_file = fs.createWriteStream(path.resolve(__dirname, '../lib/properties.js'), {encoding: 'utf-8'});

out_file.write('\'use strict\';\n\n// autogenerated\n\n');
out_file.write('/*\n *\n * http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSS2Properties\n */\n\n');
out_file.write('module.exports = function (prototype) {\n');

property_files.forEach(function (property) {
    var dashed;
    if (property.substr(-3) === '.js') {
        property = path.basename(property, '.js');
        dashed = camelToDashed(property);
        out_file.write('    Object.defineProperty(prototype, \'' + property + '\', {\n');
        out_file.write('        get: function () {\n');
        out_file.write('            var definition = require(\'./properties/' + property + '\').definition;\n');
        out_file.write('            Object.defineProperty(prototype, \'' + property + '\', definition);\n');
        out_file.write('            return this.' + property + ';\n');
        out_file.write('        },\n');
        out_file.write('        set: function (v) {\n');
        out_file.write('            var definition = require(\'./properties/' + property + '\').definition;\n');
        out_file.write('            Object.defineProperty(prototype, \'' + property + '\', definition);\n');
        out_file.write('            this.' + property + ' = v;\n');
        out_file.write('        },\n');
        out_file.write('        enumerable: true,\n');
        out_file.write('        configurable: true\n');
        out_file.write('    });\n');
        if (property !== dashed) {
            out_file.write('    Object.defineProperty(prototype, \'' + dashed + '\', {\n');
            out_file.write('        get: function () {\n');
            out_file.write('            var definition = require(\'./properties/' + property + '\').definition;\n');
            out_file.write('            Object.defineProperty(prototype, \'' + property + '\', definition);\n');
            out_file.write('            return this.' + property + ';\n');
            out_file.write('        },\n');
            out_file.write('        set: function (v) {\n');
            out_file.write('            var definition = require(\'./properties/' + property + '\').definition;\n');
            out_file.write('            Object.defineProperty(prototype, \'' + property + '\', definition);\n');
            out_file.write('            this.' + property + ' = v;\n');
            out_file.write('        },\n');
            out_file.write('        enumerable: true,\n');
            out_file.write('        configurable: true\n');
            out_file.write('    });\n');
        }
    }
});

out_file.write('};\n');
out_file.end(function (err) {
    if (err) {
        throw err;
    }
});
