slim-describe - describe an app and its dependencies
=====================================================

## SYNOPSIS

`slim` `describe` \[(`-h`|`--help`_)] \[(`-r`|`--repository=`)&lt;repository>] \[(`-o`|`--output=`)&lt;filename>] &lt;app-source>

## DESCRIPTION

Describes a Splunk app and its dependencies, assuming the `app.manifest` file is located at the root of the app
source directory.

## OPTIONS

&lt;app-source>
Location of the app source package or directory.

`-h`, `--help`  
Print help message and exit.

`-r` &lt;repository>, `--repository` &lt;repository>  
Look for dependent source packages in the directory at this location. (default: `${SLIM_REPOSITORY:=~/.slim/repository}`)

`-o` &lt;filename>, `--output=`&lt;filename>  
Print app description to the file at this location. (default: stdout)

## EXAMPLES

The following example demonstrates using the describe command to describe an app called "fictional."

```
$ slim --debug describe --repository ~/.slim/repository fictional
[info]
|-- SLIM fictional test app: A SLIM app for testing Splunk extension packaging, partitioning, and operations.
|  |-- by David Noble (dnoble@splunk.com) at Splunk, Inc.
|  |-- packaged as com.splunk.addons-fictional@1.0.0
[dependencies]
|-- Splunk Add-on for Microsoft Windows packaged as com.splunk.addon-microsoft_windows@4.7.5
|-- Splunk Add-on for *nix Operating Systems packaged as com.splunk.addon-star_nix@5.2.1
[input-groups]
|-- Microsoft Windows monitoring defines inputs [input_1, input_2, input_3] and requires no dependencies
|-- *nix monitoring defines inputs [input_4, input_5, input_6] and requires [Splunk Add-on for *nix Operating Systems]
[dependency-graph]
|-- com.splunk.addons:fictional@1.0.0
|   |-- com.splunk.addon:microsoft_windows@4.7.5 (accepting 4.7.5)
|      |-- com.splunk.addon:utilities@1.0.0 (accepting ~1.0.0)
|   |-- com.splunk.addon:star_nix@5.2.1 (accepting 5.2.1)
```
