slim - execute packaging toolkit command
====

## SYNOPSIS
    slim [-v] [-h] [--debug] [--quiet] {config,describe,generate-manifest,package,partition,validate,update-installation} ...

## DESCRIPTION
    Executes a Splunk packaging toolkit command.

## OPTIONS
    -v, --version         print version number and exit
    -h, --help            print help message and exit
    --debug               print debugging information
    --quiet               suppresses info and warnings, but not errors
 
## COMMANDS
    generate-manifest     generate a new or updated manifest for a Splunk app
    package               package the source of a Splunk app for distribution
    describe              describe a Splunk app and its dependencies
    validate              verify the contents of the manifest of a Splunk app
    partition             create a set of deployment packages from a Splunk app source package
    config                get and set user or system options
    update-installation   perform a sequence of update actions on the app installation graph for a Splunk system

    
# NAME
    slim generate-manifest

# SYNOPSIS
    slim [--debug] generate-manifest [-h] [-o <filename>] [--update] <app-source>

# DESCRIPTION
    Generates a new or updated manifest for a Splunk app.

# OPTIONS
    <app-source>          location of the app source directory
    -h, --help            print help message and exit
    --debug               print debugging information and exit
    -o <filename>, --output <filename>
                          destination of the app manifest (default: stdout)
    --update              amend the current app manifest based on configuration settings

# EXAMPLES
    The following example demonstrates using the generate command to generate a manifest for an app called "fictional."
    
    $ slim --debug generate-manifest --output app.manifest fictional
    generate-manifest: Parsing app configuration at 'fictional'...
    generate-manifest: Generating app manifest to 'app.manifest'...
    generate-manifest: Done! Please update [dependencies] and [inputGroups] sections as needed.
    
# NAME
    slim package

# SYNOPSIS
    slim [--debug] package [-h] [-r <repository>] [-u <level>] [-o <output-dir>] <app-source>

# DESCRIPTION
    Packages the source of a Splunk app for distribution. Assumes the app.manifest file is located at the root of the app source directory. The manifest file must exist for the package command to run. The source package filename is derived from the app id as follows:

    <info.id.group>-<info.id.name>-<info.id.version>.tar.gz

    The file is placed on the output directory, which defaults to the current directory.

    Since you're likely to link your app directories to $SPLUNK_HOME/etc/apps to debug locally, the following standard set of ignore files has been generated, and you have the option to specify your own list in a .slimignore file. The standard ignore list includes the following files:

    .DS_STORE
    Thumbs.db
    *.py[co]
    default/indexes.conf
    local/
    metadata/local.meta

# OPTIONS
    <app-source>          location of the app source directory
    -h, --help            print help message and exit
    --debug               print debugging information and exit
    -r <repository>, --repository <repository>
                          location of dependent source packages (default: ${SLIM_REPOSITORY:=~/.slim/repository})
    -u <level>, --unreferenced-input-groups <level>
                          report level of unreferenced input groups: info|warn|error (default: info)
    -o <output-dir>, --output-dir <output-dir>
                          destination of the app source package (default: current directory)

# EXAMPLES
    The following example demonstrates using the package command to package an app called "fictional."
    
    $ slim --debug package --unreferenced-input-groups=info --repository ~/.slim/repository fictional
    package: Packaging app "fictional" to "~/slim"...
    package: [INFO] fictional: unreferenced input groups: dependency com.splunk.addon:microsoft_windows:4.7.5:
        Active Directory Domain Services
        DHCP Server
        Windows Event Log
        Windows Host Monitor
        Windows Network Monitor
        Windows Performance Monitor
        Windows Print Monitor
        Windows Registry
        Windows Update Monitor
    package: Source package exported to "~/slim/com.splunk.addons-fictional-1.0.0.tar.gz"

# NAME
    slim describe

# SYNOPSIS
    slim [--debug] describe [-h] [-r <repository>] [-o <filename>] <app-source>

# DESCRIPTION
    Describes a Splunk app and its dependencies. Assumes the app.manifest file is located within the app source directory.

# OPTIONS
    <app-source>          location of the app source package or directory
    -h, --help            print help message and exit
    --debug               print debugging information and exit
    -r <repository>, --repository <repository>
                          location of dependent source packages (default: ${SLIM_REPOSITORY:=~/.slim/repository})
    -o <filename>, --output <filename>
                          destination of the describe output (default: stdout)

# EXAMPLES
    The following example demonstrates using the describe command to describe an app called "fictional."
    
    $ slim --debug describe --repository ~/.slim/repository fictional
    [info]
    |-- SLIM fictional test app: A SLIM app for testing Splunk extension packaging, partitioning, and operations.
    |  |-- by David Noble (dnoble@splunk.com) at Splunk, Inc.
    |  |-- packaged as com.splunk.addons-fictional@1.0.0
    [dependencies]
    |-- Splunk Add-on for Microsoft Windows packaged as com.splunk.addon-microsoft_windows@4.7.5
    |-- Splunk Add-on for *nix Operating Systems packaged as com.splunk.addon-star_nix@5.2.1
    [input-groups]
    |-- Microsoft Windows monitoring defines inputs [input_1, input_2, input_3] and requires no dependencies
    |-- *nix monitoring defines inputs [input_4, input_5, input_6] and requires [Splunk Add-on for *nix Operating Systems]
    [dependency-graph]
    |-- com.splunk.addons:fictional@1.0.0
    |   |-- com.splunk.addon:microsoft_windows@4.7.5 (accepting 4.7.5)
    |      |-- com.splunk.addon:utilities@1.0.0 (accepting ~1.0.0)
    |   |-- com.splunk.addon:star_nix@5.2.1 (accepting 5.2.1)

# NAME
    slim validate

# SYNOPSIS
    slim [--debug] validate [-h] [-r <repository>] [-u <level>] <app-source>

# DESCRIPTION
    Validates the app manifest and the app dependencies. Note that validating the app dependencies will require the manifest to be validated first. Assumes the app.manifest file is located within the app source directory.

# OPTIONS
    <app-source>          location of the app source package or directory
    -h, --help            print help message and exit
    --debug               print debugging information and exit
    -r <repository>, --repository <repository>
                          location of dependent source packages (default: ${SLIM_REPOSITORY:=~/.slim/repository})
    -u <level>, --unreferenced-input-groups <level>
                          report level of unreferenced input groups: info|warn|error (default: info)

# EXAMPLES
    The following example demonstrates using the validate command to validate an app called "fictional."
    
    $ slim --debug validate --repository ~/.slim/repository com.splunk.addons-fictional-1.0.0.tar.gz
    validate: Validating app at "com.splunk.addons-fictional-1.0.0.tar.gz"...
    validate: [ERROR] fictional: unreferenced forwarder groups: dependency com.splunk.addon:microsoft_windows:4.7.5:
        Active Directory Domain Services
        DHCP Server
        Windows Event Log
        Windows Host Monitor
        Windows Network Monitor
        Windows Performance Monitor
        Windows Print Monitor
        Windows Registry
        Windows Update Monitor

# NAME
    slim partition

# SYNOPSIS
    slim [--debug] partition [-h] [-r <repository>] [-i <filename>] [-o <output-dir>] [-d <specification> [<specification> ...]] [-f <forwarder-workloads>] [-c] [-p] <app-source>

# DESCRIPTION
    Partitions an app source package into a set of targeted deployment packages based on user-defined deployment configurations. The user-defined deployment configurations can contain three different types of Splunk workloads: indexer (named as "_indexers"), search head (named as "_search_heads") and forwarder (named as "_forwarders") workloads. User can specify any combinations of these three workloads in the configurations.

# OPTIONS
    <app-source>          location of an app source package
    -h, --help            print help message and exit
    --debug               print debugging information and exit
    -r <repository>, --repository <repository>
                          location of dependent source packages (default: ${SLIM_REPOSITORY:=~/.slim/repository})
    -i <filename>, --installation <filename>
                          location of the incoming installation graph (default: empty)
    -o <output-dir>, --output-dir <output-dir>
                          destination of the deployment packages (default: current directory)
    -d <specification> [<specification> ...], --deployment-packages <specification> [<specification> ...]
                          specify a set of logical deployment packages by name, workload, and input groups
    -f <forwarder-workloads>, --forwarder-workloads <forwarder-workloads>
                          map app input groups to a set of server classes (default: ["_search_heads", "_indexers", "_forwarders"])
    -t <os-name>, --target-os <os-name>
                          specify the target OS to be used when evaluating OS-specific dependencies defined in the manifest: *, _mac, _windows, _linux_x86, _linux_x86_64. By default, all OS-specific dependencies will be installed (*). This option is ignored when the --partition-only is used, since the installation graph is not updated. (default: ["*"])
    -c, --combine-search-head-indexer-workloads
                          combine search head and indexer workloads into a single deployment package
    -p, --partition-only  skip installation graph update

# EXAMPLES
    A deployment package specification is represented by a JSON object:

    {
      "name": "<package-name>",
      "workload": [("searchHead" | "indexer" | "forwarder")(,("searchHead" | "indexer" | "forwarder") ...)](,
      "inputGroups": ["<group-name>"(, "<group-name>" ...)])
    }

    A forwarder workload is represented by a JSON array of objects:

    [
      "<server-class-name>": ["<input-group-name>"(, "<input-group-name>" ...)],
      "<server-class-name>": ["<input-group-name>"(, "<input-group-name>" ...)] ...
    ]
    
    The following example CLI output demonstrates the usage of the partition command along with the --forwarder-workloads and --combine-search-head-and-indexer flags on an app called "fictional."
    
    $ slim partition --forwarder-workloads '{"Microsoft Windows monitoring":["server-class-1"], "*nix monitoring":["server-class-1", "server-class-2"]}' com.splunk.addons-fictional-1.0.0.tar.gz
    partition: [INFO] fictional manifest lists these undefined inputs in forwarder group "Microsoft Windows monitoring": "input_1", "input_2", "input_3"
    partition: [INFO] fictional manifest lists these undefined inputs in forwarder group "*nix monitoring": "input_4", "input_5", "input_6"
    partition: [INFO] Deployment packages created:
        /Users/splunkuser/SplunkSource/python-site/splunk/slim/com.splunk.addons-fictional-1.0.0-server-class-1.tar.gz
        /Users/splunkuser/SplunkSource/python-site/splunk/slim/com.splunk.addons-fictional-1.0.0-server-class-2.tar.gz
        /Users/splunkuser/SplunkSource/python-site/splunk/slim/com.splunk.addons-fictional-1.0.0-splunk-search-head.tar.gz
        /Users/splunkuser/SplunkSource/python-site/splunk/slim/com.splunk.addons-fictional-1.0.0-splunk-indexer.tar.gz
 
    $ slim partition --combine-search-head-and-indexer --forwarder-workloads '{"Microsoft Windows monitoring":["server-class-1"], "*nix monitoring":["server-class-1", "server-class-2"]}' com.splunk.addons-fictional-1.0.0.tar.gz
    partition: [INFO] fictional manifest lists these undefined inputs in forwarder group "Microsoft Windows monitoring": "input_1", "input_2", "input_3"
    partition: [INFO] fictional manifest lists these undefined inputs in forwarder group "*nix monitoring": "input_4", "input_5", "input_6"
    partition: Deployment packages created:
        /Users/splunkuser/SplunkSource/python-site/splunk/slim/com.splunk.addons-fictional-1.0.0-server-class-1.tar.gz
        /Users/splunkuser/SplunkSource/python-site/splunk/slim/com.splunk.addons-fictional-1.0.0-server-class-2.tar.gz
        /Users/splunkuser/SplunkSource/python-site/splunk/slim/com.splunk.addons-fictional-1.0.0-splunk-server.tar.gz 

# NAME
    slim config

# SYNOPSIS
    slim [--debug] config [-h] [-l [system|user]] [-g [<name> [<name> ...]]] [-s <name> <value> <name> <value>] [-u [<name> [<name> ...]]]

# DESCRIPTION
    Gets and sets user or system options.

# OPTIONS
    -h, --help            print help message and exit
    --debug               print debugging information and exit
    -l [system|user], --location [system|user]
                          when writing settings: write to the named configuration file (default: user); when reading settings: read only from the named configuration file rather than from system and user.
    -g [<name> [<name> ...]], --get [<name> [<name> ...]]
                          gets the values for all settings (using '*'), all settings in a section (using '<section>[.*]'), or the named settings, where the name of each setting is its section and option name separated by a dot ('<section>.<option>').
    -s <name> <value> <name> <value>, --set <name> <value> <name> <value>
                          sets the value for the named setting, where the name of the setting is its section and option name separated by a dot ('<section>.<option>').
    -u [<name> [<name> ...]], --unset [<name> [<name> ...]]
                          removes the named settings, where the name of each setting is its section and option name separated by a dot ('<section>.<option>').

# NAME
    slim update-installation

# SYNOPSIS
    slim [--debug] update-installation [-h] [-r <repository>] [-i <filename>] [-o <output-dir>] [-a <action> [<action> ...]] [--disable-automatic-resolution]

# DESCRIPTION
    Performs a sequence of update actions on the app installation graph for a Splunk system.

# OPTIONS
    -h, --help            print help message and exit
    --debug               print debugging information and exit
    -r <repository>, --repository <repository>
                          location of dependent source packages (default: ${SLIM_REPOSITORY:=~/.slim/repository})
    -i <filename>, --installation <filename>
                          location of the incoming installation graph (default: empty)
    -o <output-dir>, --output-dir <output-dir>
                          destination of the installation graph and deployment packages (default: current directory)
    -a <action> [<action> ...], --actions <action> [<action> ...]
                          list of actions to be applied to the given installation graph: add, remove, set, or update
    --disable-automatic-resolution
                          do not automatically resolve dependency conflicts by updating installed versions
    -t <os-name>, --target-os <os-name>
                          specify the target OS to be used when evaluating OS-specific dependencies defined in the manifest: *, _mac, _windows, _linux_x86, _linux_x86_64. By default, all OS-specific dependencies will be installed (*). This option is ignored when the --partition-only is used, since the installation graph is not updated. (default: ["*"])

# EXAMPLES
    Update actions are defined as a sequence of JSON objects:

    --actions '{
      "action": "add",
      "args": {
        "app_package": "<path>",
        "combine_search_head_indexer_workloads": <boolean>,
          "workloads": {
            "<input-group-name>": ["<server-class-name>"(, "<server-class-name>" ...)],
            "<input-group-name>": ["<server-class-name>"(, "<server-class-name>" ...)] ...
          }
        }
      }
    }' '{
      "action": "remove",
        "args": {
          "app_id": "<app_id>"
        }
      }
    }' '{
      "action": "set",
      "args": {
        "app_package": "<path>",
          "combine_search_head_indexer_workloads": <boolean>,
          "workloads": {
            "<input-group-name>": ["<server-class-name>"(, "<server-class-name>" ...)],
            "<input-group-name>": ["<server-class-name>"(, "<server-class-name>" ...)] ...
          }
        }
      }
    }' '{
      "action": "update"
      "args": {
        "app_package": "<path>"
      }
    }'
