slim partition - split an app source package into a set of targeted deployment packages
=======================================================================================

## SYNOPSIS

`slim` `partition` \[(`-h`|`--help`)] \[(`-i`|`--installation=`)&lt;filename>] \[(`-o`|`--output-dir=`)&lt;output-dir>]
\[(`-r`|`--repository=`)&lt;repository>] \[(`-c`|`combine-search-head-indexer-workloads`)]
\[(`-d`|`--deployment-packages=)`&lt;specification> \[&lt;specification>...]]
\[(`-f`|`--forwarder-workloads=`&lt;forwarder-workloads>]
\[(`-t`|`--target-os=`)&lt;os-name>]
\[(`-p`|`--partition-only`)] &lt;app-source>

## DESCRIPTION

Partitions an app source package into a set of targeted deployment packages based on user-defined deployment
specifications. A deployment specification can contain any combination of three different types of Splunk 
workloads: indexer (named as `"_indexers"`), search head (named as `"_search_heads"`) and forwarder (named as 
`"_forwarders"`).

## OPTIONS

&lt;app-source>          
Location of an app source package.

`-h`, `--help`  
Print help message and exit.

`-i` &lt;filename>, `--installation=`&lt;filename>  
Read installation graph from the file at this location (default: empty).

`-o` &lt;output-dir>, `--output-dir=`&lt;output-dir>  
Save targeted deployment packages to the directory at this location (default: current directory).

`-r` &lt;repository>, `--repository=`&lt;repository>  
Look for dependent source packages in the directory at this location (default: `${SLIM_REPOSITORY:=~/.slim/repository}`).

`-c`, `--combine-search-head-indexer-workloads` 
Combine search head and indexer workloads into a single deployment package.

`-d` &lt;specification> [&lt;specification> ...], `--deployment-packages=`&lt;specification> [&lt;specification> ...]  
Specify a set of deployment packages by name, workload, and—for forwarder workloads—input groups. A deployment 
specification is represented by a JSON object:

```
{
    "name": "<package-name>",
    "workload": [("searchHead" | "indexer" | "forwarder")(,("searchHead" | "indexer" | "forwarder") ...)](,
    "inputGroups": ["<group-name>"(, "<group-name>" ...)])
}
```

`-f` &lt;forwarder-workloads>, `--forwarder-workloads` &lt;forwarder-workloads>  
Map app input groups to a set of server classes (default: ["_search_heads", "_indexers", "_forwarders"]). A forwarder workload
is represented by an JSON array of objects:

```
[
    "<server-class-name>": ["<input-group-name>"(, "<input-group-name>" ...)],
    "<server-class-name>": ["<input-group-name>"(, "<input-group-name>" ...)] ...
]
```

`-t` &lt;os-name>, `--target-os` &lt;os-name>
Specify the target OS to be used when evaluating OS-specific dependencies defined in the manifest: *, _mac, _windows, _linux_x86, _linux_x86_64.
By default, all OS-specific dependencies will be installed (*). This option is ignored when the --partition-only is used, since the installation graph is not updated.


`-p`, `--partition-only`
Verify installation graph to ensure it is unchanged after partitioning. This is useful when you are partitioning an app for re-deployment.

## EXAMPLES

The following example demonstrates the usage of the partition command along with the `forwarder-workloads` and 
`combine-search-head-and-indexer` flags on an app called "fictional."

```    
$ slim partition --forwarder-workloads '{"Microsoft Windows monitoring":["server-class-1"], "*nix monitoring":["server-class-1", "server-class-2"]}' com.splunk.addons-fictional-1.0.0.tar.gz
partition: [INFO] fictional manifest lists these undefined inputs in forwarder group "Microsoft Windows monitoring": "input_1", "input_2", "input_3"
partition: [INFO] fictional manifest lists these undefined inputs in forwarder group "*nix monitoring": "input_4", "input_5", "input_6"
partition: [INFO] Deployment packages created:
    /Users/splunkuser/SplunkSource/python-site/splunk/slim/com.splunk.addons-fictional-1.0.0-server-class-1.tar.gz
    /Users/splunkuser/SplunkSource/python-site/splunk/slim/com.splunk.addons-fictional-1.0.0-server-class-2.tar.gz
    /Users/splunkuser/SplunkSource/python-site/splunk/slim/com.splunk.addons-fictional-1.0.0-splunk-search-head.tar.gz
    /Users/splunkuser/SplunkSource/python-site/splunk/slim/com.splunk.addons-fictional-1.0.0-splunk-indexer.tar.gz
```
