slim-package - make an app source package for distribution
===========================================================

## SYNOPSIS

`slim` `package` \[(`-h`|`--help`)] \[(`-r`|`--repository=`)&lt;repository>] \[(`-u`|`--unreferenced-input-groups=)`&lt;level>]
\[(`-o`|`--output-dir=`)&lt;output-dir>] &lt;app-source>

## DESCRIPTION

Makes a Splunk app source package for distribution. It asssumes the `app.manifest` file is located at the root of the
app source directory. The manifest file must exist for the package command to run. The source package filename is 
derived from the app id as follows:

&nbsp;&nbsp;&nbsp;&nbsp;*&lt;info.id.group>*`-`*&lt;info.id.name>*`-`*&lt;info.id.version>*`.tar.gz`

The file is placed on the `output` directory, which defaults to the current directory.

Since you're likely to link your app directories to `${SPLUNK_HOME}/etc/apps` to debug locally, the following standard 
set of ignore files has been generated, and you have the option to specify your own list in a `.slimignore` file at
the root of the app source directory. The standard ignore list includes these files:

```
.DS_STORE
Thumbs.db
*.py[co]
default/indexes.conf
local/
metadata/local.meta
```

## OPTIONS

&lt;app-source>  
Location of the app source directory.

`-h`, `--help`  
Print help message and exit.

`-o` &lt;output-dir>, `--output-dir=`&lt;output-dir>  
Save the app source package to the directory at this location. (default: current directory)

`-r` &lt;repository>, `--repository=`&lt;repository>  
Look for dependent source packages in the directory at this location. (default: `${SLIM_REPOSITORY:=~/.slim/repository}`)

`-u` &lt;level>, `--unreferenced-input-groups=`&lt;level>  
Report unreferenced input groups at `level`: `note` or `warn` or `error` (default: `note`)

## EXAMPLES

The following example demonstrates using the `package` command to package an app called "fictional."

```
$ slim --debug package --unreferenced-input-groups=note --repository ~/.slim/repository fictional
package: Packaging app "fictional" to "~/slim"...
package: [INFO] fictional: unreferenced input groups: dependency com.splunk.addon:microsoft_windows:4.7.5:
    Active Directory Domain Services
    DHCP Server
    Windows Event Log
    Windows Host Monitor
    Windows Network Monitor
    Windows Performance Monitor
    Windows Print Monitor
    Windows Registry
    Windows Update Monitor
package: Source package exported to "~/slim/com.splunk.addons-fictional-1.0.0.tar.gz"
```
